#include "mbed.h"
#include "BM1422AGMV.h"
#include "KX224.h"
//#include "wire.h"

DigitalOut myled(LED1);

//https://www.google.com/search?q=bm1422agmv+arduino&rlz=1C1SQJL_enTH863TH863&oq=BM1422&aqs=chrome.5.69i57j0i19j69i59l2j0i19l2j69i60l2.3962j0j7&sourceid=chrome&ie=UTF-8#imgrc=llWSwJWhYP3wyM

I2C i2c(I2C_SDA, I2C_SCL);         // setup i2c (SDA,SCL)  

BM1422AGMV bm1422(I2C_SDA, I2C_SCL);
KX224 accelerometer(I2C_SDA, I2C_SCL);

//BM1422AGMV bm1422(i2c,0x0E);
Serial pc(USBTX, USBRX);

int _px  = 6.3;//-44.5; //中点x
int _py  = -24.8;//-38.5; //中点y

/** 角度を求める **/
double getDirection(double x, double y){
  double dir  = 0;
  dir = atan((y - _py)/(x - _px));
  return dir;
}

int main() {
    //bm1422.initialize();
    pc.baud(115200);                              // baud rate: 9600
    pc.printf("test\n");
  float mag[3];
  float acc[3];
  int ret;

  double rd;
  int x = mag[0];
  int y = mag[1];
  int z = mag[2];
  
    //Initialize KX224-1053
    ret = accelerometer.initialize();
    if (ret != 0) {
        printf("\r\nKX224-1053  :   Failed initialization \n");
    }
        
    while(1) {
      accelerometer.get_val(&acc[0]);
             bm1422.get_val(mag);
      rd = getDirection(mag[0],mag[1]);
      x = mag[0];
      y = mag[1];
      z = mag[2];
      
      printf("%7.2f       %7.2f       %7.2f       %7.2f       %7.2f       %7.2f\r\n", mag[0], mag[1], mag[2],acc[0], acc[1], acc[2]);

  //磁北ではないときステッピングモーターを回転させる
  //ステッピングモーターの回転数に応じてrdに余裕を持たせています
  if(rd <= 0.3 && rd >= -0.3 && x > _px){
    //磁北の状態//Serial.println("North!");//https://deviceplus.jp/arduino/entry041/
  pc.printf("%f     %d      %d      %d      North!  \n",rd,x,y,z);
  myled = 1;

  }else{
  pc.printf("%f     %d      %d      %d       -      \n",rd,x,y,z);
  myled = 0;
  }
/*
  else if(rd > 0){
    moveStepper(2,-1);
  }
  else{
    moveStepper(2);
  }  
*/  
  
        //myled = 1;
        //wait(.1);
        //myled = 0;
        //wait(.1);
    }
}
