#include "mbed.h"
#include "SDFileSystem.h"

/************************Include the required Header files for the code *******************************/
#include "mbed.h"
#include "string.h"

/********************************** Function Prototypes declaration ***********************************/
int FUNC_CDMS_hex2int(int);                     // Need to convert the RTC time values to integers
void FUNC_CDMS_Gettime(void);                   // Function to get the time values from RTC registers 
void FUNC_CDMS_init_values(void);               // Function to initialize the registers in the RTC


/***************** Configure the SPI1 of the CDMS uc as the data bus for the RTC***********************/
SPI spi(PTE1,PTE3, PTE2);                       // mosi, miso, sclk
DigitalOut cs(PTE29);                           // PTE29 is used for chip select

char ch;
SDFileSystem sd(PTE1, PTE3, PTE2, PTE22, "sd"); // the pinout on the mbed Cool Components workshop board
Serial pc(USBTX, USBRX); // tx, rx
char time_stamp[15];

/***********************Initialization function of the RTC********************************************/ 
void FUNC_CDMS_init_values(void)
{
    cs=0;
    spi.format(8,3);                            // Set the data bit with to be of 8 bits, 
                                                // data tx mode is 3 
    spi.frequency(1000000);                     // Set Data rate to be 1 MHz
    
    cs = 0;                                     // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x80);                            // Send the address of the Seconds register 0x80
    spi.write(0x00);                            // Set seconds value to 0
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x81);                            // Send the address of the Minutes register 0x81
    spi.write(0x00);                            // Set minutes value to 0
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x82);                            // Send the address of the Hours register 0x82
    spi.write(0x00);                            // Set hours value to 0
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x83);                            // Send the address of the Day register 0x83
    spi.write(0x01);                            // Set the day to 01
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x84);                            // Send the address of the date register 0x84
    spi.write(0x01);                            // Set date of the month to 01
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x85);                            // Send the address of the Month register 0x80
    spi.write(0x01);                            // Set month to 01
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x86);                            // Send the address of the year register 0x80
    spi.write(0x00);                            // Set year to 00(2000)
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
}// End of INIT Function


/*********************************Function to read the RTC registers*********************************/   
void FUNC_CDMS_Gettime()
{

    spi.format(8,3);                            // Set the data bit with to be of 8 bits, 
                                                // data tx mode is 3 
    spi.frequency(1000000);                     // Set Data rate to be 1 MHz
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x00);                            // Sending address of seconds register
    int seconds = spi.write(0x00);              // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x01);                            // Sending address of Minutes register
    int minutes =spi.write(0x01);               // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x02);                            // Sending address of hours register
    int hours =spi.write(0x01);                 // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x03);                            // Sending address of day register
    int day =spi.write(0x01);                   // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x04);                            // Sending address of date register
    int date =spi.write(0x01);                  // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x05);                            // Sending address of month register
    int month =spi.write(0x01);                 // Read the value by sending dummy byte
    cs=1;                                       // Set chip select pin to be 1: DeActivate RTC chip
    
    cs=0;                                       // Set chip select pin to be 0: Activate RTC chip
    spi.write(0x06);                            // Sending address of year register
    int year =spi.write(0x01);                  // Read the value by sending dummy byte
    cs = 1;                                     // Set chip select pin to be 1: DeActivate RTC chip
    
    // RTC sends in BCD format.. SO we convert the values generated by RTC to integers
    year = FUNC_CDMS_hex2int(year);             
    month = FUNC_CDMS_hex2int(month);
    date = FUNC_CDMS_hex2int(date);
    day = FUNC_CDMS_hex2int(day);
    hours = FUNC_CDMS_hex2int(hours);
    minutes = FUNC_CDMS_hex2int(minutes);
    seconds = FUNC_CDMS_hex2int(seconds);
    
    // Print the obtained Time stamp
    //printf("The time is :%d %d %d %d %d %d %d \n\r",seconds,minutes,hours,day,date,month,year);
    sprintf(time_stamp,"%02d%02d%02d%02d%02d%02d",year,month,date,hours,minutes,seconds);
    printf(" \n\r Received HK data from BAE");
    printf("\n HK_data stored in %s.txt",time_stamp);
    //puts(time_stamp);
    //printf(".txt");
}//End of Read Function

/**************************Function to convert Hex values to Int values*****************************/
int FUNC_CDMS_hex2int(int a)
{
a=(a/16)*10+(a%16); //function to convert hex type to int type
return a;
}// End of convert function


/******************************************END OF RTC CODE ****************************************/

char count = 10;
void store_data()
{
    FUNC_CDMS_Gettime();
    
    char hk_data[25];
    count++;
    strcpy(hk_data,"hk_Data ");
    strcat(hk_data,"!@@#");
    hk_data[10] = count;
    //storedata(hk_data);
    mkdir("/sd/hk", 0777);
    char add[20];
    strcpy(add,"/sd/hk/");
    strcat(add,time_stamp);
    strcat(add,".txt");
    
    FILE *fp = fopen(add, "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    else
    {
       
    fprintf(fp, "%s ",hk_data);
    fclose(fp);
    printf("\n File stored in SD card\n");
    //printf("\n Reading from the file .... \n Data is %s\n",hk_data);
    
    }
}



//void create_file()
//{
    
    /*
    fprintf(fp, "Hello fun SD Card World!\n");
    fclose(fp); 
    
    fp = fopen("/sd/mydir/sdtest.txt", "r");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    //fprintf(fp, "Hello fun SD Card World!");
   // fprintf("The contents of %s file are :\n", "/sd/mydir/sdtest.txt");
    while( ( ch = fgetc(fp) ) != '\n' )
    {
      pc.printf("%c",ch);
      }
    //fprintf(fp);
    fclose(fp); 
 
    printf("Jai Mata Di..Goodbye World!\n");*/
//}
    
Ticker t;

int main() 
{
    printf("IITMSAT - CDMS\n");   
    
    FUNC_CDMS_init_values();  
    t.attach(&store_data, 20.0);
    while(1);
    
}
