#ifndef _VALVEDIGITAL_H_
#define _VALVEDIGITAL_H_

#include "mbed.h"
/**
 * Controlling an on/off valve
 */

class ValveDigital
{
public:

    /**
     * @param pin_d_out PinName of digital output
     */
    ValveDigital (PinName pin_d_out) :
        digital_out_(pin_d_out)
    {
    }

    /**
     * @return valve state
     */
    float getValve()
    {
        return digital_out_.read();
    }

    /**
     * @
     */
    void setValve(bool set)
    {
        digital_out_.write((int)set);
        return;
    }


private:
    DigitalOut digital_out_;
};

#endif