#ifndef _CONSTANTS_HARDWARE_H_
#define _CONSTANTS_HARDWARE_H_

#include "mbed.h"

#ifndef M_PI
#define M_PI 3.14159265359f
#endif

// SPI Communication AS5048 joint encoders
#define AS5048_MOSI         PTD6        // D11
#define AS5048_MISO         PTD7        // D12
#define AS5048_SCLK         PTD5        // D13
#define AS5048_CS           PTD4        // D10

// SPI Communication external SD CARD 
#define SD_MOSI             PTC6        // D7
#define SD_MISO             PTC7        
#define SD_SCK              PTC5        
#define SD_CS               PTC10       

// SPI Communication MAX5322 DAC
#define DAC_MOSI         PTD6        // D11
#define DAC_MISO         PTD7        // D12
#define DAC_SCLK         PTD5        // D13
#define DAC_CSA          D8        
#define DAC_CSB          D1         

// LCM101-100 kgf S-beam force sensor
#define LCM101              A1

// SPTE analog output pressure sensors (0-10bar for 0-5V output)
#define SPTE_0             A0
#define SPTE_1             A5

//Festo digital valve (one for inflate)
#define VALVE_PIN           D0

//Linear actuator
#define LINACT_DIR_PIN      D5
#define LINACT_PWM_PIN      D6

/**
 * Sensor settings and calibration data
 */
namespace sensors {
    extern const bool use5kN;
    
    // LCM101-100kgf force sensor
    extern const float kLcm101Offset;
    extern const float kLcm101Factor;
    
    // Gen5kN force sensor
    extern const float kGen5kNOffset;
    extern const float kGen5kNFactor;
    
    //SPTE pressure sensors (0-10bar for 0-5V output)
    extern const float kSPTE0Offset;
    extern const float kSPTE0Factor;
    extern const float kSPTE1Offset;
    extern const float kSPTE1Factor;
    
    // AS5048 abs angle sensor chain
    extern const int kNumJoints;

    extern const char *kJointNames[];
    extern const float kOffsetsDegrees[];
    extern const bool kDirections[];
}

namespace timing {
    extern const int LogDataHertz;                      //data log sample rate
    extern const int kTimeControlUs;                    // control loop
    extern const int LogDataHertz;                      // data logging
    extern const int kTimeLogDataUs;                    // data logging
    extern const int TimeControlHertz;                  // control loop sample rate
    extern const int kTimeSerialPrintUs;                // serial printing 
    extern const int minKeyInt;                   //key interval time out value
    
    extern const int kSerialBaudrate;
    
    extern const int PWMHertz;                          //Linear actuator frequency for pwm
}

namespace rigStructure {
    extern const bool invertedRig; //indicates if rig is inverted or not (for internal torque calculation)
}

#endif