#include "constants.h"

namespace sensors {
    const bool use5kN = false;
    
    // LCM101-100kgf force sensor
    // Equation from 7/6/2018 calibration used:
    // kLcm101Offset = 1.99
    // kLcm101Factor = 969.2
    // Equation from 8/3/2019 calibration used:
    // kLcm101Offset = 4.31
    // kLcm101Factor = 1001.1
    
    const float kLcm101Offset = -1.5;//-1.52;
    //This is currently the offset for the S610 sensor -5.41;
    //Offset for LCM101 sensor = -1.52
    const float kLcm101Factor = 970.55;//970.55;
    //This is currently the factor for the S610 sensor 977.35;
    //Factor for LCM101 sensor is 970.55
    
    // Gen5kN force sensor
    // Equation from 21/2/2019 calibration used:
    // kLcm101Offset = 21.2
    // kLcm101Factor = 5530
    
    const float kGen5kNOffset = 0;
    const float kGen5kNFactor = 5530;    
    
    // Pressure sensor slope and offset values for a gauge pressure reading in bar
    // Equation from 25/6/2018 calibration used:
    // kSPTE0Offset = -2.47
    // kSPTE0Factor = 12.5
    
    // Equation from 21/2/2019 calibration used
    // kSPTE0Offset = -2.33
    // kSPTE0Factor = 12.0
    
    const float kSPTE0Offset = -2.33;
    
    const float kSPTE0Factor = 12.0;
        
    const float kSPTE1Offset = -2.47;
    
    const float kSPTE1Factor = 12.5; //   
        
    // AS5048 abs angle sensor chain
    const int kNumJoints = 1;

    const char *kJointNames[]     = {"Knee"};//{"1","Knee","3","4"};
    const float kOffsetsDegrees[] = {250};//{180,180,180,180};
    const bool kDirections[] = {true};//{true,true,true,true};
}

namespace timing {
    const int TimeControlHertz = 1000;// control loop sample rate
    const int LogDataHertz = 249; //data log sample rate
    const int SerialPrintHertz = 2; //print rate of serial 
    const int kTimeControlUs            =   1000000/TimeControlHertz;   // 1000 Hz control loop
    const int kTimeLogDataUs            =  1000000/LogDataHertz;   //   200 Hz data logging
    const int kTimeSerialPrintUs        = 1000000/SerialPrintHertz;   //    2 Hz serial print
    const int minKeyInt                   = 1;                  //minimum key press interval in s
    const int kSerialBaudrate = 115200;
    
    const int PWMHertz = 10000;
}

namespace rigStructure {
    const bool invertedRig = false; //indicates if rig is inverted or not (for internal torque calculation)
}