#include "mbed.h"
#include "MQTTClient.h"
#include "MQTTFormat.h"
#include "MQTTWNCInterface.h"
#include "rtos.h"
#include "k64f.h"
#include "HTS221.h"
#include "MODSERIAL.h"

I2C i2c(PTC11, PTC10);         //SDA, SCL -- define the I2C pins being used
MODSERIAL pc(USBTX, USBRX);
MODSERIAL pump(PTC15, PTC14);//TX, RX to connect pump

#include "hardware.h"
/*
#define ORG_ID      "44a8w4" 
#define DEVICE_TYPE "IoT-Moog-1"
#define DEVICE_NAME "IoT-Moog-Device1"
#define USERNAME    "use-token-auth"                                    
#define PASSWORD    "ih*SKz2AyUSt+I*L0N"                                   
*/

#define ORG_ID      "hpy42p" 
#define DEVICE_TYPE "PumpTest"
#define DEVICE_NAME "SomethingOtherThanPumpTest"
#define USERNAME    "use-token-auth"                                    
#define PASSWORD    "SLD21utaPZP7TE8Vgk"    

#define URL    ORG_ID ".messaging.internetofthings.ibmcloud.com"
#define CLIENTSTR   "d:" ORG_ID ":" DEVICE_TYPE ":%s"

#define PORT        1883                           // MQTT broker port number
#define PUBLISH_TOPIC "iot-2/evt/status/fmt/json"              // MQTT topic
#define SUBSCRIBTOPIC "iot-2/cmd/+/fmt/+"
/// Largest msg possible is 111 bytes - header, 99 data bytes, CheckSum, LF/CR
#define PDMS_MAX_COMMAND_SIZE 111
Thread serial_thread;
volatile int key_reader =0;
volatile int old_Key =0;
char command_str[PDMS_MAX_COMMAND_SIZE];
unsigned char AIL_Enable=0;
Queue<uint32_t, 6> messageQ;

// LED color control function
void controlLED(color_t led_color) {
    switch(led_color) {
        case red :
            greenLED = blueLED = 1;          
            redLED = 0.7;
            break;
        case green :
            redLED = blueLED = 1;
            greenLED = 0.7;
            break;
        case blue :
            redLED = greenLED = 1;
            blueLED = 0.7;
            break;
        case off :
            redLED = greenLED = blueLED = 1;
            break;
    }
}
    
// Switch 2 interrupt handler
void sw2_ISR(void) {
    messageQ.put((uint32_t*)22);
}

// Switch3 interrupt handler
void sw3_ISR(void) {
    messageQ.put((uint32_t*)33);
}
 
// MQTT message arrived callback function
void messageArrived(MQTT::MessageData& md) {
    MQTT::Message &message = md.message;
    PRINTF("Receiving MQTT message:  %.*s\r\n", message.payloadlen, (char*)message.payload);
    
    if (message.payloadlen == 3) {
        if (strncmp((char*)message.payload, "red", 3) == 0)
            controlLED(red);
        
        else if(strncmp((char*)message.payload, "grn", 3) == 0)
            controlLED(green);
        
        else if(strncmp((char*)message.payload, "blu", 3) == 0)
            controlLED(blue);
        
        else if(strncmp((char*)message.payload, "off", 3) == 0)
            controlLED(off);
    }        
}

void alla_serial() 
{
  printf("Enter Thread alla_serial");
  while(1)
   {
        memset(command_str, 0x00,PDMS_MAX_COMMAND_SIZE);
        pump.gets(command_str, PDMS_MAX_COMMAND_SIZE);
        printf("%s", command_str); //print data received from Pump
        if(strstr(command_str, "Standby"))
        {
            key_reader=8;
        }
        else if(strstr(command_str, "Paused"))
        {
            if(AIL_Enable == 0)
                key_reader=1;
            else
                AIL_Enable--;
        }
        else if(strstr(command_str, "AIR IN LINE"))
        {
            key_reader=2;
            AIL_Enable=2;
        }
        else if(strstr(command_str, "Run Interval"))
        {
            key_reader=3;
        }
        else if(strstr(command_str, "Run Continous"))
        {
            key_reader=4;
        }
        else if(strstr(command_str, "DOOR OPEN"))
        {
            key_reader=5;
            AIL_Enable=2;
        }
        else if(strstr(command_str, "Priming"))
        {
            key_reader=6;
        }
        else if(strstr(command_str, "PUMP WAITING"))
        {
            key_reader=7;
        }
        else if(strstr(command_str, "Cleared"))
        {
            key_reader=9;
        }
        else
        {
           printf("\n %s", command_str);
        }
   }
}
int main() {
//////////////////////////////////////////////////////
    pump.baud(115200);
   // pump.format(8, SerialBase::Even, 1);
    serial_thread.start(&alla_serial);
//////////////////////////////////////////////////////

    int rc, pSW2=0, txSel=0, good = 0;
    Timer tmr;
    char* topic = PUBLISH_TOPIC;
    char clientID[100], buf[100];
    string st, uniqueID;

    HTS221 hts221;

    pc.baud(115200);
    rc = hts221.init();
    if ( rc  ) {
        PRINTF(BLU "HTS221 Detected (0x%02X)\n\r",rc);
        PRINTF("  Temp  is: %0.2f F \r\n  Huumid is: %02d %%\r\n\r\n",
              CTOF(hts221.readTemperature()), hts221.readHumidity()/10);
    }
    else {
        PRINTF(RED "HTS221 NOT DETECTED!\n\r");
    }

    controlLED(green);
    
    // set SW2 and SW3 to generate interrupt on falling edge 
    switch2.fall(&sw2_ISR);
    switch3.fall(&sw3_ISR);

    // initialize ethernet interface
    MQTTwnc ipstack = MQTTwnc();
    
    // get and display client network info
    WNCInterface& eth = ipstack.getEth();
    
    // construct the MQTT client
    MQTT::Client<MQTTwnc, Countdown> client = MQTT::Client<MQTTwnc, Countdown>(ipstack);

    controlLED(blue);
    
    char* hostname = URL;
    int port = PORT;
 //   uniqueID = "IoT-Moog-Device1";   //Guru Device
    uniqueID = "SomethingOtherThanPumpTest";         // Suraj Device
    sprintf(clientID, CLIENTSTR, uniqueID.c_str());

    PRINTF("Local network info...\r\n");    
    PRINTF("IP address is %s\r\n", eth.getIPAddress());
    PRINTF("MAC address is %s\r\n", eth.getMACAddress());
    PRINTF("Gateway address is %s\r\n", eth.getGateway());
    PRINTF("Your <uniqueID> is: %s\r\n", uniqueID.c_str());
    PRINTF("---------------------------------------------------------------\r\n");

    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;       

    int tries;
    
    while( !good ) {   
    
        tries=0;
        // connect to TCP socket and check return code
        tmr.start();
        rc = 1;
        while( rc && tries < 3) {
            PRINTF("\r\n\r\n(%d) Attempting TCP connect to %s:%d:  ", tries++, hostname, port);
            rc = ipstack.connect(hostname, port);
            if( rc ) {
                PRINTF("Failed (%d)!\r\n",rc);
                while( tmr.read_ms() < 5000 ) ;
                tmr.reset();
            }
            else {
                PRINTF("Success!\r\n");
                rc = 0;
            }
        }
        if( tries < 3 )
          tries = 0;
        else
          continue;
        
        data.willFlag = 0;  
        data.MQTTVersion = 3;

        data.clientID.cstring = clientID;
        data.username.cstring = USERNAME;
        data.password.cstring = PASSWORD;
        data.keepAliveInterval = 10;
        data.cleansession = 1;
    
        rc = 1;
        tmr.reset(); 
        while( !client.isConnected() && rc && tries < 3) {
            PRINTF("(%d) Attempting MQTT connect to '%s': ", tries++, clientID);
            rc = client.connect(data);
            if( rc ) {
                PRINTF("Failed (%d)!\r\n",rc);
                while( tmr.read_ms() < 5000 );
                tmr.reset();
            }
            else
                PRINTF("Success!\r\n");
        }

        if( tries < 3 )
          tries = 0;
        else
          continue;

        // subscribe to MQTT topic
        tmr.reset();
        rc = 1;
        while( rc && client.isConnected() && tries < 3) {
            PRINTF("(%d) Attempting to subscribing to MQTT topic '%s': ", tries, SUBSCRIBTOPIC);
            rc = client.subscribe(SUBSCRIBTOPIC, MQTT::QOS0, messageArrived);
            if( rc ) {
                PRINTF("Failed (%d)!\r\n", rc);
                while( tmr.read_ms() < 5000 );
                tries++;
                tmr.reset();
            }
            else {
                good=1;
                PRINTF("Subscribe successful!\r\n");
            }
        }
        while (!good);
    }        
    
    MQTT::Message message;
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    
    while(true) 
    {
       osEvent switchEvent = messageQ.get(100);
        if(key_reader != old_Key)
        {
            old_Key = key_reader;  
            memset(buf,0x00,sizeof(buf));
             //sprintf(buf, "{\"d\" : {\"Key\" : %d }}", key_reader);
             sprintf(buf, "{\"Key\":\"%d\"}", key_reader);
             PRINTF("Publishing MQTT message '%s' ", (char*)message.payload);
             message.payloadlen = strlen(buf);
             PRINTF("\n payloadlen:(%d)\r\n",message.payloadlen);
             rc = client.publish(topic, message);
             if( rc ) 
             {
                 PRINTF("Publish request failed! (%d)\r\n",rc);
                 FATAL_WNC_ERROR(resume);
             }
        }
        else
        {
            client.yield(1000);
        }
   }         
}
