#include "Stimulation.h"
#include "mbed.h"
#include "DAAD.h"
#include "HV507.h"

Stimulation::Stimulation()
{
    DAADinit();
    hv507Init(1);                               //initialize one HV507   
}
void Stimulation::begin()
{
    hv507FastScan(0);
}
void Stimulation::setOn(unsigned int pin, short volume, unsigned int pulsewidth)
{
    int t= pulsewidth/2;
    if(pin!=0){
        hv507FastScan(pin);
    }
    HV507_BL = 1;
    HV507_LE = 1;
    HV507_LE = 0;
    for(int i=0; i<t; i++) AD = DAAD(volume);   // Stimulation on
    //AD = DAAD(volume);
}
void Stimulation::setOff()
{
    AD = DAAD(0);                               // Stimulation off
    HV507_BL = 0;
}
void Stimulation::end()
{
    hv507Clear(HV507_NUM);                      //cleaning
    HV507_LE = 1;
    HV507_LE = 0;
    HV507_BL = 0;
}