#include "Stimulation.h"
#include "mbed.h"
#include "DAAD.h"
#include "HV507.h"

Stimulation::Stimulation()
{
    DAADinit();
    hv507Init(1);   //initialize one HV507   
}
void Stimulation::begin()
{
    hv507FastScan(0);
}
void Stimulation::setOn(unsigned char pin, short volume)
{
    hv507FastScan(pin);
    HV507_BL = 1;
    HV507_LE = 1;
    HV507_LE = 0;
    AD = DAAD(volume);  // Stimulation on
}
void Stimulation::setOff()
{
    AD = DAAD(0);                       // Stimulation off
    HV507_BL = 0;
}
void Stimulation::end()
{
    hv507Clear(HV507_NUM);                      //cleaning
    HV507_LE = 1;
    HV507_LE = 0;
    HV507_BL = 0;
}