#include "mbed.h"
#include "MMA8451Q.h"
#include "nRF24L01P.h"
#include <string>

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define TRANSFER_SIZE   1

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTC5, PTA4, PTC8, PTA12);    // mosi, miso, sck, csn, ce, irq
DigitalOut tx(PTD5);
DigitalOut rx(PTA13);
DigitalIn press(PTB0);


int funcx(float y);  //Function to dtermine angle
string funcp(int, char);
string funcp(int p, char c);
Serial pc(USBTX, USBRX);

float Y;
int x;
string z;
float p;


int main(){
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    char rxData[TRANSFER_SIZE];
    int rxDataCnt = 0;
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    pc.printf("receiver\n");

    
    while (1){
        p = press.read();
        Y = abs(acc.getAccY()); //Get gyroscope readings
        x =funcx(Y); //Call function to determine angle based on gyroscoe readings
        
        if (p && my_nrf24l01p.readable()){//transmitter not sending signal when open string.
        //if (my_nrf24l01p.readable()){
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ){
                //pc.putc( rxData[i] );
                z = funcp(x, rxData[i]);
                pc.printf("%s\n", z);
            }
            rx = !rx;
        }
        
        //z=funcp(x,rxData[i]); what is this?????????????????????????????????????????????????????????????????????
        
    }
}

//Function used to determine the angle for note 
int funcx(float y){
    int a;
    if (y < 0.25000)       
        {
            a=1;
        }
else if (y > 0.25001 && y < 0.5000)
        {
            a=2;
        } 
else if (y > 0.50001 && y < 0.7500)
        {
            a=3;
        }
else
        {
            a=4;
        }
        //pc.printf("%i     ",a);
        return a; 
}

//Final function used to dtermine what string to send to the phone//
string funcp(int p, char c){ 
    string str; // Final string output 
    
    if(p == 1)
    {
        if(c == 'r')
        {
            str = "G string D flat"; 
            //return str;
        }
        if(c == 'e')
        {
            str = "G string C flat"; 
            //return str;
        }
        if(c == 'w')
        {
            str = "G string B flat"; 
            //return str;
        }
        if(c == 'q')
        {
            str = "G string A flat"; 
            //return str;
        }
        if(c == 'f')
        {
            str = "G string D"; 
            //return str;
        }
        if(c == 'd')
        {
            str = "G string C"; 
            //return str;
        }
        if(c == 's')
        {
            str = "G string B"; 
            //return str;
        }
        if(c == 'a')
        {
            str = "G string A"; 
            //return str;
        }
        if(c == 'v')
        {
            str = "G string D sharp"; 
            //return str;
        }
        if(c == 'c')
        {
            str = "G string C sharp"; 
            //return str;
        }
        if(c == 'x')
        {
            str = "G string B sharp"; 
            //return str;
        }
        if(c == 'z')
        {
            str = "G string A sharp"; 
            //return str;
        } 
        if(c == '0')
        {
            str = "Open G string";
            return str; 
        }
          
    }
    if(p == 2)
    {
        str = "Open D";
        if(c == 'r')
        {
            str = "D string A flat"; 
            //return str;
        }
        if(c == 'e')
        {
            str = "D string G flat"; 
            //return str;
        }
        if(c == 'w')
        {
            str = "D string F flat"; 
            //return str;
        }
        if(c == 'q')
        {
            str = "D string E flat"; 
            //return str;
        }
        if(c == 'f')
        {
            str = "D string A"; 
            //return str;
        }
        if(c == 'd')
        {
            str = "D string G"; 
            //return str;
        }
        if(c == 's')
        {
            str = "D string F"; 
            //return str;
        }
        if(c == 'a')
        {
            str = "D string E"; 
            //return str;
        }
        if(c == 'v')
        {
            str = "D string A sharp"; 
            //return str;
        }
        if(c == 'c')
        {
            str = "D string G sharp"; 
            //return str;
        }
        if(c == 'x')
        {
            str = "D string F sharp"; 
            //return str;
        }
        if(c == 'z')
        {
            str = "D string E sharp"; 
            //return str;
        }    
        if(c == '0')
        {
            str = "Open D string";
            return str; 
        } 
    }
    if(p == 3)
    {
        str = "Open A";
        if(c == 'r')
        {
            str = "A string E flat"; 
            //return str;
        }
        if(c == 'e')
        {
            str = "A string D flat"; 
            //return str;
        }
        if(c == 'w')
        {
            str = "A string C flat"; 
            //return str;
        }
        if(c == 'q')
        {
            str = "A string B flat"; 
            //return str;
        }
        if(c == 'f')
        {
            str = "A string E"; 
            //return str;
        }
        if(c == 'd')
        {
            str = "A string D"; 
            //return str;
        }
        if(c == 's')
        {
            str = "A string C"; 
            //return str;
        }
        if(c == 'a')
        {
            str = "A string B"; 
            //return str;
        }
        if(c == 'v')
        {
            str = "A string E sharp"; 
            //return str;
        }
        if(c == 'c')
        {
            str = "A string D sharp"; 
            //return str;
        }
        if(c == 'x')
        {
            str = "A string C sharp"; 
            //return str;
        }
        if(c == 'z')
        {
            str = "A string B sharp"; 
            //return str;
        }    
        if(c == '0')
        {
            str = "Open A string";
            return str; 
        }
    }
    if(p == 4)
    {
        str = "Open E";
        if(c == 'r')
        {
            str = "E string B flat"; 
            //return str;
        }
        if(c == 'e')
        {
            str = "E string A flat"; 
            //return str;
        }
        if(c == 'w')
        {
            str = "E string G flat"; 
            //return str;
        }
        if(c == 'q')
        {
            str = "E string F flat"; 
            //return str;
        }
        if(c == 'f')
        {
            str = "E string B"; 
            //return str;
        }
        if(c == 'd')
        {
            str = "E string A"; 
            //return str;
        }
        if(c == 's')
        {
            str = "E string G"; 
            //return str;
        }
        if(c == 'a')
        {
            str = "E string F"; 
            //return str;
        }
        if(c == 'v')
        {
            str = "E string B sharp"; 
            //return str;
        }
        if(c == 'c')
        {
            str = "E string A sharp"; 
            //return str;
        }
        if(c == 'x')
        {
            str = "E string G sharp"; 
            //return str;
        }
        if(c == 'z')
        {
            str = "E string F sharp"; 
            //return str;
        }   
        if(c == '0')
        {
            str = "Open E string";
            return str; 
        }  
    }
    
    
    
    return str;
}