//HEADER FILES
#include "mbed.h"
#include "C12832.h"
#include "MMA7660.h"
#include <time.h>
#include <stdlib.h>
#include "MSCFileSystem.h"
#include "SongPlayer.h"

//IMPORTANT INITIALIZATIONS
Serial pc(USBTX, USBRX); 
C12832 lcd(p5, p7, p6, p8, p11);
BusIn joy(p15,p12,p13,p16);
DigitalIn fire(p14);
BusOut leds(LED1,LED2,LED3,LED4);
MMA7660 MMA(p28, p27);                         //I2C Accelerometer
DigitalOut connectionLed(LED1);                //Accel OK LED
LocalFileSystem local("local");                // Create the local filesystem
MSCFileSystem msc("msc");
PwmOut r(p23); //RGB LED with 3 PWM outputs for dimmer control
PwmOut g(p24);
PwmOut b(p25);
SongPlayer speaker(p26); //Speaker with PWM driver
float note[18]= {1568.0,1396.9,1244.5,1244.5,1396.9,1568.0,1568.0,1568.0,1396.9,
                 1244.5,1396.9,1568.0,1396.9,1244.5,1174.7,1244.5,1244.5, 0.0
                };
float duration[18]= {0.48,0.24,0.72,0.48,0.24,0.48,0.24,0.24,0.24,
                     0.24,0.24,0.24,0.24,0.48,0.24,0.48,0.48, 0.0
                    };
AnalogIn pot1(p19); //Reads Pot 1 - near LCD
AnalogIn pot2(p20); //Reads Pot 2 - near RGB LED


int rad;       //variable for random number
int p1=10;     //x-coordinate for food
int p2=20;     //y-coordinate for food
int fDimX;
int fDimY;
    
int main()
{
    //IMPORTANT VARIABLE DECLARATIONS
    srand(time(NULL));

    int i=0;        //variable for x-axis
    int dimX = 100; //space for snake can move(x-axis)
    int dimY = 26;  //space for snake can move(y-axis)
    
    speaker.PlaySong(note,duration);
    lcd.cls();
    lcd.locate(5,10);
    lcd.printf("welcome to snake game");
    wait(2);
    lcd.locate(5,10);
    lcd.printf("Please do not hit the wall");
    wait(2);
    lcd.cls();

    int j = 0;          //variable for y-axis
    int cst = 4;        //cast size
    fDimY = dimY - cst; 
    fDimX = dimX - cst;
    int score = 0;      //used to store score
    int flag = 0;       //used as flag
    int back_flag=0;    //used as flag
    int forward_flag=0; //used as flag
    int up_flag=0;      //used as flag
    int down_flag=0;    //used as flag
    int end_flag=0;     //used as flag
    r=1.0; //RGB LED off - PWM 100% duty cycle
    g=1.0;
    b=1.0;

    while(1) 
    {
            // CONDITIONS TO CHECK FOR JOYSTICK INPUT
            leds=joy;
            lcd.locate(i,j);
            lcd.printf("~+");
            // move backwards
            if  (joy==0x4)
            {
                i=i-cst;
                back_flag=1;
                do{
                    i--;      
                    lcd.locate(i,j);
                    lcd.printf("~+");
                    wait(0.2);
                    lcd.cls();
                    lcd.locate(110, 22);
                    lcd.printf("%d", score);
                    pc.printf("snake location %d %d\n \r", i, j);
                    lcd.locate(p1, p2);
                    lcd.printf(".");
                        if(i<0){
                            end_flag=1;
                            r=1.0-pot2;
                            do{
                                lcd.cls();
                                lcd.locate(25,10);
                                lcd.printf("GAME OVER!!");
                                FILE *fp1 = fopen("/msc/Score.txt", "w");  // Open "Result.txt" on the msc file system for writing(pendrive)
                                fprintf(fp1,"score %d\n\r",score);
                                fclose(fp1);
                                FILE *fp = fopen("/local/Score.txt", "w");  // Open "Result.txt" on the local file system for writing
                                fprintf(fp,"score %d\n\r",score);
                                fclose(fp);
                                wait(5);
                            }while(end_flag==1);}
                        if(joy==0x8||joy==0x1||joy==0x2){
                            back_flag=0;
                            break;}
                }while(back_flag==1);
            }
            //move forward
            if  (joy==0x8)
            {
                i=i+cst;
                forward_flag=1;
                do{
                    i++;      
                    lcd.locate(i,j);
                    lcd.printf("~+");
                    wait(0.2);
                    lcd.cls();
                    lcd.locate(110, 22);
                    lcd.printf("%d", score);
                    pc.printf("snake location %d %d\n \r", i, j);
                    lcd.locate(p1, p2);
                    lcd.printf(".");
                        if(i>100){
                            end_flag=1;
                            r=1.0-pot2;
                            do{
                                lcd.cls();
                                lcd.locate(25,10);
                                lcd.printf("GAME OVER!!");
                                FILE *fp1 = fopen("/msc/Score.txt", "w");  // Open "Result.txt" on the msc file system for writing(pendrive)
                                fprintf(fp1,"score %d\n\r",score);
                                fclose(fp1);
                                FILE *fp = fopen("/local/Score.txt", "w");  // Open "Result.txt" on the local file system for writing
                                fprintf(fp,"score %d\n\r",score);
                                fclose(fp);
                                wait(5);
                            }while(end_flag==1);}
                        if(joy==0x4||joy==0x1||joy==0x2){
                            forward_flag=0;
                            break;}
                }while(forward_flag==1);
            }
            //move up
            if  (joy==0x1)
            {
                j=j-cst;
                up_flag=1;
                do{
                    j--;      
                    lcd.locate(i,j);
                    lcd.printf("~+");
                    wait(0.2);
                    lcd.cls();
                    lcd.locate(110, 22);
                    lcd.printf("%d", score);
                    pc.printf("snake location %d %d\n \r", i, j);
                    lcd.locate(p1, p2);
                    lcd.printf(".");
                        if(j<0){
                            end_flag=1;
                            r=1.0-pot2;
                            do{
                                lcd.cls();
                                lcd.locate(25,10);
                                lcd.printf("GAME OVER!!");
                                FILE *fp1 = fopen("/msc/Score.txt", "w");  // Open "Result.txt" on the msc file system for writing(pendrive)
                                fprintf(fp1,"score %d\n\r",score);
                                fclose(fp1);
                                FILE *fp = fopen("/local/Score.txt", "w");  // Open "Result.txt" on the local file system for writing
                                fprintf(fp,"score %d\n\r",score);
                                fclose(fp);
                                wait(5);
                            }while(end_flag==1);}
                        if(joy==0x4||joy==0x8||joy==0x2){
                            up_flag=0;
                            break;}
                }while(up_flag==1);
            }
            //move down
            if  (joy==0x2)
            {
                j=j+cst;
                down_flag=1;
                do{
                    j++;      
                    lcd.locate(i,j);
                    lcd.printf("~+");
                    wait(0.2);
                    lcd.cls();
                    lcd.locate(110, 22);
                    lcd.printf("%d", score);
                    pc.printf("snake location %d %d\n \r", i, j);
                    lcd.locate(p1, p2);
                    lcd.printf(".");
                        if(j>26){
                            end_flag=1;
                            r=1.0-pot2;
                            do{
                                lcd.cls();
                                lcd.locate(25,10);
                                lcd.printf("GAME OVER!!");
                                FILE *fp1 = fopen("/msc/Score.txt", "w");  // Open "Result.txt" on the msc file system for writing(pendrive)
                                fprintf(fp1,"score %d\n\r",score);
                                fclose(fp1);
                                FILE *fp = fopen("/local/Score.txt", "w");  // Open "Result.txt" on the local file system for writing
                                fprintf(fp,"score %d\n\r",score);
                                fclose(fp);
                                wait(5);
                            }while(end_flag==1);}
                        if(joy==0x4||joy==0x8||joy==0x1){
                            down_flag=0;
                            break;}
                }while(down_flag==1);
            }
                
        if (flag == 0)
        {
            //print score on the LCD
            lcd.locate(110, 22);
            lcd.printf("%d", score);
            //print food on the LCD
            lcd.locate(p1, p2);
            lcd.printf(".");
            // CONDITION FOR CHECKING THE SNAKE FOOD COLLISION
            if (abs(i + 8 - p1) <=cst && abs(j - p2) <=cst+1)
            { 
                score = score + 1;
                pc.printf("score %d\n\r", score);
                g = 1.0 - pot2; //RGB LED green
                wait(0.3);
                b = 1.0 - pot2;
                //finding a new random location for food
                rad=rand();
                p1= rad%fDimX;
                p2= rad%fDimY;
                if (p1 < 30)
                    p1 = 30;
                if (p2 < 10)
                    p2 = 10;
                lcd.printf(".");
            }   
        wait(0.3);
        }
    }//while(1)
}//(int main)
