/**
 * @file at45db161e.h
 * @brief AT45DB161E module
 **/
#ifndef AT45DB161E_H
#define AT45DB161E_H

#include "mbed.h"

/** 
          * @brief ID structure 
          * This structure contains various informations about the
          * dataflash chip being used.
          **/
        struct flash_id
        {
            unsigned char manufacturer;       /**< Manufacturer id                           **/
            unsigned char device[1];          /**< Device id                                 **/
            unsigned char extendedInfoLength; /**< Extended device information string length **/
        };

class ATD45DB161E
{
    
    // Public functions
    public:
        
        ATD45DB161E(PinName mosi, PinName miso, PinName clk, PinName cs);
        ATD45DB161E(SPI &spi, PinName cs);
        
        void initial_chip(void);
        void pollbusy (void);
        int  ReadStatusRegister(void);
        void ReadManufacturerAndDeviceID(struct flash_id *id);
        
        void PageRead(unsigned int,unsigned int,unsigned char *,unsigned int);
        void ContinuousArrayRead(unsigned int,unsigned char *,unsigned int);
        
        void ChipErase(void);
        void PageErase(unsigned int);
        
        void PageWriteThroughBuffer(unsigned int, unsigned int, unsigned char ,unsigned char *,unsigned int);
        void ContinuousWriteThroughBuffer(unsigned int, unsigned char ,unsigned char *,unsigned int);
        
				void BufferRead(unsigned char, unsigned int, unsigned char, unsigned char *, unsigned int);
        void BufferWrite(unsigned char, unsigned,unsigned char *,unsigned int);
        void BufferToPage(unsigned char, unsigned int, unsigned char);
        void PageToBuffer(unsigned int, unsigned char);
        
        void DeepPowerDown(unsigned char);
        void UltraDeepPowerDown(unsigned char);
        bool is_it_awake(void);
        
    // Private variables    
    private:
        SPI _spi;
        DigitalOut _cs;
        bool _wake_flag;
        bool _deepsleep_flag;
        bool _udeepsleep_flag;
        
        void _set_pageszie_to_binary(void);
        void _select(); 
        void _deselect();
        void _pollbusy (void);
                
        // Send 3 byte address 
        void _sendaddr (unsigned int address);
};

/**
 * @}
 **/

#endif /* AT45DB161E_H */
