
#include "mbed.h"
#include "TextLCD.h"
#include "MAG3110.h"
#include "MMA8652.h"

MAG3110 mag(P20, P19); //  i2c pins SDA, SCL for magnetometer //
MMA8652 acc(P20, P19); //  i2c pins SDA, SCL for accelerometer //
// LCD pins rs, en, d4, d5, d6, d7 and 16x2 lcd //
TextLCD lcd(P6, P8, P7, P13, P14, P15,TextLCD::LCD16x2); 

PwmOut ChargePump(P0);  // pwm output to drive charge pump
InterruptIn ButtonA(P5);  // active low push switch with interrupt
InterruptIn ButtonB(P11); // active low push switch with interrupt

AnalogIn Vref_2v5(P3); // 2.5v ref on adc for vcc independent measurement
AnalogIn ADCP4 (P4);
AnalogIn ADCP10 (P10);

float frequency = 9000.0f; // min 1.5 kHz for stable operation
float duty = 50.0f; // min 20% to max 80 percent for stable operation
float heading = 0.0; // magnetometer heading
float Xg =0.0; float Yg = 0.0; float Zg = 0.0;
uint16_t vref =0;
volatile int selector = 1;

////////////////////////////////////////////////////////////////////////////////
void EnableChargePump (void)
{
// 10kHz drive signal for Diode-Capacitor DC-DC (3.3V ->5.5V) converter
       ChargePump.period(1.0f/frequency);      
       ChargePump.write(duty/100.0f); // 50% duty 
       wait(.5); // Let boosted voltage stabilize to 5.5v (lcd supply as load)
}
////////////////////////////////////////////////////////////////////////////////
void calMag(void) 
{
    //magnetometer calibration: finding max and min of X, Y axis
    int tempXmax, tempXmin, tempYmax, tempYmin, newX, newY;
    while(selector==1)
    {
    lcd.locate(0,0);
    lcd.printf("Press A to Start");
    lcd.locate(0,1);
    lcd.printf("Mag Calibration");
    wait(.3);
    }
    selector=1;
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Calibration is");
    lcd.locate(0,1);
    lcd.printf("Starting Now..");
    wait(2);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Rotate like an");
    lcd.locate(0,1);
    lcd.printf("Infinity Symbol");
    wait(3);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Calibrating now");
    lcd.locate(0,1);
    lcd.printf("Keep swinging..");  
    tempXmax = tempXmin = mag.readVal(MAG_OUT_X_MSB);
    tempYmax = tempYmin = mag.readVal(MAG_OUT_Y_MSB);
    int sample = 0;
     
    while(sample<201) {
        wait(0.05);
        newX = mag.readVal(MAG_OUT_X_MSB);
        newY = mag.readVal(MAG_OUT_Y_MSB);
        if (newX > tempXmax) tempXmax = newX;
        if (newX < tempXmin) tempXmin = newX;
        if (newY > tempYmax) tempYmax = newY;
        if (newY < tempYmin) tempYmin = newY;
        sample++;      
    }
   
    mag.setCalibration( tempXmin, tempXmax, tempYmin, tempYmax );
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Calibration has");
    lcd.locate(0,1);
    lcd.printf("been completed");
}
////////////////////////////////////////////////////////////////////////////////
void getMagHeading(void)
{
    heading = mag.getHeading();; // magnetometer heading
    wait(.1);
}
////////////////////////////////////////////////////////////////////////////////
void getAccXYZ(void)
{
    float temp[3];
    acc.ReadXYZ(temp); // accelerometer 
    Xg = 10.0*temp[0]; Yg = 10.0*temp[1]; Zg = 10.0*temp[2]; 
    wait(.1);   
}
////////////////////////////////////////////////////////////////////////////////
void WhenAPressed()
{
 // button A ISR   
    if (selector<8)
    selector++;
    if(selector>=8)
    selector=8;
    wait(.2);
}
////////////////////////////////////////////////////////////////////////////////
void WhenBPressed()
{
 // button B ISR    
    if (selector>1)
    selector--;
    if(selector<=1)
    selector=1;
    wait(.2);
}
////////////////////////////////////////////////////////////////////////////////
void updateLCD (void)
{
    lcd.cls();
    
    
    if(selector==1)
    {
        lcd.locate(0,0);
        lcd.printf("System Voltage");
        lcd.locate(0,1);
        lcd.printf("Vcc:%fVolt", ((2.5*1023.0)/Vref_2v5.read_u16()));
    }
    
     if(selector==2)
    {
        lcd.locate(0,0);
        lcd.printf("Charge Pump");
        lcd.locate(0,1);
        lcd.printf("Freq:%dkHz Cyc:%d%",int(frequency/1000.0f),int(duty));
    }
    
    if(selector==3)
    {
        lcd.locate(0,0);
        lcd.printf("Reading ADC val");
        lcd.locate(0,1);
        lcd.printf("ADC P4:%d", (ADCP4.read_u16()));
    }
    
    if(selector==4)
    {   
        lcd.locate(0,0);
        lcd.printf("Reading ADC data");
        lcd.locate(0,1);
        lcd.printf("ADC P10:%d", (ADCP10.read_u16()));
    }
        
    if(selector==5)
    {
        lcd.locate(0,0);
        lcd.printf("Mag Sensor data");
        lcd.locate(0,1);
        lcd.printf("Mag Heading:%d", int(heading));
    }
    
    if(selector==6)
    {
        lcd.locate(0,0);
        lcd.printf("Acc Sensor Xaxis");
        lcd.locate(0,1);
        lcd.printf("Xg:%f", Xg);
    }
    
    if(selector==7)
    {
        lcd.locate(0,0);
        lcd.printf("Acc Sensor Yaxis");
        lcd.locate(0,1);
        lcd.printf("Yg:%f", Yg);
    }
    
    if(selector==8)
    {   
        lcd.locate(0,0);
        lcd.printf("Acc Sensor Zaxis");
        lcd.locate(0,1);
        lcd.printf("Zg:%f", Zg);
    }
    wait(.1);
}
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////// main ////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

int main() 
{
    EnableChargePump(); // enable lcd power
    ButtonA.fall(&WhenAPressed); // enable falling edge interrupt on button A
    ButtonB.fall(&WhenBPressed); // enable falling edge interrupt on button B
    calMag(); // init magnetometer and calibrate
    acc.begin(); // init accelerometer
   
        lcd.locate(0,0);
        lcd.printf("Press A or B to");
        lcd.locate(0,1);
        lcd.printf("check sensor info");
        wait(2);
  ////////////////////// while ////////////////
  
    while(1)
    {   
    updateLCD();
    getMagHeading();
    getAccXYZ();
    
    } ///// end of while .....

} ///// end of main ......

//////////////////////////////// end of code ///////////////////////////////////
