/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 //////////////////////////////////////////////////////////
///////////////////////NOTE ///////////////////////////////
// This program uses BBC microbit as a NRF51822 board    //
// with limited onboard functionality, mainly focused    //
// BLE-uart/ADC/DIO/PWM capability, see pin maping below //
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
        
#include <string.h>
#include "mbed.h"
#include "BLE.h"
#include "stdio.h"
#include "UARTService.h"

#include "ble/BLE.h"
#include "ble/services/URIBeaconConfigService.h"
#include "ble/services/DFUService.h"
#include "ble/services/DeviceInformationService.h"
#include "ConfigParamsPersistence.h"


#define NEED_CONSOLE_OUTPUT 1 // if BLE printf messages needed on the remote console (PC/phone/host);                            
#if NEED_CONSOLE_OUTPUT
#define blePrintf(STR) { if (uart) uart->write(STR, strlen(STR)); }
#else
#define blePrintf(...) 
#endif

///////////////// pin table /////////////////////////
/////////////////////////////////////////////////////
// ubit.pin    nrf51822pin    functions      note  //
/////////////////////////////////////////////////////
//  P2           P0_1        ADC/PWM/DIO      2    //
//  P1           P0_2        ADC/PWM/DIO      1    // 
//  P0           P0_3        ADC/PWM/DIO      0    //
//  P16          P_16            DIO               //
//  P14          P0_25       SPI MIS/DIO           //
//  P5           P_17        Button A/DI    pullup //
//  P11          P_26        Button B/DI    pullup //

/////////////////////////////////////////////////////
///////////////// not mapped yet ////////////////////
//  P20                      I2C SDA/DIO    pullup //
//  P19                      I2C SCL/DIO    pullup //
//  P15                      SPI MOS/DIO           //
//  P13                      SPI SCK/DIO           //
//  P16                                            //
//  P8                                             //

/////////////////////////////////////////////////////
//      LED Matrix pins are not mapped             //
/////////////////////////////////////////////////////


BLEDevice  ble;
DigitalOut led1(LED1);
UARTService *uart;
AnalogIn   ain(P0_3);
int val,dVal, dec, i;
char result[100];
float batt = 0.03;
 

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    ble.startAdvertising();
}

void periodicCallback(void)
{
    
    blePrintf("BATT VOlT: ");
    blePrintf(result);
    blePrintf("\r\n");
}

int main(void)
{
    Ticker ticker;
    ticker.attach(periodicCallback, 5);

    blePrintf("Initialising the nRF51822\n\r");
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    
    uart = new UARTService(ble);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"uBit BLE", sizeof("uBit BLE") - 1);
                                     // device name on BLE //
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));

    ble.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    ble.startAdvertising();

    while (true) {
        ble.waitForEvent();
        val = ain.read_u16();
    // 22k+100K VOLTAGE DIVIDER AND 0.15 IS OFFSET   
    batt = (122/22)*3.6*val/1023.0 - 0.15
    dVal = batt;
    dec = (int)(batt * 100) % 100;

    memset(result, 0, 100);
    result[0] = (dVal / 10) + '0';
    result[1] = (dVal % 10) + '0';
    result[2] = '.';
    result[3] = (dec / 10) + '0';
    result[4] = (dec % 10) + '0';


    for (i=strlen(result)-1; i>=0; i--)
        putc(result[i], stdout);
      
            }
}



