/* mbed Microcontroller Library
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ble/BLE.h"
#include "HIDServiceBase.h"
//#include "KeyboardService.h"
#include "MouseService.h"
#include "examples_common.h"
#include "MMA8652.h" // accelerometer 
//Serial pc(USBTX, USBRX);
/**
 * This program implements a complete //////////////////////////HID-over-Gatt Profile:
 *  - //////HID is provided by MouseService
 *  - Battery Service
 *  - Device Information Service
 */
 
//The micro:bit has a matrixed display, this is a simple way to use some LEDs on it
// turn off LED saves 1 mA current 

  DigitalOut col9(P0_12, 0);
//DigitalOut waiting_led(P0_13);
//DigitalOut connected_led(P0_15);

MMA8652 accelerometer(P0_20, P0_19); // i2c pin assign
//I2C i2c(P0_19, P0_20);
//const int accel_addr = 0x3A;

ButtonState click;
MouseButton LR;

int Xpos = 0;int Ypos = 0;
int OldXpos = 0; int OldYpos = 0;
int dX = 0; int dY = 0;

float accelerometer_data[3];
float x,y,z;
Ticker movement,timeout ;

       
InterruptIn button1(BUTTON_A);
InterruptIn button2(BUTTON_B);

BLE ble;
//KeyboardService *kbdServicePtr;
//MouseService musServicePtr(ble);
MouseService *musServicePtr;
static const char DEVICE_NAME[] = "micro:bit_BLE_Mouse";
static const char SHORT_DEVICE_NAME[] = "uBit-mUs";

static void onDisconnect(const Gap::DisconnectionCallbackParams_t *params)
{
    //////////HID_DEBUG("disconnected\r\n");
//    connected_led = 0;
    ble.gap().startAdvertising(); // restart advertising
}

static void onConnect(const Gap::ConnectionCallbackParams_t *params)
{
    ////HID_DEBUG("connected\r\n");
  //  waiting_led = false;
}

static void waiting() 
{
  //  if (!musServicePtr->isConnected())
       {}// waiting_led = !waiting_led;
  //  else
       {}// connected_led = !connected_led;
}


 void stop_mouse_move(void)
  {
       // Set mouse state to immobile
   //    musServicePtr->.setButton(MOUSE_BUTTON_LEFT, MOUSE_UP);
       if (!musServicePtr)
        return;
    if (!musServicePtr->isConnected()) 
    {
        //////HID_DEBUG("we haven't connected yet...\n");
    } else {
           musServicePtr->setSpeed(0, 0, 0);
           }
  }
 
  void start_mouse_move(void)
  {
       // Move left with a left button down. If the focus is on a drawing
       // software, for instance, this should draw a line.
     //  mouse.setButton(MOUSE_BUTTON_LEFT, MOUSE_DOWN);
       musServicePtr->setSpeed(0, 0, 0);
   //    timeout.attach(stop_mouse_move, 0.2);
  }
 

void register_Lclick() 
{
   // send click left
    if (!musServicePtr)
        return;
    if (!musServicePtr->isConnected()) 
    {
        //////HID_DEBUG("we haven't connected yet...\n");
    } else {
            
      LR = MOUSE_BUTTON_LEFT;
      click = BUTTON_DOWN;
      musServicePtr->setButton(LR,click);
           }
}

void register_Rclick() 
{
    // send click rightLR = MOUSE_BUTTON_LEFT;
   if (!musServicePtr)
        return;
    if (!musServicePtr->isConnected()) 
    {
        //////HID_DEBUG("we haven't connected yet...\n");
    } else {
    
   LR = MOUSE_BUTTON_RIGHT;
   click = BUTTON_DOWN;
   musServicePtr->setButton(LR,click);
        }
}

void register_Lclick_release() 
{
   // send click left_release
   if (!musServicePtr)
        return;
    if (!musServicePtr->isConnected()) 
    {
        //////HID_DEBUG("we haven't connected yet...\n");
    } else {
     
   LR = MOUSE_BUTTON_LEFT;
   click = BUTTON_UP;
   musServicePtr->setButton(LR,click);
            }
}

void register_Rclick_release() 
{
   // send click right_release
   if (!musServicePtr)
        return;
    if (!musServicePtr->isConnected()) 
    {
        //////HID_DEBUG("we haven't connected yet...\n");
    } else {    
   LR = MOUSE_BUTTON_RIGHT;
   click = BUTTON_UP;
   musServicePtr->setButton(LR,click);
            }
}

void stop_mouse_movement() 
{
    musServicePtr->setSpeed(0, 0, 0);
}

void register_mouse_movement() 
{
         if (!musServicePtr)
        return;
    if (!musServicePtr->isConnected()) 
    {
        //////HID_DEBUG("we haven't connected yet...\n");
    } else {

     accelerometer.ReadXYZ(accelerometer_data);
    x = accelerometer_data[0];
    y = accelerometer_data[1];
    z = accelerometer_data[2];
    // do some math to adjust movement
 
    Xpos = x*50.0;
    Ypos = y*50.0; // float to int conv
    dX = abs(Xpos - OldXpos); dY = abs(Ypos - OldYpos); 
    OldXpos = Xpos; OldYpos = Ypos;
    musServicePtr->setSpeed(dX, dY, 0); 
    dX=0;dY=0;
    timeout.attach(stop_mouse_movement, 0.001);
    }
}

int main()
{
    Ticker heartbeat;
    
    button1.rise(register_Lclick);
    button2.rise(register_Rclick);

    button1.fall(register_Lclick_release);
    button2.fall(register_Rclick_release);

    heartbeat.attach(waiting, 1);

    ble.init();
    ble.gap().onDisconnection(onDisconnect);
    ble.gap().onConnection(onConnect);
    initializeSecurity(ble);
    initializeHOGP(ble);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::MOUSE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME,
                                           (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                           (uint8_t *)SHORT_DEVICE_NAME, sizeof(SHORT_DEVICE_NAME));
    ble.gap().setDeviceName((const uint8_t *)DEVICE_NAME);
    ble.gap().startAdvertising();

    wait(10);
   // movement.attach(&register_mouse_movement, 0.05);
   
    while (true) 
    {
        register_mouse_movement();
        ble.waitForEvent();
        
    /// make the following a separate periodic ticker
    //accelerometer.ReadXYZ(accelerometer_data);
    // x = accelerometer_data[0];
    // y = accelerometer_data[1];
    // z = accelerometer_data[2];
 
    }
}

