// Hello World! for the TextLCD

#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(PC_15, PC_13, PC_14, PE_6, PE_4, PE_2,TextLCD::LCD20x4); // rs, e, d4-d7
AnalogIn   adcPB0(PB_0);
AnalogIn adcPB1(PB_1);
AnalogOut dacPA5(PA_5); 
DigitalIn buttonPA0 (PA_0);
DigitalIn extbutton1PE5 (PE_5);
DigitalIn extbutton2PE3 (PE_3);
DigitalOut rLED(PD_14);   // on board red LED, DO
DigitalOut bLED(PD_15);   // on board blue LED. DO
DigitalOut gLED(PD_12);   // on board green LED, DO
DigitalOut oLED(PD_13);   // on board orange LED, DO

DigitalOut exRef(PE_7);   // on board orange LED, DO



uint32_t adcval=0;
uint16_t val=0;


int main() {
    dacPA5=0.0f;
    extbutton1PE5.mode(PullUp);
    extbutton2PE3.mode(PullUp);
    exRef=1;
    
    while(1)
    {
        lcd.cls();
    lcd.printf("mbed with STM32F407G");
    lcd.printf(" !! It Worked !!\n");
    if(dacPA5<1.00f)
    dacPA5 = dacPA5+0.002442f;
    adcval=0;
    for(int i=0;i<4096;i++)
    {
    adcval= adcval + 4095*adcPB1.read_u16()/65535; // 12 bit value
    }
    val=adcval/4096;
    lcd.printf("  ADC on PB1: %d\n", val);
    lcd.printf("AREF Volts: %f",(2.9464*val/4095));
   wait(.25);
   rLED =extbutton1PE5.read();
   bLED =extbutton2PE3.read();
   gLED =!extbutton1PE5.read();
   oLED =!extbutton2PE3.read();
   while(buttonPA0)
   {}
   
    }
}
