// libraries //
#include "mbed.h"
#include "LIS3DSH.h"
///////////////////////////////////////////////////////////////

// **see DocID022256 rev6 (google it) page 27-31 schematic** //
// Note: following pins are connected to onboard hardware //
///////////////////////////////////////////////////////////////
// i/o initialization //
DigitalOut rLED(PD_14);   // on board red LED, DO
DigitalOut bLED(PD_15);   // on board blue LED. DO
DigitalOut gLED(PD_12);   // on board green LED, DO
DigitalOut oLED(PD_13);   // on board orange LED, DO
PwmOut GLED(PA_9);        // on board green LED, PWM
DigitalIn  pbSW(PA_0);    // on board blue PUSH Switch, active high DI
// DAC tested, it works //
//AnalogOut dac1(PA_5); //
//AnalogOut dac2(PA_4);

/////////////////////////////////////////////////////////////////
// on board accerometer  mosi, miso, clk , cs  pins //
LIS3DSH acc(PA_7, PA_6, PA_5, PE_3);
// INT1 PE_0
// INT2 PE_1
/////////////////////////////////////////////////////////////////
// on board digital mic MP45DT02//
DigitalOut mic_clk(PB_10);
DigitalIn mic_data(PC_3);
// on board audio dac CS43L22 //
// Audio_SDA PB_9
// Audio_SCL PB_6
// Audio_RST PD_4
// DAC_Out PA_4
// PDM_Out PC_4
// ISS_MCK PC_7
// ISS_CLK PC_10
// ISS_SDI  PC_12
// ISS_WS PA_4
//////////////////////////////////////////////////////////////////
Serial serial(PA_2,PA_3); // serial com tx, rx UART
AnalogIn   adcPB0(PB_0);  // PB0 as 12 bit ADC


// variables declearation //
double delay = .2;     // delay variable for wait 
double freq = 1000.0f;  // pwm frequency variable upto 84 Mhz
double duty = 50.0f;    // duty cycle of pwm variable 0.0 - 99.9
uint16_t adcval=0;      // adc value capture variable
int16_t X, Y, Z;        // signed integer variables for X,Y,Z values
float roll, pitch;      // float variables for angle
// main code //
int main() 
{
     //////////////////////////////////////////////////////////////
      // set serial baud and print welcome msg //
    serial.baud(19200);
    serial.printf("Welcome to STM32F407 Development with mbedOS \n\r");
                  
             
       GLED.period(1.0f/freq);  // set pwm period      
       GLED.write(duty/100.0f); // set pwm duty cycle
    while(1) 
    { 
        //////////////////////////////////////////////////////////// 
         // on board RGBO LED blink //
               // set up 1 volt on dac 1
               //dac1 = 0.333f; // vdd* 0.333 = 3.0*0.333 =  1.0 volt
               // set up 1.5 volt on dac 2
               //dac2 = 0.5f; // vdd*0.5 = 1.5 volt

       
                rLED = 1;
                gLED = 1;
                wait(delay);
                rLED = 0;
                gLED = 0;
                wait(delay);            
                bLED = 1;
                oLED = 1;
                wait(delay);
                bLED = 0; 
                oLED = 0;
                wait(delay);
          //////////////////////////////////////////////////////////////////      
          // on board user push switch test // 
                if (pbSW==1) 
                 {
                      // adc value read //         
                   adcval = 4095*adcPB0.read_u16()/65535; // 12 bit value
                      // serial message //
          ///////////////////////////////////////////////////////////////////
                      
                   serial.printf("Button Pressed\n\r");
                   serial.printf("ADC on PB0: %d\n\r", adcval);
                   delay=delay+.05;
                   wait(.2);
          //////////////////////////////////////////////////////////////////         
                      // PWM fading green LED 2 //
                   for(double i=0.0; i<1.0;i=i+0.01)
                    {
                      GLED.write(i); // duty cycle changing
                      wait(.01);
                    }
              
                   for(double i=0.0; i<1.0;i=i+0.01)
                    {
                      GLED.write(1.0-i); // duty cycle changing
                      wait(.01);
                    }
                   }// end of if //   
            /////////////////////////////////////////////////////////////////
            // on board accerometer //  
            if(acc.Detect() != 1)
             {
              serial.printf("LIS3DSH acceromoter not detected!\n\r");
             }
             else
             {
              serial.printf("LIS3DSH acceromoter detected! , Reading now\n\r");
              acc.ReadData(&X, &Y, &Z);           // reads X, Y, Z values
              acc.ReadAngles(&roll, &pitch);      // reads roll and pitch angles
              serial.printf("X: %d  Y: %d  Z: %d\n\r", X, Y, Z);
              serial.printf("Roll: %f   Pitch: %f\n\r", roll, pitch);
              // divide raw value by 1750 to get acceleration in m/s^2 //
             }     
             ///////////////////////////////////////////////////////////////
  
     
                 
    }// end of while //
}// end of main
