#include "mbed.h"

DigitalOut led_red(LED_RED);
DigitalOut led_green(LED_GREEN);
DigitalIn sw2(SW2);
DigitalIn sw3(SW3);
Serial pc(USBTX, USBRX);

void check_sw2(void)
{
    if (sw2 == 0) {
        pc.printf("SW2 button pressed. \n");
        led_red = 0;
        led_green = 1;
    }
}

void check_sw3(void)
{
    if (sw3 == 0) {
        pc.printf("SW3 button pressed. \n");
        led_green = 0;
        led_red = 1;
        pc.printf("5 characters will be echoed. Start typing. \n");
        for (uint32_t i = 0; i < 5; i++) {
            pc.putc(pc.getc());
        }
        pc.putc(13); /* CR */
        pc.putc(10); /* LF */
    }
}

int main() {
    led_green = 1;
    led_red = 1;
    pc.baud(115200);
    pc.printf("Hello mbed from Xiao's FRDM-K64F board.\n");

    while (true) {
        check_sw2();
        check_sw3();
        wait(0.3);
    }
}
