/* mbed Microcontroller Library
 * Copyright (c) 2006-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "BLE.h"
#include "TMP_nrf51/TMP_nrf51.h"

#define APP_SPECIFIC_ID_TEST 0xFEFE

#pragma pack(1)
/* Advertising data  */
struct AdvertisingData_t {
    uint8_t length; /* doesn't include itself */
    GapAdvertisingData::DataType dataType;
    uint8_t data[1];
};

struct ApplicationData_t {
    uint16_t applicationSpecificId;             /* An ID used to identify temperature value
                                                   in the manufacture specific AD data field */
    TMP_nrf51::tmpSensorValue_t tmpSensorValue; /* User defined application data */
};
#pragma pack()

BLE        ble;
DigitalOut led1(LED1);

void periodicCallback(void)
{
    led1 = !led1; /* Do blinky on LED1 while we're waiting for BLE events */
}

void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params)
{
    AdvertisingData_t *pAdvData = NULL;
    uint8_t len = 0;
    
    /* Search for the manufacturer data */
    while(len < params->advertisingDataLen) {
        pAdvData = (AdvertisingData_t *)&params->advertisingData[len];
        if(pAdvData->dataType == GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA) {
            ApplicationData_t *pAppData = (ApplicationData_t *)pAdvData->data;
            if(pAppData->applicationSpecificId == APP_SPECIFIC_ID_TEST) {
                printf("From [%02x %02x %02x], ", params->peerAddr[2], params->peerAddr[1], params->peerAddr[0]);
                printf("Temp is %f\r\n", (float)pAppData->tmpSensorValue);
                break;
            }
        }
        len += (pAdvData->length + 1);
    }
}

int main(void)
{
    led1 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);

    ble.init();
    ble.gap().setScanParams(1800 /* scan interval */, 1500 /* scan window */);
    ble.gap().startScan(advertisementCallback);

    while (true) {
        ble.waitForEvent();
    }
}
