/***********************************************************************/
/******************************Prologue*********************************/
/*              University of California Santa Cruz Extension          */
/*                                                                     */
/*          Internet of Things                                         */
/*          Instructor: Avnish Aggarwal                                */
/*          Author: Sunil Aluri                                        */
/*          Assignment 4 part2a                                        */
/*                                                                     */
/*          File name: mbed_tcp_cookie_server_Sunil_Aluri.cpp          */
/*          Date:5/12/2014                                             */
/*          Objective: Develop a program to                            */
/*          fetch cookies,date from internet and send them to client   */
/*          each time it connects                                      */
/*          Comments: Since, I do not have two Mbed boards, used a     */
/*          telent client to get the server data                       */
/***********************************************************************/


#include "mbed.h"
#include "EthernetInterface.h"
#define ECHO_SERVER_PORT   7  // define the port which the clients can connect to 

// FetchCookies Class function is to , connect to a http web server and get the html header
// of the webiste, which contains Date and Set-Cookie fields.
class FetchCookies
{
private:
    char buffer[300],*key,*date,*cookie,*client_message;
    int ret;
    TCPSocketConnection sock; //create a socket for TCP connection on the server
public:
    FetchCookies() {  // initiate all the pointers and buffers
        ret=0;
        buffer[0]='\0';
        key =0;
        date=0;
        cookie=0;
        client_message=0;
    }
    ~FetchCookies() { // destructor that frees the memory allocated
        free(client_message);
    }


// getCookie method, connects to a website and requests header. It fetches the date and cookie
// part of the received header and sends out the information to the caller function.
    char* getCookie () {
        sock.connect("google.com", 80); // connect to the webserver
        //send the HEAD cmd to request header of the webpage
        char http_cmd[] = "HEAD http://www.google.com/ HTTP/1.0\r\n\r\n"; 
        sock.send_all(http_cmd, sizeof(http_cmd)-1);
        // receive the information from web server
        ret = sock.receive(buffer, sizeof(buffer)-1);
        // using strtok function, fetch for date and cookie part of header, which are
        //delimited by \n charecter
        if (ret > 0) {
            buffer[ret] = '\0';
            key = strtok(buffer,"\n");
            date = strtok(NULL,"\n");
            while(key!=NULL) {
                key=strtok(NULL,"\n");
                if(strstr(key,"Set")==NULL) {
                    continue;
                } else {
                    cookie =key;
                    break;
                }
            }
            // for string concatenation, assign memory
            client_message = (char*)malloc(strlen(date)+strlen(cookie)+1);
            // copy the date and cookie info into the message pointer
            sprintf(client_message,"%s\r\n%s",date,cookie);
        }
        //close the webserver connection
        sock.close();
        // send the TCP client message pointer.
        return(client_message);
    }
};


int main (void)
{
    /**** ether net interface definition begin *****/
    EthernetInterface eth; 
    eth.init(); //Use DHCP
    eth.connect();
    /**** ethernet interface definition end*******/
    FetchCookies FC; // create an object for Fetch Cookies class
    printf("\r\nIP Address is %s\n", eth.getIPAddress()); //print the server IP address
    TCPSocketServer server; //create a socket for server to listen to requests
    server.bind(ECHO_SERVER_PORT); // bind the port to server
    server.listen(); //listen for client requests
    char *client_info=0;
    //the following loop, listens for new connections, make them and send the response message to clients
    while (true) {
        printf("\r\nWait for new connection...\r\n");
        TCPSocketConnection client;

        server.accept(client); // accept the incoming connection
        client.set_blocking(false, 5500); // Timeout after (1.5)s
        client_info =FC.getCookie(); // fetch new cookie and date from webservers
        printf("Connection from: %s\r\n", client.get_address());
        if(client_info == 0)  // if no message was obtained, quit and start for new client connection 
            break;
        printf("Sending Data to client...\r\n"); // if webserver gives the cookies, send them to client.
        client.send_all(client_info,strlen(client_info));
        wait(5); 
        printf("Closing connection\r\n"); // after sending the message, close the connection
        client.close();
    }
    
}


