#include "mbed.h"
#include "TextLCD.h"
#include "NokiaLCD.h"
#include "SDFileSystem.h"

#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "NTPClient.h"

#include "spdomparser.hpp"
#include "spxmlnode.hpp"
#include "spxmlhandle.hpp"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
NokiaLCD lcd1(p11, p13, p14, p15, NokiaLCD::PCF8833);
//NokiaLCD lcd1(p11, p13, p14, p15, NokiaLCD::LCD3300);

SDFileSystem sd(p5, p6, p7, p8, "sd");
//LocalFileSystem local("sd");  

char filename[20];
char buf[3000];  
char lcdMsg[16];
int daySW = 0;

void parseWeather(SP_XmlElementNode *node) {
    lcd1.cls();
    SP_XmlHandle handle(node);

    SP_XmlElementNode * location = handle.getChild( "yweather:location" ).toElement();
    if (location) {
        lcd1.printf("Location:%s\n",location->getAttrValue("city"));
    }        
    
    SP_XmlElementNode * forecast;
    if( daySW == 0 )
        forecast = handle.getChild("item").getChild( "yweather:forecast",0).toElement();
    else
        forecast = handle.getChild("item").getChild( "yweather:forecast",1).toElement();

    if (forecast) {
        lcd1.printf("Condition:%s \n",forecast->getAttrValue("text"));
        sprintf(filename,"/sd/%s.bmp",forecast->getAttrValue("code"));
        lcd1.printf("Temp:Low%sC High%sC\n",forecast->getAttrValue("low"),forecast->getAttrValue("high"));
        lcd1.printf("Date:%s(%s)",forecast->getAttrValue("date"),forecast->getAttrValue("day"));
    }
}

int PrintIcon(void)
{
    FILE *fs;
    int i;
    char header[54];
    int rgb;
    unsigned char datr,datg,datb;    
           
    printf( "Weather icons access [%s]\r\n",filename);
    if ( NULL == (fs = fopen(filename, "rb" )) ) {
        printf( "file open error when oening file \r\n");
        return -1;
    }

    //bitmap headder throw  
    for (i=0;i<0x36;i++)
        fread(&header, sizeof(unsigned char), 1, fs);
    
                  
    for(int y=50;y>0;y--){
        for(int x=0;x<60;x++){       
            fread(&datb, sizeof(unsigned char), 1, fs);
            fread(&datg, sizeof(unsigned char), 1, fs);
            fread(&datr, sizeof(unsigned char), 1, fs);
            
            datb = (0xF0&datb)>>4;
            datg = (0xF0&datg)>>4; 
            datr = (0xF0&datr)>>4;
                        
            rgb = (datr <<20) | (datg<<12) | (datb<<4);
            lcd1.pixel(x+30,y+70,rgb);
        }
    }
    
    fclose(fs); 
 
    return 0;
}

void lcd_Update(void const *arg)
{
    while(true){    
        Thread::wait(15000);
        time_t ctTime = time(NULL)+32400; // JST
        strftime(lcdMsg,16,"%y/%m/%d %H:%M",localtime(&ctTime));
        lcd.locate(0,0);
        lcd.printf("[%s]",lcdMsg);
        printf("lcd_Update(%s)\r\n",lcdMsg);
    }        
}    

int main() {
    // the eth and HTTP code has be taken directly from the HTTPStream documentation page
    // see http://mbed.org/cookbook/HTTP-Client-Data-Containers
    EthernetInterface eth;
    NTPClient ntp;
    int retEth;
    HTTPClient http;  
    int retHttp;
    SP_XmlDomParser parser;
        
    printf("Setting up ...\r\n");
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Setting Up...");
    
    eth.init();
    retEth = eth.connect();
    
    lcd.locate(0,0);
    if (!retEth) {
        printf("Network Setup ok\r\n");
        lcd.printf("Network Setup OK");
    } else {
        printf("Network Error %d\r\n", retEth);
        lcd.printf("Network Error %d");
        return -1;
    }
     
    printf("Trying to update time...\r\n");
    if (ntp.setTime("ntp.nict.jp") == 0)
    {
      printf("Set time successfully\r\n");
    }
    else
    {
      printf("NTP Set Error\r\n");
    }      

    Thread thread0(lcd_Update);  
    
    while(true)
    {
        retHttp = http.get("http://weather.yahooapis.com/forecastrss?w=28426187&u=c", buf, sizeof(buf));
    
        lcd.locate(0,1);
        switch(retHttp){
        case HTTP_OK:
            printf("Read completely\r\n");
            lcd.printf("Read completely ");        
            break;
        case HTTP_TIMEOUT:
            printf("Connection Timeout\r\n");
            lcd.printf("Timeout         ");            
            break;
        case HTTP_CONN:
            printf("Connection Error\r\n");
            lcd.printf("Connection Error");
            break;;
        default:
            printf("Error\r\n");
            lcd.printf("Error           ");                           
        }        
        printf("\r\n-----%s-----\r\n%s\r\n",lcdMsg,buf);             

        parser.append( buf, strlen(buf)); // stream current buffer data to the XML parser
                
        SP_XmlHandle rootHandle( parser.getDocument()->getRootElement() );
        SP_XmlElementNode * child = rootHandle.getChild( "channel" ).toElement();
    
        if ( child ) {
            parseWeather(child);
        }
    
        if ( NULL != parser.getError() ) {
            printf( "\nerror: %s\n", parser.getError() );
        }
        
        PrintIcon();        
       
        if ( daySW == 0 )
            daySW = 1;
        else
            daySW = 0 ;
        printf("\r\nUpdateIcon%s\r\n",lcdMsg);  
        
        wait(120.0) ;
    }  
}
