#include "MySound.h"

MySound::MySound(PinName out) : _out(out){
    _out = 0;
}

void MySound::play(char pn,int s, char l)
{
    double freq,f;
    double scale ;
    float length ;
       
    switch(l){
        case 'W':
            length = 4 ;
            break ;
        case 't':
            length = 3;
            break ;
        case 'D':
            length = 2 ;
            break;  
        case 'Q':
            length = 1;
            break;
        case 'q':
            length = 1.5;
            break;
        case 'E':
            length = 0.5;
            break;
        case 'S':
            length = 0.25;
            break;           
        case 'T':
            length = 0.125;
            break;
        default:
            length = 1;
    }

    switch(pn){
        case 'a':  
            freq = 415.30469 ;
            break; 
        case 'A':
            freq = 440.0;
            break ;
        case 'b':
            freq = 466.16876;
            break;
        case 'B': 
            freq = 493.88330;
            break ;
        case 'C':
            freq = 261.62556;
            break ;
        case 'd': 
            freq = 277.18263;
            break ;
        case 'D':
            freq = 293.66476;
            break;
        case 'e':
            freq = 311.12698;
            break ;
        case 'E':
            freq = 329.62755;
            break ;
        case 'F':
            freq = 349.22823;
            break;
        case 'g':
            freq = 369.99442;
            break ;
        case 'G': 
            freq = 391.99543;
            break ;                                          
        case 'R':
            freq = 0.0;
            break ;                                                  
        default:
            freq = 440;
    }

    switch ( s ){
        case 6:
            f = freq * 4.0 ;
            break;
        case 5:
            f = freq * 2.0 ;
            break;
        case 4:
            f = freq;
            break;
        case 3: 
            f = freq / 2.0 ;
            break;
        case 2:
            f = freq / 4.0;
            break; 
        default:
            f = freq ;
        break ;
    }
    
    scale = 1.0/(2.0*f);
 
//    printf("scale=%lf\tf=%f\tfreq=%f\tlength=%lf\n",scale,f,freq,length);
//     printf("f*length=%lf\tfreq=%lf\t%lf \n",f*length,freq,scale);
    
        for(int i = 0 ; i <= (int)( f * length ) ; i++ ){
            _out = 1;
            wait(scale) ;
            _out = 0 ;
            wait(scale) ;
        }   
}