#include "mbed.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
#include "MySound.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
SDFileSystem sd(p5, p6, p7, p8, "sd") ;
MySound music(p21) ;  


int main() {
    char pitch ;
    int scale;
    char ln;
    FILE *fp;
    int n;
    
    if ( (fp = fopen("/sd/music.txt","r")) == NULL ) {
        printf("Open Failed. \n") ;
        return -1;
    }
    lcd.printf("Silent Night"); 
       
    while( (n = fscanf(fp,"%c %d %c ",&pitch,&scale,&ln)) != EOF ){
            printf("%d %c %d %c\n",n,pitch,scale,ln);
            music.play(pitch, scale, ln) ;
    } 
   
    fclose(fp) ;
}
