/**
 * Test program.
 *
 * CameraC328Library
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 *
 * CameraC1098-SS Library
 * Copyright (C) 2012 Tadao Iida
 */

/*
 * Include files.
 */

#include "mbed.h"
#include "CameraC1098.h"
#include "TextLCD.h"

/*
 * Definitions.
 */
TextLCD lcd(p24, p26, p27, p28, p29, p30);
CameraC1098 camera(p9, p10);

/*
 * Variables.
 */
PwmOut steering(p25) ;
PwmOut speed_in1(p22) ;
PwmOut speed_in2(p23) ;
Serial pc(p13,p14);

static char buf[256+1];
volatile char steer;

/**
 * A callback function for jpeg images.
 * You can block this function until saving the image datas.
 *
 * @param buf A pointer to the image buffer.
 * @param siz A size of the image buffer.
 */
void jpeg_callback(char *buf, size_t siz) {
    for (int i = 0; i < (int)siz; i++) {
        pc.putc(buf[i]) ;
    }
}

/**
 * Synchronizing.
 */
void sync(void) {
    CameraC1098::ErrorNumber err = CameraC1098::NoError;

    err = camera.sync();
    lcd.locate(0,0);
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::sync\r\n");
        lcd.printf("Camera Sync [OK]");
    } else {
        printf("[FAIL] : CameraC1098::sync (Error=%02X)\r\n", (int)err);
        lcd.printf("Camera init [NG]");
    }
}


/**
 * A test function for jpeg snapshot picture.
 */
void test_jpeg_snapshot_picture(void) {
    CameraC1098::ErrorNumber err = CameraC1098::NoError; 
    
    err = camera.getJpegSnapshotPicture(jpeg_callback);

    lcd.locate(0,0);        
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::getJpegSnapshotPicture\r\n");
        lcd.printf("Camera send [OK]");
    } else {
        printf("[FAIL] : CameraC1098::getJpegSnapshotPicture (Error=%02X)\r\n", (int)err);
        lcd.printf("Camera send [NG]");
    }
}

void  rxFunc(){
    steer = pc.getc();
}

int main() {
    float sp1, sp2;
    int st;
    
    wait(2.0) ;
    pc.attach(&rxFunc,Serial::RxIrq);
    
    printf("\r\n");
    printf("==========\r\n"); 
    printf("CameraC1098\r\n");
    printf("==========\r\n");
    CameraC1098::ErrorNumber err = CameraC1098::NoError;
    err = camera.init(CameraC1098::Baud115200, CameraC1098::JpegResolution160x128);
    camera.setmbedBaud( CameraC1098::Baud115200 );
    pc.baud(115200);
    
    
    lcd.locate(0,0);
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::init\r\n") ;
        lcd.printf("Camera init [OK]");
    } else {
        printf("[FAIL] : CameraC1098::init (Error=%02X)\r\n", (int)err) ;
        lcd.printf("Camera init[NG]");
        exit(-1);
    }
    // 
    sync(); 
    
    steering.period(0.020);
    speed_in1.period(0.1) ;
    speed_in2.period(0.1) ;
    
    while(1){
    
        lcd.locate(0,1);
        switch(steer){
            case 'S':
                lcd.printf("pictshort       ");
                test_jpeg_snapshot_picture();
                break;                    
            case '0':
                lcd.printf("                ");
                st = 1500;
                sp1 = 0.0f ;
                sp2 = 0.0f ; 
                break;
            case '1':
                lcd.printf("FORWARD         ");   
                st = 1500;
                sp1 = 0.7f ;
                sp2 = 0.0f ; 
                break;
            case '2':
                lcd.printf("BACK            ");
                st = 1500;
                sp1 = 0.0f ;
                sp2 = 0.7f ;
                break;   
            case '6':
                lcd.printf("FORWARD+LEFT    ");
                st = 1200;
                sp1 = 0.7f ;
                sp2 = 0.0f ;
                break;   
            case '7':
                lcd.printf("FORWARD+RIGHT   ");
                st = 1800;
                sp1 = 0.7f ;
                sp2 = 0.0f ;
                break;   
            case 'A':
                lcd.printf("BACK+LEFT       ");
                st = 1200;
                sp1 = 0.0f ;
                sp2 = 0.7f ;
                break;   
            case 'B':
                lcd.printf("BACK+RIGHT      ");
                st = 1800;
                sp1 = 0.0f ;
                sp2 = 0.7f ;
                break;                                                                   
            case 'F':
                lcd.printf("STOP            ");  
                st = 1500;
                sp1 = 0.0 ;
                sp2 = 0.0 ;
            break;
            default:
                lcd.printf("                ");
                st = 1500;
                sp1 = 0.0 ;
                sp2 = 0.0 ;
        }   
        steering.pulsewidth_us(st);
        speed_in1.write(sp1) ;
        speed_in2.write(sp2) ;   
    }
                
}
