#include "mbed.h"
#include "TextLCD.h"

AnalogIn in(p20);
AnalogOut out(p18) ;
TextLCD lcd(p24, p26, p27, p28, p29, p30) ;
Ticker input;
float now, old = 0.0 ;

void run(void);
int main() {
    input.attach(&run,0.5);  
    while(1) {

    }
}

void run(void)
{
    float data;
    old = now ;
    now = in ;
    
    data = (now +old)/2.0 ;
    lcd.locate(0,0) ;
    if (0.121 <= data && data <= 0.970){
        float range = 25.33 * pow((data*3.3),-1.21);
        lcd.printf("Range: %4.1f[cm]",range) ;
        out = 0.5;
    }else{
       lcd.printf("Range: ----[cm]");
       out = 1.0;
    }
}
