#include "mbed.h"
#include "TextLCD.h"

#define THR 200

enum SignalMode{NOT_USED,FORWARD,BACK,LEFT,RIGHT,DASH_FORWARD,FORWARD_LEFT,FORWARD_RIGHT,DASH_FORWARD_LEFT,
            DASH_FORWARD_RIGHT,BACK_LEFT,BACK_RIGHT,DASH_BACK,DASH_BACK_LEFT,DASH_BACK_RIGHT, STOP};
SignalMode STAT;    

int steering;        
int signal;

InterruptIn event(p21) ; 

TextLCD lcd(p24, p26, p27, p28, p29, p30);
BusOut myleds(LED1,LED2,LED3,LED4);

int bitCnt = 0;
Timer timer;
int begin,end,interval;

void tStart()
{
    interval = 0;
    begin = timer.read_us();
}

void tEnd()
{
    end = timer.read_us();
    interval = end - begin ;
    timer.reset();  
    
    if( 2000 - THR < interval && interval < 2000 + THR ){
        bitCnt = 0 ;
        signal = 0;
    }else if ( 500 -THR < interval && interval < 500 + THR ){
        signal <<= 1;
        bitCnt++;
    }else if ( 1000 -THR < interval && interval < 1000 + THR ){
        signal <<= 1;
        signal++;
        bitCnt++;       
    }   
}

int main() {
    int data = 0;
    timer.start() ;
    event.fall(&tStart) ;
    event.rise(&tEnd) ;

    while(1) {
        if ( bitCnt == 6){ 
            data = signal;
            lcd.locate(0,0);
            lcd.printf("%3d",data);
            lcd.locate(4,0);
            lcd.printf("%d%d",(data&0x20)?1:0,(data&0x10)?1:0);
            lcd.printf("%d%d%d%d",(data&0x08)?1:0,(data&0x04)?1:0,(data&0x02)?1:0,(data&0x01)?1:0);
            lcd.locate(0,1);

            if ( data < 16 )
                lcd.printf("CH A");
            else if ( data < 32 )
                lcd.printf("CH B");
            else if ( data < 48)
                lcd.printf("CH C");           
            else if ( data < 64)
                lcd.printf("CH D");

            steering = (int)(data&0x0F) ;    
            lcd.locate(5,1);
            switch(steering){
                case LEFT:
                    lcd.printf("LEFT     ");
                    myleds = 0x01;
                    break;
                case RIGHT:
                    lcd.printf("RIGHT    ");
                    myleds = 0x08;
                    break;
                case FORWARD:
                    lcd.printf("FORWARD");    
                    break;
                case BACK:
                    lcd.printf("BACK     ");
                    break;
                case DASH_FORWARD:
                    lcd.printf("DASH_FOR ");
                    break;
                case DASH_BACK:
                    lcd.printf("DASH_BACK");
                    break;    
                case STOP:
                    lcd.printf("STOP     ");    
                    wait_ms(50);
                    lcd.cls();
                    myleds =0x00;
            }    
        }
    }
}   
