#include "mbed.h"
#include "TextLCD.h"

AnalogIn  in(p20);       
AnalogOut out(p18);   
DigitalIn playsw(p21) ;
DigitalIn recordsw(p22);

DigitalOut led1(LED1); 
DigitalOut led4(LED4); 

TextLCD lcd(p24, p26, p27, p28, p29, p30);

#define N 13000
unsigned short buf[N];

void read(void) {
    int i;
    for ( i = 0 ; i < N ; i++ ){
        buf[i] = in.read_u16();
        wait(0.0002);  
    }    
}    

void write(void) {
    int i;
    for ( i = 0 ; i < N ; i++ ){
        out.write_u16(buf[i]) ;
        wait(0.0002);
    }            
}    


int main() {
    while(1) {
        if ( recordsw == 1 ){
            lcd.locate(0,0) ;
            lcd.printf(" --- Record --- ");        
            led1 = 1;
            read() ;
            led1 = 0;
            lcd.cls( ) ;
        }         
        if ( playsw == 1 ){
            lcd.locate(0,0) ;
            lcd.printf("  --- Play ---  ");
            led4 = 1 ;
            write();
            led4 = 0 ;
            lcd.cls( ) ;
        }
    }
}
