#include "mbed.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"

int main() {

    EthernetNetIf eth;   // (1)  -- DHCP
//    EthernetNetIf eth( // (2)  -- static IP address 
//        IpAddr(192,168,0,2),     // IP Address
//        IpAddr(255,255,255,0),   // Subnet Mask
//        IpAddr(192,168,0,1),     // Default Gateway
//        IpAddr(192,168,0,1)      // DNS Server
//    ) ;
   UDPSocket udp;
   char msg[64] ;
   Timer tmr;
   int i = 1 ;

   printf("Setting up...\r\n");

   EthernetErr ethErr = eth.setup();

   if( ethErr != ETH_OK )
   {
       printf("Error %d in setup.\r\n", ethErr);
       return -1;
   }

   printf("Setup OK\r\n");

   Host host(IpAddr(192,168,0,3), 12345, NULL); 

   udp.bind(host);

   tmr.start();

   while(true)
   {
       Net::poll();

       if(tmr.read() > 5){
           tmr.reset();
 
           if ( i % 5 != 0 ){
	           sprintf(msg, "No.%3d --- Hello World! ---\r\n",i);
               udp.sendto( msg, strlen(msg), &host );
               printf("%s\r\n", msg);  
           }else{
               sprintf(msg, "No.%3d --- End! ---\r\n",i);
               udp.sendto( msg, strlen(msg), &host );
               printf("%s\r\n", msg);
           }
           i++;
       }
   }
}