#include "mbed.h"
#include "EthernetInterface.h"
#include "TextLCD.h"

#define SERVER_ADDRESS "192.168.0.7"
#define SERVER_PORT 55555

TextLCD lcd(p24,p26,p27,p28,p29,p30);

AnalogIn ud(p19);
AnalogIn lr(p20);

UDPSocket client;
Endpoint DataServer;
float udData,lrData;
char ipaddr[15];

unsigned int cnt = 1;

void sendData(void const *arg)
{
    char out_buffer[42];
    
    while(true)
    {
        Thread::wait(1000);
        
        sprintf(out_buffer,"%s,%u,%.2f,%.2f,",ipaddr,cnt,udData,lrData);
        
        client.sendTo(DataServer, out_buffer, sizeof(out_buffer)) ;
        
        printf("Send Data[%s]\r\n",out_buffer);
        
        lcd.locate(0,1);
        lcd.printf("UD%0.2f : LR%0.2f",udData,lrData);
        
        cnt++;
    }
}

int main() {
    EthernetInterface eth;
    
    eth.init();
    
    eth.connect();
    
    client.init();
    
    DataServer.set_address(SERVER_ADDRESS, SERVER_PORT);
    sprintf(ipaddr,"%s",eth.getIPAddress());
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%s",ipaddr);
    
    Thread thread(sendData);
    while(1) {
        udData = ud;
        lrData = lr;
    }
}
