#include "mbed.h"
#include "EthernetNetIf.h"
#include "UDPSocket.h"
#include "NTPClient.h"
#include "TextLCD.h"

#define PORT 50001
#define LOCATION 1000

TextLCD lcd(p24, p26, p27, p28, p29, p30);
AnalogIn temp_in(p20);
AnalogIn humid_in(p19);

Host server;
IpAddr ip;
UDPSocket udp;
NTPClient ntp;

Ticker  in;

void Update(){
    char msg[64] ;
    float r_temp, r_humid;
    float temp,humid;
    char strTimeMsg[16];
    time_t ctTime;
    
    temp = temp_in;
    humid = humid_in;
    
    r_humid = humid * 3.3 * 100 ;   
    r_temp  =  temp * 55.0  ;

    ctTime = time(NULL)+32400;
    strftime(strTimeMsg,16,"%y/%m/%d %H:%M",localtime(&ctTime));

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%s",strTimeMsg);

    lcd.locate(0,1);    
    lcd.printf("H%5.1f%% T%5.1f",r_humid,r_temp);

    lcd.locate(14,1);
    lcd.putc(0xDf); 
    lcd.putc(0x43);
      
    ctTime = time(NULL)+32400;
    strftime(strTimeMsg,16,"%y/%m/%d %H:%M",localtime(&ctTime));      
    sprintf(msg, "%4d\t,%6.2f\t,%6.2f\t,",LOCATION,r_temp,r_humid);
    strcat(msg,strTimeMsg);
    udp.sendto( msg, strlen(msg), &server );
    printf("%s\r\n",msg);
}

void setRTC_NTP()
{
    char strNtpErrMsg[32] ; 
    
    Host ntpsrv(IpAddr(), 123, "ntp.nict.jp") ;
    NTPResult ntpResult = ntp.setTime(ntpsrv) ;
    
    if( ntpResult == NTP_OK ){
        sprintf(strNtpErrMsg,"NTP Connect OK!");
    }else if ( ntpResult == NTP_PRTCL ){
        sprintf(strNtpErrMsg,"NTP Protocol error.") ;
    }else if ( ntpResult == NTP_TIMEOUT ){
        sprintf(strNtpErrMsg,"Connection timeout.");  
    }else if ( ntpResult == NTP_DNS ){
        sprintf(strNtpErrMsg,"Could not resolve DNS hostname.") ;
    }else if ( ntpResult == NTP_PROCESSING ){
        sprintf(strNtpErrMsg,"Processing.");
    }else{
        sprintf(strNtpErrMsg,"NTP Error.");
    }
    printf("[%s]\r\n",strNtpErrMsg);
}

int main() {
    
    char ipaddr[16];

    EthernetNetIf eth;   // (1)  -- DHCP
//    EthernetNetIf eth( // (2)  -- static IP address 
//        IpAddr(192,168,0,10),     // IP Address
//        IpAddr(255,255,255,0),   // Subnet Mask
//        IpAddr(192,168,0,1),     // Default Gateway
//        IpAddr(192,168,0,1)      // DNS Server
//    ) ;

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("NW Setup ...    ");

    EthernetErr ethErr = eth.setup();

    if( ethErr != ETH_OK )
    {
        lcd.locate(0,0);
        lcd.printf("NW Setup Error! ", ethErr);
        return -1;
    }
    
    lcd.locate(0,0);
    lcd.printf("NW Setup ...[OK]");
  
//    ip = IpAddr(192,168,0,4);
    ip = IpAddr(192,244,80,66);
    server = Host(ip, PORT, NULL); 

    lcd.locate(0,1);    
    sprintf(ipaddr,"%d.%d.%d.%d ",ip[0],ip[1],ip[2],ip[3]);    
    lcd.printf("%s",ipaddr);
    wait(1.0);
 
    setRTC_NTP();
  
    in.attach(&Update,10);        

    while(true)
    {
        Net::poll();
    }
}
