#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "TextLCD.h"

#define TCP_LISTENING_PORT 50505

BusOut myleds(LED1, LED2, LED3, LED4);
TextLCD lcd(p24, p26, p27, p28, p29, p30);

void onTCPSocketEvent(TCPSocketEvent e) ;
void onConnectedTCPSocketEvent(TCPSocketEvent e) ;

EthernetNetIf eth ;   
TCPSocketErr tcpErr ;
TCPSocket tcpSock ;
TCPSocket* pConnectedSock ;
Host client ;

int main() {
    lcd.locate(0,0);
    lcd.printf("Setting up...");    
    EthernetNetIf eth; //(1)
    //EthernetNetIf eth( // (2)  -- static IP address 
    //    IpAddr(192,168,0,6),     // IP Address
    //    IpAddr(255,255,255,0),   // Subnet Mask
    //    IpAddr(192,168,0,1),     // Default Gateway
    //    IpAddr(192,168,0,1)      // DNS Server
    //) ;    
    
    EthernetErr ethErr = eth.setup(); 
    if( ethErr != ETH_OK )
    {
        lcd.locate(0,0);   
        printf("Error %d in setup.\r\n", ethErr);
        lcd.printf("NW Setup Error!", ethErr);
        return -1;
    }
    lcd.locate(0,0);
    lcd.printf("Setup OK     ");
    printf("Setup OK\r\n");
    
    IpAddr ip = eth.getIp() ;
 
    lcd.locate(0,1);
    lcd.printf("%d.%d.%d.%d",ip[0],ip[1],ip[2],ip[3]);
    
    printf("mbed IP Address is [%d.%d.%d.%d]\r\n", ip[0], ip[1], ip[2], ip[3]) ;
        
    tcpSock.setOnEvent(&onTCPSocketEvent) ;
    
    printf("Bindding...\r\n") ;
    tcpErr = tcpSock.bind(Host(IpAddr(), TCP_LISTENING_PORT));
    if ( tcpErr != ETH_OK ){
        printf("Bindding Error.\r\n") ;
        return -1 ;
    }
    
    printf("Listen...\r\n");
    tcpErr = tcpSock.listen() ;
    if ( tcpErr != ETH_OK ){
        printf("Listen Error.\r\n") ;
        return -1 ;
    }
   
    while(1) {
        Net::poll();       
    }
}

void onTCPSocketEvent(TCPSocketEvent e)
{
    printf("---IN TCPSocketEvent ---\r\n");
    
    if ( e == TCPSOCKET_ACCEPT ){
        printf("Listening: TCP Socket Accepted\r\n");
        tcpErr=tcpSock.accept(&client, &pConnectedSock);

        if ( tcpErr != TCPSOCKET_OK ) {
            printf("onTcpSocketEvent Error \r\n");
            return; 
        }
        pConnectedSock->setOnEvent(&onConnectedTCPSocketEvent);
        IpAddr clientIp = client.getIp();
        printf("Controler IP Address is [%d.%d.%d.%d].\r\n", 
            clientIp[0], clientIp[1], clientIp[2], clientIp[3]);
    }
    printf("--- OUT TCPSocketEvent ---\r\n\r\n") ;
 }

void onConnectedTCPSocketEvent(TCPSocketEvent e)
{
    printf("--- IN ConnectEvent ---\r\n");
    char buf[128] ;
    
    switch(e)
    {
        case TCPSOCKET_CONNECTED:
            printf("Connected to host.\r\n") ;
            break;
        case TCPSOCKET_WRITEABLE:
            printf("Can write data to buf.\r\n");
            break;
        case TCPSOCKET_READABLE:
            printf("Data in buf.\r\n");
            pConnectedSock->recv(buf,sizeof(buf)) ;
            printf("n = %s\r\n",buf) ;
            myleds = atoi(buf) ;
            break;
        case TCPSOCKET_CONTIMEOUT:
            printf("Connection timed out.\r\n");
            break ;
        case TCPSOCKET_CONRST:
            printf("Connection was reset by remote host.\r\n");
            break ;
        case TCPSOCKET_CONABRT:
            printf("Connection was aborted.\r\n") ; 
            break ;
        case TCPSOCKET_ERROR:
            printf("Unknown error.\r\n") ;
            break ;
         case TCPSOCKET_DISCONNECTED:
            printf("Tcp Socket Disconnected\r\n") ;
            pConnectedSock->close() ;
            break;   
    }
    printf("--- OUT ConnectEvent ---\r\n\r\n");
}