/*
#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "TextLCD.h"

typedef enum { OFF, ON } state;

#define TCP_LISTENING_PORT 50001
#define HEADER 2
#define CHA_INTERVAL1 130 // 130
#define CHA_INTERVAL2 10  // 10
#define CHB_INTERVAL1 110 // 130
#define CHB_INTERVAL2 30  // 10
#define CHC_INTERVAL1 90 // 130
#define CHC_INTERVAL2 50  // 10
#define CHD_INTERVAL1 70  // 130
#define CHD_INTERVAL2 70  // 10

TextLCD lcd(p24, p26, p27, p28, p29, p30);
PwmOut out(p21);
BusOut myleds(LED1, LED2, LED3, LED4);

void onTCPSocketEvent(TCPSocketEvent e) ;
void onConnectedTCPSocketEvent(TCPSocketEvent e) ;

EthernetNetIf eth ;   
TCPSocketErr tcpErr ;
TCPSocket tcpSock ;
TCPSocket* pConnectedSock ;
Host client ;
int handle,band,data;

typedef void (*FUNCPTR)();
FUNCPTR pFuncBand;
// Remote Control Signal ON
void on(){
    int begin;
    Timer ton;
    ton.start();
    begin = ton.read_us();
    while ( 500 > ton.read_us() - begin )
        out.write(0.0f) ;
    begin = ton.read_us();  
    while ( 1000 > ton.read_us() - begin )
        out.write(0.5f) ;
    ton.stop();
}

// Remote Control Signal OFF
void off(){
    int begin;
    Timer toff;
    toff.start();
    begin = toff.read_us();
    while( 500 > toff.read_us() - begin )
        out.write(0.0f) ;
   
    begin = toff.read_us();
    while ( 500 > toff.read_us() - begin )
        out.write(0.5f) ;
    toff.stop() ;    
}

int flag=0;
void tail()
{
    out.write(0.0f) ; 
    flag = 0;
}

void bandA(){
    off();off();
}
void bandB(){
    off();on();    
}
void bandC(){
    on();off();    
}
void bandD(){
    on();on();  
}       
Timer timer;
volatile int psw = 0;

void interval(int iTime,state s){
    float signal;
    int t;
    signal = (s==OFF)? 0.0f : 0.5f; 
    timer.start();
    t = timer.read_ms();
    while ( iTime > timer.read_ms() - t )
        out.write(signal) ;
    timer.stop();                        
}

int interval1, interval2;

int main() {
   
    printf("Setting up...\r\n");   
    lcd.locate(0,0); 
    lcd.printf("Setting up...");
    EthernetErr ethErr = eth.setup();
    if( ethErr != ETH_OK )
    {
        printf("Error %d in setup.\r\n", ethErr);
        lcd.locate(0,0);
        lcd.printf("NW Setup Error! ", ethErr);        
        return -1;
    }
    printf("Setup OK\r\n");
    lcd.locate(0,0);
    lcd.printf("Setup OK     ");
    wait(1.5);
    
    IpAddr ip = eth.getIp() ;
//    EthernetNetIf eth( // (2)  -- static IP address 
//        IpAddr(192,168,0,2),     // IP Address
//        IpAddr(255,255,255,0),   // Subnet Mask
//        IpAddr(192,168,0,1),     // Default Gateway
//        IpAddr(192,168,0,1)      // DNS Server
//    ) ;

    
    printf("mbed IP Address is [%d.%d.%d.%d]\r\n", ip[0], ip[1], ip[2], ip[3]) ;
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%d.%d.%d.%d",ip[0], ip[1], ip[2], ip[3]);
    lcd.locate(0,1);
    lcd.printf("PORT[%5d]",TCP_LISTENING_PORT);
    wait(3.0);
        
    tcpSock.setOnEvent(&onTCPSocketEvent) ;
    
    printf("Bindding...\r\n") ;
    tcpErr = tcpSock.bind(Host(IpAddr(), TCP_LISTENING_PORT));
    if ( tcpErr != ETH_OK ){
        printf("Bindding Error.\r\n") ;
        return -1 ;
    }
    
    printf("Listen...\r\n");
    tcpErr = tcpSock.listen() ;
    if ( tcpErr != ETH_OK ){
        printf("Listen Error.\r\n") ;
        return -1 ;
    }
    lcd.cls();
    out.period_us(26);
    while(1) {
        Net::poll();  
        
        band = (data&0x30)>>4;
       
        lcd.locate(0,0);
        if(band == 0 ){
            lcd.printf("BAND [A]");
            (pFuncBand) = &bandA;
            interval1 = CHA_INTERVAL1;
            interval2 = CHA_INTERVAL2;        
        }else if(band == 1){
            lcd.printf("BAND [B]");
            (pFuncBand) = &bandB;
            interval1 = CHB_INTERVAL1;
            interval2 = CHB_INTERVAL2;        
        }else if(band == 2){
            lcd.printf("BAND [C]");
            pFuncBand = &bandC;
            interval1 = CHC_INTERVAL1;
            interval2 = CHC_INTERVAL2;        
        }else{
            lcd.printf("BAND [D]"); 
            pFuncBand = &bandD;
            interval1 = CHD_INTERVAL1;
            interval2 = CHD_INTERVAL2;
        }              
       
        lcd.locate(0,1);
        handle = data&0x0F;
        if ( handle == 6){
            // Forward + Left
            lcd.printf("Forward+Left    ");
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)();  
            off(); on(); on(); off();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();    
            off(); on(); on(); off();            
            tail();
        }else if( handle == 7){
            // Forward + Right
            lcd.printf("Forward+Right   ");
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)(); 
            off(); on(); on(); on();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();   
            off(); on(); on(); on();
            tail();                                  
        }else if( handle == 10 ){
            // Backward+Left(1010)
            lcd.printf("Backward+Left   ");
            (pFuncBand)();
            interval(HEADER,ON);
            (pFuncBand)();    
            on(); off(); on(); off();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();     
            on(); off(); on(); off();
            tail();                      
        }else if ( handle == 11 ){
            // Backward + Right (1011)
            lcd.printf("Backward+Right  ");
            interval(interval1,OFF);
            interval(HEADER,ON);
            (pFuncBand)(); 
            on(); off(); on(); on();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();  
            on(); off(); on(); on(); 
            tail();                    
        }else if( handle == 1 ){
            // Forward(0001)
            lcd.printf("Forward         ");            
            interval(interval1,OFF);    
            interval(HEADER,ON);
            (pFuncBand)();   
            off();off();off();on();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();     
            off();off();off();on();            
            tail();
        }else if( handle == 2 ){
            // Backward(0010)
            lcd.printf("Backward        ");
            interval(interval1,OFF);   
            interval(HEADER,ON);
            (pFuncBand)();   
            off();off();on();off();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();     
            off();off();on();off();
            tail();                              
        }else if( handle == 3 ){
            // Left(0011)
            lcd.printf("Left <=          ");            
            interval(interval1,OFF);      
            interval(HEADER,ON);
            (pFuncBand)();  
            off();off();on();on();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();
            off();off();on();on(); 
            tail();                      
       }else if( handle == 4 ){
            // Right(0100)
            lcd.printf("Right =>        ");            
            interval(interval1,OFF);      
            interval(HEADER,ON);
            (pFuncBand)();
            off();on();off();off();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();
            off();on();off();off();
            tail();            
        }else if( handle == 15 ){
            if ( flag == 0 ){
               for ( int i = 0; i < 5 ; i++ ){
                   // STOP(1111)
                   lcd.locate(0,1);
                   lcd.printf("Stop            ");            
                   interval(interval1,OFF);      
                   interval(HEADER,ON);
                   (pFuncBand)();   
                   on();on();on();on();
                   interval(interval2,OFF);
                   interval(HEADER,ON);
                   (pFuncBand)();
                    on();on();on();on();
                }
                flag = 1;
            }else{
                out.write(0.0f) ;
                myleds = 0;
                data = 0;
                lcd.locate(0,1);
                lcd.printf("                ");    
            }                       
        }                              
    }
}

void onTCPSocketEvent(TCPSocketEvent e)
{ 
    if ( e == TCPSOCKET_ACCEPT ){
        tcpErr=tcpSock.accept(&client, &pConnectedSock);

        if ( tcpErr != TCPSOCKET_OK ) {
            return; 
        }
        pConnectedSock->setOnEvent(&onConnectedTCPSocketEvent);
        IpAddr clientIp = client.getIp();
    }
 }

void onConnectedTCPSocketEvent(TCPSocketEvent e)
{
    char buf[128] ;
    
    switch(e)
    {
        case TCPSOCKET_READABLE:
            pConnectedSock->recv(buf,sizeof(buf)) ;
            myleds = atoi(buf) ;
            data = atoi(buf);       
            break;
         case TCPSOCKET_DISCONNECTED:
            pConnectedSock->close() ;
            break;   
    }
}
*/


#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"
#include "TextLCD.h"

// ԊOR̃vÔ܂ܗp
typedef enum { OFF, ON } state;

#define TCP_LISTENING_PORT 50001
#define HEADER 2
#define CHA_INTERVAL1 130 // 130
#define CHA_INTERVAL2 10  // 10
#define CHB_INTERVAL1 110 // 130
#define CHB_INTERVAL2 30  // 10
#define CHC_INTERVAL1 90 // 130
#define CHC_INTERVAL2 50  // 10
#define CHD_INTERVAL1 70  // 130
#define CHD_INTERVAL2 70  // 10

TextLCD lcd(p24, p26, p27, p28, p29, p30);
PwmOut out(p21);
BusOut myleds(LED1, LED2, LED3, LED4);

void onTCPSocketEvent(TCPSocketEvent e) ;
void onConnectedTCPSocketEvent(TCPSocketEvent e) ;

EthernetNetIf eth ;   
TCPSocketErr tcpErr ;
TCPSocket tcpSock ;
TCPSocket* pConnectedSock ;
Host client ;
int handle,band,data;

typedef void (*FUNCPTR)();
FUNCPTR pFuncBand;

int flag=0;
Timer timer;
int interval1, interval2;

// ̕ӂԊOR̃vÔ܂ܗp
// ԊORON̐Mo͂֐
void on(){
    int begin;
    Timer ton;
    ton.start();
    begin = ton.read_us();
    while ( 500 > ton.read_us() - begin )
        out.write(0.0f) ;
    begin = ton.read_us();  
    while ( 1000 > ton.read_us() - begin )
        out.write(0.5f) ;
    ton.stop();
}

// ԊOROFF̐Mo͂֐
void off(){
    int begin;
    Timer toff;
    toff.start();
    begin = toff.read_us();
    while( 500 > toff.read_us() - begin )
        out.write(0.0f) ;
   
    begin = toff.read_us();
    while ( 500 > toff.read_us() - begin )
        out.write(0.5f) ;
    toff.stop() ;    
}

// Mo͂Ȃ߂̏
void tail()
{
    out.write(0.0f) ; 
    flag = 0;
}

// oh̐Mo͂֐
void bandA(){
    off();off();
}
void bandB(){
    off();on();    
}
void bandC(){
    on();off();    
}
void bandD(){
    on();on();  
}       

// wb_o͂Ԃ̐Mo͂֐
void interval(int iTime,state s){
    float signal;
    int t;
    signal = (s==OFF)? 0.0f : 0.5f; 
    timer.start();
    t = timer.read_ms();
    while ( iTime > timer.read_ms() - t )
        out.write(signal) ;
    timer.stop();                        
}

// قƂǂO쐬TCPʐM̃vOƓ
// Ⴄ̂ while̒Ńp\R瑗Ă
// MɂāAԊOLEDo͂Mς邾
int main() {
   
    printf("Setting up...\r\n");   
    lcd.locate(0,0); 
    lcd.printf("Setting up...");
    EthernetErr ethErr = eth.setup();
    if( ethErr != ETH_OK )
    {
        printf("Error %d in setup.\r\n", ethErr);
        lcd.locate(0,0);
        lcd.printf("NW Setup Error! ", ethErr);        
        return -1;
    }
    printf("Setup OK\r\n");
    lcd.locate(0,0);
    lcd.printf("Setup OK     ");
    wait(1.5);
    
	IpAddr ip = eth.getIp() ;
    
    printf("mbed IP Address is [%d.%d.%d.%d]\r\n", ip[0], ip[1], ip[2], ip[3]) ;
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%d.%d.%d.%d",ip[0], ip[1], ip[2], ip[3]);
    lcd.locate(0,1);
    lcd.printf("PORT[%5d]",TCP_LISTENING_PORT);
    wait(3.0);
        
    tcpSock.setOnEvent(&onTCPSocketEvent) ;
    
    printf("Bindding...\r\n") ;
    tcpErr = tcpSock.bind(Host(IpAddr(), TCP_LISTENING_PORT));
    if ( tcpErr != ETH_OK ){
        printf("Bindding Error.\r\n") ;
        return -1 ;
    }
    
    printf("Listen...\r\n");
    tcpErr = tcpSock.listen() ;
    if ( tcpErr != ETH_OK ){
        printf("Listen Error.\r\n") ;
        return -1 ;
    }
    lcd.cls();
    out.period_us(26);
    while(1) {
        Net::poll();  
        
        // p\R瑗Mꂽp̃f[^́Aϐdataɓ͂B
        // ȍ~data̐M͂āAbandis̃f[^o͂
        
        // data5-6bitBANDMo
        band = (data&0x30)>>4;
              
        lcd.locate(0,0);
        if(band == 0 ){
            lcd.printf("BAND [A]");
            (pFuncBand) = &bandA;
            interval1 = CHA_INTERVAL1;
            interval2 = CHA_INTERVAL2;        
        }else if(band == 1){
            lcd.printf("BAND [B]");
            (pFuncBand) = &bandB;
            interval1 = CHB_INTERVAL1;
            interval2 = CHB_INTERVAL2;        
        }else if(band == 2){
            lcd.printf("BAND [C]");
            pFuncBand = &bandC;
            interval1 = CHC_INTERVAL1;
            interval2 = CHC_INTERVAL2;        
        }else{
            lcd.printf("BAND [D]"); 
            pFuncBand = &bandD;
            interval1 = CHD_INTERVAL1;
            interval2 = CHD_INTERVAL2;
        }              
       
        // datả4bitis̃f[^o
        lcd.locate(0,1);
        handle = data&0x0F;
        
        // handle̒lɂāAo͂𐶐B
        // ̏͑OiƌiA~3ɂB
        // ̏͊FŒǉĂB
        // ͈̕ȑO쐬`Q̃vÔ܂ܗpł܂B
        
		if( handle == 1 ){
			myleds = handle;
            // Forward(0001) Oȉ
            lcd.printf("Forward         ");            
            interval(interval1,OFF);    
            interval(HEADER,ON);
            (pFuncBand)();   
            off();off();off();on();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();     
            off();off();off();on();            
            tail();
        }else if( handle == 2 ){
        	myleds = handle;
            // Backward(0010) ȉ
            lcd.printf("Backward        ");
            interval(interval1,OFF);   
            interval(HEADER,ON);
            (pFuncBand)();   
            off();off();on();off();
            interval(interval2,OFF);
            interval(HEADER,ON);
            (pFuncBand)();     
            off();off();on();off();
            tail();                              
        }else if( handle == 15 ){
            if ( flag == 0 ){
               myleds = handle;
               for ( int i = 0; i < 5 ; i++ ){
                   // STOP(1111) ~̏
                   lcd.locate(0,1);
                   lcd.printf("Stop            ");            
                   interval(interval1,OFF);      
                   interval(HEADER,ON);
                   (pFuncBand)();   
                   on();on();on();on();
                   interval(interval2,OFF);
                   interval(HEADER,ON);
                   (pFuncBand)();
                    on();on();on();on();
                }
                flag = 1;
            }else{
                out.write(0.0f) ;
                myleds = 0;
                data = 0;
                lcd.locate(0,1);
                lcd.printf("                ");    
            }                       
        }                              
    }
}

// ̓Cxg啝ɍ폜B
void onTCPSocketEvent(TCPSocketEvent e)
{ 
    if ( e == TCPSOCKET_ACCEPT ){
        tcpErr=tcpSock.accept(&client, &pConnectedSock);

        if ( tcpErr != TCPSOCKET_OK ) {
            return; 
        }
        pConnectedSock->setOnEvent(&onConnectedTCPSocketEvent);
        IpAddr clientIp = client.getIp();
    }
 }

// łKvȂȃCxg폜
void onConnectedTCPSocketEvent(TCPSocketEvent e)
{
    char buf[128] ;
    
    switch(e)
    {
        case TCPSOCKET_READABLE:
            pConnectedSock->recv(buf,sizeof(buf)) ;
            // p\R瑗Ăf[^int^ɕϊ
            data = atoi(buf);       
            break;
         case TCPSOCKET_DISCONNECTED:
            pConnectedSock->close() ;
            break;   
    }
}
