// -- SimpleSMTPClient_HelloWorld.cpp --
// Used EthernetInterface Library
// Don't support TSL/SSL.
#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "SimpleSMTPClient.h"
#include "TextLCD.h"

#define DOMAIN "DOMAIN"
#define SERVER "smtp.mailserver.domain"
#define PORT "25" //25 or 587,465(OutBound Port25 Blocking )
#define USER "user-id"
#define PWD "password"
#define FROM_ADDRESS "user-id@domain"
// TO_ADDRESS (Of some address is possible.)
// to-user1@domain, to-user2@domain, to-user3@domain ....
// The TO_ADDRESS are less than 128 characters.
#define TO_ADDRESS "to-user@domain" 

#define SUBJECT "Test Mail"

TextLCD lcd(p24, p26, p27, p28, p29, p30);

int main()
{
    EthernetInterface eth;
    char strTimeMsg[16];
    lcd.cls();
    printf("\n\n/* SimpleMTPClient library demonstration */\n");

    printf("Setting up ...\n");
    eth.init();
    eth.connect();
    printf("Connected OK\n");

    // IP Address 
    printf("IP Address is %s\n", eth.getIPAddress());
    lcd.locate(0,1);
    lcd.printf("%s", eth.getIPAddress());

    // NTP Client
    printf("NTP setTime...\n");
    NTPClient ntp;
    ntp.setTime("pool.ntp.org");
    
    time_t ctTime = time(NULL)+32400; // JST
    printf("\nTime is now (JST): %d %s\n", ctTime, ctime(&ctTime));
    strftime(strTimeMsg,16,"%y/%m/%d %H:%M",localtime(&ctTime));

    lcd.locate(0,0);
    lcd.printf("[%s]",strTimeMsg);


    SimpleSMTPClient smtp;
    int ret;
    char msg[]="Hello SimpleSMTPClient ";
    
    smtp.setFromAddress(FROM_ADDRESS);
    smtp.setToAddress(TO_ADDRESS);
    smtp.setMessage(SUBJECT,msg);
    smtp.addMessage("TEST TEST TEST\r\n");
  
    ret = smtp.sendmail(SERVER, USER, PWD, DOMAIN,PORT,SMTP_AUTH_NONE);
 
    if (ret) {
        printf("E-mail Transmission Error\r\n");
    } else {
        printf("E-mail Transmission OK\r\n");
    }
 
    return 0;

}