#include "mbed.h"
#include "rtos.h"

#include "TextLCD.h"

#include "EthernetInterface.h"
#include "HTTPClient.h"

#include "spdomparser.hpp"
#include "spxmlnode.hpp"
#include "spxmlhandle.hpp"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
char buf[3000];

int main() {
    EthernetInterface eth;
    int retEth;
    HTTPClient http;  
    int retHttp;
    SP_XmlDomParser parser;
        
    printf("Setting up ...\r\n");
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Setting Up...");
    
    eth.init();
    retEth = eth.connect();
    
    lcd.locate(0,0);
    if (!retEth) {
        printf("Network Setup OK\r\n");
        lcd.printf("Network Setup OK");
    } else {
        printf("Network Error %d\r\n", retEth);
        lcd.printf("Network Error %d");
        return -1;
    }
         
    while(true)
    {
        retHttp = http.get("http://weather.yahooapis.com/forecastrss?w=28426187&u=c", buf, sizeof(buf));
    
        lcd.locate(0,1);
        switch(retHttp){
        case HTTP_OK:
            printf("Read completely\r\n");
            lcd.printf("Read completely ");        
            break;
        case HTTP_TIMEOUT:
            printf("Connection Timeout\r\n");
            lcd.printf("Timeout         ");            
            break;
        case HTTP_CONN:
            printf("Connection Error\r\n");
            lcd.printf("Connection Error");
            break;
        default:
            printf("Error\r\n");
            lcd.printf("Error           ");                           
        }        

        parser.append( buf, strlen(buf)); // stream current buffer data to the XML parser
        wait(5.0);    
        printf("\r\n----------%s----------\r\n",buf);
        
        SP_XmlHandle rootHandle( parser.getDocument()->getRootElement() );

        /*        
        SP_XmlCDataNode * title = rootHandle.getChild( "channel" ).getChild("title").getChild(0).toCData();
        printf("\r\n === Title:%s === \r\n",title->getText());
        SP_XmlCDataNode * title1 = rootHandle.getChild( "channel" ).getChild("image").getChild("title").getChild(0).toCData();
        printf("\r\n === Title:%s === \r\n",title1->getText());
        SP_XmlCDataNode * title2 = rootHandle.getChild( "channel" ).getChild("item").getChild("title").getChild(0).toCData();
        printf("\r\n === Title:%s === \r\n",title2->getText());
        */
        
        SP_XmlElementNode * location = rootHandle.getChild( "channel" ).getChild( "yweather:location" ).toElement();
        if (location) {
            printf("\r\n === Location:%s === \r\n",location->getAttrValue("city"));
        }
                     
        SP_XmlElementNode * forecast;
        
        forecast = rootHandle.getChild( "channel" ).getChild("item").getChild( "yweather:forecast",0).toElement();
        if (forecast) {
            printf("\r\n ----- Date:%s(%s) ----- \r\n",forecast->getAttrValue("date"),forecast->getAttrValue("day"));
            printf("Condition:%s \n",forecast->getAttrValue("text"));
            printf("Temp:Low%sC High%sC\n",forecast->getAttrValue("low"),forecast->getAttrValue("high"));
        }        
        
        forecast = rootHandle.getChild( "channel" ).getChild("item").getChild( "yweather:forecast",1).toElement();    
        if (forecast) {
            printf("\r\n ----- Date:%s(%s) ----- \r\n",forecast->getAttrValue("date"),forecast->getAttrValue("day"));        
            printf("Condition:%s \n",forecast->getAttrValue("text"));
            printf("Temp:Low%sC High%sC\n",forecast->getAttrValue("low"),forecast->getAttrValue("high"));
        }        
        
        wait(120.0);
    }  
}
