#include "mbed.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"


TextLCD lcd(p24, p26, p27, p28, p29, p30);
AnalogIn temp_in(p20);
SDFileSystem sd(p5, p6, p7, p8, "sd1") ;

Ticker lcdTimer, writeTimer;
char strNtpErrMsg[32] ;
char strDispMsg[32];
double temp;

void dataWriting() {
    FILE *fp;
    //
    if ( (fp = fopen("/sd1/temp.txt","a")) == NULL ) {
        printf("Open Failed. \n") ;
        exit(0);
    }
    
    //
    fprintf(fp,"%s,%5.3f,%5.3f\r\n",strDispMsg,temp, temp*55);  
    
    //
    printf("%s,%5.3f,%5.3f\r\n",strDispMsg,temp, temp*55) ;  
    
    //
    fclose(fp);
}
void lcdUpdate(){
    double rtemp;
    char dt[16];
    time_t ctTime ;
    
    //
    temp = temp_in;        
    rtemp = temp * 55.0 ;   

    //
    lcd.locate(0,0);
    lcd.printf("RoomTemp %5.2f",rtemp);
    lcd.locate(14,0);
    lcd.putc(0xDf); 
    lcd.putc(0x43); 
    
    //
    ctTime = time(NULL)+32400 ;
    strftime(strDispMsg,32,"%Y/%m/%d %H:%M",localtime(&ctTime));
    
    // 
    strftime(dt,16," %m/%d %X",localtime(&ctTime));       
    lcd.locate(0,1);
    lcd.printf("%s",dt); 
}    


int main() {
    EthernetNetIf eth;
    NTPClient ntp;

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Please wait...");
    
    //
    EthernetErr ethErr = eth.setup() ;
    if( ethErr != ETH_OK )
    {
        printf("Error %d in setup.\r\n", ethErr);
        lcd.locate(0,1);
        lcd.printf("NW Setup Error.");
    }   

    Host ntpsrv(IpAddr(), 123, "ntp.nict.jp") ; 
    NTPResult ntpResult = ntp.setTime(ntpsrv) ;
    
    if( ntpResult == NTP_OK ){
        sprintf(strNtpErrMsg,"NTP Connect OK!\r\n");
    }else if ( ntpResult == NTP_PRTCL ){
        sprintf(strNtpErrMsg,"NTP Protocol error.\r\n") ;
    }else if ( ntpResult == NTP_TIMEOUT ){
        sprintf(strNtpErrMsg,"Connection timeout.\r\n");  
    }else if ( ntpResult == NTP_DNS ){
        sprintf(strNtpErrMsg,"Could not resolve DNS hostname.\r\n") ;
    }else if ( ntpResult == NTP_PROCESSING ){
        sprintf(strNtpErrMsg,"Processing.\r\n");
    }else{
        sprintf(strNtpErrMsg,"NTP Error.");
    }
      
    printf("%s\r\n",strNtpErrMsg);

    lcdTimer.attach(&lcdUpdate,1.0);
    
    writeTimer.attach(&dataWriting, 60.0);
 
    while(1){
    }
}