#include "mbed.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
#include "MySound.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
SDFileSystem sd(p5, p6, p7, p8, "sd") ;
MySound music(p21) ;  


int main() {
    char pitch , ln;
    int scale;
    FILE *fp;
    int n;
    
    lcd.cls();
    if ( (fp = fopen("/sd/summer.txt","r")) == NULL ) {
        lcd.printf("Open Failed.") ;
        return -1;
    }
    
    lcd.locate(2,0);
    lcd.putc(0xC5);
    lcd.putc(0xC2);
    lcd.putc(0xC9);
    lcd.putc(0xB5);
    lcd.putc(0xD3);
    lcd.putc(0xB2);        
    lcd.putc(0xC3);
    lcd.putc(0xDE);
       
    while( (n = fscanf(fp,"%c %d %c ",&pitch,&scale,&ln)) != EOF ){
            printf("%d %c %d %c \r\n",n,pitch,scale,ln);
            music.play(pitch, scale, ln) ;    
    } 
    fclose(fp) ;
    
    
}