#include "mbed.h"
#include "TextLCD.h"
#include "SDFileSystem.h"
#include "ConfigFile.h"
#include "NTPClient.h"
#include "EthernetNetIf.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
SDFileSystem sd(p5, p6, p7, p8, "sd1") ;
LocalFileSystem local("local");

ConfigFile cfg;
AnalogIn temp_in(p20);
AnalogIn humid_in(p19);

Ticker  in, write;

char strTimeMsg[16];

float r_temp, r_humid;
NTPClient ntp;

void dataWriting() {
    FILE *fp;
    //
    lcd.cls();
    if ( (fp = fopen("/sd1/env.txt","a")) == NULL ) {
        lcd.printf("Open Failed. \n") ;
        exit(0);
    }
    printf("%s,%6.2f,%6.2f\r\n",strTimeMsg,r_temp, r_humid);  
    fprintf(fp,"%s,%5.3f,%5.3f\r\n",strTimeMsg,r_temp, r_humid);  
    fclose(fp);
}

void UpdateLCD(){
    
    float temp,humid;
    time_t ctTime;

    temp = temp_in;
    humid = humid_in;
    
    // r_temp = temp * 3.3 * 100 ;   // ---- (1)
    r_temp =  temp * 55.0  ;   // ---- (2)
    r_humid = humid * 3.3 * 100 ;   
    
    lcd.cls();
    lcd.locate(1,1);
    lcd.printf("%5.1f",r_temp);
    lcd.locate(6,1);
    lcd.putc(0xDf); 
    lcd.putc(0x43);
    
    lcd.locate(9,1);
    lcd.printf("%5.1f%%",r_humid);
     
    ctTime = time(NULL)+32400;
    strftime(strTimeMsg,16,"%y/%m/%d %H:%M",localtime(&ctTime));

    lcd.locate(0,0);
    lcd.printf("%s",strTimeMsg);
}

/* ----- Set RTC by ConfigFile -----*/
void setRTC_ConfFile()
{
    char *strData = "DATE";
    char dvalue[16];
    char *strTime = "TIME";
    char tvalue[16];
    int year, month;
    struct tm ltime;
    
    if (!cfg.read("/local/datetime.cfg")) {
        printf("Failure to read a configuration file.\n");
    }

    /*
     * Get a configuration value.
     */
    if (cfg.getValue(strData, &dvalue[0], sizeof(dvalue))) {
     
    }
    if (cfg.getValue(strTime, &tvalue[0], sizeof(tvalue))) {
       
    }
    sscanf(dvalue,"%d/%d/%d",&year,&month,&ltime.tm_mday);
    sscanf(tvalue,"%d:%d",&ltime.tm_hour,&ltime.tm_min);
    
    ltime.tm_year = year - 1900;
    ltime.tm_mon =  month -1 ;
    ltime.tm_sec = 0;
 
    set_time(mktime(&ltime)-32400) ;
    printf("[able to read a datetime.cfg]\r\n");
}


    
/*  ----- Set RTC by NTP  ----- */
void setRTC_NTP()
{
    char strNtpErrMsg[32] ;    
    EthernetErr ethErr; 
    EthernetNetIf eth;
    
    /* static ip 
    EthernetNetIf eth( // (2)  -- static IP address 
    IpAddr(192,168,0,20),     // IP Address
    IpAddr(255,255,255,0),   // Subnet Mask
    IpAddr(192,168,0,1),     // Default Gateway
    IpAddr(192,168,0,1)      // DNS Server
    ) ;
    */
    
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Please wait...");
    
    ethErr = eth.setup() ;
    
    if( ethErr != ETH_OK )
    {
        printf("Error %d in setup.\r\n", ethErr);
        lcd.locate(0,1);
        lcd.printf("NW Setup Error.");
    }
    
       
    Host ntpsrv(IpAddr(), 123, "ntp.nict.jp") ;
    //Host ntpsrv(IpAddr(), 123, "192.244.80.200");
    NTPResult ntpResult = ntp.setTime(ntpsrv) ;
    
    if( ntpResult == NTP_OK ){
        sprintf(strNtpErrMsg,"NTP Connect OK!");
    }else if ( ntpResult == NTP_PRTCL ){
        sprintf(strNtpErrMsg,"NTP Protocol error.") ;
    }else if ( ntpResult == NTP_TIMEOUT ){
        sprintf(strNtpErrMsg,"Connection timeout.");  
    }else if ( ntpResult == NTP_DNS ){
        sprintf(strNtpErrMsg,"Could not resolve DNS hostname.") ;
    }else if ( ntpResult == NTP_PROCESSING ){
        sprintf(strNtpErrMsg,"Processing.");
    }else{
        sprintf(strNtpErrMsg,"NTP Error.");
    }
    printf("[%s]\r\n",strNtpErrMsg);
}


int main() {
    
    // set RTC by ConfigFile
    //setRTC_ConfFile() ;
    
    // set RTC by NTP
    setRTC_NTP();
    
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Please wait...");
    
    in.attach(&UpdateLCD,10);
    write.attach(&dataWriting,300);
        
    while(1){        
    }
}
