static const char FontLookup_ABC[][8] =
{
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // space 0x20
    0x30,0x78,0x78,0x30,0x30,0x00,0x30,0x00, // !
    0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00, // "
    0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00, // #
    0x18,0x3E,0x60,0x3C,0x06,0x7C,0x18,0x00, // $
    0x00,0x63,0x66,0x0C,0x18,0x33,0x63,0x00, // %
    0x1C,0x36,0x1C,0x3B,0x6E,0x66,0x3B,0x00, // &
    0x30,0x30,0x60,0x00,0x00,0x00,0x00,0x00, // '
    0x0C,0x18,0x30,0x30,0x30,0x18,0x0C,0x00, // (
    0x30,0x18,0x0C,0x0C,0x0C,0x18,0x30,0x00, // )
    0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00, // *
    0x00,0x30,0x30,0xFC,0x30,0x30,0x00,0x00, // +
    0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x30, // ,
    0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00, // -
    0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00, // .
    0x03,0x06,0x0C,0x18,0x30,0x60,0x40,0x00, // / (forward slash)
    0x3E,0x63,0x63,0x6B,0x63,0x63,0x3E,0x00, // 0 0x30
    0x18,0x38,0x58,0x18,0x18,0x18,0x7E,0x00, // 1
    0x3C,0x66,0x06,0x1C,0x30,0x66,0x7E,0x00, // 2
    0x3C,0x66,0x06,0x1C,0x06,0x66,0x3C,0x00, // 3
    0x0E,0x1E,0x36,0x66,0x7F,0x06,0x0F,0x00, // 4
    0x7E,0x60,0x7C,0x06,0x06,0x66,0x3C,0x00, // 5
    0x1C,0x30,0x60,0x7C,0x66,0x66,0x3C,0x00, // 6
    0x7E,0x66,0x06,0x0C,0x18,0x18,0x18,0x00, // 7
    0x3C,0x66,0x66,0x3C,0x66,0x66,0x3C,0x00, // 8
    0x3C,0x66,0x66,0x3E,0x06,0x0C,0x38,0x00, // 9
    0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00, // :
    0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x30, // ;
    0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x00, // <
    0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00, // =
    0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x00, // >
    0x3C,0x66,0x06,0x0C,0x18,0x00,0x18,0x00, // ?
    0x3E,0x63,0x6F,0x69,0x6F,0x60,0x3E,0x00, // @ 0x40
    0x18,0x3C,0x66,0x66,0x7E,0x66,0x66,0x00, // A
    0x7E,0x33,0x33,0x3E,0x33,0x33,0x7E,0x00, // B
    0x1E,0x33,0x60,0x60,0x60,0x33,0x1E,0x00, // C
    0x7C,0x36,0x33,0x33,0x33,0x36,0x7C,0x00, // D
    0x7F,0x31,0x34,0x3C,0x34,0x31,0x7F,0x00, // E
    0x7F,0x31,0x34,0x3C,0x34,0x30,0x78,0x00, // F
    0x1E,0x33,0x60,0x60,0x67,0x33,0x1F,0x00, // G
    0x66,0x66,0x66,0x7E,0x66,0x66,0x66,0x00, // H
    0x3C,0x18,0x18,0x18,0x18,0x18,0x3C,0x00, // I
    0x0F,0x06,0x06,0x06,0x66,0x66,0x3C,0x00, // J
    0x73,0x33,0x36,0x3C,0x36,0x33,0x73,0x00, // K
    0x78,0x30,0x30,0x30,0x31,0x33,0x7F,0x00, // L
    0x63,0x77,0x7F,0x7F,0x6B,0x63,0x63,0x00, // M
    0x63,0x73,0x7B,0x6F,0x67,0x63,0x63,0x00, // N
    0x3E,0x63,0x63,0x63,0x63,0x63,0x3E,0x00, // O
    0x7E,0x33,0x33,0x3E,0x30,0x30,0x78,0x00, // P 0x50
    0x3C,0x66,0x66,0x66,0x6E,0x3C,0x0E,0x00, // Q
    0x7E,0x33,0x33,0x3E,0x36,0x33,0x73,0x00, // R
    0x3C,0x66,0x30,0x18,0x0C,0x66,0x3C,0x00, // S
    0x7E,0x5A,0x18,0x18,0x18,0x18,0x3C,0x00, // T
    0x66,0x66,0x66,0x66,0x66,0x66,0x7E,0x00, // U
    0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00, // V
    0x63,0x63,0x63,0x6B,0x7F,0x77,0x63,0x00, // W
    0x63,0x63,0x36,0x1C,0x1C,0x36,0x63,0x00, // X
    0x66,0x66,0x66,0x3C,0x18,0x18,0x3C,0x00, // Y
    0x7F,0x63,0x46,0x0C,0x19,0x33,0x7F,0x00, // Z
    0x3C,0x30,0x30,0x30,0x30,0x30,0x3C,0x00, // [
    0x60,0x30,0x18,0x0C,0x06,0x03,0x01,0x00, // \ (back slash)
    0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00, // ]
    0x08,0x1C,0x36,0x63,0x00,0x00,0x00,0x00, // ^
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF, // _
    0x18,0x18,0x0C,0x00,0x00,0x00,0x00,0x00, // ` 0x60
    0x00,0x00,0x3C,0x06,0x3E,0x66,0x3B,0x00, // a
    0x70,0x30,0x3E,0x33,0x33,0x33,0x6E,0x00, // b
    0x00,0x00,0x3C,0x66,0x60,0x66,0x3C,0x00, // c
    0x0E,0x06,0x3E,0x66,0x66,0x66,0x3B,0x00, // d
    0x00,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00, // e
    0x1C,0x36,0x30,0x78,0x30,0x30,0x78,0x00, // f
    0x00,0x00,0x3B,0x66,0x66,0x3E,0x06,0x7C, // g
    0x70,0x30,0x36,0x3B,0x33,0x33,0x73,0x00, // h
    0x18,0x00,0x38,0x18,0x18,0x18,0x3C,0x00, // i
    0x06,0x00,0x06,0x06,0x06,0x66,0x66,0x3C, // j
    0x70,0x30,0x33,0x36,0x3C,0x36,0x73,0x00, // k
    0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00, // l
    0x00,0x00,0x66,0x7F,0x7F,0x6B,0x63,0x00, // m
    0x00,0x00,0x7C,0x66,0x66,0x66,0x66,0x00, // n
    0x00,0x00,0x3C,0x66,0x66,0x66,0x3C,0x00, // o
    0x00,0x00,0x6E,0x33,0x33,0x3E,0x30,0x78, // p
    0x00,0x00,0x3B,0x66,0x66,0x3E,0x06,0x0F, // q
    0x00,0x00,0x6E,0x3B,0x33,0x30,0x78,0x00, // r
    0x00,0x00,0x3E,0x60,0x3C,0x06,0x7C,0x00, // s
    0x08,0x18,0x3E,0x18,0x18,0x1A,0x0C,0x00, // t
    0x00,0x00,0x66,0x66,0x66,0x66,0x3B,0x00, // u
    0x00,0x00,0x66,0x66,0x66,0x3C,0x18,0x00, // v
    0x00,0x00,0x63,0x6B,0x7F,0x7F,0x36,0x00, // w
    0x00,0x00,0x63,0x36,0x1C,0x36,0x63,0x00, // x
    0x00,0x00,0x66,0x66,0x66,0x3E,0x06,0x7C, // y
    0x00,0x00,0x7E,0x4C,0x18,0x32,0x7E,0x00, // z
    0x0E,0x18,0x18,0x70,0x18,0x18,0x0E,0x00, // {
    0x0C,0x0C,0x0C,0x00,0x0C,0x0C,0x0C,0x00, // |
    0x70,0x18,0x18,0x0E,0x18,0x18,0x70,0x00, // }
    0x3B,0x6E,0x00,0x00,0x00,0x00,0x00,0x00, // ~
};

static const char FontLookup_misaka[][8] =
{
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, // space 0x20
    0x40,0x40,0x40,0x40,0x00,0x40,0x00,0x00, // !
    0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00, // "
    0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00, // #
    0x18,0x3E,0x60,0x3C,0x06,0x7C,0x18,0x00, // $
    0x00,0x63,0x66,0x0C,0x18,0x33,0x63,0x00, // %
    0x1C,0x36,0x1C,0x3B,0x6E,0x66,0x3B,0x00, // &
    0x30,0x30,0x60,0x00,0x00,0x00,0x00,0x00, // '
    0x0C,0x18,0x30,0x30,0x30,0x18,0x0C,0x00, // (
    0x30,0x18,0x0C,0x0C,0x0C,0x18,0x30,0x00, // )
    0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00, // *
    0x00,0x30,0x30,0xFC,0x30,0x30,0x00,0x00, // +
    0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x30, // ,
    0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x00, // -
    0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00, // .
    0x03,0x06,0x0C,0x18,0x30,0x60,0x40,0x00, // / (forward slash)
    0x3E,0x63,0x63,0x6B,0x63,0x63,0x3E,0x00, // 0 0x30
    0x18,0x38,0x58,0x18,0x18,0x18,0x7E,0x00, // 1
    0x3C,0x66,0x06,0x1C,0x30,0x66,0x7E,0x00, // 2
    0x3C,0x66,0x06,0x1C,0x06,0x66,0x3C,0x00, // 3
    0x0E,0x1E,0x36,0x66,0x7F,0x06,0x0F,0x00, // 4
    0x7E,0x60,0x7C,0x06,0x06,0x66,0x3C,0x00, // 5
    0x1C,0x30,0x60,0x7C,0x66,0x66,0x3C,0x00, // 6
    0x7E,0x66,0x06,0x0C,0x18,0x18,0x18,0x00, // 7
    0x3C,0x66,0x66,0x3C,0x66,0x66,0x3C,0x00, // 8
    0x3C,0x66,0x66,0x3E,0x06,0x0C,0x38,0x00, // 9
    0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00, // :
    0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x30, // ;
    0x0C,0x18,0x30,0x60,0x30,0x18,0x0C,0x00, // <
    0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00, // =
    0x30,0x18,0x0C,0x06,0x0C,0x18,0x30,0x00, // >
    0x3C,0x66,0x06,0x0C,0x18,0x00,0x18,0x00, // ?
    0x3E,0x63,0x6F,0x69,0x6F,0x60,0x3E,0x00, // @ 0x40
    0x18,0x3C,0x66,0x66,0x7E,0x66,0x66,0x00, // A
    0x7E,0x33,0x33,0x3E,0x33,0x33,0x7E,0x00, // B
    0x1E,0x33,0x60,0x60,0x60,0x33,0x1E,0x00, // C
    0x7C,0x36,0x33,0x33,0x33,0x36,0x7C,0x00, // D
    0x7F,0x31,0x34,0x3C,0x34,0x31,0x7F,0x00, // E
    0x7F,0x31,0x34,0x3C,0x34,0x30,0x78,0x00, // F
    0x1E,0x33,0x60,0x60,0x67,0x33,0x1F,0x00, // G
    0x66,0x66,0x66,0x7E,0x66,0x66,0x66,0x00, // H
    0x3C,0x18,0x18,0x18,0x18,0x18,0x3C,0x00, // I
    0x0F,0x06,0x06,0x06,0x66,0x66,0x3C,0x00, // J
    0x73,0x33,0x36,0x3C,0x36,0x33,0x73,0x00, // K
    0x78,0x30,0x30,0x30,0x31,0x33,0x7F,0x00, // L
    0x63,0x77,0x7F,0x7F,0x6B,0x63,0x63,0x00, // M
    0x63,0x73,0x7B,0x6F,0x67,0x63,0x63,0x00, // N
    0x3E,0x63,0x63,0x63,0x63,0x63,0x3E,0x00, // O
    0x7E,0x33,0x33,0x3E,0x30,0x30,0x78,0x00, // P 0x50
    0x3C,0x66,0x66,0x66,0x6E,0x3C,0x0E,0x00, // Q
    0x7E,0x33,0x33,0x3E,0x36,0x33,0x73,0x00, // R
    0x3C,0x66,0x30,0x18,0x0C,0x66,0x3C,0x00, // S
    0x7E,0x5A,0x18,0x18,0x18,0x18,0x3C,0x00, // T
    0x66,0x66,0x66,0x66,0x66,0x66,0x7E,0x00, // U
    0x66,0x66,0x66,0x66,0x66,0x3C,0x18,0x00, // V
    0x63,0x63,0x63,0x6B,0x7F,0x77,0x63,0x00, // W
    0x63,0x63,0x36,0x1C,0x1C,0x36,0x63,0x00, // X
    0x66,0x66,0x66,0x3C,0x18,0x18,0x3C,0x00, // Y
    0x7F,0x63,0x46,0x0C,0x19,0x33,0x7F,0x00, // Z
    0x3C,0x30,0x30,0x30,0x30,0x30,0x3C,0x00, // [
    0x60,0x30,0x18,0x0C,0x06,0x03,0x01,0x00, // \ (back slash)
    0x3C,0x0C,0x0C,0x0C,0x0C,0x0C,0x3C,0x00, // ]
    0x08,0x1C,0x36,0x63,0x00,0x00,0x00,0x00, // ^
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF, // _
    0x18,0x18,0x0C,0x00,0x00,0x00,0x00,0x00, // ` 0x60
    0x00,0x00,0x3C,0x06,0x3E,0x66,0x3B,0x00, // a
    0x70,0x30,0x3E,0x33,0x33,0x33,0x6E,0x00, // b
    0x00,0x00,0x3C,0x66,0x60,0x66,0x3C,0x00, // c
    0x0E,0x06,0x3E,0x66,0x66,0x66,0x3B,0x00, // d
    0x00,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00, // e
    0x1C,0x36,0x30,0x78,0x30,0x30,0x78,0x00, // f
    0x00,0x00,0x3B,0x66,0x66,0x3E,0x06,0x7C, // g
    0x70,0x30,0x36,0x3B,0x33,0x33,0x73,0x00, // h
    0x18,0x00,0x38,0x18,0x18,0x18,0x3C,0x00, // i
    0x06,0x00,0x06,0x06,0x06,0x66,0x66,0x3C, // j
    0x70,0x30,0x33,0x36,0x3C,0x36,0x73,0x00, // k
    0x38,0x18,0x18,0x18,0x18,0x18,0x3C,0x00, // l
    0x00,0x00,0x66,0x7F,0x7F,0x6B,0x63,0x00, // m
    0x00,0x00,0x7C,0x66,0x66,0x66,0x66,0x00, // n
    0x00,0x00,0x3C,0x66,0x66,0x66,0x3C,0x00, // o
    0x00,0x00,0x6E,0x33,0x33,0x3E,0x30,0x78, // p
    0x00,0x00,0x3B,0x66,0x66,0x3E,0x06,0x0F, // q
    0x00,0x00,0x6E,0x3B,0x33,0x30,0x78,0x00, // r
    0x00,0x00,0x3E,0x60,0x3C,0x06,0x7C,0x00, // s
    0x08,0x18,0x3E,0x18,0x18,0x1A,0x0C,0x00, // t
    0x00,0x00,0x66,0x66,0x66,0x66,0x3B,0x00, // u
    0x00,0x00,0x66,0x66,0x66,0x3C,0x18,0x00, // v
    0x00,0x00,0x63,0x6B,0x7F,0x7F,0x36,0x00, // w
    0x00,0x00,0x63,0x36,0x1C,0x36,0x63,0x00, // x
    0x00,0x00,0x66,0x66,0x66,0x3E,0x06,0x7C, // y
    0x00,0x00,0x7E,0x4C,0x18,0x32,0x7E,0x00, // z
};

const struct {
    unsigned short start, end;
} font8table[92] = {
    {0x8140, 0x817e},
    {0x8180, 0x81ac},
    {0x81b8, 0x81bf},
    {0x81c8, 0x81ce},
    {0x81da, 0x81e8},
    {0x81f0, 0x81f7},
    {0x81fc, 0x81fc},
    {0x824f, 0x8258},
    {0x8260, 0x8279},
    {0x8281, 0x829a},
    {0x829f, 0x82f1},
    {0x8340, 0x837e},
    {0x8380, 0x8396},
    {0x839f, 0x83b6},
    {0x83bf, 0x83d6},
    {0x8440, 0x8460},
    {0x8470, 0x847e},
    {0x8480, 0x8491},
    {0x849f, 0x84be},
    {0x8740, 0x875d},
    {0x875f, 0x8775},
    {0x877e, 0x877e},
    {0x8780, 0x879c},
    {0x889f, 0x88fc},
    {0x8940, 0x897e},
    {0x8980, 0x89fc},
    {0x8a40, 0x8a7e},
    {0x8a80, 0x8afc},
    {0x8b40, 0x8b7e},
    {0x8b80, 0x8bfc},
    {0x8c40, 0x8c7e},
    {0x8c80, 0x8cfc},
    {0x8d40, 0x8d7e},
    {0x8d80, 0x8dfc},
    {0x8e40, 0x8e7e},
    {0x8e80, 0x8efc},
    {0x8f40, 0x8f7e},
    {0x8f80, 0x8ffc},
    {0x9040, 0x907e},
    {0x9080, 0x90fc},
    {0x9140, 0x917e},
    {0x9180, 0x91fc},
    {0x9240, 0x927e},
    {0x9280, 0x92fc},
    {0x9340, 0x937e},
    {0x9380, 0x93fc},
    {0x9440, 0x947e},
    {0x9480, 0x94fc},
    {0x9540, 0x957e},
    {0x9580, 0x95fc},
    {0x9640, 0x967e},
    {0x9680, 0x96fc},
    {0x9740, 0x977e},
    {0x9780, 0x97fc},
    {0x9840, 0x9872},
    {0x989f, 0x98fc},
    {0x9940, 0x997e},
    {0x9980, 0x99fc},
    {0x9a40, 0x9a7e},
    {0x9a80, 0x9afc},
    {0x9b40, 0x9b7e},
    {0x9b80, 0x9bfc},
    {0x9c40, 0x9c7e},
    {0x9c80, 0x9cfc},
    {0x9d40, 0x9d7e},
    {0x9d80, 0x9dfc},
    {0x9e40, 0x9e7e},
    {0x9e80, 0x9efc},
    {0x9f40, 0x9f7e},
    {0x9f80, 0x9ffc},
    {0xe040, 0xe07e},
    {0xe080, 0xe0fc},
    {0xe140, 0xe17e},
    {0xe180, 0xe1fc},
    {0xe240, 0xe27e},
    {0xe280, 0xe2fc},
    {0xe340, 0xe37e},
    {0xe380, 0xe3fc},
    {0xe440, 0xe47e},
    {0xe480, 0xe4fc},
    {0xe540, 0xe57e},
    {0xe580, 0xe5fc},
    {0xe640, 0xe67e},
    {0xe680, 0xe6fc},
    {0xe740, 0xe77e},
    {0xe780, 0xe7fc},
    {0xe840, 0xe87e},
    {0xe880, 0xe8fc},
    {0xe940, 0xe97e},
    {0xe980, 0xe9fc},
    {0xea40, 0xea7e},
    {0xea80, 0xeaa4},
};
// converted MISAKI font
// Please refer to following URL for the MISAKI font. 
// http://www.geocities.jp/littlimi/misaki.htm
const unsigned char FontLookup[6962][8] = {
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x80,0x40,0x00},
    {0x00,0x00,0x00,0x00,0x40,0xa0,0x40,0x00},
    {0x00,0x00,0x00,0x00,0xc0,0x40,0x80,0x00},
    {0x00,0x00,0x00,0x00,0x00,0xc0,0xc0,0x00},
    {0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00},
    {0x00,0x30,0x30,0x00,0x30,0x30,0x00,0x00},
    {0x00,0x30,0x30,0x00,0x30,0x10,0x20,0x00},
    {0x3c,0x42,0x02,0x0c,0x10,0x00,0x10,0x00},
    {0x10,0x10,0x10,0x10,0x10,0x00,0x10,0x00},
    {0xa0,0x50,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x20,0x50,0x20,0x00,0x00,0x00,0x00,0x00},
    {0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x20,0x10,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x28,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x10,0x28,0x00,0x00,0x00,0x00,0x00,0x00},
    {0xfe,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x00},
    {0x00,0x00,0x20,0x10,0x08,0x08,0x00,0x00},
    {0x0a,0x00,0x20,0x10,0x08,0x08,0x00,0x00},
    {0x00,0x20,0x10,0x08,0x0c,0x10,0x00,0x00},
    {0x0a,0x20,0x10,0x08,0x0c,0x10,0x00,0x00},
    {0x00,0x00,0x24,0x24,0x24,0x48,0x00,0x00},
    {0x10,0x28,0xc6,0x7c,0x10,0x10,0xfe,0x00},
    {0x00,0x10,0x1e,0x22,0x54,0x08,0x04,0x00},
    {0x02,0x04,0x28,0x50,0xa8,0xc0,0x80,0x00},
    {0x00,0x38,0x44,0x82,0x82,0x44,0x38,0x00},
    {0x00,0x00,0x80,0x7e,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00},
    {0x02,0x04,0x08,0x10,0x20,0x40,0x80,0x00},
    {0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x00},
    {0x00,0x00,0x60,0x92,0x0c,0x00,0x00,0x00},
    {0x28,0x28,0x28,0x28,0x28,0x28,0x28,0x00},
    {0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00},
    {0x00,0x00,0x00,0x92,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x44,0x00,0x00,0x00,0x00},
    {0x02,0x04,0x06,0x00,0x00,0x00,0x00,0x00},
    {0xc0,0x40,0x80,0x00,0x00,0x00,0x00,0x00},
    {0x12,0x24,0x36,0x00,0x00,0x00,0x00,0x00},
    {0xd8,0x48,0x90,0x00,0x00,0x00,0x00,0x00},
    {0x02,0x04,0x08,0x08,0x08,0x04,0x02,0x00},
    {0x80,0x40,0x20,0x20,0x20,0x40,0x80,0x00},
    {0x06,0x18,0x10,0x10,0x10,0x18,0x06,0x00},
    {0xc0,0x30,0x10,0x10,0x10,0x30,0xc0,0x00},
    {0x0e,0x08,0x08,0x08,0x08,0x08,0x0e,0x00},
    {0xe0,0x20,0x20,0x20,0x20,0x20,0xe0,0x00},
    {0x06,0x08,0x08,0x10,0x08,0x08,0x06,0x00},
    {0xc0,0x20,0x20,0x10,0x20,0x20,0xc0,0x00},
    {0x02,0x04,0x08,0x10,0x08,0x04,0x02,0x00},
    {0x80,0x40,0x20,0x10,0x20,0x40,0x80,0x00},
    {0x0a,0x14,0x28,0x50,0x28,0x14,0x0a,0x00},
    {0xa0,0x50,0x28,0x14,0x28,0x50,0xa0,0x00},
    {0x1e,0x10,0x10,0x10,0x10,0x10,0x00,0x00},
    {0x00,0x10,0x10,0x10,0x10,0x10,0xf0,0x00},
    {0x3e,0x22,0x2e,0x28,0x28,0x28,0x38,0x00},
    {0x38,0x28,0x28,0x28,0xe8,0x88,0xf8,0x00},
    {0x0e,0x0c,0x08,0x08,0x08,0x0c,0x0e,0x00},
    {0xe0,0x60,0x20,0x20,0x20,0x60,0xe0,0x00},
    {0x10,0x10,0x10,0xfe,0x10,0x10,0x10,0x00},
    {0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00},
    {0x10,0x10,0xfe,0x10,0x10,0x00,0xfe,0x00},
    {0x82,0x44,0x28,0x10,0x28,0x44,0x82,0x00},
    {0x00,0x10,0x00,0xfe,0x00,0x10,0x00,0x00},
    {0x00,0x00,0xfe,0x00,0xfe,0x00,0x00,0x00},
    {0x00,0x04,0xfe,0x10,0xfe,0x40,0x00,0x00},
    {0x00,0x06,0x38,0xc0,0x38,0x06,0x00,0x00},
    {0x00,0xc0,0x38,0x06,0x38,0xc0,0x00,0x00},
    {0x06,0x38,0xc0,0x38,0x06,0x00,0xfe,0x00},
    {0xc0,0x38,0x06,0x38,0xc0,0x00,0xfe,0x00},
    {0x00,0x6c,0x92,0x92,0x92,0x6c,0x00,0x00},
    {0x00,0x10,0x00,0x00,0x00,0x44,0x00,0x00},
    {0x1e,0x06,0x0a,0x72,0x90,0x90,0x60,0x00},
    {0x38,0x44,0x44,0x38,0x10,0x7c,0x10,0x00},
    {0x40,0xa0,0x40,0x00,0x00,0x00,0x00,0x00},
    {0x60,0xc0,0x80,0x00,0x00,0x00,0x00,0x00},
    {0x6c,0xd8,0x90,0x00,0x00,0x00,0x00,0x00},
    {0x40,0xac,0x52,0x10,0x10,0x12,0x0c,0x00},
    {0x44,0x44,0x28,0x7c,0x10,0x7c,0x10,0x00},
    {0x08,0x3e,0x48,0x3c,0x12,0x7c,0x10,0x00},
    {0x04,0x3c,0x4a,0x48,0x52,0x3c,0x20,0x00},
    {0x18,0x24,0x70,0x20,0x60,0x92,0x6c,0x00},
    {0x42,0xa4,0x48,0x10,0x24,0x4a,0x84,0x00},
    {0x14,0x7e,0x28,0x28,0x28,0xfc,0x50,0x00},
    {0x30,0x48,0x50,0x24,0x54,0x88,0x76,0x00},
    {0x10,0x54,0x38,0x10,0x38,0x54,0x10,0x00},
    {0x38,0x44,0x9a,0xaa,0xb4,0x40,0x38,0x00},
    {0x1c,0x20,0x18,0x24,0x18,0x04,0x38,0x00},
    {0x10,0x10,0xfe,0x28,0x38,0x6c,0x44,0x00},
    {0x10,0x10,0xfe,0x38,0x38,0x6c,0x44,0x00},
    {0x38,0x44,0x82,0x82,0x82,0x44,0x38,0x00},
    {0x38,0x7c,0xfe,0xfe,0xfe,0x7c,0x38,0x00},
    {0x38,0x44,0xba,0xaa,0xba,0x44,0x38,0x00},
    {0x10,0x28,0x44,0x82,0x44,0x28,0x10,0x00},
    {0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00},
    {0xfe,0x82,0x82,0x82,0x82,0x82,0xfe,0x00},
    {0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0xfe,0x00},
    {0x10,0x10,0x28,0x28,0x44,0x44,0xfe,0x00},
    {0x10,0x10,0x38,0x38,0x7c,0x7c,0xfe,0x00},
    {0xfe,0x44,0x44,0x28,0x28,0x10,0x10,0x00},
    {0xfe,0x7c,0x7c,0x38,0x38,0x10,0x10,0x00},
    {0x92,0x44,0x28,0x92,0x28,0x44,0x92,0x00},
    {0xfe,0x00,0xfe,0x10,0x10,0x10,0x10,0x00},
    {0x00,0x08,0x04,0xfe,0x04,0x08,0x00,0x00},
    {0x00,0x20,0x40,0xfe,0x40,0x20,0x00,0x00},
    {0x10,0x38,0x54,0x10,0x10,0x10,0x10,0x00},
    {0x10,0x10,0x10,0x10,0x54,0x38,0x10,0x00},
    {0x00,0xfe,0xfe,0x00,0xfe,0xfe,0x00,0x00},
    {0x00,0x3e,0x40,0x7e,0x40,0x3e,0x00,0x00},
    {0x00,0x7c,0x02,0x7e,0x02,0x7c,0x00,0x00},
    {0x3e,0x40,0x40,0x40,0x3e,0x00,0x7e,0x00},
    {0x7c,0x02,0x02,0x02,0x7c,0x00,0x7e,0x00},
    {0x00,0x3e,0x40,0x40,0x40,0x3e,0x00,0x00},
    {0x00,0x7c,0x02,0x02,0x02,0x7c,0x00,0x00},
    {0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    {0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x00},
    {0x10,0x10,0x28,0x28,0x44,0x44,0x82,0x00},
    {0x82,0x44,0x44,0x28,0x28,0x10,0x10,0x00},
    {0x00,0x00,0x00,0xfe,0x02,0x02,0x00,0x00},
    {0x00,0x08,0xfc,0x02,0xfc,0x08,0x00,0x00},
    {0x00,0x28,0x7c,0x82,0x7c,0x28,0x00,0x00},
    {0x82,0x82,0x7c,0x44,0x28,0x28,0x10,0x00},
    {0x7e,0x02,0x02,0x7e,0x02,0x02,0x7e,0x00},
    {0x00,0x02,0x04,0x08,0x10,0x20,0x7e,0x00},
    {0x00,0x10,0x10,0x10,0x10,0x10,0xfe,0x00},
    {0x3c,0x42,0x00,0x00,0x00,0x00,0x00,0x00},
    {0x18,0x24,0x04,0x34,0x48,0x48,0x30,0x00},
    {0xfe,0x82,0x44,0x44,0x28,0x28,0x10,0x00},
    {0x00,0x7e,0x00,0x7e,0x00,0x7e,0x00,0x00},
    {0x40,0x00,0xfe,0x00,0xfe,0x00,0x04,0x00},
    {0x12,0x24,0x48,0x90,0x48,0x24,0x12,0x00},
    {0x90,0x48,0x24,0x12,0x24,0x48,0x90,0x00},
    {0x1e,0x10,0x20,0x20,0xe0,0x40,0x40,0x00},
    {0x00,0x4c,0x92,0x92,0x92,0x64,0x00,0x00},
    {0x00,0x6c,0x92,0x90,0x92,0x6c,0x00,0x00},
    {0x00,0x44,0x00,0x00,0x00,0x10,0x00,0x00},
    {0x18,0x20,0x20,0x10,0x08,0x08,0x30,0x00},
    {0x36,0x48,0x48,0x24,0x12,0x12,0x6c,0x00},
    {0x10,0x28,0x10,0x28,0x44,0x7c,0x82,0x00},
    {0x44,0xa8,0x50,0x20,0x54,0xaa,0x14,0x00},
    {0x04,0x26,0x3c,0x66,0x3c,0x64,0x20,0x00},
    {0x20,0x20,0x28,0x34,0x24,0x28,0x30,0x00},
    {0x10,0x18,0x14,0x14,0x30,0x70,0x60,0x00},
    {0x10,0x38,0x10,0x10,0x10,0x10,0x10,0x00},
    {0x10,0x38,0x10,0x10,0x10,0x38,0x10,0x00},
    {0x3c,0x74,0x74,0x34,0x14,0x14,0x14,0x00},
    {0x7c,0x82,0x82,0x82,0x82,0x82,0x7c,0x00},
    {0x3c,0x42,0x42,0x42,0x42,0x42,0x3c,0x00},
    {0x10,0x30,0x10,0x10,0x10,0x10,0x38,0x00},
    {0x3c,0x42,0x02,0x0c,0x30,0x40,0x7e,0x00},
    {0x3c,0x42,0x02,0x1c,0x02,0x42,0x3c,0x00},
    {0x04,0x0c,0x14,0x24,0x44,0x7e,0x04,0x00},
    {0x7e,0x40,0x7c,0x42,0x02,0x42,0x3c,0x00},
    {0x3c,0x42,0x40,0x7c,0x42,0x42,0x3c,0x00},
    {0x7e,0x02,0x04,0x08,0x08,0x10,0x10,0x00},
    {0x3c,0x42,0x42,0x3c,0x42,0x42,0x3c,0x00},
    {0x3c,0x42,0x42,0x3e,0x02,0x42,0x3c,0x00},
    {0x10,0x28,0x28,0x44,0x7c,0x82,0x82,0x00},
    {0x7c,0x42,0x42,0x7c,0x42,0x42,0x7c,0x00},
    {0x1c,0x22,0x40,0x40,0x40,0x22,0x1c,0x00},
    {0x78,0x44,0x42,0x42,0x42,0x44,0x78,0x00},
    {0x7e,0x40,0x40,0x7c,0x40,0x40,0x7e,0x00},
    {0x7e,0x40,0x40,0x7c,0x40,0x40,0x40,0x00},
    {0x1c,0x22,0x40,0x4e,0x42,0x22,0x1c,0x00},
    {0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x00},
    {0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00},
    {0x02,0x02,0x02,0x02,0x02,0x42,0x3c,0x00},
    {0x42,0x44,0x48,0x50,0x68,0x44,0x42,0x00},
    {0x40,0x40,0x40,0x40,0x40,0x40,0x7e,0x00},
    {0x82,0xc6,0xaa,0xaa,0x92,0x92,0x82,0x00},
    {0x42,0x62,0x52,0x4a,0x46,0x42,0x42,0x00},
    {0x18,0x24,0x42,0x42,0x42,0x24,0x18,0x00},
    {0x7c,0x42,0x42,0x7c,0x40,0x40,0x40,0x00},
    {0x18,0x24,0x42,0x42,0x4a,0x24,0x1a,0x00},
    {0x7c,0x42,0x42,0x7c,0x48,0x44,0x42,0x00},
    {0x3c,0x42,0x40,0x3c,0x02,0x42,0x3c,0x00},
    {0xfe,0x10,0x10,0x10,0x10,0x10,0x10,0x00},
    {0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00},
    {0x82,0x82,0x44,0x44,0x28,0x28,0x10,0x00},
    {0x82,0x92,0x92,0xaa,0xaa,0x44,0x44,0x00},
    {0x82,0x44,0x28,0x10,0x28,0x44,0x82,0x00},
    {0x82,0x44,0x28,0x10,0x10,0x10,0x10,0x00},
    {0x7e,0x02,0x04,0x08,0x10,0x20,0x7e,0x00},
    {0x00,0x00,0x38,0x04,0x3c,0x44,0x3c,0x00},
    {0x40,0x40,0x58,0x64,0x44,0x44,0x78,0x00},
    {0x00,0x00,0x38,0x44,0x40,0x44,0x38,0x00},
    {0x04,0x04,0x34,0x4c,0x44,0x44,0x3c,0x00},
    {0x00,0x00,0x38,0x44,0x7c,0x40,0x38,0x00},
    {0x0c,0x10,0x38,0x10,0x10,0x10,0x10,0x00},
    {0x00,0x00,0x3c,0x44,0x3c,0x04,0x38,0x00},
    {0x40,0x40,0x58,0x64,0x44,0x44,0x44,0x00},
    {0x10,0x00,0x10,0x10,0x10,0x10,0x10,0x00},
    {0x08,0x00,0x08,0x08,0x08,0x48,0x30,0x00},
    {0x20,0x20,0x24,0x28,0x30,0x28,0x24,0x00},
    {0x30,0x10,0x10,0x10,0x10,0x10,0x10,0x00},
    {0x00,0x00,0x68,0x54,0x54,0x54,0x54,0x00},
    {0x00,0x00,0x58,0x64,0x44,0x44,0x44,0x00},
    {0x00,0x00,0x38,0x44,0x44,0x44,0x38,0x00},
    {0x00,0x00,0x78,0x44,0x78,0x40,0x40,0x00},
    {0x00,0x00,0x3c,0x44,0x3c,0x04,0x04,0x00},
    {0x00,0x00,0x58,0x64,0x40,0x40,0x40,0x00},
    {0x00,0x00,0x3c,0x40,0x38,0x04,0x78,0x00},
    {0x00,0x20,0x78,0x20,0x20,0x24,0x18,0x00},
    {0x00,0x00,0x44,0x44,0x44,0x4c,0x34,0x00},
    {0x00,0x00,0x44,0x44,0x28,0x28,0x10,0x00},
    {0x00,0x00,0x44,0x54,0x54,0x28,0x28,0x00},
    {0x00,0x00,0x44,0x28,0x10,0x28,0x44,0x00},
    {0x00,0x00,0x44,0x28,0x28,0x10,0x60,0x00},
    {0x00,0x00,0x7c,0x08,0x10,0x20,0x7c,0x00},
    {0x00,0x10,0x3c,0x10,0x3c,0x5a,0x32,0x00},
    {0x20,0x7c,0x20,0x3c,0x6a,0xb2,0x64,0x00},
    {0x00,0x00,0x48,0x44,0x44,0x50,0x20,0x00},
    {0x00,0x88,0x84,0x82,0x82,0x50,0x20,0x00},
    {0x00,0x38,0x00,0x38,0x44,0x08,0x30,0x00},
    {0x3c,0x00,0x3c,0x42,0x02,0x04,0x38,0x00},
    {0x00,0x38,0x00,0x78,0x10,0x30,0x4c,0x00},
    {0x3c,0x00,0x7c,0x08,0x18,0x28,0x46,0x00},
    {0x00,0x20,0x74,0x20,0x38,0x64,0x28,0x00},
    {0x20,0xf4,0x22,0x3c,0x62,0xa2,0x6c,0x00},
    {0x20,0x20,0xf4,0x2a,0x4a,0x48,0xb0,0x00},
    {0x2a,0x20,0xf4,0x2a,0x4a,0x48,0xb0,0x00},
    {0x10,0x7c,0x08,0x7e,0x24,0x40,0x3c,0x00},
    {0x14,0x7c,0x08,0x7e,0x24,0x40,0x3c,0x00},
    {0x04,0x08,0x30,0x40,0x30,0x08,0x04,0x00},
    {0x04,0x08,0x36,0x40,0x30,0x08,0x04,0x00},
    {0x88,0x88,0xbe,0x88,0x88,0x88,0x10,0x00},
    {0x8a,0x88,0xbe,0x88,0x88,0x88,0x10,0x00},
    {0x00,0x3c,0x00,0x00,0x20,0x40,0x3e,0x00},
    {0x0a,0x3c,0x00,0x00,0x20,0x40,0x3e,0x00},
    {0x08,0x08,0x7e,0x04,0x24,0x40,0x3c,0x00},
    {0x0a,0x08,0x7e,0x04,0x24,0x40,0x3c,0x00},
    {0x20,0x20,0x20,0x20,0x20,0x22,0x1c,0x00},
    {0x2a,0x20,0x20,0x20,0x20,0x22,0x1c,0x00},
    {0x08,0xfe,0x18,0x28,0x18,0x08,0x10,0x00},
    {0x0a,0xfe,0x18,0x28,0x18,0x08,0x10,0x00},
    {0x24,0x24,0xfe,0x24,0x2c,0x20,0x1e,0x00},
    {0x26,0x24,0xfe,0x24,0x2c,0x20,0x1e,0x00},
    {0x3c,0x08,0x10,0x7e,0x10,0x10,0x0c,0x00},
    {0x3c,0x0a,0x10,0x7e,0x10,0x10,0x0c,0x00},
    {0x20,0xf0,0x2e,0x40,0x48,0x50,0x8e,0x00},
    {0x2a,0xf0,0x2e,0x40,0x48,0x50,0x8e,0x00},
    {0x08,0x7e,0x10,0x1c,0x22,0x02,0x1c,0x00},
    {0x0a,0x7e,0x10,0x1c,0x22,0x02,0x1c,0x00},
    {0x00,0x00,0x00,0x18,0x64,0x04,0x18,0x00},
    {0x00,0x3c,0xc2,0x02,0x02,0x1c,0x00,0x00},
    {0x0a,0x3c,0xc2,0x02,0x02,0x1c,0x00,0x00},
    {0x0e,0x74,0x08,0x10,0x10,0x08,0x06,0x00},
    {0x0e,0x74,0x0a,0x10,0x10,0x08,0x06,0x00},
    {0x20,0x20,0x26,0x18,0x20,0x40,0x3e,0x00},
    {0x2a,0x20,0x26,0x18,0x20,0x40,0x3e,0x00},
    {0x20,0xf4,0x22,0x44,0x9c,0x26,0x18,0x00},
    {0x80,0x9c,0x80,0x80,0x90,0xa0,0x9e,0x00},
    {0x08,0x48,0x5c,0x6a,0xb2,0xa6,0x56,0x00},
    {0x20,0x2c,0xf2,0x22,0x66,0xaa,0x24,0x00},
    {0x00,0x38,0x54,0x92,0xa2,0x44,0x18,0x00},
    {0x84,0x84,0xbe,0x84,0x9c,0xa4,0x9a,0x00},
    {0x86,0x84,0xbe,0x84,0x9c,0xa4,0x9a,0x00},
    {0x84,0x8a,0xbe,0x84,0x9c,0xa4,0x9a,0x00},
    {0x28,0xe4,0x26,0x44,0x44,0x44,0x38,0x00},
    {0x2a,0xe4,0x26,0x44,0x44,0x44,0x38,0x00},
    {0x2c,0xea,0x26,0x44,0x44,0x44,0x38,0x00},
    {0x10,0x08,0x10,0x10,0x4c,0x4a,0xb2,0x00},
    {0x16,0x08,0x10,0x10,0x4c,0x4a,0xb2,0x00},
    {0x14,0x0a,0x14,0x10,0x4c,0x4a,0xb2,0x00},
    {0x00,0x20,0x50,0x88,0x06,0x00,0x00,0x00},
    {0x0a,0x20,0x50,0x88,0x06,0x00,0x00,0x00},
    {0x04,0x2a,0x54,0x88,0x06,0x00,0x00,0x00},
    {0x80,0xbe,0x88,0xbe,0x88,0xbc,0xba,0x00},
    {0x8a,0xbe,0x88,0xbe,0x88,0xbc,0xba,0x00},
    {0x84,0xba,0x8c,0xbe,0x88,0xbc,0xba,0x00},
    {0x08,0x7e,0x08,0x7e,0x08,0x7c,0x7a,0x00},
    {0x70,0x10,0x24,0x7c,0xa6,0xc4,0x18,0x00},
    {0x20,0xf4,0x22,0x60,0xa0,0x62,0x3c,0x00},
    {0x08,0x48,0x5c,0x6a,0xb2,0xa2,0x54,0x00},
    {0x10,0x7c,0x20,0x7c,0x22,0x22,0x1c,0x00},
    {0x00,0x08,0x2c,0x72,0x14,0x10,0x08,0x00},
    {0x48,0x5c,0xe2,0x24,0x20,0x10,0x10,0x00},
    {0x00,0x10,0x58,0x74,0x54,0x18,0x20,0x00},
    {0x10,0xbc,0xd2,0x92,0xbc,0x10,0x20,0x00},
    {0x00,0x08,0x08,0x0c,0x38,0x48,0x34,0x00},
    {0x08,0x08,0x0e,0x08,0x38,0x4c,0x32,0x00},
    {0x30,0x08,0x40,0x5c,0x62,0x02,0x3c,0x00},
    {0x58,0x64,0x44,0x44,0x04,0x08,0x30,0x00},
    {0x3c,0x08,0x10,0x3c,0x42,0x32,0x3c,0x00},
    {0x20,0x2c,0xf4,0x24,0x64,0xa4,0x22,0x00},
    {0x3c,0x08,0x10,0x3c,0x42,0x02,0x3c,0x00},
    {0x00,0x10,0x14,0x7a,0x32,0x52,0x14,0x00},
    {0x20,0x2c,0xf2,0x22,0x62,0xa2,0x2c,0x00},
    {0x70,0x10,0x3c,0x52,0x96,0xaa,0x44,0x00},
    {0x38,0x10,0x38,0x44,0x18,0x6c,0x92,0x00},
    {0x10,0x7c,0x20,0x76,0x98,0x28,0x1e,0x00},
    {0x10,0x10,0x20,0x20,0x50,0x52,0x8c,0x00},
    {0x00,0x00,0x7c,0x14,0x18,0x10,0x20,0x00},
    {0x7e,0x02,0x14,0x18,0x10,0x10,0x20,0x00},
    {0x00,0x00,0x04,0x08,0x18,0x68,0x08,0x00},
    {0x02,0x04,0x08,0x18,0x68,0x08,0x08,0x00},
    {0x00,0x00,0x10,0x7c,0x44,0x08,0x30,0x00},
    {0x10,0x7e,0x42,0x02,0x04,0x08,0x30,0x00},
    {0x00,0x00,0x00,0x38,0x10,0x10,0x7c,0x00},
    {0x00,0x7c,0x10,0x10,0x10,0xfe,0x00,0x00},
    {0x00,0x00,0x08,0x7c,0x18,0x68,0x18,0x00},
    {0x08,0xfe,0x08,0x18,0x28,0xc8,0x18,0x00},
    {0x10,0x7e,0x12,0x12,0x12,0x22,0x46,0x00},
    {0x12,0x7e,0x12,0x12,0x12,0x22,0x46,0x00},
    {0x10,0x7c,0x10,0x10,0x7e,0x08,0x08,0x00},
    {0x14,0x7c,0x10,0x10,0x7e,0x08,0x08,0x00},
    {0x10,0x1e,0x22,0x42,0x04,0x08,0x30,0x00},
    {0x12,0x1e,0x22,0x42,0x04,0x08,0x30,0x00},
    {0x40,0x7e,0x48,0x88,0x08,0x10,0x20,0x00},
    {0x4a,0x7e,0x48,0x88,0x08,0x10,0x20,0x00},
    {0x00,0x7e,0x02,0x02,0x02,0x02,0x7e,0x00},
    {0x0a,0x7e,0x02,0x02,0x02,0x02,0x7e,0x00},
    {0x24,0xfe,0x24,0x24,0x04,0x08,0x30,0x00},
    {0x2a,0xfe,0x24,0x24,0x04,0x08,0x30,0x00},
    {0x40,0x20,0x42,0x22,0x04,0x08,0x70,0x00},
    {0x4a,0x20,0x42,0x22,0x04,0x08,0x70,0x00},
    {0x00,0x7c,0x04,0x08,0x08,0x34,0xc2,0x00},
    {0x0a,0x7c,0x04,0x08,0x08,0x34,0xc2,0x00},
    {0x20,0x20,0xfe,0x22,0x24,0x20,0x1e,0x00},
    {0x2a,0x20,0xfe,0x22,0x24,0x20,0x1e,0x00},
    {0x42,0x22,0x22,0x02,0x04,0x08,0x30,0x00},
    {0x46,0x22,0x22,0x02,0x04,0x08,0x30,0x00},
    {0x10,0x1e,0x22,0x5a,0x04,0x08,0x30,0x00},
    {0x12,0x1e,0x22,0x5a,0x04,0x08,0x30,0x00},
    {0x0c,0x70,0x10,0xfe,0x10,0x10,0x20,0x00},
    {0x0a,0x70,0x10,0xfe,0x10,0x10,0x20,0x00},
    {0x00,0x00,0x00,0x54,0x54,0x08,0x30,0x00},
    {0x00,0xa2,0x52,0x52,0x04,0x08,0x30,0x00},
    {0x0a,0xa0,0x52,0x52,0x04,0x08,0x30,0x00},
    {0x7c,0x00,0xfe,0x10,0x10,0x10,0x20,0x00},
    {0x7a,0x00,0xfe,0x10,0x10,0x10,0x20,0x00},
    {0x20,0x20,0x20,0x38,0x24,0x20,0x20,0x00},
    {0x2a,0x20,0x20,0x38,0x24,0x20,0x20,0x00},
    {0x10,0x10,0xfe,0x10,0x10,0x20,0x40,0x00},
    {0x00,0x7c,0x00,0x00,0x00,0xfe,0x00,0x00},
    {0x7c,0x04,0x34,0x08,0x18,0x24,0xc0,0x00},
    {0x10,0x7c,0x08,0x10,0x34,0xd2,0x10,0x00},
    {0x04,0x04,0x04,0x08,0x10,0x20,0xc0,0x00},
    {0x00,0x28,0x24,0x24,0x42,0x42,0x82,0x00},
    {0x06,0x28,0x24,0x24,0x42,0x42,0x82,0x00},
    {0x04,0x2a,0x24,0x24,0x42,0x42,0x82,0x00},
    {0x40,0x40,0x46,0x78,0x40,0x40,0x3e,0x00},
    {0x4a,0x40,0x46,0x78,0x40,0x40,0x3e,0x00},
    {0x44,0x4a,0x46,0x78,0x40,0x40,0x3e,0x00},
    {0x00,0x7e,0x02,0x02,0x04,0x08,0x30,0x00},
    {0x0a,0x7e,0x02,0x02,0x04,0x08,0x30,0x00},
    {0x04,0x7a,0x06,0x02,0x04,0x08,0x30,0x00},
    {0x00,0x20,0x50,0x88,0x04,0x02,0x00,0x00},
    {0x0a,0x20,0x50,0x88,0x04,0x02,0x00,0x00},
    {0x04,0x2a,0x54,0x88,0x04,0x02,0x00,0x00},
    {0x10,0x10,0xfe,0x10,0x54,0x92,0x30,0x00},
    {0x1a,0x10,0xfe,0x10,0x54,0x92,0x30,0x00},
    {0x14,0x1a,0xfc,0x10,0x54,0x92,0x30,0x00},
    {0x00,0xfe,0x02,0x04,0x28,0x10,0x08,0x00},
    {0x70,0x0c,0x20,0x18,0x00,0x70,0x0c,0x00},
    {0x10,0x10,0x20,0x20,0x48,0x44,0xfa,0x00},
    {0x04,0x04,0x74,0x08,0x14,0x24,0xc0,0x00},
    {0x3c,0x10,0x10,0x7e,0x10,0x10,0x0e,0x00},
    {0x00,0x00,0x20,0x3c,0x64,0x10,0x10,0x00},
    {0x20,0x2e,0xf2,0x24,0x10,0x10,0x10,0x00},
    {0x00,0x00,0x00,0x38,0x08,0x08,0x7c,0x00},
    {0x00,0x78,0x08,0x08,0x08,0xfe,0x00,0x00},
    {0x00,0x00,0x3c,0x04,0x1c,0x04,0x3c,0x00},
    {0x00,0x7e,0x02,0x3e,0x02,0x02,0x7e,0x00},
    {0x3c,0x00,0x7e,0x02,0x04,0x08,0x30,0x00},
    {0x44,0x44,0x44,0x44,0x04,0x08,0x30,0x00},
    {0x08,0x28,0x28,0x28,0x2a,0x4c,0x88,0x00},
    {0x20,0x20,0x20,0x22,0x24,0x28,0x30,0x00},
    {0x00,0x7e,0x42,0x42,0x42,0x42,0x7e,0x00},
    {0x00,0x00,0x7c,0x44,0x04,0x08,0x30,0x00},
    {0x00,0x7e,0x42,0x02,0x04,0x08,0x30,0x00},
    {0x04,0x7e,0x24,0x24,0xfe,0x04,0x04,0x00},
    {0x00,0x7c,0x08,0x10,0x10,0xfe,0x00,0x00},
    {0x7e,0x02,0x3e,0x02,0x04,0x08,0x30,0x00},
    {0x40,0x20,0x02,0x02,0x04,0x08,0x70,0x00},
    {0x12,0x7e,0x42,0x02,0x04,0x08,0x30,0x00},
    {0x00,0x00,0x10,0x7c,0x14,0x24,0x4c,0x00},
    {0x00,0x00,0x20,0x3c,0x48,0x08,0x10,0x00},
    {0x10,0x28,0x28,0x44,0x7c,0x82,0x82,0x00},
    {0x7c,0x42,0x42,0x7c,0x42,0x42,0x7c,0x00},
    {0x7e,0x40,0x40,0x40,0x40,0x40,0x40,0x00},
    {0x10,0x28,0x28,0x44,0x44,0x82,0xfe,0x00},
    {0x7e,0x40,0x40,0x7c,0x40,0x40,0x7e,0x00},
    {0x7e,0x02,0x04,0x08,0x10,0x20,0x7e,0x00},
    {0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x00},
    {0x38,0x44,0x82,0xba,0x82,0x44,0x38,0x00},
    {0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00},
    {0x42,0x44,0x48,0x50,0x68,0x44,0x42,0x00},
    {0x10,0x28,0x28,0x44,0x44,0x82,0x82,0x00},
    {0x82,0xc6,0xaa,0xaa,0x92,0x92,0x82,0x00},
    {0x42,0x62,0x52,0x4a,0x46,0x42,0x42,0x00},
    {0x7e,0x00,0x00,0x3c,0x00,0x00,0x7e,0x00},
    {0x18,0x24,0x42,0x42,0x42,0x24,0x18,0x00},
    {0x7e,0x42,0x42,0x42,0x42,0x42,0x42,0x00},
    {0x7c,0x42,0x42,0x7c,0x40,0x40,0x40,0x00},
    {0x7e,0x20,0x10,0x08,0x10,0x20,0x7e,0x00},
    {0xfe,0x10,0x10,0x10,0x10,0x10,0x10,0x00},
    {0x82,0x44,0x28,0x10,0x10,0x10,0x10,0x00},
    {0x10,0x7c,0x92,0x92,0x92,0x7c,0x10,0x00},
    {0x82,0x44,0x28,0x10,0x28,0x44,0x82,0x00},
    {0x92,0x54,0x54,0x38,0x10,0x10,0x10,0x00},
    {0x38,0x44,0x82,0x82,0x44,0x28,0xee,0x00},
    {0x00,0x00,0x1a,0x24,0x48,0x48,0x34,0x00},
    {0x0c,0x12,0x2c,0x22,0x32,0x4c,0x40,0x00},
    {0x00,0x00,0x64,0x18,0x10,0x30,0x20,0x00},
    {0x18,0x24,0x10,0x28,0x48,0x48,0x30,0x00},
    {0x00,0x00,0x18,0x24,0x30,0x44,0x38,0x00},
    {0x2c,0x10,0x20,0x20,0x10,0x08,0x30,0x00},
    {0x00,0x00,0x2c,0x52,0x12,0x24,0x04,0x00},
    {0x18,0x24,0x24,0x7c,0x48,0x48,0x30,0x00},
    {0x00,0x00,0x10,0x10,0x20,0x28,0x10,0x00},
    {0x00,0x00,0x24,0x28,0x30,0x50,0x4c,0x00},
    {0x10,0x08,0x08,0x18,0x28,0x28,0x44,0x00},
    {0x00,0x00,0x12,0x12,0x24,0x3a,0x40,0x00},
    {0x00,0x00,0x44,0x24,0x28,0x30,0x20,0x00},
    {0x1c,0x20,0x3c,0x40,0x30,0x08,0x30,0x00},
    {0x00,0x00,0x18,0x24,0x44,0x48,0x30,0x00},
    {0x00,0x00,0x3e,0x54,0x14,0x24,0x46,0x00},
    {0x00,0x00,0x1c,0x22,0x22,0x5c,0x40,0x00},
    {0x00,0x00,0x1e,0x24,0x44,0x48,0x30,0x00},
    {0x00,0x00,0x3e,0x48,0x10,0x14,0x08,0x00},
    {0x00,0x00,0x32,0x52,0x22,0x24,0x18,0x00},
    {0x04,0x04,0x3c,0x4a,0x4a,0x3c,0x10,0x00},
    {0x00,0x00,0x34,0x08,0x10,0x30,0x4c,0x00},
    {0x04,0x04,0x68,0x2a,0x4a,0x3c,0x10,0x00},
    {0x00,0x00,0x22,0x4a,0x4a,0x5a,0x24,0x00},
    {0x10,0x28,0x28,0x44,0x7c,0x82,0x82,0x00},
    {0x7e,0x40,0x40,0x7c,0x42,0x42,0x7c,0x00},
    {0x7c,0x42,0x42,0x7c,0x42,0x42,0x7c,0x00},
    {0x7e,0x40,0x40,0x40,0x40,0x40,0x40,0x00},
    {0x3c,0x24,0x24,0x24,0x44,0xfe,0x82,0x00},
    {0x7e,0x40,0x40,0x7c,0x40,0x40,0x7e,0x00},
    {0x24,0x7e,0x40,0x7c,0x40,0x40,0x7e,0x00},
    {0x92,0x54,0x54,0x38,0x54,0x54,0x92,0x00},
    {0x3c,0x42,0x02,0x1c,0x02,0x42,0x3c,0x00},
    {0x42,0x42,0x46,0x4a,0x52,0x62,0x42,0x00},
    {0x24,0x5a,0x46,0x4a,0x52,0x62,0x42,0x00},
    {0x46,0x48,0x48,0x70,0x48,0x44,0x42,0x00},
    {0x3e,0x22,0x22,0x22,0x22,0x22,0xc2,0x00},
    {0x44,0x44,0x44,0xaa,0xaa,0x92,0x92,0x00},
    {0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x00},
    {0x18,0x24,0x42,0x42,0x42,0x24,0x18,0x00},
    {0x7e,0x42,0x42,0x42,0x42,0x42,0x42,0x00},
    {0x7c,0x42,0x42,0x7c,0x40,0x40,0x40,0x00},
    {0x1c,0x22,0x40,0x40,0x40,0x22,0x1c,0x00},
    {0xfe,0x10,0x10,0x10,0x10,0x10,0x10,0x00},
    {0x42,0x24,0x24,0x18,0x08,0x10,0x60,0x00},
    {0x10,0x7c,0x92,0x92,0x92,0x7c,0x10,0x00},
    {0x82,0x44,0x28,0x10,0x28,0x44,0x82,0x00},
    {0x44,0x44,0x44,0x44,0x44,0x7e,0x02,0x00},
    {0x42,0x42,0x42,0x42,0x3e,0x02,0x02,0x00},
    {0x92,0x92,0x92,0x92,0x92,0x92,0xfe,0x00},
    {0x92,0x92,0x92,0x92,0x92,0xfe,0x02,0x00},
    {0x60,0x20,0x20,0x3c,0x22,0x22,0x3c,0x00},
    {0x42,0x42,0x42,0x72,0x4a,0x4a,0x72,0x00},
    {0x20,0x20,0x20,0x3c,0x22,0x22,0x3c,0x00},
    {0x38,0x44,0x02,0x3e,0x02,0x44,0x38,0x00},
    {0x9c,0xa2,0xa2,0xe2,0xa2,0xa2,0x9c,0x00},
    {0x3e,0x42,0x42,0x3e,0x22,0x22,0x42,0x00},
    {0x00,0x00,0x38,0x04,0x3c,0x44,0x3c,0x00},
    {0x1c,0x20,0x78,0x44,0x44,0x44,0x38,0x00},
    {0x00,0x00,0x78,0x44,0x78,0x44,0x78,0x00},
    {0x00,0x00,0x7c,0x40,0x40,0x40,0x40,0x00},
    {0x00,0x00,0x38,0x28,0x28,0x7c,0x44,0x00},
    {0x00,0x00,0x38,0x44,0x7c,0x40,0x38,0x00},
    {0x28,0x00,0x38,0x44,0x7c,0x40,0x38,0x00},
    {0x00,0x00,0x92,0x54,0x38,0x54,0x92,0x00},
    {0x00,0x00,0x38,0x44,0x18,0x44,0x38,0x00},
    {0x00,0x00,0x44,0x4c,0x54,0x64,0x44,0x00},
    {0x28,0x10,0x44,0x4c,0x54,0x64,0x44,0x00},
    {0x00,0x00,0x4c,0x50,0x70,0x48,0x44,0x00},
    {0x00,0x00,0x3c,0x24,0x24,0x24,0xc4,0x00},
    {0x00,0x00,0x44,0x6c,0x54,0x54,0x44,0x00},
    {0x00,0x00,0x44,0x44,0x7c,0x44,0x44,0x00},
    {0x00,0x00,0x38,0x44,0x44,0x44,0x38,0x00},
    {0x00,0x00,0x7c,0x44,0x44,0x44,0x44,0x00},
    {0x00,0x00,0x78,0x44,0x78,0x40,0x40,0x00},
    {0x00,0x00,0x38,0x44,0x40,0x44,0x38,0x00},
    {0x00,0x00,0x7c,0x10,0x10,0x10,0x10,0x00},
    {0x00,0x00,0x44,0x28,0x28,0x10,0x60,0x00},
    {0x10,0x10,0x38,0x54,0x54,0x38,0x10,0x00},
    {0x00,0x00,0x44,0x28,0x10,0x28,0x44,0x00},
    {0x00,0x00,0x48,0x48,0x48,0x7c,0x04,0x00},
    {0x00,0x00,0x44,0x44,0x44,0x3c,0x04,0x00},
    {0x00,0x00,0x54,0x54,0x54,0x54,0x7c,0x00},
    {0x00,0x00,0x54,0x54,0x54,0x7e,0x02,0x00},
    {0x00,0x00,0x60,0x20,0x3c,0x22,0x3c,0x00},
    {0x00,0x00,0x44,0x44,0x74,0x4c,0x74,0x00},
    {0x00,0x00,0x40,0x40,0x78,0x44,0x78,0x00},
    {0x00,0x00,0x38,0x44,0x1c,0x44,0x38,0x00},
    {0x00,0x00,0x4c,0x52,0x72,0x52,0x4c,0x00},
    {0x00,0x00,0x3c,0x44,0x3c,0x24,0x44,0x00},
    {0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00},
    {0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10},
    {0x00,0x00,0x00,0x1f,0x10,0x10,0x10,0x10},
    {0x00,0x00,0x00,0xf0,0x10,0x10,0x10,0x10},
    {0x10,0x10,0x10,0xf0,0x00,0x00,0x00,0x00},
    {0x10,0x10,0x10,0x1f,0x00,0x00,0x00,0x00},
    {0x10,0x10,0x10,0x1f,0x10,0x10,0x10,0x10},
    {0x00,0x00,0x00,0xff,0x10,0x10,0x10,0x10},
    {0x10,0x10,0x10,0xf0,0x10,0x10,0x10,0x10},
    {0x10,0x10,0x10,0xff,0x00,0x00,0x00,0x00},
    {0x10,0x10,0x10,0xff,0x10,0x10,0x10,0x10},
    {0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00},
    {0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18},
    {0x00,0x00,0x00,0x1f,0x1f,0x18,0x18,0x18},
    {0x00,0x00,0x00,0xf8,0xf8,0x18,0x18,0x18},
    {0x18,0x18,0x18,0xf8,0xf8,0x00,0x00,0x00},
    {0x18,0x18,0x18,0x1f,0x1f,0x00,0x00,0x00},
    {0x18,0x18,0x18,0x1f,0x1f,0x18,0x18,0x18},
    {0x00,0x00,0x00,0xff,0xff,0x18,0x18,0x18},
    {0x18,0x18,0x18,0xf8,0xf8,0x18,0x18,0x18},
    {0x18,0x18,0x18,0xff,0xff,0x00,0x00,0x00},
    {0x18,0x18,0x18,0xff,0xff,0x18,0x18,0x18},
    {0x18,0x18,0x18,0x1f,0x18,0x18,0x18,0x18},
    {0x00,0x00,0x00,0xff,0xff,0x10,0x10,0x10},
    {0x18,0x18,0x18,0xf8,0x18,0x18,0x18,0x18},
    {0x10,0x10,0x10,0xff,0xff,0x00,0x00,0x00},
    {0x10,0x10,0x10,0xff,0xff,0x10,0x10,0x10},
    {0x10,0x10,0x10,0x1f,0x1f,0x10,0x10,0x10},
    {0x00,0x00,0x00,0xff,0x18,0x18,0x18,0x18},
    {0x10,0x10,0x10,0xf0,0xf0,0x10,0x10,0x10},
    {0x18,0x18,0x18,0xff,0x00,0x00,0x00,0x00},
    {0x18,0x18,0x18,0xff,0x18,0x18,0x18,0x18},
    {0x7c,0x92,0xb2,0x92,0x92,0x92,0x7c,0x00},
    {0x7c,0xb2,0x8a,0x92,0xa2,0xba,0x7c,0x00},
    {0x7c,0xb2,0x8a,0x92,0x8a,0xb2,0x7c,0x00},
    {0x7c,0x8a,0x9a,0xaa,0xba,0x8a,0x7c,0x00},
    {0x7c,0xba,0xa2,0xb2,0x8a,0xb2,0x7c,0x00},
    {0x7c,0x9a,0xa2,0xb2,0xaa,0x92,0x7c,0x00},
    {0x7c,0xba,0x8a,0x92,0x92,0x92,0x7c,0x00},
    {0x7c,0x92,0xaa,0x92,0xaa,0x92,0x7c,0x00},
    {0x7c,0x92,0xaa,0x9a,0x8a,0xb2,0x7c,0x00},
    {0x7c,0xa2,0xee,0xaa,0xae,0xa2,0x7c,0x00},
    {0x7c,0xa6,0xee,0xa6,0xa6,0xa6,0x7c,0x00},
    {0x7c,0xaa,0xe6,0xae,0xaa,0xae,0x7c,0x00},
    {0x7c,0xaa,0xe6,0xaa,0xa6,0xaa,0x7c,0x00},
    {0x7c,0xaa,0xea,0xae,0xae,0xa6,0x7c,0x00},
    {0x7c,0xae,0xea,0xae,0xa6,0xaa,0x7c,0x00},
    {0x7c,0xa6,0xea,0xae,0xae,0xae,0x7c,0x00},
    {0x7c,0xae,0xe6,0xaa,0xaa,0xaa,0x7c,0x00},
    {0x7c,0xae,0xee,0xa2,0xae,0xae,0x7c,0x00},
    {0x7c,0xae,0xee,0xae,0xa6,0xaa,0x7c,0x00},
    {0x7c,0xe2,0xae,0xea,0xce,0xe2,0x7c,0x00},
    {0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00},
    {0x7c,0x28,0x28,0x28,0x28,0x28,0x7c,0x00},
    {0xfe,0x54,0x54,0x54,0x54,0x54,0xfe,0x00},
    {0xfe,0x54,0x54,0x54,0x48,0x48,0xe8,0x00},
    {0xee,0x44,0x44,0x28,0x28,0x10,0x10,0x00},
    {0xfe,0x54,0x54,0x54,0x24,0x24,0x2e,0x00},
    {0xfe,0xb4,0xb4,0xb4,0x54,0x54,0x5e,0x00},
    {0xfe,0xbc,0xbc,0xbc,0x5c,0x5c,0x5e,0x00},
    {0xfe,0x54,0x54,0x48,0x54,0x54,0xfe,0x00},
    {0xee,0x44,0x28,0x10,0x28,0x44,0xee,0x00},
    {0xe0,0x00,0x60,0x0a,0xea,0x02,0x04,0x00},
    {0x40,0xe0,0x40,0xee,0x4a,0x0a,0x0e,0x00},
    {0x8c,0xe0,0xa2,0xcc,0x40,0xe0,0x40,0x00},
    {0xa0,0x4e,0xa0,0x00,0x8c,0xcc,0x96,0x00},
    {0x76,0xae,0x22,0xcc,0x20,0x50,0xf0,0x00},
    {0x80,0x80,0xe0,0x8c,0x00,0x02,0x0c,0x00},
    {0xf0,0x56,0x60,0x80,0x60,0x60,0xb0,0x00},
    {0x46,0xaa,0x02,0x6c,0xbc,0x4c,0x96,0x00},
    {0xa0,0xae,0x22,0x00,0x8c,0xcc,0x96,0x00},
    {0xe0,0xae,0x22,0x40,0x40,0x60,0x40,0x00},
    {0xee,0x6a,0xae,0x00,0xa0,0xae,0x20,0x00},
    {0xa8,0x80,0xe0,0x80,0x14,0x14,0x26,0x00},
    {0x8c,0xe0,0xa2,0xcc,0x40,0x60,0x40,0x00},
    {0x70,0xb6,0xa0,0x00,0x94,0xc6,0xdc,0x00},
    {0xea,0x6a,0x72,0x00,0x6c,0xbc,0xb6,0x00},
    {0x50,0xa6,0x10,0xc0,0xd0,0x20,0xc0,0x00},
    {0x00,0x00,0xcc,0xee,0xee,0xee,0xaa,0x00},
    {0x00,0x00,0x6c,0x8e,0x8e,0x8e,0x6a,0x00},
    {0x80,0x80,0xac,0xae,0xce,0xae,0xaa,0x00},
    {0x00,0x00,0xc6,0xea,0xe6,0xe2,0xac,0x00},
    {0x80,0x80,0xa6,0xaa,0xc6,0xa2,0xac,0x00},
    {0x00,0x00,0x66,0x88,0x88,0x88,0x66,0x00},
    {0x06,0x02,0xd4,0xae,0xa8,0xa8,0xa8,0x00},
    {0xe4,0x4e,0xec,0x4c,0xee,0x4c,0x52,0x00},
    {0x14,0x14,0x0a,0x00,0x00,0x00,0x00,0x00},
    {0x00,0x00,0x00,0x00,0xa0,0x50,0x50,0x00},
    {0x90,0x90,0xd4,0xba,0x9a,0x9a,0x94,0x00},
    {0xaa,0xaa,0xaa,0xcc,0xaa,0xaa,0xaa,0x00},
    {0xe2,0x42,0x4a,0x56,0x5a,0x52,0x4a,0x00},
    {0x7c,0x92,0x9a,0x92,0x92,0xba,0x7c,0x00},
    {0x7c,0x92,0xfe,0xd6,0xfe,0x92,0x7c,0x00},
    {0x7c,0xba,0x92,0x9a,0x92,0x92,0x7c,0x00},
    {0x7c,0xfa,0xa2,0xba,0xd2,0xba,0x7c,0x00},
    {0x7c,0xa2,0xfa,0xa2,0xda,0x9a,0x7c,0x00},
    {0x44,0xf2,0xbe,0xea,0xfe,0xaa,0x6c,0x00},
    {0x54,0xba,0x92,0xbe,0xd6,0x9e,0x54,0x00},
    {0x44,0xaa,0xbe,0xea,0xaa,0xa6,0x44,0x00},
    {0x6a,0xe4,0xec,0xe6,0x68,0x6e,0xae,0x00},
    {0x5e,0x44,0xe4,0x56,0x54,0xb4,0xbe,0x00},
    {0x6c,0xe6,0xee,0xa6,0x8e,0x6c,0x64,0x00},
    {0x40,0x00,0xfe,0x00,0xfe,0x00,0x04,0x00},
    {0x00,0x7e,0x00,0x7e,0x00,0x7e,0x00,0x00},
    {0x18,0x20,0x20,0x10,0x08,0x08,0x30,0x00},
    {0x18,0x20,0x38,0x54,0x38,0x08,0x30,0x00},
    {0x7e,0x20,0x10,0x08,0x10,0x20,0x7e,0x00},
    {0x1e,0x10,0x20,0x20,0xe0,0x40,0x40,0x00},
    {0x00,0x10,0x10,0x10,0x10,0x10,0xfe,0x00},
    {0x00,0x02,0x04,0x08,0x10,0x20,0x7e,0x00},
    {0x00,0x40,0x40,0x40,0x40,0x40,0x7e,0x00},
    {0x00,0x02,0x06,0x0a,0x12,0x22,0x7e,0x00},
    {0x00,0x44,0x00,0x00,0x00,0x10,0x00,0x00},
    {0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x00},
    {0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00},
    {0xfe,0x28,0xfe,0xaa,0xfe,0x28,0xfe,0x00},
    {0x3e,0xd4,0xbe,0xb6,0xfe,0x14,0x3e,0x00},
    {0x24,0x2e,0xf4,0x5e,0x6e,0x34,0xce,0x00},
    {0xfe,0xa2,0xde,0xb6,0xbe,0xc2,0x86,0x00},
    {0x10,0xfe,0x44,0x7c,0x2a,0xe4,0x32,0x00},
    {0xfe,0x54,0xfe,0xaa,0x5c,0x28,0xd6,0x00},
    {0x48,0xf2,0x5e,0x68,0xde,0x44,0xda,0x00},
    {0x24,0x2a,0xfe,0x50,0x6e,0x3a,0xce,0x00},
    {0x8c,0x34,0x1a,0xc8,0x7e,0x48,0xbe,0x00},
    {0x28,0xfe,0xea,0x44,0xba,0x10,0xee,0x00},
    {0x28,0xfe,0x28,0xfe,0x6c,0x44,0x7c,0x00},
    {0xec,0x54,0xec,0x5e,0xf6,0xdc,0x46,0x00},
    {0xfe,0x7c,0x7c,0xfe,0x54,0xca,0xba,0x00},
    {0x5e,0xfe,0x54,0x78,0xde,0x54,0xee,0x00},
    {0xbe,0x3e,0xa4,0x2a,0xbe,0xa4,0xde,0x00},
    {0x4e,0xfa,0x5e,0x5a,0x5e,0x50,0x9e,0x00},
    {0x28,0xfe,0x24,0xfe,0x48,0xfe,0x08,0x00},
    {0x28,0xfe,0x28,0xfe,0x44,0x7c,0x80,0x00},
    {0x68,0xb4,0x7a,0x74,0x6a,0x04,0xb8,0x00},
    {0x48,0xfe,0x54,0xfe,0xc8,0x7e,0x48,0x00},
    {0x7e,0x48,0x48,0x5c,0x48,0x48,0xbe,0x00},
    {0xe8,0x54,0xe6,0xb4,0x44,0xfe,0x44,0x00},
    {0x7c,0xd4,0x56,0x52,0xda,0x64,0xda,0x00},
    {0x10,0xfe,0x82,0x7e,0xda,0x28,0xce,0x00},
    {0x5c,0x54,0xfc,0xb4,0xdc,0x54,0xbe,0x00},
    {0x44,0xfe,0xb0,0xf0,0x50,0x70,0xce,0x00},
    {0x48,0xa8,0x54,0xfa,0xc0,0x9c,0xdc,0x00},
    {0x50,0x9e,0x7e,0xb6,0x5e,0xf6,0x5e,0x00},
    {0x48,0x9c,0x48,0xbe,0x54,0xe8,0x56,0x00},
    {0x68,0xa8,0x6e,0x68,0x7e,0x12,0xbe,0x00},
    {0x0a,0xfe,0x08,0x68,0x6a,0x04,0xda,0x00},
    {0xfe,0x7c,0x10,0x54,0xfe,0x38,0xd6,0x00},
    {0x44,0xea,0x2e,0x40,0xee,0x6a,0x4e,0x00},
    {0x10,0xfe,0x92,0x7c,0x28,0x18,0xe6,0x00},
    {0x08,0x7e,0x54,0x6a,0x5c,0x5c,0x86,0x00},
    {0x48,0xfe,0x6a,0x7e,0xd4,0x4c,0xf2,0x00},
    {0x08,0xfe,0xb4,0xfe,0xa0,0xec,0x0c,0x00},
    {0x10,0xfe,0xaa,0x34,0xfe,0x38,0xd6,0x00},
    {0xee,0xee,0x92,0xfe,0xaa,0xfe,0xba,0x00},
    {0xa8,0xfe,0xea,0x7e,0xd4,0xcc,0x72,0x00},
    {0x10,0xfe,0x38,0xd6,0x7c,0x44,0x7c,0x00},
    {0x44,0x54,0x4c,0x44,0x64,0x8c,0x32,0x00},
    {0x3e,0x4a,0xfe,0x4a,0x5e,0x48,0x50,0x00},
    {0x28,0x7e,0xd4,0x54,0x54,0x58,0x7e,0x00},
    {0x28,0x7e,0xc8,0x5a,0x74,0x54,0x5a,0x00},
    {0x28,0x5e,0xca,0x7e,0x54,0x7e,0x44,0x00},
    {0xfe,0xaa,0xfe,0xaa,0xfe,0xaa,0xfe,0x00},
    {0x10,0xfe,0x7c,0x50,0x7c,0x14,0xee,0x00},
    {0x38,0xfe,0x38,0xd6,0x7c,0x28,0xf6,0x00},
    {0x04,0x7e,0x7c,0x54,0x6e,0x54,0xaa,0x00},
    {0x72,0x7e,0x42,0x76,0x46,0x72,0xa6,0x00},
    {0x54,0xde,0xf4,0x5e,0x54,0x54,0x5e,0x00},
    {0x10,0x7c,0x28,0xfe,0x38,0xca,0xba,0x00},
    {0x72,0x7e,0x4a,0x72,0xa6,0x48,0xba,0x00},
    {0x7c,0x44,0x7c,0x20,0x7e,0xaa,0x56,0x00},
    {0x48,0xfe,0x48,0xd4,0xfe,0x44,0x54,0x00},
    {0x28,0x78,0x1c,0x24,0x7e,0x82,0x56,0x00},
    {0x7c,0x54,0x7c,0x54,0xfe,0x48,0xe6,0x00},
    {0x7c,0x54,0x7c,0x28,0xfe,0x00,0xc6,0x00},
    {0xec,0x54,0xe8,0x56,0xea,0xc4,0x58,0x00},
    {0x54,0x9e,0x54,0xbe,0x54,0xf4,0x5e,0x00},
    {0x48,0x9e,0x4a,0xbe,0x54,0xfe,0x44,0x00},
    {0x7e,0x52,0x7e,0x7e,0x24,0x3c,0x24,0x00},
    {0x28,0xfe,0x38,0x54,0xfe,0x28,0xf6,0x00},
    {0x10,0xfe,0x10,0x2a,0xec,0x24,0x72,0x00},
    {0xbe,0xea,0x3e,0xbe,0x14,0xdc,0xd4,0x00},
    {0x9e,0x0a,0x3e,0xd4,0x7e,0x44,0xbe,0x00},
    {0x88,0x3e,0x2a,0xfe,0x5c,0x62,0xbe,0x00},
    {0xfe,0x90,0x9c,0xbe,0x88,0xb6,0xfe,0x00},
    {0x24,0xfe,0x24,0x24,0xfe,0x24,0x44,0x00},
    {0x10,0xfe,0x20,0x54,0x28,0x14,0xe2,0x00},
    {0x44,0x7e,0xc4,0x74,0x76,0xcc,0x32,0x00},
    {0x10,0xfe,0x24,0xfa,0x44,0x7c,0x44,0x00},
    {0x4e,0xfa,0x4c,0x7a,0xda,0x7c,0x58,0x00},
    {0xd2,0x64,0x52,0x9c,0x76,0x74,0x2a,0x00},
    {0x00,0x00,0x04,0xfe,0x00,0x00,0x00,0x00},
    {0x10,0xfe,0x10,0xfe,0xba,0x20,0x3c,0x00},
    {0x94,0x3e,0x94,0x22,0x9c,0x9c,0xbe,0x00},
    {0x8c,0x34,0x1e,0xde,0x4c,0x56,0xbe,0x00},
    {0xe6,0x58,0xea,0x40,0xf6,0xd6,0x56,0x00},
    {0x28,0xfe,0x10,0x9e,0x2a,0x08,0xb6,0x00},
    {0x28,0xfe,0x28,0x7c,0x10,0xfe,0x30,0x00},
    {0xf6,0x52,0xf6,0xe4,0xf6,0x1a,0xb6,0x00},
    {0x10,0x24,0xfa,0x28,0x28,0x4a,0x8e,0x00},
    {0x2e,0xca,0x8a,0xea,0x8a,0xe8,0x08,0x00},
    {0x3e,0xea,0xbe,0xaa,0xf6,0x22,0x3e,0x00},
    {0x38,0x28,0x7c,0x7c,0x44,0x7c,0xc6,0x00},
    {0xfe,0x92,0xfe,0x92,0xaa,0xc6,0xfe,0x00},
    {0xbe,0xaa,0xfe,0xea,0xf6,0x62,0xbe,0x00},
    {0xf2,0x12,0xf2,0x82,0xf2,0x12,0x32,0x00},
    {0x48,0xae,0x56,0xe4,0xe4,0x84,0xea,0x00},
    {0x86,0x38,0xaa,0x00,0xbe,0x88,0xbe,0x00},
    {0x54,0x64,0x54,0x7c,0x6c,0x7c,0xae,0x00},
    {0x28,0xfe,0xc8,0x94,0xfe,0xd4,0xba,0x00},
    {0xc8,0xfe,0xa2,0xdc,0xfe,0x94,0xa6,0x00},
    {0xc8,0xd4,0xba,0xc8,0xfe,0x94,0xba,0x00},
    {0xc6,0xf8,0xaa,0xdc,0xdc,0xb2,0xae,0x00},
    {0x2c,0xfc,0x5e,0xf2,0x1e,0x60,0x72,0x00},
    {0x04,0xfe,0xa4,0xb4,0xec,0x04,0x0c,0x00},
    {0x20,0xfe,0x20,0x7c,0xa4,0x24,0x3c,0x00},
    {0x10,0xfe,0xba,0x10,0xfe,0x10,0x30,0x00},
    {0x10,0x7c,0x44,0x7c,0x7e,0x02,0xaa,0x00},
    {0xfe,0x12,0x5a,0x12,0x36,0xda,0x36,0x00},
    {0x9c,0x08,0x3e,0xc8,0x48,0x58,0xbe,0x00},
    {0xfe,0x10,0xfe,0x92,0xb6,0x92,0xb6,0x00},
    {0x2e,0xca,0xaa,0xaa,0xea,0x28,0x48,0x00},
    {0x54,0xfe,0x2e,0xf8,0xae,0x72,0xba,0x00},
    {0x10,0xfe,0xaa,0x4e,0xee,0x4c,0xb6,0x00},
    {0x7c,0x14,0x14,0xfe,0x24,0x24,0xfe,0x00},
    {0xf4,0x5e,0x54,0x9e,0x74,0x74,0x1e,0x00},
    {0x20,0xce,0x82,0xee,0x82,0x82,0xfe,0x00},
    {0x9c,0x14,0x94,0x3e,0xa2,0xae,0xae,0x00},
    {0x08,0xee,0xb8,0xae,0xe0,0x34,0x5e,0x00},
    {0x1e,0xf2,0xbe,0xb2,0xfe,0x00,0x12,0x00},
    {0x54,0xee,0x54,0xfe,0x7c,0x64,0x74,0x00},
    {0x28,0xfe,0x72,0x7e,0x4a,0x72,0xa6,0x00},
    {0xdc,0x54,0xfe,0xfe,0xd4,0x08,0xb6,0x00},
    {0x4a,0x5c,0xe8,0xbe,0xd0,0x68,0x8e,0x00},
    {0x7e,0x5e,0x6a,0x6a,0x5e,0x6c,0x96,0x00},
    {0x8a,0x3e,0x88,0x3e,0xaa,0xbe,0xaa,0x00},
    {0x0c,0x70,0x54,0x54,0x54,0x54,0xba,0x00},
    {0xee,0xaa,0xfe,0x92,0xba,0x92,0xba,0x00},
    {0x14,0xfe,0xb6,0xa2,0xfe,0x14,0x0c,0x00},
    {0x7c,0x00,0xfe,0x10,0x10,0x24,0xfa,0x00},
    {0xbe,0x2a,0x1c,0xdc,0x7e,0x48,0xbe,0x00},
    {0x38,0xfe,0xb6,0x00,0xfe,0x24,0xfa,0x00},
    {0x28,0xfe,0x3c,0x48,0xfe,0x48,0x5c,0x00},
    {0x5e,0xaa,0x4e,0xee,0xea,0x9e,0xe2,0x00},
    {0x2e,0x32,0xfa,0xaa,0x54,0xb4,0x3a,0x00},
    {0x54,0xfe,0xaa,0x38,0x10,0x7c,0x7c,0x00},
    {0x6c,0x6c,0x92,0x20,0xfe,0x28,0xf6,0x00},
    {0x72,0x54,0xfa,0x54,0x70,0x22,0xac,0x00},
    {0x08,0xfc,0xb4,0xfe,0xa8,0xe8,0x36,0x00},
    {0x20,0xf8,0xa8,0xf8,0x14,0x08,0xf6,0x00},
    {0x54,0xfe,0x92,0x7c,0x10,0x38,0xd6,0x00},
    {0x30,0x00,0x32,0xd4,0x58,0x94,0x32,0x00},
    {0x98,0x00,0x98,0x6a,0xac,0xca,0x98,0x00},
    {0x88,0x3c,0xac,0x3c,0x8a,0x84,0xba,0x00},
    {0x14,0xfe,0x54,0xea,0x7e,0xc8,0x36,0x00},
    {0xf8,0x2e,0x52,0xaa,0x7c,0x54,0xfe,0x00},
    {0x9e,0xe4,0x8e,0x6a,0xfe,0x70,0xaa,0x00},
    {0x9e,0xe4,0x8e,0x6a,0xfe,0x20,0xaa,0x00},
    {0x28,0xfe,0x28,0x54,0xfe,0x10,0xee,0x00},
    {0x56,0xb8,0x5e,0xea,0x52,0x7a,0x56,0x00},
    {0x58,0xc0,0x18,0xba,0x1c,0xea,0xd8,0x00},
    {0x54,0xbe,0xe2,0x7e,0xd4,0x54,0xe6,0x00},
    {0x88,0x3e,0x90,0x16,0xba,0x94,0x9a,0x00},
    {0x08,0x7e,0xdc,0x54,0xee,0x4c,0xb6,0x00},
    {0x24,0xfe,0x28,0xc6,0x7c,0x54,0xfe,0x00},
    {0xee,0xca,0xea,0xcc,0xec,0x2a,0xb2,0x00},
    {0x54,0xfe,0xe2,0x7e,0x54,0x54,0x66,0x00},
    {0x5c,0xd4,0x1c,0xde,0x32,0xda,0xc6,0x00},
    {0x44,0xfe,0x54,0xf6,0x54,0xda,0xbe,0x00},
    {0xee,0xee,0xaa,0xba,0xaa,0xb2,0xde,0x00},
    {0x7e,0xdc,0x5c,0xdc,0xf4,0x48,0x76,0x00},
    {0x7e,0x74,0x4e,0x74,0x74,0x74,0xba,0x00},
    {0xfe,0x92,0x92,0xfe,0x82,0x82,0x86,0x00},
    {0xfe,0xba,0xfe,0xaa,0xba,0xd6,0xfe,0x00},
    {0x7e,0x6c,0xec,0x7a,0x64,0xea,0x3e,0x00},
    {0x10,0xfe,0x28,0xd6,0x7c,0x7c,0x0e,0x00},
    {0x10,0xfe,0xaa,0x38,0xfe,0x28,0xf6,0x00},
    {0xc2,0x5c,0x86,0x54,0xde,0x40,0xbe,0x00},
    {0x7e,0xda,0x28,0xce,0x14,0xca,0xba,0x00},
    {0x48,0xfe,0x54,0x6a,0xdc,0x5c,0xc6,0x00},
    {0x46,0xf8,0x6a,0x5e,0xca,0x54,0xea,0x00},
    {0x94,0x14,0x94,0x22,0x9c,0x94,0x9c,0x00},
    {0x88,0x3e,0xa2,0x1c,0xaa,0xbe,0x94,0x00},
    {0x10,0x54,0x28,0xc6,0x54,0x28,0xc6,0x00},
    {0x4e,0x52,0xe4,0xd6,0x56,0x76,0x96,0x00},
    {0x5e,0x4c,0xfe,0xde,0x5e,0x64,0x9e,0x00},
    {0x28,0xfe,0xde,0x54,0xde,0x00,0xaa,0x00},
    {0xa8,0x5c,0xbe,0x72,0xbe,0x34,0xda,0x00},
    {0x5c,0x84,0x7e,0x90,0x5a,0xec,0x5a,0x00},
    {0x56,0xfa,0xf4,0x9e,0xee,0x78,0xee,0x00},
    {0x28,0xfe,0x28,0x7e,0xda,0x28,0xce,0x00},
    {0x28,0xfe,0xfe,0xaa,0xba,0xd6,0xfe,0x00},
    {0x88,0x1c,0x3e,0xd4,0x5c,0x6a,0xbe,0x00},
    {0x54,0xb4,0xd4,0x62,0xdc,0x54,0xdc,0x00},
    {0x7e,0xda,0x28,0xfe,0x3e,0x02,0xaa,0x00},
    {0x50,0x5e,0xf4,0x5c,0x40,0xdc,0x3e,0x00},
    {0x48,0xf4,0x42,0x68,0x64,0xa8,0xa4,0x00},
    {0xbe,0x10,0xbe,0x10,0x5e,0x82,0x86,0x00},
    {0xde,0xf6,0x5e,0xf6,0x5e,0xea,0x16,0x00},
    {0xee,0xaa,0xaa,0xba,0x82,0x82,0xfe,0x00},
    {0x10,0x7c,0x54,0xfe,0x10,0x28,0xc6,0x00},
    {0x10,0x7c,0x5c,0x74,0xfe,0x10,0xee,0x00},
    {0x50,0x88,0x7e,0xc8,0x5c,0x48,0x7e,0x00},
    {0x08,0x7e,0x50,0x48,0x50,0x76,0x9c,0x00},
    {0x7e,0xea,0x7e,0x6a,0xfe,0x48,0xc8,0x00},
    {0x1e,0xe4,0xa4,0xee,0xa4,0xe4,0x1e,0x00},
    {0x54,0xfe,0x54,0xfe,0xdc,0x5c,0x62,0x00},
    {0xe8,0x8e,0xd6,0xa4,0xd4,0x84,0xea,0x00},
    {0xee,0x8a,0xd0,0xae,0xda,0x84,0xea,0x00},
    {0xfe,0x10,0x10,0x7c,0x10,0x10,0xfe,0x00},
    {0x28,0xc6,0x20,0xfe,0x5a,0x36,0xda,0x00},
    {0x48,0xfe,0x36,0x5a,0xfe,0x68,0x56,0x00},
    {0x54,0xfe,0x92,0x38,0x3e,0x02,0xaa,0x00},
    {0xe4,0x8e,0xde,0xa8,0xde,0x82,0xea,0x00},
    {0x28,0xfe,0x28,0xfe,0x54,0x7c,0xc6,0x00},
    {0xfe,0xaa,0xfe,0x92,0xd6,0xfe,0x82,0x00},
    {0x88,0x3e,0xaa,0x2a,0xbe,0x88,0x88,0x00},
    {0x28,0xfe,0xa4,0x56,0xb4,0x24,0xda,0x00},
    {0x28,0x7e,0xd4,0x7e,0x5c,0x72,0x6e,0x00},
    {0x7e,0x42,0x7e,0x54,0x7a,0x48,0xbe,0x00},
    {0x48,0xfe,0xd4,0x7e,0x5c,0x72,0x6e,0x00},
    {0xe8,0xbe,0xf4,0xbe,0xec,0xba,0xb6,0x00},
    {0x5e,0xc4,0x7e,0xea,0xfe,0x6a,0x6a,0x00},
    {0xc8,0xe8,0xdc,0x68,0xc8,0x48,0x7e,0x00},
    {0x78,0x08,0x10,0x20,0x40,0x82,0x7e,0x00},
    {0x28,0x7e,0xd4,0x6a,0x5c,0x5c,0x46,0x00},
    {0x4e,0x7a,0xaa,0xfa,0x2a,0xb8,0xc8,0x00},
    {0x7c,0x54,0x6c,0x7c,0x54,0xca,0xba,0x00},
    {0xbc,0x24,0xbc,0x00,0xbc,0xac,0xfe,0x00},
    {0xc6,0x78,0xea,0x5c,0xdc,0xf2,0x6e,0x00},
    {0x10,0x7c,0x28,0xfe,0x7c,0x44,0x7c,0x00},
    {0xfe,0x10,0x18,0x14,0x10,0x10,0x10,0x00},
    {0x30,0x50,0xd2,0x5c,0x50,0x52,0x5e,0x00},
    {0x3e,0x50,0xde,0x5a,0x5a,0x54,0x6a,0x00},
    {0x3e,0x42,0xde,0x56,0x5e,0x42,0x46,0x00},
    {0x50,0x7e,0xda,0xda,0x5a,0x6a,0x6e,0x00},
    {0x3e,0x48,0xde,0x5a,0x5a,0x5a,0x5e,0x00},
    {0x28,0x5c,0xc8,0x7e,0x5c,0x48,0x7e,0x00},
    {0x40,0xfe,0x5a,0x5a,0x5a,0x5a,0xbe,0x00},
    {0xfe,0x04,0x74,0x54,0x74,0x04,0x0c,0x00},
    {0x10,0xfe,0x7c,0x28,0xfe,0x5a,0xbe,0x00},
    {0xfe,0x38,0x38,0x38,0x68,0x10,0xee,0x00},
    {0x88,0xbe,0xe2,0xdc,0xda,0x6c,0x9a,0x00},
    {0x10,0xfe,0xba,0x30,0xda,0x2c,0xda,0x00},
    {0x10,0xfe,0xaa,0x38,0xfe,0x5c,0xaa,0x00},
    {0xe4,0x54,0xe4,0x54,0xc6,0xfc,0x44,0x00},
    {0x36,0xf2,0xa6,0xfe,0xaa,0xf4,0x2a,0x00},
    {0x7c,0x54,0x7c,0x54,0xfe,0x38,0xd6,0x00},
    {0x40,0xfe,0x5a,0xbe,0xfe,0x38,0xd6,0x00},
    {0xe8,0x2e,0xb6,0xe4,0x24,0xa4,0x7a,0x00},
    {0xbe,0x02,0xba,0x2a,0xba,0x82,0x86,0x00},
    {0x10,0x10,0x54,0x58,0x10,0x28,0xc6,0x00},
    {0x1e,0xe2,0x5e,0xf6,0x5e,0xe2,0x06,0x00},
    {0x4e,0xea,0x2a,0x5e,0xf2,0x56,0x56,0x00},
    {0x0c,0x70,0xfe,0x10,0x38,0xd6,0x10,0x00},
    {0xc8,0x7e,0xe2,0x5c,0xda,0xec,0x5a,0x00},
    {0x48,0x6e,0xb4,0xfe,0x92,0xaa,0xfe,0x00},
    {0x28,0xfe,0x28,0x4a,0xcc,0x4a,0x4e,0x00},
    {0x28,0xfe,0x28,0xfe,0x74,0x54,0x74,0x00},
    {0x28,0xfe,0x28,0x40,0xfe,0x5a,0xbe,0x00},
    {0x28,0xfe,0x28,0x5e,0xc2,0x5a,0x5a,0x00},
    {0x28,0xfe,0x54,0xfe,0x54,0xfe,0x10,0x00},
    {0x28,0xfe,0x7c,0x54,0xfe,0x38,0xd6,0x00},
    {0x76,0xf2,0xa6,0xfe,0x6a,0x74,0xea,0x00},
    {0xbe,0xea,0x3e,0xc8,0x3e,0xdc,0xea,0x00},
    {0x14,0xfe,0xdc,0xfe,0xdc,0x3e,0x08,0x00},
    {0x28,0x4e,0xc8,0x4e,0x3c,0x3c,0xc6,0x00},
    {0x90,0x3e,0x1a,0xda,0x6e,0x40,0xbe,0x00},
    {0x8e,0x4a,0x0a,0xde,0x52,0x56,0xbe,0x00},
    {0x38,0xfe,0xb6,0xee,0x8a,0xe4,0x8a,0x00},
    {0x48,0xfe,0xb4,0xf4,0x48,0x54,0xe2,0x00},
    {0x4e,0x74,0xfe,0xd4,0x56,0x7c,0x52,0x00},
    {0x4e,0x74,0x7e,0xd4,0xd6,0xfc,0x12,0x00},
    {0x1a,0x68,0xfe,0x28,0xfa,0x24,0x6a,0x00},
    {0x7c,0x48,0x48,0xfe,0x28,0xc8,0x18,0x00},
    {0xfe,0x10,0xba,0xba,0xba,0x82,0xfe,0x00},
    {0xf4,0xa4,0xf4,0x94,0xf4,0xa4,0xfa,0x00},
    {0x28,0xfe,0x7c,0x48,0xfe,0x28,0xd8,0x00},
    {0x4e,0xf4,0xbe,0xd4,0x56,0x7c,0xd2,0x00},
    {0x40,0xfe,0x5a,0xbe,0x24,0x3c,0xc6,0x00},
    {0xea,0xae,0xbc,0xee,0x6c,0xac,0x6e,0x00},
    {0x4e,0xb4,0x3e,0xd4,0xd6,0xbc,0xd2,0x00},
    {0x40,0xfe,0x5a,0xae,0x3e,0x02,0xaa,0x00},
    {0x10,0x28,0xc6,0x28,0x28,0x28,0x48,0x00},
    {0x10,0x28,0xde,0x00,0xfe,0x24,0xfa,0x00},
    {0x6e,0xa6,0x7a,0x7e,0x74,0x5e,0xb4,0x00},
    {0xfe,0x82,0xba,0xaa,0xba,0x82,0xfe,0x00},
    {0x48,0x7e,0xea,0x7e,0x6a,0xdc,0x2e,0x00},
    {0x48,0x7e,0xda,0x5e,0x7e,0xf4,0x1a,0x00},
    {0xde,0x52,0x9e,0x5a,0xde,0x52,0xbe,0x00},
    {0x48,0xdc,0xcc,0x7e,0x48,0x48,0x76,0x00},
    {0x7c,0xd4,0xc8,0x76,0x5c,0x48,0x7e,0x00},
    {0x50,0xde,0xec,0x4c,0x76,0x5c,0x44,0x00},
    {0x5e,0xf4,0xde,0x5c,0x54,0x54,0x6a,0x00},
    {0x48,0xfe,0xda,0x5e,0x7e,0x74,0x5a,0x00},
    {0x04,0xfe,0x04,0x54,0xfe,0x54,0x9a,0x00},
    {0x5e,0xf2,0x5e,0x60,0xde,0x4a,0xd6,0x00},
    {0xe8,0x2e,0xfa,0x8a,0xaa,0xe4,0x1a,0x00},
    {0x54,0xe4,0xf4,0xe6,0x7c,0x64,0xbe,0x00},
    {0x10,0xfe,0xac,0xec,0xb6,0xfc,0x04,0x00},
    {0x44,0xfe,0x54,0xfc,0xd6,0x54,0x4a,0x00},
    {0x90,0x1e,0xac,0x0c,0xb6,0x9c,0x84,0x00},
    {0x7e,0x48,0x6a,0x6c,0x48,0x54,0xa2,0x00},
    {0x7c,0x54,0x7c,0x54,0x7c,0xaa,0x48,0x00},
    {0x48,0x6e,0x48,0xee,0x10,0x7c,0x7c,0x00},
    {0x48,0x94,0x6e,0x80,0x7e,0xd4,0x7a,0x00},
    {0x28,0xfe,0x10,0x28,0xee,0x28,0x48,0x00},
    {0x6e,0xa6,0x6a,0x7e,0xbc,0x14,0xfa,0x00},
    {0xee,0xee,0x82,0xfe,0xaa,0xfe,0xaa,0x00},
    {0xe4,0xb6,0xe4,0xb6,0xa8,0xdc,0x9c,0x00},
    {0x7c,0x44,0x7c,0x44,0x7c,0x00,0xc6,0x00},
    {0xae,0xfa,0x0a,0xfa,0x5a,0x2a,0xf2,0x00},
    {0x28,0xfe,0x4a,0xaa,0x5a,0x2a,0xd6,0x00},
    {0x48,0x78,0x58,0xbc,0x1a,0x28,0xc8,0x00},
    {0x04,0xfe,0xa8,0xb4,0xea,0x04,0x1a,0x00},
    {0x10,0xfe,0x92,0x7c,0x10,0xfe,0x38,0x00},
    {0x92,0xfe,0x5c,0x48,0x5c,0x48,0xbe,0x00},
    {0x4e,0xf6,0xf6,0x7e,0x64,0x74,0x4a,0x00},
    {0x4e,0xf6,0x76,0xfe,0xe4,0x74,0x4a,0x00},
    {0xbe,0x24,0xae,0x24,0xae,0xa4,0xde,0x00},
    {0xec,0x4c,0x5e,0x84,0x7e,0x74,0x0c,0x00},
    {0x28,0xfe,0x34,0xfa,0x7c,0x54,0xfe,0x00},
    {0x56,0xb8,0x56,0xfa,0x52,0x7a,0x46,0x00},
    {0x44,0xde,0x08,0xd4,0x0a,0xc4,0xda,0x00},
    {0x6a,0xbe,0xc0,0x7e,0xd4,0x48,0xfe,0x00},
    {0x74,0x5e,0xf8,0x94,0x7a,0x74,0x5a,0x00},
    {0xbe,0x2a,0xbe,0x2a,0xbe,0x88,0xbe,0x00},
    {0x2e,0xfa,0x64,0x9a,0x38,0xee,0x38,0x00},
    {0x48,0xfc,0xa8,0xfe,0x5c,0x48,0xfe,0x00},
    {0x7e,0x5c,0xd4,0x5c,0x54,0xdc,0x3e,0x00},
    {0x48,0xfe,0x48,0xfe,0xea,0x6a,0x48,0x00},
    {0x5e,0xf0,0xbe,0xf4,0x56,0x5a,0xea,0x00},
    {0x48,0xae,0xf2,0x4a,0xf2,0x7e,0xc2,0x00},
    {0x22,0xf2,0x3a,0xf2,0x72,0x7a,0xe6,0x00},
    {0x14,0xfe,0xd4,0xfe,0xf6,0x36,0x5a,0x00},
    {0x18,0x68,0x10,0x28,0xfe,0x44,0x7c,0x00},
    {0x08,0x7e,0x56,0x7c,0x6e,0x7e,0x94,0x00},
    {0x44,0xde,0x50,0x54,0xd4,0x5a,0xee,0x00},
    {0x6a,0xdc,0x62,0x5c,0xdc,0x5c,0xe6,0x00},
    {0x4c,0xd4,0x48,0xd4,0xe2,0x5c,0x5c,0x00},
    {0x48,0xfe,0x50,0xea,0xd4,0x4c,0x72,0x00},
    {0x4e,0xea,0x40,0xfe,0x9a,0x64,0xba,0x00},
    {0x94,0x7e,0xdc,0x5e,0xd4,0x48,0xb6,0x00},
    {0xe4,0x5e,0x56,0x8c,0x7e,0x6c,0x0e,0x00},
    {0xd4,0x7e,0xdc,0x5e,0xd4,0xc8,0x76,0x00},
    {0x54,0xfe,0xaa,0x38,0x28,0x3a,0xce,0x00},
    {0x38,0xc8,0x7e,0x52,0x7e,0x42,0x86,0x00},
    {0x24,0x7e,0x24,0xfe,0xec,0x6e,0xb4,0x00},
    {0xc8,0x7e,0xd4,0xe2,0x54,0xc8,0x76,0x00},
    {0x2e,0xfa,0x5c,0x7a,0x3a,0xec,0x28,0x00},
    {0xee,0xee,0x9a,0xaa,0x92,0xee,0xba,0x00},
    {0xfe,0xac,0xcc,0xbe,0xb2,0xde,0x96,0x00},
    {0x28,0xfe,0x28,0x7c,0x54,0xfe,0x10,0x00},
    {0x54,0xfe,0xba,0x08,0xfe,0x10,0x30,0x00},
    {0x0c,0x70,0x7c,0x48,0xfe,0x54,0x7c,0x00},
    {0x92,0x6c,0xba,0x10,0xfe,0x38,0xd6,0x00},
    {0x2e,0xf4,0xbe,0x5a,0x2e,0xd0,0x7a,0x00},
    {0xde,0xd4,0x6e,0xfa,0x4e,0x60,0x2a,0x00},
    {0x54,0xfc,0x54,0x7e,0xd4,0x7c,0xc4,0x00},
    {0x48,0x6e,0xb4,0x10,0x7c,0x28,0xfe,0x00},
    {0x7e,0xfa,0x74,0xca,0xdc,0x48,0x7e,0x00},
    {0x5e,0xec,0x4c,0xde,0xcc,0x4c,0x5e,0x00},
    {0x5e,0xfe,0x56,0xfc,0xd6,0x5c,0x66,0x00},
    {0xf4,0x54,0xfe,0xdc,0xf4,0x34,0x9a,0x00},
    {0x94,0x24,0xbc,0x10,0xbe,0xc2,0xaa,0x00},
    {0x22,0xfa,0xaa,0x7a,0x22,0xfa,0x76,0x00},
    {0x1c,0xd4,0xdc,0xde,0xf2,0x1a,0x06,0x00},
    {0x48,0xd4,0xee,0x40,0x5c,0x54,0x5c,0x00},
    {0x44,0xd8,0x7e,0x48,0xdc,0x54,0xdc,0x00},
    {0x84,0x18,0xbe,0x08,0x5c,0x94,0x9c,0x00},
    {0x9c,0x14,0x9c,0x1e,0xb2,0x9a,0x86,0x00},
    {0x9c,0x14,0xbe,0x22,0x9c,0x9c,0x94,0x00},
    {0x28,0xfe,0x44,0x7c,0x7e,0xa2,0x36,0x00},
    {0x5c,0xf4,0x3c,0x5e,0xf2,0x7a,0x46,0x00},
    {0xc8,0x7e,0xea,0xdc,0x48,0xfe,0x5c,0x00},
    {0x7c,0x44,0x7c,0x44,0x7c,0x44,0xfe,0x00},
    {0xfe,0x7a,0xf4,0xca,0xdc,0x08,0xbe,0x00},
    {0x08,0xe8,0xbe,0xa8,0xe8,0x08,0x08,0x00},
    {0x54,0xfe,0x44,0xd4,0xf6,0x54,0x56,0x00},
    {0x54,0xfe,0x5c,0xfe,0xdc,0x7e,0x48,0x00},
    {0xa8,0xee,0xf6,0x42,0xee,0xe8,0x4e,0x00},
    {0x58,0xdc,0x68,0xfe,0xc8,0x5c,0x6a,0x00},
    {0x56,0xaa,0xba,0xaa,0xfe,0x28,0xce,0x00},
    {0x10,0xfe,0xaa,0x5c,0x7c,0x7c,0x0e,0x00},
    {0x28,0xfe,0x88,0x3e,0xaa,0x3e,0xaa,0x00},
    {0x28,0xc6,0x38,0xd6,0x38,0x54,0xfe,0x00},
    {0x54,0xbe,0xcc,0x7e,0xce,0x5c,0xea,0x00},
    {0x14,0xf6,0xbc,0xb6,0xea,0x36,0x3e,0x00},
    {0xe8,0xfc,0xfc,0xf0,0x5e,0x42,0x2a,0x00},
    {0x5e,0xe8,0x5e,0xf2,0xde,0x52,0x5e,0x00},
    {0x28,0xfe,0x7c,0x08,0xfe,0x2a,0xd8,0x00},
    {0x28,0xfe,0x28,0xfe,0xba,0x38,0xfe,0x00},
    {0xd6,0x7a,0xd6,0xbc,0xd6,0x7a,0xd6,0x00},
    {0x12,0x1a,0x5a,0x2a,0x22,0x52,0x86,0x00},
    {0x28,0xfe,0x12,0x5a,0x2a,0x52,0x86,0x00},
    {0xfe,0x20,0x3c,0x24,0x34,0x24,0xf6,0x00},
    {0xf0,0x5e,0xec,0xa4,0x48,0xf2,0x4e,0x00},
    {0x3e,0x52,0xde,0x40,0x5a,0x5a,0x6a,0x00},
    {0xfe,0x82,0x64,0x0e,0xf4,0x6c,0xbe,0x00},
    {0x10,0xfe,0xaa,0x7c,0x7c,0xb2,0x08,0x00},
    {0x72,0x2a,0x2a,0xfa,0x22,0x22,0x26,0x00},
    {0x54,0xfe,0x56,0x56,0xf6,0xaa,0xfa,0x00},
    {0x44,0x7e,0xa6,0x76,0xe6,0x6a,0x7a,0x00},
    {0x54,0x38,0xfe,0x4c,0xba,0x20,0x3c,0x00},
    {0x1c,0xe4,0xdc,0xdc,0xfe,0x08,0x36,0x00},
    {0x54,0x7e,0xd4,0x54,0x7e,0xe8,0x3e,0x00},
    {0x10,0xfe,0x28,0x74,0xfe,0x54,0xaa,0x00},
    {0x10,0xfe,0xba,0x00,0xfe,0x28,0xce,0x00},
    {0x10,0xfe,0xba,0x28,0x3c,0x24,0x3c,0x00},
    {0x10,0xfe,0xaa,0x7c,0x38,0x3a,0xce,0x00},
    {0x7c,0x10,0x10,0xfe,0x10,0x10,0x10,0x00},
    {0xe4,0x4a,0xe0,0xae,0x44,0xee,0x44,0x00},
    {0x10,0x38,0x38,0x7c,0x7c,0xca,0xba,0x00},
    {0x04,0x7e,0x74,0xb2,0x00,0xca,0xba,0x00},
    {0x5c,0xf6,0xdc,0x5c,0x5c,0x5c,0x62,0x00},
    {0x44,0xfe,0xf4,0x72,0x40,0x72,0x6e,0x00},
    {0x5c,0xe4,0x5c,0x5c,0xfe,0x48,0xf6,0x00},
    {0x74,0x26,0xfa,0x5a,0x5a,0xf4,0x1a,0x00},
    {0x54,0xfe,0x54,0xdc,0xd4,0x54,0x5c,0x00},
    {0x7e,0xdc,0x54,0xdc,0xd4,0x5c,0x7e,0x00},
    {0x48,0xfe,0x62,0xdc,0xde,0x52,0x5e,0x00},
    {0x48,0xee,0x56,0xe4,0x04,0xe4,0x5a,0x00},
    {0x44,0x76,0xaa,0x74,0xe4,0x64,0x7a,0x00},
    {0x9c,0x08,0x88,0x3e,0x88,0x88,0x88,0x00},
    {0x94,0x7e,0xaa,0x3e,0xfe,0x88,0xb6,0x00},
    {0xb6,0x36,0xa2,0x2e,0xae,0xae,0xa2,0x00},
    {0x90,0x1e,0xa8,0x1e,0xb4,0x94,0x9e,0x00},
    {0x3e,0xea,0x7e,0xdc,0x54,0xdc,0x2a,0x00},
    {0x24,0xfe,0x24,0x3c,0x24,0x24,0x3c,0x00},
    {0xe8,0xce,0xd0,0xe6,0x7c,0x54,0xfe,0x00},
    {0x0c,0x70,0x3c,0xfe,0x7c,0xa4,0x3c,0x00},
    {0x48,0x6e,0xb4,0x7c,0x10,0xfe,0x10,0x00},
    {0x48,0x6e,0xb4,0xfe,0xb2,0x3c,0x3c,0x00},
    {0x48,0x6e,0xb4,0xee,0xee,0xba,0xba,0x00},
    {0x46,0xb8,0x6a,0x9e,0x4a,0xd4,0x6a,0x00},
    {0x40,0x7c,0x90,0xfe,0x10,0x54,0x7c,0x00},
    {0xe8,0x54,0xe2,0xbe,0x4a,0xde,0x6a,0x00},
    {0xee,0xa4,0xe4,0xbe,0xe4,0xa4,0xa4,0x00},
    {0x54,0xf6,0xb0,0xb6,0xe0,0xac,0xbe,0x00},
    {0x28,0xfe,0xba,0x00,0xfe,0x28,0xce,0x00},
    {0x4e,0x7a,0xae,0x7a,0xee,0x6c,0x76,0x00},
    {0x88,0xfe,0x1c,0xdc,0x08,0xdc,0xea,0x00},
    {0x7c,0xd6,0x7c,0x7c,0x44,0x7c,0xc6,0x00},
    {0xbe,0x3e,0x1c,0xd4,0x5c,0x6a,0xbe,0x00},
    {0x54,0xb6,0xf0,0x56,0xe0,0x6c,0xde,0x00},
    {0xee,0xaa,0xfe,0xaa,0xba,0xaa,0xba,0x00},
    {0xee,0xee,0x92,0xfe,0xba,0xd6,0x92,0x00},
    {0xee,0xee,0xaa,0x92,0xfe,0x92,0xaa,0x00},
    {0xee,0xb2,0xc4,0xb6,0xb6,0xd6,0x96,0x00},
    {0xe8,0x5e,0xea,0xbe,0x54,0xfe,0x44,0x00},
    {0x44,0xbe,0x52,0xec,0xee,0x8a,0xee,0x00},
    {0x44,0xbe,0x52,0xec,0x4e,0xaa,0xee,0x00},
    {0x20,0xf8,0x28,0x68,0x38,0x4a,0x8e,0x00},
    {0x10,0x28,0xfe,0x08,0x7c,0x44,0x7c,0x00},
    {0x92,0xfe,0x40,0x5c,0x48,0x7e,0x88,0x00},
    {0x92,0xfe,0x54,0x7e,0x5a,0x74,0x9a,0x00},
    {0x1c,0xc0,0x7e,0xd4,0x54,0xd4,0x26,0x00},
    {0x08,0x7e,0xdc,0x76,0xf6,0x6a,0xbe,0x00},
    {0xfe,0xb2,0xfe,0xb2,0xfe,0xb4,0xfa,0x00},
    {0x54,0x7c,0x00,0xfe,0x40,0xbc,0x3c,0x00},
    {0xf6,0x50,0xfe,0x54,0x24,0x74,0x7a,0x00},
    {0x7e,0x56,0x6c,0x6e,0x5c,0x5c,0xa2,0x00},
    {0x7e,0x54,0x6e,0x7c,0x6e,0x6c,0xae,0x00},
    {0x6e,0x04,0xfe,0x6a,0x6e,0xb0,0x0a,0x00},
    {0x2e,0xf4,0x5e,0xfa,0xae,0x90,0xaa,0x00},
    {0xfe,0xa4,0xfe,0xfa,0xae,0xf0,0xaa,0x00},
    {0x10,0x28,0xd6,0x10,0x5c,0x50,0xfe,0x00},
    {0x28,0x7e,0xc8,0x7c,0x54,0x48,0x76,0x00},
    {0x38,0xc8,0x7e,0x5c,0x54,0x52,0x9e,0x00},
    {0x10,0xfe,0x7c,0x28,0xfe,0x44,0x7c,0x00},
    {0x6c,0x6c,0x10,0xfe,0x10,0xee,0x6c,0x00},
    {0x28,0x7c,0x28,0xfe,0x44,0x92,0x38,0x00},
    {0x10,0x7c,0x10,0x28,0xfe,0x54,0x74,0x00},
    {0x88,0xbe,0xdc,0xd4,0xfe,0x54,0x9c,0x00},
    {0x10,0xfe,0x92,0x28,0xfe,0x54,0x74,0x00},
    {0x48,0x7e,0x48,0xfc,0xd4,0xc8,0x36,0x00},
    {0x24,0x18,0x24,0xfe,0x48,0xbe,0x2a,0x00},
    {0x54,0x98,0x54,0xfc,0x4a,0x64,0x9a,0x00},
    {0x7c,0x04,0x7c,0x40,0x7c,0xca,0xba,0x00},
    {0x7e,0xea,0x7e,0x5c,0xdc,0x7e,0xc8,0x00},
    {0x5c,0xf4,0x54,0xf4,0xd4,0x54,0x66,0x00},
    {0x48,0xee,0x5c,0x6c,0x7e,0xa0,0xb2,0x00},
    {0xfe,0xaa,0xea,0xbe,0xe4,0x8c,0xf6,0x00},
    {0x5e,0xfa,0x5e,0x7a,0xfe,0x0a,0x96,0x00},
    {0x54,0xfe,0x54,0xdc,0xfe,0x40,0x62,0x00},
    {0x10,0xfe,0x28,0x74,0xfe,0x38,0xd6,0x00},
    {0x52,0xe4,0x52,0xfc,0xd6,0x54,0x6a,0x00},
    {0x5c,0xc4,0xfe,0xea,0x5c,0x5c,0x88,0x00},
    {0x2e,0xfa,0x50,0xfe,0x6a,0xb4,0x6a,0x00},
    {0x40,0x7e,0xb8,0x7c,0x54,0x24,0xd2,0x00},
    {0xa0,0x3e,0xd8,0x3c,0x84,0x84,0x82,0x00},
    {0x54,0x98,0x54,0xfc,0x0a,0xe4,0xea,0x00},
    {0x42,0xec,0x28,0x4e,0xea,0x4a,0x52,0x00},
    {0x38,0xfe,0x3c,0xda,0x08,0xfe,0x10,0x00},
    {0xd4,0x48,0xd4,0x7e,0xc8,0xde,0x6a,0x00},
    {0x5e,0x82,0x42,0xbe,0x50,0xf2,0x5e,0x00},
    {0x54,0xbe,0x56,0xee,0x56,0x7c,0x52,0x00},
    {0x5e,0xf2,0x5e,0xf2,0x5e,0x6c,0x96,0x00},
    {0x5e,0xe2,0x02,0xde,0x10,0xd2,0xde,0x00},
    {0x10,0x7c,0x54,0xfe,0x44,0x7c,0xc6,0x00},
    {0x2e,0xf2,0x2e,0xf8,0x6e,0x60,0x9e,0x00},
    {0xd0,0x7c,0xd4,0xd4,0x54,0xd4,0x66,0x00},
    {0x3e,0xb6,0x7e,0xec,0x6c,0x7e,0x84,0x00},
    {0x5c,0xb4,0x54,0xf4,0xf4,0x94,0xe6,0x00},
    {0xe4,0xde,0xe4,0xca,0xfe,0x22,0xaa,0x00},
    {0x10,0x7c,0x54,0x7c,0x7a,0x2c,0xce,0x00},
    {0x38,0xc8,0x78,0xfc,0x94,0xfc,0x0e,0x00},
    {0x54,0x7c,0xcc,0xd4,0x7e,0x42,0x6a,0x00},
    {0x54,0x7e,0xc8,0xfe,0x56,0x7c,0x52,0x00},
    {0x24,0x2e,0xf4,0x5e,0x6a,0x24,0xda,0x00},
    {0x10,0xfe,0xba,0x28,0x38,0x28,0xfe,0x00},
    {0x26,0x34,0xee,0xb4,0xa6,0xb4,0xea,0x00},
    {0x48,0xfe,0x48,0x7c,0xd4,0x48,0xf6,0x00},
    {0x66,0xfa,0x66,0x5c,0xfe,0x54,0xea,0x00},
    {0x54,0xfe,0x52,0x74,0xfc,0x04,0x9a,0x00},
    {0xd4,0xfe,0xc8,0x7e,0xd6,0x7c,0x52,0x00},
    {0x9e,0xe4,0x9e,0x6a,0xec,0x58,0xb6,0x00},
    {0x42,0xfc,0x34,0x5e,0xf4,0x54,0x5a,0x00},
    {0x24,0xfe,0x10,0xfe,0x2a,0xfc,0x2a,0x00},
    {0x54,0xfe,0xc8,0xfe,0x56,0x7c,0xd2,0x00},
    {0x88,0xfe,0x22,0xdc,0x1c,0xd4,0xfe,0x00},
    {0x94,0xfe,0x08,0xbe,0x16,0xfc,0xd2,0x00},
    {0x50,0xde,0x76,0x4a,0xde,0x4a,0xd6,0x00},
    {0x28,0xfe,0x40,0x7e,0xd6,0x3a,0x56,0x00},
    {0xb0,0xfe,0xf6,0x4a,0xfe,0xea,0x56,0x00},
    {0x10,0xfe,0x10,0x7c,0x00,0x7c,0x7c,0x00},
    {0x10,0xde,0xec,0xc4,0xc8,0x12,0x0e,0x00},
    {0x16,0xfe,0xd6,0xfa,0xdc,0x08,0x36,0x00},
    {0x48,0xfe,0x48,0xdc,0xc0,0x5c,0x5c,0x00},
    {0x5c,0xfe,0x5a,0xe8,0xfe,0x76,0x6a,0x00},
    {0x88,0xfe,0x08,0xdc,0x00,0xdc,0xdc,0x00},
    {0xe8,0x48,0x4e,0x88,0x7e,0x72,0x1e,0x00},
    {0x50,0xdc,0x68,0xc8,0xfe,0x48,0x48,0x00},
    {0x38,0xfe,0x38,0xd6,0x28,0xfe,0x54,0x00},
    {0x2e,0x7a,0x2a,0xfa,0x2a,0x58,0xe8,0x00},
    {0x10,0xfe,0x9a,0x68,0x10,0xee,0x38,0x00},
    {0xee,0xbe,0xee,0xbe,0xee,0xb4,0xbc,0x00},
    {0x08,0x0e,0x78,0x4e,0x5e,0x50,0x9e,0x00},
    {0x94,0x3e,0x08,0xea,0x7e,0x50,0xbe,0x00},
    {0x0c,0x70,0x40,0x7c,0x48,0x48,0xfe,0x00},
    {0x20,0x3c,0x24,0x48,0x08,0x14,0xe2,0x00},
    {0x28,0x7c,0xd4,0x54,0x54,0x54,0x66,0x00},
    {0x28,0x7e,0xc8,0x5c,0x5c,0x6a,0x48,0x00},
    {0xf8,0x28,0x2c,0x24,0x54,0x48,0xb6,0x00},
    {0x3c,0xd4,0xd6,0xd2,0xda,0x24,0x5a,0x00},
    {0x10,0xfe,0xaa,0x38,0x10,0x7c,0x7c,0x00},
    {0x7c,0x04,0x7c,0x40,0xfe,0x02,0x0e,0x00},
    {0x38,0xc8,0x7c,0x04,0x7c,0xca,0xba,0x00},
    {0x24,0xf6,0x2a,0xba,0x6a,0xb4,0x6a,0x00},
    {0x5e,0xe8,0x48,0xee,0xc2,0x42,0x46,0x00},
    {0x14,0xfe,0x10,0x54,0x38,0xd4,0x32,0x00},
    {0xbc,0x14,0x96,0x12,0x9a,0xa4,0xda,0x00},
    {0x88,0x3e,0x94,0x14,0x54,0x98,0xbe,0x00},
    {0x3c,0x44,0x18,0xe6,0x54,0x28,0xc6,0x00},
    {0x0a,0xfe,0x48,0xea,0x5c,0xea,0x18,0x00},
    {0x10,0xfe,0xaa,0x4c,0xf8,0x2a,0xce,0x00},
    {0x10,0xfe,0xb6,0x74,0xd6,0x32,0xd6,0x00},
    {0x48,0x6e,0xb4,0x7c,0x14,0x28,0xd6,0x00},
    {0x5c,0x94,0x56,0xb2,0x5a,0xe4,0x5a,0x00},
    {0x44,0x94,0x54,0xb4,0x56,0xfc,0x44,0x00},
    {0x48,0x94,0x6e,0x80,0x5c,0xd4,0x5c,0x00},
    {0xbe,0xa2,0xa2,0xbe,0xa2,0xa2,0xbe,0x00},
    {0x50,0x7c,0x90,0x10,0xfe,0x10,0x10,0x00},
    {0x10,0x7c,0x10,0xfe,0x10,0x24,0xfa,0x00},
    {0x7e,0x7e,0x48,0x7e,0x48,0x5c,0x9c,0x00},
    {0x7e,0x40,0x7c,0x44,0x7c,0x40,0x7e,0x00},
    {0x5e,0xf0,0x5e,0x72,0xde,0x50,0xde,0x00},
    {0x50,0xde,0x6a,0x6a,0xd2,0x58,0xe6,0x00},
    {0x54,0xfe,0x44,0xba,0x7c,0xfe,0x30,0x00},
    {0xbe,0x3c,0xa4,0x3e,0xfe,0x38,0xd6,0x00},
    {0x08,0x0e,0x78,0x4e,0x40,0x54,0xbe,0x00},
    {0x50,0xdc,0x28,0xc8,0x3e,0xc8,0xc8,0x00},
    {0xfe,0xb0,0xde,0x72,0xde,0xf0,0xde,0x00},
    {0x5e,0xbe,0xf4,0x5e,0xf4,0x7a,0xce,0x00},
    {0x8c,0x34,0x9e,0x1a,0x5e,0x80,0xaa,0x00},
    {0x66,0xbe,0x56,0xdc,0x7c,0x54,0xb2,0x00},
    {0x38,0xc8,0x7c,0x54,0x7c,0x00,0xaa,0x00},
    {0x10,0xfe,0x44,0x7c,0x08,0x10,0x30,0x00},
    {0x10,0xfe,0x44,0x7c,0x08,0xfe,0x10,0x00},
    {0x10,0xfe,0x44,0x7c,0x10,0x54,0xb2,0x00},
    {0x54,0x7e,0xd4,0xd4,0x7e,0x40,0x62,0x00},
    {0x28,0x7e,0xc8,0x6a,0x7e,0x48,0x76,0x00},
    {0x5c,0x7e,0xd4,0xea,0x7e,0x62,0x6a,0x00},
    {0x6c,0x54,0x6c,0x44,0x7c,0x2a,0xce,0x00},
    {0x24,0xfe,0x5a,0xfe,0x5a,0x6c,0xb6,0x00},
    {0x28,0x7c,0x28,0x28,0xfe,0x00,0xc6,0x00},
    {0x82,0x8a,0xaa,0x92,0xaa,0xc2,0xfe,0x00},
    {0x48,0x5e,0xea,0x40,0x4a,0x7e,0x56,0x00},
    {0xfe,0xbc,0x88,0x9c,0x88,0xbc,0xfe,0x00},
    {0x46,0xbe,0xae,0xbe,0xe6,0x6c,0xb4,0x00},
    {0x04,0xd4,0xd4,0xd4,0xd6,0x3c,0x04,0x00},
    {0x38,0xfe,0x28,0xd6,0xfe,0xaa,0xba,0x00},
    {0x48,0x7e,0xd4,0x7e,0x5c,0xdc,0x26,0x00},
    {0x48,0x7e,0x48,0xea,0xfe,0xc8,0x36,0x00},
    {0xc8,0x52,0xfe,0x9c,0xdc,0x4a,0xfe,0x00},
    {0xde,0x4c,0xcc,0x9e,0xcc,0x4c,0xde,0x00},
    {0x48,0xdc,0xc8,0x7e,0x48,0x54,0x7a,0x00},
    {0xec,0x4c,0x6c,0xd6,0x00,0xca,0xba,0x00},
    {0x28,0x7c,0x28,0xfe,0x44,0x20,0xaa,0x00},
    {0x48,0xfe,0x48,0x6a,0xfe,0x48,0xf6,0x00},
    {0x24,0x76,0x2a,0xfa,0x5a,0xb4,0x2a,0x00},
    {0x5c,0xfe,0x54,0xea,0xfe,0x62,0x6a,0x00},
    {0xbe,0x22,0xa2,0x3e,0x94,0x94,0xa6,0x00},
    {0xbe,0x48,0xc8,0x5c,0xc8,0x48,0xbe,0x00},
    {0xa8,0x7e,0xc8,0x6a,0xfe,0x48,0xb6,0x00},
    {0x9c,0xfe,0x54,0xea,0x7e,0x62,0xaa,0x00},
    {0xe8,0xae,0xf6,0xaa,0xf6,0xbe,0xa2,0x00},
    {0x10,0x7c,0x24,0xfe,0x56,0xbc,0x24,0x00},
    {0x46,0xba,0xee,0xba,0xfe,0x00,0xc6,0x00},
    {0x28,0xfe,0x38,0xee,0xfe,0xaa,0xba,0x00},
    {0x46,0xbe,0x6c,0xbe,0xe6,0x6c,0xb4,0x00},
    {0x48,0xbe,0xd4,0x7e,0xdc,0x5c,0xe6,0x00},
    {0x76,0xb6,0x66,0xbc,0x28,0xfe,0x38,0x00},
    {0x76,0xb6,0x66,0xb4,0x38,0xf6,0x28,0x00},
    {0x56,0xfa,0x74,0xba,0x3e,0x02,0xaa,0x00},
    {0x50,0x6e,0xea,0xea,0x7a,0x68,0x48,0x00},
    {0xa6,0x3a,0x26,0x1c,0xbe,0x94,0xaa,0x00},
    {0x10,0x7c,0xfe,0x28,0xfe,0x28,0xce,0x00},
    {0x08,0xfc,0xbe,0xf4,0xbe,0xd4,0x26,0x00},
    {0xaa,0xfe,0x28,0x7c,0xfe,0x38,0xd6,0x00},
    {0x7c,0x44,0x7e,0x42,0x7a,0x6a,0xba,0x00},
    {0x28,0xfe,0xaa,0xfe,0xaa,0xaa,0xfe,0x00},
    {0x5e,0xe8,0x4c,0xf6,0xd6,0x44,0x5e,0x00},
    {0xfe,0x10,0x10,0x7c,0x10,0x14,0xfe,0x00},
    {0x5e,0xf2,0x5e,0xf2,0xde,0x5e,0x52,0x00},
    {0xa4,0x58,0xc8,0x7e,0xc8,0xc8,0x48,0x00},
    {0x54,0x7e,0xd4,0xfe,0x7e,0x48,0x7e,0x00},
    {0x54,0xfe,0x56,0xf6,0xf6,0x2a,0xfa,0x00},
    {0x50,0x5e,0xe2,0x4a,0x66,0xda,0x06,0x00},
    {0x10,0xfe,0x92,0x92,0x92,0x96,0x10,0x00},
    {0x48,0xbc,0xf4,0x5c,0xfe,0x6a,0xc8,0x00},
    {0x0c,0x70,0x40,0x7e,0x48,0x48,0x88,0x00},
    {0x28,0xce,0x96,0xe4,0xa4,0xa4,0x3a,0x00},
    {0x48,0xae,0xf6,0x44,0xe4,0x64,0xda,0x00},
    {0xee,0x44,0xee,0x38,0xc6,0x38,0x08,0x00},
    {0x24,0xfe,0x6c,0xb6,0xfe,0x54,0xb2,0x00},
    {0x10,0xee,0x54,0x6c,0xfe,0xaa,0xb6,0x00},
    {0x48,0x6e,0xb4,0x68,0x7e,0x6a,0xb6,0x00},
    {0xee,0xca,0xe4,0x2a,0xfe,0x10,0x92,0x00},
    {0x28,0xfe,0x2c,0x70,0x7e,0x48,0x88,0x00},
    {0x28,0xfe,0x9a,0xfe,0xba,0xd6,0xfe,0x00},
    {0x48,0xf4,0x2e,0x40,0xfe,0x64,0x48,0x00},
    {0x52,0xf6,0x32,0x5c,0xfe,0x48,0x6a,0x00},
    {0x94,0xfe,0x14,0xbe,0x3e,0xc8,0xfe,0x00},
    {0x84,0x58,0x10,0xde,0x54,0x64,0xbe,0x00},
    {0x10,0x28,0xfe,0x10,0xfe,0x54,0xfe,0x00},
    {0x08,0xf4,0xae,0xa0,0xfe,0x04,0x18,0x00},
    {0x5e,0xb2,0xfe,0x52,0xfe,0x74,0xda,0x00},
    {0x20,0xf8,0x28,0x28,0x48,0x4a,0x8e,0x00},
    {0x3c,0x54,0xdc,0x54,0x7e,0x40,0x62,0x00},
    {0x40,0x7e,0x42,0xba,0x2a,0x3a,0x06,0x00},
    {0xfe,0x84,0xb4,0x88,0x94,0xa0,0xfe,0x00},
    {0xa8,0x4e,0xb2,0x6e,0xae,0x22,0xc6,0x00},
    {0x10,0xdc,0x54,0xe4,0x48,0xd4,0x22,0x00},
    {0x4e,0x78,0xae,0x7a,0x2e,0x58,0x8e,0x00},
    {0x28,0xfe,0x28,0xfe,0x10,0x7c,0x7c,0x00},
    {0x2e,0x78,0x5a,0x7c,0xda,0x38,0xde,0x00},
    {0xee,0xc8,0xea,0xcc,0xea,0x28,0xae,0x00},
    {0xe4,0xd8,0xf0,0xde,0xf4,0x34,0xbe,0x00},
    {0xe8,0xce,0xf2,0xce,0xee,0x22,0xa6,0x00},
    {0x7c,0x44,0x7c,0x44,0xfe,0x00,0xc6,0x00},
    {0x38,0x38,0x7c,0x5c,0x74,0xca,0xba,0x00},
    {0x08,0x0e,0x78,0x4e,0x6c,0x7e,0x94,0x00},
    {0x08,0xd4,0xea,0xd8,0xda,0x14,0x1a,0x00},
    {0x10,0xfe,0xaa,0x4c,0x38,0x10,0xfe,0x00},
    {0x3c,0x5c,0xc8,0x7e,0x6a,0x6e,0x7a,0x00},
    {0x10,0xfe,0xba,0x38,0xfe,0x9a,0xb6,0x00},
    {0x9c,0x5c,0x08,0xfe,0x6e,0x7a,0xbe,0x00},
    {0xdc,0xdc,0x88,0xfe,0xea,0xae,0xba,0x00},
    {0x10,0x7c,0x7c,0x10,0xfe,0xfe,0x10,0x00},
    {0x64,0xf6,0x52,0xf6,0xf6,0x64,0x74,0x00},
    {0x52,0xba,0xfa,0x5a,0xfa,0x52,0xe2,0x00},
    {0x7e,0x7e,0x6a,0x5e,0x52,0x5e,0x92,0x00},
    {0x7e,0x42,0x7e,0x5c,0x48,0x6a,0xbe,0x00},
    {0x7e,0xe2,0x7e,0x6e,0xe4,0x76,0xde,0x00},
    {0x10,0xfe,0xb6,0x7c,0x7c,0x6a,0xbe,0x00},
    {0x10,0xf4,0x38,0xd6,0x7c,0x44,0x7c,0x00},
    {0xac,0xf4,0xf6,0x54,0xf4,0xf4,0x56,0x00},
    {0x52,0xbc,0x5a,0xfe,0x52,0x7c,0x7c,0x00},
    {0x10,0xfe,0xaa,0x4c,0xbe,0x08,0xbe,0x00},
    {0x54,0xf6,0x50,0x74,0x56,0x00,0xaa,0x00},
    {0xfe,0xb6,0xde,0xa0,0xbe,0xd4,0x9a,0x00},
    {0x3c,0x44,0x38,0xd6,0x7c,0x38,0xd6,0x00},
    {0xfe,0x54,0x7c,0x10,0xfe,0x38,0xd6,0x00},
    {0x5c,0x94,0x7e,0xaa,0x7e,0xdc,0x6a,0x00},
    {0x7c,0x08,0xf6,0x24,0xda,0x38,0xd6,0x00},
    {0x54,0xb4,0xfe,0x5c,0xf4,0x74,0xda,0x00},
    {0x64,0xfe,0x66,0x6a,0xfa,0x00,0xaa,0x00},
    {0x7c,0x14,0xfe,0x14,0x7e,0x32,0xde,0x00},
    {0x28,0xfe,0x38,0xfe,0x54,0xfe,0xaa,0x00},
    {0x52,0xda,0x1a,0xda,0x1a,0xd2,0xe2,0x00},
    {0xfa,0x5e,0xf4,0x5e,0xe4,0x7e,0xb4,0x00},
    {0xfe,0x92,0xfe,0x7c,0x54,0xfe,0x10,0x00},
    {0xf6,0x56,0xfc,0x56,0xe6,0x74,0xb4,0x00},
    {0x28,0x78,0x28,0xfc,0x6a,0x38,0xc8,0x00},
    {0x40,0xfe,0x5a,0xbe,0xfe,0x68,0xb6,0x00},
    {0x4e,0xea,0x2c,0x4a,0xea,0x4c,0x48,0x00},
    {0x3e,0x48,0xd0,0x4a,0x7e,0x48,0x6a,0x00},
    {0x2e,0x64,0xfe,0x6a,0x6e,0x70,0x4a,0x00},
    {0xfa,0x56,0x56,0xfe,0x52,0x52,0x96,0x00},
    {0x7c,0x44,0x44,0x7c,0x28,0x2a,0xce,0x00},
    {0xf6,0x5a,0x74,0x8a,0x7c,0x44,0x7c,0x00},
    {0x10,0x7c,0x10,0xfe,0x7c,0x10,0xfe,0x00},
    {0x08,0xdc,0x48,0xfe,0x5c,0xc8,0x3e,0x00},
    {0xfa,0x56,0xfe,0x52,0xba,0x10,0xfe,0x00},
    {0x5e,0xea,0x4a,0xf6,0x7c,0x10,0xee,0x00},
    {0xfa,0x54,0x52,0xfc,0x50,0x52,0x94,0x00},
    {0x7c,0x94,0x48,0xf6,0x5c,0x48,0x7e,0x00},
    {0x10,0xfe,0x7c,0x54,0x7c,0xca,0xba,0x00},
    {0x08,0x7e,0x54,0x7e,0x76,0x58,0xb6,0x00},
    {0x44,0xee,0x44,0xfe,0x3c,0xca,0xba,0x00},
    {0x14,0x6e,0xfa,0x6e,0x00,0xca,0xba,0x00},
    {0x5c,0xd4,0x5c,0x5e,0xf2,0x5a,0xc6,0x00},
    {0x54,0xde,0x74,0x5e,0xfc,0x56,0xe2,0x00},
    {0x54,0xf6,0x5a,0x7a,0x9a,0x54,0x3a,0x00},
    {0x7c,0x44,0xfe,0x44,0x7c,0x54,0xb2,0x00},
    {0x48,0xdc,0x48,0xfe,0xdc,0x48,0x7e,0x00},
    {0x86,0x38,0xaa,0x1c,0xbe,0x88,0xb6,0x00},
    {0x04,0xee,0xe4,0xfe,0xee,0xe4,0x1e,0x00},
    {0xca,0x7e,0xd8,0x6e,0xd0,0xdc,0x5c,0x00},
    {0x7c,0x10,0x60,0x14,0xfa,0x10,0x92,0x00},
    {0x7c,0x94,0x48,0xb6,0x5c,0xc8,0x7e,0x00},
    {0x5a,0x94,0x5e,0xb4,0x5a,0xf0,0x5e,0x00},
    {0xfe,0x6a,0xf4,0x2a,0x7c,0x10,0x92,0x00},
    {0xfe,0xaa,0xfe,0x48,0xec,0x4a,0xe8,0x00},
    {0x28,0xfe,0x28,0x10,0xee,0x10,0x7c,0x00},
    {0x28,0xfe,0xf8,0x52,0xfa,0x52,0x96,0x00},
    {0x54,0xfe,0x92,0x7c,0x7c,0x14,0xfa,0x00},
    {0x48,0xc8,0x3e,0xc8,0x08,0xc8,0xc8,0x00},
    {0x52,0xdc,0x12,0xde,0x00,0xde,0xde,0x00},
    {0x56,0xfa,0x74,0x9a,0x30,0xfe,0x38,0x00},
    {0xfc,0x54,0xc8,0xf6,0x5c,0xc8,0x7e,0x00},
    {0xfe,0x54,0x2e,0xda,0x6e,0x30,0xca,0x00},
    {0xe4,0x1e,0xbe,0x50,0xfe,0x42,0xaa,0x00},
    {0x28,0xfe,0x28,0x7c,0xfe,0x24,0xfa,0x00},
    {0x90,0x2e,0x2a,0xea,0x7a,0x48,0xbe,0x00},
    {0x64,0xbe,0x6a,0x6e,0x64,0x16,0xac,0x00},
    {0x22,0x3a,0xea,0xda,0xb2,0xda,0xb6,0x00},
    {0xea,0x48,0xfe,0xa8,0x4a,0xe4,0x5a,0x00},
    {0xfe,0x6a,0xf4,0x2a,0x7c,0xfe,0x30,0x00},
    {0xa4,0x76,0xfa,0x2a,0xba,0xd4,0xaa,0x00},
    {0xe4,0xb6,0xcc,0xac,0xa4,0xd6,0x8c,0x00},
    {0x56,0xe0,0x56,0xf2,0xd2,0x52,0x56,0x00},
    {0x5a,0x6e,0xd6,0xea,0x7e,0x5c,0x6a,0x00},
    {0x40,0x7e,0x52,0x90,0x10,0x28,0xc6,0x00},
    {0x88,0x1c,0x8c,0x3e,0x88,0x88,0xb6,0x00},
    {0x96,0x3e,0x96,0x3a,0xbe,0x88,0xaa,0x00},
    {0x10,0xfe,0x82,0x28,0x28,0x44,0x82,0x00},
    {0x48,0xbe,0x48,0x9c,0x40,0xdc,0x5c,0x00},
    {0x20,0x7c,0x54,0x54,0x54,0x54,0xfe,0x00},
    {0x48,0xdc,0x0c,0xbe,0x08,0xc8,0xf6,0x00},
    {0x3e,0x22,0x3e,0x22,0x3e,0x42,0x86,0x00},
    {0x38,0x5c,0xe8,0x48,0x7e,0x48,0x48,0x00},
    {0x28,0x54,0xfe,0x6a,0x7e,0x48,0x76,0x00},
    {0x2a,0x5c,0xfe,0x54,0x6a,0x50,0x5c,0x00},
    {0x34,0x5e,0xee,0x54,0x7e,0x54,0x6e,0x00},
    {0x24,0xfe,0x7c,0x2c,0x78,0x6c,0xaa,0x00},
    {0x54,0x38,0xfe,0x44,0xbe,0x14,0x6c,0x00},
    {0x22,0x56,0xfe,0xae,0xfa,0x22,0xda,0x00},
    {0x08,0xfe,0xe2,0xdc,0xc0,0x1c,0x3e,0x00},
    {0xfe,0xaa,0xfe,0xba,0xd6,0x9a,0xfe,0x00},
    {0xee,0xca,0xe4,0x1a,0x7c,0x10,0xfe,0x00},
    {0x94,0xbe,0xcc,0xfe,0xce,0x5c,0xaa,0x00},
    {0xdc,0x4e,0x9c,0x48,0xde,0x48,0xbe,0x00},
    {0x10,0xfe,0x92,0x7c,0x38,0xca,0xba,0x00},
    {0x6e,0xe4,0x88,0xee,0x54,0xca,0xba,0x00},
    {0x54,0x38,0xfe,0x44,0xba,0x7c,0x30,0x00},
    {0x6a,0xdc,0x7e,0x54,0xea,0x50,0xdc,0x00},
    {0x48,0xd4,0x7e,0xea,0xfe,0x48,0x76,0x00},
    {0x48,0xee,0x54,0xee,0xdc,0x4c,0x4e,0x00},
    {0x10,0xfe,0x64,0xfe,0xba,0x7c,0x10,0x00},
    {0x14,0x10,0xfe,0x10,0x10,0x28,0xc6,0x00},
    {0x26,0xf4,0x2e,0xf4,0xd4,0xf4,0xba,0x00},
    {0xfe,0x4a,0x4a,0x9e,0x6a,0x6a,0x12,0x00},
    {0xfe,0x52,0x5e,0x92,0x7e,0x6c,0x16,0x00},
    {0x4c,0x8c,0x40,0xbe,0x52,0xfe,0x52,0x00},
    {0x3c,0xa4,0xbc,0xa4,0xfe,0x10,0x92,0x00},
    {0xfe,0x44,0x7c,0x5e,0x52,0x5e,0x92,0x00},
    {0x7c,0x44,0x7c,0x44,0x7c,0x2a,0xce,0x00},
    {0x94,0xfe,0x0c,0xbe,0x0e,0xdc,0xea,0x00},
    {0xee,0xca,0xe4,0x0a,0x7c,0x7c,0xc6,0x00},
    {0xee,0x44,0xe4,0xfe,0x44,0xe4,0x44,0x00},
    {0x88,0x3e,0x2a,0xfe,0x5c,0x5e,0xbe,0x00},
    {0x5a,0xae,0xea,0x56,0xea,0x68,0xd6,0x00},
    {0xc8,0xd4,0xbe,0xea,0xfe,0x88,0xb6,0x00},
    {0xfe,0x94,0x6e,0xfa,0x6e,0x70,0xca,0x00},
    {0xe8,0xd4,0xfe,0xea,0xfe,0x28,0xb6,0x00},
    {0x48,0x74,0xde,0xaa,0xbe,0xa8,0xf6,0x00},
    {0x7c,0x00,0xfe,0x28,0x28,0x4a,0x8e,0x00},
    {0x7e,0x48,0x5c,0x5c,0x48,0x6a,0x98,0x00},
    {0x54,0x7e,0x60,0x76,0x5a,0x74,0x9a,0x00},
    {0x20,0x2e,0xc2,0x52,0x22,0x52,0xf4,0x00},
    {0xc8,0x7e,0xd0,0xb4,0xc8,0x54,0xfa,0x00},
    {0x84,0x3e,0xa4,0x3c,0xa6,0xbc,0xda,0x00},
    {0xbe,0x24,0xae,0x2e,0xa4,0xb6,0xcc,0x00},
    {0x10,0xfe,0x20,0x68,0x10,0x24,0xfa,0x00},
    {0x1e,0xf2,0x5e,0xf2,0x5e,0xec,0x16,0x00},
    {0x48,0xbe,0x50,0xb4,0x48,0xd4,0x7a,0x00},
    {0x44,0xfe,0xa8,0xba,0xe4,0xaa,0xbe,0x00},
    {0x38,0xfe,0x00,0x38,0x00,0x7c,0x7c,0x00},
    {0x88,0xfe,0x14,0xbe,0x28,0xe2,0xec,0x00},
    {0xfe,0xb2,0xde,0xb2,0xbe,0xd4,0x9a,0x00},
    {0x0e,0xf0,0x54,0x10,0xfe,0x10,0x30,0x00},
    {0x3e,0x6a,0xfe,0x6a,0x76,0x7e,0x7e,0x00},
    {0x10,0x10,0xfe,0x10,0x7c,0x44,0x7c,0x00},
    {0x06,0xf8,0xea,0xc8,0xfe,0x08,0x18,0x00},
    {0xfe,0x92,0xba,0x92,0xaa,0xba,0xfe,0x00},
    {0x24,0x24,0xfe,0x54,0x6e,0x3a,0xce,0x00},
    {0xe2,0x3c,0x54,0x74,0xd4,0x56,0xea,0x00},
    {0xfc,0x04,0x04,0xfc,0x80,0x82,0x7e,0x00},
    {0x08,0x7e,0x48,0x7e,0x5c,0x7e,0x88,0x00},
    {0xc2,0x5c,0xd4,0x94,0xd4,0x56,0xea,0x00},
    {0xfe,0x00,0x7c,0x44,0x7c,0x40,0x80,0x00},
    {0x48,0xee,0x5a,0xea,0xaa,0xe4,0x1a,0x00},
    {0x48,0xc8,0x7e,0xc8,0xdc,0x54,0x5c,0x00},
    {0xae,0x7a,0xae,0x7a,0xde,0xfa,0x8a,0x00},
    {0xa2,0x5c,0xd4,0x54,0xd4,0x56,0xaa,0x00},
    {0x96,0x7e,0xd6,0x7e,0xee,0xfe,0x4a,0x00},
    {0x44,0xfe,0x2c,0x52,0xec,0x6e,0x42,0x00},
    {0xee,0xaa,0xe0,0xae,0xea,0xa4,0xba,0x00},
    {0x4e,0xea,0x4e,0xea,0xae,0xea,0x16,0x00},
    {0x28,0xfe,0xde,0x54,0x94,0x56,0xea,0x00},
    {0x08,0x0e,0x78,0x4e,0x40,0x54,0xa6,0x00},
    {0x88,0xfe,0x14,0xaa,0x1c,0xde,0xc2,0x00},
    {0xe4,0xbe,0xec,0x52,0xec,0xce,0xe2,0x00},
    {0x48,0xa8,0xfe,0x48,0xdc,0x54,0xdc,0x00},
    {0xfe,0x44,0x7c,0x54,0x5e,0x74,0x9e,0x00},
    {0xfe,0x54,0x76,0x66,0xf6,0x60,0x7a,0x00},
    {0x44,0xee,0x44,0xae,0xca,0x64,0xda,0x00},
    {0x7c,0x10,0x10,0x7c,0x24,0x24,0xfe,0x00},
    {0xfe,0x20,0x3c,0x24,0x78,0x08,0xfe,0x00},
    {0x3c,0x48,0xc8,0x7c,0x54,0x54,0x7e,0x00},
    {0x40,0x7c,0x90,0x10,0xfe,0x10,0x10,0x00},
    {0x1c,0x54,0x7c,0x04,0xfe,0x00,0xc6,0x00},
    {0x7c,0x10,0x78,0x28,0xfe,0x44,0x7c,0x00},
    {0x46,0x56,0xfc,0xa4,0xde,0x60,0x92,0x00},
    {0x48,0x90,0x4a,0xfe,0x54,0x48,0x76,0x00},
    {0x66,0xbe,0x56,0xde,0x76,0x7c,0x44,0x00},
    {0x5c,0xc8,0xfc,0x54,0x7e,0x54,0x5c,0x00},
    {0x5c,0xc8,0x7c,0xd4,0xfe,0x54,0x5c,0x00},
    {0x48,0xf6,0x5c,0xfe,0xea,0x6e,0x7a,0x00},
    {0x16,0xfe,0x56,0xfe,0x6e,0xfe,0x0a,0x00},
    {0x28,0x7c,0x28,0xfe,0x44,0xba,0x58,0x00},
    {0x5c,0xc8,0x3c,0xd4,0x3e,0xd4,0xdc,0x00},
    {0x46,0xd6,0x1c,0xc4,0x1e,0xc0,0xd2,0x00},
    {0x94,0xfe,0x1c,0xde,0x14,0xc8,0xf6,0x00},
    {0xd6,0x7e,0xd6,0xfe,0xee,0xfe,0xca,0x00},
    {0x40,0x7e,0xb8,0x08,0x30,0x42,0x3e,0x00},
    {0x7e,0xaa,0x7e,0x6a,0x7e,0x08,0xbe,0x00},
    {0x10,0xfe,0x28,0xc6,0x28,0x10,0xee,0x00},
    {0x28,0x7e,0xd4,0x62,0x54,0x48,0x76,0x00},
    {0x2c,0x44,0xde,0x48,0x5e,0x44,0x5a,0x00},
    {0x2c,0x64,0xfe,0x68,0x7e,0x64,0x5a,0x00},
    {0x28,0x5c,0xfe,0x54,0x7e,0x5c,0x48,0x00},
    {0x10,0x54,0x38,0xfe,0x28,0x2a,0xce,0x00},
    {0x28,0x28,0x44,0x92,0x10,0x24,0xfa,0x00},
    {0x08,0xfe,0x4a,0x4a,0x6a,0xca,0x16,0x00},
    {0x28,0xfe,0x5a,0x8a,0x5a,0x2a,0xd6,0x00},
    {0x40,0x7e,0x52,0x92,0x2a,0x76,0x02,0x00},
    {0x7e,0x5c,0x5c,0x44,0x7e,0x48,0x98,0x00},
    {0x00,0x7e,0x42,0x42,0x42,0x7e,0x42,0x00},
    {0x10,0xfe,0x82,0xba,0xaa,0xba,0x86,0x00},
    {0x0c,0x70,0x40,0x7e,0x40,0x5c,0x9c,0x00},
    {0x2c,0xe4,0xbe,0xa8,0xfe,0x24,0x3a,0x00},
    {0x48,0x7e,0xc0,0x5c,0x54,0xd4,0x26,0x00},
    {0x42,0x5c,0xf0,0x5e,0x70,0xd6,0x26,0x00},
    {0x2e,0x22,0xf4,0x5e,0x64,0x34,0xcc,0x00},
    {0xe8,0x28,0x48,0x68,0xc8,0x4a,0xce,0x00},
    {0x12,0x7c,0x18,0xfe,0x24,0xde,0x08,0x00},
    {0x10,0xfe,0xa2,0xfc,0x48,0x94,0x3a,0x00},
    {0x00,0x7c,0x10,0x10,0x10,0x10,0xfe,0x00},
    {0x1e,0xe8,0x48,0x4e,0x62,0xc2,0x06,0x00},
    {0x28,0x7c,0x28,0xfe,0x74,0xa2,0x38,0x00},
    {0x10,0x7c,0xfe,0x28,0xfe,0x7c,0x10,0x00},
    {0x08,0x7e,0x40,0x48,0x48,0x54,0xba,0x00},
    {0x08,0x7e,0x5e,0x4a,0x5e,0x48,0xb6,0x00},
    {0x08,0x7e,0x4e,0x7c,0x6a,0x5c,0xaa,0x00},
    {0xc8,0x48,0xc8,0x88,0xd0,0x54,0xfa,0x00},
    {0x7e,0xdc,0xd4,0x5c,0x54,0x5c,0x7e,0x00},
    {0x54,0xfe,0xd0,0x5c,0x40,0x5a,0x6a,0x00},
    {0x48,0xfe,0x40,0x5c,0xd4,0x54,0xe6,0x00},
    {0x50,0xde,0x62,0x5a,0xda,0x42,0xc6,0x00},
    {0x48,0xfe,0x76,0x40,0xdc,0x48,0xfe,0x00},
    {0x08,0xee,0x5a,0x4a,0x6a,0xc4,0x1a,0x00},
    {0x7c,0x44,0x7c,0x4e,0x8a,0xea,0x08,0x00},
    {0x7c,0x44,0x7c,0x54,0xfe,0x28,0xce,0x00},
    {0xfe,0x54,0x7c,0x54,0x7c,0x30,0xce,0x00},
    {0x48,0xfe,0x40,0xdc,0xd4,0x54,0x66,0x00},
    {0x48,0xfe,0x54,0xe2,0xd4,0x48,0x76,0x00},
    {0x7e,0xdc,0x5c,0xc8,0xd8,0x48,0x76,0x00},
    {0x54,0xfe,0x54,0xfe,0xdc,0x7e,0x54,0x00},
    {0x80,0x1c,0x88,0x08,0x48,0x88,0xbe,0x00},
    {0x94,0x3e,0x94,0x14,0xbe,0x80,0xa2,0x00},
    {0x98,0x1c,0xa8,0x3e,0x80,0x9c,0x9c,0x00},
    {0x94,0x3e,0x94,0x7c,0xaa,0xd0,0x9c,0x00},
    {0x94,0x3e,0x94,0x3e,0x9c,0xbe,0x94,0x00},
    {0xfe,0x92,0xfe,0x92,0xfe,0x10,0x10,0x00},
    {0x10,0x7c,0x44,0x7c,0xfe,0x10,0xfe,0x00},
    {0xfe,0x4e,0x4e,0x84,0x6c,0x64,0x1a,0x00},
    {0xc8,0x7e,0xd4,0x5c,0xfe,0xe2,0x6a,0x00},
    {0x88,0x7e,0xee,0x6c,0xfa,0xec,0x5a,0x00},
    {0x40,0x9c,0x48,0xa8,0x48,0xc8,0x7e,0x00},
    {0x50,0xbe,0x50,0x94,0x54,0xea,0x4e,0x00},
    {0x48,0xbe,0x54,0xa2,0x54,0xc8,0x76,0x00},
    {0x7e,0xa2,0x76,0xaa,0x76,0xfe,0x62,0x00},
    {0x54,0xfe,0x54,0xd4,0x7e,0xd4,0x64,0x00},
    {0x12,0x7c,0x18,0xfe,0x30,0xde,0x02,0x00},
    {0x10,0x5c,0x50,0xfe,0x44,0x7c,0x44,0x00},
    {0xe8,0xbe,0xe8,0xaa,0xf4,0xaa,0xae,0x00},
    {0xe8,0xbe,0xf6,0xa0,0xfc,0xa8,0xbe,0x00},
    {0x10,0xfe,0x44,0xfe,0xba,0x7c,0x44,0x00},
    {0x48,0xfe,0xa0,0xbc,0xf4,0xb4,0xa6,0x00},
    {0x28,0xfe,0x40,0x7c,0x00,0x54,0x96,0x00},
    {0x5c,0x80,0x7e,0xc4,0x44,0x44,0x4c,0x00},
    {0x5e,0xa8,0x56,0xfa,0x7a,0x52,0x6a,0x00},
    {0x94,0xfe,0x14,0xbe,0x1c,0xfe,0xd4,0x00},
    {0x7c,0x10,0xfe,0x7c,0x44,0x7c,0xc6,0x00},
    {0xd4,0xfe,0xd4,0xfe,0xdc,0x3e,0x94,0x00},
    {0x2e,0xfa,0x5c,0x8a,0x5a,0x2c,0xd8,0x00},
    {0xea,0x5c,0xc8,0xfe,0xd4,0xee,0xc4,0x00},
    {0x44,0xbe,0xf0,0x54,0xf4,0x7a,0xce,0x00},
    {0xe4,0x5e,0x50,0x94,0x74,0x7a,0x2e,0x00},
    {0x7e,0xa2,0xf6,0x6a,0xf6,0x7e,0xe2,0x00},
    {0xee,0xee,0x92,0xaa,0xfe,0xaa,0xba,0x00},
    {0xcc,0xd4,0x88,0xf6,0xdc,0xbe,0x84,0x00},
    {0x1e,0xe8,0x5e,0x52,0x7e,0xc0,0x12,0x00},
    {0x0c,0x70,0xfe,0x38,0xd6,0x7c,0x7c,0x00},
    {0x10,0xfe,0x28,0x38,0xfe,0xaa,0xba,0x00},
    {0x84,0x7e,0xae,0x28,0xbe,0xe2,0x96,0x00},
    {0xfa,0x8e,0xde,0xae,0xda,0xfa,0x8a,0x00},
    {0x24,0x7e,0x26,0xf6,0x26,0x5a,0xea,0x00},
    {0x38,0x28,0xfe,0x20,0x3c,0x04,0x0c,0x00},
    {0x10,0x28,0xde,0x00,0x7c,0x44,0x7c,0x00},
    {0x48,0x7e,0xd4,0x7e,0x5a,0xec,0x1a,0x00},
    {0x4a,0xdc,0x48,0x7e,0xd8,0x6e,0xc2,0x00},
    {0x88,0x3e,0x94,0x7e,0xda,0xac,0x9a,0x00},
    {0x10,0xfe,0x44,0xfe,0xda,0x2c,0xda,0x00},
    {0x10,0xfe,0x38,0xfe,0x6c,0xfe,0x24,0x00},
    {0x50,0xfe,0x56,0x6a,0xbe,0x4a,0xbe,0x00},
    {0x10,0xfe,0x7c,0x44,0x7c,0x2a,0xce,0x00},
    {0x22,0xfa,0x4a,0xaa,0x52,0x22,0xd6,0x00},
    {0x50,0x7c,0x90,0xfe,0x00,0x7c,0x7c,0x00},
    {0xfe,0xba,0x92,0xba,0x96,0xba,0xfe,0x00},
    {0x2e,0xfa,0x20,0xfe,0xaa,0x74,0xaa,0x00},
    {0xec,0x4e,0xf4,0xfe,0xa0,0xee,0xee,0x00},
    {0x64,0x7e,0xae,0xf8,0x0e,0x62,0x6a,0x00},
    {0x7c,0x54,0x7c,0x10,0xfe,0x00,0xaa,0x00},
    {0xb6,0x5c,0xa6,0x7c,0xa4,0x3c,0xda,0x00},
    {0x88,0x3e,0xac,0x3c,0xa0,0xb4,0xde,0x00},
    {0xfe,0xac,0xec,0xa8,0xfe,0xac,0xba,0x00},
    {0xbe,0x10,0xfc,0xf4,0x1c,0xd4,0xfa,0x00},
    {0x40,0x7e,0xaa,0x2a,0x54,0xca,0xba,0x00},
    {0x50,0xde,0xea,0x4a,0x54,0x72,0x6e,0x00},
    {0x3c,0x2c,0xfe,0xbe,0x24,0x3c,0x24,0x00},
    {0xa8,0x5e,0xb2,0x7e,0xb2,0x32,0xde,0x00},
    {0x98,0x48,0x08,0xd4,0x62,0x40,0xbe,0x00},
    {0x28,0x28,0xba,0xac,0xa8,0xba,0xce,0x00},
    {0x9e,0xa8,0xde,0x92,0xbe,0xe0,0x12,0x00},
    {0x10,0x28,0xde,0x00,0x7c,0x08,0x30,0x00},
    {0xfe,0x92,0xfe,0xba,0xd6,0x92,0xfe,0x00},
    {0x48,0x7e,0xea,0x7e,0x6a,0xfe,0x08,0x00},
    {0x2c,0xdc,0x6a,0xac,0x6a,0x10,0xfe,0x00},
    {0x5e,0x54,0xfe,0xb4,0xda,0x6c,0x8c,0x00},
    {0x5e,0xf2,0xde,0x52,0x5e,0x54,0x5a,0x00},
    {0x2c,0xdc,0x6a,0xac,0x6a,0xc0,0xba,0x00},
    {0x0c,0x70,0x7c,0x48,0xe6,0x7c,0x7c,0x00},
    {0x7c,0x44,0x7c,0x48,0x6e,0x48,0xee,0x00},
    {0x5e,0xf2,0x5e,0xf2,0xde,0x54,0x5a,0x00},
    {0x7e,0xea,0x7e,0xea,0xfe,0x6a,0x7e,0x00},
    {0xbe,0x22,0xbe,0x24,0xb6,0xa4,0xb6,0x00},
    {0x08,0x7e,0xdc,0x54,0xdc,0x54,0x9a,0x00},
    {0x54,0xbe,0x54,0xbc,0x54,0xf4,0x5c,0x00},
    {0x7c,0x44,0x7c,0x44,0x7c,0x48,0xe6,0x00},
    {0xe8,0x1e,0xfa,0x5e,0xbe,0xec,0x16,0x00},
    {0x24,0xb6,0xa4,0xf6,0x7c,0x00,0xfe,0x00},
    {0x28,0x7e,0xd0,0x5e,0x54,0x64,0x5e,0x00},
    {0x7c,0x14,0x44,0x28,0x10,0x28,0xc6,0x00},
    {0x12,0xfe,0xd4,0xe6,0xdc,0x28,0x16,0x00},
    {0x54,0x7e,0x48,0xfe,0xde,0xd4,0x2e,0x00},
    {0x20,0xfe,0x20,0x3c,0x48,0x88,0x7e,0x00},
    {0x24,0xfe,0x10,0xfe,0x5c,0x48,0xbe,0x00},
    {0x10,0xfe,0x38,0xd6,0x7c,0x44,0xfe,0x00},
    {0x88,0x1c,0x9a,0x28,0x8a,0x84,0x98,0x00},
    {0x14,0xfe,0x48,0xfe,0x5e,0xd4,0x2e,0x00},
    {0xe8,0x5c,0x5a,0x88,0x6a,0x64,0x18,0x00},
    {0x50,0xde,0x28,0xce,0x08,0xce,0xc8,0x00},
    {0x56,0xa4,0xfe,0x52,0xfe,0x60,0xd2,0x00},
    {0x88,0x2a,0x8c,0x30,0xfe,0x68,0xb6,0x00},
    {0x54,0x54,0xba,0x10,0x7c,0x10,0xfe,0x00},
    {0x08,0x7e,0x54,0x6a,0x5c,0x48,0xbe,0x00},
    {0x54,0xd4,0x6a,0x48,0xdc,0x48,0xfe,0x00},
    {0x28,0x5c,0xc8,0x7e,0x5c,0x5c,0x62,0x00},
    {0x2a,0x7e,0xd4,0x5e,0x74,0x54,0x5e,0x00},
    {0xfe,0x54,0x7c,0x54,0xfe,0x44,0x4c,0x00},
    {0x7c,0x44,0xfe,0x52,0x5a,0xf4,0x1a,0x00},
    {0x28,0x7a,0x28,0xfe,0x06,0x64,0x6a,0x00},
    {0x10,0xfe,0xaa,0x7c,0xfe,0x54,0xba,0x00},
    {0x10,0xfe,0x14,0x7c,0xfe,0x28,0xf6,0x00},
    {0x10,0xfe,0x92,0x7c,0x28,0xfe,0x10,0x00},
    {0x1a,0xe4,0xaa,0x14,0xf8,0x72,0xac,0x00},
    {0x08,0xfe,0x08,0x0c,0x18,0xe8,0x18,0x00},
    {0x46,0xf8,0x6a,0x44,0xfe,0x5c,0xea,0x00},
    {0x28,0x7a,0x28,0xfe,0x26,0x74,0xaa,0x00},
    {0x10,0x5c,0x50,0xfe,0x46,0x74,0xaa,0x00},
    {0x88,0x3e,0x94,0x08,0xb6,0x9c,0xa4,0x00},
    {0x4a,0x94,0x4a,0x10,0x54,0x28,0xc6,0x00},
    {0x0e,0xf0,0x54,0x08,0xfe,0x38,0xd6,0x00},
    {0x7e,0x7e,0x44,0x76,0x5c,0x7e,0x84,0x00},
    {0xe8,0x5c,0x4c,0x96,0x68,0x7e,0x08,0x00},
    {0x24,0xb6,0xa4,0xfe,0x40,0xbc,0x3c,0x00},
    {0x76,0x52,0xac,0x44,0xba,0x54,0xb2,0x00},
    {0x10,0xfe,0x38,0xee,0x54,0x7c,0x94,0x00},
    {0x5e,0x96,0x56,0xbe,0x56,0xf6,0x5e,0x00},
    {0x28,0xfe,0x54,0x08,0xfe,0x38,0xd6,0x00},
    {0x28,0x7a,0x28,0xfe,0x66,0xd4,0x6a,0x00},
    {0x28,0x7a,0x28,0xfe,0x66,0xf4,0x2a,0x00},
    {0xde,0xea,0x94,0xe2,0xdc,0x88,0xaa,0x00},
    {0x22,0xfa,0x5a,0x2a,0xda,0x72,0x96,0x00},
    {0x20,0xfe,0x28,0x5c,0xc8,0x48,0x7e,0x00},
    {0x44,0xfe,0x44,0xc6,0xcc,0x74,0x4c,0x00},
    {0xfe,0xfe,0x28,0xee,0x28,0xee,0x48,0x00},
    {0xe4,0xbe,0xe4,0xa6,0xec,0x14,0xac,0x00},
    {0x9e,0x14,0x14,0x3e,0x8c,0xb4,0x8c,0x00},
    {0x5e,0x50,0xfe,0x5a,0x7a,0xd4,0x2a,0x00},
    {0xde,0xd0,0x9e,0xda,0xda,0x94,0xaa,0x00},
    {0x7e,0x6a,0xfe,0x6a,0x5c,0xf6,0x14,0x00},
    {0x54,0xfe,0x5a,0xee,0xda,0x5e,0x54,0x00},
    {0x24,0x18,0x24,0xfe,0x64,0xbc,0x24,0x00},
    {0x14,0xe0,0xbe,0xa8,0xfe,0x08,0x36,0x00},
    {0x48,0x7e,0x48,0xd4,0xfe,0xc4,0x14,0x00},
    {0x48,0x7e,0xc8,0x54,0x7e,0xc4,0x14,0x00},
    {0xc8,0x7e,0x48,0x94,0x7e,0x64,0x14,0x00},
    {0xec,0xb4,0x5e,0xec,0x3e,0x02,0xaa,0x00},
    {0x28,0x4e,0xd8,0x4e,0x48,0x4e,0x48,0x00},
    {0xb2,0x2a,0xfa,0x9a,0xf2,0x92,0xb6,0x00},
    {0x10,0xde,0xe8,0xce,0xc8,0x0e,0x08,0x00},
    {0x48,0xfe,0x76,0x50,0xdc,0x6e,0xc8,0x00},
    {0x08,0xee,0xb8,0xee,0xa8,0xee,0x08,0x00},
    {0x5e,0xfa,0x2e,0xaa,0xfe,0x4a,0x96,0x00},
    {0x5e,0xda,0x5a,0xfe,0xda,0x5a,0x52,0x00},
    {0x10,0xfe,0xaa,0x4c,0x70,0x9e,0x10,0x00},
    {0x48,0x6e,0xb4,0xfe,0x92,0x38,0xd6,0x00},
    {0x10,0x7c,0xfe,0xaa,0x74,0x10,0x92,0x00},
    {0x54,0xbe,0xd4,0x7e,0xdc,0x54,0xdc,0x00},
    {0x6a,0xc4,0x48,0xfe,0xd4,0x4c,0x72,0x00},
    {0x64,0xae,0x64,0x7e,0x6e,0x04,0xae,0x00},
    {0x48,0x6e,0xb4,0x2c,0xfe,0x2c,0x3e,0x00},
    {0x68,0x6a,0xfc,0x28,0x7a,0x6e,0x9e,0x00},
    {0x7e,0x6a,0x6a,0xfe,0x6a,0x6a,0x42,0x00},
    {0x7a,0x4a,0x7a,0x52,0x7a,0x5a,0x96,0x00},
    {0x10,0xfe,0xea,0x44,0xba,0x54,0xb2,0x00},
    {0x4a,0xf4,0x4a,0x6e,0xda,0x44,0xd8,0x00},
    {0x5c,0xd4,0x7e,0x5e,0xda,0x7c,0xca,0x00},
    {0x48,0xfe,0x6a,0x54,0xe2,0x5c,0xea,0x00},
    {0x28,0xf8,0x28,0x78,0x68,0xaa,0x2e,0x00},
    {0x5e,0x2a,0xd0,0x2e,0xfa,0x74,0xaa,0x00},
    {0x28,0xfe,0xcc,0x9e,0xd4,0xd4,0xae,0x00},
    {0x4a,0xee,0x6c,0xbe,0xec,0x7c,0xae,0x00},
    {0x10,0x7c,0x7c,0xd6,0x10,0xfe,0x10,0x00},
    {0x64,0xae,0x64,0x7e,0x6a,0x0e,0xaa,0x00},
    {0x7a,0xee,0x7e,0x56,0xda,0x6a,0xea,0x00},
    {0x48,0xbc,0xc8,0x7e,0xd4,0x5c,0xd4,0x00},
    {0x68,0xbe,0x74,0x62,0x74,0x08,0xb6,0x00},
    {0x00,0x7c,0x54,0x54,0x54,0x54,0xfe,0x00},
    {0x3e,0xd4,0xbe,0xf6,0xb6,0xe2,0x3e,0x00},
    {0x00,0x7c,0x00,0x38,0x00,0x00,0xfe,0x00},
    {0x10,0x28,0xd6,0x38,0x54,0xfe,0x10,0x00},
    {0x28,0x74,0xfe,0x54,0xa2,0x08,0x70,0x00},
    {0x10,0x10,0x92,0x92,0x92,0x92,0xfe,0x00},
    {0x48,0xd4,0xfa,0x54,0x6a,0x44,0x58,0x00},
    {0x54,0xfe,0x5a,0x7a,0xda,0x5c,0xda,0x00},
    {0x54,0xf6,0x5a,0xfa,0x5a,0x74,0x5a,0x00},
    {0x4a,0xfe,0x48,0xfc,0xca,0x44,0x5a,0x00},
    {0x58,0x56,0xea,0xd4,0x6a,0x5c,0xaa,0x00},
    {0x1e,0xfa,0x5a,0xfe,0x5a,0xfa,0x12,0x00},
    {0x10,0xfe,0x24,0x7e,0x5c,0x48,0xbe,0x00},
    {0x48,0x6e,0xb4,0x7c,0x44,0xfe,0x48,0x00},
    {0x48,0x6e,0xb4,0x38,0xfe,0x38,0x92,0x00},
    {0xfe,0x10,0xee,0x54,0x7c,0x14,0xfa,0x00},
    {0x94,0xfe,0x14,0xaa,0x1c,0xdc,0xe2,0x00},
    {0x44,0xee,0x44,0xaa,0x7c,0x7c,0xc6,0x00},
    {0xea,0x5e,0xea,0xf2,0xac,0xf4,0xea,0x00},
    {0x2e,0x3a,0xd4,0x3a,0xf6,0x28,0x76,0x00},
    {0xe4,0x58,0xf0,0xfe,0x54,0xf4,0x44,0x00},
    {0x2e,0xf8,0x6e,0xf4,0x24,0x7c,0x7c,0x00},
    {0xea,0x5e,0x68,0xbc,0x6a,0x44,0x9a,0x00},
    {0x28,0x48,0xfe,0x48,0x48,0x48,0x5c,0x00},
    {0x3c,0x44,0xc8,0x7e,0x48,0x48,0x58,0x00},
    {0x3e,0x42,0xda,0x42,0x5a,0x5a,0x46,0x00},
    {0x28,0x7e,0xda,0x5e,0x78,0x48,0x76,0x00},
    {0x22,0xfa,0x22,0xfa,0xaa,0x72,0xaa,0x00},
    {0xfe,0x02,0x7a,0x02,0x7a,0x7a,0x06,0x00},
    {0x10,0x7c,0x54,0x7c,0x30,0x10,0xee,0x00},
    {0x6e,0x62,0x0e,0xf2,0xfe,0xde,0x92,0x00},
    {0xfe,0xaa,0xaa,0xae,0xc2,0x82,0xfe,0x00},
    {0x10,0x10,0xfe,0x10,0x10,0x10,0x7c,0x00},
    {0x24,0x24,0xfa,0x5e,0x60,0x3e,0xce,0x00},
    {0x44,0x5e,0xe4,0xbe,0xd6,0x76,0x84,0x00},
    {0x90,0x1e,0xaa,0x14,0xfe,0x28,0xf6,0x00},
    {0x7c,0x08,0x10,0xfe,0x10,0x10,0x30,0x00},
    {0x7e,0x42,0x7e,0x5c,0x6e,0x54,0xa6,0x00},
    {0x10,0xfe,0x10,0x7c,0x54,0x54,0x10,0x00},
    {0x5e,0xe8,0xfe,0xaa,0xea,0xea,0x08,0x00},
    {0x10,0xfe,0x10,0x7c,0x00,0xca,0xba,0x00},
    {0x7c,0x54,0x7c,0x54,0x7c,0xca,0xba,0x00},
    {0x52,0xdc,0x52,0x5e,0xc0,0x5e,0xde,0x00},
    {0x10,0xfe,0x10,0x78,0x28,0x10,0xee,0x00},
    {0xe8,0x2e,0x5a,0x6a,0xca,0x44,0xda,0x00},
    {0x52,0xfc,0x58,0x7e,0xfa,0x0a,0x92,0x00},
    {0x48,0xee,0x58,0x6e,0x7a,0xa8,0xae,0x00},
    {0x8c,0xf0,0x82,0x7e,0x7c,0x44,0x7c,0x00},
    {0x48,0xfe,0x48,0xfc,0xd4,0x48,0x76,0x00},
    {0x10,0x10,0x5c,0x50,0x50,0x50,0xfe,0x00},
    {0xfe,0x48,0x6a,0xac,0x68,0x4a,0x8e,0x00},
    {0x0c,0x70,0x50,0x7e,0x48,0x44,0xe2,0x00},
    {0xae,0x5c,0xbe,0x76,0xbe,0x3e,0xc4,0x00},
    {0x44,0xe4,0x36,0x54,0xf4,0x54,0x7e,0x00},
    {0x74,0x24,0xf4,0x24,0x78,0xaa,0x2e,0x00},
    {0x10,0x64,0x18,0x24,0xfa,0x10,0x92,0x00},
    {0x42,0x9c,0x54,0xbe,0x54,0xf4,0x5a,0x00},
    {0x24,0xb6,0xa4,0xf6,0x7a,0x10,0x92,0x00},
    {0xe4,0xbe,0xe4,0xbe,0xea,0xa4,0xba,0x00},
    {0xea,0xac,0xea,0xae,0xe0,0xae,0xae,0x00},
    {0xfe,0x28,0x74,0x10,0x7c,0x10,0xfe,0x00},
    {0x5e,0xf2,0x3e,0x52,0xfe,0x4c,0x56,0x00},
    {0x5e,0xe2,0x1a,0xc2,0x1a,0xda,0xc6,0x00},
    {0x48,0xdc,0x08,0xbe,0x04,0xfe,0xd4,0x00},
    {0x4a,0xc8,0x3e,0xc4,0x3c,0xd4,0xfa,0x00},
    {0x88,0xfe,0x08,0xdc,0x00,0xd2,0xee,0x00},
    {0xa8,0xce,0x16,0xc4,0x2a,0xde,0xde,0x00},
    {0x90,0x1e,0x2a,0x94,0x7c,0x7c,0xc6,0x00},
    {0xfe,0xb2,0xfe,0xa8,0xee,0x16,0xaa,0x00},
    {0x54,0x5e,0xf4,0xde,0xd4,0xf4,0xde,0x00},
    {0x5e,0xa2,0x5a,0xc2,0xda,0x9a,0xe6,0x00},
    {0x10,0x5e,0xfc,0x76,0x5a,0x76,0x7e,0x00},
    {0x10,0xfe,0x54,0xfc,0x16,0xfc,0x30,0x00},
    {0x32,0x56,0xd2,0x5a,0x52,0x64,0x4a,0x00},
    {0x28,0x5c,0xc8,0x7e,0x44,0x7e,0x54,0x00},
    {0x5c,0x54,0x5c,0x54,0x5c,0x2a,0xce,0x00},
    {0x10,0xfe,0xba,0x08,0xfe,0x10,0x30,0x00},
    {0x10,0x7c,0x10,0xfe,0x08,0xfe,0x28,0x00},
    {0x24,0xfe,0x24,0x48,0x24,0xca,0xba,0x00},
    {0x48,0xdc,0x48,0x7e,0xc4,0x7e,0xd4,0x00},
    {0x08,0xfc,0xa8,0xfe,0xa4,0xfe,0x14,0x00},
    {0x90,0x1e,0x2a,0x08,0x48,0x94,0xa2,0x00},
    {0x94,0x3e,0x92,0x24,0x92,0xa4,0xb6,0x00},
    {0x88,0x08,0x94,0x3a,0x80,0x9c,0x9c,0x00},
    {0xfe,0x54,0xfe,0xb6,0xda,0xb6,0xda,0x00},
    {0xfe,0x54,0xfe,0xb6,0xda,0x7c,0xfe,0x00},
    {0x08,0x7e,0xdc,0x48,0xfe,0x54,0x8c,0x00},
    {0xea,0x5e,0x4a,0x94,0x6a,0x74,0x1e,0x00},
    {0x7c,0x00,0xfe,0x10,0x54,0x92,0x30,0x00},
    {0xfe,0x10,0xfe,0xaa,0xaa,0xaa,0xaa,0x00},
    {0xfe,0x24,0x3c,0x3c,0x24,0xfe,0x04,0x00},
    {0x10,0x7e,0x42,0x7a,0x5e,0x42,0x7e,0x00},
    {0x28,0xfe,0x1c,0xc8,0xfe,0xd4,0x0c,0x00},
    {0x24,0xde,0xea,0x5e,0xe4,0xbe,0xe4,0x00},
    {0x88,0x0e,0x92,0x2a,0x84,0x88,0xb0,0x00},
    {0x08,0x7e,0x54,0x7c,0x76,0x64,0xb6,0x00},
    {0x0a,0xfe,0x08,0x78,0x24,0x34,0xc2,0x00},
    {0x96,0xfc,0x1e,0xbc,0x06,0xdc,0xda,0x00},
    {0x04,0xee,0xee,0xe8,0xee,0xe2,0x16,0x00},
    {0x48,0x6e,0xb4,0x00,0x7c,0x00,0xfe,0x00},
    {0xe4,0x5e,0xf6,0xfe,0x56,0xf6,0x5e,0x00},
    {0x10,0xfe,0x82,0x10,0xfe,0x00,0xc6,0x00},
    {0x38,0xfe,0xb6,0x00,0xfe,0x18,0x14,0x00},
    {0x20,0x20,0x2e,0xf0,0x20,0x22,0x1e,0x00},
    {0x10,0xf0,0xb2,0xbc,0xf0,0x12,0x1e,0x00},
    {0x28,0x7c,0xf4,0x54,0xfc,0x74,0x26,0x00},
    {0x50,0x7c,0x90,0xfe,0x10,0x28,0xc6,0x00},
    {0x84,0x9e,0xf0,0xd8,0xfe,0x54,0xaa,0x00},
    {0x10,0xfe,0xb2,0x28,0x74,0x10,0xfe,0x00},
    {0xfe,0x54,0xfe,0x38,0xd6,0x48,0xba,0x00},
    {0xbe,0x22,0xbe,0x14,0xb6,0x94,0xbe,0x00},
    {0x88,0x3e,0x9c,0x2a,0x9c,0xac,0xda,0x00},
    {0x08,0x7e,0xd0,0x5c,0xfe,0x48,0xb6,0x00},
    {0x24,0x48,0x6e,0xbc,0x24,0x3c,0xc6,0x00},
    {0x10,0xfe,0xba,0x10,0xfe,0x10,0xee,0x00},
    {0x28,0xfe,0x26,0xfc,0x56,0xfe,0x74,0x00},
    {0x48,0x6e,0xb4,0x48,0xfe,0x5c,0x6a,0x00},
    {0x3e,0x6a,0xfe,0x7e,0x40,0x72,0x6e,0x00},
    {0x24,0xb6,0xa4,0xf6,0xfe,0x38,0xd6,0x00},
    {0x28,0xfe,0x10,0x7c,0x08,0x50,0xbe,0x00},
    {0x7e,0x7e,0x6a,0x5c,0x7e,0x54,0xba,0x00},
    {0x28,0xfe,0x54,0xca,0x78,0xca,0xb6,0x00},
    {0x48,0xbe,0x54,0x9c,0x7e,0xe2,0x6a,0x00},
    {0x10,0x28,0xd6,0x38,0xfe,0x44,0x7c,0x00},
    {0xfe,0xa2,0x3c,0x20,0xfe,0x08,0x18,0x00},
    {0x22,0x7e,0x52,0x7a,0xd6,0x32,0xd6,0x00},
    {0x48,0xd4,0x6a,0x5c,0xfe,0x54,0xdc,0x00},
    {0x24,0x76,0x2a,0xfa,0x5a,0xd4,0x5a,0x00},
    {0x22,0x5a,0xf2,0x2a,0xf2,0x2e,0xb2,0x00},
    {0x14,0x7c,0x18,0xfe,0x5c,0x00,0xaa,0x00},
    {0x48,0xe8,0x3c,0x48,0xe8,0x48,0x7e,0x00},
    {0x48,0x9c,0x5a,0xa8,0x4a,0xe4,0x58,0x00},
    {0x12,0x7c,0x18,0xfe,0x20,0xdc,0x1c,0x00},
    {0x92,0xfe,0x2a,0xbe,0x2e,0xda,0xea,0x00},
    {0x10,0xfe,0x54,0x7c,0x54,0xfe,0x10,0x00},
    {0x88,0x3e,0x2c,0xfe,0x40,0x6a,0xbe,0x00},
    {0x48,0xfe,0xb2,0xe8,0x4e,0x68,0xce,0x00},
    {0xfe,0xaa,0xac,0xfa,0x6a,0xac,0x68,0x00},
    {0x54,0x7e,0xd4,0xfe,0x5c,0x54,0x5c,0x00},
    {0x40,0x7e,0x82,0x22,0x12,0x02,0x06,0x00},
    {0x7c,0x44,0x7c,0x50,0x48,0x44,0x82,0x00},
    {0x50,0xde,0x62,0xd2,0xca,0x42,0x46,0x00},
    {0x50,0x5e,0xe2,0xd2,0x4a,0x62,0x86,0x00},
    {0xfe,0x54,0x7e,0x7e,0x66,0x52,0xf6,0x00},
    {0xe8,0x4e,0xf2,0xea,0xa6,0xe2,0xe6,0x00},
    {0xfe,0x2a,0xba,0x2c,0xfc,0x6a,0xb2,0x00},
    {0x5e,0xb2,0xfe,0x48,0xee,0x76,0xca,0x00},
    {0x28,0xfe,0x20,0xfe,0x40,0xbc,0x3c,0x00},
    {0x10,0xfe,0xb2,0x2e,0xfa,0x24,0xaa,0x00},
    {0xee,0x22,0xee,0x88,0x66,0xaa,0x66,0x00},
    {0x28,0xfe,0x20,0x7e,0xb8,0x4a,0xba,0x00},
    {0x20,0x10,0xfe,0x10,0x7c,0x10,0xfe,0x00},
    {0xf0,0x5e,0x72,0x7a,0x54,0xfa,0x10,0x00},
    {0x10,0xfe,0x82,0x08,0xfe,0x28,0x18,0x00},
    {0x0c,0x70,0xfe,0x10,0xfe,0x10,0x30,0x00},
    {0x50,0x7c,0x90,0xfe,0x10,0x38,0xd6,0x00},
    {0xf8,0x5c,0x68,0xbe,0x68,0x5c,0xaa,0x00},
    {0xa8,0x5e,0xb2,0x64,0xbe,0x34,0xcc,0x00},
    {0x18,0xdc,0x68,0xfe,0x48,0xdc,0x2a,0x00},
    {0xc4,0x58,0xfe,0x5c,0xdc,0xc8,0x7e,0x00},
    {0xe2,0xac,0xfe,0xae,0xee,0xa4,0xbe,0x00},
    {0x58,0xee,0x4a,0xec,0x5a,0xc8,0xbe,0x00},
    {0xbe,0x14,0xbe,0x36,0xa2,0xbe,0xbe,0x00},
    {0x24,0xfe,0x10,0x7c,0x7c,0x44,0x7c,0x00},
    {0x5c,0x7e,0xea,0xdc,0x48,0x7e,0x6a,0x00},
    {0xfe,0x54,0xfe,0xba,0x28,0x10,0xee,0x00},
    {0x3e,0xe2,0xa2,0xbe,0xd4,0x14,0x66,0x00},
    {0x10,0x7c,0xfe,0x24,0xfe,0x44,0x94,0x00},
    {0x7e,0xd4,0x7e,0x62,0xdc,0x48,0xf6,0x00},
    {0x52,0xfe,0x52,0xfa,0xee,0x52,0x7a,0x00},
    {0x7e,0x94,0x7e,0xa2,0x5c,0xc8,0x76,0x00},
    {0x38,0xfe,0xb6,0x7c,0x10,0xfe,0xaa,0x00},
    {0xfe,0x92,0x92,0x92,0xaa,0xc6,0xfe,0x00},
    {0x2e,0xa2,0xaa,0xaa,0xb4,0xe4,0x2a,0x00},
    {0x7e,0x52,0x7a,0x52,0x7e,0x6a,0xba,0x00},
    {0x10,0xfe,0xba,0x00,0xfe,0x54,0xb2,0x00},
    {0x26,0xf4,0x5e,0x74,0x24,0xb4,0x6a,0x00},
    {0x52,0x52,0xf6,0xf6,0x52,0x52,0x92,0x00},
    {0x28,0x6e,0xf4,0x6a,0x64,0x62,0x4c,0x00},
    {0x74,0xfe,0x74,0xaa,0x00,0xca,0xba,0x00},
    {0x48,0xd4,0x6e,0x40,0xdc,0x54,0xdc,0x00},
    {0xaa,0x2a,0xfe,0x7e,0xaa,0xaa,0xca,0x00},
    {0x38,0xfe,0x38,0xd6,0x78,0x2c,0xc4,0x00},
    {0xc8,0x48,0xea,0x6c,0xc8,0xd4,0x62,0x00},
    {0x4c,0x94,0x48,0xb6,0x48,0xe0,0x4c,0x00},
    {0x48,0xbc,0x4e,0xbc,0x5a,0xde,0x6a,0x00},
    {0xfe,0x5a,0x36,0xda,0x20,0x7c,0x7c,0x00},
    {0x10,0x7c,0x44,0x7c,0xfe,0x10,0xee,0x00},
    {0x10,0x7c,0x54,0x44,0xfe,0x54,0x94,0x00},
    {0x28,0xfe,0x10,0x7c,0x7c,0x2a,0xce,0x00},
    {0x10,0x7c,0xfe,0x50,0x9a,0x54,0x92,0x00},
    {0x26,0xfc,0x56,0xfa,0xfe,0x68,0xb6,0x00},
    {0x54,0x76,0xec,0x76,0xfe,0x44,0x7c,0x00},
    {0xd6,0xbc,0xee,0x7c,0xd4,0xfc,0xd2,0x00},
    {0xdc,0x54,0xfe,0xdc,0x54,0xfe,0x44,0x00},
    {0xbe,0x2a,0x3e,0xea,0x76,0x5e,0xbe,0x00},
    {0x24,0xfe,0x28,0x7c,0x6c,0x44,0x7c,0x00},
    {0xea,0x4a,0xfe,0xfe,0xaa,0xea,0xea,0x00},
    {0x28,0x7c,0xa8,0x3c,0xfe,0x38,0xd6,0x00},
    {0xe8,0x5e,0xfa,0xfe,0xbe,0xec,0xf6,0x00},
    {0x28,0x48,0xfe,0x48,0x48,0x48,0x48,0x00},
    {0x28,0x44,0xde,0x44,0x4e,0x44,0x5e,0x00},
    {0x10,0xfe,0x28,0x74,0x28,0x2a,0xce,0x00},
    {0x10,0x10,0xfe,0x10,0x10,0x10,0x10,0x00},
    {0x54,0xbe,0x44,0xd6,0x54,0x54,0x6e,0x00},
    {0x0a,0xfe,0x08,0x48,0xea,0x44,0x9a,0x00},
    {0x38,0xfe,0x2a,0x58,0xfe,0x38,0xd6,0x00},
    {0x88,0x08,0xbe,0x08,0x48,0x88,0x88,0x00},
    {0x84,0x16,0x94,0x3e,0xa2,0x94,0xa2,0x00},
    {0xd6,0x74,0x7e,0x04,0xf4,0x54,0x7a,0x00},
    {0x5a,0xae,0x54,0xb6,0x54,0xdc,0x56,0x00},
    {0x38,0xfe,0x54,0x7c,0x54,0x38,0xfe,0x00},
    {0x48,0xbe,0xd4,0x7a,0xd4,0x54,0xe6,0x00},
    {0x2e,0x32,0x2a,0xfa,0x24,0xb4,0x6a,0x00},
    {0x7c,0x7c,0x54,0x5c,0x6c,0x54,0xa6,0x00},
    {0x10,0xfe,0x82,0x5e,0xc8,0x5e,0x5e,0x00},
    {0xae,0x32,0xaa,0x7a,0xa4,0xf4,0xaa,0x00},
    {0x5e,0xf2,0x32,0x5e,0xec,0x4c,0x56,0x00},
    {0x48,0xbe,0x62,0x9e,0x74,0xd6,0x56,0x00},
    {0x10,0x7c,0x16,0xfc,0x56,0x7a,0x96,0x00},
    {0x28,0xfc,0x5c,0x7c,0xae,0x10,0xfe,0x00},
    {0x28,0xfc,0x5c,0x7c,0xae,0x00,0xaa,0x00},
    {0x10,0x54,0x54,0x7c,0x92,0x92,0xfe,0x00},
    {0x56,0xb8,0x56,0xfa,0x7a,0x52,0x56,0x00},
    {0x8a,0x3e,0x08,0xea,0x6a,0x48,0xbe,0x00},
    {0x32,0x7e,0xd4,0x66,0x5c,0x68,0x56,0x00},
    {0x52,0x7e,0x54,0xe6,0xdc,0xe8,0x16,0x00},
    {0x10,0x7c,0x38,0xfe,0x44,0xba,0x38,0x00},
    {0xfe,0xb4,0xfe,0xa2,0xf4,0xbe,0xe4,0x00},
    {0x52,0xfe,0xb4,0xa6,0x5c,0xe8,0x16,0x00},
    {0xfe,0x54,0xfe,0xb2,0x5c,0x2e,0xc4,0x00},
    {0xea,0xde,0xea,0xd2,0xec,0x34,0xaa,0x00},
    {0x94,0x1e,0x34,0x1e,0x54,0x94,0x9e,0x00},
    {0x42,0x9c,0x5e,0xd4,0x5e,0x6e,0x4e,0x00},
    {0x40,0x7e,0xba,0x2a,0x3a,0x2a,0x3a,0x00},
    {0x42,0xdc,0x5e,0xd4,0xde,0x6e,0x4e,0x00},
    {0xf0,0x5e,0x7e,0xb6,0x7e,0x56,0x9e,0x00},
    {0x88,0x3e,0x94,0x1c,0x84,0xbe,0x88,0x00},
    {0x94,0x1e,0xb4,0x1e,0x90,0xfe,0x10,0x00},
    {0xf6,0x76,0xde,0x4a,0xde,0xca,0xde,0x00},
    {0x06,0x78,0x7e,0x48,0x5c,0x5c,0x9c,0x00},
    {0x48,0xbe,0x48,0xaa,0x7e,0xc8,0x4e,0x00},
    {0xaa,0x2a,0x54,0xea,0x6a,0x40,0xbe,0x00},
    {0x94,0x7e,0x36,0xe2,0x7e,0x4c,0xbe,0x00},
    {0xe4,0x5e,0xea,0xee,0xa2,0xfe,0xe4,0x00},
    {0x5e,0x74,0x7e,0x7a,0x7e,0x50,0x9a,0x00},
    {0x40,0x7c,0x54,0xd4,0x26,0x50,0x8e,0x00},
    {0x5e,0xea,0x2a,0x4a,0xea,0x6a,0x56,0x00},
    {0xf2,0x0c,0x78,0x5e,0x7a,0x4a,0x92,0x00},
    {0x7c,0x44,0x7c,0x38,0xfe,0x34,0xdc,0x00},
    {0x3e,0xea,0xbe,0xec,0xbe,0xda,0x2e,0x00},
    {0x8a,0x1c,0x88,0x3e,0x90,0xae,0x8e,0x00},
    {0x08,0x7e,0x54,0x7e,0x5c,0x40,0xaa,0x00},
    {0x4a,0x9c,0x48,0xbe,0x50,0xee,0x4e,0x00},
    {0xfe,0xaa,0xfe,0x38,0xfe,0x34,0xdc,0x00},
    {0x10,0x7c,0x16,0xfc,0x10,0xfe,0x7c,0x00},
    {0x28,0xfe,0x54,0x7e,0x38,0xfe,0x5c,0x00},
    {0x28,0xfe,0x4c,0xde,0x08,0xde,0xee,0x00},
    {0x4a,0xdc,0x08,0xbe,0x10,0xee,0xce,0x00},
    {0x74,0x5e,0x76,0x56,0x76,0x5a,0xea,0x00},
    {0x2e,0x52,0xfa,0x2a,0xf4,0x24,0xaa,0x00},
    {0x10,0x10,0xfe,0x24,0x68,0x18,0xe6,0x00},
    {0x08,0x7e,0x5c,0x44,0x7e,0x4a,0x98,0x00},
    {0x48,0x94,0x7e,0xc8,0x7e,0x48,0x6a,0x00},
    {0x2e,0xfa,0x5a,0xee,0x00,0xca,0xba,0x00},
    {0x44,0xbc,0xee,0x7e,0xee,0x7a,0xea,0x00},
    {0xc8,0xd4,0xbe,0xc8,0xfe,0x88,0xaa,0x00},
    {0x30,0x5e,0xf4,0x5c,0x5e,0x6a,0x56,0x00},
    {0x2a,0x5c,0xf6,0x5c,0x5c,0x5c,0x62,0x00},
    {0xf6,0xa4,0xfe,0xac,0xfe,0xaa,0xb6,0x00},
    {0xfe,0x8c,0xb0,0xbe,0xa8,0xc8,0xfe,0x00},
    {0x14,0xe4,0x24,0xfe,0x24,0x24,0x44,0x00},
    {0xfe,0x12,0x22,0xc6,0x7c,0x44,0x7c,0x00},
    {0x16,0xe4,0xbe,0xb2,0xfe,0x12,0x16,0x00},
    {0x10,0xfe,0x24,0xfe,0xaa,0xde,0x9a,0x00},
    {0x1c,0xf4,0xbe,0xa2,0xfe,0x22,0x3e,0x00},
    {0x54,0xfe,0xba,0x40,0x7e,0x44,0x7c,0x00},
    {0x5e,0xca,0x5e,0xc4,0x7e,0x10,0xee,0x00},
    {0x10,0x7c,0x28,0xfe,0x7c,0x28,0xf6,0x00},
    {0x2c,0x2c,0xfe,0x52,0x7e,0x32,0xde,0x00},
    {0x10,0xfe,0xb6,0x7c,0x44,0x7c,0x44,0x00},
    {0x46,0x78,0xea,0x44,0xfe,0x54,0x4c,0x00},
    {0x10,0x10,0x54,0x52,0x92,0x10,0x30,0x00},
    {0x10,0x54,0x52,0x90,0x34,0x18,0xe0,0x00},
    {0x92,0x54,0xfe,0x82,0xba,0xaa,0xba,0x00},
    {0x08,0x7e,0x48,0x5c,0x48,0x48,0xbe,0x00},
    {0x08,0x7e,0x48,0x7e,0x48,0x5c,0xaa,0x00},
    {0x08,0x7e,0x6c,0x56,0x7a,0x7c,0xaa,0x00},
    {0x22,0xfc,0x52,0xfc,0x70,0xfa,0x24,0x00},
    {0x38,0x08,0xd2,0x7c,0x54,0xba,0x10,0x00},
    {0x48,0xdc,0x5a,0x68,0xca,0x44,0xd8,0x00},
    {0x5e,0xea,0x52,0x66,0xde,0x52,0xde,0x00},
    {0x54,0xfe,0xaa,0x38,0x7c,0xfe,0x30,0x00},
    {0x44,0xde,0x46,0x5c,0xc6,0x54,0xee,0x00},
    {0x7c,0x44,0x7c,0x28,0xfe,0x28,0x48,0x00},
    {0x7c,0x44,0xfe,0x82,0xfe,0x82,0xfe,0x00},
    {0x1e,0xea,0xb2,0xe6,0xbe,0xf2,0x1e,0x00},
    {0x7c,0x44,0x7c,0xaa,0xee,0xaa,0xee,0x00},
    {0x54,0xd4,0x62,0xc8,0xc8,0x54,0x7a,0x00},
    {0x56,0xe4,0x5e,0xf2,0xde,0x52,0x56,0x00},
    {0x48,0xfe,0x54,0xfe,0xdc,0x7e,0x48,0x00},
    {0x54,0xde,0x74,0xd4,0xde,0x40,0x6a,0x00},
    {0xbe,0x0a,0x92,0x26,0x9e,0x92,0x9e,0x00},
    {0xaa,0x08,0xbe,0x22,0xbe,0xa2,0xa6,0x00},
    {0x84,0x16,0x94,0x3e,0xaa,0x84,0x98,0x00},
    {0xae,0x7a,0xae,0x7a,0xee,0xaa,0xae,0x00},
    {0x48,0x5c,0xfe,0xd4,0x7e,0x54,0xa6,0x00},
    {0x28,0x3e,0x7c,0xa8,0x3e,0x00,0xaa,0x00},
    {0xfe,0xaa,0xf2,0xae,0xee,0x00,0xaa,0x00},
    {0x08,0x7e,0xde,0x44,0xd6,0x54,0xbe,0x00},
    {0x10,0x54,0x9e,0x24,0xfc,0x24,0x3c,0x00},
    {0xf6,0x44,0x5e,0x92,0x7e,0x72,0x16,0x00},
    {0xea,0x4e,0x5c,0x8c,0x6e,0x60,0x16,0x00},
    {0x4a,0xfe,0x24,0x4e,0xe4,0x5e,0x44,0x00},
    {0xd0,0x5e,0xe8,0x5c,0xda,0xea,0x58,0x00},
    {0x10,0x7c,0x28,0xfe,0x44,0xfe,0x10,0x00},
    {0x48,0x6e,0xb4,0x10,0xfe,0x10,0xee,0x00},
    {0xa4,0x5e,0xf4,0x5e,0xf4,0xd4,0x6e,0x00},
    {0x5e,0x8a,0x52,0xa6,0x5e,0xf2,0x5e,0x00},
    {0x52,0x34,0x7e,0x42,0x7e,0x42,0x46,0x00},
    {0x28,0xfe,0x44,0x7c,0xfe,0x82,0xfe,0x00},
    {0x28,0xfe,0x6a,0xc4,0x7e,0xd4,0x4c,0x00},
    {0x28,0xfe,0x7c,0xa8,0x3e,0x00,0xaa,0x00},
    {0x4e,0xb0,0x56,0xfa,0x7a,0x52,0x7a,0x00},
    {0x54,0xfe,0xaa,0x38,0xfe,0x68,0xb6,0x00},
    {0x54,0xd4,0x22,0xc8,0x08,0xd4,0xfa,0x00},
    {0xbe,0xc4,0x04,0xd6,0x14,0xd4,0xfe,0x00},
    {0x5e,0xea,0x12,0xc6,0x1e,0xd2,0xde,0x00},
    {0x94,0xfe,0x08,0xdc,0x08,0xfe,0xc8,0x00},
    {0x38,0xc8,0x3c,0x3c,0xda,0x2c,0xda,0x00},
    {0x54,0xfe,0xaa,0x7c,0x44,0x7c,0xc6,0x00},
    {0x7e,0xd4,0x4c,0xfe,0x6c,0x44,0x7c,0x00},
    {0x5e,0xa4,0xe4,0x56,0xf4,0x74,0xde,0x00},
    {0x44,0xb8,0xfe,0x5c,0xdc,0x48,0xfe,0x00},
    {0x48,0xbe,0xd4,0x7e,0xdc,0x48,0xfe,0x00},
    {0xc8,0xfe,0x94,0xfe,0xdc,0xbe,0x88,0x00},
    {0xb6,0xe4,0xfe,0x52,0xfe,0xf2,0x56,0x00},
    {0x10,0x10,0x1c,0x10,0x10,0x10,0xfe,0x00},
    {0x10,0xfe,0x10,0x30,0x10,0x28,0xc6,0x00},
    {0x7c,0x08,0xd2,0x54,0x92,0x30,0xfe,0x00},
    {0x38,0xfe,0x54,0xfe,0x54,0x38,0xd6,0x00},
    {0xfe,0x82,0x38,0x28,0x28,0x4a,0x8e,0x00},
    {0x72,0xfa,0xaa,0xfa,0xaa,0x72,0xaa,0x00},
    {0x44,0x7e,0xe4,0x7c,0x6e,0xf4,0x2a,0x00},
    {0x5c,0x54,0xfe,0x50,0x5e,0xea,0x16,0x00},
    {0x48,0x7e,0xd4,0x76,0x7e,0xd4,0x1a,0x00},
    {0x88,0xbe,0xd4,0xf6,0xfe,0x54,0x9a,0x00},
    {0x54,0xfe,0xaa,0x38,0x7c,0x54,0x10,0x00},
    {0x48,0xdc,0xc8,0x7e,0x54,0x5c,0x54,0x00},
    {0x7e,0xdc,0x5c,0x7e,0xf6,0x48,0xf6,0x00},
    {0x18,0x68,0x10,0xee,0x7c,0x38,0xd6,0x00},
    {0x48,0xfe,0x48,0xd8,0xc8,0x54,0x62,0x00},
    {0x9c,0x24,0x9e,0x3e,0x8a,0xbe,0x98,0x00},
    {0x4a,0x48,0xfe,0x48,0xc8,0x54,0x62,0x00},
    {0x7c,0x54,0x7c,0xfe,0xba,0x28,0xfe,0x00},
    {0xc8,0x7e,0xd4,0x76,0xfe,0xd4,0x5a,0x00},
    {0x28,0xfe,0x32,0xd4,0x52,0xfe,0xaa,0x00},
    {0x88,0xfe,0x14,0xb6,0x3e,0xd4,0xda,0x00},
    {0xc8,0x7e,0xd4,0xf6,0xfe,0xd4,0xda,0x00},
    {0x48,0xbe,0xee,0x44,0xd6,0x54,0xee,0x00},
    {0x3e,0xfe,0xa4,0xac,0xfe,0x36,0x5a,0x00},
    {0x48,0x7e,0xc8,0x6c,0x6c,0xe0,0x3e,0x00},
    {0x48,0xae,0x54,0xe4,0xfe,0x96,0xe4,0x00},
    {0x4a,0xc8,0x7e,0x44,0xfc,0x54,0xfa,0x00},
    {0x48,0xfe,0x48,0xec,0xec,0x60,0x7e,0x00},
    {0xe4,0x5e,0x64,0xb6,0x76,0x50,0x9e,0x00},
    {0x7e,0x6a,0xde,0xe2,0x5a,0x5e,0xba,0x00},
    {0x56,0xbc,0x5e,0xbc,0x46,0xdc,0x5a,0x00},
    {0xf6,0x7c,0x6e,0x7c,0x66,0xf4,0x3a,0x00},
    {0x38,0xc8,0x7c,0x54,0x7c,0x42,0x3e,0x00},
    {0x68,0xbe,0x6a,0x7e,0x68,0x6a,0xbe,0x00},
    {0x10,0x28,0xd6,0x30,0x34,0x28,0x76,0x00},
    {0x48,0xbe,0x5a,0xfe,0xe8,0x8a,0xfe,0x00},
    {0x7e,0x5c,0x7e,0xa8,0xfe,0x28,0x18,0x00},
    {0x7e,0x42,0x7e,0x48,0x7c,0x54,0xa6,0x00},
    {0x28,0x7e,0xea,0x7e,0x6a,0x7e,0x48,0x00},
    {0x2c,0x5e,0xc0,0x4c,0x40,0x5e,0x5e,0x00},
    {0x3c,0x44,0xdc,0x7e,0x76,0x48,0x76,0x00},
    {0x7e,0x5c,0x7e,0x68,0xb6,0x3c,0x3c,0x00},
    {0x5e,0x50,0xf6,0xb0,0xde,0x74,0x9a,0x00},
    {0x10,0xfe,0x8a,0xde,0x5a,0xc4,0x5a,0x00},
    {0x10,0xfe,0xba,0x54,0xfe,0x7c,0xba,0x00},
    {0x20,0x10,0x20,0x64,0x62,0xa4,0x3c,0x00},
    {0x48,0xfe,0xdc,0x5c,0x7e,0x40,0x62,0x00},
    {0x7e,0xe0,0x6c,0x60,0xfe,0x74,0xda,0x00},
    {0x22,0xfc,0x58,0x2e,0xfa,0x72,0xaa,0x00},
    {0xfe,0x6c,0x28,0xfe,0x7c,0x44,0x7c,0x00},
    {0x10,0x7c,0x38,0x54,0xfe,0x6c,0xb6,0x00},
    {0x48,0xfe,0x48,0xd4,0xea,0x5c,0x6a,0x00},
    {0x9c,0x04,0x9c,0x3e,0xb6,0x88,0xb6,0x00},
    {0xbe,0x22,0x94,0x26,0xbe,0x9c,0xaa,0x00},
    {0x10,0xfe,0x92,0xfe,0x92,0xfe,0x10,0x00},
    {0x08,0x7e,0xc8,0x54,0xea,0x44,0x98,0x00},
    {0x10,0xfe,0x38,0x38,0xfe,0x00,0xc6,0x00},
    {0x48,0xfe,0x2a,0x7e,0xea,0x7e,0x48,0x00},
    {0x10,0x7c,0x38,0xfe,0x54,0x38,0xd6,0x00},
    {0x48,0xbe,0x6a,0xbe,0x6a,0xfe,0x48,0x00},
    {0x7e,0x50,0x7c,0x44,0x7c,0x50,0x7e,0x00},
    {0x28,0xfe,0x28,0x20,0x64,0x6a,0xba,0x00},
    {0x28,0xfe,0x5c,0x28,0xfe,0x7a,0xa2,0x00},
    {0x2e,0xfa,0x5e,0x2a,0xfe,0x74,0xaa,0x00},
    {0x48,0xd4,0x2a,0xc4,0x0a,0xc4,0xd8,0x00},
    {0x10,0x3c,0x24,0x3e,0xe4,0x1c,0x6c,0x00},
    {0x10,0x7c,0x28,0xfe,0x10,0x7c,0x10,0x00},
    {0x94,0x1e,0x34,0xde,0x54,0x5e,0xbe,0x00},
    {0x48,0xa8,0xfe,0x48,0xe8,0x68,0xc8,0x00},
    {0x38,0xfe,0xb6,0x7c,0x7e,0x68,0xb6,0x00},
    {0x10,0x10,0x10,0x28,0x28,0x44,0x82,0x00},
    {0x20,0x5c,0xc0,0x40,0x40,0x7e,0x40,0x00},
    {0xfe,0x12,0x12,0x72,0x2a,0x42,0x86,0x00},
    {0x08,0x7e,0x5c,0x64,0x76,0x48,0xbe,0x00},
    {0x0c,0x70,0x10,0xfe,0x10,0x10,0x7c,0x00},
    {0x7c,0x04,0xee,0x4a,0xfe,0x28,0x18,0x00},
    {0x28,0xfe,0x28,0x38,0xfe,0x54,0x7e,0x00},
    {0x7c,0x44,0x78,0x54,0x44,0xb2,0x08,0x00},
    {0xee,0xca,0xe4,0x0a,0x7c,0x7c,0x44,0x00},
    {0xbc,0xd4,0x1c,0xb4,0x14,0xd4,0xe6,0x00},
    {0xbc,0x14,0x3c,0xd4,0x52,0x40,0xbe,0x00},
    {0xc8,0xfe,0x9c,0xdc,0xdc,0xbe,0x88,0x00},
    {0xbe,0xea,0xea,0x5a,0xee,0xea,0x56,0x00},
    {0x48,0x6e,0xb4,0x7e,0x02,0x72,0x76,0x00},
    {0xb8,0xde,0x1a,0xda,0x1c,0xfa,0xc8,0x00},
    {0x5e,0x88,0x5e,0x92,0x1e,0x40,0x92,0x00},
    {0xe8,0x4e,0xf8,0xee,0xa8,0xee,0xe8,0x00},
    {0xfe,0xd2,0x86,0xaa,0x9a,0xa6,0xfe,0x00},
    {0x7e,0x40,0x7a,0x6e,0x72,0x5a,0xb6,0x00},
    {0xbe,0x5e,0x12,0xde,0x4c,0x5e,0xbe,0x00},
    {0x10,0xde,0xea,0xc8,0xc8,0x14,0x22,0x00},
    {0x0c,0x70,0xfe,0x54,0xfe,0x10,0xfe,0x00},
    {0x48,0xfe,0xea,0xaa,0xea,0xea,0x08,0x00},
    {0x54,0xde,0x74,0x5e,0xd4,0x54,0xde,0x00},
    {0x10,0x12,0xf4,0x38,0x54,0x92,0x30,0x00},
    {0x50,0x5e,0xea,0xc8,0x48,0x54,0xa2,0x00},
    {0xee,0xa4,0xfe,0xac,0xfe,0xa4,0xee,0x00},
    {0xa8,0x7c,0xd4,0x66,0xc8,0xfe,0x48,0x00},
    {0xfe,0x5a,0x36,0xfe,0x54,0xfe,0x10,0x00},
    {0x10,0xfe,0x38,0xee,0x38,0xe8,0x36,0x00},
    {0x94,0x3e,0x08,0xda,0x6c,0x5a,0xbe,0x00},
    {0xe8,0x5c,0xec,0xf6,0xa8,0xfe,0xe8,0x00},
    {0x54,0xbe,0xf4,0x5e,0xf4,0x74,0xde,0x00},
    {0x5c,0xa8,0xfe,0x54,0xfe,0x48,0xfe,0x00},
    {0xf4,0xae,0xc4,0xb8,0xb6,0xd6,0xae,0x00},
    {0x2a,0xfe,0x40,0xfe,0x50,0xfe,0x2a,0x00},
    {0x74,0x6e,0xe4,0xb8,0x76,0x76,0x5e,0x00},
    {0x54,0x7c,0xfe,0xba,0x7c,0x54,0xb2,0x00},
    {0x54,0x7c,0xfe,0x28,0xfe,0xaa,0xba,0x00},
    {0xac,0x76,0xaa,0x4a,0xfa,0x54,0xea,0x00},
    {0x5e,0xf0,0x5a,0xf4,0xda,0x50,0x5e,0x00},
    {0x48,0xee,0x56,0xe8,0x4e,0xd6,0xbe,0x00},
    {0x4a,0x7e,0xbc,0x4e,0x7c,0xbc,0x4e,0x00},
    {0x5e,0xfe,0x54,0x7e,0xd4,0x5a,0xee,0x00},
    {0x22,0xf4,0x22,0x74,0x60,0xa2,0x2c,0x00},
    {0x5c,0xd4,0x7e,0xe2,0xfe,0x62,0x7e,0x00},
    {0x28,0xfe,0x28,0xfe,0xb2,0x3c,0x3c,0x00},
    {0x2e,0xf4,0xae,0xfa,0xde,0xa0,0xda,0x00},
    {0x10,0x54,0x9e,0x28,0xfe,0x28,0x3e,0x00},
    {0x5e,0xfe,0x34,0x5e,0xf4,0x5a,0x6e,0x00},
    {0xba,0x14,0xa2,0x1c,0x54,0x88,0xbe,0x00},
    {0x76,0xd2,0x76,0x52,0xc8,0x5c,0xdc,0x00},
    {0x08,0xfe,0x08,0x28,0x18,0x08,0x18,0x00},
    {0x54,0x54,0xfe,0x54,0x5c,0x40,0x7e,0x00},
    {0xae,0x74,0xfe,0x7a,0xae,0xf0,0xaa,0x00},
    {0x24,0xf6,0x0a,0xf2,0xf4,0xf4,0xfa,0x00},
    {0x7c,0x44,0xfe,0x10,0x5c,0x50,0xbe,0x00},
    {0x88,0x3e,0x0c,0x1c,0xbe,0x94,0xba,0x00},
    {0x62,0x7a,0xaa,0x7a,0x22,0xfa,0xaa,0x00},
    {0x28,0x7c,0xec,0x76,0xbc,0x14,0x6c,0x00},
    {0x2c,0x2e,0xf4,0x54,0x6e,0x24,0xde,0x00},
    {0x5e,0x84,0x44,0xd6,0x54,0x54,0x7e,0x00},
    {0x58,0xde,0xe8,0x48,0x5c,0x48,0x7e,0x00},
    {0x04,0x7e,0x44,0x74,0x56,0x54,0xaa,0x00},
    {0xf4,0x26,0x2a,0xba,0xaa,0xb4,0xca,0x00},
    {0x26,0xfa,0x74,0xaa,0xfe,0x5c,0xfe,0x00},
    {0x7c,0x44,0x7e,0x50,0xbc,0x10,0xfe,0x00},
    {0x04,0xee,0xa4,0xfe,0xaa,0xee,0x0a,0x00},
    {0x48,0xfe,0x4c,0xdc,0xfe,0x54,0x7a,0x00},
    {0x7e,0xd4,0x7e,0xf6,0xf6,0x62,0x7e,0x00},
    {0xfe,0x10,0x10,0x5c,0x50,0x50,0xfe,0x00},
    {0x88,0x1c,0x88,0x3e,0x94,0x9c,0x94,0x00},
    {0xd8,0xde,0xe8,0x48,0xdc,0x48,0x7e,0x00},
    {0x50,0x7e,0x90,0x10,0x7c,0x10,0xfe,0x00},
    {0x04,0x7e,0x64,0xaa,0x7c,0x54,0xfe,0x00},
    {0xa8,0x5c,0xc8,0x7e,0xd4,0xdc,0x54,0x00},
    {0xfe,0x6a,0xfe,0x10,0x7c,0x10,0xfe,0x00},
    {0x10,0xfe,0x10,0x7c,0x54,0x7c,0x80,0x00},
    {0x62,0x7a,0xaa,0x72,0xfe,0x68,0xb6,0x00},
    {0xfe,0x28,0xfe,0xaa,0xce,0x82,0xfe,0x00},
    {0x84,0xfe,0x24,0xbc,0x2e,0xf4,0xea,0x00},
    {0x44,0xd8,0x5e,0xd4,0x64,0xfe,0x38,0x00},
    {0x48,0xdc,0x08,0xbe,0x14,0xdc,0xd4,0x00},
    {0x92,0x3c,0x16,0xd6,0x7a,0x52,0xbe,0x00},
    {0xee,0x4a,0xee,0xf4,0xae,0xe4,0xfe,0x00},
    {0x10,0x7c,0x10,0xfe,0x44,0x7c,0x44,0x00},
    {0x26,0x7a,0x24,0xfe,0x56,0x7e,0x54,0x00},
    {0x10,0xfe,0x28,0x10,0xee,0x38,0x48,0x00},
    {0xd4,0x7e,0xe2,0x7e,0xd4,0xd4,0x66,0x00},
    {0xec,0xb4,0xfe,0xbe,0xfa,0xb8,0xae,0x00},
    {0x28,0x3e,0x68,0xbe,0x28,0x10,0xee,0x00},
    {0x08,0x7e,0x54,0x7e,0x48,0x7e,0xaa,0x00},
    {0x54,0xfe,0xd4,0x7e,0x5c,0x54,0x5c,0x00},
    {0x04,0x7e,0x54,0x5c,0x56,0x7c,0x92,0x00},
    {0x0c,0x70,0x40,0x7e,0x58,0x4c,0x88,0x00},
    {0x28,0x7c,0x28,0xfe,0x7c,0x44,0x7c,0x00},
    {0x44,0xd8,0x50,0xde,0xd4,0x54,0x64,0x00},
    {0xfe,0x20,0x20,0x7c,0xa4,0x24,0x3c,0x00},
    {0xc8,0x5c,0xc8,0x7e,0xdc,0xdc,0x62,0x00},
    {0x48,0x6e,0xb4,0x2e,0xfc,0x76,0xa6,0x00},
    {0x48,0x9c,0x48,0xbe,0x5c,0xdc,0x62,0x00},
    {0xd6,0x10,0xd6,0x38,0xc6,0x7c,0x44,0x00},
    {0x10,0x7c,0x10,0xfe,0x44,0x7c,0xc6,0x00},
    {0x10,0x7c,0x10,0xfe,0x28,0xaa,0x58,0x00},
    {0xe8,0xbe,0xd4,0x76,0xf6,0xd4,0xec,0x00},
    {0xe8,0xbc,0xc8,0x7e,0xdc,0xdc,0xe2,0x00},
    {0xfe,0x48,0x5e,0x92,0x7e,0x60,0x12,0x00},
    {0x5e,0x4a,0xea,0x4a,0x4a,0x6a,0x16,0x00},
    {0x48,0xea,0x7e,0x48,0xea,0x6a,0xfe,0x00},
    {0x48,0xfe,0x54,0x7e,0xd4,0x4c,0xf2,0x00},
    {0x7e,0xd4,0x54,0x7e,0xe2,0x54,0xe2,0x00},
    {0x44,0xd8,0x50,0x5e,0xd4,0x54,0xe4,0x00},
    {0x5c,0xd4,0x26,0xdc,0x14,0xc8,0xf6,0x00},
    {0x10,0xfe,0xaa,0x4c,0xee,0x46,0x6a,0x00},
    {0x48,0x6e,0xb4,0xee,0xea,0x9a,0xe8,0x00},
    {0x94,0xfe,0x22,0xbe,0x14,0xd4,0xe6,0x00},
    {0x38,0xfe,0xb6,0x00,0x7c,0x04,0x7c,0x00},
    {0x4c,0xb4,0x5e,0xba,0x5e,0xf0,0x5e,0x00},
    {0x0c,0x70,0xfe,0x10,0x7c,0x44,0x7c,0x00},
    {0x6a,0xc4,0xbe,0xfe,0x48,0x7e,0xc8,0x00},
    {0x28,0x48,0xea,0x6a,0x6a,0x6a,0x7e,0x00},
    {0x50,0x7c,0x90,0xfe,0x28,0x2a,0xce,0x00},
    {0x0c,0x70,0x10,0xfe,0x10,0x10,0x10,0x00},
    {0x10,0x10,0x1e,0x10,0x7e,0x42,0x7e,0x00},
    {0x10,0xfe,0xba,0x00,0x38,0x28,0xfe,0x00},
    {0x10,0xfe,0x38,0x38,0xfe,0x28,0x18,0x00},
    {0x10,0x54,0x92,0x30,0xfe,0x10,0xee,0x00},
    {0x42,0x52,0x52,0x52,0x52,0x42,0x82,0x00},
    {0xaa,0x08,0xfe,0xf4,0x26,0xf4,0x2a,0x00},
    {0xfe,0x7c,0x40,0x7e,0x6a,0x5e,0xaa,0x00},
    {0x76,0xd2,0x64,0x76,0xdc,0x40,0xe2,0x00},
    {0x48,0xd4,0x7e,0xc8,0xdc,0x48,0x7e,0x00},
    {0x50,0xde,0x60,0xdc,0xd4,0x7e,0x54,0x00},
    {0x10,0x7c,0x44,0x7c,0xda,0x54,0xb2,0x00},
    {0x8a,0x3e,0x88,0x3c,0x8a,0x84,0x9a,0x00},
    {0x98,0x1e,0xa8,0x3e,0x94,0x94,0xa6,0x00},
    {0x88,0x3c,0x94,0x26,0xfe,0x38,0xd6,0x00},
    {0x94,0x3e,0x94,0x2a,0x9c,0x94,0x9c,0x00},
    {0x24,0xfe,0x54,0x74,0x54,0x00,0xaa,0x00},
    {0x7e,0x5c,0xf0,0xde,0x5a,0x56,0xaa,0x00},
    {0x48,0xee,0x50,0x6e,0x66,0xac,0xb6,0x00},
    {0x10,0xfe,0xaa,0x4c,0x38,0xfe,0x48,0x00},
    {0x48,0x6e,0xb4,0xfe,0x54,0x74,0x54,0x00},
    {0x48,0x9c,0x54,0x9c,0x7a,0xdc,0x6a,0x00},
    {0x56,0xbc,0x56,0xbc,0x56,0xdc,0x72,0x00},
    {0x24,0xfe,0x10,0xfe,0x9c,0x08,0xb6,0x00},
    {0xe8,0xbc,0xf4,0xbc,0xfa,0xbc,0xaa,0x00},
    {0x44,0x7e,0x54,0xb4,0x1e,0x24,0xc4,0x00},
    {0x2a,0x7a,0x5a,0x50,0xfe,0x5a,0x9e,0x00},
    {0x28,0xfe,0x54,0x7c,0x5e,0x42,0xaa,0x00},
    {0x48,0xd4,0x3e,0xc8,0x1c,0xc8,0xfe,0x00},
    {0xea,0xbe,0xe8,0xbc,0xea,0x04,0xaa,0x00},
    {0xea,0xbe,0xe8,0x5c,0xea,0xc4,0xea,0x00},
    {0xb6,0x12,0x24,0xf6,0x5c,0x62,0xbe,0x00},
    {0xbe,0x5c,0x1c,0xea,0x50,0x5c,0xbe,0x00},
    {0x4a,0xbe,0xe8,0x5c,0xea,0x64,0xda,0x00},
    {0x58,0xbc,0xe8,0x7e,0xd4,0x54,0xe6,0x00},
    {0xee,0xaa,0xee,0x92,0x92,0xaa,0xc6,0x00},
    {0x6a,0xbe,0x64,0x6e,0x64,0x1e,0xa4,0x00},
    {0x24,0xfe,0x00,0xea,0xaa,0xe2,0xa6,0x00},
    {0x24,0xfe,0x10,0xfe,0x54,0xfe,0x7c,0x00},
    {0xb2,0x1c,0xb8,0x3e,0x9a,0xba,0x92,0x00},
    {0x74,0x5e,0xb4,0x24,0xca,0x00,0xaa,0x00},
    {0x10,0x28,0xfe,0x10,0x7c,0x10,0xfe,0x00},
    {0x5a,0xe4,0x3e,0x5e,0xe4,0x5e,0x44,0x00},
    {0x54,0xbe,0x48,0xbe,0x54,0xfe,0x5c,0x00},
    {0xea,0xbe,0xe4,0xbe,0xea,0xbe,0xae,0x00},
    {0xbe,0x50,0xfe,0x5e,0xfe,0xd4,0x6e,0x00},
    {0x14,0xfe,0xaa,0xbe,0xfc,0x14,0x1c,0x00},
    {0xae,0xfa,0xde,0x7a,0xca,0x10,0xfe,0x00},
    {0x5c,0x54,0x5c,0xd4,0xdc,0xd4,0x3e,0x00},
    {0x54,0xfe,0x54,0x7e,0xdc,0x54,0xdc,0x00},
    {0x28,0x44,0xfe,0x54,0x7c,0x44,0x7c,0x00},
    {0x24,0x7e,0x52,0x7e,0x3c,0x24,0x3c,0x00},
    {0x24,0xfe,0x6c,0xb6,0xfc,0x58,0xbe,0x00},
    {0xbc,0x54,0xbc,0x74,0xbc,0x34,0xde,0x00},
    {0xe8,0x3e,0x54,0x7a,0xf8,0xda,0x2a,0x00},
    {0xe8,0x3e,0x5a,0x7e,0xe8,0xdc,0x2a,0x00},
    {0xea,0x5e,0x4a,0x94,0x6e,0x6c,0x16,0x00},
    {0x5c,0xf4,0x3c,0x54,0xfc,0x54,0x7e,0x00},
    {0xfc,0x54,0xfc,0x54,0xdc,0xd4,0x7e,0x00},
    {0xbc,0x54,0xfc,0x54,0xdc,0xd4,0x7e,0x00},
    {0x10,0x7c,0xfe,0x24,0xfa,0x10,0x92,0x00},
    {0x5c,0x94,0x5c,0xb4,0x5c,0xd4,0x7e,0x00},
    {0x28,0xfe,0x6c,0xbe,0x6c,0x16,0xa4,0x00},
    {0x44,0xd8,0x10,0xde,0x1c,0xd6,0xe4,0x00},
    {0xdc,0xd4,0x9c,0xd4,0xdc,0x94,0xbe,0x00},
    {0xae,0x7e,0x3e,0xd6,0x66,0x4a,0xbe,0x00},
    {0x2c,0x44,0x7c,0x54,0x6c,0x54,0xea,0x00},
    {0x54,0x7e,0xea,0xfe,0x5c,0x54,0x5c,0x00},
    {0x22,0x5a,0xea,0x6a,0x42,0x72,0xb6,0x00},
    {0xfe,0x12,0x5a,0x2a,0x24,0x54,0x8a,0x00},
    {0xaa,0xfe,0x28,0xfe,0x7a,0xe4,0x2a,0x00},
    {0x10,0x28,0xfe,0x38,0x20,0x5c,0x9c,0x00},
    {0x10,0xfe,0x76,0x10,0xfe,0x68,0xb6,0x00},
    {0x48,0x48,0xfe,0x48,0xc8,0x48,0x5c,0x00},
    {0x10,0xfe,0x38,0xfe,0x54,0x92,0x28,0x00},
    {0x10,0xfe,0x54,0x38,0x54,0x28,0xc6,0x00},
    {0x10,0xfe,0x92,0x7c,0x10,0x38,0xd6,0x00},
    {0x7e,0x7e,0x54,0x6a,0x7e,0x54,0x9c,0x00},
    {0xfe,0x88,0xbe,0xaa,0xaa,0x88,0xfe,0x00},
    {0xc8,0xee,0x56,0xea,0x56,0xc8,0xba,0x00},
    {0x2e,0xfa,0x6e,0xba,0x2e,0xc0,0xba,0x00},
    {0x48,0xfe,0x6a,0x7e,0xd4,0x48,0xf6,0x00},
    {0x5c,0xc4,0x7e,0x6a,0xdc,0x5c,0xc8,0x00},
    {0x46,0xf8,0x48,0x7e,0xea,0x7e,0xc8,0x00},
    {0x7c,0xd4,0x48,0x7e,0xdc,0x4a,0xfe,0x00},
    {0x5c,0xd4,0x7e,0x6a,0xfe,0x5c,0xea,0x00},
    {0x7c,0x44,0x7c,0x44,0x7c,0xfe,0x10,0x00},
    {0x28,0xfe,0xfe,0xaa,0xfe,0x44,0x7c,0x00},
    {0x54,0x7c,0x7c,0x10,0xfe,0x38,0xd6,0x00},
    {0x48,0xd4,0x7a,0xd8,0xd0,0x6c,0x4c,0x00},
    {0x54,0xfe,0x54,0xfe,0xfe,0x54,0x5c,0x00},
    {0x94,0x3e,0x94,0x3e,0xbe,0x94,0x9c,0x00},
    {0x5c,0x54,0xfe,0xea,0x7e,0x5c,0xaa,0x00},
    {0x38,0xc8,0x7c,0xfe,0x14,0x7c,0x30,0x00},
    {0x08,0x7e,0xdc,0x7e,0xd4,0x48,0xb6,0x00},
    {0x2e,0xfa,0x2e,0x7a,0x6e,0xaa,0x2e,0x00},
    {0x10,0xfe,0xaa,0x4c,0x30,0xca,0xba,0x00},
    {0x94,0x7e,0xd4,0x7e,0xfe,0xd4,0x5c,0x00},
    {0x54,0xa2,0x54,0xba,0x40,0xf2,0x6e,0x00},
    {0x48,0xbe,0x62,0x9c,0x7e,0xc8,0x6a,0x00},
    {0xea,0x72,0x68,0x7e,0x60,0xfa,0x36,0x00},
    {0x28,0xfe,0x7c,0x44,0x7c,0xfe,0x10,0x00},
    {0x28,0xfe,0x40,0xc8,0x7e,0xc8,0x5c,0x00},
    {0x28,0xfe,0x6c,0xa8,0x4e,0xfe,0x48,0x00},
    {0x28,0xfe,0x44,0xba,0x38,0x5c,0x9c,0x00},
    {0x28,0xfe,0x94,0x2a,0xbe,0x1c,0xaa,0x00},
    {0x48,0xfe,0x48,0xdc,0xfe,0x68,0xb6,0x00},
    {0x10,0x7c,0x10,0xfe,0x1c,0x50,0xbe,0x00},
    {0x94,0x3e,0x08,0xdc,0x48,0x76,0xbe,0x00},
    {0x94,0x3e,0x14,0xfe,0x7e,0x54,0xbe,0x00},
    {0x44,0xaa,0xfc,0x4c,0xe8,0x6e,0xd6,0x00},
    {0x38,0xfe,0xb6,0x2e,0xfa,0x7a,0xae,0x00},
    {0xfe,0xca,0xe4,0xde,0xee,0x24,0xbe,0x00},
    {0x2c,0x74,0xdc,0x5c,0x5a,0x6c,0x5a,0x00},
    {0x54,0x7e,0xea,0x7e,0x5c,0xd4,0x1c,0x00},
    {0x54,0xfe,0xea,0x7e,0x5c,0x54,0x5c,0x00},
    {0xf4,0xbe,0xe4,0xbe,0xf4,0xb4,0xba,0x00},
    {0x28,0xfe,0x28,0x7c,0x76,0x74,0xba,0x00},
    {0xd4,0xfe,0xea,0xfe,0xdc,0x14,0xbc,0x00},
    {0x98,0x1c,0x28,0xfe,0x54,0x5c,0xbe,0x00},
    {0x3e,0x52,0xde,0x44,0x56,0x54,0x6e,0x00},
    {0x3a,0x6e,0xfe,0x6e,0x7a,0x42,0x6a,0x00},
    {0xe2,0xaa,0xea,0xaa,0xe2,0x02,0xa6,0x00},
    {0xee,0xaa,0xea,0xaa,0xea,0x98,0xe8,0x00},
    {0x10,0x7c,0x44,0x7c,0x7c,0xca,0xba,0x00},
    {0x5e,0xf2,0x5e,0x64,0xd6,0x54,0xee,0x00},
    {0x10,0xfe,0x54,0x7c,0x10,0x38,0xd6,0x00},
    {0xba,0x2e,0xbe,0x2e,0xba,0x82,0xaa,0x00},
    {0x7c,0x44,0x7c,0x10,0x5c,0x50,0xbe,0x00},
    {0x88,0x7e,0x2a,0xfe,0x5c,0x6a,0xbe,0x00},
    {0x54,0x62,0xc8,0xd4,0x62,0x5c,0x5c,0x00},
    {0x7e,0x7e,0x4c,0x5c,0x7e,0x6e,0xba,0x00},
    {0xc4,0xfe,0xd4,0xfc,0xd6,0x04,0xaa,0x00},
    {0x48,0xee,0x58,0x6c,0x7e,0xa4,0xaa,0x00},
    {0x48,0xbe,0x48,0xbe,0x62,0xd4,0x66,0x00},
    {0x10,0xfe,0x44,0x44,0xaa,0xfe,0x10,0x00},
    {0x44,0xfe,0x36,0x5e,0xf6,0x76,0x5e,0x00},
    {0x28,0xfe,0x28,0x38,0xfe,0x00,0xc6,0x00},
    {0x54,0xfe,0x40,0x7a,0xea,0x7a,0xea,0x00},
    {0x20,0xfe,0x2c,0x44,0xfe,0x48,0x58,0x00},
    {0xee,0x24,0x48,0x64,0xde,0x44,0xd6,0x00},
    {0x24,0xfe,0x5c,0x6c,0xfe,0x28,0x18,0x00},
    {0x4c,0xec,0x5e,0x72,0xde,0x40,0xd2,0x00},
    {0x24,0xfe,0x24,0x74,0x6c,0xa4,0x2c,0x00},
    {0xbe,0x14,0x28,0xe4,0x5e,0x74,0xbe,0x00},
    {0x24,0x54,0xde,0x76,0x54,0x52,0x5e,0x00},
    {0x18,0x68,0x10,0xee,0x32,0x0c,0x70,0x00},
    {0x10,0x10,0xfe,0x10,0x10,0x28,0xd6,0x00},
    {0x88,0x08,0xbe,0x08,0x48,0x94,0xaa,0x00},
    {0x88,0xfe,0x22,0xd4,0x18,0xd2,0xde,0x00},
    {0x1c,0xc8,0xfe,0xd4,0xfe,0x08,0x3e,0x00},
    {0xc8,0xde,0x88,0xd6,0x86,0x10,0xfe,0x00},
    {0x0e,0xf0,0x54,0xfe,0x28,0x18,0xe6,0x00},
    {0x50,0xfe,0xd4,0x6e,0x5c,0x5c,0x54,0x00},
    {0x5e,0xe4,0x44,0x64,0xc4,0x44,0xcc,0x00},
    {0x44,0xfe,0x52,0xe8,0xce,0x48,0x4e,0x00},
    {0x44,0xfe,0xb2,0xa8,0xee,0xa8,0xae,0x00},
    {0x50,0xfe,0x54,0xee,0xdc,0x5c,0x54,0x00},
    {0xe4,0xbe,0xd2,0xa8,0xae,0xc8,0x8e,0x00},
    {0xe4,0xc4,0xee,0xc4,0xe4,0x2a,0xb6,0x00},
    {0xea,0xc4,0xfe,0xde,0xe4,0x3e,0xa4,0x00},
    {0x28,0x7e,0xc8,0x5c,0x6a,0x5c,0x48,0x00},
    {0x54,0x5e,0xf4,0x5e,0x74,0xd4,0x1e,0x00},
    {0x22,0xfe,0x12,0x5a,0x26,0x52,0x86,0x00},
    {0xfa,0x46,0xfa,0xae,0xae,0xaa,0xaa,0x00},
    {0x2a,0x5e,0xc4,0x42,0x10,0x92,0xfe,0x00},
    {0x54,0xfe,0x54,0xfe,0x92,0x7c,0x54,0x00},
    {0x48,0x9c,0x48,0xfe,0x44,0x7e,0x54,0x00},
    {0x10,0x24,0xfa,0x44,0x7c,0xca,0xba,0x00},
    {0x54,0xf6,0x50,0x74,0x56,0xc8,0xba,0x00},
    {0x2a,0x78,0xfe,0x68,0xfa,0x04,0xaa,0x00},
    {0x44,0xee,0x44,0xaa,0x7c,0x44,0x7c,0x00},
    {0x10,0x7c,0x38,0xee,0x54,0x38,0xd6,0x00},
    {0x94,0x3e,0x94,0x3e,0xaa,0x9c,0x94,0x00},
    {0xe4,0xa4,0xea,0xbe,0xe0,0xae,0xae,0x00},
    {0xf6,0xa6,0xe6,0xb4,0xfa,0xb0,0xbe,0x00},
    {0x28,0xfe,0x10,0x24,0xfa,0x44,0x7c,0x00},
    {0x2a,0x5e,0xc4,0x52,0xfe,0x68,0xb6,0x00},
    {0x2a,0x5e,0xc4,0x42,0x3c,0x3c,0xc6,0x00},
    {0x9e,0x52,0x1e,0xd2,0x5c,0x56,0xbe,0x00},
    {0x88,0x3c,0x1c,0xea,0x5c,0x6a,0xbe,0x00},
    {0xd4,0xfe,0x90,0xea,0xdc,0xaa,0x98,0x00},
    {0x2a,0x5e,0xc4,0x7a,0x38,0xfe,0xaa,0x00},
    {0xfe,0x6a,0xfe,0xea,0xf6,0x3e,0xa2,0x00},
    {0x2a,0x48,0xfe,0x48,0x44,0x44,0x42,0x00},
    {0x10,0x10,0x24,0xfa,0x00,0x7c,0x7c,0x00},
    {0x10,0x10,0xfe,0x10,0x10,0x28,0xc6,0x00},
    {0x48,0x6e,0xb4,0x7c,0x50,0x3e,0xd2,0x00},
    {0xec,0x4c,0xfe,0xe4,0xb6,0xf4,0xee,0x00},
    {0x6e,0x64,0xfe,0x2e,0x70,0x6a,0x9e,0x00},
    {0x08,0x7e,0x6c,0x6e,0x5e,0x42,0xaa,0x00},
    {0x88,0x3e,0x94,0x3e,0x9c,0x9c,0x86,0x00},
    {0x96,0x7c,0xae,0x7a,0xae,0xbc,0xae,0x00},
    {0x10,0x1e,0x7c,0x44,0x7c,0xfe,0x10,0x00},
    {0x3e,0xd0,0xda,0xec,0xdc,0x2a,0x18,0x00},
    {0x10,0xfe,0xba,0x10,0xfe,0x10,0x1e,0x00},
    {0x44,0xd8,0x48,0x7e,0xc8,0x4a,0xce,0x00},
    {0x5e,0xf2,0x5e,0x74,0xd4,0x52,0xe2,0x00},
    {0x5e,0xe8,0x48,0x6e,0xda,0x4a,0xce,0x00},
    {0x9e,0x12,0x9e,0x14,0x54,0x92,0xa2,0x00},
    {0xb6,0x12,0xb6,0x14,0x9e,0xb4,0x9e,0x00},
    {0x3e,0xd0,0x5a,0xec,0x5c,0xea,0x18,0x00},
    {0x44,0xd8,0x08,0xbe,0x08,0xca,0xce,0x00},
    {0x7e,0xbe,0xc8,0x7e,0xd4,0x7e,0xc8,0x00},
    {0xbe,0x2a,0x9e,0x22,0x9a,0x9e,0xba,0x00},
    {0x94,0xfe,0x10,0xbe,0x10,0xee,0xce,0x00},
    {0x28,0xfe,0x28,0xfe,0x24,0xfe,0x04,0x00},
    {0x7c,0x44,0x54,0x7c,0x7c,0x54,0x96,0x00},
    {0x56,0xe4,0xbe,0xf2,0x5e,0x72,0xd6,0x00},
    {0x7c,0x44,0x44,0x7c,0x00,0x28,0xc6,0x00},
    {0x1e,0xf2,0xb2,0xb2,0xf6,0x10,0x10,0x00},
    {0x3c,0x54,0xdc,0x54,0x5c,0x40,0x7e,0x00},
    {0x88,0x1c,0x3e,0xd4,0x7e,0x48,0xbe,0x00},
    {0x7e,0x40,0x5c,0x40,0x7e,0x68,0xb6,0x00},
    {0x10,0xfe,0x74,0xba,0xfe,0x28,0x18,0x00},
    {0xea,0xbe,0xf2,0xbe,0xec,0xac,0xb6,0x00},
    {0xee,0x22,0x6e,0x38,0xfe,0x00,0xc6,0x00},
    {0xee,0xca,0xe4,0x1a,0x7c,0x28,0xfe,0x00},
    {0x88,0x2a,0x2a,0xea,0x7e,0x40,0xbe,0x00},
    {0x7e,0xea,0x7e,0xea,0xfe,0x6a,0x56,0x00},
    {0x28,0x44,0x10,0x28,0xc6,0x38,0x38,0x00},
    {0xbe,0x6a,0xfe,0x6a,0xfe,0x48,0xbe,0x00},
    {0x6c,0xbe,0x76,0x60,0x6e,0x02,0xae,0x00},
    {0x54,0xfe,0x76,0xe2,0xfe,0x54,0x4c,0x00},
    {0x54,0xde,0x34,0xde,0x14,0xd4,0xde,0x00},
    {0x7c,0x44,0x54,0x44,0xfe,0x44,0x8c,0x00},
    {0x54,0x7c,0x54,0x7c,0x54,0xfe,0x10,0x00},
    {0x14,0xfe,0xaa,0xbe,0xfe,0x08,0x36,0x00},
    {0x5c,0x54,0xfc,0x54,0x7c,0xc0,0x3e,0x00},
    {0x5c,0xf4,0x5c,0x74,0xdc,0x40,0xfe,0x00},
    {0x7e,0xe2,0x54,0x66,0xfe,0x5c,0xea,0x00},
    {0x7c,0x44,0x7c,0x44,0x7c,0x00,0xfe,0x00},
    {0x54,0xf6,0x5a,0xf4,0xf4,0x24,0xda,0x00},
    {0xaa,0x14,0xa2,0x08,0xaa,0x94,0xa2,0x00},
    {0x94,0x3e,0x94,0x14,0xbe,0xa8,0xbe,0x00},
    {0x92,0xfe,0x48,0x6a,0x6c,0x48,0xb6,0x00},
    {0x9e,0xe0,0x5e,0xf2,0x5e,0x6c,0x9e,0x00},
    {0x6a,0xfe,0xa0,0xbe,0x50,0xfe,0x2a,0x00},
    {0x48,0x6e,0xb4,0x54,0x7c,0xfe,0x10,0x00},
    {0x48,0xbe,0x6e,0x84,0x56,0xd4,0x6e,0x00},
    {0xe8,0x7e,0x7a,0x68,0x6c,0xec,0x36,0x00},
    {0xee,0xaa,0xee,0xaa,0xee,0xa0,0xae,0x00},
    {0xfe,0x1a,0x50,0xbe,0x38,0x14,0xfa,0x00},
    {0xb2,0xdc,0x26,0x94,0x3e,0xd0,0xee,0x00},
    {0x4e,0xb6,0xf8,0x56,0xfa,0x74,0xda,0x00},
    {0xfe,0x8a,0xfe,0xaa,0x8a,0x9a,0xfe,0x00},
    {0x48,0x7e,0xf6,0x7e,0x5c,0xd4,0x3e,0x00},
    {0xea,0x44,0xfe,0xbe,0xc8,0x7e,0xc8,0x00},
    {0xd2,0xac,0xf8,0xae,0xda,0x8a,0xf2,0x00},
    {0x06,0xf8,0xaa,0xfe,0xaa,0xf4,0x2a,0x00},
    {0x48,0xfe,0x76,0xfe,0xdc,0x54,0x7e,0x00},
    {0x2e,0x4a,0x60,0x4e,0x6a,0xc4,0x5a,0x00},
    {0x7c,0x54,0x7c,0x54,0xfe,0x22,0xc6,0x00},
    {0xaa,0xd4,0x22,0xc8,0x2a,0xd4,0xe2,0x00},
    {0x28,0x7e,0xc8,0x6c,0x6c,0x60,0x7e,0x00},
    {0x40,0x7e,0xaa,0x7a,0x2a,0x5a,0x8e,0x00},
    {0x44,0x54,0xde,0x76,0x54,0xd2,0x1e,0x00},
    {0xc4,0x54,0xde,0xb6,0xd4,0x52,0xde,0x00},
    {0xe8,0x64,0x68,0x7a,0x78,0xea,0x2e,0x00},
    {0x40,0x7e,0xaa,0x5e,0xfc,0x44,0x7c,0x00},
    {0x84,0x14,0x9e,0x36,0x94,0x92,0x9e,0x00},
    {0x08,0x7e,0xd0,0x5e,0xf6,0x56,0xa8,0x00},
    {0xf4,0x5e,0xf4,0x5e,0xf4,0xd4,0x5e,0x00},
    {0xfe,0xaa,0xfe,0x24,0xbc,0xa4,0xfe,0x00},
    {0xf4,0x26,0x5a,0xfa,0x6a,0x34,0xca,0x00},
    {0x60,0xfe,0xd6,0xfe,0x56,0x56,0xe8,0x00},
    {0x9e,0x5e,0x10,0xda,0x5e,0x64,0xbe,0x00},
    {0xe4,0xd4,0xfe,0xd6,0xf4,0x32,0xbe,0x00},
    {0x48,0x6e,0xb4,0x4c,0xee,0x38,0xd6,0x00},
    {0x10,0xfe,0x60,0x12,0xfe,0x54,0x7c,0x00},
    {0x48,0x6e,0xb4,0x24,0x24,0x24,0x2c,0x00},
    {0x48,0x6e,0xb4,0x00,0xec,0x4c,0xf6,0x00},
    {0x28,0xfe,0x60,0x12,0xfe,0x54,0x7c,0x00},
    {0xbe,0x50,0x1a,0xec,0x5a,0x68,0xbe,0x00},
    {0xd8,0x5c,0xe8,0x7e,0xc8,0xd4,0x62,0x00},
    {0x10,0xfe,0xaa,0x5c,0x7a,0x10,0xfe,0x00},
    {0x28,0xfe,0x10,0x28,0xfe,0x54,0x92,0x00},
    {0x88,0xbe,0xd4,0xfe,0xea,0x76,0xbe,0x00},
    {0x24,0xfe,0x10,0xfe,0x7c,0x64,0xbc,0x00},
    {0x10,0xfe,0x92,0x92,0xfe,0x10,0x10,0x00},
    {0x28,0x7e,0xea,0x6a,0x7e,0x48,0x48,0x00},
    {0x10,0xfe,0x92,0x7c,0x7c,0x54,0x7c,0x00},
    {0x10,0x7c,0x54,0x7c,0x10,0xca,0xba,0x00},
    {0x48,0xfe,0x6a,0x7e,0xea,0x6a,0xfe,0x00},
    {0x7c,0x44,0x78,0x44,0xba,0x28,0xfe,0x00},
    {0x50,0xc8,0x7e,0xc8,0xdc,0x48,0x7e,0x00},
    {0x90,0x08,0xbe,0x08,0x5c,0x88,0xbe,0x00},
    {0x10,0x7c,0x54,0x54,0x7c,0x14,0xfa,0x00},
    {0x10,0xfe,0x54,0x7c,0x2a,0xe4,0x32,0x00},
    {0x50,0xc8,0x3e,0xc8,0x1c,0xc8,0xfe,0x00},
    {0xe4,0x5e,0xe4,0xf4,0xac,0xe4,0xec,0x00},
    {0x48,0xbc,0xfe,0x54,0xfe,0x64,0xd4,0x00},
    {0xe8,0xc4,0xfe,0xc4,0xee,0x24,0xbe,0x00},
    {0x5c,0xfe,0x6a,0xdc,0xde,0x42,0x46,0x00},
    {0xb4,0x1e,0xb4,0x5e,0xb8,0xd6,0xa6,0x00},
    {0xa4,0x4e,0xa4,0x7e,0xa8,0x36,0xc6,0x00},
    {0x28,0xfe,0x28,0xfe,0xba,0x10,0x30,0x00},
    {0x28,0xfe,0x3c,0x18,0xfe,0x34,0xdc,0x00},
    {0xe4,0xbe,0xf2,0xae,0xe4,0x04,0xac,0x00},
    {0xfe,0x10,0x10,0x10,0x10,0x10,0x30,0x00},
    {0x28,0xaa,0x6c,0x2c,0xea,0x28,0xce,0x00},
    {0xbe,0x2a,0x3e,0x2a,0xb6,0xbe,0xa2,0x00},
    {0x2a,0xfe,0xae,0xa0,0xfe,0x1c,0x2a,0x00},
    {0x10,0xfe,0xa6,0xfc,0x52,0x74,0x56,0x00},
    {0x48,0xe8,0xee,0xe8,0x5e,0x52,0x5e,0x00},
    {0x5e,0xd0,0xdc,0xd0,0x7e,0x54,0x5a,0x00},
    {0x08,0x7e,0x40,0x7e,0x48,0x48,0x98,0x00},
    {0x7c,0x14,0x7c,0x50,0xfe,0x12,0x16,0x00},
    {0xde,0x50,0xdc,0x90,0xfe,0x54,0xda,0x00},
    {0xfa,0xac,0xfa,0xac,0xd8,0xfa,0x8c,0x00},
    {0x54,0xbe,0x7e,0xc6,0x7e,0x54,0x7a,0x00},
    {0x54,0xbe,0x46,0xfc,0x5a,0xc8,0xba,0x00},
    {0x54,0xf6,0x54,0x76,0xd4,0x54,0xe6,0x00},
    {0x4e,0xea,0xbe,0xe8,0xae,0xf6,0x4a,0x00},
    {0xee,0x4a,0xee,0xaa,0x4e,0xea,0x56,0x00},
    {0xbe,0x1a,0xbe,0x3a,0x9e,0xba,0x92,0x00},
    {0xaa,0xbe,0xf6,0x90,0xfe,0xbc,0xaa,0x00},
    {0xf0,0xbe,0xf4,0xb4,0xb4,0xf4,0x0c,0x00},
    {0xf4,0xb6,0xf4,0xb6,0xf4,0xb4,0xe6,0x00},
    {0xe4,0x7e,0x6e,0x6e,0x60,0xfa,0x36,0x00},
    {0xee,0xa8,0xee,0xa8,0xfe,0xb4,0xba,0x00},
    {0xee,0xaa,0xfe,0xa8,0xee,0xb6,0xaa,0x00},
    {0x6a,0xfe,0xae,0xe0,0x7e,0x5c,0xea,0x00},
    {0xbe,0xea,0x3e,0xaa,0x36,0xfe,0xe2,0x00},
    {0xaa,0xfe,0x2e,0xa0,0x3e,0xdc,0xea,0x00},
    {0x2e,0xf6,0x2a,0xf0,0x6e,0x6a,0x9e,0x00},
    {0xf4,0xb6,0xf4,0x56,0xf4,0xd4,0xe6,0x00},
    {0x54,0xb6,0xf4,0x56,0xf4,0x74,0xe6,0x00},
    {0x3c,0x20,0x38,0x20,0xfe,0x28,0x76,0x00},
    {0xfe,0x48,0x5e,0x52,0x5e,0xc0,0x12,0x00},
    {0x10,0x7c,0x7c,0x40,0x7e,0x02,0xaa,0x00},
    {0x24,0xfe,0x6e,0x7e,0x26,0x7a,0xaa,0x00},
    {0x44,0xd6,0x54,0x7e,0xea,0x44,0xd8,0x00},
    {0x10,0xfe,0x10,0xbc,0xa4,0xbc,0xfe,0x00},
    {0xea,0xa0,0xfe,0xa4,0xfe,0xa4,0xba,0x00},
    {0x88,0x3e,0xaa,0x0c,0x4c,0x94,0xa6,0x00},
    {0x08,0xd4,0x6a,0xc4,0x4a,0xc4,0x18,0x00},
    {0x24,0x58,0xfe,0x48,0x3c,0x3c,0xc6,0x00},
    {0x44,0xbe,0xec,0x4c,0xfe,0x60,0xd2,0x00},
    {0xc8,0xfe,0x9c,0xdc,0xc8,0x9c,0xaa,0x00},
    {0x88,0x3c,0x8e,0x3c,0x88,0xbe,0x88,0x00},
    {0xd4,0xfe,0x9a,0xec,0x9a,0x10,0xfe,0x00},
    {0x54,0xde,0x74,0xde,0xd4,0x54,0x5e,0x00},
    {0x52,0xe6,0x46,0xf4,0xd6,0x56,0x6e,0x00},
    {0x88,0x5e,0x1e,0xd0,0x5e,0x52,0xbe,0x00},
    {0x52,0xa6,0xe6,0x74,0xd6,0x76,0xde,0x00},
    {0x08,0x7e,0xc4,0x7e,0xea,0x7e,0xaa,0x00},
    {0xbe,0x04,0x3e,0xea,0x7e,0x6a,0xbe,0x00},
    {0x7e,0x62,0xdc,0x7a,0x5c,0xec,0x1a,0x00},
    {0x5c,0xd4,0x54,0xfe,0xe4,0x7e,0x4c,0x00},
    {0x7e,0xde,0x4a,0x5e,0xca,0x5e,0xfe,0x00},
    {0x56,0xfe,0x56,0xfe,0xd6,0x6c,0x4a,0x00},
    {0x3e,0x6a,0xea,0x7e,0x6a,0x6a,0x7e,0x00},
    {0x88,0x1c,0x88,0x3e,0x9c,0x9c,0xa2,0x00},
    {0x5e,0xe8,0x48,0xee,0xda,0x4a,0x4e,0x00},
    {0x88,0x08,0x3e,0xc8,0x48,0x48,0xbe,0x00},
    {0x28,0xfe,0x10,0x78,0x7e,0x02,0xaa,0x00},
    {0x7e,0x94,0x6a,0xbe,0x6a,0xd4,0x6a,0x00},
    {0x5a,0xba,0xec,0x5e,0xe8,0x6e,0xc2,0x00},
    {0x48,0xfe,0x5c,0xfe,0xd4,0x6e,0x4c,0x00},
    {0x88,0x3e,0xaa,0x3e,0x9c,0x9c,0xa2,0x00},
    {0x7e,0x48,0xea,0x48,0x7e,0xc8,0x08,0x00},
    {0x10,0xfe,0x10,0xfe,0xaa,0x7c,0xfe,0x00},
    {0x9c,0xbe,0xea,0xdc,0xc8,0x7e,0xaa,0x00},
    {0x48,0xbe,0x6a,0xbe,0x6a,0xea,0x7e,0x00},
    {0x0c,0x70,0x54,0x54,0x54,0x54,0x92,0x00},
    {0x7c,0x44,0x7c,0xfe,0x92,0x96,0x10,0x00},
    {0x48,0xae,0xf2,0x4a,0xe6,0x62,0xc6,0x00},
    {0x24,0xfe,0xbe,0x68,0xee,0x62,0x6a,0x00},
    {0x10,0xfe,0x44,0xfe,0xba,0x10,0x30,0x00},
    {0x22,0x5c,0xd4,0x5e,0x54,0x52,0x7e,0x00},
    {0x28,0x7e,0xd4,0x7e,0x5e,0x48,0x58,0x00},
    {0x28,0x4e,0xdc,0x54,0x5c,0x5c,0x62,0x00},
    {0x52,0xfa,0x2a,0xfa,0xa2,0x7a,0xaa,0x00},
    {0x10,0x1e,0x7c,0x44,0x7c,0x7c,0xc6,0x00},
    {0x7c,0x44,0xfe,0x10,0x7c,0x10,0xfe,0x00},
    {0x4c,0x4c,0xfe,0x44,0x56,0xd4,0x2e,0x00},
    {0x10,0xfe,0xba,0x10,0x5c,0x50,0xbe,0x00},
    {0x10,0xfe,0x24,0xfe,0x92,0x7c,0x54,0x00},
    {0x08,0x7e,0x5e,0x54,0x5e,0x54,0xba,0x00},
    {0x08,0x7e,0x72,0x54,0x6e,0x54,0xae,0x00},
    {0xc4,0x58,0x88,0x7e,0xc8,0x5c,0xbe,0x00},
    {0x24,0xfe,0x12,0x7e,0x50,0x3e,0xd2,0x00},
    {0x54,0xfe,0xca,0x7e,0x68,0x5e,0x6a,0x00},
    {0x42,0xdc,0x54,0x5e,0xd4,0x52,0xfe,0x00},
    {0x72,0xdc,0x64,0x5e,0xf4,0x5e,0xee,0x00},
    {0x4c,0xec,0x5e,0x44,0xd6,0x54,0xee,0x00},
    {0x54,0xfe,0x4a,0xfe,0xe8,0x5e,0x6a,0x00},
    {0xbe,0x08,0x88,0x08,0x48,0x88,0x98,0x00},
    {0xe4,0x5e,0x52,0x8c,0x66,0x6c,0x16,0x00},
    {0x44,0xe6,0x2c,0x4c,0xec,0x4c,0x52,0x00},
    {0xdc,0x54,0xfe,0x48,0xdc,0xc8,0x7e,0x00},
    {0x48,0xbe,0x54,0xbe,0x6a,0xdc,0x54,0x00},
    {0x72,0xdc,0xe4,0xde,0xf4,0xde,0xee,0x00},
    {0x5e,0xe4,0x04,0xe4,0x04,0xe4,0xec,0x00},
    {0x88,0xfe,0x14,0xbe,0x2a,0xdc,0xd4,0x00},
    {0xe8,0xbe,0xd4,0x7e,0xea,0xdc,0xd4,0x00},
    {0x82,0x5c,0x14,0xde,0x56,0x64,0xbe,0x00},
    {0x16,0xe6,0xa4,0xf6,0xa6,0x94,0xec,0x00},
    {0x56,0xfe,0xdc,0x8e,0xfe,0x24,0xdc,0x00},
    {0x5e,0xa4,0xe4,0x44,0xe4,0x64,0xcc,0x00},
    {0xba,0xba,0xba,0xee,0x28,0x6e,0xaa,0x00},
    {0xbe,0x22,0xbe,0x28,0xae,0xa8,0xce,0x00},
    {0x48,0xfe,0x54,0x7e,0xea,0x76,0xfe,0x00},
    {0x76,0xd2,0x76,0x54,0xde,0x74,0xde,0x00},
    {0x24,0xf6,0x5a,0xfa,0xaa,0xdc,0xfa,0x00},
    {0x88,0x3e,0x94,0x3e,0xaa,0xb6,0xbe,0x00},
    {0x48,0xee,0xb2,0xea,0xa6,0xe2,0x06,0x00},
    {0x48,0x6e,0xb4,0x10,0x7c,0x54,0x7c,0x00},
    {0x88,0x3e,0x14,0xfe,0x6a,0x76,0xbe,0x00},
    {0x48,0xbe,0xd4,0x7e,0xea,0x76,0xfe,0x00},
    {0xb6,0x12,0xb6,0x24,0xb6,0xda,0xb6,0x00},
    {0x44,0xd8,0x5e,0xd4,0x7c,0x44,0x7c,0x00},
    {0x54,0xbe,0x56,0xe6,0x5e,0x5c,0x5a,0x00},
    {0x54,0xfe,0x56,0x66,0xde,0x5c,0xda,0x00},
    {0xd4,0x7e,0xd6,0xe6,0x5e,0xdc,0x5a,0x00},
    {0x94,0x1e,0x24,0xde,0x44,0x5a,0xbe,0x00},
    {0x58,0xbc,0xe8,0x7e,0xc8,0x54,0xe2,0x00},
    {0x28,0x7c,0x6c,0x7c,0xfe,0x00,0xc6,0x00},
    {0x48,0x7e,0xdc,0x5c,0x7e,0xc0,0x22,0x00},
    {0xfe,0x10,0x7c,0x10,0x10,0x28,0xc6,0x00},
    {0x7e,0x42,0x7e,0x54,0x7e,0x68,0xb6,0x00},
    {0x08,0x7e,0x48,0x4e,0x48,0x5e,0x9e,0x00},
    {0x84,0x18,0xbe,0x14,0xaa,0x88,0xaa,0x00},
    {0x48,0xbe,0x6c,0xbe,0x76,0xe8,0x5e,0x00},
    {0x2a,0xde,0xea,0x4e,0xea,0xaa,0xee,0x00},
    {0xe8,0xa8,0xee,0xa8,0xfe,0x12,0xbe,0x00},
    {0xdc,0x40,0xfe,0xc8,0x48,0xd4,0x7a,0x00},
    {0x2e,0xf4,0x6e,0x6a,0xfe,0x00,0x92,0x00},
    {0x10,0x1c,0x10,0x7c,0x7c,0x00,0xaa,0x00},
    {0x3c,0x40,0xfe,0x48,0x48,0x54,0x7a,0x00},
    {0x7e,0x4a,0x70,0x6e,0x7a,0x44,0xaa,0x00},
    {0xfe,0x4a,0xf0,0x6e,0xfa,0xc4,0xaa,0x00},
    {0xfe,0x92,0x92,0xfe,0x92,0x92,0xfe,0x00},
    {0x38,0xfe,0xb6,0x7c,0x54,0x7c,0x0e,0x00},
    {0x0c,0xf0,0x7c,0x54,0x7c,0x2a,0xce,0x00},
    {0x08,0xe8,0xbc,0xa8,0xe8,0x08,0x3e,0x00},
    {0x4a,0x5c,0xc8,0x7e,0x50,0xee,0x0e,0x00},
    {0x88,0x14,0xbe,0x08,0xba,0x10,0xfe,0x00},
    {0x5e,0x48,0xe8,0xae,0xda,0x6a,0x8e,0x00},
    {0x7e,0x7e,0x5c,0x48,0x7e,0x5c,0xac,0x00},
    {0x48,0x9c,0x48,0xfe,0x4c,0x58,0x6e,0x00},
    {0x48,0x28,0x48,0x28,0x0e,0xf8,0x08,0x00},
    {0x48,0xe8,0x5c,0xe8,0xc8,0x48,0x7e,0x00},
    {0x88,0x3e,0xac,0x3e,0xaa,0xa4,0xda,0x00},
    {0x74,0xaa,0x44,0xba,0x28,0x10,0xfe,0x00},
    {0x28,0xfe,0x3c,0xd4,0x7c,0x2a,0xce,0x00},
    {0xe4,0xae,0xe4,0xbe,0xe8,0x16,0xa6,0x00},
    {0x88,0x14,0x3e,0xc8,0x6a,0x48,0xbe,0x00},
    {0x2e,0x7a,0x2c,0xfa,0x4a,0xbc,0x38,0x00},
    {0x48,0xbe,0xec,0x7e,0xea,0x64,0xda,0x00},
    {0xe2,0x5c,0x54,0x9e,0x74,0x72,0x1e,0x00},
    {0xfe,0x50,0x5e,0x94,0x76,0x7a,0x2a,0x00},
    {0x2e,0xfa,0x54,0x6a,0xbc,0x14,0x6c,0x00},
    {0x08,0x7e,0x54,0x7e,0x54,0x48,0xb6,0x00},
    {0x10,0x10,0x7c,0x10,0x10,0x10,0xfe,0x00},
    {0x2e,0x22,0xfa,0x5a,0x64,0x34,0xca,0x00},
    {0x2e,0xfa,0x54,0xea,0x00,0xca,0xba,0x00},
    {0x3a,0x56,0xe6,0x7e,0x52,0x7a,0x46,0x00},
    {0x54,0xfe,0xba,0x28,0x38,0x2a,0xce,0x00},
    {0x18,0x68,0x10,0x28,0xd6,0x30,0x0c,0x00},
    {0x88,0x3e,0x1c,0x1c,0x48,0x9c,0xaa,0x00},
    {0xfe,0x12,0x12,0x22,0x22,0x42,0x86,0x00},
    {0x08,0x7e,0x5c,0x4e,0x7c,0x54,0x9c,0x00},
    {0x54,0x7e,0xc8,0x54,0x7e,0xd4,0x1c,0x00},
    {0x48,0x7e,0xec,0x66,0x7c,0xea,0x2e,0x00},
    {0x10,0xfe,0x64,0xb2,0xfe,0x24,0xfa,0x00},
    {0x10,0xfe,0x82,0x7c,0x20,0x7c,0xbc,0x00},
    {0x10,0x7c,0x7c,0x40,0x7e,0xaa,0xfa,0x00},
    {0x48,0x5c,0x5c,0xf0,0xfe,0xc2,0x2a,0x00},
    {0x48,0xee,0xdc,0x54,0x5c,0x7e,0x48,0x00},
    {0x5c,0xd4,0x66,0x5c,0xd4,0x48,0xf6,0x00},
    {0x54,0xfe,0x48,0x54,0xfe,0x54,0xdc,0x00},
    {0x10,0xfe,0x54,0x7c,0x54,0x38,0xd6,0x00},
    {0x54,0xf6,0x54,0xf6,0xd4,0x54,0x66,0x00},
    {0x48,0xdc,0x7e,0xd4,0xfe,0x64,0x54,0x00},
    {0x48,0xfe,0x5c,0xdc,0xc8,0x5c,0x6a,0x00},
    {0x90,0x1e,0x2a,0x94,0x7c,0x54,0xfe,0x00},
    {0x90,0x1e,0xaa,0x1e,0x8a,0xae,0xbe,0x00},
    {0x9c,0x14,0xbe,0x10,0x9e,0xaa,0x96,0x00},
    {0x88,0x1c,0xbe,0x14,0xfe,0xa4,0xd4,0x00},
    {0x5e,0x44,0xe4,0xc4,0x44,0x64,0x8c,0x00},
    {0x7a,0x54,0xe2,0xdc,0x54,0x48,0xbe,0x00},
    {0x52,0x34,0x7e,0x02,0x3e,0x02,0x7e,0x00},
    {0x08,0x7e,0xde,0x52,0xde,0x4c,0x9e,0x00},
    {0x48,0xfc,0x3e,0x54,0xfe,0x64,0x54,0x00},
    {0x48,0x6e,0xb4,0x18,0xfe,0x28,0x18,0x00},
    {0x48,0x6e,0xb4,0x38,0xc6,0x38,0x38,0x00},
    {0x48,0x6e,0xb4,0xfe,0x82,0xba,0xba,0x00},
    {0x88,0x7e,0xec,0x66,0xfc,0xea,0x4e,0x00},
    {0x48,0xbe,0x54,0xba,0x54,0xd4,0x66,0x00},
    {0xf2,0x2a,0x5a,0xfa,0x62,0x32,0xc6,0x00},
    {0x28,0xfe,0x38,0xfe,0x54,0x7c,0xfe,0x00},
    {0x28,0xfe,0x94,0x1c,0xbe,0x16,0xaa,0x00},
    {0x28,0xfe,0x2a,0xf4,0xaa,0xfc,0xaa,0x00},
    {0x44,0xde,0x04,0xd4,0x0c,0xc4,0xcc,0x00},
    {0xf6,0xa4,0xfe,0xac,0xf2,0xac,0xac,0x00},
    {0xfe,0x00,0x7c,0x44,0x7c,0x28,0xfe,0x00},
    {0xe8,0xba,0xdc,0x6a,0xdc,0xf4,0xdc,0x00},
    {0x94,0x36,0x14,0xf6,0x54,0x66,0xbe,0x00},
    {0x9c,0x3e,0x1c,0xea,0x4c,0x54,0xbe,0x00},
    {0x7a,0xb4,0xe2,0x5c,0xd4,0x48,0xfe,0x00},
    {0xd0,0xde,0xaa,0xde,0xca,0xae,0xbe,0x00},
    {0xee,0x04,0xee,0xaa,0x4e,0xe0,0x12,0x00},
    {0xf6,0xa4,0xfe,0xac,0xee,0xa2,0xb6,0x00},
    {0xee,0xee,0x82,0xf6,0xde,0xa6,0xf6,0x00},
    {0x34,0x5e,0xf6,0x76,0x56,0x7a,0x4a,0x00},
    {0xe8,0x5e,0xea,0xea,0xea,0x4a,0xf6,0x00},
    {0xfe,0x82,0xba,0x82,0xba,0xaa,0xba,0x00},
    {0x54,0xfe,0xaa,0x38,0x7c,0x10,0xfe,0x00},
    {0x54,0x3e,0xdc,0x5c,0xfe,0x28,0x18,0x00},
    {0x48,0xfe,0xd4,0x7e,0x5c,0x48,0x7e,0x00},
    {0x48,0xfe,0x54,0x7e,0xdc,0x48,0xfe,0x00},
    {0xbe,0x22,0xba,0x22,0xba,0xba,0xa6,0x00},
    {0xe8,0xbe,0xf4,0xbe,0xfc,0xa8,0xfe,0x00},
    {0x10,0x7c,0x28,0xfe,0x7c,0x10,0xfe,0x00},
    {0xfe,0xb2,0xfe,0xb2,0xfe,0xbe,0xb2,0x00},
    {0x28,0xfe,0x7e,0x52,0xba,0x56,0x7e,0x00},
    {0x94,0x3e,0x08,0xd4,0x5c,0x54,0xbe,0x00},
    {0x5e,0xb2,0xfe,0x52,0xfe,0x7e,0xd2,0x00},
    {0x48,0x4e,0x48,0xfe,0xec,0xea,0x08,0x00},
    {0x88,0xfc,0x9c,0xf0,0x5e,0xe2,0x56,0x00},
    {0xfe,0xa8,0xfe,0xb0,0xdc,0x94,0xfe,0x00},
    {0x5c,0x94,0x7e,0xc4,0x7e,0x54,0x4c,0x00},
    {0x48,0xbe,0x5c,0xdc,0x40,0x72,0x6e,0x00},
    {0x88,0x3e,0x88,0x3e,0xa2,0x94,0xa6,0x00},
    {0xc8,0xfc,0xc8,0x7e,0xc4,0x7e,0x54,0x00},
    {0x2e,0x3a,0xf4,0xaa,0x7c,0x44,0x7c,0x00},
    {0x38,0xfe,0x38,0xd6,0x28,0x2a,0xce,0x00},
    {0x48,0x6e,0xbc,0x50,0x7e,0x02,0xaa,0x00},
    {0x10,0x7c,0x10,0xfe,0x54,0xfe,0x7c,0x00},
    {0xa8,0x5e,0xba,0x7e,0xa8,0x2a,0xde,0x00},
    {0x88,0xfe,0x08,0xbe,0x22,0xd4,0xe6,0x00},
    {0x5e,0xf0,0x5e,0xf4,0xd6,0x5a,0x6a,0x00},
    {0x4c,0xf4,0x5c,0xdc,0xda,0x6c,0x5a,0x00},
    {0x38,0x28,0x28,0xee,0x82,0x82,0xfe,0x00},
    {0x10,0xfe,0xaa,0x4c,0xfe,0x10,0xee,0x00},
    {0x5e,0xea,0x70,0xee,0xfa,0x64,0x6a,0x00},
    {0x7e,0x42,0x7e,0x48,0x7e,0x6a,0xbe,0x00},
    {0x0a,0xfe,0x14,0x7a,0x7e,0x02,0xaa,0x00},
    {0x28,0xfe,0x10,0x1c,0x10,0x7c,0x7c,0x00},
    {0x10,0xfe,0xba,0x7c,0x54,0x7c,0xc6,0x00},
    {0xfe,0x28,0xfe,0xaa,0xce,0xfe,0xfe,0x00},
    {0xa6,0x7a,0xa4,0x7e,0xd6,0xfe,0xd4,0x00},
    {0x2e,0xf4,0xae,0xbe,0xe6,0x30,0x0a,0x00},
    {0x16,0xf8,0x10,0x52,0x7e,0x10,0x1e,0x00},
    {0x48,0xfe,0xd4,0x5c,0x44,0x7e,0x48,0x00},
    {0x24,0xf6,0x5a,0x7a,0x3a,0xe4,0x2a,0x00},
    {0x88,0x3e,0x88,0x2a,0xbe,0x88,0x8e,0x00},
    {0xfe,0xa8,0xec,0xb6,0xec,0xb6,0xac,0x00},
    {0x82,0x5c,0x1e,0xd4,0x6e,0x4e,0xbe,0x00},
    {0x2e,0xf4,0x2e,0xaa,0xfe,0x20,0x3a,0x00},
    {0x0c,0x70,0xfe,0x44,0xba,0x28,0x38,0x00},
    {0x7c,0x44,0xfe,0xb6,0x78,0x24,0xfa,0x00},
    {0x48,0xbe,0xc8,0x6a,0xfe,0x48,0xce,0x00},
    {0x10,0xfe,0x28,0xc6,0x7c,0x54,0xb2,0x00},
    {0xf6,0x56,0xf4,0x56,0xf6,0x54,0xb4,0x00},
    {0x10,0xfe,0x92,0xaa,0xc6,0x82,0x86,0x00},
    {0x20,0x3e,0x50,0x9e,0x10,0x1e,0x10,0x00},
    {0x7c,0x44,0x54,0x5c,0x74,0x7c,0x86,0x00},
    {0x28,0xfe,0x4a,0x6c,0xde,0x4c,0xae,0x00},
    {0xaa,0xc4,0x1e,0xac,0x36,0xe4,0xfe,0x00},
    {0xda,0x7c,0xae,0x7c,0xfe,0xac,0xde,0x00},
    {0x48,0xfe,0x54,0x62,0xdc,0x48,0xea,0x00},
    {0x4e,0xaa,0xea,0x5e,0xf2,0x76,0xd6,0x00},
    {0x54,0xfe,0x54,0xfe,0xf6,0x62,0x7e,0x00},
    {0xf2,0xda,0xfa,0xda,0xfa,0x32,0xa2,0x00},
    {0x5c,0x94,0x5e,0xba,0x56,0xfc,0x46,0x00},
    {0x3e,0xd4,0xea,0xfe,0xea,0xd4,0x2a,0x00},
    {0x10,0xfe,0x10,0xfe,0xaa,0xfe,0x92,0x00},
    {0x48,0xfe,0x48,0xf6,0xea,0x7e,0x6a,0x00},
    {0xe8,0x4e,0xf6,0xe4,0x44,0xe4,0x5a,0x00},
    {0x5a,0xfe,0x5c,0xfe,0xfc,0x2c,0xde,0x00},
    {0x88,0x08,0xbe,0x14,0x98,0x8c,0xb2,0x00},
    {0x00,0x7c,0x00,0x00,0x00,0x00,0xfe,0x00},
    {0x7e,0x42,0x7e,0x50,0x5e,0x50,0x9e,0x00},
    {0x6a,0x08,0xfe,0x68,0x04,0x34,0xc2,0x00},
    {0x90,0x1e,0x24,0xd4,0x66,0x4c,0xbe,0x00},
    {0x40,0x7e,0xa2,0x3a,0x22,0x3a,0x06,0x00},
    {0xfe,0xb0,0xf6,0xb0,0xfe,0x14,0xba,0x00},
    {0x10,0xfe,0x92,0xaa,0x92,0xaa,0x86,0x00},
    {0x40,0xfc,0xa8,0xe8,0x48,0x48,0xfe,0x00},
    {0x24,0x24,0xfe,0x24,0x24,0x24,0x3c,0x00},
    {0x7e,0x42,0x42,0x7e,0x42,0x42,0x7e,0x00},
    {0x3c,0xd4,0x04,0x74,0x14,0xfc,0x26,0x00},
    {0x70,0x10,0x10,0x28,0x28,0x44,0x82,0x00},
    {0x20,0x2e,0xfa,0x5a,0x6a,0x3a,0xce,0x00},
    {0x7e,0x42,0x7e,0x48,0x7a,0x5c,0xaa,0x00},
    {0x28,0xfe,0x6c,0x28,0x6c,0x28,0xfe,0x00},
    {0x24,0x58,0xc8,0x7e,0x48,0x48,0x5c,0x00},
    {0x22,0x2c,0xf4,0x5e,0x64,0x34,0xce,0x00},
    {0x7c,0x2c,0x14,0xec,0x50,0xca,0xba,0x00},
    {0xbe,0xd6,0x0a,0xb6,0x00,0xd2,0xee,0x00},
    {0x9c,0x3e,0xaa,0x1c,0x88,0xbe,0xaa,0x00},
    {0x5e,0xec,0x3e,0x56,0xfa,0x56,0x5a,0x00},
    {0x48,0xee,0x34,0x4c,0xee,0x56,0x4c,0x00},
    {0x10,0xfe,0xaa,0x5c,0xfe,0x10,0x30,0x00},
    {0x28,0xfe,0x7c,0xac,0x54,0xca,0xba,0x00},
    {0x94,0x7e,0xd4,0x7e,0xfe,0x6a,0xbe,0x00},
    {0x28,0x6c,0xf4,0x6c,0xb6,0x00,0xaa,0x00},
    {0x40,0x7e,0x90,0x7c,0x50,0xfe,0x10,0x00},
    {0x10,0x28,0xde,0x38,0x08,0xc2,0xba,0x00},
    {0x48,0xd4,0x6e,0x5c,0xc4,0x72,0xee,0x00},
    {0x54,0xde,0x6c,0x54,0xea,0x40,0xea,0x00},
    {0x54,0x5e,0xec,0xd4,0x6a,0x40,0xaa,0x00},
    {0xa8,0x48,0xee,0x48,0xfe,0xd2,0x5e,0x00},
    {0xf8,0x28,0x2e,0x22,0x42,0x42,0x86,0x00},
    {0xde,0x4c,0x9e,0x5a,0xd2,0x5e,0xbe,0x00},
    {0x10,0x7c,0x04,0x08,0x50,0x60,0x9e,0x00},
    {0x24,0xfe,0x6c,0xb6,0x7c,0x10,0xfe,0x00},
    {0x10,0xfe,0x54,0xfe,0xfe,0x68,0xb6,0x00},
    {0x6a,0xc2,0xd4,0x6a,0x76,0x62,0x7e,0x00},
    {0x94,0x3e,0xbe,0x00,0xbe,0xb4,0xda,0x00},
    {0x48,0xbe,0x6a,0xaa,0x76,0xe2,0x66,0x00},
    {0x24,0x56,0xf4,0x76,0x56,0x74,0x56,0x00},
    {0xfa,0xa2,0xf4,0xaa,0xf6,0xb2,0xbe,0x00},
    {0xea,0xbe,0xfe,0xa0,0xfe,0xb4,0xba,0x00},
    {0x28,0x7c,0x7c,0x00,0x7e,0x68,0xb6,0x00},
    {0xee,0x2a,0xee,0x2a,0xee,0xec,0x36,0x00},
    {0x7c,0x24,0x38,0xd6,0x7c,0x14,0xfa,0x00},
    {0xfc,0x94,0x94,0xfc,0x80,0x82,0x7e,0x00},
    {0x7e,0xea,0x6a,0x7e,0xe0,0x62,0xde,0x00},
    {0x7e,0xd4,0x7e,0x5c,0xea,0x5c,0xdc,0x00},
    {0xfe,0x54,0x7c,0xae,0x4a,0xee,0x52,0x00},
    {0x7e,0xea,0x6a,0xfe,0xe0,0x62,0x5e,0x00},
    {0x88,0x3e,0xaa,0x3c,0xb4,0xa8,0xd6,0x00},
    {0x86,0x38,0xa6,0x38,0xb6,0xb4,0xd2,0x00},
    {0xee,0x44,0xfe,0x54,0x7c,0x42,0x3e,0x00},
    {0xe4,0x5e,0x56,0x9e,0x7a,0x74,0x2a,0x00},
    {0x84,0x1e,0x94,0x2a,0xfe,0x28,0xf6,0x00},
    {0xfe,0xaa,0xfe,0x50,0x7e,0x02,0xaa,0x00},
    {0x28,0xfe,0x7c,0x54,0x7c,0x42,0x3e,0x00},
    {0x7e,0x50,0x7c,0x50,0x7e,0x02,0xaa,0x00},
    {0x54,0x76,0xd4,0xf6,0x54,0x76,0x54,0x00},
    {0x08,0x7e,0x7a,0x54,0x6e,0x4c,0xb6,0x00},
    {0x7e,0xdc,0x48,0x5c,0xc8,0x7e,0xc8,0x00},
    {0x54,0xf6,0x54,0x76,0xd4,0x76,0xd4,0x00},
    {0xe8,0xae,0xfa,0xaa,0xea,0x04,0xaa,0x00},
    {0x7e,0xc8,0x48,0xdc,0xea,0x48,0x48,0x00},
    {0xfe,0x10,0x34,0xd2,0x7c,0x54,0xfe,0x00},
    {0xa8,0xbe,0xfa,0x9e,0xec,0xbe,0xa4,0x00},
    {0x28,0xee,0x28,0xfe,0x44,0x7c,0x44,0x00},
    {0xe4,0xbe,0xe4,0xbe,0xf6,0xb6,0xa4,0x00},
    {0x28,0xee,0x28,0xfe,0x54,0xfe,0x10,0x00},
    {0xee,0x42,0xe2,0xee,0xa8,0xea,0xee,0x00},
    {0x28,0x7e,0xd4,0x7e,0x40,0x5c,0x5c,0x00},
    {0x48,0x7e,0xd4,0x7e,0x40,0xdc,0x1c,0x00},
    {0x94,0xbe,0xd4,0xdc,0xfe,0x5c,0xaa,0x00},
    {0x50,0xde,0x6c,0xcc,0xf6,0x5c,0x44,0x00},
    {0x54,0xfe,0x54,0xdc,0xfe,0x5c,0x6a,0x00},
    {0x54,0x7e,0xd4,0xdc,0x7e,0x5c,0xaa,0x00},
    {0xae,0x4a,0xae,0x6a,0xae,0x20,0xd2,0x00},
    {0xfe,0xaa,0xfe,0x7c,0x44,0x7c,0xc6,0x00},
    {0x10,0xfe,0x10,0xfe,0x82,0x28,0xce,0x00},
    {0xe8,0xbe,0xf4,0xbe,0xe0,0x0c,0xac,0x00},
    {0xe8,0xbe,0xd4,0xbe,0xa0,0xdc,0x9c,0x00},
    {0x8c,0x5e,0x00,0xcc,0x40,0x5e,0xbe,0x00},
    {0x4c,0xec,0xae,0xfa,0x56,0x5c,0xe6,0x00},
    {0xfe,0x48,0xea,0x48,0xfe,0xc8,0x48,0x00},
    {0x9a,0xea,0x5a,0xf2,0x5a,0x6a,0x9a,0x00},
    {0x28,0xfe,0x24,0xd6,0x54,0xe4,0x5a,0x00},
    {0x28,0x5e,0xd2,0x5e,0x52,0x52,0x5e,0x00},
    {0x62,0x2a,0xfa,0x2a,0xaa,0x72,0xaa,0x00},
    {0x4a,0x7e,0xdc,0x5c,0x7e,0x54,0x4c,0x00},
    {0x48,0xfe,0x52,0x7e,0xd2,0x52,0xde,0x00},
    {0x48,0xfe,0x52,0xfe,0xd2,0x52,0x5e,0x00},
    {0x88,0x3e,0xa2,0x3e,0xa2,0xa2,0xbe,0x00},
    {0x10,0x7e,0x42,0x7e,0x42,0x42,0x7e,0x00},
    {0x48,0x6e,0xb4,0x08,0xbe,0x22,0xbe,0x00},
    {0xa8,0x5e,0xf2,0x5e,0xf2,0xd2,0x5e,0x00},
    {0x48,0xfe,0xb2,0xbe,0xf2,0xb2,0xbe,0x00},
    {0x28,0xfe,0x9c,0x1c,0xbe,0x14,0x8c,0x00},
    {0x88,0x5e,0x12,0xde,0x52,0x5e,0xbe,0x00},
    {0x1e,0xfe,0xac,0xfe,0xaa,0xdc,0x2a,0x00},
    {0x94,0x3e,0x9c,0x14,0xbe,0x88,0xb6,0x00},
    {0x7e,0x7e,0xd4,0xfe,0x6a,0x5c,0xaa,0x00},
    {0x4a,0xbe,0x5c,0x9c,0x7e,0xd4,0x4c,0x00},
    {0x28,0xfe,0x7c,0x44,0xfe,0x10,0xee,0x00},
    {0xea,0xc4,0xea,0xc0,0xea,0x24,0xba,0x00},
    {0x10,0x7c,0x10,0xfe,0x28,0x50,0xae,0x00},
    {0xfe,0x20,0xb2,0xd6,0xba,0xd6,0xfe,0x00},
    {0x48,0x6e,0xb4,0x2a,0xfe,0x7a,0xae,0x00},
    {0xd4,0x62,0x48,0x94,0x62,0x6c,0x0c,0x00},
    {0x48,0x6e,0xb4,0x18,0xfe,0x34,0xdc,0x00},
    {0xfe,0x5a,0x74,0x8a,0x7c,0xfe,0x10,0x00},
    {0x48,0x6e,0xb4,0x78,0x10,0xfe,0x38,0x00},
    {0x48,0xce,0x78,0xee,0xe0,0x6c,0x5e,0x00},
    {0x7e,0xd4,0xfe,0xdc,0x6a,0x5c,0x5c,0x00},
    {0xfc,0xb4,0xf4,0xb4,0xf4,0xb4,0xa6,0x00},
    {0x5e,0x56,0xf6,0xde,0x56,0x76,0x9e,0x00},
    {0x10,0x3c,0x24,0x7e,0x7e,0x52,0x7e,0x00},
    {0x28,0x28,0x28,0x28,0x44,0x44,0x82,0x00},
    {0x48,0xbe,0xe8,0x5c,0xea,0x7c,0xc8,0x00},
    {0xba,0x14,0xa2,0x1c,0xbe,0x94,0xa6,0x00},
    {0x74,0xaa,0x44,0xba,0x7c,0x28,0xce,0x00},
    {0xfa,0x54,0xe2,0xdc,0xfe,0xd4,0xe6,0x00},
    {0x72,0x44,0xf2,0x7e,0x1c,0x28,0xd6,0x00},
    {0x2a,0x48,0xde,0x48,0x4a,0x44,0x5a,0x00},
    {0xfe,0xaa,0xfe,0x6a,0x0a,0xe2,0xe6,0x00},
    {0x48,0xfe,0x48,0x4c,0xd4,0x68,0xd6,0x00},
    {0x48,0x6e,0xb4,0x46,0xdc,0x44,0x5a,0x00},
    {0xee,0xee,0x82,0xae,0xfa,0xaa,0xb6,0x00},
    {0x44,0xee,0x6e,0x68,0x6e,0xb2,0x0a,0x00},
    {0x12,0xfc,0xe8,0xde,0xfa,0x3a,0x52,0x00},
    {0x48,0x7e,0xd4,0x5c,0x7e,0xe2,0x2a,0x00},
    {0x44,0xea,0xae,0xe0,0x4e,0x6a,0xce,0x00},
    {0x28,0x3e,0x68,0xbe,0x10,0xfe,0x10,0x00},
    {0x24,0x56,0xc4,0x5e,0x44,0x5e,0x44,0x00},
    {0x22,0xaa,0x22,0xfa,0x22,0xfa,0x26,0x00},
    {0x10,0x54,0x10,0x7c,0x10,0xfe,0x10,0x00},
    {0x7e,0x40,0x7c,0x54,0x54,0x48,0xb6,0x00},
    {0xbe,0x50,0xfe,0x5a,0xfa,0x54,0x9a,0x00},
    {0x5c,0xd4,0xd4,0xdc,0x54,0x54,0x66,0x00},
    {0x56,0xfa,0x68,0x6e,0xfa,0x6c,0xea,0x00},
    {0xd6,0x7c,0x4c,0xee,0x54,0x54,0xee,0x00},
    {0x5e,0xf0,0x5e,0xfa,0xda,0x54,0x6a,0x00},
    {0xbc,0x24,0xa4,0x2c,0xa0,0xa2,0x9e,0x00},
    {0xbc,0x24,0xb4,0x2c,0xa4,0xa4,0xc6,0x00},
    {0xbe,0xb0,0xfe,0x9a,0xfa,0xb4,0xaa,0x00},
    {0xbe,0x52,0xb2,0x76,0xb0,0x32,0xde,0x00},
    {0xe6,0x4c,0x6c,0xee,0x4c,0xd4,0x2e,0x00},
    {0x04,0xf6,0xe4,0xfe,0xe4,0xfe,0x04,0x00},
    {0x86,0xfa,0x74,0xea,0x7c,0x10,0x92,0x00},
    {0x2e,0x7a,0x50,0x5e,0xfa,0x54,0x9a,0x00},
    {0x28,0xfe,0x9c,0x3e,0x94,0x2e,0x8c,0x00},
    {0xfe,0xb0,0xfe,0xba,0xfa,0x14,0xaa,0x00},
    {0x48,0x6e,0xb4,0xfe,0x6a,0xf8,0x2e,0x00},
    {0x0e,0xf0,0x54,0xfe,0x10,0x38,0xd6,0x00},
    {0x5e,0x48,0xfe,0xd2,0x5e,0x60,0x92,0x00},
    {0x5e,0x54,0x8e,0x7a,0x5e,0x50,0xba,0x00},
    {0x5e,0xb0,0x5e,0xfa,0xfa,0x94,0xea,0x00},
    {0x4c,0xd4,0x7e,0x6a,0xfe,0x54,0xe6,0x00},
    {0x0c,0xf4,0xbe,0xea,0xbe,0xd4,0x26,0x00},
    {0xfe,0x54,0xfe,0x38,0xd6,0x7c,0x7c,0x00},
    {0x6e,0x6a,0xf4,0xaa,0x7c,0x54,0xfe,0x00},
    {0x6e,0x6a,0xf4,0xaa,0xfe,0x64,0xbc,0x00},
    {0x28,0xfe,0x54,0xfe,0x54,0xba,0x38,0x00},
    {0x10,0xfe,0x28,0xba,0x38,0x14,0xfa,0x00},
    {0xfe,0x94,0xf6,0x94,0xf6,0xa4,0xfe,0x00},
    {0x10,0x7c,0x54,0x7c,0x28,0xfe,0x08,0x00},
    {0xfe,0x10,0x34,0xd2,0x7c,0x44,0x7c,0x00},
    {0x2e,0x22,0xf2,0x5e,0x68,0x3a,0xce,0x00},
    {0x08,0x7e,0x40,0x64,0x76,0x64,0xb6,0x00},
    {0x48,0xbe,0x6a,0xfc,0x74,0x68,0x56,0x00},
    {0x28,0xee,0x28,0xee,0x28,0xc2,0xba,0x00},
    {0xfe,0x44,0x7c,0x76,0x54,0x76,0xa4,0x00},
    {0x54,0xf4,0x5e,0x74,0xd4,0x5c,0xd6,0x00},
    {0x48,0xfe,0x6a,0x7c,0xf4,0x68,0xd6,0x00},
    {0x28,0xee,0x28,0xfe,0x28,0x10,0xee,0x00},
    {0x48,0x48,0x7a,0x4c,0x48,0x7a,0xce,0x00},
    {0x90,0x0a,0x92,0x34,0xba,0x90,0xae,0x00},
    {0x08,0x7e,0xc4,0x5e,0xda,0x54,0xaa,0x00},
    {0x08,0x7e,0x4a,0x7c,0x54,0x48,0xb6,0x00},
    {0xe8,0x5e,0x5a,0x9e,0x6c,0x7e,0x04,0x00},
    {0xd0,0x4a,0xd2,0x74,0xfa,0xd0,0x6e,0x00},
    {0x54,0xb6,0x54,0xb6,0x54,0xf6,0x54,0x00},
    {0xfe,0xaa,0xfe,0x54,0xf6,0x74,0x56,0x00},
    {0xfe,0xaa,0xea,0xbe,0xe0,0xa2,0xbe,0x00},
    {0x44,0xfe,0x36,0x5e,0xfa,0x74,0x5a,0x00},
    {0x94,0xf6,0x14,0xb6,0x14,0xf6,0xd4,0x00},
    {0x28,0xfe,0x2a,0xfe,0xc4,0x7c,0xc6,0x00},
    {0xb4,0x3e,0x2a,0xf4,0x7e,0x44,0xbe,0x00},
    {0x28,0xee,0x28,0xee,0x28,0xee,0x48,0x00},
    {0xfc,0x54,0xd2,0x7c,0xd6,0x54,0x92,0x00},
    {0x6c,0xc4,0x4e,0xfe,0xda,0x50,0x6e,0x00},
    {0x48,0x6e,0xb4,0x5e,0xfa,0x14,0xaa,0x00},
    {0x54,0x7e,0xd4,0xfe,0x60,0x6e,0x4a,0x00},
    {0x7e,0x7e,0x4c,0x78,0x4e,0x78,0x8e,0x00},
    {0x54,0xbe,0x7e,0xc6,0x7e,0x54,0x6a,0x00},
    {0x54,0xf4,0x5e,0xf4,0xd4,0x5c,0x56,0x00},
    {0x7c,0x54,0x7c,0x48,0x6e,0x48,0xee,0x00},
    {0xee,0x44,0xee,0x48,0x6e,0x48,0xee,0x00},
    {0x7e,0x4a,0x7e,0x52,0x5e,0x52,0x9e,0x00},
    {0x24,0xfe,0x7c,0x10,0xfe,0x10,0xee,0x00},
    {0x10,0x38,0x28,0x7c,0x54,0xfe,0x48,0x00},
    {0x4c,0xd4,0x48,0xf6,0xc8,0x40,0x4c,0x00},
    {0xc8,0x7e,0xea,0x7e,0xd4,0xfe,0x44,0x00},
    {0xfe,0xa8,0xa8,0xaa,0xce,0x80,0xfe,0x00},
    {0xfe,0x12,0x10,0x5c,0x50,0x50,0xbe,0x00},
    {0x72,0x44,0xf2,0x64,0x36,0xa4,0xf6,0x00},
    {0x10,0xfe,0x24,0x7e,0x58,0x42,0x9c,0x00},
    {0xe8,0xbe,0xe8,0xb4,0xea,0xbc,0xaa,0x00},
    {0x28,0xfe,0x38,0xfc,0x6e,0x98,0x66,0x00},
    {0xe4,0xbe,0xe4,0xb4,0xec,0xa4,0xac,0x00},
    {0xc6,0x7a,0xd6,0xbc,0xee,0x7a,0xc6,0x00},
    {0x20,0x14,0x24,0xaa,0xb2,0x20,0xde,0x00},
    {0x7c,0x54,0x7c,0xfe,0x54,0xfe,0x10,0x00},
    {0x48,0x6e,0xb4,0x7e,0x14,0xfe,0x10,0x00},
    {0xbe,0x54,0x1c,0xc0,0x7e,0x6a,0xbe,0x00},
    {0x48,0xd4,0x6e,0xc0,0xfe,0x54,0x7a,0x00},
    {0x5e,0x54,0xfe,0xb2,0xde,0x74,0x9e,0x00},
    {0x86,0xb8,0xea,0xde,0xca,0x54,0xaa,0x00},
    {0x7c,0x94,0x54,0xbe,0x54,0xd4,0x7e,0x00},
    {0xfe,0x10,0x7c,0x44,0x7c,0x44,0x7c,0x00},
    {0xb6,0xd2,0x08,0xd4,0x2a,0xc4,0xd8,0x00},
    {0x28,0x7e,0xc8,0x7c,0x5a,0x74,0x5a,0x00},
    {0x22,0x34,0xe2,0xb4,0x82,0xb4,0xde,0x00},
    {0x7e,0xdc,0x5c,0xc0,0xfe,0x48,0x6a,0x00},
    {0x50,0x12,0xf4,0x38,0x54,0x92,0x30,0x00},
    {0xbe,0x1c,0x9c,0x00,0xbe,0x88,0xaa,0x00},
    {0xf2,0x6c,0x7a,0x1a,0xfa,0x2a,0xb2,0x00},
    {0xfe,0x54,0x7c,0x00,0xfe,0x54,0xb2,0x00},
    {0x10,0x7c,0x10,0xfc,0x2a,0xe4,0x32,0x00},
    {0xbe,0xc8,0x2a,0xc8,0x3e,0xc8,0xc8,0x00},
    {0x28,0xce,0x72,0xaa,0x66,0xa2,0x46,0x00},
    {0x08,0x7e,0x70,0x6e,0x7a,0x7e,0xaa,0x00},
    {0x54,0xfe,0x54,0x7e,0xfe,0x6a,0xfe,0x00},
    {0x08,0x7e,0xdc,0x7e,0xea,0x76,0xa2,0x00},
    {0xc8,0x5c,0xda,0x68,0xca,0xc4,0x58,0x00},
    {0x28,0xfe,0x28,0x7c,0x7c,0x54,0x7c,0x00},
    {0x54,0xbe,0xd4,0x7e,0xfe,0x6a,0xfe,0x00},
    {0x44,0xb8,0xde,0x54,0xfe,0x40,0xe2,0x00},
    {0x28,0xfe,0x66,0xee,0x44,0xee,0x44,0x00},
    {0x5e,0xe8,0xbe,0xe4,0x4e,0x64,0xde,0x00},
    {0x6a,0xbc,0x6e,0x74,0x66,0x0e,0xae,0x00},
    {0x7c,0x44,0x7c,0x00,0xee,0xaa,0xee,0x00},
    {0x52,0xfc,0x52,0xfc,0xf8,0x52,0x54,0x00},
    {0x5a,0xe4,0x3e,0xa4,0x54,0x5c,0xba,0x00},
    {0x84,0x18,0x9e,0x14,0xbe,0x80,0xa2,0x00},
    {0xae,0x34,0xae,0x7a,0xae,0x90,0xea,0x00},
    {0x28,0x44,0xbe,0x14,0x3c,0x3c,0xc6,0x00},
    {0x10,0xfe,0xba,0x54,0x78,0x38,0xc6,0x00},
    {0x2e,0xb4,0xae,0xfa,0xbe,0x20,0xca,0x00},
    {0x84,0xf6,0x6a,0x6a,0xba,0xe4,0x2a,0x00},
    {0xbe,0x50,0xfc,0x74,0xfc,0x74,0xba,0x00},
    {0xfe,0x10,0x10,0x34,0xd2,0x10,0x10,0x00},
    {0x24,0x5e,0xc4,0x54,0x4c,0x44,0x4c,0x00},
    {0x48,0x5c,0xf4,0x5e,0x52,0xfe,0x08,0x00},
    {0x10,0x7c,0x10,0xfe,0x10,0x28,0xc6,0x00},
    {0x5c,0x44,0xfe,0xaa,0xdc,0x7c,0x88,0x00},
    {0x10,0xfe,0xaa,0x38,0x7c,0x54,0x7c,0x00},
    {0xfe,0xba,0x28,0x38,0x7c,0x54,0x7c,0x00},
    {0x20,0xfe,0x28,0x7e,0xaa,0x2a,0x08,0x00},
    {0x08,0x7e,0x52,0x5e,0x72,0x5a,0x96,0x00},
    {0x50,0xfe,0xd0,0x64,0x5e,0x56,0x44,0x00},
    {0x48,0xdc,0x48,0x7e,0xc8,0x54,0xe2,0x00},
    {0x24,0xf6,0x6a,0x6a,0xfa,0x54,0xaa,0x00},
    {0x28,0xc6,0x38,0xc6,0x7c,0x48,0x88,0x00},
    {0x24,0xfe,0x6c,0x28,0xfe,0x44,0x7c,0x00},
    {0x8e,0x34,0x80,0x1c,0x84,0xbe,0x88,0x00},
    {0x28,0xc6,0x28,0x28,0x10,0x28,0xc6,0x00},
    {0x48,0x6e,0xb4,0x5e,0xc4,0x54,0x4c,0x00},
    {0x08,0x7e,0x54,0x6c,0x7e,0x6a,0xb6,0x00},
    {0x08,0x0e,0x78,0x5e,0x5e,0x5e,0x92,0x00},
    {0x28,0xfe,0x10,0x7c,0xfe,0x10,0xee,0x00},
    {0x94,0xfe,0x14,0xb6,0x14,0xfe,0xdc,0x00},
    {0x38,0xc8,0x7c,0x44,0x7c,0x7c,0xc6,0x00},
    {0xf6,0xc4,0xfe,0xd4,0xdc,0x34,0xba,0x00},
    {0x24,0xf4,0x26,0xf4,0x74,0x60,0x9e,0x00},
    {0x10,0x78,0x48,0x7c,0x44,0xfe,0x10,0x00},
    {0xea,0xb6,0xd2,0xba,0xb2,0xd2,0x96,0x00},
    {0x30,0x5e,0xec,0x4c,0x76,0x5c,0x44,0x00},
    {0x60,0xfe,0x54,0x7e,0xd4,0x7e,0xea,0x00},
    {0x6a,0x08,0xfe,0x28,0x74,0x64,0xf2,0x00},
    {0x80,0xfe,0x54,0xfe,0x54,0xbe,0x44,0x00},
    {0x28,0xfe,0x7e,0x92,0x7a,0x7a,0x5a,0x00},
    {0x28,0xfe,0x40,0xfe,0x54,0xfe,0xaa,0x00},
    {0x2e,0xfa,0x5c,0xfa,0x0a,0x6c,0x68,0x00},
    {0x22,0x7e,0x22,0xfa,0x66,0x32,0xc6,0x00},
    {0x7e,0xea,0x7e,0xfe,0xea,0x6e,0x5a,0x00},
    {0x7c,0x54,0x7c,0x7c,0x54,0x5c,0xb6,0x00},
    {0x28,0xfe,0x44,0xfe,0x24,0xfe,0x04,0x00},
    {0x28,0xfe,0xec,0xb4,0x48,0xf6,0xdc,0x00},
    {0x2a,0x48,0xfe,0x48,0x48,0x54,0x62,0x00},
    {0xfa,0x56,0x76,0x06,0xfa,0xaa,0xfa,0x00},
    {0x50,0x9e,0x6c,0xcc,0x54,0x48,0x76,0x00},
    {0x7e,0xd4,0xdc,0xc0,0x7e,0x6a,0x7e,0x00},
    {0x7e,0x52,0x70,0x5e,0x7a,0x54,0xba,0x00},
    {0x5e,0xec,0x2c,0x40,0xfe,0x56,0x5e,0x00},
    {0xf0,0xbe,0xec,0xac,0xf4,0xa8,0xb6,0x00},
    {0x50,0xfe,0x2c,0x4c,0xf4,0x68,0x56,0x00},
    {0xfe,0x54,0x7c,0x8c,0x54,0xc8,0x76,0x00},
    {0xaa,0x2a,0xbe,0x22,0xbe,0xaa,0xca,0x00},
    {0x28,0xfe,0x3e,0xe8,0xfe,0x2a,0xc8,0x00},
    {0x48,0xe8,0x48,0x68,0xd0,0x54,0xfa,0x00},
    {0x94,0x3e,0x9e,0x34,0xbe,0x96,0xa4,0x00},
    {0x28,0x48,0xc8,0x48,0x50,0x54,0x7a,0x00},
    {0xd0,0xde,0xee,0x4e,0xd6,0x6a,0x56,0x00},
    {0x6a,0xb6,0x72,0x7a,0x72,0x12,0xb6,0x00},
    {0x28,0x28,0x44,0xbe,0x14,0x24,0xcc,0x00},
    {0x10,0xfe,0xae,0xae,0xb6,0xea,0x16,0x00},
    {0x08,0xfe,0xd4,0xfe,0xd4,0x1c,0x22,0x00},
    {0x48,0x7e,0xd4,0x7e,0x54,0xdc,0x22,0x00},
    {0x48,0xfe,0xd4,0x7e,0x54,0x5c,0x62,0x00},
    {0x54,0xd4,0x62,0x5c,0xd4,0x54,0xec,0x00},
    {0x24,0xfe,0x6c,0xb6,0x54,0x28,0xc6,0x00},
    {0x10,0xfe,0x74,0xba,0x7c,0x54,0x7c,0x00},
    {0xb4,0x54,0xe2,0x5c,0xd4,0xd4,0x6c,0x00},
    {0x54,0xfe,0x54,0xba,0x38,0xfe,0x44,0x00},
    {0x54,0x94,0x62,0x9c,0x54,0xd4,0x6c,0x00},
    {0x38,0xfe,0xb6,0x44,0xbe,0x14,0x6c,0x00},
    {0x10,0xfe,0x28,0x28,0x10,0x28,0xc6,0x00},
    {0xee,0xee,0x82,0xfe,0xba,0xfa,0x8a,0x00},
    {0xfe,0x10,0xfe,0x92,0xaa,0xc2,0x86,0x00},
    {0x34,0x40,0xfe,0x54,0x7e,0x54,0x64,0x00},
    {0x0c,0x70,0x7c,0x48,0xfe,0x00,0xc6,0x00},
    {0x7e,0x62,0xfe,0x74,0x6c,0xfe,0x14,0x00},
    {0x96,0x6a,0xf4,0xaa,0x7c,0x54,0x10,0x00},
    {0xfe,0x54,0x38,0x10,0xfe,0x10,0x10,0x00},
    {0x96,0x6a,0xf4,0xaa,0xfe,0x28,0x48,0x00},
    {0x7e,0xc8,0x7e,0xea,0xf6,0x62,0x66,0x00},
    {0x24,0xfe,0x28,0x6a,0x6c,0x28,0xfe,0x00},
    {0x28,0xfe,0x94,0x66,0xda,0xb4,0xda,0x00},
    {0xee,0xaa,0xee,0x92,0xfa,0xb2,0xd6,0x00},
    {0xe4,0xf6,0xa4,0xf6,0xdc,0x88,0xbe,0x00},
    {0x54,0x38,0xfe,0x10,0x38,0xd6,0x10,0x00},
    {0xfe,0x10,0x7c,0x7c,0x44,0x7c,0xc6,0x00},
    {0x24,0x7e,0xfa,0x6e,0x74,0x7e,0x44,0x00},
    {0x64,0x7e,0x4a,0xfe,0x64,0x10,0xfe,0x00},
    {0x08,0x7e,0xf4,0x7e,0xea,0x7e,0xb4,0x00},
    {0xe4,0x4e,0xea,0x4e,0xfe,0x64,0xbc,0x00},
    {0xf2,0x9a,0xfa,0x4a,0x72,0x52,0xb6,0x00},
    {0x96,0x6a,0xf4,0xaa,0x7c,0x7c,0x7c,0x00},
    {0x28,0xfe,0x54,0x7e,0x4a,0x64,0x8a,0x00},
    {0x48,0x6e,0xbc,0x54,0x6c,0x48,0xee,0x00},
    {0x3e,0x54,0xdc,0x50,0x5e,0x6e,0x4a,0x00},
    {0x10,0xfe,0x28,0xba,0x68,0x10,0xee,0x00},
    {0x48,0x48,0x7e,0x40,0x7c,0x44,0x84,0x00},
    {0x48,0x6e,0xb4,0x7c,0x7c,0x5e,0x96,0x00},
    {0x7e,0x94,0x5c,0x90,0x5e,0xee,0x4a,0x00},
    {0xbe,0x4a,0x0a,0xd2,0x66,0x40,0xbe,0x00},
    {0x9e,0x50,0x1e,0xda,0x54,0x6a,0xbe,0x00},
    {0xbe,0x5c,0x10,0xde,0x6e,0x4a,0xbe,0x00},
    {0x3e,0x5c,0xdc,0x48,0x58,0x48,0x76,0x00},
    {0x64,0xae,0xf6,0xb6,0xfa,0x6a,0xbe,0x00},
    {0x4c,0x54,0xfe,0xba,0xde,0x6c,0x96,0x00},
    {0x10,0x24,0xfa,0x28,0xfe,0x28,0x48,0x00},
    {0xae,0xf4,0xfe,0x5e,0xfc,0xf4,0x5a,0x00},
    {0x3c,0x54,0xdc,0x48,0x7e,0x5c,0x6a,0x00},
    {0x4a,0xbe,0x48,0xfe,0x2a,0xfe,0xea,0x00},
    {0x4a,0xbe,0xc8,0x7e,0xea,0x7e,0xea,0x00},
    {0xfe,0x96,0xfe,0xba,0xba,0xaa,0xfe,0x00},
    {0x4a,0xfe,0x48,0x7e,0xea,0x7e,0xea,0x00},
    {0x10,0x5c,0x50,0xfe,0x54,0x9a,0x70,0x00},
    {0x14,0x7e,0x10,0x7e,0x52,0x7e,0x52,0x00},
    {0x4a,0xfe,0x28,0x5e,0xfa,0x7e,0x5a,0x00},
    {0xca,0x7e,0xc8,0xfe,0x6a,0xfe,0x6a,0x00},
    {0xc8,0x7e,0xdc,0x5c,0xdc,0xf2,0x6e,0x00},
    {0x28,0xfe,0x38,0xfe,0x7c,0xaa,0x58,0x00},
    {0x28,0xfe,0x38,0xfe,0x44,0x92,0x38,0x00},
    {0x28,0xfe,0x38,0xfe,0x44,0x20,0xaa,0x00},
    {0x0a,0x7e,0x48,0x48,0x4a,0x44,0x9a,0x00},
    {0x28,0xfe,0x38,0xfe,0x44,0xba,0x38,0x00},
    {0x3c,0x34,0x24,0xfe,0x54,0x7e,0x0c,0x00},
    {0x48,0x6e,0xb4,0x1c,0xbe,0x14,0x8c,0x00},
    {0x28,0xfe,0x7c,0x28,0xfe,0x44,0x7c,0x00},
    {0x54,0x7e,0xd6,0xde,0x5e,0x6c,0x6a,0x00},
    {0x28,0x5c,0xfe,0x54,0x6a,0x5c,0x48,0x00},
    {0x40,0x7e,0xba,0x0a,0x7a,0x40,0x7e,0x00},
    {0x7c,0x44,0x7c,0x10,0xfe,0x38,0xd6,0x00},
    {0x2e,0x7a,0xf8,0x5e,0xfa,0x74,0x2a,0x00},
    {0x10,0x7c,0x38,0xfe,0x54,0xba,0x10,0x00},
    {0x10,0xfe,0xba,0x10,0x38,0x14,0xfe,0x00},
    {0x4c,0x54,0x48,0xf6,0xc8,0xfe,0x08,0x00},
    {0x92,0xfe,0x68,0x38,0xd6,0x38,0x10,0x00},
    {0x92,0xfe,0x7e,0x5a,0x7e,0x5a,0xb6,0x00},
    {0x08,0x7e,0x5e,0x6a,0x5a,0x50,0x9e,0x00},
    {0x50,0xde,0x7a,0x4a,0xda,0x50,0xde,0x00},
    {0x48,0xdc,0x7e,0x54,0xea,0x5c,0xc8,0x00},
    {0x24,0xf6,0x4a,0x7a,0x5a,0x54,0xba,0x00},
    {0x10,0xfe,0x20,0x3c,0x24,0x44,0x8c,0x00},
    {0x7e,0x5a,0x7e,0x5a,0x7e,0x5a,0xb6,0x00},
    {0x88,0x1c,0x88,0x3e,0x88,0x94,0xba,0x00},
    {0x90,0x1e,0xba,0x0a,0x9a,0x90,0x9e,0x00},
    {0x10,0xfe,0x44,0x7c,0x08,0x00,0xaa,0x00},
    {0xe8,0x4e,0x56,0x82,0x6e,0x68,0x0e,0x00},
    {0x56,0x8a,0x44,0xba,0x5e,0xd4,0x6e,0x00},
    {0xe8,0xae,0xf6,0xa2,0xee,0xa8,0xae,0x00},
    {0x28,0xfe,0x10,0xfe,0x20,0x3c,0xc4,0x00},
    {0x28,0xfe,0xaa,0xee,0xaa,0xee,0x12,0x00},
    {0x28,0xfe,0x4c,0x34,0xda,0x48,0xbe,0x00},
    {0x4c,0xf4,0xa8,0xf6,0x48,0x7e,0xc8,0x00},
    {0x10,0xfe,0x54,0xdc,0x2a,0xe4,0x32,0x00},
    {0x88,0xfe,0x10,0xde,0x12,0xd2,0xe6,0x00},
    {0x28,0x7c,0x7c,0xc6,0x7c,0x28,0xfe,0x00},
    {0x2e,0xfa,0x2c,0xfa,0x2a,0xfc,0x48,0x00},
    {0x4c,0xb4,0xc8,0x76,0xc8,0x7e,0xc8,0x00},
    {0x48,0xae,0x56,0xe2,0xee,0x88,0xee,0x00},
    {0x7c,0x54,0x74,0x74,0x7c,0x4c,0xae,0x00},
    {0xf4,0xbe,0xfe,0xb8,0xfe,0xb2,0xba,0x00},
    {0x7c,0x10,0x7c,0x08,0x50,0x60,0x9e,0x00},
    {0x10,0xfe,0x40,0x40,0x40,0x40,0x3e,0x00},
    {0x28,0x7e,0xd4,0x7e,0x6a,0x4c,0x54,0x00},
    {0x22,0xfa,0x5a,0xfa,0x02,0x72,0x76,0x00},
    {0x44,0x5e,0xe8,0x4e,0x6a,0xca,0x16,0x00},
    {0x44,0x5e,0xe8,0xae,0xca,0x6a,0x96,0x00},
    {0x7e,0xe2,0xfe,0xd4,0x5c,0x54,0x5c,0x00},
    {0x10,0xfe,0x40,0x7c,0x54,0xca,0xba,0x00},
    {0x48,0xfe,0xd0,0x50,0x50,0x50,0x4e,0x00},
    {0xfe,0x44,0x7c,0x48,0x7e,0x54,0xac,0x00},
    {0x7c,0x7c,0x28,0xfe,0x54,0x38,0xd6,0x00},
    {0x2e,0xfa,0x4e,0x72,0xfe,0x10,0xfe,0x00},
    {0x28,0xfe,0x28,0x38,0xfe,0x38,0xd6,0x00},
    {0x48,0xdc,0x7e,0xd4,0xea,0x5c,0x48,0x00},
    {0xfe,0x82,0xfe,0x44,0x7c,0x44,0x7c,0x00},
    {0x44,0x9e,0x48,0xae,0x4a,0xea,0x56,0x00},
    {0xe4,0xbe,0xe8,0xae,0xea,0xaa,0xb6,0x00},
    {0xea,0xbc,0xea,0xbc,0xf8,0xaa,0xbc,0x00},
    {0x94,0xfe,0x14,0xdc,0x3e,0xdc,0xea,0x00},
    {0x28,0xde,0x72,0xbe,0x72,0xac,0x56,0x00},
    {0x2e,0xc6,0xea,0x7c,0x44,0x7c,0xc6,0x00},
    {0x48,0xb2,0xfe,0x5c,0xe8,0x7e,0xc8,0x00},
    {0xe4,0xbe,0xc8,0xae,0xaa,0xca,0x96,0x00},
    {0x0a,0xe8,0xbe,0xa8,0xe8,0x14,0x22,0x00},
    {0x2e,0xf4,0x2e,0xba,0xfe,0x20,0xda,0x00},
    {0x28,0x28,0xea,0x2c,0x68,0xaa,0x2e,0x00},
    {0x2a,0x7e,0xd4,0x7e,0x5c,0x48,0x76,0x00},
    {0x20,0x20,0x30,0x28,0x24,0x20,0x20,0x00},
    {0x7c,0x54,0xfe,0x00,0xaa,0x10,0xfe,0x00},
    {0x6a,0xfe,0x54,0x7e,0xdc,0x48,0xf6,0x00},
    {0x28,0xf8,0x28,0x7c,0x6a,0xa8,0x28,0x00},
    {0xd0,0xde,0xf4,0x54,0xd4,0x48,0x76,0x00},
    {0xe8,0xbc,0xfe,0xb4,0xe6,0xa8,0xfe,0x00},
    {0xc8,0x5c,0xdc,0x6a,0xcc,0xc2,0x5c,0x00},
    {0x20,0x5e,0xfa,0x2a,0xfa,0x7a,0xee,0x00},
    {0x24,0x6e,0xf6,0x96,0x26,0xfa,0x6a,0x00},
    {0x9c,0x14,0xa6,0x1c,0x54,0x88,0xb6,0x00},
    {0xe8,0x48,0x74,0xba,0x60,0x5c,0x9c,0x00},
    {0x7e,0x62,0xfe,0x6e,0x64,0xd6,0x1e,0x00},
    {0x5c,0xdc,0xea,0xc8,0x7e,0x54,0x66,0x00},
    {0x10,0xfe,0x28,0xd6,0x38,0xfe,0x48,0x00},
    {0x10,0xfe,0x10,0x38,0x54,0xba,0x10,0x00},
    {0xfe,0x6a,0xfe,0x6a,0xbe,0x7e,0x6a,0x00},
    {0x7c,0x44,0x64,0x54,0x54,0x44,0x86,0x00},
    {0x28,0x44,0xbe,0x14,0x7c,0x54,0xfe,0x00},
    {0x08,0x7e,0x54,0x7e,0x54,0x7e,0x98,0x00},
    {0x08,0x7e,0x54,0x7e,0x54,0x5e,0xac,0x00},
    {0x08,0x7e,0x54,0x7e,0x5c,0x5c,0xa6,0x00},
    {0x08,0x7e,0x54,0x7e,0x54,0x7e,0x94,0x00},
    {0x7e,0x6a,0xfe,0x6a,0x7e,0xc8,0x3e,0x00},
    {0x48,0x5c,0xe8,0xbe,0xc8,0x5c,0xaa,0x00},
    {0x08,0xfc,0xa8,0xfe,0xa8,0xfc,0x2a,0x00},
    {0x50,0xde,0x74,0xd4,0xd4,0x48,0x76,0x00},
    {0x40,0x7e,0xb4,0xfe,0x54,0x7e,0x0c,0x00},
    {0x3e,0xea,0xbe,0xaa,0xfe,0x08,0x3e,0x00},
    {0x48,0xfe,0x5c,0xdc,0xfe,0x40,0x62,0x00},
    {0x28,0xfe,0x38,0xfe,0x56,0xbc,0x34,0x00},
    {0xea,0xbe,0xec,0xac,0xfe,0xa4,0xba,0x00},
    {0x48,0xfe,0x6a,0xcc,0xcc,0x54,0x66,0x00},
    {0x68,0xbe,0x68,0x6e,0x7a,0x0e,0xaa,0x00},
    {0x5e,0xe4,0x44,0xf6,0xd4,0x54,0x7e,0x00},
    {0xd4,0x7e,0xf6,0xe2,0xfe,0x14,0xac,0x00},
    {0x52,0xde,0x6a,0xda,0xce,0x52,0x62,0x00},
    {0x10,0xfe,0x28,0x6c,0x6a,0xaa,0x58,0x00},
    {0x3c,0x54,0xfe,0x48,0x5c,0x48,0x76,0x00},
    {0x7c,0x04,0x24,0x28,0x10,0x28,0xc6,0x00},
    {0x48,0xfe,0x48,0x5c,0xc8,0x5c,0xea,0x00},
    {0x10,0xfe,0x10,0x7c,0x10,0x38,0xd6,0x00},
    {0x88,0x3e,0x88,0x1c,0x48,0x9c,0xaa,0x00},
    {0x90,0x1e,0x2c,0xc8,0x52,0x4e,0xbe,0x00},
    {0x3e,0x52,0xde,0x54,0x6a,0x40,0x4c,0x00},
    {0x28,0xfe,0x28,0xfe,0xb6,0xde,0xb6,0x00},
    {0x08,0x7e,0x54,0x7e,0x54,0x7e,0xbe,0x00},
    {0xfe,0x20,0x3c,0x24,0x24,0x44,0x8c,0x00},
    {0x5c,0xd4,0xfe,0x7e,0x54,0x48,0x76,0x00},
    {0x94,0x3e,0x94,0x3e,0xaa,0xbe,0xa2,0x00},
    {0x9c,0x14,0xbe,0x3e,0x94,0x88,0xb6,0x00},
    {0x28,0xfe,0x38,0x7c,0x6c,0x10,0xee,0x00},
    {0x08,0xfc,0xa8,0xbe,0xe8,0x1c,0x2a,0x00},
    {0x10,0x7c,0x10,0xfe,0x10,0x38,0xd6,0x00},
    {0x48,0xfc,0xe8,0xfe,0x5c,0x6a,0xbe,0x00},
    {0xfc,0x84,0x84,0xfc,0x80,0x82,0x7e,0x00},
    {0x48,0x6e,0xb4,0x7c,0x28,0xfe,0x44,0x00},
    {0x7e,0x6a,0x7e,0xea,0xfe,0xe8,0x08,0x00},
    {0x10,0xfe,0xaa,0x60,0xba,0x54,0x7c,0x00},
    {0x10,0xfe,0xaa,0x7c,0xb8,0x14,0xfa,0x00},
    {0x88,0x3e,0x9c,0x7e,0xaa,0xc8,0x94,0x00},
    {0x28,0xfe,0x38,0xee,0x38,0xe8,0x36,0x00},
    {0xc8,0x54,0xee,0x5c,0xc4,0xf2,0x6e,0x00},
    {0xe6,0xb8,0xe6,0xb8,0xf6,0xb4,0xb2,0x00},
    {0x48,0x5c,0xfa,0xa8,0xca,0x64,0x98,0x00},
    {0xa2,0x5c,0xe6,0x5c,0xe6,0xdc,0x46,0x00},
    {0x7c,0x44,0x7c,0x50,0x7e,0x48,0xe6,0x00},
    {0xfe,0xb2,0xfe,0xb4,0xfe,0xb4,0xfa,0x00},
    {0xe8,0x2e,0x54,0xea,0x7e,0xaa,0x76,0x00},
    {0x28,0xfe,0x54,0xfe,0xba,0x18,0x70,0x00},
    {0x80,0xfe,0x54,0xfe,0x54,0xfe,0xaa,0x00},
    {0x10,0x24,0xfa,0x3c,0x50,0xfe,0x10,0x00},
    {0x7c,0x14,0x08,0xfe,0x2a,0xc8,0x18,0x00},
    {0x38,0xfe,0xb6,0x6c,0xfa,0x66,0xaa,0x00},
    {0xd4,0x2e,0xfe,0x28,0xae,0xe2,0xda,0x00},
    {0x48,0xfe,0x54,0xdc,0xc8,0x6a,0x58,0x00},
    {0x5e,0x4a,0xec,0xb6,0xca,0x6e,0x8a,0x00},
    {0x48,0x5e,0xf2,0xbe,0xde,0x74,0x9a,0x00},
    {0xfe,0xba,0x28,0x38,0xfe,0x00,0xc6,0x00},
    {0x3c,0x24,0x58,0x10,0x3e,0xd2,0x1e,0x00},
    {0x10,0x28,0xde,0x00,0xee,0xea,0x08,0x00},
    {0xee,0xaa,0xee,0xaa,0xee,0x12,0x26,0x00},
    {0xee,0xaa,0xee,0x12,0x7c,0x54,0xfe,0x00},
    {0xaa,0x08,0x3e,0xdc,0x6a,0x48,0xbe,0x00},
    {0x4e,0xaa,0xf4,0x48,0xfe,0x6a,0xce,0x00},
    {0x08,0xdc,0xdc,0xd0,0xde,0x02,0x2a,0x00},
    {0x5e,0x48,0xfe,0xa4,0xce,0x64,0x9e,0x00},
    {0x68,0x78,0xaa,0x3c,0xe8,0x2a,0x2e,0x00},
    {0x84,0x7e,0xfc,0x54,0xfe,0xd4,0xaa,0x00},
    {0x38,0xc8,0x7c,0x54,0x7c,0x2a,0xce,0x00},
    {0x48,0xdc,0x54,0xdc,0xfe,0x6a,0x48,0x00},
    {0x48,0x9c,0x54,0x9c,0x7e,0xea,0x48,0x00},
    {0x5e,0x88,0x5e,0xb6,0x5e,0xf6,0x5e,0x00},
    {0xfe,0x10,0xfe,0xaa,0xba,0xaa,0xfe,0x00},
    {0x5e,0xe8,0x5e,0x76,0xbe,0x56,0xbe,0x00},
    {0x54,0xfe,0x5c,0x54,0xfe,0x48,0xf6,0x00},
    {0x54,0xfe,0x5c,0xd4,0xfe,0x48,0x76,0x00},
    {0x28,0xfe,0x28,0x7e,0x4a,0x44,0x9a,0x00},
    {0x10,0xfe,0x40,0x7c,0xfe,0x28,0xf6,0x00},
    {0x7c,0x08,0xfe,0x10,0x7c,0x54,0xfe,0x00},
    {0x0c,0x70,0x1e,0xf0,0x1e,0xf0,0x1e,0x00},
    {0xac,0x44,0xfe,0x48,0xdc,0x5c,0xbe,0x00},
    {0x10,0xfe,0x40,0x7c,0x7c,0x44,0x7c,0x00},
    {0x7e,0xa2,0x76,0xfe,0x6a,0xee,0x62,0x00},
    {0x44,0xf8,0x4e,0xf8,0x4e,0xf8,0x4e,0x00},
    {0x28,0xfe,0x28,0xfe,0xda,0x2c,0xda,0x00},
    {0x24,0x7e,0xc4,0x6e,0x48,0x76,0x76,0x00},
    {0x10,0xfe,0x10,0x38,0x54,0x92,0x10,0x00},
    {0xea,0xfe,0xe8,0x48,0xf6,0x00,0xaa,0x00},
    {0x7e,0x42,0x7e,0x42,0x7e,0x42,0x7e,0x00},
    {0x10,0xfe,0x38,0xd6,0x7c,0x10,0xfe,0x00},
    {0x40,0x7e,0xaa,0x2a,0x4a,0x92,0x26,0x00},
    {0x54,0xa0,0x7e,0xd4,0xfe,0x94,0xe4,0x00},
    {0x14,0xfe,0x10,0x18,0x18,0x2a,0xce,0x00},
    {0xfe,0x44,0x7c,0x48,0x7e,0x48,0xb6,0x00},
    {0xbe,0x4a,0xea,0x5a,0xee,0xca,0x56,0x00},
    {0x54,0xfe,0x54,0x7e,0x44,0x7c,0xc6,0x00},
    {0xee,0xaa,0xee,0x82,0xba,0xaa,0xba,0x00},
    {0xee,0xaa,0xee,0x92,0xa2,0xee,0xba,0x00},
    {0x48,0xbe,0x54,0x94,0x48,0xd4,0x62,0x00},
    {0xee,0xaa,0xee,0x82,0x82,0x82,0x86,0x00},
    {0x40,0x7e,0x52,0xb2,0x1e,0x22,0xc6,0x00},
    {0x08,0x28,0x2e,0xfa,0x28,0x22,0x1e,0x00},
    {0x88,0x08,0x14,0x3a,0x80,0x9c,0x9c,0x00},
    {0x10,0xfe,0x28,0x4e,0xda,0x44,0x5a,0x00},
    {0x28,0xc6,0x38,0xc6,0x74,0xf6,0x14,0x00},
    {0xfe,0x56,0x74,0x76,0x5e,0xf4,0x14,0x00},
    {0xfe,0xb2,0xf4,0xbe,0xf6,0x24,0xfc,0x00},
    {0xd0,0x5e,0xe8,0x9c,0xda,0x6a,0xd8,0x00},
    {0x40,0x7c,0x90,0xfe,0x10,0x28,0xc6,0x00},
    {0x7e,0x40,0x5c,0x54,0x54,0x52,0x9e,0x00},
    {0x5c,0x94,0x66,0xdc,0x54,0x48,0x76,0x00},
    {0x48,0x8e,0x52,0xaa,0x46,0xe2,0x46,0x00},
    {0x28,0xfe,0xba,0x6c,0xfe,0x38,0xd6,0x00},
    {0x5e,0xd2,0x1e,0xd4,0x14,0xd2,0xe2,0x00},
    {0xee,0xa6,0xee,0x44,0xee,0xdc,0xee,0x00},
    {0x48,0xfc,0xa8,0xbe,0x54,0xfc,0x14,0x00},
    {0x56,0xe6,0x76,0xf6,0xf6,0x54,0x64,0x00},
    {0x28,0xfe,0xb6,0x6a,0xba,0x54,0xea,0x00},
    {0x54,0xae,0xee,0x54,0xf6,0x76,0xde,0x00},
    {0x48,0xd4,0xee,0x40,0x5a,0x5a,0x5a,0x00},
    {0x10,0x28,0xde,0x74,0x74,0xca,0xba,0x00},
    {0x88,0x3e,0xaa,0x3e,0xaa,0xaa,0xbe,0x00},
    {0x08,0x7e,0xc8,0x76,0xf4,0x52,0xae,0x00},
    {0x48,0xd4,0x2e,0xc0,0x1a,0xda,0xda,0x00},
    {0xe8,0x54,0xee,0xe0,0x5a,0xfa,0x5a,0x00},
    {0x14,0xfe,0xb4,0xbe,0xf4,0x14,0x1e,0x00},
    {0x28,0x7e,0xd0,0x5e,0x72,0x52,0x5e,0x00},
    {0x3e,0x5c,0xdc,0x7e,0x76,0x48,0x76,0x00},
    {0x7c,0x08,0x7c,0x54,0xfe,0x22,0xc6,0x00},
    {0x20,0xfe,0x20,0x3c,0x54,0x88,0x76,0x00},
    {0x10,0xfe,0xa2,0x7c,0x34,0xdc,0x14,0x00},
    {0x34,0xda,0xb6,0xda,0xfe,0x92,0xfe,0x00},
    {0x26,0x5a,0xd4,0x5a,0x00,0xca,0xba,0x00},
    {0xfe,0x38,0x38,0xfe,0xda,0x28,0xd6,0x00},
    {0x5c,0xd4,0x7e,0x5c,0xd4,0x7e,0xc4,0x00},
    {0x20,0xfe,0x20,0x7c,0xa4,0x3c,0x24,0x00},
    {0x48,0xfe,0x6a,0xfe,0xea,0x6a,0x7e,0x00},
    {0x9e,0x04,0x9e,0x1a,0xbe,0x8a,0xb6,0x00},
    {0xbe,0x04,0xbe,0x2a,0xbe,0xaa,0xaa,0x00},
    {0xb4,0x7e,0xd4,0x7e,0xf6,0x62,0xbe,0x00},
    {0x56,0xf4,0x6e,0xf4,0xd4,0x94,0xfa,0x00},
    {0x10,0xfe,0x92,0xfe,0x92,0x92,0xfe,0x00},
    {0x48,0xfe,0x28,0x4e,0xfa,0x4a,0x4e,0x00},
    {0x54,0xe2,0x28,0x54,0xe2,0x6c,0x4c,0x00},
    {0x9c,0xfe,0x1c,0xaa,0x3c,0xd6,0xe2,0x00},
    {0x94,0x3e,0x16,0xda,0x6e,0x54,0xbe,0x00},
    {0x78,0x48,0xfc,0x94,0xfc,0x82,0x7e,0x00},
    {0x7e,0x2a,0xfc,0x6a,0xfa,0x2c,0xf8,0x00},
    {0x54,0xfe,0x54,0x5e,0xb4,0x54,0x7e,0x00},
    {0xf4,0x6e,0x6a,0xfe,0x94,0xf6,0xbe,0x00},
    {0x10,0x1e,0x22,0x5a,0x04,0x08,0x70,0x00},
    {0x7c,0x28,0x10,0xfe,0x12,0x10,0x30,0x00},
    {0x10,0x28,0xfe,0x10,0xfe,0x54,0xb2,0x00},
    {0x20,0x3c,0x20,0x38,0xfe,0x08,0x18,0x00},
    {0x54,0xfe,0x44,0xba,0x00,0x7c,0x7c,0x00},
    {0x56,0xba,0xd6,0xba,0xfe,0x00,0xc6,0x00},
    {0x7e,0x14,0x2e,0xfa,0x3e,0x20,0x6a,0x00},
    {0x24,0x7e,0xec,0x7e,0x76,0x7e,0x56,0x00},
    {0x24,0x2e,0xc6,0x56,0x26,0x5a,0xea,0x00},
    {0x22,0x2c,0xf4,0x5e,0x64,0x34,0xca,0x00},
    {0x10,0xfe,0xaa,0x54,0x28,0xfe,0x38,0x00},
    {0x08,0x7e,0x5c,0x7e,0x6a,0x7e,0xaa,0x00},
    {0x5c,0xd4,0x7e,0x50,0xde,0x6a,0xd6,0x00},
    {0x46,0xda,0x48,0x7e,0xc8,0x6a,0xfe,0x00},
    {0x48,0xfe,0x56,0x6c,0xf6,0x54,0xe6,0x00},
    {0x1e,0xea,0xbe,0xe4,0xae,0xfc,0x0e,0x00},
    {0x5c,0xd4,0x7e,0xd0,0xde,0x6a,0x56,0x00},
    {0x54,0xfe,0x5c,0xfe,0xea,0x5c,0x6a,0x00},
    {0x94,0x3e,0x88,0x1c,0x88,0xbe,0x88,0x00},
    {0x88,0x3e,0xb6,0x08,0x94,0xae,0x8c,0x00},
    {0x48,0x7e,0xf6,0xc8,0x54,0x6e,0x8c,0x00},
    {0x7e,0x52,0x7e,0x52,0x7e,0x52,0x96,0x00},
    {0x10,0xfe,0xaa,0x7c,0x10,0xfe,0xaa,0x00},
    {0x24,0xfe,0x10,0x7c,0x10,0xfe,0x10,0x00},
    {0x2e,0xb6,0x6e,0xf4,0x6e,0x7c,0x8e,0x00},
    {0x28,0xfe,0x5c,0x40,0xfe,0x38,0xd6,0x00},
    {0x28,0xfe,0xaa,0x54,0x28,0xfe,0x38,0x00},
    {0xfe,0x54,0x7c,0x10,0xfe,0x28,0xf6,0x00},
    {0x46,0xda,0x08,0xde,0x08,0xea,0xfe,0x00},
    {0xee,0xa4,0xde,0x76,0xde,0xf6,0xd6,0x00},
    {0x86,0x3a,0x08,0xfe,0x48,0x6a,0xbe,0x00},
    {0xdc,0xd4,0xbe,0xd0,0xde,0xaa,0x96,0x00},
    {0x24,0xfe,0x10,0xfe,0x7c,0xba,0x34,0x00},
    {0x58,0x2e,0xd6,0x64,0x6a,0xc0,0xba,0x00},
    {0x50,0xee,0x6a,0x6a,0xfa,0x68,0xc8,0x00},
    {0x54,0x86,0x2a,0x54,0x84,0x74,0x7a,0x00},
    {0x84,0x18,0x88,0x3e,0x88,0x88,0xb6,0x00},
    {0x94,0x22,0x88,0x14,0xa2,0x9c,0x9c,0x00},
    {0xfe,0x5a,0x36,0xda,0x7c,0x28,0xfe,0x00},
    {0xfe,0x5a,0x36,0x58,0xfe,0x00,0xc6,0x00},
    {0x88,0x3e,0xae,0x04,0x96,0x94,0xae,0x00},
    {0xfe,0xaa,0xfe,0x94,0x5e,0xf4,0x5e,0x00},
    {0x7e,0xea,0xbe,0xd0,0x7e,0x48,0xea,0x00},
    {0x7e,0xea,0x3e,0x48,0xfe,0x5c,0x6a,0x00},
    {0x10,0xfe,0x54,0x10,0xfe,0x38,0xd6,0x00},
    {0x28,0xfe,0x54,0x10,0xfe,0x38,0xd6,0x00},
    {0x2e,0xf4,0x7e,0x7a,0x2e,0x70,0xaa,0x00},
    {0x38,0xfe,0xb6,0x00,0x7c,0x54,0x7c,0x00},
    {0x8c,0x14,0x88,0x14,0xa2,0x9c,0x9c,0x00},
    {0x4c,0x94,0x48,0x94,0x62,0xdc,0x5c,0x00},
    {0x28,0xfe,0x8c,0x34,0x88,0x36,0x9c,0x00},
    {0xec,0x54,0xe8,0xf4,0xa2,0xec,0xec,0x00},
    {0x18,0x68,0xf8,0x28,0x78,0x5a,0x7e,0x00},
    {0x2e,0xca,0xee,0xaa,0xea,0x28,0x48,0x00},
    {0x92,0xfe,0x54,0x7c,0x7c,0x5c,0xb6,0x00},
    {0x76,0xf6,0x6a,0xfe,0xea,0x7e,0x6a,0x00},
    {0xb4,0x26,0xa0,0x36,0x80,0x9c,0xbe,0x00},
    {0x28,0xfe,0x68,0x4e,0x60,0x38,0xfe,0x00},
    {0x28,0xfe,0xee,0x92,0xfe,0xba,0xd6,0x00},
    {0xe8,0xce,0xe6,0x38,0x38,0x3a,0xce,0x00},
    {0x72,0x2a,0xfa,0x2a,0x72,0xa2,0x26,0x00},
    {0x10,0xfe,0x54,0x7c,0x30,0x10,0xee,0x00},
    {0x7e,0x7e,0x58,0x6e,0x5a,0x74,0x9a,0x00},
    {0x10,0xfe,0x3c,0xda,0x08,0xfe,0x10,0x00},
    {0x6a,0xfa,0x6a,0xb2,0xfe,0x38,0xd6,0x00},
    {0x3e,0xea,0x7e,0xea,0x7e,0xc8,0x3e,0x00},
    {0x08,0xfe,0x54,0xdc,0x7e,0xee,0x3a,0x00},
    {0x08,0x7e,0xc8,0x76,0xd6,0x7a,0x96,0x00},
    {0x10,0xfe,0x54,0x7c,0xfe,0x68,0xb6,0x00},
    {0x5e,0xf6,0x3e,0x56,0xfe,0x64,0x5e,0x00},
    {0x7c,0x54,0x7c,0x54,0x7c,0x10,0xfe,0x00},
    {0x2a,0xfe,0x5c,0x6e,0xfc,0xbc,0xee,0x00},
    {0xc8,0xdc,0xbe,0xd4,0xe6,0x88,0xbe,0x00},
    {0x48,0xbc,0x4e,0xfc,0x48,0x7e,0x48,0x00},
    {0x10,0xfe,0x54,0x20,0x54,0xfe,0x10,0x00},
    {0x10,0xfe,0x44,0x24,0x28,0x28,0xfe,0x00},
    {0x28,0xfe,0x48,0xbc,0x4c,0xfe,0x48,0x00},
    {0x48,0xfe,0x54,0x5c,0xc8,0x6a,0xd8,0x00},
    {0x0c,0xf4,0xe8,0xf4,0xe2,0xec,0x0c,0x00},
    {0x5a,0x9a,0xea,0x52,0xaa,0x72,0xfa,0x00},
    {0x88,0x3e,0x94,0x3a,0x98,0x9a,0xaa,0x00},
    {0x8e,0x36,0xa6,0x3a,0x9c,0x9c,0x9c,0x00},
    {0x08,0xfe,0x54,0xfa,0x58,0xda,0x2a,0x00},
    {0x2e,0xc6,0x96,0xea,0x7c,0x54,0x7c,0x00},
    {0xe4,0x5e,0x48,0x9e,0x60,0x7a,0x2a,0x00},
    {0xa8,0x7e,0xd4,0x54,0xd4,0xd8,0x7e,0x00},
    {0xcc,0xd4,0x88,0xf6,0xdc,0x88,0xbe,0x00},
    {0x10,0x7c,0x28,0xfe,0x54,0x7c,0x0e,0x00},
    {0x26,0xfc,0x56,0xfa,0x56,0x74,0x56,0x00},
    {0x3e,0x52,0xde,0x48,0x5e,0x52,0x5e,0x00},
    {0x08,0x0e,0x78,0x5e,0x5c,0x72,0xae,0x00},
    {0x48,0xee,0x54,0x68,0x7a,0xac,0xaa,0x00},
    {0x08,0x0e,0x78,0x4e,0x5c,0x7e,0x92,0x00},
    {0xfe,0x04,0x18,0x10,0x10,0x10,0x30,0x00},
    {0x10,0xfe,0x44,0xfe,0x82,0x28,0xce,0x00},
    {0x28,0x7e,0xd4,0x7e,0x54,0x48,0x6a,0x00},
    {0xfe,0x10,0xfe,0x92,0xd6,0xfe,0x82,0x00},
    {0x88,0x1c,0x08,0x3e,0x94,0xa8,0x96,0x00},
    {0x10,0xfe,0xaa,0x7c,0xaa,0x38,0x92,0x00},
    {0xa4,0x54,0xe4,0x54,0xc6,0xfc,0x44,0x00},
    {0xbc,0x14,0x96,0x2c,0xfe,0x38,0xd6,0x00},
    {0x88,0x3e,0x94,0x1c,0x88,0xaa,0x98,0x00},
    {0xaa,0x44,0xbe,0x6a,0xbe,0x2a,0xca,0x00},
    {0x08,0x7e,0xd4,0x7e,0xd4,0x48,0xaa,0x00},
    {0xe8,0xbe,0xf4,0xbe,0xf4,0xa8,0xea,0x00},
    {0xc8,0x5c,0xc8,0x7e,0xd4,0xe8,0x56,0x00},
    {0xbc,0x54,0xfe,0x5c,0xdc,0xc8,0x7e,0x00},
    {0x10,0x7c,0x44,0x7c,0x7c,0x48,0xe6,0x00},
    {0x88,0xfe,0x14,0xdc,0x08,0xea,0xd8,0x00},
    {0x88,0x3e,0x14,0xfe,0x54,0x6a,0xbe,0x00},
    {0x7c,0x44,0xfe,0x54,0x7c,0x10,0xfe,0x00},
    {0xc8,0xdc,0x88,0xfe,0xd4,0xa8,0x96,0x00},
    {0x5e,0xa4,0xee,0x0a,0xee,0x60,0x52,0x00},
    {0x10,0xfe,0x12,0x22,0x22,0x42,0x86,0x00},
    {0x5c,0x84,0x7e,0x88,0x6a,0xdc,0x6a,0x00},
    {0x28,0x54,0xee,0x40,0x7e,0x7e,0x6a,0x00},
    {0x7e,0x6a,0x7e,0x6a,0x7e,0x48,0xbe,0x00},
    {0x24,0xfe,0x24,0x6c,0x76,0xa4,0x24,0x00},
    {0x94,0x7e,0x94,0x3c,0xbe,0xd4,0x94,0x00},
    {0x6a,0x5c,0xea,0xc0,0x74,0x5e,0xa4,0x00},
    {0x14,0xfe,0x54,0xfc,0x7e,0xd4,0x14,0x00},
    {0xf4,0xa6,0xfe,0x96,0xf0,0xae,0xfe,0x00},
    {0xe8,0x54,0xee,0xe0,0x5e,0xfe,0x56,0x00},
    {0xea,0xbc,0xca,0xa0,0xb4,0xde,0xa4,0x00},
    {0xea,0x5c,0xea,0xc0,0xf4,0x1e,0xa4,0x00},
    {0x56,0xec,0xb6,0xe0,0xda,0xee,0x92,0x00},
    {0x0e,0xf6,0x66,0xfa,0x5c,0xdc,0x1c,0x00},
    {0x7c,0x54,0x7c,0x82,0x44,0x92,0x7c,0x00},
    {0xbe,0x12,0x9e,0x14,0x9e,0xa4,0x9a,0x00},
    {0x7c,0x54,0x7c,0x24,0xfa,0x10,0x92,0x00},
    {0xae,0x74,0xae,0x2a,0xfe,0x20,0xda,0x00},
    {0x10,0x28,0xde,0x00,0xfe,0x12,0x10,0x00},
    {0x28,0x54,0xee,0x40,0x7e,0x4a,0x48,0x00},
    {0x3a,0x56,0xde,0x6e,0x5a,0x52,0x66,0x00},
    {0x88,0x14,0x2e,0x00,0xbe,0x8a,0x88,0x00},
    {0xf4,0x8e,0xf6,0xa6,0xb6,0xda,0xda,0x00},
    {0x92,0xfe,0xa4,0x0e,0xee,0x60,0x52,0x00},
    {0x48,0xd4,0xee,0x40,0x7e,0x4a,0x48,0x00},
    {0x08,0xd4,0x6e,0xc0,0x7e,0xca,0x08,0x00},
    {0x48,0xe8,0x28,0x48,0xe8,0x4a,0x4e,0x00},
    {0x28,0xfe,0x10,0x28,0xfe,0x12,0x10,0x00},
    {0x48,0xb4,0xee,0x40,0xfe,0x6a,0xc8,0x00},
    {0x48,0xfc,0x4e,0xfc,0x1a,0xec,0x5a,0x00},
    {0x38,0xfe,0xb6,0x28,0xfe,0x12,0x10,0x00},
    {0x38,0xfe,0xb6,0x00,0xba,0x54,0xfe,0x00},
    {0xee,0xaa,0x7e,0x54,0x7e,0x64,0xb6,0x00},
    {0x24,0xba,0xee,0xb0,0xde,0xb6,0xf4,0x00},
    {0x7e,0x54,0x7e,0x54,0x7e,0x62,0xbe,0x00},
    {0x7e,0x54,0x7e,0x54,0x46,0x54,0xbe,0x00},
    {0xf2,0x4a,0x6a,0xaa,0x62,0x42,0x86,0x00},
    {0x10,0x54,0x9a,0x30,0xfe,0x22,0xc6,0x00},
    {0xf2,0x4a,0x6a,0xa2,0x46,0x00,0xaa,0x00},
    {0xf2,0x6a,0xaa,0x42,0xfe,0x68,0xb6,0x00},
    {0x08,0x7e,0x5c,0x4e,0x7e,0x5c,0xaa,0x00},
    {0x10,0xfe,0x28,0xaa,0x00,0xca,0xba,0x00},
    {0x6a,0xdc,0xea,0x40,0x74,0x5e,0x64,0x00},
    {0xa4,0x1e,0x8c,0x2c,0xbe,0xa4,0xbe,0x00},
    {0x48,0x7e,0xdc,0xdc,0x48,0x5c,0xaa,0x00},
    {0x48,0x6e,0xbe,0x5a,0x7e,0x5c,0xaa,0x00},
    {0x48,0xbe,0x5c,0x9c,0x48,0xdc,0x6a,0x00},
    {0xea,0x74,0x6a,0x74,0x7e,0xee,0x34,0x00},
    {0x28,0xfe,0x48,0x1e,0xde,0x48,0xbe,0x00},
    {0x88,0x3e,0x1c,0xdc,0x7e,0x48,0xbe,0x00},
    {0x48,0xbe,0xfc,0x5c,0xe8,0x5c,0xea,0x00},
    {0x3c,0x24,0x3c,0x10,0x7e,0x42,0x7e,0x00},
    {0x38,0xc8,0x7c,0x7c,0xaa,0x7c,0x7c,0x00},
    {0x4c,0xf4,0x5c,0xdc,0xea,0x5c,0x5c,0x00},
    {0x5e,0x40,0xfe,0xd2,0x5e,0x50,0xa0,0x00},
    {0xec,0xb4,0xe8,0xb4,0xe2,0x0c,0xac,0x00},
    {0xec,0xb4,0xe8,0x54,0xe2,0xcc,0xec,0x00},
    {0x38,0xfe,0xb6,0xec,0xb4,0x5e,0xec,0x00},
    {0x54,0xfe,0x92,0x7c,0x14,0x24,0xcc,0x00},
    {0x10,0x7c,0xfe,0x54,0xfe,0x28,0xf6,0x00},
    {0x08,0x7e,0x56,0x74,0x76,0x6e,0xb4,0x00},
    {0x7c,0x10,0x7c,0x28,0xfe,0x28,0x48,0x00},
    {0x4e,0xea,0xae,0xea,0x8e,0xaa,0xd6,0x00},
    {0x6a,0xdc,0x6a,0xd0,0xfe,0x54,0x7a,0x00},
    {0x56,0xfe,0x6c,0xfe,0xe6,0x74,0x44,0x00},
    {0x88,0x3c,0xa4,0x3c,0xbc,0xa8,0xb6,0x00},
    {0xbe,0x3e,0xa0,0x3e,0xa8,0xbe,0xda,0x00},
    {0x10,0xfe,0xd2,0x7c,0x90,0xfe,0x10,0x00},
    {0xa4,0x5e,0xb2,0x7e,0xbe,0x34,0xda,0x00},
    {0x48,0x6e,0xb4,0x28,0xfe,0x38,0x0e,0x00},
    {0x12,0x7c,0x18,0xfe,0x5c,0x90,0x1e,0x00},
    {0x26,0xfc,0x52,0xf6,0x5c,0xfe,0x04,0x00},
    {0x6a,0xc4,0xbe,0xea,0x7e,0x6a,0xca,0x00},
    {0x4e,0xea,0xac,0xea,0x8a,0xac,0xe8,0x00},
    {0x10,0xfe,0x00,0x28,0x28,0x44,0x82,0x00},
    {0x44,0xee,0x7e,0x54,0x7e,0x64,0xb6,0x00},
    {0x5c,0xe4,0x3e,0x48,0xea,0x5c,0x6a,0x00},
    {0xe8,0xbe,0xea,0xaa,0xea,0xaa,0xb6,0x00},
    {0x5c,0xa4,0xfe,0x48,0xea,0x5c,0xea,0x00},
    {0x48,0xd4,0x2e,0xc0,0x3e,0xfe,0xea,0x00},
    {0x5c,0x7e,0xdc,0xea,0x7e,0x54,0x7a,0x00},
    {0x70,0x2e,0xfa,0x2a,0x7a,0xaa,0x2e,0x00},
    {0x44,0xd8,0x3e,0xc8,0x1c,0xd4,0xdc,0x00},
    {0xfe,0x34,0xd2,0x7c,0x1c,0x50,0xfe,0x00},
    {0xe8,0xbe,0xe8,0xae,0xfa,0x0e,0xaa,0x00},
    {0xe8,0xbe,0xea,0xa0,0xea,0xbe,0xaa,0x00},
    {0x0a,0xfe,0x64,0xea,0x00,0xca,0xba,0x00},
    {0x48,0xfc,0x54,0xe6,0xc8,0x7e,0x48,0x00},
    {0x24,0xfe,0x54,0x7a,0xbe,0x02,0xaa,0x00},
    {0xfe,0x20,0x3c,0x2c,0x54,0x08,0xfe,0x00},
    {0xfe,0x7c,0x44,0x7c,0x44,0x7c,0xfe,0x00},
    {0x7a,0xba,0x6c,0x7e,0x68,0x0e,0xa2,0x00},
    {0x88,0xfe,0x26,0x98,0x3e,0xc8,0xce,0x00},
    {0x28,0xfe,0x38,0xee,0xba,0x38,0xd6,0x00},
    {0x28,0xfe,0x68,0x5e,0x76,0x54,0xaa,0x00},
    {0x48,0xfe,0x62,0xde,0xea,0x58,0x6e,0x00},
    {0x88,0x3e,0x94,0x36,0x9c,0x9e,0x82,0x00},
    {0xe4,0x5e,0x52,0x8e,0x76,0x6c,0x16,0x00},
    {0xe4,0xbe,0xf2,0xae,0xf6,0xac,0xb6,0x00},
    {0x0a,0xfe,0x08,0x08,0xf4,0x04,0x02,0x00},
    {0xfe,0x10,0x5c,0x50,0x7e,0x02,0x06,0x00},
    {0xfe,0x10,0x34,0xd2,0x10,0x10,0xfe,0x00},
    {0x10,0x28,0xd6,0x10,0x10,0x10,0x10,0x00},
    {0x28,0xaa,0xaa,0xaa,0xee,0x28,0x48,0x00},
    {0x00,0x20,0x10,0x08,0x08,0x00,0x00,0x00},
    {0x24,0xfe,0x34,0x24,0xfe,0x24,0x44,0x00},
    {0x08,0x08,0x08,0x08,0x08,0x10,0x60,0x00},
    {0x44,0x44,0x28,0x28,0x10,0x28,0xc6,0x00},
    {0x0c,0x70,0xfe,0xd6,0x54,0xd6,0x10,0x00},
    {0x0c,0x70,0xfe,0x54,0xd6,0x38,0xd6,0x00},
    {0x74,0xac,0x74,0x14,0xf4,0xb4,0xd6,0x00},
    {0x10,0x10,0x10,0x10,0x10,0x10,0x30,0x00},
    {0xec,0x34,0x5c,0xfc,0x5a,0x6c,0xda,0x00},
    {0x10,0xfe,0x54,0x3c,0xfe,0x1c,0x30,0x00},
    {0x5e,0xaa,0x44,0xfe,0x46,0xa4,0xec,0x00},
    {0x0a,0xfe,0x08,0x68,0x04,0xf4,0x02,0x00},
    {0x7c,0x10,0x10,0xfe,0x10,0x10,0x30,0x00},
    {0xfe,0x28,0xee,0x82,0xee,0x28,0xfe,0x00},
    {0xfe,0x20,0x3e,0xda,0xd4,0x3a,0xfe,0x00},
    {0x00,0x10,0x10,0xfe,0x00,0x00,0x00,0x00},
    {0x10,0xfe,0x00,0x38,0x28,0x2a,0xce,0x00},
    {0x10,0xfe,0x44,0x7c,0x7c,0x54,0xb2,0x00},
    {0x10,0xfe,0x44,0xfe,0x9a,0x70,0x1e,0x00},
    {0x10,0xfe,0x6c,0x7c,0x38,0x28,0xfe,0x00},
    {0x24,0x24,0x24,0x24,0x54,0x4a,0x92,0x00},
    {0x3c,0x54,0xd6,0x52,0x52,0x52,0x66,0x00},
    {0x7e,0x48,0x48,0x48,0x48,0x54,0xa2,0x00},
    {0x28,0x48,0xc8,0x4c,0x4a,0x48,0x48,0x00},
    {0x28,0x5e,0xca,0x4a,0x4a,0x4a,0x56,0x00},
    {0x28,0x7e,0xc8,0x58,0x48,0x54,0x62,0x00},
    {0x3e,0x4a,0xda,0x5a,0x6a,0x4a,0x56,0x00},
    {0x3e,0x4a,0xda,0x4a,0x4e,0x4a,0x56,0x00},
    {0x24,0x58,0xc8,0x7e,0x48,0x48,0x48,0x00},
    {0x28,0x54,0xe2,0x54,0x54,0x54,0x64,0x00},
    {0x28,0x7e,0xc0,0x5c,0x54,0x54,0x66,0x00},
    {0x38,0x5c,0xe8,0x7e,0x48,0x54,0x62,0x00},
    {0x28,0x48,0xfe,0x48,0x5c,0x54,0x5c,0x00},
    {0x54,0x7e,0xde,0xf4,0x7e,0x56,0x64,0x00},
    {0x30,0x5e,0xe2,0x5a,0x5a,0x42,0x46,0x00},
    {0x28,0x7e,0xe2,0x54,0x58,0x52,0x5e,0x00},
    {0x24,0x5e,0xd2,0x4e,0x44,0x44,0x4c,0x00},
    {0x28,0x7e,0xc8,0x5c,0x40,0x5c,0x5c,0x00},
    {0x2c,0x54,0xc8,0x76,0x4a,0x44,0x58,0x00},
    {0x38,0x5c,0xe8,0x7e,0x48,0x5c,0x6a,0x00},
    {0x28,0x7e,0xe6,0x58,0x7e,0x48,0x4e,0x00},
    {0x54,0x76,0xd4,0xf6,0x54,0x54,0x66,0x00},
    {0x3e,0x62,0xfe,0x6a,0x7e,0x7e,0x6a,0x00},
    {0x3e,0x48,0xde,0x52,0x5e,0x52,0x5e,0x00},
    {0x28,0x5e,0xc8,0x4e,0x5a,0x4e,0x4a,0x00},
    {0x54,0x7e,0xc8,0xdc,0x48,0x7e,0x48,0x00},
    {0x10,0xfe,0x54,0x54,0xba,0x38,0xd6,0x00},
    {0x10,0x28,0xde,0x00,0xfe,0xfe,0xaa,0x00},
    {0x28,0x5c,0xce,0x5c,0x6a,0x5c,0x7e,0x00},
    {0x3e,0x52,0xde,0x52,0x5e,0x4c,0x56,0x00},
    {0x28,0x52,0xde,0x48,0x5e,0x44,0x5a,0x00},
    {0x5c,0x54,0xbc,0x14,0x5c,0x54,0xbe,0x00},
    {0x3c,0x6a,0xc0,0x5c,0x44,0x7e,0x48,0x00},
    {0x2c,0x54,0xfe,0x6a,0x7e,0x54,0x66,0x00},
    {0x3e,0x44,0xfe,0x6a,0x7e,0x6a,0x6a,0x00},
    {0x3e,0x6a,0xfe,0x6a,0x7e,0x48,0x7e,0x00},
    {0x3a,0x56,0xfe,0x56,0x7a,0x72,0x56,0x00},
    {0x54,0x7e,0xca,0xfe,0x68,0x5e,0x6a,0x00},
    {0x28,0x7e,0xdc,0x5c,0x5c,0x7e,0x48,0x00},
    {0x28,0x7e,0xc8,0x54,0x7e,0x44,0x54,0x00},
    {0x3e,0x5e,0xd4,0x5e,0x54,0x5a,0x6e,0x00},
    {0x3e,0x62,0xfe,0x6e,0x64,0x76,0x5e,0x00},
    {0x36,0x62,0xf6,0x62,0x7e,0x54,0x66,0x00},
    {0x28,0x7e,0xf6,0x40,0x5c,0x48,0x7e,0x00},
    {0x28,0x7e,0xd4,0x54,0x6a,0x7e,0x48,0x00},
    {0x28,0x7c,0xd4,0x66,0x48,0x7e,0x48,0x00},
    {0x36,0x5a,0xd2,0x7a,0x54,0x74,0x5a,0x00},
    {0x5c,0x54,0xfe,0xe2,0x7e,0x62,0x7e,0x00},
    {0x28,0x5c,0xc8,0x7e,0x5c,0x5c,0x54,0x00},
    {0x28,0x4e,0xdc,0x54,0x5c,0x7e,0x48,0x00},
    {0x28,0x7e,0xea,0x7e,0x54,0x7e,0x44,0x00},
    {0x28,0x7e,0xe0,0x6a,0x76,0x72,0x56,0x00},
    {0x36,0x76,0xf6,0x62,0x62,0x62,0x66,0x00},
    {0x3e,0x48,0xfe,0x6a,0x7e,0x7e,0x6a,0x00},
    {0x3e,0x6c,0xec,0x7a,0x64,0x6a,0x7e,0x00},
    {0x36,0x72,0xe6,0x7e,0x6a,0x74,0x6a,0x00},
    {0x10,0x28,0xfe,0x54,0x7c,0x44,0x7c,0x00},
    {0x24,0x76,0xe4,0x76,0x48,0x5c,0x5c,0x00},
    {0x28,0x7e,0xd4,0x7e,0x68,0x62,0x4c,0x00},
    {0x3c,0x54,0xdc,0x5e,0x72,0x5a,0x46,0x00},
    {0x54,0x7e,0xd6,0xfe,0x6e,0x7c,0x4a,0x00},
    {0x2a,0x5c,0xc8,0x7e,0x54,0x6e,0x4e,0x00},
    {0x30,0x5e,0xea,0x5a,0x44,0x72,0x6e,0x00},
    {0x38,0x54,0xee,0x40,0x5a,0x5c,0x5a,0x00},
    {0x28,0x7e,0xea,0x7e,0x6a,0x5c,0x6e,0x00},
    {0x54,0x7e,0xee,0xc6,0x6e,0x54,0x6a,0x00},
    {0x2a,0x7e,0xdc,0x54,0x7e,0x54,0x4c,0x00},
    {0x3e,0x6c,0xec,0x60,0x76,0x76,0x7e,0x00},
    {0x54,0x7e,0xd6,0xfe,0x56,0x5c,0x6a,0x00},
    {0x10,0x28,0xfe,0xaa,0xee,0x44,0xaa,0x00},
    {0x3e,0x5c,0xfe,0x54,0x6a,0x50,0x5c,0x00},
    {0x28,0x7e,0xdc,0x5a,0x7e,0x54,0x4c,0x00},
    {0x28,0x5c,0xf6,0x5c,0x7e,0x54,0x7a,0x00},
    {0x28,0x7e,0xdc,0x54,0x7e,0x54,0x5c,0x00},
    {0x3c,0x6a,0xdc,0x54,0x7e,0x42,0x6a,0x00},
    {0x28,0x5c,0xfe,0x76,0x7e,0x54,0x66,0x00},
    {0x54,0x5e,0xfe,0xd4,0x6a,0x5c,0x5c,0x00},
    {0x54,0x7e,0xd4,0xea,0x5c,0x54,0x5c,0x00},
    {0x28,0x7e,0xd4,0x7e,0x5c,0x48,0x7e,0x00},
    {0x3e,0x5c,0xc0,0x5c,0x5c,0x5c,0x62,0x00},
    {0x3e,0x4c,0xcc,0x5e,0x4c,0x4c,0x5e,0x00},
    {0x28,0x54,0xfe,0x6a,0x7e,0x54,0x6a,0x00},
    {0x54,0x5e,0xf4,0xde,0x76,0x6a,0x62,0x00},
    {0x54,0x7e,0xfe,0xc0,0x7e,0x74,0x5a,0x00},
    {0x34,0x66,0xe0,0x76,0x40,0x5c,0x7e,0x00},
    {0x28,0x7e,0xd4,0x6a,0x54,0x5c,0x64,0x00},
    {0x28,0x5c,0xfe,0x48,0x7e,0x74,0x4c,0x00},
    {0x54,0x7e,0xdc,0xfe,0x6e,0x44,0x58,0x00},
    {0x3c,0x5c,0xdc,0x40,0x76,0x76,0x76,0x00},
    {0x2a,0x7c,0xd6,0x7c,0x7e,0x54,0x6e,0x00},
    {0x36,0x6a,0xfe,0x6c,0x7e,0x64,0x76,0x00},
    {0x36,0x7e,0xf4,0x7e,0x7a,0x7c,0x6a,0x00},
    {0x2a,0x7e,0xea,0x5c,0x7e,0x40,0x6a,0x00},
    {0x28,0x28,0x28,0x28,0x28,0x4a,0x8e,0x00},
    {0xfe,0x28,0x28,0x28,0x28,0x4a,0x8e,0x00},
    {0x2c,0x44,0x6c,0x44,0x7c,0x2a,0xce,0x00},
    {0x28,0x44,0xfe,0x44,0x7c,0x2a,0xce,0x00},
    {0x38,0xc8,0x7e,0x52,0x7e,0x34,0xde,0x00},
    {0x24,0xfe,0x24,0x5a,0x7e,0x6c,0xb6,0x00},
    {0x24,0xfe,0x5a,0xfe,0x7e,0x6c,0xb6,0x00},
    {0xfe,0x10,0xfe,0xda,0xda,0xb6,0x92,0x00},
    {0x70,0x28,0xde,0x00,0xea,0xf4,0xaa,0x00},
    {0x28,0x44,0xfa,0x20,0x3c,0x04,0x0c,0x00},
    {0x28,0xee,0x28,0xfe,0x38,0xfe,0x44,0x00},
    {0xfe,0x82,0x82,0x82,0x82,0x82,0x86,0x00},
    {0xfe,0xba,0xaa,0xba,0xa2,0xba,0x86,0x00},
    {0x7e,0x5a,0x5a,0xfe,0x5a,0x5a,0xb6,0x00},
    {0x10,0x7c,0x54,0x7c,0x54,0xfe,0x44,0x00},
    {0xfe,0xaa,0xce,0xba,0xaa,0xba,0x86,0x00},
    {0x10,0xfe,0x92,0xfe,0x44,0x5c,0x44,0x00},
    {0x28,0xfe,0x28,0xfe,0x54,0xfe,0x44,0x00},
    {0x7c,0x44,0x3c,0xd4,0x7c,0x2a,0xce,0x00},
    {0x00,0x00,0xfe,0x82,0x00,0x00,0x00,0x00},
    {0xfe,0xba,0x3c,0xd4,0x7c,0x2a,0xce,0x00},
    {0xfe,0x86,0x6c,0x0a,0xe4,0x6a,0xbe,0x00},
    {0xfe,0xba,0x30,0xda,0x2c,0xca,0x30,0x00},
    {0xfe,0xaa,0x48,0x78,0x7e,0x82,0x56,0x00},
    {0xfe,0xaa,0x7c,0x38,0xfe,0x7e,0xb4,0x00},
    {0x20,0x10,0x00,0x08,0x10,0x20,0x20,0x00},
    {0x88,0x5c,0x0c,0x3e,0x48,0x88,0xb6,0x00},
    {0xbe,0x48,0x0e,0x12,0x5c,0x84,0xbe,0x00},
    {0x88,0x3e,0x2a,0x2a,0xbe,0x88,0x88,0x00},
    {0x88,0x0a,0x3c,0x18,0xac,0x8a,0x98,0x00},
    {0xbe,0x22,0x22,0x3e,0x94,0x94,0xa6,0x00},
    {0xba,0x16,0x1e,0x2e,0x9a,0x92,0xa6,0x00},
    {0xbe,0x2a,0x3e,0x2a,0xb6,0xbe,0xbe,0x00},
    {0x88,0x3e,0x14,0x1c,0x88,0xaa,0x98,0x00},
    {0x88,0x3e,0x14,0x1c,0xbe,0x88,0xaa,0x00},
    {0x7c,0x44,0x44,0x44,0x44,0x44,0x86,0x00},
    {0x08,0x0e,0x78,0x5e,0x6c,0x54,0xae,0x00},
    {0x7c,0x44,0x54,0x7c,0x54,0x7c,0x96,0x00},
    {0x24,0x58,0xfe,0x48,0x3c,0x28,0xce,0x00},
    {0x7c,0x54,0x7c,0x6c,0x7c,0x54,0xbe,0x00},
    {0x82,0x82,0x82,0x82,0x82,0x82,0xfe,0x00},
    {0x7c,0x08,0x9a,0xf6,0xda,0xf6,0xfe,0x00},
    {0xfe,0x12,0x52,0x32,0x2e,0x42,0x86,0x00},
    {0x12,0xea,0x2a,0xfa,0x22,0x22,0x46,0x00},
    {0x22,0x7a,0x3a,0xfa,0x22,0x52,0x86,0x00},
    {0x42,0x7a,0xba,0x3a,0x5a,0xaa,0x5a,0x00},
    {0x5e,0xea,0x4a,0xea,0x4a,0xaa,0xd6,0x00},
    {0x7a,0x6e,0x6e,0xfe,0x6a,0x6a,0x4a,0x00},
    {0x12,0x6a,0xfa,0x2a,0x72,0x52,0x76,0x00},
    {0x22,0xfa,0x52,0xaa,0x72,0x7a,0x0a,0x00},
    {0x52,0x2a,0xda,0x2a,0xfa,0x72,0xaa,0x00},
    {0xbe,0x4a,0xfa,0x6a,0xee,0x6a,0xb6,0x00},
    {0xfa,0x56,0xa6,0x56,0xfa,0x22,0xfa,0x00},
    {0x42,0xea,0x4a,0xaa,0xe2,0x46,0xbe,0x00},
    {0x22,0xfa,0x6a,0x7a,0x22,0x72,0xaa,0x00},
    {0x22,0xfa,0x2a,0x5a,0xfa,0x12,0x56,0x00},
    {0xf2,0x9a,0xfa,0x4a,0x72,0xb2,0x56,0x00},
    {0x24,0xfe,0x74,0x54,0xfe,0x22,0xc6,0x00},
    {0xaa,0xfa,0x0a,0xfa,0x52,0x3a,0xe6,0x00},
    {0x72,0xfa,0x52,0xda,0x22,0x72,0xaa,0x00},
    {0x52,0xfa,0x2a,0x5a,0xfa,0x52,0x76,0x00},
    {0x52,0xaa,0x7a,0x7a,0xfa,0x72,0xaa,0x00},
    {0xfa,0x52,0xfa,0xfa,0x72,0x22,0xaa,0x00},
    {0x22,0x5a,0xfa,0xaa,0xfa,0x52,0xaa,0x00},
    {0x2e,0x56,0xfe,0xb6,0xf6,0x5a,0xaa,0x00},
    {0x2e,0x56,0xf6,0xbe,0xf6,0x5a,0xaa,0x00},
    {0x2e,0x56,0xfe,0xb6,0xf6,0x2a,0xda,0x00},
    {0x64,0x6e,0xca,0x64,0xfe,0x22,0xc6,0x00},
    {0x22,0xfa,0x5a,0xaa,0x52,0x72,0x96,0x00},
    {0x54,0xfe,0xba,0x54,0xfe,0x54,0xa4,0x00},
    {0x44,0xfe,0xba,0x5c,0xfe,0x5c,0xac,0x00},
    {0x44,0x7e,0x96,0x76,0x76,0x1a,0x3a,0x00},
    {0xe8,0x7e,0xaa,0x0a,0xea,0xaa,0xf6,0x00},
    {0x48,0xfe,0x4a,0xea,0x0a,0xea,0xf6,0x00},
    {0x54,0x92,0x7c,0x28,0xde,0x14,0x6c,0x00},
    {0xf4,0x5e,0xa6,0x56,0xf6,0x2a,0xfa,0x00},
    {0x24,0xfe,0x56,0x76,0x26,0xaa,0x6a,0x00},
    {0x7c,0x7c,0x74,0x5e,0x76,0x5a,0xea,0x00},
    {0xaa,0x44,0xfe,0x92,0x7c,0x24,0xcc,0x00},
    {0x28,0xfe,0x2a,0xfa,0x6a,0x6a,0x96,0x00},
    {0x54,0xae,0x76,0x76,0xf6,0x7a,0xaa,0x00},
    {0x48,0xae,0xf0,0xe8,0x9e,0xea,0x96,0x00},
    {0xf4,0x5e,0x26,0x56,0xa6,0x1a,0x6a,0x00},
    {0x64,0xfe,0x66,0x66,0xf6,0x0a,0xaa,0x00},
    {0xf4,0xae,0xf6,0xf6,0xa6,0xfa,0xda,0x00},
    {0x54,0xfe,0xde,0x66,0x76,0xea,0x7a,0x00},
    {0x40,0x7e,0x82,0x02,0x02,0x02,0x06,0x00},
    {0x40,0x7e,0xaa,0x3a,0x4e,0x92,0x26,0x00},
    {0x40,0x7e,0xaa,0x52,0x6a,0x7a,0x06,0x00},
    {0x40,0x7e,0xfe,0x56,0x7e,0x56,0x7e,0x00},
    {0x40,0x7e,0x92,0x7a,0x12,0x7a,0x5a,0x00},
    {0x40,0x7e,0x82,0x7a,0x32,0x7a,0x7a,0x00},
    {0x24,0xf6,0x6a,0x96,0x66,0x74,0x16,0x00},
    {0x40,0x44,0x58,0xe0,0x40,0x42,0x3e,0x00},
    {0xfe,0x80,0x80,0x80,0x80,0x80,0xfe,0x00},
    {0xfe,0xaa,0xbe,0xaa,0xbe,0x88,0xfe,0x00},
    {0xfe,0xd4,0xbe,0xd4,0x9e,0xd4,0xfe,0x00},
    {0xfe,0x98,0xbc,0x98,0x98,0xa4,0xfe,0x00},
    {0xfe,0x88,0x9c,0xbe,0x94,0xaa,0xfe,0x00},
    {0xfe,0x40,0x40,0x40,0x40,0x40,0x3e,0x00},
    {0xfe,0x94,0x9c,0x80,0xb6,0xb6,0xfe,0x00},
    {0x10,0xf8,0x2a,0xce,0x10,0xfe,0x10,0x00},
    {0x54,0x54,0x54,0xfe,0x54,0x54,0x94,0x00},
    {0x54,0x54,0xfe,0x54,0x54,0x54,0x7c,0x00},
    {0x10,0x7c,0x10,0x24,0xfe,0x24,0x44,0x00},
    {0xf2,0x12,0x12,0xfe,0x90,0x90,0x9e,0x00},
    {0x94,0x1e,0x34,0x9e,0x10,0xfe,0x10,0x00},
    {0x10,0xfe,0x10,0x18,0x14,0x10,0x10,0x00},
    {0x3c,0x24,0x24,0x24,0x2c,0x20,0x20,0x00},
    {0x0c,0x70,0x7e,0x5c,0x54,0x52,0x9e,0x00},
    {0x4e,0x7a,0x5a,0xba,0x1a,0x28,0xc8,0x00},
    {0x5e,0x8a,0x2a,0x5a,0x8a,0x68,0x68,0x00},
    {0x54,0x92,0x28,0xfe,0x6c,0xa2,0x38,0x00},
    {0x7e,0x40,0x40,0x40,0x40,0x40,0x80,0x00},
    {0x7e,0x50,0x7a,0x54,0x52,0x54,0xae,0x00},
    {0x7e,0x68,0x7a,0x6a,0x7a,0x42,0xaa,0x00},
    {0x7e,0x5e,0x4c,0x4c,0x54,0x48,0xb6,0x00},
    {0x7e,0x68,0x56,0x6e,0x74,0x54,0xaa,0x00},
    {0x7e,0x5a,0x7c,0x5c,0x7e,0x46,0xaa,0x00},
    {0x7e,0x54,0x6e,0x7a,0x7a,0x7c,0xaa,0x00},
    {0x10,0x10,0x10,0x20,0x28,0x44,0xfa,0x00},
    {0x28,0x74,0xaa,0xfe,0x54,0x8a,0x30,0x00},
    {0x48,0x6e,0xb4,0x38,0xfe,0x5a,0xb4,0x00},
    {0x54,0x7e,0xec,0x7e,0x28,0x10,0xee,0x00},
    {0x56,0x92,0xd6,0xfe,0x28,0x10,0xee,0x00},
    {0x7c,0x44,0xfe,0xfe,0x28,0x10,0xee,0x00},
    {0x54,0xee,0x54,0xba,0x28,0x10,0xee,0x00},
    {0x1e,0xe4,0xa4,0xa4,0xe4,0x04,0x0c,0x00},
    {0x1e,0xea,0xaa,0xaa,0xea,0x12,0x26,0x00},
    {0x14,0xd4,0xd4,0xd4,0xd4,0x14,0x22,0x00},
    {0x18,0xe8,0xa8,0xa8,0xf4,0x14,0x22,0x00},
    {0x1c,0xc8,0xc8,0xfe,0xc8,0x08,0x18,0x00},
    {0x18,0xdc,0xe8,0xc8,0xfe,0x08,0x08,0x00},
    {0x1e,0xd4,0xd4,0xfe,0xcc,0x34,0x0c,0x00},
    {0x04,0xd8,0xd0,0xde,0xd4,0x14,0x24,0x00},
    {0x08,0xfe,0xc0,0xdc,0xd4,0x14,0x26,0x00},
    {0x3c,0xcc,0xd4,0xdc,0xf4,0x14,0x36,0x00},
    {0x08,0xd2,0xfe,0xd4,0xd4,0x14,0x26,0x00},
    {0x18,0xe8,0xbe,0xaa,0xf6,0x22,0x26,0x00},
    {0x14,0xd4,0xe2,0xdc,0xd4,0x14,0x2c,0x00},
    {0x10,0xfe,0x28,0x10,0xee,0x7c,0x7c,0x00},
    {0x1e,0xf2,0xbe,0xb4,0xf4,0x12,0x22,0x00},
    {0x18,0xc0,0xd8,0xfa,0xdc,0x2a,0x18,0x00},
    {0x3e,0xc2,0xde,0xd6,0xde,0x02,0x06,0x00},
    {0x74,0xd4,0x2a,0xd0,0x7e,0x44,0x7c,0x00},
    {0x08,0xfe,0xd0,0xf4,0xc8,0x14,0x3a,0x00},
    {0x02,0xdc,0xd4,0xd4,0xd4,0x16,0x2a,0x00},
    {0x3e,0xea,0xbe,0xaa,0xfe,0x08,0x08,0x00},
    {0x24,0xb6,0xa4,0xf6,0x7c,0x44,0x7c,0x00},
    {0xee,0xaa,0xee,0x38,0x28,0x2a,0xce,0x00},
    {0x08,0xfe,0xaa,0xbe,0xea,0x3e,0x08,0x00},
    {0x1c,0xd4,0xdc,0xd4,0xdc,0x14,0x3e,0x00},
    {0x16,0xd2,0xfa,0xea,0xf4,0x14,0x2a,0x00},
    {0x08,0xea,0xfe,0xc8,0xea,0x2a,0x3e,0x00},
    {0x12,0xee,0xa2,0xaa,0xe6,0x22,0x26,0x00},
    {0x08,0xee,0xb2,0xae,0xee,0x08,0x0e,0x00},
    {0x08,0xdc,0xc8,0xfe,0xdc,0x08,0x3e,0x00},
    {0xee,0xee,0x38,0xfe,0x20,0x3c,0x04,0x00},
    {0x04,0x7e,0x44,0x74,0x46,0x74,0xba,0x00},
    {0x3e,0xd4,0xfa,0xc8,0xdc,0x08,0x3e,0x00},
    {0x08,0xfe,0xd4,0xe2,0xd4,0x08,0x36,0x00},
    {0x14,0xfe,0xd4,0xd4,0xfe,0x00,0x22,0x00},
    {0x08,0xd4,0xee,0xc0,0xdc,0x14,0x1c,0x00},
    {0x90,0x1e,0x2a,0x94,0x7c,0x44,0x7c,0x00},
    {0x76,0x56,0x56,0x60,0x6a,0x50,0x8e,0x00},
    {0x3e,0xd4,0xbe,0xb6,0xf6,0x22,0x3e,0x00},
    {0x08,0xfe,0xe6,0xd8,0xfe,0x08,0x0e,0x00},
    {0x0a,0xdc,0xc8,0xfe,0xd0,0x28,0x0e,0x00},
    {0x7c,0x5c,0x54,0xfe,0xba,0xaa,0xba,0x00},
    {0x16,0xe0,0xb6,0xb2,0xf2,0x12,0x16,0x00},
    {0xfe,0x54,0x74,0xfe,0x74,0x54,0x74,0x00},
    {0x0e,0xf4,0xfe,0xd4,0xd6,0x3c,0x12,0x00},
    {0x14,0xc8,0xd4,0xfe,0xc8,0x1e,0x2a,0x00},
    {0x1c,0xc8,0xfc,0xd4,0xfe,0x14,0x1c,0x00},
    {0x3e,0xdc,0xdc,0xc8,0xd8,0x08,0x36,0x00},
    {0x0a,0xdc,0xc8,0xfe,0xd4,0x2e,0x04,0x00},
    {0xee,0xaa,0xee,0x14,0xfe,0x10,0xee,0x00},
    {0x0a,0xfe,0xa8,0xbe,0xea,0x3e,0x2a,0x00},
    {0x3e,0xc8,0xfe,0xd4,0xfe,0x14,0x24,0x00},
    {0x14,0xfa,0xd0,0xdc,0xda,0x2c,0x2a,0x00},
    {0x3e,0xe4,0xae,0xa4,0xee,0x24,0x5e,0x00},
    {0x26,0xfe,0xd6,0xde,0xf6,0x3c,0x04,0x00},
    {0x08,0xfe,0xf6,0xc0,0xdc,0x08,0x3e,0x00},
    {0x28,0x3e,0x68,0xbe,0x3c,0x24,0x3c,0x00},
    {0x3e,0xd4,0xaa,0xbe,0xea,0x14,0x2a,0x00},
    {0x08,0xce,0xdc,0xd4,0xdc,0x3e,0x08,0x00},
    {0x2a,0xd4,0xe2,0xc8,0xea,0x14,0x22,0x00},
    {0x0e,0xd2,0xc4,0xd6,0xe2,0x36,0x3e,0x00},
    {0x08,0xd4,0xee,0xdc,0xc4,0x32,0x2e,0x00},
    {0x3e,0xd2,0xde,0xd4,0xde,0x24,0x1a,0x00},
    {0x38,0xd6,0xfe,0xd6,0xd8,0x34,0x52,0x00},
    {0x0e,0xd4,0xfe,0xe8,0xda,0x2c,0x1a,0x00},
    {0x08,0xfe,0xee,0xd4,0xc8,0x36,0x1c,0x00},
    {0x0c,0xf4,0xa8,0xb4,0xe2,0x1c,0x1c,0x00},
    {0x04,0xfe,0xa4,0xbc,0xe6,0x3c,0x5a,0x00},
    {0x3e,0xea,0xbe,0xbe,0xf4,0x1c,0x14,0x00},
    {0x10,0xfe,0x24,0xfe,0xaa,0x7c,0x7c,0x00},
    {0x34,0xd4,0xfe,0xdc,0xf4,0x34,0x1a,0x00},
    {0x2a,0xfe,0xc0,0xfe,0xd0,0x3e,0x2a,0x00},
    {0x16,0xfe,0xae,0xbe,0xe6,0x34,0x24,0x00},
    {0xee,0xaa,0xfe,0x54,0x7c,0xfe,0x10,0x00},
    {0x08,0xfe,0xd4,0xfe,0xea,0x1c,0x14,0x00},
    {0x08,0xfe,0xc8,0xf6,0xea,0x3e,0x2a,0x00},
    {0x38,0xd4,0xee,0xc0,0xfa,0x3c,0x2a,0x00},
    {0x12,0xfe,0xb6,0xbe,0xd2,0x3a,0x56,0x00},
    {0x08,0xfe,0xd4,0xfe,0xe2,0x14,0x26,0x00},
    {0x08,0xdc,0xd4,0xdc,0xde,0x02,0x2a,0x00},
    {0x08,0xdc,0xd4,0xdc,0xfe,0x08,0x36,0x00},
    {0x14,0xfe,0xc8,0xfe,0xde,0x14,0x2e,0x00},
    {0x3e,0xc8,0xdc,0xdc,0xf4,0x08,0x36,0x00},
    {0x0a,0xdc,0xfe,0xd8,0xee,0x1c,0x1c,0x00},
    {0x2a,0xfe,0xc8,0xfe,0xdc,0x0a,0x3e,0x00},
    {0x10,0xde,0xcc,0xec,0xfe,0x00,0x22,0x00},
    {0x3e,0xec,0xac,0xa0,0xf6,0x36,0x3e,0x00},
    {0x14,0xfe,0xd6,0xfe,0xd6,0x1c,0x2a,0x00},
    {0x08,0xdc,0xc8,0xfe,0xdc,0x1c,0x22,0x00},
    {0x14,0xfe,0xd6,0xdc,0xde,0x2c,0x2a,0x00},
    {0x14,0xfe,0xba,0xbc,0xd4,0x34,0x5a,0x00},
    {0x08,0xfe,0xd4,0xfe,0xfe,0x7e,0x94,0x00},
    {0x24,0xde,0xec,0xcc,0xde,0x24,0x3e,0x00},
    {0x08,0xfe,0xc8,0xfe,0xea,0x14,0x3e,0x00},
    {0x6c,0x6c,0xfe,0x10,0xfe,0x6c,0x6c,0x00},
    {0xaa,0x44,0xfe,0xba,0x10,0x7c,0x7c,0x00},
    {0x24,0xf6,0xe4,0xfe,0xdc,0x1c,0x24,0x00},
    {0x2a,0xfc,0xac,0xbe,0xfe,0x06,0x2a,0x00},
    {0x3e,0xda,0xbe,0xba,0xde,0x3a,0x12,0x00},
    {0x20,0xfe,0xd4,0xfe,0xd4,0x3e,0x2a,0x00},
    {0x08,0xfe,0xd4,0xfe,0xdc,0x32,0x2e,0x00},
    {0x12,0xf6,0xd2,0xdc,0xfe,0x08,0x2a,0x00},
    {0x08,0xdc,0xce,0xf4,0xe2,0x36,0x56,0x00},
    {0x24,0xf6,0xd2,0xfe,0xdc,0x2a,0x3e,0x00},
    {0x1c,0xf4,0xbe,0xaa,0xfe,0x1c,0x2a,0x00},
    {0x14,0xfe,0xdc,0xd4,0xfe,0x22,0x2a,0x00},
    {0x08,0xfe,0xba,0xac,0xfe,0x08,0x18,0x00},
    {0x08,0xdc,0xd4,0xfe,0xea,0x3e,0x14,0x00},
    {0x16,0xee,0xf6,0xca,0xd6,0x2a,0x1e,0x00},
    {0x08,0xdc,0xfe,0xfe,0xcc,0x18,0x2e,0x00},
    {0x08,0xdc,0xfe,0xfe,0xce,0x18,0x2e,0x00},
    {0x14,0xfe,0xdc,0xd4,0xfe,0x00,0x2a,0x00},
    {0x76,0xb6,0x66,0xb4,0xfe,0xaa,0xba,0x00},
    {0x36,0xf6,0xea,0xd0,0xfe,0x14,0x3a,0x00},
    {0x6c,0x7e,0x60,0x76,0x5a,0x74,0x9a,0x00},
    {0x6c,0x6c,0xfe,0x38,0x38,0xee,0x6c,0x00},
    {0x1c,0xea,0xbe,0xbe,0xe6,0x32,0x26,0x00},
    {0x1e,0xec,0xbe,0xa4,0xf6,0x3e,0x12,0x00},
    {0x12,0xfc,0xee,0xd4,0xfe,0x3c,0x56,0x00},
    {0x34,0xde,0xbe,0xbe,0xd6,0x3a,0x16,0x00},
    {0x14,0xfe,0xd4,0xda,0xfe,0x14,0x3a,0x00},
    {0x74,0xda,0xf6,0xd6,0xf0,0x06,0x56,0x00},
    {0x3e,0xfe,0xaa,0xbc,0xfe,0x2e,0x5a,0x00},
    {0x16,0xfe,0xda,0xfe,0xda,0x16,0x1e,0x00},
    {0xfe,0x82,0x82,0x82,0x82,0x82,0xfe,0x00},
    {0xfe,0x9a,0xae,0xea,0xaa,0xae,0xfe,0x00},
    {0xfe,0x92,0xaa,0xfe,0x96,0x92,0xfe,0x00},
    {0xfe,0xaa,0xce,0xbe,0x9a,0xaa,0xfe,0x00},
    {0xfe,0xa2,0xfa,0xa2,0xda,0x9a,0xfe,0x00},
    {0xfe,0xba,0xf2,0xaa,0xfe,0xba,0xfe,0x00},
    {0xfe,0x92,0xfe,0xaa,0xfe,0x92,0xfe,0x00},
    {0xfe,0xaa,0xfe,0xba,0xf6,0xba,0xfe,0x00},
    {0xfe,0x8a,0xfe,0xea,0x8a,0xe6,0xfe,0x00},
    {0xfe,0x9a,0xfe,0xaa,0xfe,0x8a,0xfe,0x00},
    {0xfe,0xba,0xaa,0xba,0xba,0xc6,0xfe,0x00},
    {0xfe,0x92,0xfe,0xba,0xfe,0x8a,0xfe,0x00},
    {0xfe,0xaa,0xba,0xfe,0xaa,0xba,0xfe,0x00},
    {0x10,0xfe,0x54,0xba,0xfe,0x6c,0x7c,0x00},
    {0xfe,0xba,0xfe,0xba,0xea,0xb6,0xfe,0x00},
    {0x58,0x48,0xe8,0x48,0x74,0xd4,0x22,0x00},
    {0x7e,0x48,0xec,0x4a,0x68,0xc8,0x08,0x00},
    {0x48,0x48,0xea,0x6a,0x6a,0xea,0x3e,0x00},
    {0x50,0x5e,0xea,0x48,0x68,0xd4,0x22,0x00},
    {0x44,0x58,0xf0,0x5e,0x74,0xd4,0x24,0x00},
    {0x44,0x44,0xf6,0x54,0x74,0xd4,0x3e,0x00},
    {0x7e,0x48,0xc8,0x5c,0x6a,0xc8,0x08,0x00},
    {0x54,0x7e,0xd4,0x5c,0x74,0xd4,0x1c,0x00},
    {0x0c,0x70,0xfe,0x54,0xd6,0x38,0xfe,0x00},
    {0x2a,0x5e,0xc4,0x52,0x7c,0x10,0xfe,0x00},
    {0x48,0x7e,0xea,0x7c,0x74,0xe8,0x36,0x00},
    {0x4a,0x56,0xf2,0x5a,0x72,0xd2,0x16,0x00},
    {0x50,0x5e,0xe2,0x5a,0x5a,0xd0,0x1e,0x00},
    {0x48,0x7e,0xd0,0x6a,0x54,0xcc,0x32,0x00},
    {0x5e,0x52,0xfe,0x52,0x7e,0xd4,0x1a,0x00},
    {0x56,0x60,0xd6,0x72,0x52,0xd2,0x16,0x00},
    {0x7e,0x54,0xfa,0x48,0x5c,0xc8,0x3e,0x00},
    {0x54,0x40,0xfe,0x54,0x7e,0xd4,0x24,0x00},
    {0x48,0x4e,0xe8,0x5e,0x6c,0xca,0x08,0x00},
    {0x48,0x52,0xfe,0x50,0x7e,0xc8,0x36,0x00},
    {0x4c,0x74,0xde,0x5a,0x5e,0xd2,0x26,0x00},
    {0x4a,0x7e,0xc8,0x7e,0x6a,0xfe,0x2a,0x00},
    {0x5c,0x6a,0xc4,0x7e,0x44,0xd4,0x0c,0x00},
    {0x4c,0x54,0xe8,0x5e,0x64,0xd4,0x0c,0x00},
    {0xfe,0x6c,0x44,0x6c,0xfe,0x10,0xfe,0x00},
    {0x54,0x7e,0xc4,0x54,0x76,0xd4,0x16,0x00},
    {0x48,0x7e,0xd4,0x54,0x6a,0xfe,0x08,0x00},
    {0x7e,0x6a,0xfe,0x6a,0x7e,0xea,0x56,0x00},
    {0x5e,0x4c,0xfe,0x5e,0x7e,0xc4,0x1e,0x00},
    {0x4e,0x4a,0xea,0x5e,0x72,0xd6,0x16,0x00},
    {0x50,0x5e,0xf4,0x5c,0x5e,0xea,0x16,0x00},
    {0x3c,0x54,0xfe,0x5c,0x6a,0x10,0xfe,0x00},
    {0x48,0x5c,0xf4,0x5c,0x7e,0xc2,0x2a,0x00},
    {0xaa,0x44,0xfe,0x92,0x38,0x10,0xfe,0x00},
    {0xa0,0x3e,0x9c,0x3e,0x9c,0x10,0xfe,0x00},
    {0x4e,0xba,0x90,0xfe,0x6a,0x34,0xca,0x00},
    {0x48,0x7c,0xe8,0x7e,0x64,0xfe,0x14,0x00},
    {0x5e,0x5a,0xfe,0x44,0x76,0xd4,0x1e,0x00},
    {0x2e,0xf8,0x6e,0xf4,0x24,0x10,0xfe,0x00},
    {0xee,0xe4,0xee,0x46,0xec,0x10,0xfe,0x00},
    {0x76,0x76,0xe2,0x6e,0x6e,0xee,0x22,0x00},
    {0x44,0x46,0xfc,0x56,0x70,0xd4,0x2e,0x00},
    {0x54,0x62,0xfe,0x76,0x7e,0xd4,0x0c,0x00},
    {0x48,0x5e,0xde,0x5a,0x7e,0xc8,0x36,0x00},
    {0x48,0x7e,0xda,0x7e,0x48,0xf4,0x1a,0x00},
    {0x48,0x7e,0xd4,0x6a,0x7e,0xf6,0x3e,0x00},
    {0x54,0x7e,0xdc,0x4c,0x7e,0xdc,0x2c,0x00},
    {0xc8,0xde,0x88,0xde,0x8e,0x10,0xfe,0x00},
    {0x10,0xfe,0x8e,0x5c,0x8e,0x10,0xfe,0x00},
    {0x7e,0x74,0x4e,0x74,0xba,0x10,0xfe,0x00},
    {0x6e,0xfa,0xaa,0x74,0xea,0x10,0xfe,0x00},
    {0x48,0x5c,0xee,0x5c,0x6a,0xdc,0x3e,0x00},
    {0x48,0x7e,0xec,0x7e,0x6c,0xec,0x32,0x00},
    {0x7c,0x54,0x7c,0xee,0xee,0x10,0xfe,0x00},
    {0x7e,0x6c,0xfe,0x60,0x6a,0xc4,0x1e,0x00},
    {0x5c,0x54,0xfe,0x76,0x4c,0xd4,0x3a,0x00},
    {0x48,0x7e,0xf6,0x5c,0x7e,0xf4,0x1a,0x00},
    {0x26,0xfc,0x52,0xf4,0x56,0x10,0xfe,0x00},
    {0xa4,0xa4,0xfe,0x24,0xe4,0x64,0xae,0x00},
    {0x10,0xfe,0x10,0xfe,0xaa,0x6c,0xfe,0x00},
    {0x10,0xfe,0x10,0xfe,0xba,0x28,0xfe,0x00},
    {0x5e,0x4a,0xec,0x56,0x6a,0xce,0x0a,0x00},
    {0x10,0xfe,0x10,0xfe,0xba,0x6c,0xfe,0x00},
    {0x10,0x7c,0xfe,0x10,0xfe,0x64,0x6c,0x00},
    {0x20,0x3c,0x44,0xa8,0x10,0x28,0xc6,0x00},
    {0x20,0xbc,0x44,0xa8,0x10,0x28,0xc6,0x00},
    {0x38,0xdc,0x3c,0x3c,0x68,0x10,0xee,0x00},
    {0x38,0x08,0xfe,0x1c,0x64,0x18,0xe0,0x00},
    {0x24,0xfe,0x6c,0xbe,0x64,0x18,0xe0,0x00},
    {0x76,0x7a,0x24,0xf6,0x2a,0x74,0xa8,0x00},
    {0x10,0x7c,0x14,0xfe,0x10,0x28,0xc6,0x00},
    {0x0c,0x70,0x10,0xfe,0x10,0x28,0xc6,0x00},
    {0x10,0xfe,0x28,0xc6,0x10,0xfe,0x10,0x00},
    {0x10,0xfe,0x28,0xc6,0x38,0x3c,0x04,0x00},
    {0x10,0xfe,0x54,0x54,0xba,0x10,0xee,0x00},
    {0x10,0x7c,0x28,0xfe,0x74,0x54,0x74,0x00},
    {0x10,0xfe,0x28,0xaa,0x7c,0x10,0xee,0x00},
    {0x38,0xc8,0x7c,0x6c,0xfe,0x10,0xee,0x00},
    {0x10,0xfe,0x28,0xd6,0x38,0x10,0xfe,0x00},
    {0x7c,0x52,0xa0,0x14,0xfe,0x10,0xee,0x00},
    {0xa4,0xfe,0x64,0xae,0x7c,0x10,0xee,0x00},
    {0x10,0xfe,0x28,0xd6,0x7e,0x34,0xdc,0x00},
    {0x28,0xc6,0x7c,0x6c,0xfe,0x10,0xee,0x00},
    {0x10,0x7c,0x7c,0x74,0xfe,0x10,0xee,0x00},
    {0xac,0xf4,0x7e,0xac,0xfe,0x10,0xee,0x00},
    {0x10,0xfe,0x24,0xda,0x58,0x76,0x7e,0x00},
    {0x2e,0x24,0xf4,0x5e,0x64,0x34,0xc4,0x00},
    {0x28,0x2e,0xf2,0x5a,0x66,0x32,0xc6,0x00},
    {0xa4,0xa4,0xfe,0x2a,0xec,0x64,0xba,0x00},
    {0x2c,0x40,0xde,0x48,0x5e,0x4c,0x5a,0x00},
    {0x28,0x7e,0xd0,0x5c,0x7e,0x54,0x7a,0x00},
    {0x54,0x54,0xfe,0xb4,0xd4,0x7c,0x96,0x00},
    {0x2e,0x2a,0xfe,0x5a,0x6e,0x30,0xce,0x00},
    {0x5c,0x54,0xf4,0xbe,0xe4,0x7e,0x8c,0x00},
    {0x88,0xbe,0xdc,0xd8,0xde,0x4a,0xb6,0x00},
    {0x24,0xfe,0x7c,0x10,0xfe,0x28,0xf6,0x00},
    {0xbe,0x94,0xd4,0xfe,0xd4,0x54,0xa4,0x00},
    {0x92,0xac,0xe4,0xee,0xe4,0x64,0xae,0x00},
    {0x94,0xb6,0xd4,0xf6,0xd4,0x54,0xa6,0x00},
    {0x8e,0xb4,0xfe,0xd4,0xd6,0x7c,0x92,0x00},
    {0x2c,0x2c,0xf0,0x5e,0x72,0x3e,0xd2,0x00},
    {0x88,0x2a,0x8c,0x30,0xfe,0x28,0xf6,0x00},
    {0xbe,0x96,0xfc,0xd6,0xfe,0x54,0xac,0x00},
    {0x24,0x2e,0xfe,0x5e,0x68,0x3e,0xc2,0x00},
    {0x5e,0x56,0xfe,0xb6,0xde,0x6a,0x96,0x00},
    {0xbe,0xb2,0xee,0xfa,0xfe,0x62,0xa6,0x00},
    {0x9c,0xaa,0xc0,0xfe,0xdc,0x48,0xbe,0x00},
    {0x88,0xbe,0xe2,0xde,0xea,0x58,0xae,0x00},
    {0xb8,0x9e,0xda,0xda,0xdc,0x7a,0x88,0x00},
    {0xfe,0x6a,0xf4,0x2a,0xfe,0x28,0xf6,0x00},
    {0x88,0xbe,0xea,0xfe,0xd4,0x7e,0x84,0x00},
    {0x24,0xfe,0x6c,0xb6,0x7c,0x28,0xf6,0x00},
    {0x5e,0x56,0xfe,0xb0,0xd6,0x56,0xa6,0x00},
    {0x5e,0x56,0xfa,0xbe,0xc0,0x6c,0x9e,0x00},
    {0x94,0xbe,0xd4,0xfe,0xdc,0x7e,0x94,0x00},
    {0x5e,0x4a,0xfe,0xb4,0xde,0x6a,0x9e,0x00},
    {0x96,0xaa,0xea,0xfe,0xd4,0x48,0xb6,0x00},
    {0x5e,0x54,0xfe,0xb4,0xde,0x62,0x96,0x00},
    {0x5e,0x4c,0xfe,0xb0,0xde,0x62,0x96,0x00},
    {0xbe,0xac,0xec,0xe0,0xf6,0x76,0xbe,0x00},
    {0xaa,0x9c,0xf6,0xdc,0xfe,0x6a,0x88,0x00},
    {0x94,0xbe,0xf6,0xfe,0xd6,0x7c,0x92,0x00},
    {0xbe,0x9c,0xdc,0xc0,0xfe,0x48,0xaa,0x00},
    {0xb6,0xb6,0xe2,0xee,0xee,0x76,0xa2,0x00},
    {0xb6,0xb6,0xea,0xfe,0xea,0x7e,0xaa,0x00},
    {0x9c,0xbe,0xd4,0xea,0xfe,0x62,0xaa,0x00},
    {0xb6,0xb6,0xdc,0xdc,0xdc,0x7e,0x88,0x00},
    {0x64,0x6e,0xca,0x64,0xfe,0x28,0xf6,0x00},
    {0xd6,0xd6,0xfe,0x6c,0xf6,0x56,0xaa,0x00},
    {0xb4,0xbc,0xfe,0xd6,0xde,0x5c,0xaa,0x00},
    {0x88,0xbe,0xea,0xf4,0xdc,0x5c,0xa2,0x00},
    {0x88,0x9c,0xd4,0xfe,0xea,0x7e,0x94,0x00},
    {0x96,0xba,0xf0,0xfe,0xde,0x70,0x9a,0x00},
    {0x88,0xbe,0xf6,0xdc,0xfe,0x74,0x9a,0x00},
    {0xac,0x94,0xfe,0xd4,0xfe,0x54,0xba,0x00},
    {0x9c,0xbe,0xea,0xc0,0xd6,0x7e,0x96,0x00},
    {0x7c,0x08,0x10,0x1e,0xf0,0x10,0x30,0x00},
    {0x78,0x2e,0x22,0xdc,0x08,0xfe,0x10,0x00},
    {0x7c,0x52,0xb8,0x08,0xfe,0x10,0x30,0x00},
    {0x10,0x7c,0xfe,0xba,0x08,0xfe,0x10,0x00},
    {0x2e,0xfa,0x54,0xfa,0x08,0xfe,0x10,0x00},
    {0xe8,0x3e,0x50,0x6a,0xd4,0x4c,0xf2,0x00},
    {0x28,0xfc,0x54,0x74,0x1c,0xf4,0x26,0x00},
    {0x24,0xfe,0x24,0x48,0x3c,0xfe,0x10,0x00},
    {0x5c,0xaa,0xe0,0xec,0xe4,0x7e,0xa8,0x00},
    {0x2c,0x54,0xfe,0xba,0x08,0xfe,0x10,0x00},
    {0x10,0xfe,0x28,0x10,0x6c,0xfe,0x10,0x00},
    {0xec,0x3e,0x56,0x6e,0xc4,0x5e,0xd6,0x00},
    {0x00,0x00,0x10,0xfe,0x82,0x00,0x00,0x00},
    {0x10,0xfe,0x82,0x4c,0x70,0x42,0x3e,0x00},
    {0x10,0xfe,0xfa,0x48,0x78,0x50,0x7c,0x00},
    {0x10,0xfe,0xfa,0x40,0x7c,0x68,0xb6,0x00},
    {0x10,0xfe,0xbe,0xd4,0x7c,0x2a,0xce,0x00},
    {0x10,0xfe,0xea,0x0c,0xe8,0x54,0xbe,0x00},
    {0x10,0xfe,0xaa,0x3c,0x7e,0xa8,0x3e,0x00},
    {0x10,0xfe,0xaa,0x7c,0x18,0x50,0xbe,0x00},
    {0x10,0xfe,0xea,0x3c,0xe8,0x7c,0xaa,0x00},
    {0x10,0xfe,0xea,0x3c,0xec,0x7e,0xac,0x00},
    {0x10,0xfe,0xba,0x6c,0x38,0x38,0xc6,0x00},
    {0x10,0xfe,0xe2,0x2e,0xea,0x64,0xaa,0x00},
    {0x10,0xfe,0xaa,0x7c,0xfe,0x10,0xee,0x00},
    {0x10,0xfe,0xb6,0x28,0xd6,0x08,0x30,0x00},
    {0x10,0xfe,0xaa,0x48,0x7e,0x82,0x56,0x00},
    {0x10,0xfe,0xba,0x7c,0x3c,0xe8,0x36,0x00},
    {0x10,0xfe,0xea,0x4c,0xfc,0x7c,0xc6,0x00},
    {0x10,0xfe,0xea,0x54,0xfc,0x7c,0xc6,0x00},
    {0x42,0xee,0x42,0xaa,0xe2,0x46,0xbe,0x00},
    {0xa6,0xaa,0xe4,0x3e,0xe2,0x6a,0xa6,0x00},
    {0x10,0xfe,0x38,0x34,0xfe,0x28,0x18,0x00},
    {0xaa,0xf6,0x52,0xfa,0x66,0x32,0xc6,0x00},
    {0x40,0x7e,0x90,0x54,0x52,0x92,0x30,0x00},
    {0x54,0xfc,0x5e,0x54,0xf2,0xa4,0xf8,0x00},
    {0x10,0xfe,0x10,0x18,0x18,0x2a,0xce,0x00},
    {0x52,0xf4,0x42,0x64,0x62,0x64,0xbe,0x00},
    {0x7e,0x42,0x7e,0x40,0x40,0x40,0x80,0x00},
    {0x7c,0x14,0xfe,0x14,0x7c,0x20,0xc0,0x00},
    {0x7e,0x42,0x7e,0x64,0x76,0x64,0xb6,0x00},
    {0x7e,0x7e,0x48,0x6a,0x7e,0x6a,0xbe,0x00},
    {0x7e,0x7e,0x5a,0x48,0x7e,0x5c,0xaa,0x00},
    {0x7e,0x7e,0x54,0x5c,0x54,0x5c,0xa2,0x00},
    {0x7e,0x7e,0x54,0x6e,0x5a,0x74,0x9a,0x00},
    {0x7e,0x7e,0x54,0x7e,0x54,0x7e,0xa4,0x00},
    {0x7e,0x7e,0x4c,0x7e,0x52,0x76,0xa4,0x00},
    {0x7e,0x7e,0x6a,0x5e,0x7a,0x5a,0xb6,0x00},
    {0x10,0x92,0x92,0x92,0xfe,0x20,0xc0,0x00},
    {0x28,0x28,0x28,0xa8,0xa8,0xfa,0x0e,0x00},
    {0x54,0x54,0x7c,0xfe,0x12,0x22,0xc6,0x00},
    {0x50,0x5e,0x6c,0xc4,0xc8,0xd2,0x0e,0x00},
    {0x92,0xfe,0x2c,0x24,0x34,0x48,0xb6,0x00},
    {0x92,0xfe,0x28,0xc6,0x7c,0x08,0x30,0x00},
    {0x28,0x44,0xbe,0x14,0x6c,0x92,0xfe,0x00},
    {0x54,0x7c,0xfe,0x10,0xfe,0x28,0xf6,0x00},
    {0x48,0x7e,0x6a,0xfe,0xea,0xea,0x3e,0x00},
    {0x42,0x5c,0x54,0xfe,0xf4,0xf2,0x1e,0x00},
    {0x48,0x5e,0x52,0xfe,0xf2,0xf2,0x1e,0x00},
    {0x7e,0x5c,0x6a,0xc8,0xfe,0xc8,0x08,0x00},
    {0x5e,0x52,0x5e,0xf4,0xfe,0xf4,0x1a,0x00},
    {0x48,0x52,0x7e,0xd4,0xfe,0xd4,0x24,0x00},
    {0x48,0x48,0x4e,0xe8,0xfe,0xf2,0x1e,0x00},
    {0x92,0xfe,0x10,0x38,0xc6,0x38,0x38,0x00},
    {0x48,0x5c,0x48,0xfe,0xc4,0xfe,0x14,0x00},
    {0x92,0xfe,0x6a,0xfc,0x2a,0xe4,0x2a,0x00},
    {0x48,0x7e,0x5c,0xdc,0xea,0xc8,0x36,0x00},
    {0x7e,0x5c,0x5c,0xc8,0xd8,0xc8,0x36,0x00},
    {0x54,0x6a,0x54,0xdc,0xd4,0xdc,0x14,0x00},
    {0x92,0xfe,0x7c,0x40,0x7e,0x02,0xaa,0x00},
    {0x54,0x62,0x48,0xd4,0xe2,0xdc,0x1c,0x00},
    {0x92,0xfe,0x54,0xfe,0x54,0xfe,0x10,0x00},
    {0x5e,0x54,0x5e,0xd4,0xde,0xd4,0x2e,0x00},
    {0x92,0xfe,0xaa,0xfe,0x92,0xd6,0xfe,0x00},
    {0x92,0xfe,0x24,0xfe,0x74,0x54,0x74,0x00},
    {0x92,0xfe,0x10,0xee,0x38,0x54,0xfe,0x00},
    {0x7e,0x62,0x7e,0xee,0xe4,0xd6,0x1e,0x00},
    {0x92,0xfe,0x44,0x7c,0x6e,0x48,0xee,0x00},
    {0x92,0xfe,0x3c,0x68,0xbc,0x28,0x3e,0x00},
    {0x5c,0x6a,0x40,0xfc,0xce,0xfc,0x08,0x00},
    {0x48,0x5c,0x48,0xfe,0xd4,0xe8,0x16,0x00},
    {0x92,0xfe,0x28,0xc6,0x7c,0x7c,0x54,0x00},
    {0x48,0x54,0x6e,0xc0,0xfe,0xfe,0x2a,0x00},
    {0x92,0xfe,0x08,0x5e,0xf6,0x54,0x7a,0x00},
    {0x38,0x28,0xfe,0xaa,0xee,0x54,0x7c,0x00},
    {0x5c,0x5c,0x48,0xfe,0xea,0xee,0x3a,0x00},
    {0x5e,0x56,0x5e,0xd0,0xd6,0xd6,0x26,0x00},
    {0x92,0xfe,0x10,0x7c,0x7c,0x2a,0xce,0x00},
    {0x92,0xfe,0x10,0xfe,0x5c,0x48,0xbe,0x00},
    {0x5e,0x4a,0x5e,0xf4,0xfe,0xea,0x1e,0x00},
    {0x7e,0x6c,0x6c,0xe0,0xf6,0xf6,0x3e,0x00},
    {0x92,0xfe,0x2c,0xf8,0x6e,0xf4,0x24,0x00},
    {0x48,0x7e,0x54,0xfe,0xdc,0xfe,0x08,0x00},
    {0x48,0x5c,0x7e,0xf6,0xfe,0xd4,0x26,0x00},
    {0x7a,0x54,0x62,0xdc,0xd4,0xc8,0x3e,0x00},
    {0x54,0x7e,0x48,0xfe,0xd6,0xfc,0x12,0x00},
    {0x48,0x54,0x7e,0xea,0xfe,0xd4,0x2a,0x00},
    {0x92,0xfe,0xa4,0x5e,0xa4,0x3c,0xda,0x00},
    {0x92,0xfe,0xd4,0x88,0xf6,0xc8,0xbe,0x00},
    {0x92,0xfe,0x9e,0xe4,0xfe,0x58,0xb6,0x00},
    {0x56,0x6a,0x6e,0xe6,0xfe,0xc0,0x22,0x00},
    {0x4c,0x76,0x5e,0xdc,0xf6,0xcc,0x36,0x00},
    {0x92,0xfe,0x74,0xae,0xfe,0x6c,0xd6,0x00},
    {0x92,0xfe,0x84,0xee,0x6e,0x00,0xaa,0x00},
    {0x5a,0xbc,0x5a,0xe6,0x5a,0x54,0x7c,0x00},
    {0x92,0xfe,0x6c,0x7e,0x5a,0x74,0x9a,0x00},
    {0x2a,0x2a,0x54,0xa8,0x54,0x2a,0x2a,0x00},
    {0x7c,0x10,0x54,0x54,0xba,0x10,0xfe,0x00},
    {0xfc,0x04,0x84,0xfc,0x80,0x82,0x7e,0x00},
    {0x0c,0x70,0x7e,0x6a,0x7e,0x60,0xbe,0x00},
    {0x0c,0x70,0x7c,0x48,0xe6,0x7c,0x54,0x00},
    {0x3c,0xfe,0x3c,0xfe,0x92,0x7c,0x54,0x00},
    {0x58,0xdc,0xe8,0xfe,0x48,0x54,0x62,0x00},
    {0x2e,0xfa,0x54,0xea,0x7c,0x54,0x10,0x00},
    {0x10,0x7c,0x44,0x7c,0xfe,0x92,0x10,0x00},
    {0x6c,0xfe,0x6c,0xb6,0xfe,0x7c,0x54,0x00},
    {0x54,0xde,0xf4,0xde,0x54,0x54,0x5e,0x00},
    {0x5e,0xde,0xd4,0xd8,0x5e,0x54,0x6e,0x00},
    {0x48,0xde,0xca,0xfe,0x54,0x7e,0x44,0x00},
    {0x48,0xce,0xdc,0xd4,0x5c,0x5c,0x62,0x00},
    {0x7e,0xe2,0xdc,0xd4,0x7e,0x40,0x62,0x00},
    {0x7e,0xea,0xfe,0xfa,0x66,0x72,0x7e,0x00},
    {0x5c,0xd4,0xfe,0xfe,0x54,0x48,0x76,0x00},
    {0x56,0xfc,0xde,0xfc,0x46,0x5c,0x5a,0x00},
    {0x48,0xfe,0xd4,0xfe,0x5c,0x48,0x7e,0x00},
    {0x56,0xaa,0x74,0x6a,0x7c,0x54,0x10,0x00},
    {0x42,0xee,0x4a,0xe6,0x7c,0x54,0x10,0x00},
    {0xee,0x44,0x44,0xee,0x44,0x44,0x44,0x00},
    {0x24,0x08,0x7e,0x24,0xfe,0x24,0x44,0x00},
    {0x10,0x10,0x64,0x28,0x10,0x24,0xfa,0x00},
    {0x08,0x7e,0x54,0x7e,0x68,0x54,0xba,0x00},
    {0x08,0x7e,0x40,0x40,0x40,0x40,0x80,0x00},
    {0x08,0x7e,0x54,0x7e,0x48,0x7e,0x88,0x00},
    {0x08,0x7e,0x78,0x6a,0x7a,0x42,0xaa,0x00},
    {0x08,0x7e,0x6e,0x7a,0x6e,0x7a,0xae,0x00},
    {0x08,0x7e,0x4c,0x4c,0x54,0x48,0xb6,0x00},
    {0x08,0x7e,0x5e,0x74,0x6e,0x74,0x8a,0x00},
    {0x08,0x7e,0x5e,0x7a,0x6e,0x74,0x8a,0x00},
    {0x08,0x7e,0x6a,0x54,0x6a,0x44,0x98,0x00},
    {0x08,0x7e,0x54,0x7e,0x5c,0x5c,0xa2,0x00},
    {0x08,0x7e,0x7a,0x6c,0x7e,0x46,0xaa,0x00},
    {0x08,0x7e,0x7a,0x56,0x6a,0x5a,0xb6,0x00},
    {0x08,0x7e,0x5c,0x7e,0x76,0x48,0xbe,0x00},
    {0x08,0x7e,0x7a,0x5c,0x6a,0x54,0xaa,0x00},
    {0x08,0x7e,0x60,0x7e,0x54,0x7e,0xaa,0x00},
    {0x08,0x7e,0x76,0x5a,0x74,0x7e,0xd4,0x00},
    {0x08,0x7e,0x54,0x5c,0x7e,0x5c,0xaa,0x00},
    {0x08,0x7e,0x4c,0x78,0x6e,0x6c,0xde,0x00},
    {0x08,0x7e,0x56,0x6c,0x56,0x74,0xbe,0x00},
    {0x08,0x7e,0x74,0x5e,0x74,0x7a,0x96,0x00},
    {0x08,0x7e,0x74,0x7e,0x74,0x7a,0x96,0x00},
    {0xe0,0x20,0x40,0x20,0xa0,0x40,0xbe,0x00},
    {0xc4,0x5e,0x96,0x5e,0xd6,0x5e,0xbe,0x00},
    {0x24,0x24,0x24,0xfe,0x24,0x24,0x44,0x00},
    {0x10,0xfe,0x28,0x74,0xfe,0x28,0x48,0x00},
    {0xa4,0xfe,0x64,0xae,0xfe,0x28,0x48,0x00},
    {0x1c,0x28,0xfe,0xa4,0x4c,0xfe,0x48,0x00},
    {0x1c,0x28,0xfe,0xa4,0x4a,0xfe,0x48,0x00},
    {0x14,0x10,0xfe,0x10,0x10,0x0a,0x06,0x00},
    {0x56,0x24,0xde,0x24,0xfc,0x6c,0xba,0x00},
    {0x7c,0x04,0x3c,0x20,0x3c,0x04,0xfe,0x00},
    {0x2e,0xfa,0x54,0xea,0x78,0x7e,0x02,0x00},
    {0xfe,0x54,0xdc,0x9c,0xd4,0x7e,0xc4,0x00},
    {0xfe,0x6a,0xfe,0xaa,0xfe,0x6a,0xd6,0x00},
    {0xfe,0x44,0xd4,0xbe,0xc4,0x54,0xcc,0x00},
    {0xf6,0x76,0xdc,0x9c,0xdc,0x7e,0xc8,0x00},
    {0xfe,0x5c,0xea,0xbe,0xea,0x7e,0xea,0x00},
    {0x5a,0xbc,0x5a,0xfe,0x40,0x7e,0x02,0x00},
    {0x10,0xfe,0x28,0xaa,0x58,0x7e,0x02,0x00},
    {0x20,0x3c,0x24,0x44,0x78,0x08,0xfe,0x00},
    {0x1c,0x28,0xfe,0x30,0xda,0x2c,0xda,0x00},
    {0x44,0xee,0x44,0xfe,0x04,0xfe,0x7c,0x00},
    {0x1c,0x28,0xfe,0xba,0x7c,0x38,0xd6,0x00},
    {0x04,0x18,0x64,0x18,0x62,0x0c,0x70,0x00},
    {0x22,0xf4,0x22,0x74,0x50,0x22,0xf4,0x00},
    {0x04,0x08,0x34,0x08,0x38,0x08,0x08,0x00},
    {0x48,0xbe,0x50,0xde,0x52,0x52,0x66,0x00},
    {0x58,0x9e,0x68,0xc8,0x5c,0x48,0x7e,0x00},
    {0x5c,0x94,0x5c,0xd4,0x5c,0x54,0x7e,0x00},
    {0x54,0xbe,0x5e,0xf4,0x7e,0x56,0x64,0x00},
    {0x7e,0xa2,0x7e,0xf6,0x7e,0x62,0x7e,0x00},
    {0x5e,0x92,0x5e,0xd2,0x5e,0x54,0x5a,0x00},
    {0x5e,0x8a,0x54,0xca,0x5e,0x44,0x5e,0x00},
    {0x50,0x9e,0x7e,0xd6,0x5e,0x56,0x5e,0x00},
    {0x54,0x94,0x6a,0xc4,0x56,0x54,0x6e,0x00},
    {0x44,0x96,0x54,0xfe,0x46,0x54,0x6e,0x00},
    {0x54,0xb6,0x54,0xf6,0x54,0x76,0x54,0x00},
    {0x48,0xbe,0x5c,0xea,0x48,0x5c,0x6a,0x00},
    {0x48,0x9c,0x54,0xdc,0x7e,0x48,0x7e,0x00},
    {0x4c,0x94,0x48,0xde,0x64,0x56,0x5e,0x00},
    {0x54,0xbe,0x7e,0xd6,0x5e,0x6c,0x5a,0x00},
    {0x44,0xfe,0xc4,0x54,0x4c,0x44,0x4c,0x00},
    {0x44,0xd8,0xd0,0x5e,0x54,0x54,0x64,0x00},
    {0x50,0xdc,0xe8,0x48,0x7e,0x48,0x48,0x00},
    {0x7c,0xd4,0xd4,0x7e,0x54,0x54,0x7e,0x00},
    {0x48,0xfe,0xea,0x4c,0x4c,0x54,0x66,0x00},
    {0x0c,0x70,0xfe,0x28,0xc6,0x20,0xaa,0x00},
    {0x10,0x7c,0x18,0x58,0x7c,0xca,0xba,0x00},
    {0x28,0x44,0xbe,0x14,0x6c,0xca,0xba,0x00},
    {0x48,0xc8,0xd4,0x7a,0x40,0x5c,0x5c,0x00},
    {0x48,0xfe,0xd0,0x74,0x5e,0x54,0x5e,0x00},
    {0x48,0xc8,0xfe,0x48,0x5c,0x54,0x5c,0x00},
    {0x50,0xde,0xe2,0x5a,0x5a,0x42,0x46,0x00},
    {0x5e,0xd2,0xde,0x54,0x56,0x54,0x66,0x00},
    {0x20,0x3e,0xd0,0x1e,0x50,0xca,0xba,0x00},
    {0x40,0x7e,0xaa,0x7a,0x14,0xca,0xba,0x00},
    {0x5c,0xd4,0xdc,0x54,0x5c,0x40,0x7e,0x00},
    {0x48,0xfe,0xd2,0x5e,0x52,0x52,0x5e,0x00},
    {0x54,0xfe,0xde,0x74,0x7e,0x56,0x64,0x00},
    {0x7e,0xdc,0xea,0x48,0x7e,0x48,0x48,0x00},
    {0x48,0xdc,0xd4,0x7e,0x48,0x48,0x76,0x00},
    {0x58,0xc0,0xd8,0x7a,0x5c,0x6a,0x58,0x00},
    {0x10,0x7c,0xfe,0x10,0xfe,0x48,0xba,0x00},
    {0x24,0x58,0xfe,0x48,0x5c,0xc0,0xba,0x00},
    {0x4c,0xd4,0xc8,0x54,0x62,0x5c,0x5c,0x00},
    {0x28,0x7e,0xc8,0x5c,0x6a,0xc0,0xba,0x00},
    {0x50,0xde,0xf6,0x4a,0x56,0x5e,0x42,0x00},
    {0x48,0xde,0xca,0x40,0x4a,0x7e,0x56,0x00},
    {0x7e,0xd0,0xdc,0x54,0x6c,0x48,0x7e,0x00},
    {0x48,0xea,0xdc,0x7e,0x54,0x54,0x66,0x00},
    {0x90,0x1e,0x2a,0x94,0x00,0xca,0xba,0x00},
    {0x48,0xdc,0xc8,0x7e,0x44,0x7e,0x54,0x00},
    {0x48,0xde,0xd6,0x56,0x56,0x56,0x7e,0x00},
    {0x50,0xde,0xfe,0x56,0x5e,0x56,0x5e,0x00},
    {0x44,0xd8,0xfe,0x48,0x5c,0x54,0x5c,0x00},
    {0x5e,0xf2,0xde,0x52,0x5e,0x5e,0x52,0x00},
    {0x24,0xfe,0x10,0xfe,0x54,0xca,0xba,0x00},
    {0x4c,0xec,0xc0,0x5e,0x52,0x5e,0x52,0x00},
    {0x5c,0xd4,0xdc,0x7e,0x48,0x7e,0x48,0x00},
    {0x5c,0xd4,0xdc,0x54,0x7e,0x40,0x62,0x00},
    {0x7e,0xea,0xfe,0x6a,0x7e,0x6a,0x7e,0x00},
    {0x48,0xfe,0xda,0x5e,0x48,0x5c,0x6a,0x00},
    {0x54,0xea,0xd4,0x5c,0x54,0x5c,0x54,0x00},
    {0x52,0xfe,0xd4,0x66,0x5c,0x68,0x56,0x00},
    {0x48,0xdc,0xfe,0x6e,0x44,0x7e,0x48,0x00},
    {0x4c,0xd4,0xfe,0x6a,0x7e,0x54,0x66,0x00},
    {0x5c,0xd4,0xfe,0x6a,0x7e,0x60,0x5e,0x00},
    {0x7a,0xd6,0xfe,0x56,0x7a,0x72,0x56,0x00},
    {0x48,0xfe,0xd4,0x48,0x76,0x5c,0x5c,0x00},
    {0xfe,0x6c,0x44,0xfe,0x54,0xca,0xba,0x00},
    {0x5c,0xfe,0xdc,0x6a,0x44,0x7e,0x48,0x00},
    {0x10,0xfe,0x54,0x7c,0x74,0xca,0xba,0x00},
    {0x54,0xea,0xfe,0x54,0x6a,0x50,0x5c,0x00},
    {0x48,0xfe,0xd4,0x54,0x6a,0x7e,0x48,0x00},
    {0x48,0xfc,0xd4,0x66,0x48,0x7e,0x48,0x00},
    {0x48,0xfe,0xcc,0x5c,0x7e,0x54,0x7a,0x00},
    {0x7e,0xea,0xfe,0x6a,0x76,0x7e,0x62,0x00},
    {0x5e,0xd0,0xdc,0x50,0x7e,0x54,0x5a,0x00},
    {0x7e,0xe2,0xf6,0x7e,0x6a,0x6e,0x62,0x00},
    {0x5e,0xf6,0xda,0x5e,0x40,0x4c,0x5e,0x00},
    {0x76,0xf6,0xdc,0x7e,0x50,0x5e,0x42,0x00},
    {0x56,0x80,0x56,0xc2,0x56,0xc8,0xba,0x00},
    {0x48,0xdc,0xd4,0x5c,0x7e,0x48,0x7e,0x00},
    {0x38,0xfe,0x24,0xda,0x18,0xca,0xba,0x00},
    {0x74,0xd4,0xfe,0x5c,0x74,0x74,0x5a,0x00},
    {0x6a,0xfe,0xc0,0x7e,0x50,0x7e,0x6a,0x00},
    {0x5c,0xd4,0xde,0x68,0x5c,0x48,0x7e,0x00},
    {0x48,0xfe,0xe2,0x5c,0x40,0x5c,0x7e,0x00},
    {0x50,0xde,0xea,0x5a,0x44,0x72,0x6e,0x00},
    {0x7a,0xee,0xfe,0x6e,0x7a,0x42,0x6a,0x00},
    {0x4a,0xd4,0xca,0x5e,0x56,0x5a,0x5e,0x00},
    {0xf6,0xfa,0xa4,0xda,0x00,0xca,0xba,0x00},
    {0x50,0xde,0xec,0x4c,0x54,0x48,0x76,0x00},
    {0x2e,0xca,0xe4,0xaa,0x00,0xca,0xba,0x00},
    {0x60,0xfe,0xdc,0x7e,0x6a,0x5e,0x6a,0x00},
    {0x2e,0xfa,0x74,0x5a,0x00,0xca,0xba,0x00},
    {0x48,0xfe,0xea,0x7e,0x6a,0x5c,0x6e,0x00},
    {0x54,0xfe,0xcc,0x7e,0x4e,0x5c,0x6a,0x00},
    {0x7e,0x5c,0x5c,0x6a,0x98,0x4a,0xba,0x00},
    {0x50,0xde,0xcc,0x6c,0x7e,0x40,0x62,0x00},
    {0xae,0xea,0xee,0x52,0x80,0x4a,0xba,0x00},
    {0x48,0xd4,0xfa,0x58,0x50,0x6c,0x4c,0x00},
    {0x4a,0xfe,0xdc,0x54,0x7e,0x54,0x4c,0x00},
    {0xbe,0x04,0xbe,0x3e,0xaa,0x40,0xba,0x00},
    {0x7e,0xdc,0xdc,0x48,0x7e,0x5c,0x6a,0x00},
    {0x7e,0xfa,0xf4,0x4a,0x5c,0x48,0x7e,0x00},
    {0x48,0xfe,0xee,0x6c,0x7a,0x6c,0x5a,0x00},
    {0x54,0xfa,0xd4,0x7e,0x6a,0x44,0x58,0x00},
    {0x2e,0xf8,0x6e,0xf4,0x24,0xc8,0xba,0x00},
    {0x72,0xdc,0xf8,0x7e,0x5a,0x7a,0x52,0x00},
    {0x54,0xaa,0x5c,0xd8,0x6e,0xc0,0xba,0x00},
    {0x7e,0xca,0xde,0x6a,0x44,0x5e,0x5e,0x00},
    {0x50,0xde,0xf4,0x5c,0x5e,0x6a,0x56,0x00},
    {0x6c,0xce,0xe4,0x5e,0x6a,0x6e,0x7e,0x00},
    {0x48,0xfe,0xdc,0x5a,0x7e,0x54,0x4c,0x00},
    {0x74,0xde,0xf6,0x76,0x56,0x7a,0x4a,0x00},
    {0xfe,0xa8,0xfe,0xb4,0xfe,0x48,0xba,0x00},
    {0x7e,0xdc,0xdc,0x40,0x7e,0x48,0x6a,0x00},
    {0x44,0xfe,0xec,0x7e,0x76,0x7e,0x56,0x00},
    {0x10,0xfe,0x38,0xfe,0x7c,0xca,0xba,0x00},
    {0x24,0xfe,0x74,0x74,0xaa,0x40,0xba,0x00},
    {0x2a,0xde,0xea,0x6e,0x00,0xca,0xba,0x00},
    {0x5c,0xd4,0xfe,0x54,0x5c,0x48,0x6a,0x00},
    {0x54,0xde,0xf4,0x54,0x5e,0x40,0x6a,0x00},
    {0x76,0xf6,0xdc,0x5c,0x5c,0x7e,0x48,0x00},
    {0x54,0x7e,0xd4,0x7e,0x56,0xc8,0xba,0x00},
    {0xbe,0x28,0x3e,0x82,0x2a,0xc0,0xba,0x00},
    {0x76,0xf6,0xea,0x7e,0x76,0x6a,0x76,0x00},
    {0x60,0xfe,0xd4,0x7e,0x54,0x7e,0x6a,0x00},
    {0x7e,0xfe,0xc8,0x7e,0x54,0x7e,0x48,0x00},
    {0x48,0xde,0xde,0x5a,0x7e,0x48,0x76,0x00},
    {0x08,0x7e,0x56,0x6c,0x6e,0x52,0xae,0x00},
    {0x48,0xfe,0xda,0x7e,0x48,0x74,0x5a,0x00},
    {0x5e,0xea,0xd8,0x5a,0x5e,0x5e,0x6a,0x00},
    {0x54,0xfe,0x76,0x2a,0xf0,0x4a,0xba,0x00},
    {0x5c,0xd4,0xfe,0x6a,0x7e,0x5c,0x6a,0x00},
    {0x4c,0xd4,0xfe,0x76,0x6c,0x7e,0x4c,0x00},
    {0x7c,0xce,0x54,0xfe,0x54,0xca,0xba,0x00},
    {0xfe,0xaa,0xfe,0x54,0xde,0xd4,0x5e,0x00},
    {0x48,0xfe,0xd4,0x5c,0x7e,0x5c,0x6a,0x00},
    {0x5c,0xfe,0xea,0x5c,0x48,0x7e,0x6a,0x00},
    {0x94,0x3e,0x94,0x3e,0xaa,0x40,0xba,0x00},
    {0x56,0xfa,0xf0,0x7e,0x5e,0x70,0x5a,0x00},
    {0x6e,0xd4,0xfe,0x54,0x7e,0x54,0x7a,0x00},
    {0x56,0xd4,0xfe,0x54,0x7e,0x54,0x7a,0x00},
    {0x58,0xee,0x54,0xaa,0xe0,0x5a,0xf6,0x00},
    {0x54,0xfe,0xf6,0x54,0x5e,0x74,0x5e,0x00},
    {0x76,0xf6,0xc0,0x54,0x5e,0x74,0x5e,0x00},
    {0x5e,0xcc,0xde,0x44,0x76,0x7e,0x52,0x00},
    {0x5a,0xbc,0x5a,0xe6,0x5a,0xc0,0xba,0x00},
    {0x14,0xfe,0x10,0x14,0x08,0x1a,0x66,0x00},
    {0x0a,0x7e,0x48,0x48,0x6a,0xc4,0x1a,0x00},
    {0x0a,0x7e,0x48,0x68,0x5a,0x44,0x9a,0x00},
    {0x0a,0x7e,0x48,0x78,0x4a,0x44,0x9a,0x00},
    {0x14,0xfc,0x1a,0x66,0xfc,0x1a,0x66,0x00},
    {0xfe,0x3c,0x24,0x3e,0xfc,0x1a,0x66,0x00},
    {0xfe,0x3c,0x24,0xfe,0xba,0x18,0x66,0x00},
    {0x56,0xf4,0x5e,0x54,0xf6,0xa4,0xfa,0x00},
    {0x2a,0x78,0xfe,0x28,0x7a,0xd4,0x7a,0x00},
    {0xf6,0x54,0x2e,0x54,0xa6,0x14,0x6a,0x00},
    {0xde,0xdc,0x76,0x74,0x76,0xfc,0x22,0x00},
    {0x26,0x34,0xee,0xf4,0xd6,0xa4,0xfa,0x00},
    {0xf6,0x54,0x0e,0x54,0x76,0xe4,0x7a,0x00},
    {0xfe,0x44,0x7c,0x40,0x7e,0x7e,0xaa,0x00},
    {0x48,0xe8,0x48,0x68,0xc8,0x4a,0xce,0x00},
    {0x5c,0xc8,0x48,0x7e,0xc8,0x48,0xc8,0x00},
    {0x40,0xfe,0x52,0x72,0xd2,0x52,0xde,0x00},
    {0x40,0xdc,0x48,0x48,0xc8,0x48,0xfe,0x00},
    {0x7e,0xea,0x62,0x54,0xc8,0x54,0xe2,0x00},
    {0x5e,0xea,0x5a,0x6a,0xce,0x4a,0xd6,0x00},
    {0x5e,0xf0,0x5e,0x7a,0xda,0x58,0xee,0x00},
    {0x7e,0xc8,0x48,0x5c,0xc8,0x48,0xfe,0x00},
    {0x48,0xdc,0x4c,0x7e,0xc8,0x48,0xf6,0x00},
    {0x4a,0xe8,0x5e,0x68,0xca,0x44,0xda,0x00},
    {0x7c,0xd4,0x48,0x7e,0xca,0x48,0xd8,0x00},
    {0x44,0xf8,0x6c,0x6c,0xec,0x6c,0xca,0x00},
    {0x44,0xd4,0x44,0x54,0xc6,0x7c,0xc4,0x00},
    {0x4a,0xfe,0x48,0x6a,0xca,0x54,0xea,0x00},
    {0x48,0xfe,0x48,0x4c,0xca,0x48,0xc8,0x00},
    {0x7e,0xc8,0x48,0x5c,0xea,0x48,0xc8,0x00},
    {0x54,0xde,0x66,0x56,0xe6,0x6a,0xfa,0x00},
    {0x54,0xfe,0x54,0x5c,0xd4,0x54,0xdc,0x00},
    {0x48,0xfe,0x6a,0x7e,0xea,0x7e,0xc8,0x00},
    {0x2e,0xfa,0x54,0xea,0x7c,0xfe,0x30,0x00},
    {0x10,0x28,0xfe,0x38,0x7c,0xfe,0x30,0x00},
    {0x44,0xd8,0x50,0x5e,0xdc,0x56,0xe4,0x00},
    {0x4c,0xd4,0x7e,0x76,0xec,0x7e,0xcc,0x00},
    {0x48,0xe8,0x4e,0x68,0xde,0x52,0xde,0x00},
    {0x3e,0xce,0xe4,0x4e,0xe4,0x5e,0x84,0x00},
    {0x54,0xe2,0x48,0x7e,0xc8,0x7e,0xc8,0x00},
    {0x4a,0xd6,0x72,0x5a,0xd2,0x52,0xd6,0x00},
    {0x54,0xfe,0x5e,0x74,0xfe,0x56,0xe4,0x00},
    {0x5c,0xd4,0x54,0x7e,0xe4,0x7e,0xcc,0x00},
    {0x54,0xfe,0x56,0x56,0xda,0x50,0xee,0x00},
    {0x48,0xfe,0x54,0x54,0xd4,0x58,0xfe,0x00},
    {0x4c,0xd4,0x48,0x54,0xe2,0x5c,0xdc,0x00},
    {0x48,0xfe,0x48,0x5c,0xc0,0x5c,0xdc,0x00},
    {0x54,0xfe,0x54,0x54,0xfe,0x40,0xe2,0x00},
    {0x7e,0xca,0x5e,0x6a,0xde,0x6a,0xca,0x00},
    {0x48,0xdc,0x48,0x7e,0xdc,0x48,0xfe,0x00},
    {0x4e,0xe6,0x66,0xca,0x7c,0xfe,0x30,0x00},
    {0x5c,0xc4,0x7a,0x5c,0xea,0x48,0xfe,0x00},
    {0x48,0xfe,0x56,0x72,0xd4,0x5e,0xd4,0x00},
    {0x4c,0xec,0x40,0x7e,0xd2,0x5e,0xd2,0x00},
    {0x48,0xfe,0x5c,0x5c,0xea,0x48,0xf6,0x00},
    {0x5c,0xd4,0x5c,0x7e,0xc8,0x7e,0xc8,0x00},
    {0x56,0xea,0x6a,0x7e,0xd4,0x48,0xf6,0x00},
    {0x7e,0xe2,0x7e,0x48,0xdc,0x48,0xfe,0x00},
    {0x48,0xfe,0x50,0x76,0xda,0x54,0xda,0x00},
    {0x48,0xfe,0x48,0x54,0xfe,0x44,0xd4,0x00},
    {0x54,0xe6,0x7a,0x74,0xf4,0x54,0xda,0x00},
    {0x78,0xde,0x5a,0x5a,0xdc,0x7a,0xc8,0x00},
    {0x5c,0xc8,0x7e,0x54,0xfe,0x48,0xfe,0x00},
    {0x62,0x7a,0xaa,0x72,0x7c,0xfe,0x30,0x00},
    {0x50,0xde,0x6a,0x5e,0xca,0x6e,0xfe,0x00},
    {0x48,0xee,0x5c,0x74,0xdc,0x7e,0xc8,0x00},
    {0x48,0xfe,0x6e,0x44,0xd6,0x54,0xee,0x00},
    {0x48,0xd4,0x6e,0x40,0xf6,0x76,0xc4,0x00},
    {0x76,0xf6,0x76,0x62,0xe2,0x62,0xe6,0x00},
    {0x7e,0xd2,0x5e,0x54,0xde,0x64,0xda,0x00},
    {0x4e,0xd4,0x7e,0x68,0xda,0x6c,0xda,0x00},
    {0x64,0xf6,0x64,0x76,0xc8,0x5c,0xdc,0x00},
    {0x48,0xfe,0x5e,0x5e,0xc8,0x5c,0xea,0x00},
    {0x7a,0xd4,0x62,0x5c,0xfe,0x48,0xf6,0x00},
    {0x6a,0xfe,0x40,0x7e,0xd0,0x7e,0xea,0x00},
    {0x5c,0xfe,0x5a,0x68,0xfe,0x5c,0xea,0x00},
    {0x46,0xd8,0x7e,0x48,0xfe,0x6a,0xfe,0x00},
    {0x7e,0xd6,0x5c,0x5e,0xd6,0x7c,0xc4,0x00},
    {0x78,0xd4,0x6e,0x40,0xda,0x5c,0xda,0x00},
    {0x4c,0xd4,0x48,0x5e,0xe4,0x56,0xde,0x00},
    {0x10,0xfe,0xaa,0x7c,0xba,0x7c,0x30,0x00},
    {0x54,0xfe,0x54,0x7e,0xdc,0x7e,0xd4,0x00},
    {0x54,0xfe,0x48,0x7e,0xde,0x54,0xee,0x00},
    {0x5e,0xea,0x5e,0x74,0xde,0x4a,0xde,0x00},
    {0x48,0xd4,0x7a,0x58,0xd0,0x6c,0xcc,0x00},
    {0x5e,0xec,0x5e,0x44,0xf6,0x7e,0xd2,0x00},
    {0x48,0xfc,0x5c,0x70,0xde,0x4a,0xde,0x00},
    {0x5c,0xd4,0x5c,0x7e,0xca,0x5e,0xea,0x00},
    {0x4a,0xfe,0x5c,0x54,0xfe,0x54,0xcc,0x00},
    {0x6a,0xfe,0x54,0x5e,0xf4,0x54,0xde,0x00},
    {0x28,0x7c,0xec,0x76,0x3c,0xfe,0x30,0x00},
    {0x48,0xfe,0x5c,0x5a,0xfe,0x54,0xcc,0x00},
    {0x76,0xd2,0x48,0x54,0xea,0x44,0xd8,0x00},
    {0x56,0xea,0x7e,0x62,0xdc,0x5c,0xe6,0x00},
    {0x6a,0xfc,0x6c,0x7e,0xfe,0x46,0xea,0x00},
    {0x48,0xdc,0x7e,0x76,0xfe,0x54,0xe6,0x00},
    {0x7a,0xd4,0x62,0x5e,0xfa,0x54,0xea,0x00},
    {0x48,0xfe,0x54,0x7e,0xd4,0x48,0xea,0x00},
    {0x6a,0xd4,0x7e,0x6a,0xde,0x4a,0xf6,0x00},
    {0x44,0xfe,0x74,0x72,0xc0,0x72,0xee,0x00},
    {0x48,0xce,0x78,0x76,0xec,0x76,0xec,0x00},
    {0x48,0xf6,0x5c,0x7e,0xea,0x6e,0xfa,0x00},
    {0x48,0xfe,0x76,0x7e,0xdc,0x54,0xfe,0x00},
    {0x7e,0xfe,0x48,0x7e,0xd4,0x7e,0xc8,0x00},
    {0x64,0xce,0x5e,0x6a,0xde,0x64,0xfe,0x00},
    {0x64,0x6e,0xca,0x64,0x7c,0xfe,0x30,0x00},
    {0x5c,0xfe,0x6a,0x40,0xfe,0x6a,0xfe,0x00},
    {0x76,0xf6,0x6e,0x76,0xea,0x7e,0xee,0x00},
    {0x2c,0x54,0x5c,0xfe,0x54,0xba,0x30,0x00},
    {0x2c,0x54,0x5c,0xfe,0x54,0xba,0x10,0x00},
    {0x48,0xfe,0x54,0x6a,0xd4,0x5c,0xe4,0x00},
    {0x48,0xfe,0x5c,0x7e,0xea,0x5c,0xfe,0x00},
    {0x48,0xc8,0x54,0x7a,0xc0,0x5c,0xdc,0x00},
    {0x48,0xdc,0x7e,0x48,0xfe,0x74,0xcc,0x00},
    {0x48,0xfe,0x6a,0x74,0xdc,0x5c,0xe2,0x00},
    {0x74,0xe6,0x76,0x5c,0xdc,0x5c,0xe6,0x00},
    {0x64,0xf6,0x52,0x7e,0xea,0x7a,0xea,0x00},
    {0x48,0xfe,0x6c,0x7e,0xec,0x6c,0xd2,0x00},
    {0x56,0xee,0x44,0x7e,0xfe,0x54,0xec,0x00},
    {0x7e,0xfe,0x54,0x66,0xf0,0x74,0xf6,0x00},
    {0x54,0xee,0x54,0xfe,0x54,0xba,0x30,0x00},
    {0x5a,0xec,0x5a,0x6c,0xfe,0x5c,0xea,0x00},
    {0x48,0xfe,0x76,0x5c,0xfe,0x74,0xda,0x00},
    {0x6a,0xfe,0x5e,0x74,0xde,0x76,0xea,0x00},
    {0x54,0xfe,0x54,0x6a,0xdc,0x5c,0xe2,0x00},
    {0x6a,0xfc,0x56,0x7c,0xfe,0x54,0xee,0x00},
    {0x5a,0xbc,0x5a,0xe6,0x5a,0xfe,0x30,0x00},
    {0x76,0xf6,0x5c,0x5e,0xd4,0x48,0xf6,0x00},
    {0x10,0x1c,0x10,0x78,0x28,0x10,0xee,0x00},
    {0x20,0x3c,0x48,0xa8,0x10,0x28,0xc6,0x00},
    {0xe8,0x4e,0x5a,0x6a,0x2a,0x24,0x7a,0x00},
    {0x28,0xae,0xba,0xaa,0xaa,0xe4,0x3a,0x00},
    {0x28,0x6e,0xfa,0x6a,0x6a,0x64,0x5a,0x00},
    {0x08,0xee,0xfa,0xea,0xea,0xe4,0x1a,0x00},
    {0x24,0xf6,0x5a,0x8a,0x5a,0x24,0xda,0x00},
    {0x48,0xee,0x5a,0xea,0x4a,0x64,0xba,0x00},
    {0x24,0xf6,0x7a,0x7a,0x2a,0x74,0xaa,0x00},
    {0x24,0x56,0xf4,0x2e,0xfa,0x24,0xaa,0x00},
    {0x24,0x56,0xfa,0x2a,0xfa,0x24,0xaa,0x00},
    {0x64,0xb6,0x2a,0xfa,0x9a,0xb4,0xba,0x00},
    {0x64,0xb6,0x2a,0xfa,0xba,0xf4,0xba,0x00},
    {0x24,0xf6,0x54,0x7e,0xfa,0x8c,0xaa,0x00},
    {0x24,0x76,0xda,0x6a,0xfa,0x54,0xea,0x00},
    {0x24,0x56,0xfa,0xaa,0xfa,0x54,0xaa,0x00},
    {0x56,0xaa,0x74,0x5a,0xfe,0x68,0xce,0x00},
    {0x5a,0xbc,0x5a,0x7e,0xa4,0x18,0xe6,0x00},
    {0x62,0xaa,0x72,0x7a,0x72,0x5e,0xb2,0x00},
    {0x52,0xfa,0x52,0x5a,0xf2,0xae,0xf2,0x00},
    {0xe2,0x4c,0x48,0x8e,0x6a,0x6a,0x12,0x00},
    {0xaa,0xd4,0xac,0xfe,0xae,0xd6,0xfa,0x00},
    {0x48,0xee,0x50,0x6e,0x6a,0xbe,0xaa,0x00},
    {0x48,0xee,0x54,0x7e,0x6e,0xae,0xa4,0x00},
    {0x10,0xfe,0x24,0xfe,0xa2,0x3c,0xc4,0x00},
    {0x48,0xee,0x56,0x6c,0x66,0xac,0xa6,0x00},
    {0x48,0xee,0x50,0x6c,0x6e,0xb4,0xae,0x00},
    {0x48,0xee,0x54,0x66,0x60,0xaa,0xaa,0x00},
    {0x48,0xee,0x5e,0x6c,0x76,0xac,0xac,0x00},
    {0x5e,0xec,0x5e,0x6c,0x76,0xac,0xac,0x00},
    {0x7c,0x10,0x10,0xfe,0x18,0x2a,0xce,0x00},
    {0xfc,0x10,0x90,0xfe,0x18,0x2a,0xce,0x00},
    {0x7c,0x44,0x7c,0xfe,0x10,0xfe,0x10,0x00},
    {0x7c,0x44,0x7c,0xfe,0x10,0x38,0xd6,0x00},
    {0x7c,0x44,0xfe,0x10,0x7c,0x10,0xee,0x00},
    {0x3c,0x24,0x3c,0x7e,0x48,0x48,0xb6,0x00},
    {0x7c,0x44,0x7c,0xfe,0x28,0x10,0xee,0x00},
    {0x10,0xfe,0x38,0xd6,0x7c,0x7c,0x7c,0x00},
    {0x1e,0xf2,0xbe,0xf4,0xb6,0xf4,0x26,0x00},
    {0x6e,0x0a,0x6e,0xfa,0x6e,0xb0,0x6e,0x00},
    {0x7c,0x44,0x7c,0xce,0xaa,0xea,0x48,0x00},
    {0x7c,0x44,0xfe,0x20,0x7e,0xaa,0x56,0x00},
    {0x7c,0x44,0xfe,0x92,0x7c,0x28,0xf6,0x00},
    {0x04,0xf6,0xac,0xfe,0xac,0xec,0x16,0x00},
    {0xfe,0x48,0x6c,0xfe,0x7c,0x44,0x7c,0x00},
    {0x7c,0x7c,0xaa,0x6c,0xea,0x28,0xce,0x00},
    {0x14,0xe8,0xb4,0xfe,0xa8,0xfe,0x2a,0x00},
    {0x10,0x7c,0x16,0x7c,0xfe,0x44,0xfe,0x00},
    {0x0e,0xe4,0xbe,0xea,0xbe,0xea,0x0e,0x00},
    {0x0c,0xee,0xb4,0xfe,0xa4,0xee,0x0e,0x00},
    {0x3c,0x24,0x7e,0x5c,0x7e,0x68,0xb6,0x00},
    {0x3c,0x24,0x7e,0x44,0x76,0x54,0xaa,0x00},
    {0x44,0xd8,0x5e,0xd4,0x7c,0x7c,0x7c,0x00},
    {0x0a,0xfc,0xac,0xfe,0xba,0xea,0x0a,0x00},
    {0x7c,0x44,0x7c,0xee,0x28,0xee,0x48,0x00},
    {0x7c,0x44,0xfe,0xba,0x38,0xfe,0x10,0x00},
    {0x14,0xfe,0xb4,0xea,0xbe,0xc8,0x36,0x00},
    {0x1e,0xf6,0xbe,0xec,0xac,0xfe,0x04,0x00},
    {0x04,0xfe,0xb2,0xec,0xa0,0xec,0x1e,0x00},
    {0x0e,0xea,0xbe,0xe8,0xae,0xf6,0x0a,0x00},
    {0x1e,0xf2,0xac,0xec,0xbe,0xe0,0x12,0x00},
    {0x5e,0xec,0xec,0xd6,0x7c,0x44,0xfe,0x00},
    {0xbe,0x3e,0x94,0x1e,0xf4,0x5e,0xbe,0x00},
    {0x08,0xfc,0xbe,0xf6,0xbe,0xd4,0x26,0x00},
    {0x14,0xfe,0xee,0xf6,0xde,0xf4,0x1a,0x00},
    {0x56,0xaa,0x74,0x5a,0x7c,0x44,0x7c,0x00},
    {0x14,0xfe,0xbc,0xfe,0xbc,0xfe,0x08,0x00},
    {0x08,0xfe,0xb4,0xfe,0xb4,0xc8,0x2a,0x00},
    {0x3e,0xd4,0xbe,0xf2,0xac,0xd4,0x2a,0x00},
    {0x14,0xfe,0xb4,0xfe,0xba,0xec,0x1a,0x00},
    {0x08,0xfe,0xac,0xfe,0xac,0xec,0x32,0x00},
    {0x04,0xfe,0xb0,0xf4,0xb4,0xfa,0x2e,0x00},
    {0x14,0xfe,0xa8,0xfe,0xb6,0xec,0x1a,0x00},
    {0x7c,0x44,0xfe,0x6c,0xfe,0x68,0xb6,0x00},
    {0x7e,0x42,0x42,0x7a,0x42,0x42,0x7e,0x00},
    {0x24,0xf8,0xa8,0xf8,0x14,0x08,0xf6,0x00},
    {0x7c,0x44,0x7c,0x3e,0xd2,0x6a,0x7a,0x00},
    {0xe4,0xb6,0xfe,0xa4,0xf6,0xb6,0xbe,0x00},
    {0xe4,0xbe,0xf2,0xbe,0xfe,0xb4,0xba,0x00},
    {0x28,0x7c,0x28,0xfe,0x5c,0x9a,0x28,0x00},
    {0xd4,0xbe,0xf4,0xbe,0xfa,0xac,0xba,0x00},
    {0xd6,0xbc,0xee,0xba,0xee,0xbc,0xae,0x00},
    {0x38,0xfe,0xb6,0x50,0x76,0xf6,0x2a,0x00},
    {0x14,0xfe,0x10,0x54,0x54,0x54,0x96,0x00},
    {0x10,0xfe,0x7c,0x54,0x10,0x38,0xd6,0x00},
    {0x78,0x2e,0xc2,0x10,0xfe,0x38,0xd6,0x00},
    {0x58,0xe8,0x48,0xe8,0xd4,0x54,0x62,0x00},
    {0x48,0xfe,0x4a,0xea,0xca,0x4a,0x56,0x00},
    {0x5e,0xea,0x4a,0xea,0xca,0x4a,0x56,0x00},
    {0x5c,0xc8,0x48,0xfe,0xc8,0x48,0x48,0x00},
    {0x5e,0xe2,0x42,0xfe,0xd0,0x52,0x5e,0x00},
    {0x40,0xdc,0x48,0xc8,0xc8,0x48,0x7e,0x00},
    {0x4a,0xe8,0x5e,0xe8,0xc4,0x44,0x42,0x00},
    {0x48,0xc8,0x6a,0xea,0xea,0x6a,0x7e,0x00},
    {0x5e,0xe8,0x4e,0xea,0xca,0x4a,0x56,0x00},
    {0x7e,0xc8,0x48,0xdc,0xc8,0x48,0x7e,0x00},
    {0x10,0xfe,0x10,0x38,0xd6,0x00,0xaa,0x00},
    {0x10,0xfe,0x3c,0xda,0x24,0xd2,0x3c,0x00},
    {0x7c,0xd4,0x48,0xfe,0xca,0x48,0x58,0x00},
    {0x48,0xdc,0x5a,0xe8,0xca,0x44,0x58,0x00},
    {0x54,0xd4,0x62,0xdc,0xd4,0x54,0x6c,0x00},
    {0x44,0xfe,0x48,0xee,0xca,0x4a,0x56,0x00},
    {0x5e,0xe0,0x4e,0xea,0xce,0x48,0x50,0x00},
    {0x4c,0xf4,0x54,0xfe,0xd4,0x54,0x64,0x00},
    {0x7e,0xd4,0x54,0xfe,0xd4,0x54,0x64,0x00},
    {0x50,0xfe,0x5a,0xda,0xda,0x6a,0x6e,0x00},
    {0x5e,0xe2,0x5e,0xf6,0xde,0x42,0x46,0x00},
    {0x5e,0xf2,0x5e,0xe0,0xde,0x4a,0x56,0x00},
    {0x10,0xfe,0x7c,0x7c,0x7c,0x38,0xd6,0x00},
    {0x7e,0xe2,0x62,0xfe,0xc0,0x54,0x62,0x00},
    {0x5e,0xf6,0x5a,0xf2,0xd4,0x5a,0x5e,0x00},
    {0x48,0xee,0x52,0xee,0xce,0x42,0x46,0x00},
    {0x5c,0xd4,0x5c,0xd4,0xdc,0x54,0x7e,0x00},
    {0x48,0xee,0x58,0xee,0xc8,0x4e,0x48,0x00},
    {0x44,0xd8,0x50,0xde,0xdc,0x56,0x64,0x00},
    {0x42,0xdc,0x54,0xde,0xd4,0x52,0x7e,0x00},
    {0x48,0xea,0x7e,0xc8,0xea,0x6a,0x7e,0x00},
    {0x48,0xee,0x52,0xee,0xce,0x48,0x4e,0x00},
    {0x4a,0xd6,0x72,0xda,0xd2,0x52,0x56,0x00},
    {0x48,0xfe,0x54,0xd4,0xd4,0x58,0x7e,0x00},
    {0x42,0xdc,0x54,0xd4,0xd4,0x56,0x6a,0x00},
    {0x48,0xd4,0x7e,0xea,0xfe,0x54,0x5c,0x00},
    {0xee,0x44,0xee,0x54,0xfe,0x38,0xd6,0x00},
    {0x7e,0xee,0x64,0xee,0xe4,0x6e,0x7e,0x00},
    {0x7e,0xca,0x5e,0xea,0xde,0x6a,0x4a,0x00},
    {0x74,0xd6,0x2e,0xd4,0x7c,0x38,0xd6,0x00},
    {0x48,0xfe,0x54,0xea,0xdc,0x5e,0x42,0x00},
    {0x4a,0xdc,0x48,0xfe,0xd8,0x6e,0x42,0x00},
    {0x7e,0xd4,0x7a,0xc8,0xdc,0x48,0x7e,0x00},
    {0x48,0xfe,0x54,0xfa,0xd8,0x5a,0x6a,0x00},
    {0x48,0xfe,0x56,0xf2,0xd4,0x5e,0x54,0x00},
    {0x48,0xd2,0x7e,0xdc,0xe8,0x7e,0x48,0x00},
    {0x6a,0xc8,0x7e,0xc2,0xde,0x42,0x7e,0x00},
    {0x4c,0xf4,0x5e,0xda,0xde,0x52,0x66,0x00},
    {0x5c,0xd4,0x5c,0xfe,0xc8,0x7e,0x48,0x00},
    {0x10,0x78,0x7e,0x12,0xfe,0x38,0xd6,0x00},
    {0x58,0xdc,0x68,0xfe,0xc8,0x5c,0x5c,0x00},
    {0x52,0xfe,0x54,0xe6,0xdc,0x68,0x56,0x00},
    {0x42,0xdc,0x5e,0xda,0xde,0x58,0x6e,0x00},
    {0x2c,0x74,0xe8,0x74,0x7e,0x5c,0x6a,0x00},
    {0x7e,0xd6,0x7c,0xd6,0xfe,0x54,0x6c,0x00},
    {0x72,0xdc,0x64,0xde,0xf4,0x5e,0x6e,0x00},
    {0x48,0xdc,0x7e,0xc8,0xfe,0x74,0x4c,0x00},
    {0x44,0xd8,0x5e,0xd4,0xfe,0x40,0x62,0x00},
    {0x5c,0xea,0x40,0xdc,0xc4,0x7e,0x48,0x00},
    {0x24,0xfe,0x6c,0xbe,0x24,0x34,0xc6,0x00},
    {0x5e,0xf2,0x5e,0xe8,0xde,0x52,0x5e,0x00},
    {0x24,0xfe,0x6c,0xb6,0xfe,0x18,0x14,0x00},
    {0x7e,0xd4,0x76,0xe2,0xf6,0x54,0x7e,0x00},
    {0x48,0xdc,0x5c,0xc8,0xfe,0x48,0x4e,0x00},
    {0x5e,0xea,0x5e,0xea,0xdc,0x4e,0x56,0x00},
    {0x48,0xfe,0x54,0xdc,0xc4,0x7e,0x48,0x00},
    {0x28,0x7c,0x28,0xfe,0x54,0x38,0xd6,0x00},
    {0x50,0xde,0x76,0xca,0xde,0x4a,0x56,0x00},
    {0x24,0xfe,0x24,0xfe,0xb6,0x6c,0xb6,0x00},
    {0x7e,0xde,0x4a,0xde,0xca,0x5e,0x7e,0x00},
    {0x54,0xea,0x7e,0xd4,0xea,0x5c,0x64,0x00},
    {0x7e,0xe2,0x76,0xea,0xf6,0x7e,0x62,0x00},
    {0x48,0xfe,0x76,0xc0,0xdc,0x48,0x7e,0x00},
    {0x7e,0xe2,0x7e,0xe4,0xf6,0x64,0x76,0x00},
    {0x5e,0xf4,0x5e,0xf4,0xda,0x5c,0x5c,0x00},
    {0x4a,0xfe,0x44,0xea,0xde,0x44,0x5a,0x00},
    {0x48,0xfe,0x62,0xdc,0xfe,0x48,0x6a,0x00},
    {0x76,0xea,0x76,0xfe,0xd4,0x68,0x56,0x00},
    {0x56,0xda,0x52,0xfa,0xd4,0x74,0x5a,0x00},
    {0x48,0xfe,0x54,0xfe,0xd4,0x4c,0x72,0x00},
    {0x10,0xfe,0x54,0x38,0xd6,0x38,0xd6,0x00},
    {0x48,0xfc,0x4e,0xfc,0xea,0x5c,0x6a,0x00},
    {0x70,0xfe,0x56,0xfe,0xd6,0x56,0x68,0x00},
    {0x48,0xce,0x5c,0xd4,0xdc,0x7e,0x48,0x00},
    {0x54,0xfe,0xaa,0x38,0xfe,0x38,0xd6,0x00},
    {0x48,0xd4,0x6e,0xdc,0xc4,0x72,0x6e,0x00},
    {0x48,0xfe,0x60,0xea,0xf6,0x72,0x56,0x00},
    {0x54,0xfe,0x54,0xf6,0xf6,0x54,0x7e,0x00},
    {0x76,0xf6,0x76,0xe2,0xe2,0x62,0x66,0x00},
    {0x4a,0xde,0x5a,0xde,0xfe,0x40,0x52,0x00},
    {0x7a,0xd6,0x66,0xfe,0xd2,0x7a,0x46,0x00},
    {0x48,0xd4,0x6e,0xc0,0xfe,0x7e,0x6a,0x00},
    {0x7c,0xd6,0x5a,0xe6,0xdc,0x5c,0x7e,0x00},
    {0x64,0xf6,0x64,0xf6,0xc8,0x5c,0x5c,0x00},
    {0x56,0xfe,0x56,0xfe,0xee,0x7e,0x4a,0x00},
    {0x74,0xd4,0x7e,0xdc,0xf4,0x74,0x5a,0x00},
    {0x5c,0xd4,0x7e,0xdc,0xd4,0x7e,0x44,0x00},
    {0x56,0xfe,0x7a,0xd0,0xfe,0x48,0x76,0x00},
    {0x48,0xdc,0x54,0xdc,0xfa,0x5c,0x6a,0x00},
    {0x4a,0xdc,0x48,0xfe,0xd4,0x6e,0x4e,0x00},
    {0x54,0xfe,0x54,0xd4,0xfe,0x68,0x7e,0x00},
    {0x48,0xfe,0x54,0xfe,0xea,0x5c,0x54,0x00},
    {0x4e,0xd4,0x7e,0xe8,0xda,0x6c,0x5a,0x00},
    {0x7c,0xce,0x54,0xfe,0xde,0x74,0x54,0x00},
    {0x7e,0xd6,0x5c,0xde,0xd6,0x7c,0x44,0x00},
    {0x78,0xd4,0x6e,0xc0,0xda,0x5c,0x5a,0x00},
    {0x5e,0xfe,0x44,0xde,0xc8,0x4e,0x52,0x00},
    {0x48,0xfe,0x5e,0xde,0xc8,0x5c,0x6a,0x00},
    {0x48,0xfe,0x6a,0xd4,0xfa,0x48,0x7e,0x00},
    {0x6a,0xfe,0x6e,0xe0,0xfe,0x5c,0x6a,0x00},
    {0x5e,0xf6,0x5a,0xfe,0xc0,0x4c,0x5e,0x00},
    {0xaa,0x44,0xfe,0x92,0x7c,0x38,0xd6,0x00},
    {0x48,0xfe,0x6a,0xfe,0xea,0x5c,0x6e,0x00},
    {0x6a,0xfe,0x40,0xfe,0xd4,0x48,0x7e,0x00},
    {0x48,0xfe,0x54,0xdc,0xfe,0x62,0x6a,0x00},
    {0x5c,0xc8,0x7e,0xdc,0xd4,0x5c,0x62,0x00},
    {0x5c,0xd4,0x7e,0xe2,0xdc,0x5c,0x54,0x00},
    {0x54,0xfe,0x48,0xfe,0xde,0x54,0x6e,0x00},
    {0x10,0xfe,0xaa,0x7c,0xfe,0xba,0x54,0x00},
    {0xae,0xea,0xee,0x52,0xfe,0x38,0xd6,0x00},
    {0x48,0xfc,0x5c,0xf0,0xde,0x4a,0x5e,0x00},
    {0x5c,0xd4,0x5c,0xfe,0xca,0x5e,0x6a,0x00},
    {0x6e,0x6a,0xf4,0xaa,0xfe,0x38,0xd6,0x00},
    {0x7e,0xd4,0x76,0xd4,0xf6,0x54,0x7e,0x00},
    {0x7e,0xdc,0x5c,0xc0,0xea,0x48,0x76,0x00},
    {0x4a,0xfe,0x5c,0xd4,0xfe,0x54,0x4c,0x00},
    {0x7e,0xe2,0x5c,0xd4,0xfe,0x40,0x62,0x00},
    {0x48,0xfe,0x54,0xfe,0xea,0x4c,0x54,0x00},
    {0x48,0xfe,0x76,0xc8,0xd4,0x6e,0x4c,0x00},
    {0x4e,0xf6,0x66,0xfa,0xdc,0x5c,0x5c,0x00},
    {0x48,0xfe,0x54,0xfe,0xdc,0x5c,0x46,0x00},
    {0x56,0xfe,0x6c,0xfe,0xd6,0x7c,0x54,0x00},
    {0x52,0xbc,0x6a,0xbc,0xfe,0x38,0xd6,0x00},
    {0x76,0xd2,0x48,0xd4,0xea,0x44,0x58,0x00},
    {0x54,0xfe,0x54,0xfe,0xfe,0x48,0x7e,0x00},
    {0x54,0xfe,0x76,0xd4,0xde,0x74,0x5e,0x00},
    {0x48,0xdc,0x5c,0xf6,0xc8,0x7e,0x48,0x00},
    {0x5a,0xee,0x5a,0xde,0xda,0x5e,0x6a,0x00},
    {0x2e,0xf8,0x6e,0xf4,0xfe,0x38,0xd6,0x00},
    {0x54,0xea,0x50,0xf4,0xd6,0x5c,0x56,0x00},
    {0x48,0xfe,0x5c,0xf6,0xdc,0x74,0x5a,0x00},
    {0x7e,0xec,0x6c,0xe0,0xf6,0x76,0x7e,0x00},
    {0x44,0xfe,0x54,0xdc,0xd6,0x7c,0x52,0x00},
    {0x54,0xe8,0x5c,0xdc,0xfe,0x5c,0x6a,0x00},
    {0x48,0xfe,0x5c,0xda,0xfe,0x54,0x4c,0x00},
    {0x54,0xee,0x54,0xee,0x7c,0x10,0xee,0x00},
    {0x48,0xfe,0x6a,0xd4,0xec,0x5a,0x5e,0x00},
    {0x48,0xfe,0x6a,0xd4,0xfc,0x4a,0x7e,0x00},
    {0x54,0xfe,0x5c,0xc8,0xfa,0x5c,0x6a,0x00},
    {0x48,0xdc,0x76,0xdc,0xfe,0x54,0x7a,0x00},
    {0x7c,0xd6,0x7e,0xee,0xee,0x7c,0x4a,0x00},
    {0x5c,0xf6,0x5c,0xdc,0xdc,0x5c,0x62,0x00},
    {0x48,0xfe,0x5c,0xd4,0xfe,0x54,0x5c,0x00},
    {0x5c,0xd4,0x7e,0xde,0xda,0x7c,0x4a,0x00},
    {0x5c,0xd4,0x5c,0xf6,0xf6,0x76,0x76,0x00},
    {0x4c,0xde,0x48,0xd6,0xf6,0x64,0x76,0x00},
    {0x74,0xde,0x68,0xde,0xde,0x6e,0x4a,0x00},
    {0x7a,0xd4,0x62,0xdc,0xd4,0x48,0x7e,0x00},
    {0x48,0xfe,0x54,0xfe,0xdc,0x48,0x7e,0x00},
    {0x48,0xdc,0x7e,0xf6,0xfe,0x54,0x66,0x00},
    {0x6a,0xfe,0x54,0xfe,0xdc,0x48,0x76,0x00},
    {0x48,0xfc,0x5c,0xf0,0xde,0x42,0x56,0x00},
    {0x4c,0xd4,0x7e,0xf6,0xec,0x7e,0x4c,0x00},
    {0x48,0xfe,0x54,0xfe,0xdc,0x72,0x6e,0x00},
    {0x56,0xfa,0x74,0x9a,0xfe,0x38,0xd6,0x00},
    {0x54,0xfe,0x7e,0xd6,0xde,0x6c,0x5a,0x00},
    {0x48,0xd4,0x7e,0xea,0xfe,0x54,0x6a,0x00},
    {0x48,0xfe,0x54,0xea,0xfe,0x76,0x7e,0x00},
    {0x64,0x6e,0xca,0x64,0xfe,0x38,0xd6,0x00},
    {0x28,0xfe,0x6a,0xce,0x7c,0x38,0xd6,0x00},
    {0x74,0xe6,0x60,0xf6,0xc0,0x5c,0x7e,0x00},
    {0x7e,0xec,0x7e,0xec,0xec,0x72,0x7e,0x00},
    {0x76,0xd2,0x40,0xd4,0xde,0x74,0x5e,0x00},
    {0x48,0xfe,0x7a,0xdc,0xfe,0x48,0x58,0x00},
    {0x48,0xfe,0x6a,0xf4,0xdc,0x5c,0x62,0x00},
    {0x54,0xfe,0x54,0xfe,0xda,0x6c,0x5a,0x00},
    {0x56,0xea,0x5e,0xe4,0xda,0x76,0x5a,0x00},
    {0x5c,0xdc,0x5c,0xc0,0xf6,0x76,0x76,0x00},
    {0x5a,0xec,0x5a,0xec,0xfe,0x5c,0x6a,0x00},
    {0x6a,0xd4,0x76,0xc8,0xfe,0x5c,0x6a,0x00},
    {0x76,0xf6,0x6e,0xea,0xfe,0x72,0x7e,0x00},
    {0x7e,0xf4,0x7e,0xf4,0xe0,0x74,0x5e,0x00},
    {0x76,0xf6,0x6a,0xd0,0xfe,0x54,0x7a,0x00},
    {0x56,0xea,0x6e,0xfe,0xdc,0x7e,0x58,0x00},
    {0x28,0xfe,0x6a,0x4e,0x7c,0x38,0xd6,0x00},
    {0x5c,0xfe,0x6a,0xc8,0xc0,0x6a,0x6a,0x00},
    {0x5a,0xbc,0x5a,0xa4,0xfe,0x38,0xd6,0x00},
    {0x74,0xe6,0x76,0xdc,0xdc,0x5c,0x66,0x00},
    {0x54,0xee,0x7c,0xfa,0xf4,0x42,0x74,0x00},
    {0x6e,0xfe,0x6e,0xd6,0xfe,0x74,0x7a,0x00},
    {0x44,0x96,0xfa,0x44,0xf4,0x24,0xda,0x00},
    {0x54,0x26,0x5a,0xf4,0x24,0x7c,0xaa,0x00},
    {0x90,0x1e,0xaa,0x14,0xbc,0x34,0xfe,0x00},
    {0x24,0xf6,0x2a,0x54,0xf4,0x14,0x5a,0x00},
    {0x48,0xae,0xf6,0xe4,0x84,0xe4,0x9a,0x00},
    {0x74,0x56,0x7a,0x74,0x94,0xd4,0x3a,0x00},
    {0x14,0x66,0xfa,0x24,0xf4,0xb4,0xfa,0x00},
    {0x54,0xf6,0x3a,0xf4,0x34,0x74,0xaa,0x00},
    {0xf4,0xb6,0xba,0x84,0xdc,0xdc,0xfa,0x00},
    {0x24,0x56,0xaa,0xf4,0x54,0xf4,0x5a,0x00},
    {0x24,0x36,0xea,0xb4,0xa4,0xb4,0xea,0x00},
    {0x24,0x56,0xfa,0xac,0xfc,0x54,0xaa,0x00},
    {0x54,0xb6,0xba,0xb4,0xf4,0x04,0x9a,0x00},
    {0x54,0xfe,0xda,0x54,0x7c,0xd4,0x7a,0x00},
    {0x4c,0xc6,0xac,0xfe,0x76,0xce,0xea,0x00},
    {0xfe,0x10,0x1c,0x64,0x18,0x10,0x60,0x00},
    {0xee,0x4a,0x74,0xae,0x6a,0x44,0x9a,0x00},
    {0xe4,0x58,0x68,0xbe,0x68,0x48,0xb6,0x00},
    {0xe8,0x54,0x6a,0xa4,0x6a,0x44,0x98,0x00},
    {0xe8,0x5c,0x74,0xbe,0x68,0x48,0xb6,0x00},
    {0xec,0x5a,0x60,0xac,0x64,0x5e,0x88,0x00},
    {0xea,0x5e,0x64,0xaa,0x7e,0x44,0x9a,0x00},
    {0xe8,0x5e,0x74,0xbe,0x60,0x4c,0x8c,0x00},
    {0xec,0x4c,0x7e,0xb2,0x7e,0x40,0x92,0x00},
    {0xf0,0x5e,0x6c,0xac,0x6e,0x56,0x8a,0x00},
    {0xe4,0x5e,0x64,0xbe,0x72,0x4c,0x9e,0x00},
    {0xfa,0x5a,0x6c,0xac,0x6c,0x5e,0x84,0x00},
    {0xe8,0x7e,0x6a,0xb4,0x7c,0x5c,0xa2,0x00},
    {0xee,0x54,0x7e,0xb4,0x7e,0x54,0xba,0x00},
    {0xf6,0x54,0x7e,0xb4,0x7e,0x54,0xba,0x00},
    {0x38,0x2a,0xce,0x78,0x28,0x10,0xee,0x00},
    {0x2e,0xca,0xe0,0xee,0x8a,0xe4,0xaa,0x00},
    {0x4e,0xfa,0x60,0x9e,0xfa,0x64,0xba,0x00},
    {0xfe,0xba,0xb0,0x8e,0xda,0xd4,0xfa,0x00},
    {0x7c,0x54,0x54,0xfe,0x54,0x7e,0x0c,0x00},
    {0x84,0xfe,0x68,0x6e,0xb0,0xea,0x2a,0x00},
    {0x10,0x54,0x9a,0x70,0x1c,0xf2,0x1e,0x00},
    {0x24,0xde,0x64,0xd6,0x6c,0xd6,0x7e,0x00},
    {0x10,0xfe,0x44,0xfe,0xba,0x7c,0x1e,0x00},
    {0x38,0x1e,0xf0,0x1c,0x66,0xcc,0x66,0x00},
    {0x24,0xd6,0x64,0xda,0x64,0xda,0x7e,0x00},
    {0x08,0x7e,0x54,0x7e,0x4c,0x78,0x8e,0x00},
    {0x22,0xfc,0xd6,0xfc,0x66,0x6c,0xf6,0x00},
    {0x5e,0xf2,0x9e,0x94,0xbe,0x74,0x1a,0x00},
    {0x40,0x7e,0xb8,0x7c,0x04,0x04,0x02,0x00},
    {0x40,0x7e,0xb8,0x7c,0x8c,0x34,0x52,0x00},
    {0x40,0x7e,0xb8,0xfc,0x5c,0x6c,0x7a,0x00},
    {0x40,0x7e,0xb8,0x7c,0xac,0x74,0xaa,0x00},
    {0x7c,0x10,0xfe,0x10,0xda,0x54,0xb2,0x00},
    {0x88,0x08,0xaa,0x2a,0xaa,0xaa,0xbe,0x00},
    {0x88,0x08,0x9c,0x08,0x48,0x88,0xbe,0x00},
    {0xbe,0x08,0x88,0x1c,0x48,0x88,0xbe,0x00},
    {0x84,0x18,0x90,0x1e,0x54,0x94,0xa4,0x00},
    {0xbe,0x08,0x8e,0x12,0x5c,0x84,0xbe,0x00},
    {0x84,0x04,0x96,0x14,0x54,0x94,0xbe,0x00},
    {0x90,0x08,0x90,0x34,0xb2,0xd4,0x9c,0x00},
    {0x88,0x3e,0x88,0x3e,0xaa,0xaa,0x88,0x00},
    {0x94,0x14,0xa2,0x1c,0x54,0x94,0xac,0x00},
    {0xbe,0x22,0xa2,0x3e,0xa2,0xa2,0xbe,0x00},
    {0xbe,0x20,0xbe,0x2a,0xaa,0xa4,0xda,0x00},
    {0x9e,0x12,0xa6,0x1c,0x54,0x88,0xb6,0x00},
    {0x88,0x3e,0x88,0x1c,0x9c,0xaa,0x88,0x00},
    {0xaa,0x2a,0xbe,0x2a,0xae,0xa0,0xbe,0x00},
    {0x88,0x1c,0x94,0x3e,0x88,0x88,0xb6,0x00},
    {0xb4,0x14,0xb4,0x24,0xb8,0x9a,0xbe,0x00},
    {0x88,0x08,0xbe,0x08,0x5c,0x94,0x9c,0x00},
    {0xbe,0x36,0xb6,0x36,0xa2,0xa2,0xbe,0x00},
    {0xbe,0x22,0xaa,0x2a,0xb6,0xa2,0xbe,0x00},
    {0x84,0x18,0x90,0x1e,0x5c,0x96,0xa4,0x00},
    {0x9c,0x14,0x9c,0x14,0x5c,0x94,0xbe,0x00},
    {0x88,0x3e,0xa2,0x14,0x58,0x92,0x9e,0x00},
    {0x88,0x08,0x8e,0x08,0xbe,0xa2,0xbe,0x00},
    {0xbe,0x2a,0xaa,0x3e,0xaa,0xaa,0xbe,0x00},
    {0xbc,0x08,0xbc,0x04,0xa8,0xb0,0xce,0x00},
    {0xbc,0x24,0xbc,0x28,0xbe,0xa4,0xb2,0x00},
    {0xbe,0x1c,0xaa,0x08,0xbe,0x88,0x88,0x00},
    {0xbe,0x22,0xbe,0x22,0xbe,0xa2,0xbe,0x00},
    {0x88,0x7e,0xbc,0x28,0xbe,0x8a,0xb6,0x00},
    {0x56,0x80,0x56,0xc2,0x4a,0x52,0x56,0x00},
    {0x90,0x1e,0xb6,0x0a,0x56,0x9e,0x82,0x00},
    {0x90,0x3e,0xaa,0x2a,0xaa,0xaa,0xfe,0x00},
    {0x88,0x14,0xae,0x00,0x5c,0x94,0x9c,0x00},
    {0x88,0x2a,0x9c,0x3e,0x94,0x94,0xa6,0x00},
    {0x98,0x1c,0xa8,0x3e,0x88,0x9c,0xaa,0x00},
    {0x90,0x1e,0xbe,0x16,0x5e,0x96,0x9e,0x00},
    {0xa0,0x2e,0xfa,0x5a,0xea,0xba,0xce,0x00},
    {0xbe,0x14,0xbe,0x36,0xb6,0xa2,0xbe,0x00},
    {0xba,0x16,0x9e,0x2e,0x9a,0x92,0xa6,0x00},
    {0x88,0x3e,0xa2,0x1c,0xbe,0x94,0xa6,0x00},
    {0x9c,0x1c,0x80,0x3e,0xa2,0xbe,0xa2,0x00},
    {0x88,0x3e,0xaa,0x7e,0x94,0xaa,0xde,0x00},
    {0x92,0x3e,0x94,0x26,0x9c,0xa8,0x96,0x00},
    {0x88,0x3e,0x9c,0x1c,0xaa,0x88,0xb6,0x00},
    {0x92,0x3c,0x98,0x1e,0xba,0x9a,0xb2,0x00},
    {0xb2,0x1c,0xa6,0x14,0xbe,0x90,0xae,0x00},
    {0x94,0x3e,0x8a,0x3e,0xa8,0x9e,0xaa,0x00},
    {0x88,0x1c,0xbe,0x08,0xbe,0xb4,0x8c,0x00},
    {0xbe,0x22,0xbe,0x08,0x5c,0x88,0xbe,0x00},
    {0x88,0x3e,0x94,0x2a,0x9c,0x9c,0x86,0x00},
    {0xaa,0x06,0xbe,0x16,0xba,0x92,0xaa,0x00},
    {0xaa,0x3e,0xaa,0x3e,0xaa,0xbe,0xca,0x00},
    {0xbe,0x18,0xaa,0x3e,0xbe,0xaa,0xbe,0x00},
    {0x94,0x3e,0x94,0x1c,0xbe,0x80,0xa2,0x00},
    {0x88,0x14,0xbe,0x08,0xbe,0x9c,0xbe,0x00},
    {0xbe,0x2a,0xbe,0x2a,0xb6,0xbe,0xbe,0x00},
    {0x94,0x08,0x94,0x7e,0xb4,0xdc,0x94,0x00},
    {0x88,0x3e,0x94,0x14,0xaa,0xbe,0x88,0x00},
    {0xaa,0x7a,0xa0,0x74,0xe4,0xaa,0xae,0x00},
    {0x94,0x2a,0x88,0x3e,0xa2,0xae,0xae,0x00},
    {0x9c,0x2a,0x80,0x3c,0x8e,0xbc,0x88,0x00},
    {0x88,0x3e,0x8c,0x1c,0xbe,0x94,0xba,0x00},
    {0x92,0x3c,0x98,0x3e,0xba,0x9a,0x92,0x00},
    {0x8a,0x3e,0x84,0x1a,0xbe,0x84,0x9a,0x00},
    {0x88,0x3e,0xa2,0x1c,0xbe,0x88,0xaa,0x00},
    {0x94,0x3a,0x90,0x1c,0x9a,0xac,0xaa,0x00},
    {0x88,0x1c,0xbe,0x14,0xa6,0x88,0xbe,0x00},
    {0x88,0x14,0xae,0x00,0xbe,0xbe,0xaa,0x00},
    {0x94,0x1e,0xb4,0x1e,0x54,0x94,0x9e,0x00},
    {0xbe,0x2a,0xbe,0x3e,0x94,0x9c,0x94,0x00},
    {0xbe,0x14,0xbe,0x36,0xbe,0x88,0xbe,0x00},
    {0x94,0x3e,0x94,0x3e,0x82,0x9a,0x9a,0x00},
    {0x9c,0x24,0x9c,0x1c,0xbe,0x88,0xb6,0x00},
    {0x9c,0x2a,0x80,0x1e,0x4a,0x94,0xaa,0x00},
    {0x88,0x1c,0x94,0x1c,0xbe,0x88,0xbe,0x00},
    {0xbe,0x2a,0xbe,0x1c,0x9c,0xbe,0x88,0x00},
    {0x88,0x3e,0x9c,0x2a,0x9c,0x9c,0xbe,0x00},
    {0xb4,0x14,0xbe,0x1c,0xb4,0xb4,0x9a,0x00},
    {0xaa,0x7e,0xae,0x20,0xbe,0x9c,0xaa,0x00},
    {0x88,0x1c,0x94,0x1c,0xba,0x9c,0xaa,0x00},
    {0xaa,0x3e,0x80,0x3e,0x90,0xbe,0xaa,0x00},
    {0x88,0x3e,0x94,0x7e,0xde,0x88,0x98,0x00},
    {0x8e,0x34,0x9e,0x34,0x9e,0x94,0xa4,0x00},
    {0xba,0x2e,0xbe,0x2a,0xb8,0xaa,0xbc,0x00},
    {0xbe,0x08,0xbe,0x36,0xbe,0xb6,0xbe,0x00},
    {0x94,0x3e,0xfe,0x4e,0x96,0xba,0x92,0x00},
    {0x94,0x3e,0x94,0x3e,0xbe,0xbe,0xaa,0x00},
    {0xb8,0x14,0xae,0x00,0xba,0xbc,0xaa,0x00},
    {0xa8,0x7e,0xae,0x32,0xb4,0xde,0xd4,0x00},
    {0x92,0x7e,0xb6,0x3e,0x92,0xba,0xd6,0x00},
    {0x9c,0x2a,0x90,0x08,0xbe,0x88,0xb6,0x00},
    {0x88,0x1c,0xbe,0x14,0xba,0x9c,0xbe,0x00},
    {0x9c,0x1c,0xaa,0x08,0xbe,0x94,0xa6,0x00},
    {0xbe,0x3e,0xaa,0x36,0xae,0xba,0xbe,0x00},
    {0x88,0x7e,0xca,0x3e,0x94,0xfe,0x88,0x00},
    {0xbe,0x2c,0xbe,0x54,0xbe,0x94,0x8c,0x00},
    {0xae,0x7e,0xae,0x3e,0x96,0xa6,0x8a,0x00},
    {0x88,0x14,0xba,0x18,0x90,0xac,0x8c,0x00},
    {0x96,0x2a,0xaa,0x3e,0x94,0x88,0xb6,0x00},
    {0x9c,0x2a,0x80,0x16,0xa2,0xb6,0xbe,0x00},
    {0xf4,0xaa,0xfe,0xb4,0xea,0xbc,0xaa,0x00},
    {0x88,0x3e,0xac,0x26,0xbc,0xaa,0xce,0x00},
    {0x8a,0x3e,0x9c,0x14,0xbe,0x94,0x8c,0x00},
    {0x88,0x3e,0x94,0x3e,0xaa,0x8c,0x94,0x00},
    {0xbe,0x22,0x9c,0x14,0xbe,0x80,0xa2,0x00},
    {0x9e,0xe4,0x8e,0x7a,0xee,0x70,0xaa,0x00},
    {0xae,0x36,0xb6,0x3e,0xa4,0xb4,0xaa,0x00},
    {0x94,0x3e,0xb6,0x14,0x9e,0xb4,0x9e,0x00},
    {0xbe,0x3e,0xac,0x3e,0xbe,0xb0,0xde,0x00},
    {0xa8,0x7e,0x8c,0x34,0x8e,0xb4,0xb4,0x00},
    {0x88,0x7e,0x94,0x3a,0x98,0xb4,0x9a,0x00},
    {0xa6,0xea,0x7e,0xa4,0x74,0x38,0xd6,0x00},
    {0x94,0x3a,0x94,0x3e,0xaa,0x84,0x98,0x00},
    {0x94,0x7e,0xba,0x3c,0x94,0xb4,0xda,0x00},
    {0x94,0x3e,0x94,0x2a,0xbe,0xaa,0x88,0x00},
    {0xb6,0x14,0xb6,0x24,0xbe,0x9c,0xba,0x00},
    {0xa8,0x3e,0xf4,0x7a,0xb4,0xbe,0xa4,0x00},
    {0x94,0x3e,0x9c,0x08,0xba,0x9c,0xaa,0x00},
    {0x88,0x3e,0x94,0x1c,0xbe,0xae,0xba,0x00},
    {0x88,0x0e,0xbc,0x36,0xaa,0xb6,0xbe,0x00},
    {0x88,0x1c,0xbe,0x36,0xbe,0x94,0xa6,0x00},
    {0xbe,0x3e,0xa4,0x28,0xbe,0xaa,0xd4,0x00},
    {0x94,0x3e,0x94,0x2a,0x9c,0x9c,0x94,0x00},
    {0x84,0x16,0x94,0x7e,0xb6,0xa4,0xf6,0x00},
    {0xbe,0x16,0xaa,0x24,0xb6,0xa4,0xf6,0x00},
    {0x9c,0x0e,0xbc,0x16,0xbe,0x94,0x8c,0x00},
    {0x94,0x1e,0xbe,0x14,0xaa,0x9c,0x9c,0x00},
    {0xa8,0x3e,0xbe,0x14,0xaa,0x9c,0x9c,0x00},
    {0xbe,0x1c,0x80,0x1c,0x94,0xbe,0x88,0x00},
    {0x94,0x3e,0xbe,0x06,0xbe,0x94,0xba,0x00},
    {0x88,0x3e,0x94,0x3e,0x9c,0x88,0xbe,0x00},
    {0xbe,0x14,0xbe,0x1c,0xaa,0x9c,0x9c,0x00},
    {0x92,0x3c,0x92,0x3c,0xa8,0x92,0xbc,0x00},
    {0xbe,0x14,0xb6,0x36,0xbe,0xaa,0xbe,0x00},
    {0x88,0x7e,0xdc,0x4e,0xfe,0xdc,0xaa,0x00},
    {0x88,0x3e,0x94,0x3e,0x94,0x88,0xaa,0x00},
    {0x88,0x1e,0x9e,0x1a,0xbe,0x88,0xb6,0x00},
    {0xb4,0x1a,0xb0,0x3e,0x94,0xbe,0x94,0x00},
    {0x9c,0x14,0xbe,0x2a,0xbe,0x9c,0xaa,0x00},
    {0xbe,0x3e,0x88,0x3e,0x94,0xbe,0x88,0x00},
    {0x8c,0x14,0xbe,0x36,0xac,0xbe,0xac,0x00},
    {0x88,0x3e,0x94,0x3e,0x94,0x9c,0xa2,0x00},
    {0x9c,0x3e,0xaa,0x14,0xbe,0x8a,0x88,0x00},
    {0x88,0x3e,0x94,0x2a,0x94,0x9c,0xa4,0x00},
    {0xbe,0x3e,0x92,0x24,0xb6,0x80,0xaa,0x00},
    {0x88,0x0e,0xbe,0x2a,0x94,0xae,0x8c,0x00},
    {0xbe,0x1c,0xaa,0x3e,0xaa,0xbe,0xaa,0x00},
    {0x88,0x3e,0xba,0x1c,0xbe,0x88,0x98,0x00},
    {0x88,0x3e,0xaa,0x34,0x9c,0x9c,0xa2,0x00},
    {0xaa,0x3e,0xf4,0x7e,0xbc,0xa8,0xb6,0x00},
    {0x94,0x3e,0x94,0x7e,0xda,0xac,0x9a,0x00},
    {0x88,0x3e,0xae,0x14,0x9e,0xa2,0x96,0x00},
    {0x88,0x3e,0xaa,0x14,0xbe,0x9e,0xac,0x00},
    {0xb4,0x3e,0xb4,0x3a,0xbe,0x84,0xaa,0x00},
    {0xbe,0x3e,0x94,0x3e,0xaa,0x9c,0xaa,0x00},
    {0x94,0x3e,0x88,0x7e,0xbc,0xda,0x94,0x00},
    {0x96,0x2e,0xb6,0x0a,0x96,0xaa,0x9e,0x00},
    {0x88,0x0e,0xb8,0x2e,0xac,0xba,0xd6,0x00},
    {0x88,0x7e,0xa0,0x3e,0xb4,0xac,0xd6,0x00},
    {0xb4,0x1a,0xb0,0x3e,0x96,0xba,0x92,0x00},
    {0xa4,0x1e,0xb4,0x1e,0xb8,0x96,0xa6,0x00},
    {0xbe,0x34,0xbe,0x34,0xa0,0xb4,0xde,0x00},
    {0x88,0x0e,0xb8,0x2e,0xa0,0xac,0xde,0x00},
    {0x94,0x3e,0x9c,0x76,0xa2,0xb6,0xd6,0x00},
    {0xbe,0x14,0xba,0x2e,0xba,0x9e,0xba,0x00},
    {0xb6,0x36,0xaa,0x3e,0xaa,0xbe,0xaa,0x00},
    {0x94,0x2e,0xfe,0x56,0xfe,0xd4,0xaa,0x00},
    {0xb6,0x2a,0xbe,0x2c,0xbe,0xe4,0xb6,0x00},
    {0x9a,0x2c,0x9a,0x3e,0x90,0x9e,0x82,0x00},
    {0x1c,0x64,0x18,0xe0,0x54,0x28,0xc6,0x00},
    {0x48,0x5c,0xfa,0xc8,0x4a,0x64,0x98,0x00},
    {0x7e,0x62,0xfe,0xf6,0x7e,0x62,0xa6,0x00},
    {0x7e,0x76,0xe2,0xfe,0x76,0x7e,0xa2,0x00},
    {0x5e,0x50,0xfe,0xd2,0x5e,0x70,0x9e,0x00},
    {0x50,0x5e,0xe8,0xce,0x48,0x6e,0x88,0x00},
    {0x7e,0x48,0xfe,0xea,0x76,0x62,0xa6,0x00},
    {0x48,0x4e,0xf2,0xce,0x4e,0x68,0x8e,0x00},
    {0x7e,0x6a,0xfe,0xea,0x76,0x62,0xbe,0x00},
    {0x28,0x7e,0xc8,0x5c,0x6a,0x00,0xaa,0x00},
    {0x7c,0x08,0xd2,0x54,0x92,0x7c,0xaa,0x00},
    {0x4c,0x54,0xc8,0xd4,0x62,0x5c,0x9c,0x00},
    {0xfe,0x1c,0x50,0xfe,0x7e,0x02,0xaa,0x00},
    {0x4c,0x54,0xe8,0xf6,0x48,0x7e,0x88,0x00},
    {0x7e,0x62,0xfe,0xe4,0x76,0x64,0xb6,0x00},
    {0x48,0x7e,0xd4,0xfe,0x40,0x5c,0x9c,0x00},
    {0x5c,0x64,0xdc,0xdc,0x7e,0x48,0xb6,0x00},
    {0xf6,0xa6,0x96,0xa4,0xf6,0x00,0xaa,0x00},
    {0x76,0x76,0x76,0x74,0xb6,0x00,0xaa,0x00},
    {0xe8,0xae,0xf2,0xae,0xee,0x00,0xaa,0x00},
    {0xaa,0x44,0xfe,0xbe,0x14,0x7c,0x12,0x00},
    {0x48,0x5c,0xd4,0xdc,0x7e,0x48,0xbe,0x00},
    {0x5c,0x6a,0xc0,0xde,0x4a,0x54,0xaa,0x00},
    {0x5c,0x54,0xfe,0xd0,0x5e,0x6a,0x96,0x00},
    {0x38,0xfe,0x7c,0x7c,0xfe,0x00,0xaa,0x00},
    {0x5c,0x7e,0xdc,0xdc,0x7e,0x40,0xaa,0x00},
    {0x48,0x5c,0xdc,0xdc,0x40,0x72,0xae,0x00},
    {0x5c,0x48,0xfe,0xdc,0x5c,0x5c,0xa2,0x00},
    {0x72,0x7e,0x6a,0xa6,0x54,0x28,0xc6,0x00},
    {0x24,0x76,0xfa,0x64,0xaa,0x00,0xaa,0x00},
    {0x76,0x76,0xe2,0xee,0x6e,0x76,0xa2,0x00},
    {0x10,0xfe,0x38,0xfe,0x44,0x7c,0xaa,0x00},
    {0x56,0x7c,0xde,0xfc,0x46,0x5c,0xba,0x00},
    {0x48,0x5c,0xfe,0xf6,0x7e,0x54,0xa6,0x00},
    {0x54,0x7e,0xee,0xf6,0x5e,0x74,0x9a,0x00},
    {0x7e,0x54,0xfe,0xdc,0x6a,0x5c,0x9c,0x00},
    {0x48,0x7e,0xd4,0xfe,0x54,0x48,0xaa,0x00},
    {0x48,0x5e,0xde,0xda,0x7e,0x48,0xb6,0x00},
    {0x5e,0x6a,0xf8,0xd6,0x7a,0x54,0xba,0x00},
    {0x6c,0x52,0xee,0xcc,0x56,0x6c,0xbe,0x00},
    {0x64,0x4e,0xde,0xea,0x5e,0x64,0xbe,0x00},
    {0x48,0x5c,0xee,0xdc,0x6a,0x5c,0xbe,0x00},
    {0xee,0x44,0xaa,0x66,0x54,0x28,0xc6,0x00},
    {0x76,0x52,0xc0,0xd4,0x5e,0x74,0x9e,0x00},
    {0x5a,0x6c,0xda,0xec,0x7e,0x5c,0xaa,0x00},
    {0x48,0x4e,0xf8,0xee,0x60,0x6c,0x9e,0x00},
    {0x76,0x76,0xea,0xfe,0x6a,0x7e,0xaa,0x00},
    {0x2c,0x54,0xfe,0xaa,0x7c,0x92,0x28,0x00},
    {0x7c,0x52,0xbc,0x14,0xfe,0x1c,0x30,0x00},
    {0x10,0x66,0x76,0x74,0x76,0x70,0xae,0x00},
    {0x7c,0x52,0xbc,0x7e,0x34,0x48,0xb6,0x00},
    {0x7c,0x52,0xbc,0x24,0x3e,0x42,0xaa,0x00},
    {0x64,0x18,0x64,0x28,0x28,0x10,0xee,0x00},
    {0xbc,0x54,0xbc,0x14,0xbc,0x54,0xbe,0x00},
    {0x24,0x24,0x3c,0x04,0x7c,0x24,0x44,0x00},
    {0xa8,0xbe,0xe8,0x3c,0xfc,0x6a,0xa8,0x00},
    {0xa8,0xbe,0xf4,0x2a,0xfe,0x76,0xbe,0x00},
    {0xaa,0xbe,0xe4,0x8a,0xfe,0xa4,0xaa,0x00},
    {0xa4,0xbe,0xfa,0x9e,0xec,0xac,0xb2,0x00},
    {0xc2,0xfc,0xd4,0x5e,0xf4,0x52,0x5e,0x00},
    {0xdc,0xc8,0xfc,0x54,0xfe,0x54,0x5c,0x00},
    {0x68,0xfe,0x76,0xaa,0x3c,0xfe,0x10,0x00},
    {0x6a,0xfa,0x6a,0xb2,0x3c,0xfe,0x10,0x00},
    {0x50,0x7c,0xfe,0x48,0x6c,0xfe,0x24,0x00},
    {0xc8,0xfe,0xd4,0x5c,0xfe,0x62,0x6a,0x00},
    {0xaa,0x44,0xfe,0xb2,0x3c,0xfe,0x10,0x00},
    {0xc8,0xfe,0xf6,0x7e,0xdc,0x5c,0x62,0x00},
    {0xd4,0xfe,0xc8,0x7e,0xd6,0x4c,0x5a,0x00},
    {0xaa,0x5e,0xa8,0x6c,0xac,0x2c,0xd6,0x00},
    {0xa4,0x5e,0xa4,0x66,0xac,0x34,0xcc,0x00},
    {0xbc,0x54,0xd4,0x7e,0xd4,0x54,0xbe,0x00},
    {0xa8,0x5e,0xaa,0x6a,0xbe,0x28,0xc8,0x00},
    {0xa8,0x48,0xea,0x6c,0xc8,0x54,0xa2,0x00},
    {0xbe,0x6a,0xfe,0x6a,0xfe,0x48,0x88,0x00},
    {0x94,0x7e,0xde,0x74,0xfe,0x56,0xa4,0x00},
    {0xac,0x54,0xc8,0x54,0xe2,0x5c,0x9c,0x00},
    {0xbe,0x52,0xbe,0x72,0xbe,0x34,0xda,0x00},
    {0x88,0x7e,0xd4,0x62,0xd4,0x48,0xb6,0x00},
    {0x88,0x7e,0xdc,0x5c,0xea,0x48,0xb6,0x00},
    {0xac,0x4c,0xa0,0x7e,0xb2,0x3e,0xd2,0x00},
    {0x2c,0x74,0xe8,0x74,0x7e,0x48,0x76,0x00},
    {0x88,0x7e,0xc8,0x54,0xfe,0x44,0x94,0x00},
    {0x96,0x62,0xf6,0x62,0xfe,0x54,0xa6,0x00},
    {0xa8,0x5c,0xc8,0x7e,0xdc,0x5c,0x94,0x00},
    {0xac,0x4c,0xbe,0x72,0xbe,0x32,0xde,0x00},
    {0x88,0x7e,0xd4,0x54,0xea,0x7e,0x88,0x00},
    {0xac,0x64,0xfe,0x68,0xfe,0x64,0xba,0x00},
    {0xaa,0x7e,0xc0,0x7e,0xd0,0x7e,0xaa,0x00},
    {0xae,0x4a,0xae,0x74,0xae,0x24,0xde,0x00},
    {0xbe,0x56,0xbe,0x60,0xbe,0x34,0xda,0x00},
    {0x9c,0x54,0xfe,0x62,0xdc,0x5c,0x94,0x00},
    {0xa6,0xea,0x7e,0xa4,0xfe,0x10,0xee,0x00},
    {0x94,0x7e,0xdc,0x54,0xfe,0x48,0xb6,0x00},
    {0xea,0xe8,0xfe,0x48,0xe8,0x14,0xa2,0x00},
    {0xbe,0x68,0xd6,0x6e,0xf4,0x54,0xaa,0x00},
    {0xa8,0x54,0xfe,0x6a,0xfe,0x54,0x9c,0x00},
    {0xbe,0x6a,0xde,0x62,0xda,0x5e,0xba,0x00},
    {0x88,0x7e,0xfa,0x5c,0xfe,0x48,0x98,0x00},
    {0xf6,0xf4,0x7e,0x74,0xf4,0x54,0x7a,0x00},
    {0xaa,0x54,0xde,0x56,0xda,0x5e,0xaa,0x00},
    {0x26,0x34,0xee,0xb4,0xe4,0xf4,0xda,0x00},
    {0x96,0x7a,0xf0,0x7e,0xde,0x70,0x9a,0x00},
    {0x10,0xfe,0x5a,0xda,0x5a,0xea,0x2e,0x00},
    {0x16,0xe4,0x6e,0xe4,0x64,0xe4,0x22,0x00},
    {0x10,0xde,0x68,0xdc,0x5a,0xea,0x18,0x00},
    {0x08,0xfe,0x6a,0xfc,0x74,0xe8,0x36,0x00},
    {0x08,0xfe,0x52,0xfe,0x52,0xf2,0x1e,0x00},
    {0x3e,0xd4,0x5c,0xdc,0x54,0xfe,0x04,0x00},
    {0x3e,0xe2,0x7e,0xea,0x7e,0xfe,0x2a,0x00},
    {0x0c,0xd4,0x48,0xd4,0x62,0xdc,0x1c,0x00},
    {0x3e,0xd4,0x76,0xf6,0x7e,0xea,0x3e,0x00},
    {0x08,0xfe,0x52,0xfe,0x5e,0xf4,0x1a,0x00},
    {0x16,0xfe,0x6c,0xfe,0x66,0xec,0x34,0x00},
    {0x08,0xce,0x78,0xee,0x60,0xec,0x36,0x00},
    {0x1c,0xc8,0x7c,0xd4,0x7e,0xd4,0x1c,0x00},
    {0x14,0xf6,0x54,0xf6,0x54,0xf6,0x14,0x00},
    {0x24,0xce,0x64,0xce,0x64,0xe8,0x2e,0x00},
    {0x36,0xf2,0x66,0xfe,0x6a,0xf4,0x2a,0x00},
    {0x3e,0xea,0x7e,0xdc,0x5c,0xfe,0x08,0x00},
    {0xee,0x44,0xee,0x28,0xb2,0x20,0xde,0x00},
    {0x0a,0xf4,0x4a,0xfe,0x56,0xfa,0x1e,0x00},
    {0x3e,0xe2,0x6e,0xd4,0x5c,0xd4,0x1c,0x00},
    {0x38,0xd4,0x6e,0xc0,0x5a,0xdc,0x1a,0x00},
    {0xaa,0x44,0xfe,0x92,0x7c,0x14,0xfe,0x00},
    {0x10,0xfe,0x6a,0xfe,0x6a,0xdc,0x2e,0x00},
    {0x14,0xea,0x48,0xdc,0x54,0xdc,0x22,0x00},
    {0x3e,0xe8,0x7c,0xe8,0x7e,0xc2,0x2a,0x00},
    {0x06,0xda,0x48,0xfe,0x48,0xea,0x3e,0x00},
    {0x14,0xfe,0x54,0xfe,0x7e,0xc8,0x3e,0x00},
    {0x08,0xfe,0x54,0xfe,0x5c,0xfe,0x08,0x00},
    {0x2a,0xfe,0x54,0xfe,0x5c,0xc8,0x36,0x00},
    {0x64,0x6e,0xca,0x64,0xfe,0x3c,0xfe,0x00},
    {0x0c,0xf6,0x4e,0xee,0x5a,0xe4,0x1a,0x00},
    {0x16,0xfc,0x6e,0xfa,0x6e,0xfc,0x2e,0x00},
    {0x36,0xf6,0x6a,0xd0,0x7e,0xd4,0x3a,0x00},
    {0x2a,0xc4,0x48,0xfe,0x54,0xcc,0x32,0x00},
    {0x42,0xfc,0x54,0xb4,0x54,0x7a,0x2a,0x00},
    {0x54,0xfe,0xba,0x74,0xfe,0x74,0xb4,0x00},
    {0xf4,0x44,0x6e,0x64,0x64,0x64,0xde,0x00},
    {0xf2,0x4c,0x64,0x6e,0x64,0x64,0xde,0x00},
    {0x28,0xc6,0x20,0xfe,0x3c,0x24,0xf6,0x00},
    {0xe4,0x5e,0x64,0x76,0x7c,0x66,0xbe,0x00},
    {0xf4,0x4a,0x60,0x6e,0x66,0x6a,0xde,0x00},
    {0xf2,0x4c,0x66,0x6c,0x64,0x66,0xde,0x00},
    {0xee,0x44,0x6a,0x6e,0x6a,0x6e,0xde,0x00},
    {0x90,0x1e,0x2a,0x94,0xfe,0x24,0xf6,0x00},
    {0xfe,0x48,0xec,0xec,0xec,0x4c,0xfa,0x00},
    {0x14,0xee,0x74,0xaa,0xfe,0x24,0xf6,0x00},
    {0xee,0x48,0x6e,0x6e,0x74,0x6e,0xde,0x00},
    {0xfe,0xb8,0xbc,0x8c,0xdc,0xdc,0xfa,0x00},
    {0x5e,0xe8,0x6c,0x6c,0xec,0x2c,0xba,0x00},
    {0x28,0xfe,0x54,0xfe,0xbe,0x24,0xf6,0x00},
    {0x10,0xfe,0x5c,0x9e,0xfe,0x24,0xf6,0x00},
    {0x64,0x6e,0xca,0x64,0xfe,0x24,0xf6,0x00},
    {0x54,0xfe,0xba,0x44,0xfe,0x44,0x7c,0x00},
    {0xec,0x4e,0xf4,0xee,0xc4,0x5e,0xbe,0x00},
    {0x7e,0x04,0x7e,0x52,0x7e,0x52,0x56,0x00},
    {0x7c,0x54,0x7c,0x54,0xfe,0x10,0x30,0x00},
    {0x52,0x04,0x7e,0x52,0x7e,0x52,0x7e,0x00},
    {0x08,0xf4,0xe2,0xf4,0xf4,0xf4,0x24,0x00},
    {0x14,0xfe,0xf4,0xf4,0xfe,0xf4,0x24,0x00},
    {0x08,0xfc,0xe8,0xfe,0xe8,0xf4,0x22,0x00},
    {0x08,0xf4,0xea,0xe4,0xea,0xe4,0x18,0x00},
    {0x24,0xf4,0x04,0xf4,0xf8,0xfa,0xfe,0x00},
    {0x28,0x74,0xfe,0x44,0xbe,0x34,0x3c,0x00},
    {0x08,0xfe,0xe8,0xfa,0xf4,0xf4,0x1a,0x00},
    {0x08,0xfc,0xe8,0xfe,0xe4,0xfe,0x14,0x00},
    {0x7c,0x54,0x7c,0x28,0x10,0xee,0x38,0x00},
    {0x10,0x7c,0x16,0x7c,0xfe,0x54,0xfe,0x00},
    {0x08,0xf4,0xfe,0xe8,0xfe,0xe8,0x1a,0x00},
    {0x08,0xfe,0xe8,0xf4,0xfe,0xe4,0x14,0x00},
    {0x54,0xfe,0xaa,0x38,0x7c,0x54,0x7c,0x00},
    {0xfe,0x2c,0x6c,0x5e,0xec,0x6c,0xde,0x00},
    {0x08,0xfc,0xfe,0xe8,0xfe,0xf4,0x0c,0x00},
    {0x08,0xfc,0xfe,0xf4,0xfe,0xe4,0x14,0x00},
    {0x38,0x38,0xee,0xfe,0xba,0x28,0xfe,0x00},
    {0x38,0x38,0xee,0xfe,0xaa,0x50,0xfe,0x00},
    {0x38,0xba,0x44,0xfe,0xba,0x28,0xfe,0x00},
    {0x08,0x7e,0xc0,0x7e,0xc8,0x48,0x98,0x00},
    {0x08,0x7e,0xcc,0x54,0xc4,0x48,0xb6,0x00},
    {0x08,0x7e,0xc0,0x48,0xea,0x6a,0xbe,0x00},
    {0x08,0x7e,0xc8,0x54,0xf6,0x54,0xa4,0x00},
    {0x08,0x7e,0xc8,0x7e,0xcc,0x4c,0xb6,0x00},
    {0x08,0x7e,0xd0,0x7e,0xda,0x5a,0xae,0x00},
    {0x08,0x7e,0xd4,0x7e,0xd4,0x54,0x9c,0x00},
    {0x08,0x7e,0xc8,0x7e,0xd0,0x4a,0xbe,0x00},
    {0x08,0x7e,0xd4,0x5e,0xf4,0x7c,0xb6,0x00},
    {0x08,0x7e,0xdc,0x54,0xdc,0x54,0xbe,0x00},
    {0x08,0x7e,0xdc,0x54,0xdc,0x40,0xbe,0x00},
    {0x08,0x7e,0xcc,0x54,0xcc,0x72,0x88,0x00},
    {0x08,0x7e,0xd0,0x5e,0xee,0x48,0x8e,0x00},
    {0x08,0x7e,0xfc,0x58,0xde,0x4a,0xb6,0x00},
    {0x08,0x7e,0xc8,0x54,0xfe,0x48,0xbe,0x00},
    {0x08,0x7e,0xd4,0x7e,0xc8,0x7e,0x88,0x00},
    {0x08,0x7e,0xca,0x54,0xfe,0x48,0xbe,0x00},
    {0x08,0x7e,0xdc,0x48,0xdc,0x72,0xae,0x00},
    {0x08,0x7e,0xde,0x4c,0xd6,0x6c,0x8c,0x00},
    {0x08,0x7e,0xf2,0x6e,0xfe,0x72,0xa6,0x00},
    {0x08,0x7e,0xdc,0x6a,0xfe,0x54,0xba,0x00},
    {0x08,0x7e,0xea,0x7e,0xea,0x76,0xbe,0x00},
    {0x08,0x7e,0xfe,0x54,0xea,0x7e,0x88,0x00},
    {0x08,0x7e,0xea,0x48,0xf6,0x48,0xb6,0x00},
    {0x08,0x7e,0xda,0x5e,0xcc,0x5e,0x84,0x00},
    {0x08,0x7e,0xd4,0x7e,0xfe,0x7e,0x94,0x00},
    {0x08,0x7e,0xd4,0x7e,0xd4,0x7e,0x94,0x00},
    {0x08,0x7e,0xe4,0x7c,0xfc,0x6c,0xda,0x00},
    {0x08,0x7e,0xd4,0x5c,0xfe,0x56,0xaa,0x00},
    {0x08,0x7e,0xc8,0x54,0xfa,0x5c,0x9a,0x00},
    {0x08,0x7e,0xd6,0x5a,0xde,0x5c,0xbe,0x00},
    {0x08,0x7e,0xcc,0x58,0xd6,0x5c,0xa6,0x00},
    {0x08,0x7e,0xf6,0x48,0xf6,0x5c,0x94,0x00},
    {0x08,0x7e,0xc8,0x54,0xfa,0x5c,0xac,0x00},
    {0x08,0x7e,0xd0,0x7e,0xfa,0x74,0xba,0x00},
    {0x08,0x7e,0xd6,0x66,0xfa,0x5c,0x9c,0x00},
    {0x08,0x7e,0xd4,0x7e,0xdc,0x7e,0x88,0x00},
    {0x08,0x7e,0xdc,0x5c,0xfe,0x48,0xaa,0x00},
    {0x08,0x7e,0xdc,0x7e,0xfe,0x54,0xba,0x00},
    {0x08,0x7e,0xf6,0x62,0xee,0x6e,0xb6,0x00},
    {0x08,0x7e,0xfa,0x5c,0xea,0x54,0xaa,0x00},
    {0x08,0x7e,0xea,0x54,0xfe,0x6e,0x94,0x00},
    {0x08,0x7e,0xf0,0x6e,0xfa,0x44,0xaa,0x00},
    {0x08,0x7e,0xd4,0x7e,0xdc,0x7e,0xae,0x00},
    {0x08,0x7e,0xe6,0x7a,0xfe,0x54,0xaa,0x00},
    {0x08,0x7e,0xd4,0x7e,0xdc,0x7a,0x94,0x00},
    {0x08,0x7e,0xdc,0x6a,0xdc,0x78,0x9e,0x00},
    {0x08,0x7e,0xf2,0x76,0xe6,0x70,0xaa,0x00},
    {0x08,0x7e,0xf4,0x5e,0xf6,0x70,0x9a,0x00},
    {0x08,0x7e,0xde,0x5a,0xd0,0x54,0xae,0x00},
    {0x08,0x7e,0xd0,0x7a,0xf4,0x4e,0xb4,0x00},
    {0x08,0x7e,0xd6,0x6c,0xd6,0x74,0xbe,0x00},
    {0x08,0x7e,0xe6,0x76,0xf6,0x40,0xaa,0x00},
    {0x00,0x74,0xaa,0x44,0x82,0x00,0x00,0x00},
    {0x74,0xaa,0x44,0xba,0x7c,0x10,0xee,0x00},
    {0x74,0xaa,0x44,0xae,0x4a,0x24,0x6a,0x00},
    {0x10,0x7c,0x44,0x7c,0x70,0x42,0x3e,0x00},
    {0x10,0x7c,0x44,0x7c,0x7c,0x2a,0xce,0x00},
    {0x5e,0xf0,0xbe,0xfa,0xba,0xf4,0x1a,0x00},
    {0x10,0x7c,0x44,0xfe,0x54,0xba,0x10,0x00},
    {0x48,0xfe,0xb4,0xe2,0xb4,0xc8,0x36,0x00},
    {0x44,0xfe,0xb2,0xec,0xbe,0xec,0x16,0x00},
    {0x4c,0xee,0xb4,0xfe,0xa0,0xee,0x0e,0x00},
    {0x2e,0xf8,0x6e,0xb4,0x10,0x7c,0x7c,0x00},
    {0x56,0xfe,0xa0,0xfe,0xaa,0xe4,0x1e,0x00},
    {0x48,0xee,0xd2,0xee,0xae,0xc8,0xae,0x00},
    {0x54,0xfe,0x5c,0x8e,0x3a,0x5c,0xaa,0x00},
    {0xf4,0xbe,0xfc,0x6e,0x6a,0xfc,0x2a,0x00},
    {0x5e,0xf6,0xde,0xec,0xac,0xde,0xa4,0x00},
    {0x44,0x7e,0xb6,0x5e,0x7a,0xb4,0x5a,0x00},
    {0x7c,0x10,0xfe,0x30,0x7c,0x54,0xfe,0x00},
    {0x10,0x7c,0xfe,0x24,0xfa,0x7c,0xfe,0x00},
    {0x24,0xfe,0x10,0xfe,0x7c,0x54,0xfe,0x00},
    {0x10,0x28,0xfe,0x38,0x7c,0x54,0xfe,0x00},
    {0x14,0xfc,0x32,0xcc,0x32,0x7c,0xfe,0x00},
    {0x10,0x7c,0x16,0x7c,0xaa,0x7c,0xfe,0x00},
    {0x56,0xba,0xd6,0xba,0xd6,0x7c,0xfe,0x00},
    {0x08,0x0e,0x78,0x4e,0x5c,0x5c,0xbe,0x00},
    {0x9c,0x14,0xbe,0x16,0xaa,0x7c,0xfe,0x00},
    {0x28,0xfe,0x94,0x1e,0xaa,0x7c,0xfe,0x00},
    {0xe4,0xaa,0xfe,0xa8,0xee,0xa2,0xe6,0x00},
    {0xe8,0xbe,0xfa,0xa8,0xec,0xac,0xf6,0x00},
    {0xe8,0xbc,0xfa,0xa8,0xea,0xa4,0xf8,0x00},
    {0xee,0xa4,0xf6,0xb6,0xfe,0xa2,0xe6,0x00},
    {0xe4,0xbe,0xe8,0xba,0xe4,0xaa,0xfe,0x00},
    {0xfe,0xb2,0xfe,0xb4,0xf6,0xb4,0xe6,0x00},
    {0x40,0x7c,0x38,0xb8,0xfe,0x00,0xc6,0x00},
    {0x24,0xb6,0xa4,0xf6,0x7c,0x7c,0x7c,0x00},
    {0xf4,0xb4,0xfe,0xb4,0xf4,0xbc,0xf6,0x00},
    {0xe8,0xbc,0xe8,0xbe,0xe8,0xbc,0xea,0x00},
    {0x54,0x92,0x28,0xfe,0x44,0xba,0x38,0x00},
    {0xe8,0xb2,0xfe,0xae,0xf4,0xbe,0xe4,0x00},
    {0xea,0xbe,0xe6,0xbe,0xf4,0xae,0xf6,0x00},
    {0xfe,0xb4,0xfe,0xb4,0xfe,0xb4,0xee,0x00},
    {0xe8,0xb6,0xfa,0xb2,0xfe,0xac,0xf6,0x00},
    {0xe4,0xbe,0xe6,0xbc,0xe6,0xac,0xf6,0x00},
    {0xe4,0xae,0xe4,0xbe,0xee,0xae,0xea,0x00},
    {0xe8,0xbe,0xfa,0xbe,0xec,0xbe,0xe4,0x00},
    {0x10,0x1c,0xfe,0xaa,0x7c,0xba,0x38,0x00},
    {0x10,0x7c,0x54,0xfe,0x28,0xfe,0x10,0x00},
    {0xe4,0xae,0xe4,0xbe,0xe8,0xb6,0xe6,0x00},
    {0xe4,0xbe,0xf6,0xae,0xe4,0xbe,0xee,0x00},
    {0xe8,0xae,0xec,0xbc,0xfe,0xa0,0xf2,0x00},
    {0xfe,0xb2,0xec,0xac,0xfe,0xa0,0xf2,0x00},
    {0xea,0xbc,0xf6,0xbc,0xfe,0xa8,0xfe,0x00},
    {0xea,0xbe,0xea,0xbe,0xfe,0xbe,0xf6,0x00},
    {0xfc,0xb6,0xfe,0xae,0xee,0xbc,0xea,0x00},
    {0xe4,0xbe,0xf6,0xbe,0xec,0xac,0xf2,0x00},
    {0xfe,0xb4,0xfe,0xb2,0xec,0xb4,0xea,0x00},
    {0x6c,0x6c,0x28,0x3e,0x7c,0xa8,0x3e,0x00},
    {0xe8,0xb4,0xfe,0xaa,0xfe,0xb4,0xea,0x00},
    {0x44,0xee,0x4a,0xa4,0xca,0x7c,0x7c,0x00},
    {0xec,0xb4,0xfe,0xba,0xf4,0xbe,0xec,0x00},
    {0xf4,0xbe,0xf4,0xbe,0xfa,0xac,0xfa,0x00},
    {0x6c,0x6c,0x78,0xbe,0x28,0x10,0xee,0x00},
    {0x10,0x7c,0x18,0x58,0xfe,0xcc,0xee,0x00},
    {0xfe,0xbe,0xea,0xbc,0xfe,0xae,0xfa,0x00},
    {0xe8,0x34,0x4e,0xe0,0x7e,0xa4,0x68,0x00},
    {0x10,0x24,0xfa,0x20,0x7c,0x10,0xee,0x00},
    {0x9c,0xfe,0x5c,0xea,0x7e,0x54,0xba,0x00},
    {0xe0,0x5c,0x48,0x88,0x68,0x68,0x3e,0x00},
    {0xe6,0x56,0x5e,0x96,0x7e,0x66,0x0a,0x00},
    {0xf4,0x54,0x5e,0x94,0x74,0x7c,0x16,0x00},
    {0xe4,0x5e,0x56,0x9e,0x76,0x70,0x2a,0x00},
    {0xee,0x4a,0x4e,0x8a,0x6e,0x6a,0x1e,0x00},
    {0xfe,0x54,0x5e,0x9e,0x74,0x7e,0x2a,0x00},
    {0xe4,0x4e,0x44,0x9e,0x6e,0x64,0x1e,0x00},
    {0xc8,0x7e,0x54,0x94,0x6a,0x7e,0x08,0x00},
    {0xd4,0x7e,0x44,0x94,0x76,0x74,0x16,0x00},
    {0x84,0x1e,0x94,0x2a,0xfe,0x64,0xbc,0x00},
    {0xfe,0x6a,0x7e,0xaa,0x7e,0x6a,0x56,0x00},
    {0xe4,0x5e,0x4a,0x9e,0x60,0x6e,0x0e,0x00},
    {0xce,0x54,0x7e,0x88,0x6a,0x7c,0x2a,0x00},
    {0xfc,0x54,0x5c,0x9e,0x72,0x7a,0x06,0x00},
    {0xe4,0x46,0x4c,0x8c,0x6c,0x6c,0x12,0x00},
    {0xd4,0x7e,0x54,0x94,0x7e,0x68,0x3e,0x00},
    {0xea,0x54,0x4a,0x9e,0x76,0x7a,0x1e,0x00},
    {0xf6,0x5e,0x40,0x9e,0x6a,0x64,0x1e,0x00},
    {0xee,0x4a,0x5e,0x92,0x6e,0x6e,0x0a,0x00},
    {0xea,0x5e,0x44,0x9e,0x6e,0x74,0x0e,0x00},
    {0xea,0x56,0x4e,0x92,0x7e,0x5c,0x2a,0x00},
    {0xfe,0x62,0x7e,0xac,0x7e,0x74,0x1a,0x00},
    {0xfe,0x54,0x5e,0x94,0x7e,0x62,0x16,0x00},
    {0xc8,0x7e,0x54,0xbe,0x6a,0x6c,0x14,0x00},
    {0x7e,0x3c,0x54,0x1c,0xfe,0x6e,0xb6,0x00},
    {0x2e,0xfa,0x64,0x8a,0xfe,0x64,0xbc,0x00},
    {0xe4,0x5e,0x44,0x9e,0x6c,0x6c,0x12,0x00},
    {0xe4,0x5e,0x4c,0x8e,0x7e,0x6a,0x06,0x00},
    {0xe8,0x5c,0x7e,0xb6,0x7e,0x6c,0x16,0x00},
    {0xfa,0x54,0x62,0x9c,0x74,0x68,0x1e,0x00},
    {0xe8,0x5e,0x5e,0x9a,0x7e,0x68,0x16,0x00},
    {0xea,0x5e,0x44,0x9e,0x6a,0x7c,0x0a,0x00},
    {0xea,0x5c,0x76,0x9c,0x7e,0x6a,0x3e,0x00},
    {0xe6,0x7a,0x66,0x9c,0x7e,0x54,0x2a,0x00},
    {0x54,0xee,0x54,0xee,0x7c,0xba,0x58,0x00},
    {0xda,0x6c,0x5a,0xac,0x7e,0x5c,0x2a,0x00},
    {0xfe,0x12,0xf2,0x5e,0xf0,0xf2,0x5e,0x00},
    {0xee,0x02,0xee,0x42,0xee,0xee,0x42,0x00},
    {0xe2,0x1c,0xf4,0x5e,0xf4,0xf2,0x5e,0x00},
    {0x54,0x7c,0x92,0xfe,0x7c,0x54,0xb2,0x00},
    {0xe8,0x0e,0xf8,0x4e,0xe8,0xee,0x48,0x00},
    {0xd0,0x0a,0xd2,0x74,0xfa,0xd0,0x6e,0x00},
    {0xea,0x1e,0xe8,0x4a,0xea,0xd4,0x6a,0x00},
    {0xd4,0x3e,0xd4,0x5c,0xfe,0xc0,0x62,0x00},
    {0xce,0x14,0xfe,0x48,0xea,0xdc,0x6a,0x00},
    {0xd6,0x3e,0xfa,0x50,0xfe,0xc8,0x76,0x00},
    {0xdc,0x1c,0xe6,0x4c,0xf4,0xc8,0x76,0x00},
    {0xc8,0x3e,0xdc,0x54,0xfe,0xd4,0x5c,0x00},
    {0x10,0xfe,0x6c,0xba,0x44,0x7c,0x94,0x00},
    {0xf6,0x36,0xdc,0x5c,0xdc,0xfe,0x48,0x00},
    {0xd4,0x3e,0xfe,0x62,0xfe,0xd4,0x7e,0x00},
    {0xc8,0x3e,0xf6,0x5c,0xfe,0xf4,0x5a,0x00},
    {0x0c,0xf0,0x7c,0x54,0xfe,0x9a,0xb6,0x00},
    {0x7c,0x54,0x7c,0x54,0xfe,0x9a,0xb6,0x00},
    {0x38,0xfe,0x7c,0x1e,0x7c,0x38,0xd6,0x00},
    {0xf4,0x54,0xfe,0x54,0xf4,0xdc,0x56,0x00},
    {0xc8,0x5c,0xd4,0x7e,0xc8,0xc8,0x76,0x00},
    {0xfe,0x50,0xfe,0x52,0xfe,0xd0,0x5e,0x00},
    {0xea,0x5e,0xe8,0x4a,0xea,0xd4,0x6a,0x00},
    {0xc8,0x7e,0xc8,0x5c,0xc8,0xdc,0x6a,0x00},
    {0xdc,0x54,0xdc,0x7e,0xc8,0xfe,0x48,0x00},
    {0xd4,0x6a,0xd4,0x5c,0xd4,0xdc,0x54,0x00},
    {0xd4,0x7e,0xd4,0x5c,0xfe,0xc0,0x62,0x00},
    {0xc8,0x7e,0xc8,0x6c,0xec,0xe0,0x7e,0x00},
    {0xfe,0x6a,0xfe,0x6a,0xf6,0xfe,0x62,0x00},
    {0x10,0xfe,0x6c,0x7c,0xfe,0x38,0xd6,0x00},
    {0x10,0xfe,0x6c,0x7c,0xfe,0x54,0xb2,0x00},
    {0xdc,0x6a,0xc8,0x5c,0xdc,0xfe,0x54,0x00},
    {0xdc,0x6a,0xc0,0x56,0xe2,0xf6,0x7e,0x00},
    {0x10,0xfe,0x38,0xee,0xba,0x38,0xd6,0x00},
    {0xdc,0x5c,0xe6,0x4c,0xf4,0xc8,0x76,0x00},
    {0xc8,0x7e,0xf6,0x48,0xd4,0xee,0x4c,0x00},
    {0xc8,0x7e,0xdc,0x5a,0xc0,0xf2,0x6e,0x00},
    {0xfe,0x7e,0xe4,0x76,0xec,0xfe,0x44,0x00},
    {0xc8,0x7e,0xd4,0x6a,0xfe,0xf6,0x7e,0x00},
    {0xc4,0x56,0xd4,0x7e,0xd6,0xd4,0x6a,0x00},
    {0xdc,0x6a,0xdc,0x4e,0xdc,0xf2,0x6e,0x00},
    {0xcc,0x74,0xde,0x76,0xd6,0xf4,0x5e,0x00},
    {0xc8,0x7e,0xf6,0x5c,0xfe,0xf4,0x5a,0x00},
    {0x10,0xfe,0xaa,0x4c,0x7c,0x7e,0x02,0x00},
    {0x10,0xfe,0xaa,0x4c,0x7e,0xfe,0x24,0x00},
    {0x10,0xfe,0xaa,0x44,0x2e,0x46,0xea,0x00},
    {0x10,0xfe,0xb6,0x7c,0x5c,0x6c,0x7c,0x00},
    {0x10,0xfe,0xb6,0x6c,0xea,0x28,0xce,0x00},
    {0x10,0xfe,0xb6,0x18,0xfe,0x34,0xdc,0x00},
    {0x10,0xfe,0xb6,0x3c,0x50,0xfe,0x38,0x00},
    {0x10,0xfe,0xb6,0x7c,0x4c,0xfe,0xba,0x00},
    {0x10,0xfe,0xaa,0x5c,0x6c,0x6c,0x3e,0x00},
    {0x10,0xfe,0xb6,0x68,0x3c,0xea,0x3e,0x00},
    {0x10,0xfe,0xba,0x6c,0xfe,0x28,0xf6,0x00},
    {0x10,0xfe,0xb6,0x66,0xea,0x64,0xaa,0x00},
    {0x10,0xfe,0xae,0x44,0x7c,0x54,0xda,0x00},
    {0x10,0xfe,0xb6,0xcc,0xf6,0xc8,0xbe,0x00},
    {0x88,0x3e,0xb6,0x08,0xd6,0x6c,0xbe,0x00},
    {0x10,0xfe,0xb6,0x7c,0x7c,0x3c,0xc6,0x00},
    {0x10,0xfe,0xb6,0x64,0xee,0x7e,0xaa,0x00},
    {0x48,0xe8,0xbe,0xa8,0x48,0xe8,0x08,0x00},
    {0x44,0xf8,0xa8,0xbe,0x48,0xe8,0x08,0x00},
    {0x54,0xf4,0xa2,0xbc,0x54,0xd4,0x2c,0x00},
    {0x46,0xf8,0xae,0xb8,0x4e,0xf8,0x0e,0x00},
    {0x48,0xe8,0xae,0xa8,0x5e,0xf2,0x1e,0x00},
    {0x44,0xfe,0xb2,0xae,0x44,0xe4,0x0c,0x00},
    {0x44,0xfe,0xaa,0xaa,0x4a,0xec,0x1e,0x00},
    {0x5e,0xe8,0xbe,0xb2,0x5e,0xf2,0x1e,0x00},
    {0x48,0xf2,0xbe,0xa8,0x5e,0xe4,0x1a,0x00},
    {0x48,0xfe,0xba,0xbe,0x48,0xdc,0x2a,0x00},
    {0x5c,0xf4,0xbc,0xae,0x72,0xda,0x06,0x00},
    {0x5e,0xf0,0xbe,0xbe,0x5e,0xd4,0x2e,0x00},
    {0x48,0x6e,0xb4,0x20,0x7c,0x24,0xd6,0x00},
    {0x48,0x6e,0xb4,0x7e,0x6a,0xaa,0x56,0x00},
    {0x48,0x6e,0xbc,0x70,0x54,0x54,0x92,0x00},
    {0x48,0x6e,0xfc,0x54,0x7c,0x42,0x3e,0x00},
    {0x48,0x6e,0xb4,0x40,0xfe,0x5a,0xbe,0x00},
    {0x48,0x6e,0xb4,0x1c,0x10,0x7c,0x7c,0x00},
    {0x48,0x6e,0xb4,0x7e,0xbc,0x10,0xfe,0x00},
    {0x48,0x6e,0xb4,0x20,0xfe,0x44,0x7c,0x00},
    {0x48,0x6e,0xb4,0x3c,0xa4,0x22,0x9e,0x00},
    {0x48,0x6e,0xb4,0xfe,0x54,0xba,0x10,0x00},
    {0x48,0x6e,0xb4,0x20,0x7c,0x10,0xee,0x00},
    {0x48,0x6e,0xb4,0x7e,0x5c,0x48,0x7e,0x00},
    {0x48,0x6e,0xb4,0x7e,0x5c,0x4a,0x7e,0x00},
    {0x48,0x6e,0xb4,0x7c,0x28,0xfe,0x48,0x00},
    {0x48,0x6e,0xbe,0x6a,0xba,0x2a,0x3a,0x00},
    {0x48,0x6e,0xbc,0x16,0xfc,0x20,0xc0,0x00},
    {0x48,0x6e,0xf4,0x28,0xfe,0x10,0xfe,0x00},
    {0x48,0x6e,0xbc,0x50,0xfe,0x28,0xce,0x00},
    {0x48,0x6e,0xb4,0x46,0x94,0x5e,0xbe,0x00},
    {0x48,0x6e,0xbc,0x38,0x10,0x7c,0x7c,0x00},
    {0x48,0x6e,0xbc,0x54,0xba,0x10,0xee,0x00},
    {0x48,0x6e,0xb4,0x38,0x38,0x3a,0xce,0x00},
    {0x48,0x6e,0xb4,0x4e,0xd8,0x4e,0x48,0x00},
    {0x48,0x6e,0xb4,0x66,0xea,0x64,0x4a,0x00},
    {0x48,0x6e,0xbe,0x44,0x76,0x54,0xaa,0x00},
    {0x48,0x6e,0xbc,0x54,0xba,0x10,0xfe,0x00},
    {0x48,0x6e,0xb4,0x54,0xfe,0x54,0xdc,0x00},
    {0x48,0x6e,0xb4,0xfe,0xba,0xd6,0xfe,0x00},
    {0x48,0x6e,0xbc,0x3c,0x6e,0x48,0xee,0x00},
    {0x48,0x6e,0xbc,0x5e,0xde,0x54,0xde,0x00},
    {0x48,0x6e,0xfe,0xaa,0x4c,0x38,0xfe,0x00},
    {0x48,0x6e,0xb4,0x2a,0x5a,0xb2,0x36,0x00},
    {0x48,0x6e,0xb4,0x1a,0xfc,0x1a,0x66,0x00},
    {0x48,0x6e,0xbc,0xfe,0x92,0x7c,0x54,0x00},
    {0x48,0x6e,0xb8,0x54,0xfe,0x1c,0x30,0x00},
    {0x48,0x6e,0xbc,0x48,0xfe,0x1c,0x30,0x00},
    {0x48,0x6e,0xb4,0x6e,0x6a,0x6c,0xaa,0x00},
    {0x48,0x6e,0xb4,0x7e,0x68,0x54,0x7e,0x00},
    {0x48,0x6e,0xb8,0x28,0x7c,0x10,0xfe,0x00},
    {0x48,0x6e,0xbc,0x44,0xde,0x48,0x56,0x00},
    {0x48,0x6e,0xb4,0x58,0xfe,0x54,0x7a,0x00},
    {0x48,0x6e,0xb4,0x7e,0x46,0x74,0xba,0x00},
    {0x48,0x6e,0xbc,0x28,0xfe,0x2c,0xda,0x00},
    {0x48,0x6e,0xb4,0xfe,0x7c,0xfe,0x44,0x00},
    {0x48,0x6e,0xbe,0x64,0x5e,0x76,0x64,0x00},
    {0x48,0x6e,0xb8,0xee,0x38,0xe8,0x36,0x00},
    {0x48,0x6e,0xb8,0xfe,0x38,0xe8,0x36,0x00},
    {0x48,0x6e,0xd4,0x6c,0x7e,0x48,0xee,0x00},
    {0x48,0x6e,0xfe,0x54,0xfe,0x38,0xd6,0x00},
    {0x48,0x6e,0xf4,0x56,0xfa,0x74,0x56,0x00},
    {0x48,0x6e,0xb8,0xfe,0x7c,0x7c,0xc6,0x00},
    {0x48,0x6e,0xb4,0xe8,0x4e,0x64,0xaa,0x00},
    {0x48,0x6e,0xb4,0x72,0x54,0x72,0xb4,0x00},
    {0x48,0x6e,0xb8,0x38,0xfe,0x7c,0x10,0x00},
    {0x48,0x6e,0xb4,0x0c,0xde,0x44,0xbe,0x00},
    {0x48,0x6e,0xb6,0x4a,0xfe,0x38,0xd6,0x00},
    {0x48,0x6e,0xb8,0x7c,0xfe,0x28,0xf6,0x00},
    {0x48,0x7e,0x9c,0x50,0xfe,0x02,0xaa,0x00},
    {0x48,0x6e,0xfc,0x54,0xfe,0x7c,0xc6,0x00},
    {0x48,0x6e,0xb4,0xfe,0x54,0x7c,0xc6,0x00},
    {0x48,0x6e,0xbc,0x6c,0xb6,0x7c,0x7c,0x00},
    {0x48,0x6e,0xfc,0x7c,0x28,0xfe,0x10,0x00},
    {0x48,0x6e,0xfc,0x66,0x5c,0x7e,0x9c,0x00},
    {0x48,0x6e,0xbc,0x6e,0x42,0x6e,0xaa,0x00},
    {0x48,0x6e,0xb8,0xc6,0x6c,0x6c,0x92,0x00},
    {0x48,0x6e,0xfc,0x38,0xfe,0x64,0x6c,0x00},
    {0x48,0x6e,0xb4,0x6e,0x60,0x38,0xfe,0x00},
    {0x48,0x6e,0xb4,0x76,0xfa,0x54,0xea,0x00},
    {0x48,0x6e,0xbc,0xec,0x5e,0x6c,0xb2,0x00},
    {0x48,0x6e,0xb8,0x56,0xda,0x4c,0xcc,0x00},
    {0x48,0x6e,0xb4,0xec,0xba,0xfc,0xaa,0x00},
    {0x48,0x6e,0xb4,0xfe,0xae,0xfc,0xaa,0x00},
    {0x48,0x6e,0xf4,0x7e,0x2e,0x70,0xaa,0x00},
    {0x48,0x6e,0xb4,0x58,0xfe,0x74,0xea,0x00},
    {0x48,0x6e,0xb4,0x68,0xfe,0x74,0xea,0x00},
    {0x48,0x6e,0xb4,0x28,0xfe,0x7c,0x54,0x00},
    {0x48,0x6e,0xfc,0x5c,0xee,0xbc,0xee,0x00},
    {0xa8,0x48,0xfe,0x48,0xe8,0xc8,0x48,0x00},
    {0xb4,0x54,0xfe,0x54,0xf4,0xdc,0x56,0x00},
    {0xae,0x40,0xee,0x4a,0xee,0xc8,0x50,0x00},
    {0x10,0x7c,0x5c,0x74,0xfe,0x3c,0x04,0x00},
    {0xa8,0x54,0xee,0x40,0xdc,0xd4,0x5c,0x00},
    {0x90,0x1e,0x2a,0x94,0xfe,0x38,0xd6,0x00},
    {0xbe,0x50,0xfe,0x6a,0xea,0xea,0x6a,0x00},
    {0xbe,0x52,0xfe,0x52,0xfe,0xde,0x52,0x00},
    {0xbe,0x48,0xfe,0x52,0xfe,0xd2,0x5e,0x00},
    {0xbe,0x5c,0xdc,0x48,0xd8,0xc8,0x76,0x00},
    {0x2e,0x3a,0xd4,0x6a,0xfe,0x38,0xd6,0x00},
    {0xbc,0x14,0x96,0x2c,0xfe,0x38,0xd6,0x00},
    {0xa4,0x5e,0xf2,0x5e,0xfe,0xd4,0x5a,0x00},
    {0x88,0x7e,0xd4,0x54,0xea,0xfe,0x48,0x00},
    {0x88,0x7e,0xe2,0x5c,0xfe,0xc8,0x6a,0x00},
    {0x94,0x7e,0xc4,0x54,0xf6,0xd4,0x56,0x00},
    {0x9c,0x7e,0xda,0x68,0xfe,0xdc,0x6a,0x00},
    {0x94,0x7e,0xd4,0x54,0xfe,0xe8,0x7e,0x00},
    {0x88,0x7e,0xe2,0x5c,0xda,0xec,0x5a,0x00},
    {0x94,0x7e,0xd4,0x7e,0xe0,0xee,0x4a,0x00},
    {0x08,0x7e,0x7e,0x54,0x7e,0x5c,0xaa,0x00},
    {0x94,0x7e,0xdc,0x54,0xfe,0xc8,0x76,0x00},
    {0xd6,0x7a,0xd6,0xfe,0x44,0xfe,0x92,0x00},
    {0x9c,0x7e,0xea,0x5c,0xc8,0xfe,0x6a,0x00},
    {0xbe,0x54,0xfe,0x5e,0xf4,0xde,0x6a,0x00},
    {0x5e,0x4a,0xa0,0x4a,0xee,0xdc,0x4e,0x00},
    {0xbe,0xea,0xe0,0x4a,0xee,0xdc,0x4e,0x00},
    {0x48,0x88,0x48,0xa8,0x48,0xea,0x4e,0x00},
    {0x5c,0x88,0x48,0xbe,0x48,0xc8,0x58,0x00},
    {0x44,0xbe,0x44,0x94,0x4c,0xe4,0x4c,0x00},
    {0x5c,0x80,0x7e,0x88,0x48,0xd4,0x7a,0x00},
    {0x54,0x94,0x5e,0xb4,0x54,0xfc,0x56,0x00},
    {0x10,0xfe,0x28,0x10,0xee,0x38,0x92,0x00},
    {0x7e,0xa2,0x7e,0xb6,0x7e,0xe2,0x66,0x00},
    {0x44,0x9e,0x50,0xb4,0x54,0xda,0x6e,0x00},
    {0x28,0xf8,0x7a,0xae,0x7c,0x10,0x92,0x00},
    {0x6a,0xaa,0x7e,0xaa,0x6e,0xe0,0x7e,0x00},
    {0x48,0x88,0x54,0xba,0x40,0xdc,0x5c,0x00},
    {0x44,0x9e,0x52,0xae,0x44,0xe4,0x4c,0x00},
    {0x54,0xa2,0x48,0xbe,0x48,0xfe,0x48,0x00},
    {0x4c,0x94,0x48,0xb6,0x4c,0xfe,0x44,0x00},
    {0x48,0xaa,0x5c,0xbe,0x54,0xd4,0x66,0x00},
    {0x56,0xa0,0x56,0xb2,0x52,0xd2,0x56,0x00},
    {0x44,0x88,0x44,0xaa,0x44,0xee,0x44,0x00},
    {0x44,0xbe,0x54,0xbc,0x56,0xd4,0x4a,0x00},
    {0x2e,0xfa,0x5a,0xee,0x7c,0x10,0x92,0x00},
    {0x48,0xbc,0x6c,0xbc,0x4a,0xe4,0x5a,0x00},
    {0x54,0x80,0x7e,0x94,0x7e,0xd4,0x64,0x00},
    {0x5e,0x8a,0x54,0xaa,0x5e,0xe4,0x5e,0x00},
    {0x5c,0xbe,0x5c,0xaa,0x7c,0xd6,0x62,0x00},
    {0x2c,0x74,0xe8,0x74,0x7e,0x48,0x6a,0x00},
    {0x5c,0xaa,0x40,0x88,0x7e,0xd4,0x7a,0x00},
    {0x5e,0x92,0x5e,0xa8,0x5e,0xf2,0x5e,0x00},
    {0x7e,0x96,0x4a,0xb6,0x40,0xf2,0x6e,0x00},
    {0x48,0xbe,0x48,0x94,0x7e,0xc4,0x54,0x00},
    {0xf6,0x5a,0x74,0x8a,0x7c,0x10,0x92,0x00},
    {0x54,0xaa,0x7e,0x94,0x6a,0xd0,0x5c,0x00},
    {0x5c,0xaa,0x40,0x88,0x7e,0xdc,0x6a,0x00},
    {0x4a,0x94,0x4a,0xbe,0x5e,0xf6,0x5e,0x00},
    {0x48,0x8e,0x5c,0xb4,0x5c,0xfe,0x48,0x00},
    {0x4a,0x9e,0x44,0xaa,0x5e,0xe4,0x5a,0x00},
    {0x48,0x9e,0x5e,0xbe,0x40,0xf2,0x6e,0x00},
    {0x7e,0xaa,0x7e,0xaa,0x76,0xfe,0x62,0x00},
    {0x50,0x9e,0x6a,0x9e,0x4a,0xee,0x7e,0x00},
    {0x2e,0x74,0x58,0x74,0xfe,0xa4,0xb6,0x00},
    {0x48,0x94,0x6e,0x80,0x5e,0xfe,0x56,0x00},
    {0x7e,0x92,0x5e,0xb4,0x5e,0xe4,0x5a,0x00},
    {0x48,0xbe,0x62,0x9c,0x5e,0xf2,0x5e,0x00},
    {0x44,0xbe,0x64,0xbc,0x66,0xfc,0x5a,0x00},
    {0x5c,0x94,0x7e,0x9c,0x54,0xfe,0x44,0x00},
    {0x6a,0xbe,0x6e,0xa0,0x7e,0xdc,0x6a,0x00},
    {0x5e,0xaa,0x70,0xae,0x7a,0xe4,0x6a,0x00},
    {0x7c,0x96,0x66,0xbe,0x56,0xfc,0x4a,0x00},
    {0x7a,0xae,0x7e,0xaa,0x78,0xea,0x7c,0x00},
    {0x5e,0x92,0x5e,0xb4,0x5a,0xee,0x4e,0x00},
    {0x44,0xbe,0x7c,0xb4,0x6e,0xf4,0x6a,0x00},
    {0x54,0xa2,0x5c,0x94,0x62,0xdc,0x7e,0x00},
    {0x6e,0xe4,0xe8,0x84,0xfe,0x24,0xb6,0x00},
    {0x48,0xbe,0x6a,0xbe,0x54,0xfe,0x48,0x00},
    {0x54,0xbe,0x48,0xbe,0x5e,0xd4,0x6e,0x00},
    {0x54,0xaa,0x50,0xb4,0x56,0xdc,0x56,0x00},
    {0x5e,0x9c,0x5a,0xac,0x7e,0xd4,0x4c,0x00},
    {0x7e,0xa4,0x76,0xbe,0x5c,0xd4,0x5c,0x00},
    {0x52,0x86,0x56,0xa4,0x56,0xf6,0x5e,0x00},
    {0xf4,0xaa,0xfe,0xb4,0xfa,0xa8,0xaa,0x00},
    {0x76,0x92,0x48,0x94,0x6a,0xc4,0x58,0x00},
    {0x7e,0x9a,0x74,0xae,0x7e,0xd4,0x7e,0x00},
    {0x08,0x7e,0x7e,0x54,0x7a,0x48,0xaa,0x00},
    {0x5c,0x94,0x7e,0xbe,0x54,0xc8,0x76,0x00},
    {0x7e,0x9c,0x5c,0x80,0x7e,0xc8,0x6a,0x00},
    {0x6a,0xbe,0x40,0xb6,0x76,0xf6,0x5a,0x00},
    {0x48,0x9c,0x76,0x9c,0x7e,0xd4,0x7a,0x00},
    {0x7e,0xaa,0x7e,0x90,0x7e,0xc8,0x6a,0x00},
    {0x54,0x8e,0x5c,0xac,0x5e,0xf4,0x5e,0x00},
    {0x5c,0xbe,0x6a,0x80,0x7e,0xd4,0x7a,0x00},
    {0x76,0xb6,0x62,0xae,0x6e,0xf6,0x62,0x00},
    {0x54,0xbe,0x5a,0xba,0x5a,0xdc,0x5a,0x00},
    {0x48,0x9c,0x7e,0xb6,0x7e,0xd4,0x66,0x00},
    {0x7e,0x94,0x7e,0x9c,0x6a,0xdc,0x5c,0x00},
    {0x48,0xbe,0x54,0xbe,0x54,0xc8,0x6a,0x00},
    {0x7e,0xbe,0x48,0xbe,0x54,0xfe,0x48,0x00},
    {0x48,0x94,0x7e,0xaa,0x7e,0xd4,0x5c,0x00},
    {0x7e,0xb6,0x54,0xb6,0x76,0xd4,0x5e,0x00},
    {0x6a,0xb4,0x6a,0xbe,0x6a,0xf4,0x7e,0x00},
    {0x5c,0xbe,0x6a,0x9c,0x48,0xfe,0x6a,0x00},
    {0x48,0xbe,0x54,0xaa,0x54,0xdc,0x64,0x00},
    {0x48,0xbe,0x54,0x88,0x76,0xdc,0x64,0x00},
    {0x48,0xbe,0x6a,0xb4,0x5c,0xdc,0x62,0x00},
    {0x54,0xee,0xba,0x6c,0xd6,0x7c,0x94,0x00},
    {0x74,0xa6,0x60,0xb6,0x40,0xdc,0x7e,0x00},
    {0x56,0xbc,0x56,0xbe,0x46,0xf8,0x5a,0x00},
    {0x54,0xbe,0x54,0xaa,0x5c,0xdc,0x62,0x00},
    {0x48,0xbe,0x76,0xbe,0x5c,0xdc,0x62,0x00},
    {0x7e,0xac,0x7e,0xa0,0x6a,0xe4,0x5e,0x00},
    {0x56,0xbc,0x6e,0x86,0x6e,0xd0,0x6a,0x00},
    {0x76,0xb6,0x6a,0x90,0x7e,0xd4,0x7a,0x00},
    {0x4c,0x96,0x4e,0xac,0x56,0xec,0x56,0x00},
    {0x6e,0x94,0x7e,0x94,0x7e,0xd4,0x7a,0x00},
    {0x56,0x94,0x7e,0x94,0x7e,0xd4,0x7a,0x00},
    {0x10,0x7c,0xfe,0x7c,0xea,0xee,0x54,0x00},
    {0x74,0xa6,0x76,0x9c,0x5c,0xdc,0x66,0x00},
    {0x40,0x7e,0xa4,0xf4,0x24,0xb4,0xfe,0x00},
    {0x44,0x7e,0xa6,0xfe,0x24,0xb4,0xfa,0x00},
    {0x84,0xe6,0x5c,0xf6,0x5e,0xf4,0xec,0x00},
    {0x6c,0x6c,0x92,0x3c,0xfe,0x54,0x7c,0x00},
    {0x38,0x38,0xee,0xfe,0xfe,0x54,0x7c,0x00},
    {0x8c,0xec,0x5e,0xf6,0x4c,0xd4,0xfa,0x00},
    {0x94,0xfe,0x76,0xd4,0x5e,0xf4,0xde,0x00},
    {0xfe,0xaa,0xea,0xba,0xaa,0xd6,0x82,0x00},
    {0xfe,0xaa,0x4c,0x38,0x10,0xfe,0x10,0x00},
    {0xfe,0xaa,0xfe,0x92,0xfe,0xa2,0xba,0x00},
    {0xfe,0xaa,0xfe,0x00,0xfe,0x34,0xd2,0x00},
    {0xfe,0xaa,0xfe,0x10,0xfe,0x44,0x7c,0x00},
    {0xfe,0xaa,0xfe,0x44,0x7e,0x48,0xe6,0x00},
    {0xfe,0xaa,0xfe,0x54,0xba,0x38,0x0e,0x00},
    {0xfe,0xaa,0xfe,0x7c,0x48,0xfe,0x10,0x00},
    {0xfe,0xaa,0xfe,0x24,0xfe,0x6c,0xb6,0x00},
    {0xfe,0xaa,0xfe,0xc4,0x3e,0xd4,0xcc,0x00},
    {0xfe,0xaa,0xfe,0x9e,0x52,0xfe,0x52,0x00},
    {0xfe,0xaa,0xfe,0x74,0x56,0x00,0xaa,0x00},
    {0xfe,0xaa,0xfe,0x38,0xfe,0x7e,0xb4,0x00},
    {0xfe,0xaa,0xfe,0xac,0x4e,0xe2,0x56,0x00},
    {0xfe,0xaa,0xfe,0xac,0x5e,0xe4,0x54,0x00},
    {0x24,0xfe,0x7c,0x10,0xfe,0x28,0xce,0x00},
    {0x24,0xfe,0x7c,0x10,0xfe,0x00,0xaa,0x00},
    {0x24,0xfe,0x10,0xfe,0x7c,0x54,0xbe,0x00},
    {0xa2,0x5c,0xf4,0x5e,0xf4,0x52,0x9e,0x00},
    {0xa8,0x54,0xee,0x40,0xfe,0x4a,0x88,0x00},
    {0x3c,0xfe,0x34,0xdc,0x38,0xfe,0x10,0x00},
    {0xbc,0x54,0xfc,0x5e,0xf2,0x5a,0x86,0x00},
    {0x24,0xfe,0x10,0xfe,0x6a,0x3c,0x6a,0x00},
    {0x24,0xfe,0x7c,0xaa,0x7c,0x38,0xee,0x00},
    {0x24,0xfe,0x7c,0xaa,0x7c,0x10,0xee,0x00},
    {0xa4,0x5e,0xfa,0x5e,0xec,0x4c,0x9e,0x00},
    {0x10,0xfe,0x40,0x7c,0x6e,0x7e,0xb6,0x00},
    {0x24,0xfe,0x7c,0xd6,0x10,0xd6,0xd6,0x00},
    {0x5e,0xea,0x5e,0xea,0xbe,0x4a,0xbe,0x00},
    {0xee,0x22,0x7c,0x14,0x66,0xfe,0x10,0x00},
    {0x5e,0xea,0xbe,0xaa,0x5e,0xea,0x0a,0x00},
    {0x10,0x28,0xfe,0x38,0xee,0x66,0xaa,0x00},
    {0xbe,0x4a,0xde,0x6a,0xde,0x6a,0x8a,0x00},
    {0x28,0xee,0x28,0xfe,0x5a,0xb6,0x5a,0x00},
    {0x24,0xfe,0x74,0x54,0xee,0x66,0xaa,0x00},
    {0xde,0x0a,0xde,0x8a,0xfe,0xea,0xaa,0x00},
    {0xfe,0xca,0xf4,0xaa,0xfe,0x66,0xaa,0x00},
    {0x5e,0xea,0xfe,0xaa,0xfe,0x6a,0xbe,0x00},
    {0xfc,0x6c,0xfa,0x6c,0xbe,0x7c,0x6a,0x00},
    {0x14,0x78,0xfe,0x50,0x9e,0x3c,0x3c,0x00},
    {0x14,0x78,0x30,0xde,0x3c,0xf0,0x1e,0x00},
    {0x14,0x78,0x30,0xde,0x7c,0x10,0xfe,0x00},
    {0x14,0xf8,0x7c,0x10,0xfe,0x38,0xd6,0x00},
    {0x6e,0xc0,0x5e,0xe4,0x44,0xea,0x5e,0x00},
    {0x7e,0xd6,0x56,0xfe,0x50,0xf2,0x5e,0x00},
    {0x7c,0xd4,0x5c,0xf0,0x5e,0xf2,0x5e,0x00},
    {0x64,0xfc,0x6e,0xfe,0x6e,0xfa,0x4a,0x00},
    {0x5e,0xdc,0x5a,0xec,0x7e,0xd4,0x4c,0x00},
    {0xf4,0x54,0x7e,0x7c,0x54,0xf4,0x1a,0x00},
    {0xe4,0x64,0x76,0x74,0x74,0xf4,0x3e,0x00},
    {0xe8,0x76,0x76,0x76,0x7e,0xec,0x34,0x00},
    {0xe8,0x74,0x6e,0x60,0x7e,0xea,0x28,0x00},
    {0xe2,0x6c,0x7e,0x64,0x6e,0xea,0x2e,0x00},
    {0xe4,0x6e,0x6e,0x7e,0x68,0xee,0x22,0x00},
    {0xfe,0x6a,0xf4,0x2a,0x54,0x38,0xd6,0x00},
    {0x40,0x7e,0xaa,0x5e,0x24,0xfe,0x04,0x00},
    {0xe4,0x7e,0x72,0x6c,0x66,0xec,0x36,0x00},
    {0xea,0x74,0x6a,0x6c,0x7e,0xec,0x34,0x00},
    {0x54,0xaa,0x4c,0xfe,0x24,0xfe,0x04,0x00},
    {0x2e,0xfa,0x64,0x8a,0x3c,0xfe,0x04,0x00},
    {0xe8,0x7e,0x7e,0x7e,0x60,0xfa,0x36,0x00},
    {0xfe,0x3c,0xfe,0xee,0x66,0xee,0x22,0x00},
    {0xe4,0x7e,0x7a,0x6c,0x7e,0xe4,0x2c,0x00},
    {0xe4,0x7e,0x6e,0xfe,0x60,0xfa,0x36,0x00},
    {0x10,0x7c,0x16,0xfc,0x10,0xfe,0x10,0x00},
    {0x84,0xec,0x86,0x7c,0xe4,0x5e,0xa4,0x00},
    {0x74,0x4c,0x76,0x4c,0xf4,0x5e,0xf4,0x00},
    {0x10,0x7c,0x3e,0xec,0x42,0x6e,0xaa,0x00},
    {0xe0,0xae,0xe4,0xa4,0xe4,0xa4,0xbe,0x00},
    {0x10,0xfe,0x40,0x7c,0x44,0x7c,0x44,0x00},
    {0xe4,0xa4,0xee,0xa4,0xe4,0xa4,0xbe,0x00},
    {0xec,0xa4,0xfe,0xb6,0xfa,0xb2,0xb6,0x00},
    {0xfe,0x82,0xba,0x7c,0x44,0x7c,0x44,0x00},
    {0xea,0xbe,0xe8,0xac,0xec,0xac,0xb6,0x00},
    {0xfe,0xb6,0xfe,0xb6,0xfe,0xa4,0xa4,0x00},
    {0xfe,0x1a,0x50,0xbe,0x44,0x7c,0x44,0x00},
    {0xe8,0xae,0xf8,0xae,0xe8,0xae,0xa8,0x00},
    {0xe2,0xbc,0xf4,0xbe,0xf4,0xb2,0xbe,0x00},
    {0x10,0xfe,0x92,0xfe,0x44,0x7c,0x44,0x00},
    {0xfe,0xa4,0xec,0xb6,0xe4,0xa4,0xbe,0x00},
    {0xf4,0xa2,0xe8,0xbe,0xe8,0xbe,0xa8,0x00},
    {0xec,0xa0,0xec,0xbe,0xec,0xb6,0xac,0x00},
    {0xe4,0xbe,0xec,0xb2,0xec,0xae,0xa2,0x00},
    {0xe4,0xb6,0xec,0xbe,0xec,0xac,0xb6,0x00},
    {0xfe,0xaa,0xf4,0xaa,0xfe,0xa4,0xbe,0x00},
    {0x2c,0x74,0xe8,0x7e,0x74,0x7c,0x54,0x00},
    {0x7e,0x7c,0x68,0xb6,0x7c,0x7c,0x44,0x00},
    {0xea,0xbe,0xe8,0xbe,0xfa,0xbe,0xba,0x00},
    {0xe4,0xbe,0xe8,0xae,0xfa,0xac,0xaa,0x00},
    {0xe8,0xbe,0xd4,0xae,0xbc,0xdc,0x94,0x00},
    {0xea,0xbe,0xfa,0xbe,0xfe,0xa0,0xb2,0x00},
    {0xe8,0xbe,0xfa,0xbe,0xec,0xbe,0xa4,0x00},
    {0xec,0xbe,0xec,0xbe,0xec,0xbe,0xac,0x00},
    {0xe4,0xbe,0xf0,0xba,0xfe,0xba,0xaa,0x00},
    {0xea,0xa0,0xfe,0xaa,0xfe,0xaa,0xb2,0x00},
    {0xfa,0xae,0xea,0xb6,0xea,0xa8,0xb6,0x00},
    {0xfe,0xb6,0xfe,0xbe,0xe0,0xba,0xb6,0x00},
    {0xee,0xaa,0xee,0xb4,0xee,0xa4,0xbe,0x00},
    {0xea,0xb4,0xea,0xbe,0xf6,0xba,0xbe,0x00},
    {0xe8,0xb6,0xfe,0xb6,0xfe,0xa4,0xba,0x00},
    {0xfe,0xb6,0xfa,0xbe,0xe0,0xac,0xbe,0x00},
    {0xfe,0xac,0xec,0xbe,0xf2,0xbe,0xb6,0x00},
    {0xea,0xbe,0xfc,0xb4,0xfe,0xb4,0xac,0x00},
    {0xe8,0xbe,0xf4,0xbe,0xea,0xac,0xb4,0x00},
    {0x48,0xee,0x7c,0xaa,0x7c,0x7c,0x44,0x00},
    {0xfe,0xaa,0xe4,0xaa,0xf4,0xa2,0xac,0x00},
    {0xfe,0xaa,0xfe,0xba,0xe6,0xb2,0xbe,0x00},
    {0xec,0xbe,0xf6,0xa0,0xec,0xa6,0xac,0x00},
    {0xe4,0xbe,0xf6,0xa8,0xfe,0xa4,0xbe,0x00},
    {0xe4,0xbe,0xf2,0xac,0xfa,0xa4,0xbe,0x00},
    {0xe8,0xae,0xfc,0xac,0xee,0xb6,0xaa,0x00},
    {0xe4,0xbe,0xf4,0xa4,0xf6,0xb4,0xaa,0x00},
    {0xfe,0xac,0xfe,0xac,0xf6,0xac,0xac,0x00},
    {0xf4,0xbe,0xf4,0xb4,0xea,0xbe,0xa8,0x00},
    {0xe8,0xb4,0xfe,0xaa,0xfe,0xac,0xac,0x00},
    {0xf4,0xae,0xf4,0xae,0xe6,0xb6,0xbe,0x00},
    {0xec,0xb4,0xfe,0xb6,0xfc,0xbe,0xac,0x00},
    {0x7e,0x7a,0x54,0xaa,0x7c,0x7c,0x44,0x00},
    {0x64,0x6e,0xca,0x64,0x7c,0x7c,0x44,0x00},
    {0x08,0x7e,0x6c,0x6e,0x5e,0x5e,0x92,0x00},
    {0xe8,0xb4,0xfe,0xaa,0xfe,0xb4,0xaa,0x00},
    {0xe8,0xbe,0xf4,0xaa,0xf4,0xbc,0xa4,0x00},
    {0xec,0xbe,0xf6,0xae,0xe4,0xbe,0xb6,0x00},
    {0xea,0xbe,0xee,0xaa,0xfe,0xa0,0xb6,0x00},
    {0xea,0xb4,0xee,0xae,0xfa,0xb6,0xba,0x00},
    {0xea,0xbe,0xec,0xae,0xf2,0xba,0xa6,0x00},
    {0xe8,0xae,0xf8,0xae,0xe0,0xac,0xbe,0x00},
    {0xf4,0xbe,0xf4,0xbe,0xec,0xbc,0xba,0x00},
    {0x5a,0xbc,0x5a,0xe6,0xfe,0x92,0xaa,0x00},
    {0x04,0xbe,0xe4,0x3c,0xf6,0xb4,0x5a,0x00},
    {0x10,0xfe,0x38,0xfe,0xaa,0x74,0xfe,0x00},
    {0xe8,0x5e,0xac,0x7e,0xea,0x5c,0xea,0x00},
    {0x56,0x92,0xd6,0x92,0xd6,0x28,0xc6,0x00},
    {0x2c,0x44,0x6c,0x7c,0x28,0xfe,0x48,0x00},
    {0x10,0x7c,0x38,0xfe,0x54,0xa6,0x3c,0x00},
    {0x2c,0x44,0x7c,0x54,0xfe,0x22,0xc6,0x00},
    {0x66,0xba,0xce,0xaa,0xfe,0x00,0xc6,0x00},
    {0x28,0xfe,0x7c,0xa8,0x3e,0x6c,0x7c,0x00},
    {0x10,0x28,0xfe,0x10,0xfe,0x44,0x7c,0x00},
    {0x22,0xdc,0xf4,0x5e,0xf4,0xb4,0xfa,0x00},
    {0x4a,0xbe,0x48,0xfe,0x6a,0xbe,0xea,0x00},
    {0x54,0xf4,0xa2,0xa8,0xe8,0xb4,0xba,0x00},
    {0x44,0xfe,0xa8,0xae,0xea,0xaa,0xb6,0x00},
    {0x5e,0xe2,0xbe,0xb6,0xfe,0xa2,0xa6,0x00},
    {0x48,0xfe,0xaa,0xbe,0xea,0xaa,0xbe,0x00},
    {0x5c,0xea,0xa0,0xac,0xe4,0xbe,0xa8,0x00},
    {0x44,0xea,0xbc,0xac,0xe8,0xb6,0xa6,0x00},
    {0x48,0xf6,0xb6,0xbe,0xea,0xa4,0xba,0x00},
    {0x4c,0xfe,0xb6,0xa0,0xec,0xa6,0xac,0x00},
    {0x54,0xfe,0xb4,0xbe,0xfe,0xb4,0xbc,0x00},
    {0x48,0xfe,0xb4,0xbe,0xfc,0xa8,0xbe,0x00},
    {0x54,0xfe,0xa8,0xbe,0xf6,0xbc,0xb2,0x00},
    {0x48,0xfe,0xb4,0xaa,0xfe,0xb6,0xbe,0x00},
    {0x54,0xfe,0xb4,0xbe,0xfa,0xac,0xba,0x00},
    {0x4c,0xf4,0xac,0xac,0xfa,0xac,0xac,0x00},
    {0x48,0xee,0xb8,0xae,0xe0,0xac,0xbe,0x00},
    {0x5e,0xe0,0xae,0xaa,0xee,0xa8,0xb0,0x00},
    {0xbe,0xf2,0x5e,0xf2,0xfe,0x54,0xba,0x00},
    {0xb6,0xfa,0xf4,0x9e,0x6e,0x78,0xee,0x00},
    {0x24,0xb6,0xb6,0xb6,0xfe,0x24,0x44,0x00},
    {0x28,0xfe,0x28,0x00,0x28,0x10,0xee,0x00},
    {0x28,0xfe,0x28,0x7e,0xa2,0x12,0x06,0x00},
    {0x28,0xfe,0x10,0xfe,0x40,0x40,0x3e,0x00},
    {0x28,0xfe,0x7c,0x00,0xfe,0x28,0xce,0x00},
    {0x28,0xfe,0x44,0xbe,0x28,0x10,0xee,0x00},
    {0x40,0x7e,0xb2,0x66,0x7e,0xb2,0x66,0x00},
    {0x28,0xfe,0x28,0x44,0xbe,0x14,0x6c,0x00},
    {0x28,0xfe,0x54,0x4c,0x64,0x8c,0x32,0x00},
    {0x28,0xfe,0x7e,0x44,0x7c,0x40,0x7e,0x00},
    {0x28,0xfe,0x28,0x7e,0x82,0x32,0x36,0x00},
    {0x28,0xfe,0x54,0x7c,0x54,0xfe,0x44,0x00},
    {0x28,0xfe,0x7c,0x44,0x7c,0x44,0xfe,0x00},
    {0x28,0xfe,0x18,0x68,0x18,0xe6,0x10,0x00},
    {0x28,0xfe,0x34,0xfe,0x54,0x7e,0x0c,0x00},
    {0x28,0xfe,0x74,0xbe,0x54,0x7e,0x0c,0x00},
    {0x28,0xfe,0xbc,0x24,0xac,0x22,0x9e,0x00},
    {0x28,0xfe,0x24,0x5e,0xc4,0x54,0x4c,0x00},
    {0x28,0xfe,0x38,0x54,0x10,0xfe,0x10,0x00},
    {0x28,0xfe,0x7a,0xaa,0x3a,0x20,0x3e,0x00},
    {0x28,0xfe,0x2e,0xca,0xaa,0xea,0x48,0x00},
    {0x28,0xfe,0x7c,0x44,0x7c,0x44,0x7c,0x00},
    {0x28,0xfe,0x10,0xfe,0x7c,0x38,0xd6,0x00},
    {0x28,0xfe,0x10,0xfe,0x24,0x28,0xfe,0x00},
    {0x28,0xfe,0x92,0xba,0x92,0xaa,0xfe,0x00},
    {0x28,0xfe,0xfe,0xba,0xaa,0xba,0xfe,0x00},
    {0x28,0xfe,0x18,0x68,0x10,0xee,0x38,0x00},
    {0x28,0xfe,0x44,0x88,0x44,0xaa,0xee,0x00},
    {0x28,0xfe,0x3c,0x50,0xfe,0x38,0xd6,0x00},
    {0x28,0xfe,0x7e,0xaa,0x3a,0x2a,0x3a,0x00},
    {0x28,0xfe,0x20,0xfe,0x5a,0x2a,0xde,0x00},
    {0x28,0xfe,0x2c,0x44,0xfe,0x48,0x58,0x00},
    {0x28,0xfe,0x10,0x38,0xc6,0x38,0x38,0x00},
    {0x28,0xfe,0x28,0x5e,0xc8,0x48,0x56,0x00},
    {0x28,0xfe,0x88,0x3e,0x90,0x10,0x9e,0x00},
    {0x28,0xfe,0x1c,0x64,0x1e,0xf2,0x1e,0x00},
    {0x28,0xfe,0x7c,0x24,0xfe,0x5a,0xb6,0x00},
    {0x28,0xfe,0x24,0x5e,0xca,0x4c,0x5e,0x00},
    {0x28,0xfe,0xdc,0x46,0x94,0x5e,0xbe,0x00},
    {0x28,0xfe,0x6a,0xfc,0x2a,0xe4,0x2a,0x00},
    {0x28,0xfe,0x24,0xda,0x08,0x7c,0x7c,0x00},
    {0x28,0xfe,0x54,0x54,0xba,0x10,0xee,0x00},
    {0x28,0xfe,0x4a,0x94,0xfe,0x10,0xfe,0x00},
    {0x28,0xfe,0x1c,0x54,0xfe,0x10,0xee,0x00},
    {0x28,0xfe,0x9c,0x1a,0xa8,0x04,0x98,0x00},
    {0x28,0xfe,0x74,0x5e,0x76,0x5a,0xea,0x00},
    {0x28,0xfe,0x20,0xa4,0xfe,0x64,0xae,0x00},
    {0x28,0xfe,0x38,0xd6,0x7c,0x54,0xb2,0x00},
    {0x28,0xfe,0x7c,0x54,0x7c,0x2a,0xce,0x00},
    {0x28,0xfe,0x7c,0x44,0x7c,0x28,0xfe,0x00},
    {0x28,0xfe,0x7c,0x14,0x6c,0xc2,0xba,0x00},
    {0x28,0xfe,0x38,0xd6,0x78,0x2c,0xc4,0x00},
    {0x28,0xfe,0x70,0x2a,0xfa,0x72,0xa6,0x00},
    {0x28,0xfe,0x7c,0x44,0x7c,0x48,0xe6,0x00},
    {0x28,0xfe,0x28,0xd6,0x7c,0x7c,0x0e,0x00},
    {0x28,0xfe,0x10,0xfe,0xba,0x28,0xfe,0x00},
    {0x28,0xfe,0x7c,0x54,0xfe,0x10,0xfe,0x00},
    {0x28,0xfe,0x44,0x7c,0x6e,0x48,0xee,0x00},
    {0x28,0xfe,0x30,0x2e,0xfa,0x24,0xaa,0x00},
    {0x28,0xfe,0x44,0x44,0xaa,0xfe,0x10,0x00},
    {0x28,0xfe,0x54,0xe2,0x48,0xf2,0x5e,0x00},
    {0x28,0xfe,0x14,0x7c,0xfe,0x28,0xf6,0x00},
    {0x28,0xfe,0x38,0xfe,0x54,0x7c,0x44,0x00},
    {0x28,0xfe,0x3c,0xfe,0x92,0x7c,0x54,0x00},
    {0x28,0xfe,0x3c,0x20,0xfe,0x28,0x76,0x00},
    {0x28,0xfe,0x84,0x1e,0x9a,0x14,0xaa,0x00},
    {0x28,0xfe,0x28,0xee,0x28,0xee,0x48,0x00},
    {0x28,0xfe,0xbe,0x1c,0xaa,0x3e,0x88,0x00},
    {0x28,0xfe,0x9e,0x2a,0x9a,0x10,0x9e,0x00},
    {0x28,0xfe,0x7e,0x5a,0x7e,0x5a,0xb6,0x00},
    {0x28,0xfe,0x28,0xc6,0x28,0xfe,0x48,0x00},
    {0x28,0xfe,0x56,0x92,0xd6,0x10,0xee,0x00},
    {0x28,0xfe,0x9c,0x3e,0x94,0x28,0x96,0x00},
    {0x28,0xfe,0x24,0xfe,0x6c,0xb6,0x24,0x00},
    {0x28,0xfe,0xa6,0xee,0x8a,0xe4,0x8a,0x00},
    {0x28,0xfe,0x24,0xcc,0x64,0xde,0x44,0x00},
    {0x28,0xfe,0x6c,0x38,0xfe,0x3c,0x04,0x00},
    {0x28,0xfe,0x38,0x6c,0xfe,0x3c,0x04,0x00},
    {0x28,0xfe,0xe6,0x0c,0xf4,0x6c,0xbe,0x00},
    {0x28,0xfe,0x92,0x7c,0x54,0xfe,0x10,0x00},
    {0x28,0xfe,0x4e,0xea,0x4e,0xaa,0xf6,0x00},
    {0x28,0xfe,0x72,0xa6,0x7e,0xb2,0x66,0x00},
    {0x28,0xfe,0x6c,0x5e,0x6a,0xc4,0x5a,0x00},
    {0x28,0xfe,0x24,0xfe,0x92,0x7c,0x54,0x00},
    {0x28,0xfe,0x4e,0xae,0xe8,0xaa,0xee,0x00},
    {0x28,0xfe,0x54,0xdc,0x7e,0x5c,0x6a,0x00},
    {0x28,0xfe,0x54,0x7c,0xfe,0x9a,0xb6,0x00},
    {0x28,0xfe,0x48,0x8e,0x52,0xea,0x46,0x00},
    {0x28,0xfe,0x48,0xee,0x5a,0x68,0xae,0x00},
    {0x28,0xfe,0x5c,0x54,0xfe,0xaa,0xba,0x00},
    {0x28,0xfe,0x28,0xc6,0xfe,0x66,0xaa,0x00},
    {0x28,0xfe,0x7c,0x28,0xd6,0x7c,0xfe,0x00},
    {0x28,0xfe,0x7c,0x2c,0x78,0x6c,0xaa,0x00},
    {0x28,0xfe,0x7c,0x28,0xfe,0xaa,0xba,0x00},
    {0x28,0xfe,0x4e,0xf2,0xae,0x4e,0xe2,0x00},
    {0x28,0xfe,0x54,0x6a,0x5c,0x48,0xbe,0x00},
    {0x28,0xfe,0x78,0x30,0xde,0x3c,0x3c,0x00},
    {0x28,0xfe,0x22,0xee,0x88,0x66,0xaa,0x00},
    {0x28,0xfe,0x2c,0x6a,0xf4,0x62,0x4c,0x00},
    {0x28,0xfe,0x7c,0x5a,0x7e,0xa4,0x0c,0x00},
    {0x28,0xfe,0x38,0xfe,0x54,0x38,0xd6,0x00},
    {0x28,0xfe,0x54,0x7e,0x48,0x7e,0xaa,0x00},
    {0x28,0xfe,0x54,0x6c,0x7e,0x48,0xee,0x00},
    {0x28,0xfe,0x24,0xfe,0xa2,0x3c,0xc4,0x00},
    {0x28,0xfe,0x6a,0x44,0xba,0x54,0xb2,0x00},
    {0x28,0xfe,0x82,0x5e,0xc8,0x5e,0x5e,0x00},
    {0x28,0xfe,0x38,0x34,0xfe,0x28,0x18,0x00},
    {0x28,0xfe,0x54,0x7e,0x5c,0x40,0xaa,0x00},
    {0x28,0xfe,0x24,0xfa,0x54,0x8a,0x30,0x00},
    {0x28,0xfe,0xe4,0x3e,0x50,0xde,0xea,0x00},
    {0x28,0xfe,0x48,0xee,0x5e,0x64,0xaa,0x00},
    {0x28,0xfe,0x6c,0xb6,0xfe,0x7c,0x54,0x00},
    {0x28,0xfe,0x7e,0xaa,0x3a,0x7a,0x7a,0x00},
    {0x28,0xfe,0x6c,0x38,0xd6,0x08,0x30,0x00},
    {0x28,0xfe,0x24,0xfe,0xb6,0x6c,0xb6,0x00},
    {0x28,0xfe,0x54,0xfe,0xb6,0x5e,0xe4,0x00},
    {0x28,0xfe,0x7c,0xee,0xfe,0x28,0xce,0x00},
    {0x28,0xfe,0x54,0x7c,0x28,0xfe,0x10,0x00},
    {0x28,0xfe,0x1c,0xee,0x4a,0xfe,0x2c,0x00},
    {0x28,0xfe,0x64,0xda,0xb6,0x38,0xd6,0x00},
    {0x28,0xfe,0x5c,0xfe,0x26,0xb4,0xfe,0x00},
    {0x28,0xfe,0xac,0x52,0xbe,0x36,0xde,0x00},
    {0x28,0xfe,0xaa,0x36,0xbe,0x1c,0xbe,0x00},
    {0x28,0xfe,0xf6,0x54,0xb6,0x54,0xbe,0x00},
    {0x28,0xfe,0x7c,0xd6,0x7c,0x44,0x7c,0x00},
    {0x28,0xfe,0x7c,0x38,0x7c,0x38,0xfe,0x00},
    {0x28,0xfe,0x62,0xaa,0x6a,0x02,0xa6,0x00},
    {0x28,0xfe,0x54,0xfe,0xbe,0x68,0xce,0x00},
    {0x28,0xfe,0x3c,0xee,0x42,0x6e,0xaa,0x00},
    {0x28,0xfe,0x54,0xba,0xfe,0x6c,0x7c,0x00},
    {0x28,0xfe,0xe8,0xfe,0x94,0xfe,0xe8,0x00},
    {0x28,0xfe,0xf6,0x7a,0xfa,0x54,0xea,0x00},
    {0x28,0xfe,0x5e,0x86,0x7e,0xd4,0x6a,0x00},
    {0x28,0xfe,0x64,0x7e,0xca,0x7e,0x64,0x00},
    {0x28,0xfe,0x6e,0x26,0xf6,0x30,0x6a,0x00},
    {0x28,0xfe,0x7c,0xb6,0x7c,0x54,0x7c,0x00},
    {0x28,0xfe,0x2c,0xde,0x6a,0xd4,0x4a,0x00},
    {0x28,0xfe,0x5e,0xec,0x5e,0xec,0x4c,0x00},
    {0x28,0xfe,0x6c,0xba,0x44,0x7c,0x84,0x00},
    {0x28,0xfe,0x04,0xbe,0xfc,0x74,0xda,0x00},
    {0x28,0xfe,0x38,0xfe,0xaa,0x74,0xfe,0x00},
    {0x28,0xfe,0x24,0xce,0x6a,0xac,0x76,0x00},
    {0x28,0xfe,0x4c,0xec,0x5e,0xf6,0x5a,0x00},
    {0x28,0xfe,0x2c,0x76,0xfe,0x24,0xfa,0x00},
    {0x28,0xfe,0x7a,0xac,0xfe,0x38,0xd6,0x00},
    {0x28,0xfe,0x6a,0xb6,0x28,0xfe,0x54,0x00},
    {0x28,0xfe,0x5c,0xd4,0x1e,0xf2,0xda,0x00},
    {0x28,0xfe,0x56,0x9a,0x5e,0xec,0x5e,0x00},
    {0x28,0xfe,0x2c,0xd4,0x5c,0xdc,0x6a,0x00},
    {0x28,0xfe,0x2e,0xb6,0xe6,0x10,0x6a,0x00},
    {0x28,0xfe,0x7a,0x76,0x26,0x70,0xaa,0x00},
    {0x28,0xfe,0xc6,0xaa,0xbe,0xea,0xbe,0x00},
    {0x28,0xfe,0x0c,0x78,0x4e,0x5c,0xbe,0x00},
    {0x28,0xfe,0xfc,0x56,0xfa,0x74,0x56,0x00},
    {0x28,0xfe,0x6a,0xbe,0x64,0x7e,0xa4,0x00},
    {0x28,0xfe,0x4c,0x9e,0x5a,0xe4,0x5a,0x00},
    {0x28,0xfe,0xfe,0x94,0x5e,0xf4,0x5e,0x00},
    {0x10,0x1c,0x7e,0x52,0x7c,0x52,0x9e,0x00},
    {0x06,0x78,0x7e,0x7e,0x48,0x7e,0xaa,0x00},
    {0x08,0x0e,0x78,0x5e,0x54,0x48,0xb6,0x00},
    {0xc8,0xce,0x38,0xee,0xa0,0x6c,0xd6,0x00},
    {0x2e,0x34,0xee,0xb4,0xf6,0xe2,0xf6,0x00},
    {0xfc,0x24,0xfc,0xac,0xfc,0x24,0xfa,0x00},
    {0x5a,0xea,0xba,0xf2,0x5a,0x6a,0xda,0x00},
    {0x54,0xf4,0xa2,0xe8,0x48,0x54,0xfa,0x00},
    {0x54,0x7c,0xfe,0x54,0x7c,0x14,0xfa,0x00},
    {0x44,0xf4,0xa4,0xf4,0x46,0x7c,0xc4,0x00},
    {0x58,0xe8,0xbe,0xea,0x76,0x62,0xe6,0x00},
    {0x44,0xfe,0xa4,0xee,0x44,0x5e,0xe4,0x00},
    {0x4a,0xfe,0xaa,0xee,0x4a,0x6a,0xce,0x00},
    {0x44,0xf8,0xb0,0xfe,0x54,0x54,0xfe,0x00},
    {0x44,0xe4,0xbe,0xe4,0x4e,0x6a,0xce,0x00},
    {0x5c,0xf4,0xbc,0xf4,0x5c,0x54,0xfe,0x00},
    {0x44,0xfe,0xb6,0xfe,0x56,0x76,0xde,0x00},
    {0x48,0xf4,0xae,0xe0,0x5e,0x6a,0xc8,0x00},
    {0x5e,0xf4,0xbe,0xfe,0x54,0x5e,0xea,0x00},
    {0x48,0xee,0xb2,0xee,0x4e,0x68,0xce,0x00},
    {0x5e,0xf2,0xbe,0xfa,0x5e,0x72,0xde,0x00},
    {0x42,0xec,0xbe,0xe4,0x4e,0x6a,0xce,0x00},
    {0xec,0x4c,0xf6,0x38,0x38,0x14,0xfa,0x00},
    {0x28,0x7c,0xfe,0x7c,0xba,0x14,0xfa,0x00},
    {0x48,0xfe,0xb4,0xe2,0x54,0x48,0xf6,0x00},
    {0x58,0xdc,0xa8,0xfe,0x48,0x5c,0xea,0x00},
    {0x4a,0xfc,0xa8,0xfe,0x50,0x68,0xce,0x00},
    {0x72,0xdc,0xe6,0xd4,0x7e,0x50,0xee,0x00},
    {0x5e,0xf2,0xbe,0xf2,0x5e,0x6c,0xd6,0x00},
    {0x46,0xf6,0xbc,0xe4,0x5e,0x68,0xd6,0x00},
    {0xfe,0xaa,0x7e,0xba,0x3a,0x16,0xfa,0x00},
    {0x7e,0x7c,0x68,0xb6,0x38,0x3c,0xfa,0x00},
    {0x54,0xe2,0xbe,0xf2,0x5e,0x6c,0xd6,0x00},
    {0xc2,0x5c,0x86,0x54,0xfe,0x3c,0xfa,0x00},
    {0x5c,0xea,0xa0,0xec,0x44,0x7e,0xc8,0x00},
    {0x48,0xf4,0xbe,0xc8,0x7e,0x48,0xea,0x00},
    {0x5e,0xe4,0xbe,0xf6,0x5e,0x76,0xd6,0x00},
    {0x7a,0xd6,0xbe,0xd6,0x7a,0x72,0xd6,0x00},
    {0x5e,0xf2,0xbe,0xe8,0x4e,0x56,0xea,0x00},
    {0x48,0xfe,0xa2,0xde,0x6a,0x58,0xee,0x00},
    {0x54,0xea,0xbe,0xd4,0x6a,0x50,0xdc,0x00},
    {0x44,0xee,0xa4,0xfe,0x4e,0x6e,0xca,0x00},
    {0x52,0xfc,0xd8,0xfe,0x7a,0x5a,0xd2,0x00},
    {0x7e,0xea,0xbe,0xea,0x76,0x7e,0xe2,0x00},
    {0x28,0xee,0x28,0xee,0x78,0x3c,0xfa,0x00},
    {0x5e,0xec,0xac,0xe0,0x5e,0x76,0xde,0x00},
    {0x7e,0xea,0xbe,0xfe,0x54,0x5c,0xd4,0x00},
    {0x4e,0xea,0xaa,0xfe,0x52,0x76,0xd6,0x00},
    {0x7a,0xd6,0xba,0xd6,0x72,0x7e,0xd2,0x00},
    {0x5c,0xf4,0xbc,0xfe,0x52,0x7a,0xc6,0x00},
    {0x56,0xfe,0xd6,0xfe,0x6e,0x7e,0xca,0x00},
    {0x44,0xee,0xaa,0xee,0x5e,0x64,0xde,0x00},
    {0x7c,0x14,0xfc,0x22,0x6c,0x6c,0xda,0x00},
    {0x50,0xfe,0xac,0xec,0x54,0x48,0xf6,0x00},
    {0x7e,0xf4,0xbc,0xf0,0x5e,0x6e,0xca,0x00},
    {0x78,0xd4,0xee,0xc0,0x5a,0x5c,0xda,0x00},
    {0x54,0xfe,0xd6,0xda,0x5c,0x6e,0xec,0x00},
    {0x5c,0xf4,0xbe,0xd0,0x5e,0x6a,0xd6,0x00},
    {0x7e,0xf6,0xd4,0xf6,0x76,0x54,0xde,0x00},
    {0xaa,0x44,0xfe,0xba,0x38,0x14,0xfa,0x00},
    {0x5e,0xf2,0xac,0xec,0x5e,0x60,0xd2,0x00},
    {0x56,0xfe,0xac,0xfe,0x66,0x74,0xc4,0x00},
    {0x26,0x6a,0xf4,0x6a,0xb8,0x3c,0xfa,0x00},
    {0x7e,0xd4,0xfe,0xdc,0x6a,0x50,0xee,0x00},
    {0x18,0x68,0x38,0xd6,0x6c,0x6c,0xda,0x00},
    {0x48,0xfe,0xea,0xd4,0x6a,0x7e,0xc8,0x00},
    {0x6a,0xdc,0xb6,0xdc,0x7e,0x6a,0xc8,0x00},
    {0xea,0xbe,0x54,0xfe,0xf4,0x54,0xfe,0x00},
    {0x66,0xfa,0x74,0xaa,0x38,0x3c,0xfa,0x00},
    {0x28,0x7c,0xec,0x76,0x38,0x3c,0xfa,0x00},
    {0x6a,0xdc,0xb6,0xdc,0x7e,0x48,0xfe,0x00},
    {0x28,0xfe,0x38,0xfc,0x7e,0x94,0x7a,0x00},
    {0x54,0xfe,0xdc,0xd4,0x7e,0x48,0xf6,0x00},
    {0x48,0xdc,0xb6,0xdc,0x7e,0x54,0xfa,0x00},
    {0x48,0xdc,0xbe,0xf6,0x7e,0x54,0xe6,0x00},
    {0x10,0x7c,0x7c,0xfa,0x6c,0x6c,0xda,0x00},
    {0x7e,0xd4,0xfe,0xdc,0x6a,0x5c,0xdc,0x00},
    {0x5e,0xea,0xd8,0xda,0x5e,0x5e,0xea,0x00},
    {0x7c,0xee,0xfa,0xdc,0x6c,0x74,0xca,0x00},
    {0x4c,0xd4,0xbe,0xf6,0x6c,0x7e,0xcc,0x00},
    {0x7e,0xda,0xbe,0xc8,0x5c,0x48,0xfe,0x00},
    {0x6a,0xdc,0xb6,0xdc,0x7e,0x6a,0xfe,0x00},
    {0x54,0xfe,0xd4,0xea,0x4c,0x7e,0xd4,0x00},
    {0x54,0xfe,0xd4,0xe2,0x54,0x7e,0xd4,0x00},
    {0x6a,0xd4,0xbe,0xea,0x5c,0x5c,0xea,0x00},
    {0x54,0xfe,0xdc,0xde,0x54,0x48,0xf6,0x00},
    {0x5c,0xfe,0xea,0xdc,0x48,0x7e,0xea,0x00},
    {0x38,0xfe,0x5c,0x9a,0x6c,0x6c,0xda,0x00},
    {0x1c,0xfe,0x2c,0xda,0x6c,0x6c,0xda,0x00},
    {0x10,0x7c,0x7e,0x6c,0xda,0x7c,0xfe,0x00},
    {0xfe,0x6c,0xb6,0x38,0x6c,0x6c,0xda,0x00},
    {0x10,0xfe,0x54,0xba,0x7c,0x6c,0xda,0x00},
    {0x10,0xfe,0x7c,0xba,0x6c,0x6c,0xda,0x00},
    {0x5a,0xbc,0x5a,0xe6,0x7a,0x3c,0xfa,0x00},
    {0x3e,0x6a,0x6a,0x7e,0x6a,0x6a,0xde,0x00},
    {0x3e,0x6a,0x7a,0x6a,0x6e,0x6a,0xd6,0x00},
    {0x56,0xb8,0x56,0xea,0x52,0x7a,0x46,0x00},
    {0x5e,0x88,0x5e,0xda,0x42,0x5a,0x5a,0x00},
    {0x56,0xb8,0x5e,0xea,0x7a,0x7a,0x56,0x00},
    {0x76,0xb4,0x42,0xd6,0x5e,0x7a,0x5e,0x00},
    {0x42,0xec,0x22,0x4c,0xe0,0x62,0x4c,0x00},
    {0x10,0x7c,0xfe,0x44,0x7c,0x68,0xb6,0x00},
    {0x10,0x28,0xfe,0x08,0xfe,0x68,0xb6,0x00},
    {0x10,0xfe,0x44,0xba,0x38,0xe8,0x36,0x00},
    {0x5e,0xf2,0x32,0x5e,0xf2,0x72,0x5e,0x00},
    {0x42,0xec,0x24,0x5e,0xe4,0x64,0x4e,0x00},
    {0x52,0xec,0x24,0x6e,0xe4,0x64,0x6e,0x00},
    {0x4c,0xe4,0x3e,0x56,0xfa,0x72,0x56,0x00},
    {0x44,0xee,0x26,0x5e,0xe4,0x64,0x5a,0x00},
    {0x48,0xf4,0x2a,0x44,0xea,0x64,0x58,0x00},
    {0x4e,0xea,0x2e,0x4a,0xee,0x60,0x5e,0x00},
    {0x48,0xee,0x34,0x4c,0xee,0x76,0x4c,0x00},
    {0x48,0xfe,0x32,0x5e,0xf2,0x72,0x5e,0x00},
    {0x54,0xe2,0x28,0x5e,0xe8,0x7e,0x48,0x00},
    {0x48,0xee,0x32,0x4e,0xee,0x68,0x4e,0x00},
    {0x10,0xfe,0x78,0x3e,0xd2,0x68,0xb6,0x00},
    {0x3c,0x34,0xfe,0x54,0xfe,0x68,0xb6,0x00},
    {0x44,0xee,0x24,0x5e,0xee,0x64,0x5e,0x00},
    {0x56,0xe4,0x2e,0x64,0xe4,0x64,0x6a,0x00},
    {0x48,0xee,0x28,0x5e,0xec,0x6a,0x48,0x00},
    {0x56,0xe0,0x36,0x52,0xf2,0x72,0x56,0x00},
    {0x10,0xfe,0x68,0xb6,0xfe,0xda,0x9a,0x00},
    {0x14,0xfe,0x58,0xb4,0xfe,0x68,0xb6,0x00},
    {0x5e,0xea,0x3e,0x4a,0xfc,0x6e,0x56,0x00},
    {0xa4,0xfe,0x64,0xae,0xfe,0x68,0xb6,0x00},
    {0x10,0xfe,0x38,0x7c,0xb2,0x68,0xb6,0x00},
    {0x54,0xfc,0x34,0x5e,0xf4,0x7c,0x44,0x00},
    {0x5e,0xf2,0x3e,0x48,0xee,0x76,0x4a,0x00},
    {0x28,0xee,0xee,0x28,0xfe,0x68,0xb6,0x00},
    {0x48,0xfe,0x3a,0x5e,0xec,0x7e,0x44,0x00},
    {0x5e,0xe4,0x3e,0x56,0xfe,0x7e,0x56,0x00},
    {0x48,0xfe,0x2c,0x5c,0xfe,0x6c,0x5a,0x00},
    {0x5e,0xf6,0x3e,0x4c,0xec,0x7e,0x44,0x00},
    {0x5e,0xea,0x2e,0x48,0xee,0x7e,0x4a,0x00},
    {0x5c,0xf4,0x3c,0x68,0xfe,0x7c,0x6a,0x00},
    {0x10,0xfe,0x54,0x9c,0x6a,0xe4,0x32,0x00},
    {0x5e,0xf6,0x3a,0x5e,0xe0,0x6c,0x5e,0x00},
    {0x5e,0xfc,0x3a,0x6c,0xfe,0x74,0x4c,0x00},
    {0x56,0xe6,0x36,0x44,0xea,0x70,0x5e,0x00},
    {0x7e,0xe6,0x3c,0x76,0xf0,0x6c,0x56,0x00},
    {0x5a,0xec,0x3e,0x56,0xfe,0x6c,0x5e,0x00},
    {0x10,0xfe,0x6c,0x38,0xfe,0x68,0xb6,0x00},
    {0x10,0xfe,0xfc,0x6c,0xf6,0x68,0xb6,0x00},
    {0x5e,0xea,0x3e,0x4a,0xe4,0x6e,0x4e,0x00},
    {0x48,0xfc,0x36,0x5c,0xfe,0x54,0x7a,0x00},
    {0x5a,0xfa,0x2c,0x4c,0xec,0x7e,0x44,0x00},
    {0x5a,0xe4,0x3e,0x5e,0xe4,0x7e,0x44,0x00},
    {0x6a,0xfc,0x36,0x5c,0xfe,0x6a,0x7e,0x00},
    {0x64,0x6e,0xca,0x64,0xfe,0x68,0xb6,0x00},
    {0x5c,0xfe,0x2a,0x5c,0xe8,0x7e,0x6a,0x00},
    {0x54,0xf6,0x30,0x56,0xe0,0x6c,0x5e,0x00},
    {0x56,0xfc,0x36,0x5e,0xe6,0x78,0x5a,0x00},
    {0x4a,0xfe,0x2c,0x5e,0xf6,0x74,0x5a,0x00},
    {0x56,0xfe,0x2e,0x56,0xfe,0x74,0x5a,0x00},
    {0x76,0xf6,0x2a,0x7e,0xea,0x7e,0x6a,0x00},
    {0x56,0xea,0x2e,0x7e,0xdc,0x7e,0x58,0x00},
    {0x00,0xfe,0x28,0xfe,0xaa,0xba,0x82,0x00},
    {0xfe,0x7c,0x54,0x38,0x28,0xfe,0x10,0x00},
    {0xfe,0x7c,0x54,0xee,0xfa,0x64,0xaa,0x00},
    {0xfe,0x7c,0x54,0xae,0x4c,0xe2,0x56,0x00},
    {0x7c,0x52,0xbc,0x24,0x3c,0x2a,0xce,0x00},
    {0x5e,0x52,0x7e,0x52,0xfe,0xac,0xf6,0x00},
    {0xfe,0x2a,0x7e,0x7a,0xae,0x34,0xca,0x00},
    {0x2e,0x7a,0x2e,0xfa,0x4e,0xb4,0x3a,0x00},
    {0xee,0x5a,0xbe,0x0a,0xde,0xec,0xd6,0x00},
    {0xae,0xfa,0x0e,0xfa,0x5e,0x2c,0xf6,0x00},
    {0x5e,0xfa,0x5e,0xfa,0x7e,0xf4,0x5a,0x00},
    {0x5e,0xfa,0x5e,0xfa,0xfe,0x24,0xfa,0x00},
    {0x2c,0x54,0xfe,0xba,0x28,0x3a,0xce,0x00},
    {0xe8,0xce,0xee,0x38,0x38,0x3a,0xce,0x00},
    {0x2e,0xfa,0xde,0xfa,0x6e,0x6c,0x96,0x00},
    {0x5e,0xfa,0xde,0x6a,0x7e,0xec,0x76,0x00},
    {0x62,0xbc,0x74,0x74,0x74,0x76,0xaa,0x00},
    {0x24,0xb6,0xa4,0xfe,0x54,0x7c,0x84,0x00},
    {0x62,0xbc,0x74,0x7e,0x74,0x72,0xbe,0x00},
    {0x6a,0xbe,0x64,0x6e,0x64,0x7e,0xa4,0x00},
    {0x68,0xae,0x7c,0x6c,0x6e,0x76,0xaa,0x00},
    {0x7e,0xb6,0x6e,0x72,0x6e,0x6e,0xba,0x00},
    {0x48,0xe8,0x08,0xec,0x0a,0xe8,0xe8,0x00},
    {0x50,0xde,0x2c,0xc4,0x08,0xd2,0xce,0x00},
    {0x5c,0xc8,0x08,0xbe,0x08,0xc8,0xc8,0x00},
    {0x40,0xdc,0x08,0xc8,0x08,0xc8,0xfe,0x00},
    {0x4c,0xd4,0x36,0xd4,0x14,0xd4,0xd6,0x00},
    {0x5e,0xd4,0x14,0xbe,0x0c,0xf4,0xcc,0x00},
    {0x58,0xc8,0x3e,0xea,0x36,0xe2,0xe6,0x00},
    {0x5e,0xe2,0x1e,0xd6,0x1e,0xc2,0xc6,0x00},
    {0x48,0xc8,0x3e,0xc8,0x1c,0xd4,0xdc,0x00},
    {0x5c,0xd4,0x1c,0xd4,0x1c,0xd4,0xfe,0x00},
    {0x48,0xc8,0x14,0xba,0x00,0xdc,0xdc,0x00},
    {0x42,0xdc,0x14,0xde,0x14,0xd2,0xde,0x00},
    {0xfe,0xaa,0xfe,0x38,0xfe,0x44,0x7c,0x00},
    {0x90,0xfe,0x10,0xa4,0x16,0xc4,0xda,0x00},
    {0x4c,0xf4,0x1e,0xde,0x1a,0xd8,0xee,0x00},
    {0x42,0xdc,0x10,0xde,0x10,0xd6,0xe6,0x00},
    {0x50,0xde,0x3e,0xd6,0x1e,0xd6,0xde,0x00},
    {0x58,0xdc,0x28,0xbe,0x08,0xdc,0xea,0x00},
    {0x94,0xf6,0x14,0xb6,0x14,0xd4,0xe6,0x00},
    {0x8a,0xfc,0x1e,0xc8,0x3e,0xdc,0xea,0x00},
    {0x50,0xde,0x2c,0xcc,0x36,0xdc,0xc4,0x00},
    {0x84,0xfe,0x14,0xbc,0x16,0xd4,0xca,0x00},
    {0xae,0xd4,0x34,0x9e,0x34,0xd4,0xee,0x00},
    {0x58,0xdc,0x28,0xbe,0x08,0xdc,0xdc,0x00},
    {0xbe,0xc4,0x3e,0xaa,0x3e,0xea,0xea,0x00},
    {0x54,0xea,0x14,0xdc,0x14,0xdc,0xd4,0x00},
    {0xbe,0xc8,0x1c,0xdc,0x2a,0xc8,0xfe,0x00},
    {0x88,0xfe,0x14,0xdc,0x04,0xfe,0xc8,0x00},
    {0x5c,0xea,0x1c,0xcc,0x3e,0xcc,0xd8,0x00},
    {0x4e,0xd2,0x04,0xd6,0x12,0xd6,0xde,0x00},
    {0x88,0xfe,0x2e,0xc4,0x16,0xd4,0xee,0x00},
    {0x88,0xfe,0x1e,0xde,0x08,0xdc,0xea,0x00},
    {0x88,0xfe,0x14,0xbe,0x00,0xdc,0xdc,0x00},
    {0xa4,0xf6,0x24,0xb6,0x08,0xdc,0xdc,0x00},
    {0xb6,0xf6,0x1c,0xbe,0x10,0xde,0xc2,0x00},
    {0x48,0xde,0x0a,0xbe,0x14,0xfe,0xc4,0x00},
    {0x44,0xe6,0x1c,0xd6,0x1e,0xd8,0xee,0x00},
    {0x44,0xde,0x12,0xcc,0x00,0xcc,0xde,0x00},
    {0xbe,0xea,0x3e,0xdc,0x1c,0xfe,0xc8,0x00},
    {0xbe,0xea,0x3e,0xbe,0x2a,0xee,0xda,0x00},
    {0xbe,0xd4,0x1c,0xd0,0x1e,0xde,0xea,0x00},
    {0x50,0xee,0x3a,0xaa,0x3e,0xc8,0xf6,0x00},
    {0x5e,0xe4,0x14,0xde,0x04,0xd4,0xcc,0x00},
    {0x10,0xfe,0xaa,0x7c,0xba,0x7c,0x7c,0x00},
    {0x54,0xe2,0x1c,0xd4,0x22,0xdc,0xfe,0x00},
    {0x54,0xe2,0x18,0xdc,0x04,0xdc,0xfe,0x00},
    {0x5c,0xdc,0x26,0xcc,0x34,0xc8,0xf6,0x00},
    {0x48,0xd2,0x34,0xda,0x2e,0xdc,0xfe,0x00},
    {0x88,0xfe,0x14,0xbe,0x2a,0xcc,0xd4,0x00},
    {0x4c,0xd4,0x08,0xde,0x24,0xd6,0xde,0x00},
    {0xbe,0xec,0x2c,0xa0,0x36,0xf6,0xfe,0x00},
    {0xa8,0xee,0xf2,0x5a,0xe2,0xfa,0x5a,0x00},
    {0x2e,0xfa,0x64,0x8a,0xfe,0x44,0x7c,0x00},
    {0x88,0xfe,0x14,0xbe,0x2a,0xf6,0xfe,0x00},
    {0x5c,0xd4,0x3e,0xbe,0x14,0xc8,0xf6,0x00},
    {0x54,0xfe,0x1c,0xd4,0x3e,0xc8,0xf6,0x00},
    {0x94,0xfe,0x1c,0xbe,0x1c,0xfe,0xc8,0x00},
    {0x9c,0xea,0x1c,0xd4,0x3e,0xc2,0xea,0x00},
    {0x52,0xe4,0x12,0xbc,0x16,0xd4,0xea,0x00},
    {0x5c,0xfe,0x1a,0xa8,0x3e,0xf6,0xea,0x00},
    {0xba,0xd4,0x22,0xdc,0x14,0xc8,0xfe,0x00},
    {0x54,0xde,0x3e,0x94,0x2a,0xdc,0xdc,0x00},
    {0x94,0xfe,0x14,0xaa,0x1c,0xd4,0xdc,0x00},
    {0xbe,0xdc,0x00,0xdc,0x14,0xfe,0xc8,0x00},
    {0x4c,0xd4,0x3e,0xb6,0x2c,0xfe,0xcc,0x00},
    {0x5c,0xd4,0x3e,0xaa,0x3e,0xdc,0xea,0x00},
    {0x64,0x6e,0xca,0x7c,0x00,0x7c,0x7c,0x00},
    {0xbe,0xfe,0x08,0xbe,0x14,0xfe,0xc8,0x00},
    {0xa4,0xde,0x36,0x9e,0x2c,0xee,0xfe,0x00},
    {0x2c,0x54,0x5c,0xfe,0x44,0xba,0x38,0x00},
    {0x88,0xfe,0x36,0xbe,0x1c,0xdc,0xe2,0x00},
    {0x94,0xfe,0x1c,0xd4,0x3e,0xc0,0xea,0x00},
    {0x52,0x7c,0xe6,0x7c,0x66,0x7c,0x7e,0x00},
    {0x4c,0xf6,0x1e,0xdc,0x36,0xcc,0xf6,0x00},
    {0x88,0xfe,0x36,0xdc,0x3e,0xf4,0xda,0x00},
    {0x56,0xd4,0x3e,0xd4,0x3e,0xd4,0xfa,0x00},
    {0x94,0xfe,0x36,0xd4,0x1e,0xf4,0xde,0x00},
    {0xa8,0xfe,0x14,0xaa,0x1c,0xdc,0xe2,0x00},
    {0x5e,0x8a,0x2a,0x5e,0x86,0x7a,0x76,0x00},
    {0x2a,0xf0,0xb4,0x7a,0x20,0xf6,0x76,0x00},
    {0x6a,0xd0,0x24,0x5a,0xf0,0x26,0xd6,0x00},
    {0x54,0x7c,0xfe,0x44,0x7c,0x28,0xfe,0x00},
    {0xe4,0x1e,0xf2,0xae,0x56,0xec,0x16,0x00},
    {0xee,0xc4,0xea,0xfe,0x7c,0x28,0xfe,0x00},
    {0xaa,0xfe,0xfe,0x44,0x7c,0x28,0xfe,0x00},
    {0xfe,0x20,0x34,0xd8,0x2c,0xca,0x30,0x00},
    {0x54,0x92,0x38,0x7c,0xda,0x2c,0xda,0x00},
    {0xea,0x5c,0xa8,0x7e,0xb4,0x2e,0xce,0x00},
    {0x08,0x74,0xf8,0x14,0x6c,0x14,0x68,0x00},
    {0x24,0xde,0x64,0xa6,0x6c,0xb4,0x4c,0x00},
    {0x3e,0xca,0x72,0xa6,0x7e,0xb2,0x5e,0x00},
    {0x2c,0xd4,0x68,0xb4,0x62,0xac,0x4c,0x00},
    {0x34,0xde,0x74,0xbc,0x7e,0xb4,0x54,0x00},
    {0x3e,0xc8,0x7e,0xb2,0x7e,0xb2,0x5e,0x00},
    {0x3e,0xd6,0x7e,0xb6,0x7e,0xa4,0x5e,0x00},
    {0x28,0xd6,0x7a,0xb2,0x7e,0xac,0x56,0x00},
    {0x28,0xde,0x76,0xba,0x7e,0xb4,0x5e,0x00},
    {0x34,0xd4,0x7e,0xb4,0x74,0xbc,0x56,0x00},
    {0x34,0xde,0x7c,0xb4,0x7e,0xa8,0x56,0x00},
    {0xea,0xa8,0xfe,0xa8,0xea,0x04,0xaa,0x00},
    {0x06,0x78,0x7e,0x5c,0x54,0x5c,0xa2,0x00},
    {0x10,0x28,0xfe,0x08,0x7c,0x7c,0xc6,0x00},
    {0xe4,0xa4,0xea,0xbe,0xe0,0x0e,0xae,0x00},
    {0x24,0xb6,0xa4,0xfe,0x44,0x7c,0xc6,0x00},
    {0x0a,0xfe,0x68,0x08,0x64,0x64,0x92,0x00},
    {0x6a,0x08,0xfe,0x68,0x64,0x64,0x92,0x00},
    {0xee,0xa4,0xfe,0xa2,0xf4,0x18,0xa6,0x00},
    {0xfe,0x54,0x7c,0x7c,0x44,0x7c,0xc6,0x00},
    {0x10,0xfe,0x54,0xfe,0x44,0x7c,0xc6,0x00},
    {0xea,0xbe,0xe4,0xaa,0xfe,0x04,0xaa,0x00},
    {0x10,0xfe,0x54,0x7c,0x44,0x7c,0xc6,0x00},
    {0x10,0xfe,0x54,0xaa,0x7c,0x7c,0xc6,0x00},
    {0x10,0xfe,0xaa,0x7c,0xc6,0x7c,0xc6,0x00},
    {0xf4,0xbe,0xec,0xbe,0xee,0x1c,0xaa,0x00},
    {0xea,0xbe,0xfc,0xb4,0xfe,0x14,0xac,0x00},
    {0x28,0x7c,0xec,0x76,0x3c,0x3c,0xc6,0x00},
    {0x26,0x6a,0xf4,0x6a,0xbc,0x3c,0xc6,0x00},
    {0x6c,0xfe,0x6c,0xb6,0x7c,0x7c,0xc6,0x00},
    {0x5a,0xe4,0xbe,0x54,0xbe,0x3c,0xc6,0x00},
    {0x10,0xfe,0x40,0x7c,0x76,0x76,0xae,0x00},
    {0xec,0xb4,0xfe,0xb6,0xfc,0x1e,0xac,0x00},
    {0xe8,0xbc,0xee,0xbc,0xea,0x1c,0xbe,0x00},
    {0x10,0xfe,0x6c,0xba,0x7c,0x7c,0xac,0x00},
    {0xc4,0xde,0xf4,0xfc,0xde,0x34,0xaa,0x00},
    {0xe4,0xbe,0xf4,0xbe,0xf4,0x14,0xae,0x00},
    {0x38,0x38,0x44,0x00,0x6c,0x6c,0x92,0x00},
    {0xe8,0xbe,0xf6,0xbe,0xfc,0x1c,0xa2,0x00},
    {0x2e,0x7e,0x28,0xfe,0xea,0x7c,0xaa,0x00},
    {0x24,0x7e,0x24,0xfe,0xe8,0x76,0xa6,0x00},
    {0x10,0x7c,0xfe,0x24,0x08,0x50,0xbe,0x00},
    {0x54,0xf4,0x54,0xf6,0x5c,0xc4,0xbe,0x00},
    {0x48,0xd4,0x6a,0xd0,0x44,0xd8,0xbe,0x00},
    {0x54,0xea,0x5c,0xf4,0x5c,0xd4,0xbe,0x00},
    {0xe8,0xbe,0xe8,0x5c,0xf4,0xc8,0xf6,0x00},
    {0xe4,0xa4,0xf4,0x56,0xf4,0xd4,0xfe,0x00},
    {0xe8,0xbc,0xe8,0x7e,0xc8,0xd4,0xe2,0x00},
    {0xd0,0xbe,0xfa,0x5a,0xda,0xea,0xee,0x00},
    {0xfe,0xba,0xda,0x7e,0xda,0xfa,0xd2,0x00},
    {0xfe,0xa8,0xe8,0x4e,0xfa,0xca,0xee,0x00},
    {0xd8,0xbc,0xe8,0x7e,0xc8,0xd4,0xe2,0x00},
    {0xe4,0xbe,0xf6,0x5e,0xfa,0xd4,0xea,0x00},
    {0xea,0xbe,0xe8,0x4a,0xea,0xd4,0xea,0x00},
    {0xec,0xb4,0xfe,0x5e,0xfa,0xd8,0xee,0x00},
    {0xec,0x4c,0xf6,0x38,0x38,0x50,0xbe,0x00},
    {0xfe,0xb2,0xde,0x72,0xde,0xf4,0xda,0x00},
    {0xec,0xae,0xf4,0x5e,0xec,0xcc,0xf6,0x00},
    {0xfc,0xb4,0xfe,0x52,0xfa,0xda,0xe6,0x00},
    {0xe8,0xbe,0xfa,0x7e,0xc8,0xdc,0xea,0x00},
    {0xe4,0xbe,0xf2,0x5e,0xfe,0xd4,0xfa,0x00},
    {0xe4,0xae,0xe4,0x5e,0xe6,0xd4,0xee,0x00},
    {0xfe,0xea,0xfe,0x48,0xfe,0xdc,0xea,0x00},
    {0xfe,0xbe,0xf4,0x5e,0xf4,0xda,0xee,0x00},
    {0xea,0xbe,0xe4,0x4a,0xfe,0xc4,0xea,0x00},
    {0xe0,0xbe,0xd6,0x7e,0xd6,0xd6,0xe8,0x00},
    {0xdc,0xbe,0xda,0x68,0xfe,0xdc,0xea,0x00},
    {0xe4,0xb8,0xfe,0x5c,0xdc,0xc8,0xfe,0x00},
    {0xf8,0xb4,0xce,0x60,0xda,0xfc,0xda,0x00},
    {0xee,0xa4,0xce,0x6e,0xde,0xea,0xd6,0x00},
    {0xec,0xba,0xc4,0x6a,0xde,0xe4,0xda,0x00},
    {0x10,0xfe,0xaa,0x7c,0xba,0x50,0xbe,0x00},
    {0xd4,0xbe,0xc8,0x7e,0xde,0xd4,0xee,0x00},
    {0xe4,0xaa,0xfc,0x4c,0xe8,0xd6,0xe6,0x00},
    {0xf6,0xa8,0xf6,0x5c,0xf6,0xdc,0xf4,0x00},
    {0xdc,0xaa,0xc0,0x56,0xe2,0xf6,0xfe,0x00},
    {0x04,0x7e,0x54,0x7c,0xba,0x50,0xbe,0x00},
    {0xf4,0xaa,0xf0,0x54,0xf6,0xdc,0xf6,0x00},
    {0xe8,0xbe,0xf4,0x7e,0xec,0xc0,0xea,0x00},
    {0xe8,0xbe,0xe2,0x5c,0xfe,0xc8,0xea,0x00},
    {0xd4,0xbe,0xd4,0x7e,0xfe,0xfe,0xea,0x00},
    {0xfe,0xbe,0xd4,0x7e,0xd4,0xfe,0xc8,0x00},
    {0xfe,0xa8,0xf6,0x6e,0xf4,0xd4,0xea,0x00},
    {0xf4,0xbe,0xf6,0x62,0xfe,0xd4,0xcc,0x00},
    {0xea,0xbe,0xd4,0x7e,0xdc,0xc8,0xf6,0x00},
    {0xdc,0xd4,0xfe,0x6a,0xfe,0xdc,0xea,0x00},
    {0xd4,0xbe,0xdc,0x4c,0xfe,0xdc,0xec,0x00},
    {0xfe,0xea,0xde,0x62,0xda,0xde,0xfa,0x00},
    {0x64,0x6e,0xca,0x7c,0x3c,0x50,0xbe,0x00},
    {0xe8,0xbe,0xd4,0x6a,0xd4,0xdc,0xe4,0x00},
    {0xe8,0xbc,0xfe,0x48,0xfe,0xf4,0xcc,0x00},
    {0xd2,0xa4,0xf6,0x5c,0xdc,0xdc,0xe2,0x00},
    {0xd6,0xae,0xc4,0x7e,0xfe,0xd4,0xec,0x00},
    {0xc8,0xbe,0xec,0x7e,0xf6,0xe8,0xde,0x00},
    {0xf6,0xb6,0xea,0x6e,0xfe,0xee,0xe2,0x00},
    {0xd4,0xbe,0xf6,0x6a,0xfe,0xee,0xe2,0x00},
    {0xfe,0xac,0xfe,0x44,0xf6,0xfe,0xd2,0x00},
    {0x2e,0x72,0x5e,0x78,0xde,0x32,0xd6,0x00},
    {0x44,0xfe,0xa4,0xec,0xb6,0x6c,0xa4,0x00},
    {0x2a,0x7e,0x5e,0x72,0xde,0x34,0xde,0x00},
    {0x5c,0xea,0xb6,0xe8,0xbe,0x7c,0xaa,0x00},
    {0x2a,0x7e,0x5e,0x74,0xde,0x34,0xda,0x00},
    {0x5e,0xf4,0xb6,0xfc,0xbe,0x7c,0xae,0x00},
    {0x44,0xfe,0xbc,0xfe,0xb0,0x7a,0xb6,0x00},
    {0xe8,0x48,0xe8,0xe8,0x48,0xea,0x4e,0x00},
    {0xfe,0x50,0xfe,0xfa,0x5a,0xf8,0x4e,0x00},
    {0x10,0xfe,0x54,0xfe,0x44,0x28,0xc6,0x00},
    {0xd8,0x5c,0xe8,0xfe,0x48,0xd4,0x62,0x00},
    {0xfe,0x42,0xfe,0xf6,0x5e,0xe2,0x46,0x00},
    {0xe8,0x54,0xea,0xe4,0x4a,0xe4,0x58,0x00},
    {0xe6,0x44,0xfe,0xe4,0x5c,0xec,0x5a,0x00},
    {0xfe,0x54,0xfa,0xc8,0x5c,0xc8,0x7e,0x00},
    {0xec,0x54,0xe8,0xf4,0x42,0xec,0x4c,0x00},
    {0xfe,0x4a,0xf4,0xea,0x5e,0xe4,0x5e,0x00},
    {0xfe,0x54,0xdc,0xdc,0x54,0xfc,0x4e,0x00},
    {0xf8,0x5e,0xda,0xda,0x5c,0xfa,0x48,0x00},
    {0xcc,0x54,0xfe,0xea,0x7e,0xd4,0x66,0x00},
    {0xea,0x54,0xea,0xfe,0x5e,0xf6,0x5e,0x00},
    {0xfe,0x54,0xea,0xfe,0x6a,0xd4,0x6a,0x00},
    {0xfe,0x48,0xfe,0xea,0x7e,0xfe,0x6a,0x00},
    {0xfe,0x48,0xfe,0xea,0x7e,0xfe,0x62,0x00},
    {0x44,0xee,0x44,0xaa,0x7c,0xfe,0x10,0x00},
    {0xc8,0x7e,0xdc,0xfe,0x6a,0xc8,0x54,0x00},
    {0xfe,0x4c,0xec,0xe0,0x5e,0xf6,0x5e,0x00},
    {0xf0,0x5e,0xec,0xec,0x54,0xc8,0x76,0x00},
    {0xe8,0x5c,0xfe,0xf2,0x5e,0xf4,0x5a,0x00},
    {0x2e,0xfa,0x70,0xfe,0x6a,0xf4,0x2a,0x00},
    {0xfe,0x62,0xfe,0xec,0x7e,0xf4,0x5a,0x00},
    {0xec,0x5e,0xf6,0xe0,0x4c,0xe6,0x4c,0x00},
    {0xc8,0x7e,0xdc,0xda,0x7e,0xd4,0x4c,0x00},
    {0xc8,0x7e,0xec,0xfe,0x7e,0xe4,0x76,0x00},
    {0xdc,0x7e,0xd4,0xea,0x7e,0xe2,0x6a,0x00},
    {0xc4,0x7e,0xf4,0xf2,0x40,0xf2,0x6e,0x00},
    {0xdc,0x7e,0xea,0xdc,0x48,0xfe,0x6a,0x00},
    {0xda,0x6c,0xda,0xec,0x7e,0xdc,0x6a,0x00},
    {0xfe,0x74,0xfe,0xf4,0x60,0xf4,0x5e,0x00},
    {0xe8,0x4e,0xf8,0xee,0x60,0xec,0x5e,0x00},
    {0x10,0xfe,0x7c,0x28,0xfe,0x7c,0x10,0x00},
    {0x64,0x7e,0x6a,0x5e,0xe4,0x7e,0x64,0x00},
    {0x48,0xfe,0xba,0x7e,0xe8,0x5c,0xaa,0x00},
    {0x74,0xae,0x7a,0x1e,0xf4,0xbe,0xd4,0x00},
    {0x54,0xfe,0xca,0x7e,0xc4,0x7e,0xb4,0x00},
    {0x80,0x00,0xbe,0x00,0xc0,0x40,0xbe,0x00},
    {0x88,0x3e,0xaa,0x3e,0xc8,0x48,0xbe,0x00},
    {0xbe,0x22,0xba,0x3a,0xe2,0x66,0xbe,0x00},
    {0xbe,0x0a,0xb2,0x1e,0xd2,0x5e,0xbe,0x00},
    {0x88,0x3e,0xaa,0x3e,0xea,0x7e,0xbe,0x00},
    {0x94,0x1c,0xae,0x1c,0xd4,0x64,0xbe,0x00},
    {0xbe,0x1a,0xbe,0x16,0xda,0x56,0xbe,0x00},
    {0xbe,0x22,0xbe,0x36,0xfe,0x62,0xbe,0x00},
    {0x82,0x1c,0x90,0x1e,0xd0,0x66,0xbe,0x00},
    {0x88,0x3e,0x94,0x36,0xd4,0x6c,0xbe,0x00},
    {0xbe,0x14,0xbe,0x36,0xe2,0x7e,0xbe,0x00},
    {0x8a,0x3e,0x88,0x2a,0xdc,0x6a,0xbe,0x00},
    {0x9e,0x0a,0x94,0x1e,0xc4,0x5e,0xbe,0x00},
    {0x92,0x3e,0x94,0x26,0xcc,0x5a,0xbe,0x00},
    {0x94,0x2a,0x9c,0x14,0xdc,0x54,0xbe,0x00},
    {0x9c,0x14,0xbe,0x1c,0xc8,0x5c,0xbe,0x00},
    {0xac,0x34,0x9e,0x34,0xd4,0x6a,0xbe,0x00},
    {0x8a,0x3e,0x88,0x1e,0xde,0x5a,0xbe,0x00},
    {0x94,0x22,0x88,0x14,0xee,0x4c,0xbe,0x00},
    {0x9c,0x3e,0x9c,0x2a,0xdc,0x7a,0xbe,0x00},
    {0x88,0x1c,0xbe,0x16,0xe8,0x5e,0xbe,0x00},
    {0x88,0x1c,0xbe,0x14,0xfe,0x48,0xbe,0x00},
    {0x94,0x00,0xbe,0x14,0xfe,0x54,0xbe,0x00},
    {0x9c,0x14,0x9e,0x32,0xda,0x46,0xbe,0x00},
    {0xb6,0x32,0xae,0x3a,0xe4,0x6a,0xbe,0x00},
    {0x88,0x1c,0x94,0x3e,0xc8,0x5c,0xbe,0x00},
    {0x9c,0x22,0x9c,0x3e,0xf6,0x62,0xbe,0x00},
    {0xbe,0x14,0xbe,0x36,0xe2,0x7e,0xbe,0x00},
    {0x88,0x0e,0x9c,0x1c,0xdc,0x62,0xbe,0x00},
    {0xb8,0x14,0xae,0x00,0xda,0x5c,0xbe,0x00},
    {0x88,0x3e,0x88,0x3e,0xf6,0x6a,0xbe,0x00},
    {0x94,0x3e,0x94,0x3e,0xdc,0x7e,0xbe,0x00},
    {0xbe,0x26,0xbc,0x36,0xec,0x56,0xbe,0x00},
    {0x94,0x36,0xba,0x1a,0xec,0x5a,0xbe,0x00},
    {0xbe,0x2c,0xba,0x2c,0xfe,0x6c,0xbe,0x00},
    {0x88,0x1c,0xbe,0x3e,0xd4,0x66,0xbe,0x00},
    {0xf4,0xae,0xd4,0xae,0xa6,0xd6,0x9e,0x00},
    {0xbe,0x3e,0xb6,0x2c,0xfe,0x64,0xbe,0x00},
    {0x9e,0x2a,0x98,0x1a,0xde,0x6a,0xbe,0x00},
    {0x88,0x0e,0xb8,0x3e,0xec,0x5a,0xbe,0x00},
    {0x94,0x3e,0x94,0x3e,0xee,0x7a,0xbe,0x00},
    {0x94,0x3e,0xba,0x1a,0xec,0x5a,0xbe,0x00},
    {0x88,0x14,0x9c,0x3e,0xee,0x54,0xbe,0x00},
    {0x88,0x14,0x9c,0x3e,0xea,0x54,0xbe,0x00},
    {0xbe,0x3e,0xa4,0x16,0xfc,0x56,0xbe,0x00},
    {0x4e,0xfa,0x4c,0xda,0xfa,0x4c,0x68,0x00},
    {0x56,0xfe,0x54,0x76,0x56,0x54,0x74,0x00},
    {0x16,0x66,0x44,0x7e,0x56,0x5c,0xe4,0x00},
    {0xf6,0x56,0x54,0xb6,0x76,0x54,0x74,0x00},
    {0x76,0x56,0xfc,0x26,0x76,0x3c,0xe4,0x00},
    {0x5e,0x8a,0x2c,0x5a,0x8a,0x6c,0x68,0x00},
    {0xfe,0x44,0x7e,0x6a,0x7e,0x60,0xbe,0x00},
    {0x76,0xae,0x04,0x76,0x16,0xfc,0x24,0x00},
    {0xde,0xda,0x6c,0xfa,0x4a,0x6c,0x28,0x00},
    {0x4e,0x7a,0xbc,0x4a,0x7a,0xbc,0x48,0x00},
    {0x76,0x56,0x24,0xfe,0x76,0x74,0x74,0x00},
    {0xde,0xda,0x6c,0x6a,0x6a,0xfc,0x28,0x00},
    {0xae,0x76,0xac,0x06,0xd6,0x7c,0x94,0x00},
    {0xfe,0x44,0xe4,0xe4,0xa4,0xe4,0xec,0x00},
    {0xe8,0x5e,0xfa,0xe8,0xac,0xec,0xf6,0x00},
    {0xee,0x4a,0xe0,0xee,0xaa,0xe4,0xfa,0x00},
    {0xea,0x5e,0xea,0xee,0xaa,0xea,0xee,0x00},
    {0xee,0x44,0xfe,0xe4,0xac,0xf6,0xe4,0x00},
    {0xee,0x4a,0xf4,0xe8,0xbe,0xea,0xee,0x00},
    {0xe4,0x48,0xe4,0xfe,0xaa,0xee,0xea,0x00},
    {0xee,0x4a,0xe6,0xfc,0xae,0xe4,0xee,0x00},
    {0xea,0x5e,0xea,0xfe,0xae,0xea,0xee,0x00},
    {0xe8,0x5e,0xf4,0xf4,0xaa,0xfe,0xe8,0x00},
    {0xea,0x5e,0xea,0xfe,0xbe,0xea,0xea,0x00},
    {0xe8,0x5e,0xe8,0xf6,0xa6,0xec,0xfe,0x00},
    {0xfe,0xca,0xf4,0xaa,0xfe,0x6c,0x7c,0x00},
    {0xe4,0x5e,0xe8,0xee,0xb6,0xec,0xfe,0x00},
    {0xfe,0x4a,0xe4,0xea,0xb4,0xe2,0xec,0x00},
    {0xe8,0x4e,0xf8,0xf6,0xac,0xf6,0xec,0x00},
    {0xea,0x5e,0xfe,0xf2,0xbe,0xec,0xfe,0x00},
    {0xec,0x5e,0xec,0xec,0xbe,0xe0,0xf6,0x00},
    {0xc8,0x7e,0xf6,0xdc,0xfe,0xf4,0xda,0x00},
    {0x2c,0x54,0xfe,0x44,0x7c,0x5c,0xaa,0x00},
    {0xf4,0x24,0xbe,0x2e,0xfe,0x7e,0xae,0x00},
    {0xfe,0x3e,0xa4,0x3e,0xea,0x7e,0xa4,0x00},
    {0x26,0x7a,0xf4,0x7a,0x7e,0x5c,0xbe,0x00},
    {0x5e,0xaa,0xea,0x4a,0xea,0x6a,0xd6,0x00},
    {0x54,0xb4,0xf4,0x54,0xf4,0x54,0xe2,0x00},
    {0x28,0x44,0x10,0xee,0x38,0x54,0xfe,0x00},
    {0x48,0xbe,0xea,0x4a,0xea,0x6a,0xd6,0x00},
    {0x5e,0xaa,0xfa,0x4a,0xee,0x6a,0xd6,0x00},
    {0x7e,0xaa,0xe2,0x54,0xe8,0x54,0xe2,0x00},
    {0x44,0xb4,0xfe,0x56,0xf4,0x72,0xde,0x00},
    {0x48,0xae,0xf2,0x4a,0xe6,0x6a,0xc6,0x00},
    {0x42,0xac,0xe8,0x4e,0xea,0x6a,0xd2,0x00},
    {0x48,0xbc,0xda,0x68,0xca,0x64,0xd8,0x00},
    {0x5e,0xb2,0xfe,0x54,0xf4,0x52,0xe2,0x00},
    {0x7c,0xb4,0xd4,0x7e,0xd4,0x54,0xfe,0x00},
    {0x5e,0xb0,0xfe,0x5a,0xfa,0x54,0xea,0x00},
    {0x44,0xbe,0xf4,0x54,0xf6,0x74,0xda,0x00},
    {0x54,0xbe,0xf4,0x5c,0xf4,0x74,0xdc,0x00},
    {0x5e,0xb0,0xfe,0x52,0xfe,0x70,0xde,0x00},
    {0x44,0xbe,0xe8,0x5a,0xe4,0x6a,0xde,0x00},
    {0x48,0xae,0xf2,0x4e,0xee,0x62,0xc6,0x00},
    {0x44,0xbe,0xf2,0x48,0xee,0x68,0xce,0x00},
    {0x48,0xbe,0xfc,0x58,0xfe,0x6a,0xd6,0x00},
    {0x5e,0xb6,0xf6,0x5e,0xf6,0x76,0xde,0x00},
    {0x48,0xae,0xf2,0x4e,0xee,0x68,0xce,0x00},
    {0x5e,0xa8,0xe8,0x4e,0xfa,0x6a,0xce,0x00},
    {0x56,0xa8,0x7e,0xd2,0x7a,0x5a,0x76,0x00},
    {0x58,0xbc,0xe8,0x7e,0xc8,0x5c,0xea,0x00},
    {0x5c,0xaa,0xfe,0x44,0xee,0x64,0xde,0x00},
    {0x42,0xac,0xfe,0x44,0xee,0x6a,0xce,0x00},
    {0x56,0xa6,0xf6,0x76,0xf6,0x54,0xe4,0x00},
    {0x48,0xbe,0xfc,0x5c,0xea,0x48,0xf6,0x00},
    {0x5c,0xbe,0xdc,0x6a,0xfc,0x56,0xe2,0x00},
    {0x54,0xaa,0xf4,0x5c,0xf4,0x7c,0xd4,0x00},
    {0x54,0xbe,0xe8,0x5e,0xf0,0x70,0xde,0x00},
    {0x7e,0xb4,0xf6,0x62,0xf6,0x54,0xfe,0x00},
    {0x48,0xbe,0xe2,0x5e,0xea,0x58,0xee,0x00},
    {0x48,0xbe,0xf4,0x5c,0xc8,0x6a,0xd8,0x00},
    {0x7e,0xaa,0xfe,0x6a,0xf6,0x7e,0xfe,0x00},
    {0x4a,0xb4,0xea,0x5e,0xfe,0x76,0xde,0x00},
    {0x4a,0xbe,0xe4,0x4a,0xfe,0x64,0xda,0x00},
    {0x5c,0xaa,0xfc,0x4c,0xfe,0x4c,0xd8,0x00},
    {0x7e,0xb4,0xea,0x7e,0xea,0x54,0xea,0x00},
    {0x4a,0xbe,0xe4,0x5e,0xe8,0x6e,0xd2,0x00},
    {0x54,0xbe,0xe4,0x54,0xf6,0x74,0xd6,0x00},
    {0x5a,0xa4,0xfe,0x44,0xf4,0x7c,0xda,0x00},
    {0x76,0xb2,0xe6,0x7e,0xea,0x74,0xea,0x00},
    {0x48,0xbc,0xf4,0x5c,0xfe,0x48,0xfe,0x00},
    {0x44,0xbe,0xe4,0x7c,0xe6,0x7c,0xda,0x00},
    {0x78,0xb4,0xee,0x40,0xfa,0x7c,0xda,0x00},
    {0x54,0xbe,0xd4,0x54,0xfe,0x68,0xfe,0x00},
    {0x54,0xa2,0xdc,0x54,0xe2,0x5c,0xfe,0x00},
    {0x48,0xbe,0xf4,0x5c,0xfe,0x62,0xea,0x00},
    {0x48,0xae,0xec,0x5c,0xfe,0x60,0xd2,0x00},
    {0x48,0xbe,0xf6,0x48,0xd4,0x6e,0xcc,0x00},
    {0x54,0xaa,0xf0,0x4e,0xf4,0x7a,0xde,0x00},
    {0x08,0x7e,0x5c,0x7e,0x9c,0x2a,0x7e,0x00},
    {0x7e,0xba,0xf4,0x4a,0xdc,0x48,0xfe,0x00},
    {0x2e,0xf8,0x6e,0xf4,0xfe,0x54,0xfe,0x00},
    {0x48,0xbe,0xf2,0x4e,0xf4,0x76,0xd6,0x00},
    {0x56,0xba,0xf4,0x5e,0xf2,0x7a,0xd6,0x00},
    {0x54,0xbe,0xd6,0x5c,0xde,0x6c,0xea,0x00},
    {0x5c,0xb4,0xfe,0x7e,0xd4,0x48,0xf6,0x00},
    {0x5e,0xaa,0xe4,0x4a,0xf4,0x62,0xcc,0x00},
    {0x54,0xae,0xf6,0x46,0xee,0x74,0xde,0x00},
    {0x48,0xbc,0xf6,0x5c,0xfe,0x54,0xfa,0x00},
    {0x5e,0xac,0xfe,0x5e,0xe0,0x7a,0xd6,0x00},
    {0x7e,0xbc,0xe0,0x5c,0xd4,0x7e,0xc8,0x00},
    {0x54,0xbe,0xee,0x76,0xde,0x74,0xda,0x00},
    {0x48,0xbc,0xfe,0x76,0xfe,0x54,0xe6,0x00},
    {0x5e,0xac,0xfe,0x4c,0xf6,0x6c,0xcc,0x00},
    {0x48,0xbe,0xd4,0x7e,0xd4,0x48,0xea,0x00},
    {0x7e,0xaa,0xfe,0x52,0xfe,0x74,0xda,0x00},
    {0x54,0xbe,0xf4,0x5e,0xf6,0x6a,0xe2,0x00},
    {0x56,0xbc,0xfe,0x6c,0xfe,0x54,0xfa,0x00},
    {0x56,0xbc,0xfe,0x7c,0xee,0x54,0xfa,0x00},
    {0x6a,0xbc,0xf6,0x5c,0xfe,0x6a,0xfe,0x00},
    {0x76,0xaa,0xf6,0x7e,0xd4,0x68,0xd6,0x00},
    {0xe8,0xce,0xee,0x38,0xfe,0x54,0xfe,0x00},
    {0x48,0xbc,0xfe,0x48,0xfe,0x74,0xcc,0x00},
    {0x48,0xbe,0xec,0x7e,0xec,0x6c,0xd2,0x00},
    {0x5a,0xac,0xda,0x6c,0xfe,0x5c,0xea,0x00},
    {0x48,0xae,0xf8,0x6e,0xec,0x7a,0xd6,0x00},
    {0x4a,0xb4,0xfe,0x56,0xfa,0x5e,0xea,0x00},
    {0x48,0xae,0xf8,0x6e,0xe0,0x6c,0xde,0x00},
    {0x5e,0xa0,0xee,0x4a,0xee,0x68,0xd0,0x00},
    {0x48,0xb4,0xfe,0x5c,0xfe,0x7e,0xea,0x00},
    {0x54,0xbe,0xf6,0x54,0xde,0x74,0xde,0x00},
    {0x5e,0xac,0xfe,0x44,0xf6,0x7e,0xd2,0x00},
    {0x68,0xbe,0xd4,0x6a,0xdc,0x5c,0xe2,0x00},
    {0x54,0xbe,0xd4,0x6a,0xdc,0x5c,0xe2,0x00},
    {0x7e,0xaa,0xfe,0x64,0xd6,0x7c,0xd6,0x00},
    {0x5a,0xbc,0x5a,0xe6,0xfe,0x54,0xfe,0x00},
    {0x76,0xb6,0xfc,0x5e,0xf4,0x48,0xf6,0x00},
    {0xae,0x7a,0xf4,0x7a,0xfe,0x54,0xfe,0x00},
    {0xee,0xaa,0xee,0x82,0xba,0x82,0x86,0x00},
    {0xee,0xaa,0xee,0xba,0x92,0x9a,0x92,0x00},
    {0xee,0xaa,0xee,0x92,0xd6,0xfe,0x82,0x00},
    {0xee,0xee,0x92,0xfe,0xaa,0x92,0xee,0x00},
    {0xee,0xaa,0xee,0x92,0xf6,0xba,0xd6,0x00},
    {0xee,0xaa,0xee,0x82,0xba,0xba,0x92,0x00},
    {0xee,0xee,0x92,0xfe,0xbe,0xb6,0x92,0x00},
    {0xee,0xaa,0xfe,0x92,0xba,0x96,0xba,0x00},
    {0xee,0xee,0x92,0xba,0xfe,0xba,0xfe,0x00},
    {0xee,0xee,0xaa,0xfe,0xaa,0xfe,0xc6,0x00},
    {0xee,0xee,0xba,0xaa,0xfa,0xca,0xfa,0x00},
    {0xee,0xee,0xaa,0xf6,0xaa,0xb6,0xda,0x00},
    {0xee,0xee,0x9a,0xaa,0x9e,0xa6,0xbe,0x00},
    {0xee,0xee,0x92,0xfe,0xbe,0xda,0x8e,0x00},
    {0xee,0xee,0x8a,0xfe,0xea,0x8a,0xe6,0x00},
    {0xee,0xee,0xda,0xbe,0xca,0x96,0xde,0x00},
    {0xee,0x6e,0xda,0x7e,0xca,0xd6,0xde,0x00},
    {0xee,0xee,0xba,0xaa,0xfe,0x92,0xee,0x00},
    {0xee,0xee,0x96,0xba,0xfe,0xba,0xda,0x00},
    {0xee,0xee,0x92,0xfe,0xba,0xba,0xd6,0x00},
    {0xee,0xee,0xd2,0xbe,0xee,0xaa,0xd6,0x00},
    {0xee,0xee,0x9a,0xbe,0xb6,0x9a,0xbe,0x00},
    {0xee,0xee,0xba,0xb2,0xbe,0x86,0xd6,0x00},
    {0xee,0xee,0xa6,0xca,0xfe,0xae,0xca,0x00},
    {0xee,0xee,0xee,0xba,0xba,0xfe,0x92,0x00},
    {0xee,0xee,0xca,0x9e,0xfe,0xaa,0xde,0x00},
    {0xee,0xee,0xea,0xfe,0xd6,0xfe,0xea,0x00},
    {0xc4,0xd8,0x88,0xfe,0xc8,0x88,0x88,0x00},
    {0xde,0xd0,0x9e,0xda,0xda,0x98,0xae,0x00},
    {0xdc,0xc0,0xbe,0xd4,0xd4,0x94,0xa6,0x00},
    {0xe4,0xa4,0xd6,0xb4,0xb4,0xd4,0xbe,0x00},
    {0xc4,0xde,0x96,0xde,0xda,0x94,0xaa,0x00},
    {0xfe,0xa8,0xde,0xb2,0xbe,0xd2,0x9e,0x00},
    {0xe8,0xbe,0xc8,0xae,0xba,0xce,0x8a,0x00},
    {0xee,0xa4,0xde,0xb6,0xba,0xd0,0x9e,0x00},
    {0xee,0xb2,0xc4,0xb6,0xb2,0xd6,0x9e,0x00},
    {0xc8,0xfe,0x9c,0xdc,0xea,0x88,0xb6,0x00},
    {0xcc,0xf4,0xbe,0xd4,0xe4,0x88,0xbe,0x00},
    {0xc8,0xfe,0x9c,0xdc,0xea,0x88,0xb6,0x00},
    {0xe4,0xb6,0xd4,0xbe,0xaa,0xc4,0x98,0x00},
    {0xc8,0xdc,0xbe,0xd4,0xfe,0xa4,0x94,0x00},
    {0xdc,0xc8,0xbe,0xd4,0xfe,0x88,0xbe,0x00},
    {0xf8,0xde,0x9a,0xda,0xdc,0xba,0x88,0x00},
    {0xc8,0xdc,0x94,0xdc,0xfe,0x88,0xbe,0x00},
    {0xd4,0xe2,0x9c,0xd4,0xe2,0x9c,0xbe,0x00},
    {0xec,0xac,0xde,0xb2,0xbe,0xc0,0x92,0x00},
    {0xc8,0xfe,0xaa,0xfe,0xea,0x9c,0xae,0x00},
    {0xc8,0xd4,0xbe,0xea,0xfe,0x94,0xaa,0x00},
    {0xec,0xd2,0xae,0xcc,0xf6,0xac,0xbe,0x00},
    {0xdc,0xea,0x9c,0xce,0xdc,0xb2,0xae,0x00},
    {0xf6,0xa4,0xd8,0xae,0xac,0xc2,0x96,0x00},
    {0xdc,0xdc,0x92,0xe4,0xf6,0x80,0xaa,0x00},
    {0xd6,0xfc,0xae,0xfa,0xee,0xbc,0xae,0x00},
    {0x10,0x7c,0x16,0xfc,0x54,0x38,0xd6,0x00},
    {0x28,0xfc,0x6e,0xbc,0x6a,0x3c,0xaa,0x00},
    {0x28,0x3e,0x68,0xbc,0x28,0x28,0x3e,0x00},
    {0x7a,0x5e,0x7c,0x5e,0x7c,0x5c,0xee,0x00},
    {0x28,0x7e,0xa8,0x3e,0xee,0xba,0x86,0x00},
    {0x4a,0x7e,0xac,0x7e,0x2c,0x5c,0x8e,0x00},
    {0x10,0xfe,0x54,0x9e,0xf4,0x54,0x9e,0x00},
    {0x54,0xfe,0x34,0x5e,0xfe,0x5c,0x6a,0x00},
    {0x2a,0xfe,0x5c,0xae,0xfc,0x7c,0xae,0x00},
    {0x38,0xfe,0xb6,0x28,0x7e,0xa8,0x3e,0x00},
    {0xfa,0xae,0xfc,0xae,0xdc,0xfc,0x8e,0x00},
    {0x38,0xfe,0xb6,0x3e,0xc2,0x38,0x3e,0x00},
    {0x38,0xfe,0xb6,0x7c,0xaa,0x38,0x28,0x00},
    {0x38,0xfe,0xb6,0x4c,0x9e,0x44,0xbe,0x00},
    {0x38,0xfe,0xb6,0x7e,0x88,0x3e,0xaa,0x00},
    {0x38,0xfe,0xb6,0x4c,0x7c,0x28,0xce,0x00},
    {0x38,0xfe,0xb6,0x28,0xfe,0x28,0xf6,0x00},
    {0x38,0xfe,0xb6,0x08,0x8e,0x3c,0xbc,0x00},
    {0x38,0xfe,0xb6,0x28,0xee,0xee,0x48,0x00},
    {0x38,0xfe,0xb6,0x24,0xfe,0x6c,0xb6,0x00},
    {0x38,0xfe,0xb6,0x7c,0xfe,0x10,0xee,0x00},
    {0x38,0xfe,0xae,0x4c,0x74,0x38,0x38,0x00},
    {0x38,0xfe,0xb6,0x38,0xbe,0x08,0xbe,0x00},
    {0x38,0xfe,0xb6,0x56,0xfa,0x74,0x5a,0x00},
    {0x38,0xfe,0xb6,0x7e,0x6a,0xfe,0x64,0x00},
    {0x38,0xfe,0xb6,0xfe,0x6c,0xba,0x48,0x00},
    {0x38,0xfe,0xb6,0x4e,0xae,0x64,0xce,0x00},
    {0x38,0xfe,0xb6,0xcc,0x0e,0xd2,0xda,0x00},
    {0x74,0xee,0xb6,0x04,0xee,0x54,0xfe,0x00},
    {0x38,0xfe,0xb6,0xfe,0xfe,0x54,0xfe,0x00},
    {0x38,0xfe,0xb6,0x7e,0x76,0x58,0xbe,0x00},
    {0x7e,0xf4,0xbe,0x12,0xec,0x54,0xea,0x00},
    {0x5c,0xea,0x40,0xfc,0xee,0xfc,0xa8,0x00},
    {0x50,0x7c,0xfe,0x44,0x7c,0xee,0x48,0x00},
    {0xf4,0x26,0xfa,0xd6,0xf6,0xd4,0xf6,0x00},
    {0xfe,0x2a,0xfe,0xda,0xfe,0xd4,0xfa,0x00},
    {0x7e,0x6e,0x74,0xba,0xfe,0x6c,0x7c,0x00},
    {0xa8,0xfe,0xea,0x4a,0xea,0xea,0x56,0x00},
    {0xbe,0xea,0xe2,0x54,0xe8,0xd4,0x62,0x00},
    {0xbe,0xea,0xfa,0x4a,0xee,0xea,0x56,0x00},
    {0xac,0xe4,0xfe,0x56,0xfa,0xf2,0x56,0x00},
    {0xa8,0xfc,0xf4,0x5e,0xe8,0xe8,0x56,0x00},
    {0xae,0xea,0xee,0x4a,0xee,0xe0,0x5e,0x00},
    {0xa4,0xfe,0xf6,0x5e,0xfa,0xf4,0x4a,0x00},
    {0xa8,0xfe,0xe8,0x5c,0xe8,0xfc,0x4a,0x00},
    {0xbe,0xe4,0xfe,0x56,0xfa,0xf2,0x56,0x00},
    {0xa4,0xee,0xe4,0x5e,0xee,0xe4,0x5e,0x00},
    {0xec,0x4c,0xf6,0x7c,0x38,0xfe,0x10,0x00},
    {0xa8,0xee,0xe8,0x5e,0xec,0xea,0x48,0x00},
    {0xa8,0xfa,0xdc,0x6a,0xfc,0xf4,0x5c,0x00},
    {0xbc,0xf4,0xfc,0x5e,0xf2,0xfa,0x46,0x00},
    {0xb4,0xf4,0xfe,0x5c,0xf4,0xf4,0x5a,0x00},
    {0xbc,0xfe,0xda,0x68,0xfe,0xdc,0x6a,0x00},
    {0xaa,0xfe,0xe4,0x4a,0xfe,0xea,0x4e,0x00},
    {0xaa,0xfe,0xea,0x5e,0xf0,0xf6,0x56,0x00},
    {0xb4,0xee,0xfe,0x4a,0xfe,0xf4,0x5e,0x00},
    {0xbe,0xec,0xec,0x56,0xe8,0xec,0x7e,0x00},
    {0xaa,0xfe,0xec,0x5e,0xf6,0xf4,0x5a,0x00},
    {0x10,0x7c,0x24,0xfe,0x48,0xfe,0x08,0x00},
    {0x5c,0xea,0x60,0xb6,0x52,0xf6,0x5e,0x00},
    {0x28,0x28,0xee,0x28,0xee,0x28,0xfe,0x00},
    {0x10,0xfe,0x6c,0xba,0x7c,0x54,0xbc,0x00},
    {0x10,0xfe,0x6c,0xba,0x6c,0x28,0xfe,0x00},
    {0x10,0x7c,0x28,0xfe,0x38,0x3a,0xce,0x00},
    {0x2e,0xf6,0x5a,0xf0,0x0e,0x6a,0x6e,0x00},
    {0x28,0xfe,0x52,0xfa,0x06,0x6a,0x66,0x00},
    {0x2e,0xf4,0x0e,0x7a,0x5e,0x50,0x9a,0x00},
    {0x5e,0x54,0x8e,0x2a,0x2e,0x50,0xea,0x00},
    {0xfe,0x54,0xae,0x5a,0xfe,0x20,0xfa,0x00},
    {0xfe,0xa4,0xf6,0xd6,0xf6,0xa0,0xfa,0x00},
    {0x2e,0xf4,0x2e,0x7a,0x0e,0x70,0x7a,0x00},
    {0x2e,0x54,0xee,0x2a,0x7e,0x50,0x7a,0x00},
    {0x6e,0xf4,0x7e,0xaa,0x7e,0x50,0x9a,0x00},
    {0xfe,0xb4,0xfe,0x2a,0xfe,0x70,0xaa,0x00},
    {0x2e,0xf4,0x6e,0xfa,0xae,0x90,0xaa,0x00},
    {0xfe,0xb4,0xfe,0xfa,0x0e,0xd0,0xba,0x00},
    {0x2e,0xf4,0xde,0xfa,0x6e,0x70,0xea,0x00},
    {0xfe,0xf4,0x5e,0xaa,0x5e,0xf0,0xaa,0x00},
    {0x2e,0xb6,0xf0,0x6a,0x38,0xfe,0x10,0x00},
    {0x2e,0x34,0xee,0xba,0x8e,0xb0,0xfa,0x00},
    {0x5e,0xf4,0xde,0x5a,0x7e,0xd0,0x7a,0x00},
    {0xfe,0x64,0xfe,0x2a,0xfe,0xf0,0x5a,0x00},
    {0xfe,0x18,0x7c,0x4c,0x74,0x5c,0xba,0x00},
    {0x7e,0xea,0xbe,0xbe,0x6a,0xee,0x3a,0x00},
    {0xf4,0xb8,0xfe,0xf6,0xb6,0xb0,0xde,0x00},
    {0xf6,0xb6,0xfe,0xf0,0xba,0xb0,0xde,0x00},
    {0xfe,0x76,0x7e,0x1e,0xf6,0x36,0xaa,0x00},
    {0xfe,0xb6,0xf6,0xf0,0xbe,0xb4,0xde,0x00},
    {0x5e,0xf6,0x5e,0xbe,0xf6,0x76,0xaa,0x00},
    {0x48,0xbe,0xe8,0xea,0x9e,0xe8,0x8e,0x00},
    {0x44,0xb8,0xc8,0xfe,0x88,0xc8,0xb6,0x00},
    {0x48,0xbe,0xd4,0xe2,0x94,0xc8,0xb6,0x00},
    {0x48,0xbe,0xf2,0xfe,0x9a,0xfe,0x92,0x00},
    {0x5c,0xaa,0xc0,0xc8,0xbe,0xd4,0xba,0x00},
    {0x4a,0xbe,0xe8,0xfe,0x9a,0xfe,0x9a,0x00},
    {0x44,0xaa,0xfe,0xe4,0x9e,0xe4,0x96,0x00},
    {0x4e,0xb2,0xe4,0xf6,0x92,0xf6,0x9e,0x00},
    {0x54,0xbe,0xc8,0xfe,0x90,0xdc,0xa4,0x00},
    {0x4a,0xbe,0xe4,0xea,0x9e,0xe4,0x9a,0x00},
    {0x56,0xa4,0xfa,0xe4,0x96,0xe4,0x9a,0x00},
    {0x54,0xa8,0xfe,0xd4,0xbe,0xd4,0xa4,0x00},
    {0x56,0xbe,0xd6,0xfe,0xae,0xfe,0x8a,0x00},
    {0xf4,0x6a,0xd4,0x38,0xf6,0x28,0x76,0x00},
    {0x48,0xbe,0xea,0xfe,0xaa,0xdc,0xae,0x00},
    {0x4e,0xb6,0xe6,0xfa,0x9c,0xdc,0x9c,0x00},
    {0x5e,0xb6,0xfa,0xfe,0x80,0xec,0x9e,0x00},
    {0x54,0xbe,0xd4,0xfe,0xbe,0xc8,0xbe,0x00},
    {0x5c,0xb4,0xfe,0xfe,0x94,0xc8,0xb6,0x00},
    {0x44,0xbe,0xe4,0xfe,0x92,0xec,0x9e,0x00},
    {0x48,0xbe,0xea,0xfe,0x9c,0xdc,0xa2,0x00},
    {0x52,0xa4,0xd2,0xfc,0x96,0xd4,0xaa,0x00},
    {0x48,0xbc,0xfe,0xf6,0xbe,0xd4,0xa6,0x00},
    {0x76,0xb6,0xe4,0xf6,0x9c,0xc0,0xa2,0x00},
    {0x66,0x6c,0xee,0x3c,0xf6,0x28,0x76,0x00},
    {0x4a,0xfe,0x64,0x6a,0x6e,0x6a,0xbe,0x00},
    {0xa4,0xfe,0x44,0xb4,0xf6,0xa4,0xfa,0x00},
    {0x78,0x2e,0xfc,0x76,0xaa,0x74,0x7a,0x00},
    {0xee,0xc2,0xea,0xca,0xe4,0x24,0xba,0x00},
    {0xbe,0x28,0x3c,0x28,0xbe,0x82,0xaa,0x00},
    {0xe4,0xde,0xea,0xca,0xe4,0x24,0xba,0x00},
    {0xfe,0xd6,0xf6,0xd6,0xfa,0x32,0xbe,0x00},
    {0xe4,0xde,0xf6,0xde,0xec,0x24,0xba,0x00},
    {0xe4,0xde,0xf2,0xc8,0xee,0x28,0xae,0x00},
    {0xe4,0xc4,0xea,0xde,0xe0,0x2e,0xae,0x00},
    {0x2e,0xfa,0x54,0x6a,0xbe,0x02,0xaa,0x00},
    {0xe4,0xde,0xe8,0xd4,0xea,0x24,0xba,0x00},
    {0xe4,0xde,0xea,0xd0,0xea,0x24,0xba,0x00},
    {0xec,0xd4,0xe8,0xd4,0xe2,0x2c,0xac,0x00},
    {0xea,0xca,0xfe,0xde,0xea,0x2a,0xb2,0x00},
    {0xee,0xca,0xee,0xde,0xe4,0x3e,0xa4,0x00},
    {0xec,0xc6,0xec,0xde,0xfa,0x24,0xba,0x00},
    {0xe4,0xce,0xee,0xde,0xe8,0x2e,0xa2,0x00},
    {0xea,0xde,0xea,0xce,0xfe,0x20,0xb2,0x00},
    {0xf4,0xde,0xf4,0xde,0xf4,0x34,0xbe,0x00},
    {0xea,0xc0,0xfe,0xca,0xfe,0x2a,0xb2,0x00},
    {0xfe,0xca,0xee,0xc8,0xee,0x3e,0xaa,0x00},
    {0x10,0xfe,0xaa,0x7c,0xbe,0x02,0xaa,0x00},
    {0xee,0xca,0xe4,0xda,0xee,0x2c,0xbe,0x00},
    {0xfe,0xdc,0xfc,0xd0,0xf6,0x36,0xbe,0x00},
    {0xf4,0xfa,0xd4,0xfe,0xea,0x24,0xb8,0x00},
    {0x28,0xfe,0x7c,0xaa,0x3e,0x02,0xaa,0x00},
    {0xfe,0xdc,0xfc,0xc0,0xfe,0x28,0xaa,0x00},
    {0xfe,0xea,0xfe,0xd0,0xfe,0x28,0xaa,0x00},
    {0xdc,0xfe,0xd4,0xea,0xfe,0x22,0xaa,0x00},
    {0xe8,0xdc,0xfe,0xf6,0xfe,0x2c,0xb6,0x00},
    {0xfe,0xde,0xe4,0xde,0xea,0x3e,0xa4,0x00},
    {0xe8,0xd4,0xfe,0xea,0xfe,0x34,0xaa,0x00},
    {0xfe,0xda,0xec,0xda,0xe8,0x3c,0xaa,0x00},
    {0xe8,0xce,0xf8,0xee,0xe0,0x2c,0xbe,0x00},
    {0xec,0xde,0xec,0xde,0xfe,0x2c,0xb2,0x00},
    {0xe8,0xfe,0xf6,0xdc,0xfe,0x34,0xba,0x00},
    {0xf4,0xfe,0xf6,0xd4,0xfe,0x34,0xbe,0x00},
    {0x7c,0x50,0x7e,0xaa,0x7c,0x7e,0xda,0x00},
    {0xf6,0xea,0xfe,0xec,0xfe,0x24,0xb6,0x00},
    {0x7e,0x54,0xf4,0x9e,0x74,0x74,0x54,0x00},
    {0x7e,0x5a,0xf0,0x9e,0x7a,0x74,0x5a,0x00},
    {0x76,0x5a,0xf4,0x9a,0x70,0x76,0x56,0x00},
    {0x68,0x7e,0xfa,0xbe,0x6c,0x7e,0x64,0x00},
    {0x68,0x7c,0xf6,0xbc,0x7e,0x74,0x7a,0x00},
    {0x7e,0x76,0xee,0xb2,0x6e,0x6e,0x7a,0x00},
    {0x74,0x6e,0xf4,0xae,0x66,0x76,0x7e,0x00},
    {0x6a,0x7e,0xfe,0xb2,0x7e,0x6c,0x7e,0x00},
    {0x5c,0xf4,0x7e,0x6a,0xfe,0xfc,0xaa,0x00},
    {0x72,0x44,0x72,0x44,0xf8,0x52,0xec,0x00},
    {0x72,0x44,0xf2,0x74,0x3e,0xec,0x3e,0x00},
    {0x72,0x44,0xf2,0x74,0xfe,0x1c,0x64,0x00},
    {0x72,0x44,0xf2,0x74,0x3e,0xf0,0x1e,0x00},
    {0x72,0x44,0xf2,0x7c,0x54,0xfe,0x44,0x00},
    {0x72,0x44,0xf2,0x7e,0x22,0xdc,0x1c,0x00},
    {0x72,0x44,0xf2,0x7e,0x14,0x28,0xd6,0x00},
    {0x72,0x44,0xfa,0x7c,0x68,0x3e,0xca,0x00},
    {0x72,0x44,0xf2,0x3e,0xc2,0x38,0x3e,0x00},
    {0x72,0x44,0xf2,0x24,0xfe,0xaa,0xfe,0x00},
    {0x72,0x44,0xf2,0x7c,0x10,0x7c,0x7c,0x00},
    {0x72,0x44,0xf0,0x7a,0xf4,0x7a,0xae,0x00},
    {0x72,0x44,0xfa,0x7c,0x6c,0x10,0xee,0x00},
    {0x72,0x44,0xf2,0x5e,0x8c,0x4c,0x92,0x00},
    {0x72,0x44,0xf2,0x3c,0xfe,0x68,0xb6,0x00},
    {0x72,0x44,0xfe,0xba,0x7c,0x3c,0xc6,0x00},
    {0x72,0x44,0xf2,0x7c,0x7c,0x54,0xea,0x00},
    {0xee,0xc6,0xee,0x82,0x82,0x82,0x86,0x00},
    {0xee,0xc6,0x92,0xfe,0xbe,0xb6,0x92,0x00},
    {0xee,0xc6,0xaa,0xfe,0xaa,0xfe,0xc6,0x00},
    {0xee,0xc6,0xaa,0xca,0xfa,0xb2,0xda,0x00},
    {0xee,0xc6,0x82,0xf6,0xde,0xa6,0xf6,0x00},
    {0xee,0xc6,0x9a,0xea,0xba,0xba,0x9e,0x00},
    {0xd6,0xaa,0xd6,0xfe,0x78,0x42,0x3e,0x00},
    {0xfe,0x44,0x7c,0xfe,0xaa,0xde,0x92,0x00},
    {0x48,0xfe,0xba,0xfe,0xbe,0xec,0x16,0x00},
    {0x4a,0xfe,0xe8,0xea,0x74,0x6a,0xbe,0x00},
    {0x68,0xfe,0x7a,0xae,0xfe,0x6c,0xd6,0x00},
    {0x5e,0xfa,0xf6,0xfa,0x7e,0x72,0xbe,0x00},
    {0x5e,0xe4,0xfe,0xf6,0x76,0x7a,0xbe,0x00},
    {0x44,0xfe,0xec,0xec,0x7e,0x76,0xbe,0x00},
    {0x7e,0x6e,0x74,0x7a,0xac,0x3c,0xce,0x00},
    {0x64,0xbe,0x68,0x6e,0x6a,0x0a,0xb6,0x00},
    {0x68,0xae,0x78,0x6e,0x68,0x0e,0xa8,0x00},
    {0x7e,0xac,0x76,0x64,0x7e,0x04,0xa4,0x00},
    {0x68,0xae,0x72,0x6e,0x6e,0x08,0xae,0x00},
    {0x7e,0xa8,0x68,0x6e,0x7a,0x0a,0xae,0x00},
    {0x6c,0xb4,0x68,0x76,0x68,0x00,0xac,0x00},
    {0x68,0xbe,0x6a,0x7e,0x74,0x0c,0xb2,0x00},
    {0x6c,0xb4,0x7e,0x7e,0x7a,0x18,0xae,0x00},
    {0x6a,0xac,0x6a,0x6e,0x60,0x0e,0xae,0x00},
    {0x74,0xbe,0x74,0x7e,0x7e,0x14,0xb4,0x00},
    {0x7e,0xa8,0x70,0x6a,0x7e,0x08,0xaa,0x00},
    {0x88,0x2a,0x8c,0x30,0xfc,0x7c,0xaa,0x00},
    {0x74,0xaa,0x74,0x7c,0x74,0x1c,0xb4,0x00},
    {0x6a,0xbe,0x68,0x7e,0x7a,0x1e,0xba,0x00},
    {0x7a,0xae,0x7e,0x6e,0x7a,0x1a,0xaa,0x00},
    {0x74,0xa8,0x74,0x7e,0x68,0x1e,0xaa,0x00},
    {0x6e,0xa4,0x7e,0x76,0x7e,0x16,0xb6,0x00},
    {0x7e,0xb2,0x7e,0x68,0x6e,0x16,0xaa,0x00},
    {0x68,0xb6,0x7a,0x72,0x7e,0x0c,0xb6,0x00},
    {0x7e,0xa2,0x7e,0x64,0x76,0x24,0xb6,0x00},
    {0x6a,0xb4,0x6a,0x7e,0x7e,0x16,0xbe,0x00},
    {0xd4,0x76,0xd4,0xf6,0xd4,0x36,0xa4,0x00},
    {0xd4,0x7a,0xd4,0xfe,0xea,0x04,0xb8,0x00},
    {0xd4,0x7a,0xd0,0xdc,0xda,0x2c,0xaa,0x00},
    {0x64,0xa6,0x7c,0x76,0x70,0x1c,0xb6,0x00},
    {0x68,0xb4,0x6e,0x7c,0x64,0x12,0xae,0x00},
    {0x76,0xb2,0x66,0x7e,0x6a,0x34,0xaa,0x00},
    {0x64,0xbe,0x64,0x7c,0x66,0x3c,0xba,0x00},
    {0x64,0xae,0x6a,0x6e,0x7e,0x04,0xbe,0x00},
    {0x7e,0xaa,0x7e,0x7e,0x60,0x12,0xae,0x00},
    {0x6c,0xb2,0x7e,0x6c,0x7e,0x1e,0xbe,0x00},
    {0x68,0xbe,0x6c,0x7e,0x74,0x0e,0xac,0x00},
    {0x6a,0xbe,0x6e,0x60,0x7e,0x1c,0xaa,0x00},
    {0x70,0xbe,0x6c,0x6c,0x74,0x08,0xb6,0x00},
    {0x68,0xbe,0x7e,0x7e,0x68,0x1c,0xaa,0x00},
    {0x64,0xbe,0x7c,0x74,0x6e,0x34,0xaa,0x00},
    {0x7e,0xb6,0x7a,0x7e,0x60,0x0c,0xbe,0x00},
    {0x7e,0xb2,0x7e,0x60,0x7c,0x1c,0xbe,0x00},
    {0x7e,0xbe,0x68,0x74,0x6a,0x1c,0xaa,0x00},
    {0x6e,0xb4,0x7e,0x6e,0x7e,0x3e,0xa4,0x00},
    {0x68,0xb6,0x76,0x7a,0x60,0x0c,0xac,0x00},
    {0xf4,0x4e,0xfa,0xde,0xfa,0x3e,0x94,0x00},
    {0xc4,0x7e,0xee,0xec,0xfa,0x2c,0x9a,0x00},
    {0x26,0x6a,0xf4,0x6a,0xfc,0x7c,0xaa,0x00},
    {0x64,0xbe,0x6a,0x7e,0x6c,0x1e,0xa4,0x00},
    {0x7e,0xac,0x6c,0x60,0x7e,0x08,0xaa,0x00},
    {0xc8,0x7e,0xdc,0xd4,0xfe,0x14,0xbc,0x00},
    {0x68,0xb4,0x7e,0x6a,0x7e,0x14,0xbc,0x00},
    {0x6a,0xbe,0x7e,0x72,0x7e,0x0c,0xbe,0x00},
    {0xd4,0x7e,0xc8,0xfe,0xdc,0x3a,0x94,0x00},
    {0x68,0xae,0x78,0x6e,0x60,0x2c,0xbe,0x00},
    {0x10,0x78,0x78,0x7e,0xaa,0x3c,0xc6,0x00},
    {0x10,0x78,0x7e,0x02,0x38,0x2a,0xce,0x00},
    {0x08,0xdc,0x5c,0x50,0xbe,0x82,0x2a,0x00},
    {0xf4,0xae,0xae,0xf8,0x6e,0xa2,0x6a,0x00},
    {0x7e,0x54,0x6c,0x6c,0x6e,0x62,0xaa,0x00},
    {0x7e,0x48,0x5c,0x5c,0x5e,0x42,0xaa,0x00},
    {0x44,0xee,0xe6,0x9e,0xe4,0x24,0xba,0x00},
    {0x44,0xfe,0xde,0x48,0x6e,0x62,0xb6,0x00},
    {0x24,0xfe,0x8e,0x58,0x5e,0x52,0x8a,0x00},
    {0x10,0x7c,0xfe,0x74,0xbe,0x02,0xaa,0x00},
    {0xaa,0x44,0xfe,0xba,0x3e,0x02,0xaa,0x00},
    {0x48,0xfc,0x5c,0xf0,0xbe,0xe2,0x16,0x00},
    {0x14,0xee,0xae,0xf8,0xae,0x92,0xea,0x00},
    {0xf4,0x2e,0x5e,0xf8,0x6e,0x32,0xca,0x00},
    {0x44,0xde,0xd2,0x88,0xee,0x28,0xae,0x00},
    {0x44,0xae,0xee,0x08,0xee,0x62,0x4a,0x00},
    {0x24,0xfe,0x5e,0x88,0x5e,0x22,0xda,0x00},
    {0x44,0xae,0xee,0x08,0xee,0xa2,0xea,0x00},
    {0x44,0x9e,0xfe,0x78,0xae,0xf2,0x2a,0x00},
    {0x56,0xb0,0x76,0xe2,0x7a,0x4a,0x6a,0x00},
    {0xf4,0x5e,0x7e,0x78,0x5e,0xf2,0x1a,0x00},
    {0x34,0xde,0xfe,0x58,0x5e,0xf2,0x5a,0x00},
    {0x6a,0xfe,0x64,0xfa,0x3e,0x02,0xaa,0x00},
    {0x64,0xae,0x7e,0x78,0x7e,0x52,0xba,0x00},
    {0x64,0x6e,0x0e,0xf8,0x9e,0xf2,0x9a,0x00},
    {0xf4,0x2e,0x7e,0x78,0xae,0x32,0xca,0x00},
    {0xe4,0xae,0xee,0xa8,0xee,0x02,0xaa,0x00},
    {0x54,0xfe,0x5e,0xf8,0x7e,0x52,0x7a,0x00},
    {0x24,0xfe,0x5e,0x78,0x3e,0xe2,0x2a,0x00},
    {0x24,0xfe,0x7e,0x78,0x2e,0x72,0xaa,0x00},
    {0x24,0xfe,0xfe,0xf8,0x2e,0x72,0xaa,0x00},
    {0x44,0xfe,0xde,0xf8,0x6e,0xf2,0x2a,0x00},
    {0x24,0xfe,0x4e,0x78,0xde,0x62,0x56,0x00},
    {0xd4,0xde,0x6e,0xf8,0x4e,0x62,0x2a,0x00},
    {0xf4,0xbe,0xfe,0x68,0x6e,0xf2,0x2a,0x00},
    {0x76,0xea,0x74,0xba,0x3e,0x02,0xaa,0x00},
    {0x54,0x8e,0x46,0xfc,0xae,0x7a,0xaa,0x00},
    {0x74,0xae,0x4e,0x28,0xfe,0x22,0xd6,0x00},
    {0x64,0x9e,0x6e,0x68,0x9e,0x62,0xf6,0x00},
    {0x74,0x5e,0xfe,0x88,0x7e,0x72,0x5a,0x00},
    {0xf4,0x5e,0xfe,0xa8,0xfe,0x52,0xfa,0x00},
    {0xd4,0x2e,0xde,0x78,0xde,0x72,0x5a,0x00},
    {0x44,0x7e,0x6e,0xe8,0xfe,0x02,0x96,0x00},
    {0x24,0xfe,0x6e,0x68,0xfe,0x02,0x96,0x00},
    {0x64,0xae,0x4e,0xf8,0x2e,0xb2,0xfa,0x00},
    {0x28,0x7c,0xec,0x76,0x3e,0x02,0xaa,0x00},
    {0x24,0xfe,0xae,0xf8,0xbe,0x82,0xda,0x00},
    {0x74,0xfe,0x6e,0xa8,0xfe,0xd2,0xba,0x00},
    {0x54,0x7e,0xee,0x68,0x7e,0x02,0xaa,0x00},
    {0xf4,0x5e,0xfe,0x78,0xae,0x72,0x7a,0x00},
    {0x24,0xfe,0x5e,0xf8,0x5e,0x22,0xaa,0x00},
    {0x2c,0x54,0xfe,0xba,0x3e,0x02,0xaa,0x00},
    {0xda,0xde,0xae,0x48,0xfe,0x52,0xea,0x00},
    {0x54,0xfe,0xde,0x58,0x7e,0xd2,0x7a,0x00},
    {0x5a,0xbc,0x5a,0xe6,0x7e,0x02,0xaa,0x00},
    {0x10,0x1e,0x7c,0x56,0x6a,0x56,0x7e,0x00},
    {0x44,0x7e,0xd4,0xbc,0xb6,0xbc,0xfa,0x00},
    {0xe8,0xce,0xde,0xee,0x7c,0x54,0xfe,0x00},
    {0x38,0xc8,0x7e,0x54,0x7e,0x64,0xb6,0x00},
    {0x08,0x7e,0x5c,0x64,0x76,0x5c,0xbe,0x00},
    {0x08,0x7e,0x6c,0xbe,0x7c,0x38,0xd6,0x00},
    {0x08,0x7e,0x6c,0xbe,0x5c,0x7c,0xc6,0x00},
    {0x4a,0xfe,0xaa,0xee,0xde,0xe0,0x92,0x00},
    {0x08,0x7e,0x6c,0xbe,0x7c,0x74,0x7c,0x00},
    {0x08,0x7e,0x6c,0x9e,0x24,0x3c,0xc6,0x00},
    {0x08,0x7e,0x6c,0xbe,0x72,0x5a,0xb6,0x00},
    {0x10,0xfe,0x54,0xaa,0x5c,0x28,0x54,0x00},
    {0x24,0xfe,0x64,0xbe,0x54,0xaa,0x5e,0x00},
    {0x44,0xee,0x44,0x6e,0xa4,0x4a,0xbe,0x00},
    {0x2e,0xf4,0x6e,0xbe,0x52,0xa6,0x5e,0x00},
    {0x24,0xf6,0x6a,0xb6,0x56,0xa4,0x5e,0x00},
    {0x08,0x7e,0x54,0x7e,0x54,0x76,0xa4,0x00},
    {0x2c,0x54,0xfe,0xaa,0x7c,0x38,0xc6,0x00},
    {0x68,0xfe,0x6a,0xb6,0x28,0xfe,0x54,0x00},
    {0x64,0xf4,0x66,0xb4,0xfe,0x7a,0xae,0x00},
    {0x64,0xfe,0x6c,0xbc,0xfe,0x7e,0xaa,0x00},
    {0xe8,0xf4,0xee,0x40,0xfe,0x04,0xa8,0x00},
    {0xe4,0xf6,0xfe,0x44,0xf6,0x16,0xbe,0x00},
    {0xe8,0xe8,0xee,0x48,0xfe,0x12,0xbe,0x00},
    {0xd4,0xde,0xe6,0x56,0xe6,0x2a,0xba,0x00},
    {0xe4,0xfe,0xe4,0x4e,0xe0,0x0e,0xae,0x00},
    {0xe4,0xfe,0xea,0x4e,0xe4,0x16,0xac,0x00},
    {0x54,0xfe,0xba,0x6c,0xfe,0x00,0xaa,0x00},
    {0xe8,0xfe,0xf4,0x5e,0xe0,0x0c,0xac,0x00},
    {0x54,0xbe,0x7e,0xd6,0x7e,0x44,0x6a,0x00},
    {0x7e,0x6e,0x74,0xba,0x38,0xfe,0xaa,0x00},
    {0xe8,0xfe,0xf6,0x5e,0xfc,0x1c,0xa2,0x00},
    {0xaa,0xfe,0x54,0x92,0x7c,0x7c,0x54,0x00},
    {0xaa,0x5e,0xe8,0x4a,0xea,0xf4,0xaa,0x00},
    {0xaa,0x5e,0xe8,0x5e,0xfa,0xfe,0xba,0x00},
    {0x7c,0x6c,0x28,0xee,0xee,0x28,0x3e,0x00},
    {0x26,0x6a,0xf4,0x7e,0xec,0x6c,0x3e,0x00},
    {0x56,0xaa,0x74,0x7a,0x6c,0x6c,0x3e,0x00},
    {0x44,0xfe,0x56,0xbe,0xda,0x74,0xda,0x00},
    {0x44,0xfe,0x6c,0xf6,0x38,0xe6,0x10,0x00},
    {0x54,0x08,0x7c,0x54,0x7c,0x54,0x96,0x00},
    {0x44,0xbe,0x9e,0xfe,0xde,0xb0,0xde,0x00},
    {0x2e,0x74,0x54,0xfe,0xb4,0xf4,0x54,0x00},
    {0x10,0xfe,0x6c,0xba,0x44,0x7c,0x84,0x00},
    {0x10,0x5e,0xfc,0x56,0x6a,0x56,0x7e,0x00},
    {0x28,0xb8,0xea,0xdc,0xb8,0xda,0xfe,0x00},
    {0x24,0xb6,0xea,0xd6,0xb6,0xd2,0xf6,0x00},
    {0x2e,0xba,0xee,0xda,0xbe,0xda,0xfe,0x00},
    {0x2e,0xb6,0xea,0xd0,0xbe,0xda,0xfe,0x00},
    {0x24,0xba,0xee,0xd0,0xbe,0xd6,0xf4,0x00},
    {0x2e,0xba,0xee,0xda,0xbe,0xdc,0xfa,0x00},
    {0x4e,0xe6,0x6a,0xfe,0x56,0x6a,0x7e,0x00},
    {0x2e,0xb4,0xee,0xd6,0xb0,0xd6,0xf6,0x00},
    {0x2e,0xba,0xee,0xd4,0xb6,0xdc,0xf6,0x00},
    {0x5e,0x7e,0xd4,0xb8,0xde,0xb4,0xfe,0x00},
    {0x26,0xbc,0xec,0xdc,0xbe,0xde,0xfa,0x00},
    {0x2a,0xba,0xec,0xbe,0xd4,0xb6,0xf2,0x00},
    {0x10,0xee,0x3c,0xfa,0x56,0xfc,0x56,0x00},
    {0x38,0xc8,0x7c,0xee,0x6e,0xec,0x3e,0x00},
    {0x10,0x28,0xfe,0xaa,0xfe,0x7c,0x54,0x00},
    {0x10,0x7c,0xfe,0x6c,0xfe,0x28,0xce,0x00},
    {0x50,0xde,0x4c,0xec,0xfe,0x40,0x62,0x00},
    {0x8c,0x14,0x88,0x1e,0xe4,0x56,0xbe,0x00},
    {0x0c,0xf4,0x48,0xde,0x64,0xd6,0x1e,0x00},
    {0x88,0x3e,0x14,0x1c,0xbe,0x9c,0xaa,0x00},
    {0xf6,0xa6,0xd6,0xa4,0xf6,0x00,0xaa,0x00},
};
