#include "mbed.h"
#include "NokiaLCD.h"
#include "SDFileSystem.h"

NokiaLCD lcd1(p11, p13, p14, p15, NokiaLCD::LCD3300); // mosi, sclk, cs, rst, type
//NokiaLCD lcd1(p11, p13, p14, p15, NokiaLCD::PCF8833); // mosi, sclk, cs, rst, type
SDFileSystem sd(p5, p6, p7, p8, "sd");
char filename[20] = "/sd/icons/01d.bmp";

int PrintIcon(int px, int py)
{
    FILE *fs;
    int i;
    char    header[54];
    int rgb;
    unsigned char datr,datg,datb;
           
    printf( "Weather icons access [%s]\r\n",filename);
    if ( NULL == (fs = fopen(filename, "rb" )) ) {
        printf( "file open error when oening file ");
        return -1;
    }
    printf( "file Open OK.\r\n");
  
    //bitmap headder throw  
    for (i=0;i<0x36;i++)
        fread(&header, sizeof(unsigned char), 1, fs);
          
        
    for(int y=50;y>0;y--){
        for(int x=0;x<60;x++){       
            fread(&datb, sizeof(unsigned char), 1, fs);
            fread(&datg, sizeof(unsigned char), 1, fs);
            fread(&datr, sizeof(unsigned char), 1, fs);
            
            datb = (0xF0&datb)>>4;
            datg = (0xF0&datg)>>4; 
            datr = (0xF0&datr)>>4;
                        
            rgb = (datr <<20) | (datg<<12) | (datb<<4);
            lcd1.pixel(px+x,py+y,rgb);
            
        }
    }
    
    fclose(fs);   
    return 0;
}

int main() {
    int r,g,b;

    lcd1.background(0x00000000);
    lcd1.cls();
    b = 0x000000F0 ; 
    g = 0x0000F000 ;
    r = 0x00F00000 ;
    
    lcd1.fill( 0, 0,130,10 , r ) ; 
    lcd1.fill( 0,10,130,10 , g );
    lcd1.fill( 0,20,130,10 , b );
//    lcd1.fill( 0,10,130,10 , b|r ); // purple
//    lcd1.fill( 0,20,130,10 , b|g ); // cyan

    lcd1.locate(0,4);
    lcd1.printf("Hello NokiaLCD");
    
    PrintIcon(0,70);
    
}
