#include "mbed.h"
#include "TextLCD.h"

void slideMessage(char* ,double ,int );
//slideMessage(message, slidetime, row )
 
TextLCD lcd(p24,p26,p27,p28,p29,p30);
#define SIZE 16
// I don't test TextLCD 20x ... 16x2B

int main() {
    static char msg[] = "1234567890123456" ;
    static char msg1[] = "Welcome to mbed! mbed is a tool for Rapid Prototyping with Microcontrollers." ;
    static char msg2[] = "abcdefghijklmnop" ;
    
    slideMessage(msg1,0.5,0);
    return 0 ;
}

void slideMessage(char msg[], double time,int row)
{
    int j, k ;   
    int len = ( strlen(msg) ) ;
        
    lcd.cls();
 
    while(1){  // <= Debug ha while wo comment nisuru
        printf("[len:%d  :: %s]",len,msg); // <= Debug
        printf("----- first loop -----\r\n"); // <= Debug        
        for (j = SIZE -1  ; j>=0 ; j-- ){
            printf("(%2d)",j); // <= Debug
            for ( k = j ; k < SIZE ; k++ ){
                lcd.locate(k,row);
                if ( len  > (k - j) ){
                    lcd.printf("%c",msg[k-j]) ;
                    printf("[%2d:%c]",k,msg[k-j]); // <= Debug
                }else{
                    lcd.printf(" ") ;
                    printf("[%2d:*]",k); // <= Debug
                }       
            }
            wait(time) ;
            printf("\r\n"); // <= Debug
        }
        printf("----- second loop -----\r\n"); // <= Debug
        for ( j = 1 ; j <= len  ; j++ ){
            printf("(%2d)",j); // <= Debug
            for ( k = 0; k < SIZE ; k++ ){
                lcd.locate(k,row) ;
                if( ( k + j ) < len ){
                    lcd.printf("%c",msg[k+j]) ;
                    printf("[%2d:%c]",k,msg[k+j]); // <= Debug
                }else{
                    lcd.printf(" ") ;
                    printf("[%2d:*]",k); // <= Debug
                }    
            }
            wait(time) ;
            printf("\r\n"); // <= Debug
        }    
    }   // <= Debug ha kokomo comment ni suru.
}