// -- InformEmail --
#include "mbed.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "SimpleSMTPClient.h"
#include "TextLCD.h"

#define DOMAIN "mbed"
#define SERVER "smtp.mail.yahoo.co.jp"
#define PORT "587" //25 or 587(OutBound Port25 Blocking )

#define USER "yahoo-japan-ID" 
#define PWD "password"
#define FROM_ADDRESS "yahoo-japan-ID@yahoo.co.jp"
// TO_ADDRESS (Of some address is possible.)
// to-user1@domain, to-user2@domain, to-user3@domain ....
// The TO_ADDRESS are less than 128 characters.
#define TO_ADDRESS "to-address@domain" 

#define SUBJECT "Notice of the detection log"

#define INIT 5.0
#define NOISE 3.0
#define DELAY 10.0
#define INTERVAL 3600

TextLCD lcd(p24, p26, p27, p28, p29, p30);
DigitalOut led1(LED1); 
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalIn msensor(p20);
int cnt,flag,flag1;

void emailsendInterval(void const *args)
{
   while (true) {
        led1 = !led1;
        Thread::wait(1000);
        cnt++; 
        if ( cnt == INTERVAL ){ 
            cnt = 0;
            flag = 1;
        }    
    }
}

void lcdUpdate(void const *args)
{
    char lcdMsg[16];
    while(true){    
        Thread::wait(30000);
        time_t ctTime = time(NULL)+32400; 
        strftime(lcdMsg,16,"%y/%m/%d %H:%M",localtime(&ctTime));
        lcd.locate(0,0);
        lcd.printf("[%s]",lcdMsg);
    }   
}

void flip(void const *args) {
   while (true) {
        led1 = !led1;
        Thread::wait(200);
    }
}

int main()
{
    SimpleSMTPClient smtp;
    EthernetInterface eth;
    
    char sendMsg[512]="";
    char strTimeMsg[16];
    int ret;
    flag1 = 0;
    
    lcd.cls();
    printf("\n\n/* Inform Email System */\n");

    printf("Setting up ...\n");
    eth.init();    
    eth.connect();

    printf("Connected OK\n");    
    
    printf("IP Address is %s\n", eth.getIPAddress());
    lcd.locate(0,1);
    lcd.printf("%s", eth.getIPAddress());    

    printf("NTP setTime...\n");
    NTPClient ntp;
    ntp.setTime("ntp.nict.jp");
    
    time_t ctTime = time(NULL)+32400;   
    printf("\nTime is now (JST):%s\n", ctime(&ctTime));
    strftime(strTimeMsg,16,"%y/%m/%d %H:%M",localtime(&ctTime));
    lcd.locate(0,0);
    lcd.printf("[%s]",strTimeMsg);    
 
    led1 = 1;    
    Thread thread0(flip);
    wait(INIT);    
    thread0.terminate();    
    led1=0;
   
   
    Thread thread(emailsendInterval);
    Thread thread1(lcdUpdate);
         
    smtp.setFromAddress(FROM_ADDRESS);
    smtp.setToAddress(TO_ADDRESS);
    smtp.setMessage(SUBJECT,sendMsg);  
    
    while(1)
    {
        led2 = msensor;
        if ( led2 == 1 ){
            wait( NOISE );
            led2 = msensor;

            while ( led2 == 1 ){    
                led3 = 1;                     
                wait( DELAY ) ;
                led2 = msensor;
                if ( flag1 == 0 ){
                    ctTime = time(NULL)+32400; // JST
                    strftime(strTimeMsg,16,"%m/%d %H:%M\r\n",localtime(&ctTime));
                    smtp.addMessage(strTimeMsg);
                    printf("[%s]",strTimeMsg);
                }
                flag1 = 1;
            }
            flag1 = 0;
            led3 = 0;
        }
        if ( flag == 1 ) {      
            if ( smtp.msgLength() != 0 ){
                ret = smtp.sendmail(SERVER, USER, PWD, DOMAIN, PORT,SMTP_AUTH_LOGIN);
                smtp.clearMessage();
                if (ret) {       
                    printf("E-mail Transmission Error\r\n");
                } else {
                    printf("E-mail Transmission OK\r\n");  
                }
            }
            flag = 0;        
        }              
    }
}

