#include "mbed.h"
#include "TextLCD.h"
// #include "math.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
AnalogIn in(p20);
AnalogOut out(p18);
Ticker input;
Ticker output;
int freq;
double t = 0.0 ;
float d11 = 0.0, d12 =0.0 ;

void run(){
    float data ;
    
    data = in;
    lcd.locate(3,0);
    
    if ( data < 0.1212){
        freq = 0;
        lcd.putc(0xFE);
        lcd.putc(0xFE);
    }else if ( data < 0.181){
        freq = 2093;
        lcd.putc(0xC4);
        lcd.putc(0xDE);      
    }else if ( data < 0.242){
        freq = 1976;
        lcd.putc(0xBC);
        lcd.putc(0xFE);  
    }else if ( data < 0.333){
        freq = 1760;
        lcd.putc(0xD7);
        lcd.putc(0xFE);  
    }else if ( data < 0.394){
        freq = 1568;
        lcd.putc(0xBF);
        lcd.putc(0xFE); 
    }else if ( data < 0.485){  
        freq = 1397;
        lcd.putc(0xCC);
        lcd.putc(0xA7);                   
    }else if ( data < 0.697 ){
        freq = 1319;
        lcd.putc(0xD0);
        lcd.putc(0xFE);  
    }else if ( data < 0.85){    
        freq = 1175;
        lcd.putc(0xDA);
        lcd.putc(0xFE);
    }else{
        freq = 1046;
        lcd.putc(0xC4);
        lcd.putc(0xDE);    
    }
        
    if ( 0.12 <= data){
        float range = 26.663 * pow((data*3.3),-1.25);
        lcd.locate(0,1);
        lcd.printf("RANGE %4.1f[cm]",range);
    }else{
        lcd.locate(0,1);
        lcd.printf("RANGE OVER!     ");
    }
}

void wave(){
    float a;

    if ( freq != 0 ){
        a =0.5*sin(2.0 * 3.1415 * freq * t )+0.5;
        out = a;
    }
    if ( t > 1.0 ) t = 0.0 ;
    t=t+0.00005;
}
       
int main() {    
    input.attach(&run,0.5);   
    output.attach_us(&wave,50);

    while(1){
   
    }
}
