#include "mbed.h"
#include "EthernetInterface.h"
#include "TextLCD.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);
DigitalIn sw(p21);
AnalogOut  out(p18);
AnalogIn in(p20);

// DES_ADDRESS(Static IP)
const char* DES_ADDRESS = "192.168.0.21";
//const char* DES_ADDRESS = "192.168.0.26";

const int PORT = 50505;
const int DSIZE = 1024;

UDPSocket server;
Endpoint client;
unsigned short rtmp,wtmp;
unsigned char rbuf[DSIZE], wbuf[DSIZE];

void read(void) {
    int i;
    for ( i = 0 ; i < DSIZE ; i=i+2 ){
        rtmp = in.read_u16();
        rbuf[i] = (unsigned char)(rtmp & 0x00FF);
        rbuf[i+1] = (unsigned char)((rtmp>>8)&0x00FF) ;          
        wait(0.0001);  
    }    
    server.sendTo(client, (char*)rbuf, sizeof(rbuf));     
}       

void write(void) {
    int i;

    server.receiveFrom(client, (char*)wbuf, sizeof(wbuf));
    for ( i = 0 ; i < DSIZE ; i=i+2 ){
        wtmp = (unsigned char)(wbuf[i+1]);
        wtmp <<=8;
        wtmp |= (unsigned char)wbuf[i] ;
        out.write_u16(wtmp) ;
        wait(0.0001);
    }            
}    
  
 
int main (void) {
    EthernetInterface eth;

    eth.init("192.168.0.26","255.255.255.0","192.168.0.1"); 
    //eth.init("192.168.0.21","255.255.255.0","192.168.0.1"); 

    eth.connect();
    lcd.printf("%s", eth.getIPAddress());
    
    server.bind( PORT );
    server.set_blocking(false) ;
    client.set_address(DES_ADDRESS, PORT);

    while(1) {
        if ( sw == 0 ){
            lcd.locate(0,1);
            lcd.printf("Listen...");    
                        
            write();
        }else{
            read();
            lcd.locate(0,1);
            lcd.printf("Talk...  ");
        }
    }    
}