#include "mbed.h"

#define INIT 7.0
#define NOISE 3.0
#define DELAY 10.0

Ticker flipper;

DigitalOut led1(LED1); 
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalIn msensor(p20);
 
void flip() {
    led1 = !led1;
}

int main() {
    led2 = 0;
    led3 = 0;
    
    flipper.attach(&flip, 0.3); 
    wait( INIT );
    flipper.detach();
    led1=0;
    
    while(1) {
        led2 = msensor;
        if ( led2 == 1 ){
            wait( NOISE );
            led2 = msensor;

            while ( led2 == 1 ){        
                led3 = 1;        
                wait( DELAY ) ;
                led2 = msensor;
            }
            led3 = 0;
        }
    }
}