#ifndef MBED_MYGPS_H
#define MBED_MYGPS_H

#include "mbed.h"

class MyGPS {
    
public :   
    MyGPS(PinName tx,PinName rx);
    
    
    float getLongitude();
    float getLatitude();
    char  getNS();
    char  getEW();
    int   getStatus() ;
    int   sample();
    time_t getTime();
    char* getNMEA();
    void setUpdateTime(int);
    int getUpdateTime();   
    void setTime();
       
private:
    float longitude ;
    float latitude ;    
    int status ;
    Serial _gps;
    char msg[256] ;
    char ns, ew;
    int timeLocMode ; 
    int updateTime;
     
    float trunc(float);
    void setLongitude(float);
    void setLatitude(float);
    void setStatus(int);
    void setNS(char);
    void setEW(char);
    int getTimeLocMode() ;
    void setTimeLocMode(int) ;
};

#endif