#include "MyGPS.h"

MyGPS::MyGPS(PinName tx, PinName rx) : _gps(tx,rx)
{
    _gps.baud(4800) ;
    setTimeLocMode(1); // UTC->JST Change TimeLocationMode 
    setLongitude(0.0) ;
    setLatitude(0.0) ;
    setStatus(0) ;
    setNS('-');
    setEW('-');
    setUpdateTime(10);
}

float MyGPS::getLongitude()
{
    return longitude;
}

float MyGPS::getLatitude()
{
    return latitude;
}

void MyGPS::setLatitude(float lat)
{
    float deg, min;
    
    if ( lat != 0.0 ){
        deg = trunc(lat /100.0) ;
        min = lat - ( deg * 100.0);
        latitude = (deg + min / 60.0);
    }else{
        latitude = 0.0;
    }    
}

void MyGPS::setLongitude(float lon)
{
    float deg, min;

    if ( lon != 0.0 ){
        deg = trunc(lon/100.0);
        min = lon - ( deg * 100.0) ;
        longitude = (deg + min / 60.0);
    }else{
        longitude = 0.0 ;
    }
}

void MyGPS::setNS(char lns)
{
    if(lns == 'N' || lns =='S')
        ns = lns;
    else
        ns = '-' ;
}
char MyGPS::getNS()
{
    return ns;
}
void MyGPS::setEW(char lew)
{
    if (lew == 'E' || lew == 'W' )
        ew = lew ;
    else
        ew = '-' ;
}
char MyGPS::getEW()
{
    return ew;
}

int MyGPS::getStatus()
{
    return status;
}    

char *MyGPS::getNMEA()
{
    return msg;
}    
void MyGPS::setStatus(int stat)
{
    status = stat;
}

void MyGPS::setTime()
{
    struct tm s_time;
    int i ;
    float lat,lon,ltime;
    char lns,lew;
            
    while(1){
        if (_gps.readable()) {
            //_gps.getc(); // $ cut
            for ( i = 0 ; (msg[i]=_gps.getc())!='\r' ; i++);
            _gps.getc();
            msg[i] ='\0' ;
        }
        printf("%s \r\n",msg); // Debug 
        if(strstr(msg,"GPRMC") != NULL ){
            char statc;
            float d1,d2;
            int date;
            sscanf(msg, "$GPRMC,%f,%c,%f,%c,%f,%c,%f,%f,%d",&ltime,&statc,&lat,&lns,&lon,&lew,&d1,&d2,&date);
//ltime=161229.00; statc='A' ; date=120511; lat=3612.2475;lon=12158.34;lew='W';lns='N';
            //printf("GPRMC=>[%c] Date[%d] Time[%f]\r\n",statc); // Debug  
            
            if(statc == 'A'){
                s_time.tm_mday = (int)(date / 10000 );
                s_time.tm_mon = (int)((date - (s_time.tm_mday) * 10000) /100 ) - 1 ;
                s_time.tm_year = date%100+100;
                
                s_time.tm_hour = (int)((int)ltime / 10000 );
                s_time.tm_min  = (int)(((int)ltime - (s_time.tm_hour * 10000 )) / 100 ) ;
                s_time.tm_sec  =  (int)ltime%100 ;
                set_time(mktime(&s_time)) ;
                setStatus(1);
                break;
            }
        }
    }                    
}

time_t MyGPS::getTime()
{
     if( getTimeLocMode() == 0 )
        return time(NULL); // UTC
     else if ( getTimeLocMode() == 1 )
        return ( time(NULL) + 32400 ) ; // JST Add 9Hour
     else
        return time(NULL) ;
}

int MyGPS::getTimeLocMode()
{
    return timeLocMode;
}

void MyGPS::setTimeLocMode(int tlm)
{
    timeLocMode = tlm ;
}
void MyGPS::setUpdateTime(int update)
{
    updateTime = update;
}
int MyGPS::getUpdateTime()
{
    return updateTime;
}        
float MyGPS::trunc(float v)
{
    if ( v < 0.0 ){
        v *= -1.0;
        v = floor(v);
        v *= -1.0;
    }else{
        v = floor(v);
    }
    return v;    
}

int MyGPS::sample(){
    int i ;
    float lat,lon,ltime;
    char lns,lew;
          
    while(1){
        if (_gps.readable()) {
            //_gps.getc(); // $ cut
            for ( i = 0 ; (msg[i]=_gps.getc())!='\r' ; i++);
            _gps.getc();
            msg[i] ='\0' ;
        }
        printf("%s \r\n",msg); // Debug 
        if(strstr(msg,"GPRMC") != NULL ){
            char statc;

            sscanf(msg, "$GPRMC,%f,%c,%f,%c,%f,%c",&ltime,&statc,&lat,&lns,&lon,&lew);
//ltime=161229.00; statc='A' ; date=120511; lat=3612.2475;lon=12158.34;lew='W';lns='N';
            //printf("GPRMC=>[%c]\r\n",statc); // Debug  
            
            if(statc == 'A'){

                setLatitude(lat) ;
                setNS(lns);                
                setLongitude(lon) ;     
                setEW(lew);
          
                setStatus(1);
                return 0;
            }else{
                setStatus(0) ;
                return -1;
            }
        }                           
    }
}