#include "mbed.h"
#include "MyGPS.h"
#include "TextLCD.h"
#include "string.h"
#include "SDFileSystem.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30) ;
MyGPS gps(p9, p10);  // tx, rx
SDFileSystem sd(p5, p6, p7, p8, "sd1") ;
DigitalOut led1(LED1);

void writeLocation(void) ;
void ledFlash(void);

int main() {
    time_t oldTime = 0 ,nowTime = 0;
    char strTimeMsg[16];
    time_t t_time;
    
    gps.setUpdateTime(10);
    lcd.cls();
       
    lcd.locate(0,0); 
    lcd.printf("Please Wait....");
    gps.setTime();

    t_time = gps.getTime() ;
    
    strftime(strTimeMsg,16,"%m/%d %H:%M:%S",localtime(&t_time));
    lcd.locate(0,0); 
    lcd.printf("%s",strTimeMsg);
    wait(2.0);
       
    while (1) {
        gps.sample();
        lcd.cls();
        if ( gps.getStatus() ==1 ){
            lcd.locate(0,0);
            lcd.printf("lat:%10.6f %c",gps.getLatitude(),gps.getNS());
            lcd.locate(0,1);
            lcd.printf("lon:%10.6f %c",gps.getLongitude(),gps.getEW());  
                     
            nowTime = gps.getTime();        
            if( (oldTime + gps.getUpdateTime()) < nowTime ){
                writeLocation();
                oldTime = nowTime;
            }        
        }else{
            lcd.locate(0,1); 
            lcd.printf("data not valid!");
        }
    }   
}

void writeLocation(void)
{
    FILE *fp,*fp1;
    char strTimeMsg[32];
    time_t t_time;
    
    if ( gps.getStatus() == 1 ){
        if ( (fp = fopen("/sd1/gps.txt","a"))== NULL ) {
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("gps Open Failed.") ;
            wait(0.5);
        }else{
            t_time = gps.getTime() ;
            strftime(strTimeMsg,32,"%Y/%m/%d %H:%M:%S ",localtime(&t_time));
            fprintf(fp,"%s",strTimeMsg);
            fprintf(fp,"Latitude:%f Longitude:%f\n",gps.getLatitude(),gps.getLongitude());    
         
            ledFlash(); 
            fclose(fp);             
        }
       
        if ( (fp1 = fopen("/sd1/NMEA.nme","a"))== NULL ) {
            lcd.cls();
            lcd.locate(0,1);
            lcd.printf("NMEA Open Failed.") ;
            wait(0.5);
        }else{    
            fprintf(fp1,"%s\n",gps.getNMEA());
            fclose(fp1); 
        }    
    }
}

void ledFlash(void)
{
    led1=1;
    wait(0.3);
    led1=0; 
}