#include "mbed.h"
#include "TextLCD.h"


TextLCD lcd(p24, p26, p27, p28, p29, p30);
/*
AnalogIn in(p20);
PwmOut out(p21);
DigitalOut myled(LED1);

Ticker input;
Ticker output;
double flash;
float data,now,old=0.0;

void run(){
    old = now;
    now = in;
    data = ( now + old ) / 2.0;
}

void update(){
    float range;
    lcd.locate(0,0);
    if ( data < 0.208 ){ // x <= 40cm 
        flash = 0.0 ;
        lcd.printf("  Safty  ");
    }else if ( data < 0.272){  // 30cm <= x < 40cm
        flash = 0.8 ;
        lcd.printf("Caution! ");
    }else if ( data < 0.389){  // 20cm <= x 30cm   
        flash = 0.4 ;
        lcd.printf("Caution! ");               
    }else if ( data < 0.724){  // 10cm <= x < 20cm 
        flash = 0.1 ;
        lcd.printf(" Danger! ");
    }else{                      // x < 10cm
        flash = 0.05 ; 
        lcd.printf(" Danger! ");
    }
    
    
    range = 25.33 * pow((data*3.3),-1.21);
 
    lcd.locate(0,1);
    if ( data > 0.12)
        lcd.printf("RANGE %5.2f[cm]",range);
    else
        lcd.printf("RANGE OVER     ");        
}
  
int main() {    

    input.attach(&run,0.2);   
    output.attach(&update,0.5);
    out.period(0.001);
    while(1){
        out.write(0.0);
        if ( flash != 0.0 ){
            myled = !myled ;
            wait(flash) ;
            out.write(0.5);
            wait(flash);
        }else{
            myled = 0;
            out.write(0.0);
        }    
    }
}


*/




AnalogOut out(p18);
AnalogIn in(p20);
Ticker input;
Ticker output;
int freq;
double t = 0.0 ;
float d11 = 0.0, d12 =0.0 ;
float data;

void run(){
    data = in;
}

void wave(){
        if ( data < 0.1212){
            freq = 0;
        }else if ( data < 0.181){
            freq = 2093;
        }else if ( data < 0.242){
            freq = 1976;
        }else if ( data < 0.333){
            freq = 1760;
        }else if ( data < 0.394){
            freq = 1568;
        }else if ( data < 0.485){  
            freq = 1397; 
        }else if ( data < 0.697 ){
            freq = 1319; 
        }else if ( data < 0.85){    
            freq = 1175;
        }else{
            freq = 1046; 
        }
        float a;

        if ( freq != 0 ){
            a =0.5*sin(2.0 * 3.1415 * freq * t )+0.5;
            out = a;
        }
        if ( t > 1.0 ) t = 0.0 ;
        t=t+0.00005;
}
  
int main() {    

    input.attach(&run,0.5);   
    output.attach_us(&wave,50);

    while(1){

        lcd.locate(0,0);
        lcd.printf("%5.3f %4d",data,freq);
        if ( 0.12 <= data){
            float range = 25.33 * pow((data*3.3),-1.21);
            lcd.locate(0,1);
            lcd.printf("RANGE %5.2f[cm]",range);    
        }else{
            lcd.locate(0,1);
            lcd.printf("RANGE -----[cm]");        
        }                
        lcd.locate(12,0);
        lcd.putc('[');
        if ( freq == 0){
            lcd.putc('-');
            lcd.putc('-');
        }else if ( freq == 2093){
            lcd.putc(0xC4);
            lcd.putc(0xDE);    
        }else if (freq == 1976){
            lcd.putc(0xBC);
            lcd.putc(0xFE);
        }else if ( freq == 1760){
            lcd.putc(0xD7);
            lcd.putc(0xFE);
        }else if ( freq == 1568){
            lcd.putc(0xBF);
            lcd.putc(0xFE);
        }else if ( freq == 1397){  
            lcd.putc(0xCC);
            lcd.putc(0xA7);                 
        }else if ( freq == 1319 ){
            lcd.putc(0xD0);
            lcd.putc(0xFE);
        }else if ( freq == 1175){    
            lcd.putc(0xDA);
            lcd.putc(0xFE);
        }else{
            lcd.putc(0xC4);
            lcd.putc(0xDE);
        }
        lcd.putc(']');
    }
}
