#include "mbed.h"
#include "CameraC1098.h"
#include "TextLCD.h"

static char buf[256+1];

TextLCD lcd(p24, p26, p27, p28, p29, p30);
CameraC1098 camera(p9, p10);
Serial pc(p13,p14);

/**
 * A callback function for jpeg images.
 * You can block this function until saving the image datas.
 *
 * @param buf A pointer to the image buffer.
 * @param siz A size of the image buffer.
 */
void jpeg_callback(char *buf, size_t siz) {
    for (int i = 0; i < (int)siz; i++) {
        pc.putc(buf[i]);
    }
}

/**
 * Synchronizing.
 */
void sync(void) {
    CameraC1098::ErrorNumber err = CameraC1098::NoError;

    err = camera.sync();
    lcd.locate(0,0);
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::sync\r\n");
        lcd.printf("C1098:Sync [OK] ");
        
    } else {
        printf("[FAIL] : CameraC1098::sync (Error=%02X)\r\n", (int)err);
        lcd.printf("C1098:Sync[FAIL]");
    }
}


/**
 * A test function for jpeg snapshot picture.
 */
void test_jpeg_snapshot_picture() {
    CameraC1098::ErrorNumber err = CameraC1098::NoError; 
    
    err = camera.getJpegSnapshotPicture(jpeg_callback);
    lcd.locate(0,1);
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::getJpegSnapshotPicture\r\n");
        lcd.printf("getJpgPict [OK] ");
    } else {
        printf("[FAIL] : CameraC1098::getJpegSnapshotPicture (Error=%02X)\r\n", (int)err);
        lcd.printf("getJpgPict[FAIL]");
    }
}

/**
 * A entry point.
 */
int main() {
    printf("\r\n");
    printf("==========\r\n"); 
    printf("CameraC1098\r\n");
    printf("==========\r\n");
    CameraC1098::ErrorNumber err = CameraC1098::NoError;
    err = camera.init(CameraC1098::Baud460800, CameraC1098::JpegResolution320x240);  
    camera.setmbedBaud( CameraC1098::Baud460800 );
    pc.baud(460800); 
    
    lcd.cls();
    lcd.locate(0,0);
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::init\r\n");
        lcd.printf("C1098:init [OK] ");
    } else {
        printf("[FAIL] : CameraC1098::init (Error=%02X)\r\n", (int)err);
        lcd.printf("C1098:init[FAIL]");
    }
    sync();

    while(1){    
        test_jpeg_snapshot_picture(); 
    }
    return 0;
}
