#include "mbed.h"
#include "CameraC1098.h"
#include "SDHCFileSystem.h"
#include "TextLCD.h"
 
/*
 * Definitions.
 */
#define USE_SD_CARD 1

/*
 * Variables.
 */
static const int CAPTURE_FRAMES = 1;
static char buf[256+1];
static FILE *fp_jpeg;

/*
 * Modules.
 */
#if USE_SD_CARD
SDFileSystem sd(p5, p6, p7, p8, "fs");
#else
LocalFileSystem fs("fs");
#endif

TextLCD lcd(p24, p26, p27, p28, p29, p30);
CameraC1098 camera(p9, p10);
 

/**
 * A callback function for jpeg images.
 * You can block this function until saving the image datas.
 *
 * @param buf A pointer to the image buffer.
 * @param siz A size of the image buffer.
 */
void jpeg_callback(char *buf, size_t siz) {
    for (int i = 0; i < (int)siz; i++) {
        fprintf(fp_jpeg, "%c", buf[i]);
    }
}

/**
 * Synchronizing.
 */
void sync(void) {
    CameraC1098::ErrorNumber err = CameraC1098::NoError;

    err = camera.sync();
    lcd.locate(0,0);
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::sync\r\n");
        lcd.printf("C1098:Sync [OK] ");
        
    } else {
        printf("[FAIL] : CameraC1098::sync (Error=%02X)\r\n", (int)err);
        lcd.printf("C1098:Sync[FAIL]");
    }
}


/**
 * A test function for jpeg snapshot picture.
 */
void test_jpeg_snapshot_picture(int j) {
    CameraC1098::ErrorNumber err = CameraC1098::NoError; 
    for (int i = 0; i < CAPTURE_FRAMES; i++) {
        char fname[64];
        snprintf(fname, sizeof(fname), "/fs/jpss%02d-%02d.jpg",i, j);
        fp_jpeg = fopen(fname, "w");
        if ( fp_jpeg == NULL ){
            lcd.locate(0,1);
            lcd.printf("File Open Fail ");
            exit(1);
        }

        err = camera.getJpegSnapshotPicture(jpeg_callback);
        lcd.locate(0,1);
        if (CameraC1098::NoError == err) {
            printf("[ OK ] : CameraC1098::getJpegSnapshotPicture\r\n");
            lcd.printf("getJpgPict [OK] ");
        } else {
            printf("[FAIL] : CameraC1098::getJpegSnapshotPicture (Error=%02X)\r\n", (int)err);
            lcd.printf("getJpgPict[FAIL]");
        }
        fclose(fp_jpeg);
    }
}

/**
 * A entry point.
 */
int main() {
    printf("\r\n");
    printf("==========\r\n"); 
    printf("CameraC1098\r\n");
    printf("==========\r\n");
    CameraC1098::ErrorNumber err = CameraC1098::NoError;
    err = camera.init(CameraC1098::Baud460800, CameraC1098::JpegResolution80x64);    
     
    lcd.cls();
    lcd.locate(0,0);
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::init\r\n");
        lcd.printf("C1098:init [OK] ");
    } else {
        printf("[FAIL] : CameraC1098::init (Error=%02X)\r\n", (int)err);
        lcd.printf("C1098:init[FAIL]");
    }
    sync();
    
    test_jpeg_snapshot_picture(1); 
    err = camera.init(CameraC1098::Baud460800, CameraC1098::JpegResolution160x128);   
    test_jpeg_snapshot_picture(2);        
    err = camera.init(CameraC1098::Baud460800, CameraC1098::JpegResolution320x240);   
    test_jpeg_snapshot_picture(3);    
    err = camera.init(CameraC1098::Baud460800, CameraC1098::JpegResolution640x480);   
    test_jpeg_snapshot_picture(4);         
    
    return 0;
}
