/**
 * Test program.
 *
 * CameraC328Library
 * Copyright (C) 2010 Shinichiro Nakamura (CuBeatSystems)
 * http://shinta.main.jp/
 *
 * CameraC1098-SS Library
 * Copyright (C) 2012 Tadao Iida
 */

/*
 * Include files.
 */

#include "mbed.h"
#include "CameraC1098.h"
#include "SDFileSystem.h"

/*
 * Definitions.
 */
#define USE_JPEG_HIGH_RESOLUTION  1
#define USE_SD_CARD 1

/*
 * Variables.
 */
static const int CAPTURE_FRAMES = 3;
static char buf[256+1];
static FILE *fp_jpeg;

/*
 * Modules.
 */
#if USE_SD_CARD
SDFileSystem sd(p5, p6, p7, p8, "fs");
#else
LocalFileSystem fs("fs");
#endif

CameraC1098 camera(p9, p10);
 

/**
 * A callback function for jpeg images.
 * You can block this function until saving the image datas.
 *
 * @param buf A pointer to the image buffer.
 * @param siz A size of the image buffer.
 */
void jpeg_callback(char *buf, size_t siz) {
    for (int i = 0; i < (int)siz; i++) {
        fprintf(fp_jpeg, "%c", buf[i]);
    }
}

/**
 * Synchronizing.
 */
void sync(void) {
    CameraC1098::ErrorNumber err = CameraC1098::NoError;

    err = camera.sync();
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::sync\r\n");
    } else {
        printf("[FAIL] : CameraC1098::sync (Error=%02X)\r\n", (int)err);
    }
}


/**
 * A test function for jpeg snapshot picture.
 */
void test_jpeg_snapshot_picture(void) {
    CameraC1098::ErrorNumber err = CameraC1098::NoError; 
    for (int i = 0; i < CAPTURE_FRAMES; i++) {
        char fname[64];
        snprintf(fname, sizeof(fname), "/fs/jpss%04d.jpg", i);
        fp_jpeg = fopen(fname, "w");

        err = camera.getJpegSnapshotPicture(jpeg_callback);
        
        if (CameraC1098::NoError == err) {
            printf("[ OK ] : CameraC1098::getJpegSnapshotPicture\r\n");
        } else {
            printf("[FAIL] : CameraC1098::getJpegSnapshotPicture (Error=%02X)\r\n", (int)err);
        }
        fclose(fp_jpeg);
    }
}

/**
 * A entry point.
 */
int main() {
    printf("\r\n");
    printf("==========\r\n"); 
    printf("CameraC1098\r\n");
    printf("==========\r\n");
    CameraC1098::ErrorNumber err = CameraC1098::NoError;
    err = camera.init(CameraC1098::Baud460800, CameraC1098::JpegResolution320x240);
  
    if (CameraC1098::NoError == err) {
        printf("[ OK ] : CameraC1098::init\r\n");
    } else {
        printf("[FAIL] : CameraC1098::init (Error=%02X)\r\n", (int)err);
    }
    //
    sync();
    test_jpeg_snapshot_picture();
    
    return 0;
}
